%  Td_Argo.m
%  
%  read Argo mat file data from the N Pacific and then
%  compute the OHC and the depth-averaged
%  temperatures, T100 and Td.
%
%  requires the CSIRO equation of state routines sw_dens.m and sw_smow.m 
%  requires the Argo data file to be in this directory
%
%  by Jim Price, November 2008, August, 2009 
%  jprice@whoi.edu

clear all
close all
format compact

set(0,'DefaultAxesFontSize',13)
set(0,'DefaultTextFontSize',13)
set(0,'DefaultAxesLineWidth', 1.3)
set(0,'DefaultLineLineWidth', 1.0)
format compact

%  load the Argo data, thanks to JJ Park

load argo2007_jim;

nop = 0
if nop == 1
figure(1)
plot(dday, lon)

figure(2)
plot(dday, lat)

min(lat)
max(lat)
min(lon)
max(lon)

figure(3)
plot(lon, lat)
end

%  define the geographic region to analyze
lat1 = 18.
lat2 = 28.
lon1 = 123.
lon2 = 133.

np = length(lat)

for j=1:np
xday(j) = max(juld) - juld(j);
end

np = length(lat)
k = 0

for j=1:np  
    if lat(j)>=lat1 & lat(j)<=lat2 & lon(j)>=lon1 & lon(j)<=lon2
         if abs(xday(j)-210) <= 60
            k = k + 1;      %  come here when a profile fits the window
            ind(k) = j;
         end
    end
end

%  the depth resolution is set here......
dz = 1.0
zi = 0:dz:190;    %  this deep limit is arbitrary
zi(1) = 0.001;

nk = length(ind)   %  the number of profiles

figure(9)
clf reset
set(gcf,'paperposition', [0.25 0.25 5.5 4.1])

m = 0
for j=1:nk     %  now analyze the selected profiles
    
    p = Prof(ind(j)).P;
    t = Prof(ind(j)).T;
    s = Prof(ind(j)).S;
    
 %  use the shallowest measured depth is the  surface value 
    p8 = [0 p];
    t8 = [t(1) t];
    s8 = [s(1) s];
    
    p1 = p8(p8<=250);
    t1 = t8(p8<=250);
    s1 = s8(p8<=250);

 %  look for big errors in temp (should do something for s, too)
    dp = diff(p1);
    dt = -diff(t1)./dp;
    if min(dp) >= 0.01 & min(dt) >= -0.01
        
    m = m + 1
    ti = interp1(p1,t1,zi,'linear');
    si = interp1(p1,s1,zi,'linear');
   
    clear p t s
    p = zi;     %  this is interpolated (extrapolated) data
    t = ti;
    s = si;
    
    figure(9)
    hold on
    if mod(m,3) == 1    %  plot every 3rd profile
    
    subplot(1,2,1)
    hold on
    plot(t,-zi, 'linewidth', 0.7)
    
    subplot(1,2,2)
    hold on
    plot(s, -zi, 'linewidth', 0.7)
    end
    
%  store the interpolated data in arrays
    ta(:,m) = t;
    pa(:,m) = p;
    sa(:,m) = s;
    end      %  if on data quality 
    
end   %  loop on j, the profile number

%  some statistics on temperature  - why not salinity?
mp = mean(pa');
mt = mean(ta');
st = std(ta');

subplot(1,2,1)
hold on
plot(mt, -mp, 'k', 'linewidth', 2.5)

hold on
plot(mt+st, -mp, 'k--', 'linewidth', 2)
plot(mt-st, -mp, 'k--', 'linewidth', 2)
grid

xlabel('temperature, C')
ylabel('depth, m')
axis([16 32 -200 0])
title('Argo T(z), S(z) ITOP region, summer 2007')

subplot(1,2,2)
xlabel('salinity')
ylabel('depth, m')
grid
axis([34 35.5 -200 0])

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%  calculate the OHC and the mixing depth, d

nprof = m
for m=1:nprof     %  loop on the number of profiles = m
    
    istab = zeros(200,1);
    
    b(m) = 300.;   %  in general, there should be a bottom depth
    z9 = -zi;      %  z9 is positive up
    t9 = ta(:,m);
    s9 = sa(:,m);
           
%  compute  OHC

Cp = 4.1e3;
r0 = 1030.;
hpsum = 0.;

n180 = floor(180/abs(dz));
nb = floor(b(m)/abs(dz));

for k=2:min(n180, nb) 
    if t9(k) >= 26.0
        dz = z9(k-1) - z9(k);
        tw = (t9(k-1) +  t9(k))/2.;
        hpsum = hpsum + abs(dz)*(tw - 26.0);  
    end   
end
OHC(m) = r0*Cp*hpsum;

%  now compute the variable depth form of cooling

%  compute the density;  this requires sw_dens.m and sw_smow.m 
dens = sw_dens0(s9,t9) - 1000.;

g = 9.8;
Cp = 4.1e3;
r0 = 1030.;
lat = 22.;
f = 2.*7.292e-5*sin(lat*pi/180);  % not used
RH = 35.e3;        % radius to max winds, m
UH = 5.5;          % hurricane translation speed, m/sec
Simcon = 1.2;
TimeH = 4*RH/UH;   % residence time
tau = 5.5;          % hurricane (max) stress, Pa
Rvc = 0.6;            %  crtical Richardson number
U = Simcon*tau*TimeH/r0;  %  the wind-driven current speed

%  note that d9 is the density and z9 is the depth, positive up

dsum = 0.;   % depth-integrated density
for j=1:min(n180, nb)    
    
    istab(j) = 0;            %  a counter, = 0 if below the depth h
    dsum = dsum + dz*dens(j);  %  the depth-intgrated density
    dens5 = dens(j)*abs(z9(j));   %  the density at depth j  
    stab(j) = g*(dens5 - dsum); % this is the numerator of Eqn (3)
    Rv = (stab(j)*(z9(j)^2))/(r0*U^2);  % the Ri number at the depth j*dz
    
    if Rv <= Rvc;      %  check to see whether Rv is less than Rvc Rvc 
        istab(j) = 1;  %  if yes, then still above the mixing depth
    end
    
end    %  loop on j

d(m) = sum(istab)*abs(dz);    %  the mixing depth, d, for this profile,
                              %          or could be the bottom

%  compue the depth-averaged temperatures 
T1001 = 0.;
Td1 = 0.;
for j=1:sum(istab)   
    Td1 = Td1 + t9(j);     %  compute Th
end
Td(m) = Td1/sum(istab);

n100 = floor(100/dz);
for j=1:min(n100, nb)                % compute T100 
    T1001 = T1001 + t9(j);
end
T100(m) = T1001/min(n100, nb);

end    %  loop on m,  the profile number of the profiles being analyzed


%  plot Th and T100
figure(50)
clf reset
plot(Td, T100, '*')
xlabel('Td, C')
ylabel('T100, C')
axis([20 30 20 30])
grid on

%  plot OHC and T100
figure(51)
clf reset
plot(OHC/1.e7, T100, '*')
xlabel('OHC, kJ cm^{-2}')
ylabel('T100, C')
axis([-75 200 20 30])
grid on








    
    






