
%update dpddic, dpdalk, dpdsst, dpdsss
par1type =    1; % The first parameter supplied is of type "1", which is "alkalinity"
par1     = 2400; % value of the first parameter
par2type =    2; % The first parameter supplied is of type "1", which is "DIC"
par2     = [2100:5:2300]; % value of the second parameter, which is a long vector of different DIC's!
sal      =   35; % Salinity of the sample
tempin   =   10; % Temperature at input conditions
presin   =    0; % Pressure    at input conditions
tempout  =    0; % Temperature at output conditions - doesn't matter in this example
presout  =    0; % Pressure    at output conditions - doesn't matter in this example
sil      =   50; % Concentration of silicate  in the sample (in umol/kg)
po4      =    2; % Concentration of phosphate in the sample (in umol/kg)
pHscale  =    1; % pH scale at which the input pH is reported ("1" means "Total Scale")  - doesn't matter in this example
k1k2c    =    14; % Choice of H2CO3 and HCO3- dissociation constants K1 and K2 
kso4c    =    1; % Choice of HSO4- dissociation constants KSO4 ("1" means "Dickson")
%A=CO2SYS(par1,par2,par1type,par2type,sal,tempin,tempout,presin,presout,sil,po4,pHscale,k1k2c,kso4c);
tic;
num=0;
[jm,im]=size(dpd_index);
for j0=1:jm
    for i0=1:im
        if dpd_index(j0,i0)==1;
           num=num+1;
           if mod(num,100)==0; toc; disp([num2str(j0),'/',num2str(jm)]); tic;end
           dic0=squeeze(mdic(j0,i0,:));
           alk0=squeeze(malk(j0,i0,:));
           sst0=squeeze(msst(j0,i0,:));
           sss0=squeeze(msss(j0,i0,:));
           sio40=squeeze(msio4(j0,i0,:));
           po40=squeeze(mpo4(j0,i0,:));
           std_cri=60;
           dic_range=std(dic0)*2; alk_range=std(alk0)*2;
           if dic_range>=std_cri; dic_range=std_cri; end
           if alk_range>=std_cri; alk_range=std_cri; end

           dic_in=linspace(mean(dic0)-dic_range,mean(dic0)+dic_range,20)';
           alk_in=linspace(mean(alk0)-alk_range,mean(alk0)+alk_range,20)';
           sst_in=linspace(min(sst0),max(sst0),20)';
           sss_min=min(sss0); if sss_min<0; sss_min=0; end
           sss_in=linspace(sss_min,max(sss0),20)';
    res=CO2SYS(nanmean(alk0),dic_in,1,2,nanmean(sss0),nanmean(sst0),tempout,presin,presout,nanmean(sio40),nanmean(po40),pHscale,k1k2c,kso4c);
           [r,dpddic_regress,o] = regression(dic_in',res(:,4)');
           dpddic(j0,i0,:)=dpddic_regress;
          res=CO2SYS(alk_in,nanmean(dic0),1,2,nanmean(sss0),nanmean(sst0),tempout,presin,presout,nanmean(sio40),nanmean(po40),pHscale,k1k2c,kso4c);
           [r,dpdalk_regress,o] = regression(alk_in',res(:,4)');
           dpdalk(j0,i0,:)=dpdalk_regress;
           res=CO2SYS(nanmean(alk0),nanmean(dic0),1,2,nanmean(sss0),sst_in,tempout,presin,presout,nanmean(sio40),nanmean(po40),pHscale,k1k2c,kso4c);
           [r,dpdsst_regress,o] = regression(sst_in',res(:,4)');
           dpdsst(j0,i0,:)=dpdsst_regress;
           res=CO2SYS(nanmean(alk0),nanmean(dic0),1,2,sss_in,nanmean(sst0),tempout,presin,presout,nanmean(sio40),nanmean(po40),pHscale,k1k2c,kso4c);
           [r,dpdsss_regress,o] = regression(sss_in',res(:,4)');
           dpdsss(j0,i0,:)=dpdsss_regress;
       end
    end
end
