! This model code was generated by the Code Generation Tool CGT
! www.ergom.net
!
! Model Version: 2.00a1 experimental POCN, POCP, code generation date: 2019-Apr-11 10:14 
!----------------------------------------------------------------
! <CONTACT EMAIL="thomas.neumann@io-warnemuende.de"> T. Neumann
! </CONTACT>
! <CONTACT EMAIL="hagen.radtke@io-warnemuende.de"> H. Radtke
! </CONTACT>
! <CONTACT EMAIL="thomas.neumann@io-warnemuende.de, hagen.radtke@io-warnemuende.de"> Thomas Neumann, Hagen Radtke, Martin Schmidt 
! </CONTACT>
!
! <REVIEWER EMAIL="none yet">
! </REVIEWER>
!<OVERVIEW>
! Ecological Regional Ocean Model - ERGOM
!</OVERVIEW>
!
!Ecological ReGional Ocean Model
!       ERGOM is developed for marine ecosystems in which bentho-pelagic
!       fluxes and changing redox conditions are important.It describes
!       the nitrogen and phosphorus cycle and partly the sulfor cycle.
!       Included is a carbon module and the oxygen dynamics.
!</DESCRIPTION>
!
! <INFO>
! http://www.ergom.net
! <REFERENCE>
! T. Neumann, 2000: Towards a 3D-ecosystem model of the Baltic Sea
! Journal of Marine Systems, 25, 405-419
! </REFERENCE>
! <REFERENCE>
! T. Neumann, W. Fennel, Ch. Kremp 2002: Experimental Simulations with
! an Ecosystem Model of the Baltic Sea: A Nutrient Load Reduction Experiment,
! Global Biogeochemical Cycles 16, No 3, 7-1  7-19
! </REFERENCE>
! <REFERENCE>
! W. Fennel, Th. Neumann, 2004: Introduction to the Modelling of Marine Ecosystems,
! Elsevier Oceanography Series 72, Elsevier
! </REFERENCE>
! <REFERENCE>
! Radtke, H., T. Neumann, M. Voss, and W. Fennel (2012), Modeling pathways of
! riverine nitrogen and phosphorus in the Baltic Sea,
! J. Geophys. Res., 117, C09024, doi:10.1029/2012JC008119
! </REFERENCE>
! <REFERENCE>
! I. Kuznetsov, T. Neumann, Simulation of carbon dynamics in the Baltic Sea with a 3D model,
! Journal of Marine Systems, Available online 22 October 2012,
! ISSN 0924-7963, doi: 10.1016/j.jmarsys.2012.10.011.
! </REFERENCE>
! <DEVELOPER_NOTES>
! Ergom will be continuously developed.
! </DEVELOPER_NOTES>
! </INFO>
!
!----------------------------------------------------------------

#define salt4yellowSubs

module generic_ERGOM

  use coupler_types_mod,   only: coupler_2d_bc_type
  use field_manager_mod,   only: fm_string_len
  use fms_mod,             only: write_version_number, open_namelist_file, check_nml_error, close_file  
  use mpp_mod,             only: mpp_error, NOTE, WARNING, FATAL, stdout, stdlog
  use mpp_mod,             only: mpp_clock_id, mpp_clock_begin, mpp_clock_end, CLOCK_ROUTINE
  use time_manager_mod,    only: time_type, get_date, days_in_year, time_type_to_real
  use fm_util_mod,         only: fm_util_start_namelist, fm_util_end_namelist
  use diag_manager_mod,    only: register_diag_field, send_data

  use g_tracer_utils, only : g_tracer_type,g_tracer_start_param_list,g_tracer_end_param_list
  use g_tracer_utils, only : g_tracer_add,g_tracer_add_param, g_tracer_set_files
  use g_tracer_utils, only : g_tracer_set_values,g_tracer_get_pointer,g_tracer_get_common
  use g_tracer_utils, only : g_tracer_coupler_set,g_tracer_coupler_get
  use g_tracer_utils, only : g_tracer_send_diag, g_tracer_get_values
  use g_tracer_utils, only : g_diag_type, g_diag_field_add

  use data_override_mod, only: data_override

  implicit none ; private

  character(len=fm_string_len), parameter :: mod_name       = 'generic_ERGOM'
  character(len=fm_string_len), parameter :: package_name   = 'generic_ergom'

  character(len=128) :: version=&
         '$Id: generic_ERGOM.F90,v 2.00a1 experimental POCN, POCP 2019-Apr-11 10:14 $'
  character (len=128) :: tagname = &
         '$Name: IOW $'


  public do_generic_ERGOM
  public generic_ERGOM_register
  public generic_ERGOM_init
  public generic_ERGOM_update_from_coupler
  public generic_ERGOM_update_from_source
  public generic_ERGOM_update_from_bottom
  public generic_ERGOM_set_boundary_values
  public generic_ERGOM_register_diag
  public generic_ERGOM_end

  !
  !This type contains all the parameters and arrays used in this module.
  !
  !Note that there is no programatic reason for treating
  !the following as a type. These are the parameters used only in this module.
  !It suffices for varables to be a declared at the top of the module.
  !nnz: Find out about the timing overhead for using type%x rather than x

  !An auxiliary type for storing varible names
  type, public :: vardesc
     character(len=fm_string_len) :: name     ! variable name in a NetCDF file.
     character(len=fm_string_len) :: longname ! long name of that variable.
     character(len=1)  :: hor_grid            ! hor. grid:  u, v, h, q, or 1.
     character(len=1)  :: z_grid              ! vert. grid:  L, i, or 1.
     character(len=1)  :: t_grid              ! time description: s, a, m, or 1.
     character(len=fm_string_len) :: units    ! dimensions of the variable.
     character(len=1)  :: mem_size            ! size in memory: d or f.
  end type vardesc

  type generic_ERGOM_type

     real, ALLOCATABLE, dimension(:,:) :: &
          t_n2_t_n2_csurf               ! surface concentration of t_n2 [mol/m3]
     real, ALLOCATABLE, dimension(:,:) :: &
          t_o2_t_o2_csurf               ! surface concentration of t_o2 [mol/m3]
     real, ALLOCATABLE, dimension(:,:) :: &
          co2_t_dic_csurf               ! surface concentration of co2 [mol/m3]
     real, ALLOCATABLE, dimension(:,:) :: &
          t_n2_t_n2_with_atmos_tot_N_csurf               ! surface concentration of t_n2 [mol/m3]
     real, ALLOCATABLE, dimension(:,:) :: &
          t_n2_t_n2_with_atmos_ship_N_csurf               ! surface concentration of t_n2 [mol/m3]
     real, ALLOCATABLE, dimension(:,:) :: &
          t_n2_alpha, &                       ! surface solubility of t_n2    [mol/m3/Pa]
          t_n2_sc_no                          ! Schmidt number of t_n2        [1]
     real, ALLOCATABLE, dimension(:,:) :: &
          t_o2_alpha, &                       ! surface solubility of t_o2    [mol/m3/Pa]
          t_o2_sc_no                          ! Schmidt number of t_o2        [1]
     real, ALLOCATABLE, dimension(:,:) :: &
          co2_alpha, &                       ! surface solubility of co2    [mol/m3/Pa]
          co2_sc_no                          ! Schmidt number of co2        [1]


     real, ALLOCATABLE, dimension(:,:) :: &
          p_sed_resp_nh4  , &                      ! recycling of sedimentary detritus to ammonium using oxygen (respiration)
          saved_rate_p_sed_resp_nh4                ! for Runge-Kutta method
     real, ALLOCATABLE, dimension(:,:) :: &
          p_nh4_nitdenit_n2 , &                      ! coupled nitrification and denitrification after mineralization of detritus in oxic sediments
          saved_rate_p_nh4_nitdenit_n2               ! for Runge-Kutta method
     real, ALLOCATABLE, dimension(:,:) :: &
          p_sed_denit_nh4_noN2 , &                      ! recycling of sedimentary detritus to ammonium using nitrate (denitrification)
          saved_rate_p_sed_denit_nh4_noN2               ! for Runge-Kutta method
     real, ALLOCATABLE, dimension(:,:) :: &
          p_sed_denit_nh4_wiN2 , &                      ! recycling of sedimentary detritus to ammonium using nitrate (denitrification)
          saved_rate_p_sed_denit_nh4_wiN2               ! for Runge-Kutta method
     real, ALLOCATABLE, dimension(:,:) :: &
          p_sed_sulf_nh4  , &                      ! recycling of sedimentary detritus to ammonium using sulfate (sulfate reduction)
          saved_rate_p_sed_sulf_nh4                ! for Runge-Kutta method
     real, ALLOCATABLE, dimension(:,:) :: &
          p_sed_poc_resp  , &                      ! recycling of sedimentary poc to dic using oxygen (respiration)
          saved_rate_p_sed_poc_resp                ! for Runge-Kutta method
     real, ALLOCATABLE, dimension(:,:) :: &
          p_sed_poc_denit , &                      ! recycling of sedimentary poc to dic using nitrate (denitrification)
          saved_rate_p_sed_poc_denit               ! for Runge-Kutta method
     real, ALLOCATABLE, dimension(:,:) :: &
          p_sed_poc_sulf  , &                      ! recycling of sedimentary poc to dic using sulfate (sulfate reduction)
          saved_rate_p_sed_poc_sulf                ! for Runge-Kutta method
     real, ALLOCATABLE, dimension(:,:) :: &
          p_po4_retent_ips , &                      ! retention of phosphate in the sediment under oxic conditions
          saved_rate_p_po4_retent_ips               ! for Runge-Kutta method
     real, ALLOCATABLE, dimension(:,:) :: &
          p_ips_liber_po4 , &                      ! liberation of phosphate from the sediment under anoxic conditions
          saved_rate_p_ips_liber_po4               ! for Runge-Kutta method
     real, ALLOCATABLE, dimension(:,:) :: &
          p_det_sedi_sed  , &                      ! detritus sedimentation
          saved_rate_p_det_sedi_sed                ! for Runge-Kutta method
     real, ALLOCATABLE, dimension(:,:) :: &
          p_ipw_sedi_ips  , &                      ! sedimentation of iron PO4
          saved_rate_p_ipw_sedi_ips                ! for Runge-Kutta method
     real, ALLOCATABLE, dimension(:,:) :: &
          p_poc_sedi_sed  , &                      ! poc sedimentation
          saved_rate_p_poc_sedi_sed                ! for Runge-Kutta method
     real, ALLOCATABLE, dimension(:,:) :: &
          p_pocn_sedi_sed , &                      ! pocn sedimentation
          saved_rate_p_pocn_sedi_sed               ! for Runge-Kutta method
     real, ALLOCATABLE, dimension(:,:) :: &
          p_pocp_sedi_sed , &                      ! pocp sedimentation
          saved_rate_p_pocp_sedi_sed               ! for Runge-Kutta method
     real, ALLOCATABLE, dimension(:,:) :: &
          p_sed_ero_det   , &                      ! sedimentary detritus erosion
          saved_rate_p_sed_ero_det                 ! for Runge-Kutta method
     real, ALLOCATABLE, dimension(:,:) :: &
          p_ips_ero_ipw   , &                      ! erosion of iron PO4
          saved_rate_p_ips_ero_ipw                 ! for Runge-Kutta method
     real, ALLOCATABLE, dimension(:,:) :: &
          p_sed_ero_poc   , &                      ! sedimentary poc erosion
          saved_rate_p_sed_ero_poc                 ! for Runge-Kutta method
     real, ALLOCATABLE, dimension(:,:) :: &
          p_sed_ero_pocn  , &                      ! sedimentary pocn erosion
          saved_rate_p_sed_ero_pocn                ! for Runge-Kutta method
     real, ALLOCATABLE, dimension(:,:) :: &
          p_sed_ero_pocp  , &                      ! sedimentary pocp erosion
          saved_rate_p_sed_ero_pocp                ! for Runge-Kutta method
     real, ALLOCATABLE, dimension(:,:) :: &
          p_sed_biores_det , &                      ! bio resuspension of sedimentary detritus
          saved_rate_p_sed_biores_det               ! for Runge-Kutta method
     real, ALLOCATABLE, dimension(:,:) :: &
          p_ips_biores_ipw , &                      ! bio resuspension of iron PO4
          saved_rate_p_ips_biores_ipw               ! for Runge-Kutta method
     real, ALLOCATABLE, dimension(:,:) :: &
          p_sed_biores_poc , &                      ! bio resuspension of sedimentary poc
          saved_rate_p_sed_biores_poc               ! for Runge-Kutta method
     real, ALLOCATABLE, dimension(:,:) :: &
          p_sed_biores_pocn , &                      ! bio resuspension of sedimentary pocn
          saved_rate_p_sed_biores_pocn               ! for Runge-Kutta method
     real, ALLOCATABLE, dimension(:,:) :: &
          p_sed_biores_pocp , &                      ! bio resuspension of sedimentary pocp
          saved_rate_p_sed_biores_pocp               ! for Runge-Kutta method
     real, ALLOCATABLE, dimension(:,:) :: &
          p_sed_burial    , &                      ! burial of detritus deeper than max_sed
          saved_rate_p_sed_burial                  ! for Runge-Kutta method
     real, ALLOCATABLE, dimension(:,:) :: &
          p_ips_burial    , &                      ! burial of iron PO4
          saved_rate_p_ips_burial                  ! for Runge-Kutta method
     real, ALLOCATABLE, dimension(:,:) :: &
          p_poc_burial    , &                      ! burial of poc deeper than max_sed
          saved_rate_p_poc_burial                  ! for Runge-Kutta method
     real, ALLOCATABLE, dimension(:,:) :: &
          p_pocn_burial   , &                      ! burial of pocn deeper than max_sed
          saved_rate_p_pocn_burial                 ! for Runge-Kutta method
     real, ALLOCATABLE, dimension(:,:) :: &
          p_pocp_burial   , &                      ! burial of pocp deeper than max_sed
          saved_rate_p_pocp_burial                 ! for Runge-Kutta method
     real, ALLOCATABLE, dimension(:,:) :: &
          p_sed_pocn_resp , &                      ! recycling of sedimentary pocn to dic and NH4 using oxygen (respiration)
          saved_rate_p_sed_pocn_resp               ! for Runge-Kutta method
     real, ALLOCATABLE, dimension(:,:) :: &
          p_sed_pocp_resp , &                      ! recycling of sedimentary pocp to dic and PO4 using oxygen (respiration)
          saved_rate_p_sed_pocp_resp               ! for Runge-Kutta method
     real, ALLOCATABLE, dimension(:,:) :: &
          p_sed_pocn_denit_noN2 , &                      ! recycling of sedimentary pocn to dic and NH4 using nitrate (denitrification)
          saved_rate_p_sed_pocn_denit_noN2               ! for Runge-Kutta method
     real, ALLOCATABLE, dimension(:,:) :: &
          p_sed_pocn_denit_wiN2 , &                      ! recycling of sedimentary pocn to dic and NH4 using nitrate (denitrification)
          saved_rate_p_sed_pocn_denit_wiN2               ! for Runge-Kutta method
     real, ALLOCATABLE, dimension(:,:) :: &
          p_sed_pocp_denit , &                      ! recycling of sedimentary pocp to dic and PO4 using nitrate (denitrification)
          saved_rate_p_sed_pocp_denit               ! for Runge-Kutta method
     real, ALLOCATABLE, dimension(:,:) :: &
          p_sed_pocn_sulf , &                      ! recycling of sedimentary pocn to dic and NH4 using sulfate (sulfate reduction)
          saved_rate_p_sed_pocn_sulf               ! for Runge-Kutta method
     real, ALLOCATABLE, dimension(:,:) :: &
          p_sed_pocp_sulf , &                      ! recycling of sedimentary pocp to dic and PO4 using sulfate (sulfate reduction)
          saved_rate_p_sed_pocp_sulf               ! for Runge-Kutta method
     real, ALLOCATABLE, dimension(:,:) :: &
          p_nh4_nitdenit_pocn_n2 , &                      ! coupled nitrification and denitrification after mineralization of pocn-detritus in oxic sediments
          saved_rate_p_nh4_nitdenit_pocn_n2               ! for Runge-Kutta method
     real, ALLOCATABLE, dimension(:,:) :: &
          p_sed_resp_nh4_atmos_tot_N , &                      ! recycling of sedimentary detritus to ammonium using oxygen (respiration); sub-process for atmos_tot nitrogen
          saved_rate_p_sed_resp_nh4_atmos_tot_N               ! for Runge-Kutta method
     real, ALLOCATABLE, dimension(:,:) :: &
          p_sed_denit_nh4_noN2_atmos_tot_N , &                      ! recycling of sedimentary detritus to ammonium using nitrate (denitrification); sub-process for atmos_tot nitrogen
          saved_rate_p_sed_denit_nh4_noN2_atmos_tot_N               ! for Runge-Kutta method
     real, ALLOCATABLE, dimension(:,:) :: &
          p_sed_sulf_nh4_atmos_tot_N , &                      ! recycling of sedimentary detritus to ammonium using sulfate (sulfate reduction); sub-process for atmos_tot nitrogen
          saved_rate_p_sed_sulf_nh4_atmos_tot_N               ! for Runge-Kutta method
     real, ALLOCATABLE, dimension(:,:) :: &
          p_det_sedi_sed_atmos_tot_N , &                      ! detritus sedimentation; sub-process for atmos_tot nitrogen
          saved_rate_p_det_sedi_sed_atmos_tot_N               ! for Runge-Kutta method
     real, ALLOCATABLE, dimension(:,:) :: &
          p_pocn_sedi_sed_atmos_tot_N , &                      ! pocn sedimentation; sub-process for atmos_tot nitrogen
          saved_rate_p_pocn_sedi_sed_atmos_tot_N               ! for Runge-Kutta method
     real, ALLOCATABLE, dimension(:,:) :: &
          p_sed_ero_det_atmos_tot_N , &                      ! sedimentary detritus erosion; sub-process for atmos_tot nitrogen
          saved_rate_p_sed_ero_det_atmos_tot_N               ! for Runge-Kutta method
     real, ALLOCATABLE, dimension(:,:) :: &
          p_sed_ero_pocn_atmos_tot_N , &                      ! sedimentary pocn erosion; sub-process for atmos_tot nitrogen
          saved_rate_p_sed_ero_pocn_atmos_tot_N               ! for Runge-Kutta method
     real, ALLOCATABLE, dimension(:,:) :: &
          p_sed_biores_det_atmos_tot_N , &                      ! bio resuspension of sedimentary detritus; sub-process for atmos_tot nitrogen
          saved_rate_p_sed_biores_det_atmos_tot_N               ! for Runge-Kutta method
     real, ALLOCATABLE, dimension(:,:) :: &
          p_sed_biores_pocn_atmos_tot_N , &                      ! bio resuspension of sedimentary pocn; sub-process for atmos_tot nitrogen
          saved_rate_p_sed_biores_pocn_atmos_tot_N               ! for Runge-Kutta method
     real, ALLOCATABLE, dimension(:,:) :: &
          p_sed_burial_atmos_tot_N , &                      ! burial of detritus deeper than max_sed; sub-process for atmos_tot nitrogen
          saved_rate_p_sed_burial_atmos_tot_N               ! for Runge-Kutta method
     real, ALLOCATABLE, dimension(:,:) :: &
          p_pocn_burial_atmos_tot_N , &                      ! burial of pocn deeper than max_sed; sub-process for atmos_tot nitrogen
          saved_rate_p_pocn_burial_atmos_tot_N               ! for Runge-Kutta method
     real, ALLOCATABLE, dimension(:,:) :: &
          p_sed_pocn_resp_atmos_tot_N , &                      ! recycling of sedimentary pocn to dic and NH4 using oxygen (respiration); sub-process for atmos_tot nitrogen
          saved_rate_p_sed_pocn_resp_atmos_tot_N               ! for Runge-Kutta method
     real, ALLOCATABLE, dimension(:,:) :: &
          p_sed_pocn_denit_noN2_atmos_tot_N , &                      ! recycling of sedimentary pocn to dic and NH4 using nitrate (denitrification); sub-process for atmos_tot nitrogen
          saved_rate_p_sed_pocn_denit_noN2_atmos_tot_N               ! for Runge-Kutta method
     real, ALLOCATABLE, dimension(:,:) :: &
          p_sed_pocn_sulf_atmos_tot_N , &                      ! recycling of sedimentary pocn to dic and NH4 using sulfate (sulfate reduction); sub-process for atmos_tot nitrogen
          saved_rate_p_sed_pocn_sulf_atmos_tot_N               ! for Runge-Kutta method
     real, ALLOCATABLE, dimension(:,:) :: &
          p_sed_resp_nh4_atmos_ship_N , &                      ! recycling of sedimentary detritus to ammonium using oxygen (respiration); sub-process for atmos_ship nitrogen
          saved_rate_p_sed_resp_nh4_atmos_ship_N               ! for Runge-Kutta method
     real, ALLOCATABLE, dimension(:,:) :: &
          p_sed_denit_nh4_noN2_atmos_ship_N , &                      ! recycling of sedimentary detritus to ammonium using nitrate (denitrification); sub-process for atmos_ship nitrogen
          saved_rate_p_sed_denit_nh4_noN2_atmos_ship_N               ! for Runge-Kutta method
     real, ALLOCATABLE, dimension(:,:) :: &
          p_sed_sulf_nh4_atmos_ship_N , &                      ! recycling of sedimentary detritus to ammonium using sulfate (sulfate reduction); sub-process for atmos_ship nitrogen
          saved_rate_p_sed_sulf_nh4_atmos_ship_N               ! for Runge-Kutta method
     real, ALLOCATABLE, dimension(:,:) :: &
          p_det_sedi_sed_atmos_ship_N , &                      ! detritus sedimentation; sub-process for atmos_ship nitrogen
          saved_rate_p_det_sedi_sed_atmos_ship_N               ! for Runge-Kutta method
     real, ALLOCATABLE, dimension(:,:) :: &
          p_pocn_sedi_sed_atmos_ship_N , &                      ! pocn sedimentation; sub-process for atmos_ship nitrogen
          saved_rate_p_pocn_sedi_sed_atmos_ship_N               ! for Runge-Kutta method
     real, ALLOCATABLE, dimension(:,:) :: &
          p_sed_ero_det_atmos_ship_N , &                      ! sedimentary detritus erosion; sub-process for atmos_ship nitrogen
          saved_rate_p_sed_ero_det_atmos_ship_N               ! for Runge-Kutta method
     real, ALLOCATABLE, dimension(:,:) :: &
          p_sed_ero_pocn_atmos_ship_N , &                      ! sedimentary pocn erosion; sub-process for atmos_ship nitrogen
          saved_rate_p_sed_ero_pocn_atmos_ship_N               ! for Runge-Kutta method
     real, ALLOCATABLE, dimension(:,:) :: &
          p_sed_biores_det_atmos_ship_N , &                      ! bio resuspension of sedimentary detritus; sub-process for atmos_ship nitrogen
          saved_rate_p_sed_biores_det_atmos_ship_N               ! for Runge-Kutta method
     real, ALLOCATABLE, dimension(:,:) :: &
          p_sed_biores_pocn_atmos_ship_N , &                      ! bio resuspension of sedimentary pocn; sub-process for atmos_ship nitrogen
          saved_rate_p_sed_biores_pocn_atmos_ship_N               ! for Runge-Kutta method
     real, ALLOCATABLE, dimension(:,:) :: &
          p_sed_burial_atmos_ship_N , &                      ! burial of detritus deeper than max_sed; sub-process for atmos_ship nitrogen
          saved_rate_p_sed_burial_atmos_ship_N               ! for Runge-Kutta method
     real, ALLOCATABLE, dimension(:,:) :: &
          p_pocn_burial_atmos_ship_N , &                      ! burial of pocn deeper than max_sed; sub-process for atmos_ship nitrogen
          saved_rate_p_pocn_burial_atmos_ship_N               ! for Runge-Kutta method
     real, ALLOCATABLE, dimension(:,:) :: &
          p_sed_pocn_resp_atmos_ship_N , &                      ! recycling of sedimentary pocn to dic and NH4 using oxygen (respiration); sub-process for atmos_ship nitrogen
          saved_rate_p_sed_pocn_resp_atmos_ship_N               ! for Runge-Kutta method
     real, ALLOCATABLE, dimension(:,:) :: &
          p_sed_pocn_denit_noN2_atmos_ship_N , &                      ! recycling of sedimentary pocn to dic and NH4 using nitrate (denitrification); sub-process for atmos_ship nitrogen
          saved_rate_p_sed_pocn_denit_noN2_atmos_ship_N               ! for Runge-Kutta method
     real, ALLOCATABLE, dimension(:,:) :: &
          p_sed_pocn_sulf_atmos_ship_N , &                      ! recycling of sedimentary pocn to dic and NH4 using sulfate (sulfate reduction); sub-process for atmos_ship nitrogen
          saved_rate_p_sed_pocn_sulf_atmos_ship_N               ! for Runge-Kutta method
     real, ALLOCATABLE, dimension(:,:) :: &
          frac_denit_sed                           ! fraction of ammonium that is immediately nitrified and denitrified after remineralization in oxic sediments
     real, ALLOCATABLE, dimension(:,:) :: &
          sed_tot                                  ! total carbon in sediment layer [mol/m**2]
     real, ALLOCATABLE, dimension(:,:) :: &
          sed_tot_active                           ! total carbon in active sediment layer [mol/m**2]
     real, ALLOCATABLE, dimension(:,:) :: &
          sed_active                               ! detritus in active sediment layer [mol/m**2]
     real, ALLOCATABLE, dimension(:,:) :: &
          lr_sed_rec                               ! recycling rate of sediment detritus, limited by oxygen [1/d]
     real, ALLOCATABLE, dimension(:,:) :: &
          ips_eff                                  ! effective concentration of iron phosphate in the sediment assumed for burial (enhanced burial above a threshold) [mol/m**2]
     real, ALLOCATABLE, dimension(:,:) :: &
          erosion_is_active                          ! switch (1=erosion, 0=no erosion) which depends on the combined bottom stress of currents and waves
     real, ALLOCATABLE, dimension(:,:) :: &
          poc_active                               ! poc in active sediment layer [mol/m**2]
     real, ALLOCATABLE, dimension(:,:) :: &
          pocn_active                              ! pocn in active sediment layer [mol/m**2]
     real, ALLOCATABLE, dimension(:,:) :: &
          pocp_active                              ! pocp in active sediment layer [mol/m**2]
     real, ALLOCATABLE, dimension(:,:) :: &
          ph_temp                                  ! temporary value assumed for pH [1]
     real, ALLOCATABLE, dimension(:,:) :: &
          k_water                                  ! self-ionization constant of Water [mol2/kg2]
     real, ALLOCATABLE, dimension(:,:) :: &
          k0_co2                                   ! Solubility of CO2 [mol/kg/Pa]
     real, ALLOCATABLE, dimension(:,:) :: &
          k1_co2                                   ! Acid dissociation constant CO2 + 2 H2O <-> HCO3- + H3O+ [mol/kg]
     real, ALLOCATABLE, dimension(:,:) :: &
          k2_co2                                   ! Acid dissociation constant HCO3- + H2O <-> [CO3 2-] + H3O+ [mol/kg]
     real, ALLOCATABLE, dimension(:,:) :: &
          k_boron                                  ! Acid dissociation constant of boric acid [mol/kg]
     real, ALLOCATABLE, dimension(:,:) :: &
          k1_po4                                   ! Acid dissociation constant H3PO4 + H2O <-> [H2PO4 -] + H3O+ [mol/kg]
     real, ALLOCATABLE, dimension(:,:) :: &
          k2_po4                                   ! Acid dissociation constant [H2PO4 -] + H2O+ <-> [HPO4 2-] + H3O+ [mol/kg]
     real, ALLOCATABLE, dimension(:,:) :: &
          k3_po4                                   ! Acid dissociation constant [HPO4 2-] + H2O <-> [PO4 3-] + H3O+ [mol/kg]
     real, ALLOCATABLE, dimension(:,:) :: &
          k1_h2s                                   ! Acid dissociation constant H2S + H2O <-> HS- + H3O+ [mol/kg]
     real, ALLOCATABLE, dimension(:,:) :: &
          boron_total                              ! total concentration of boron [mol/kg]
     real, ALLOCATABLE, dimension(:,:) :: &
          alk_boron                                ! boron alkalinity [mol/kg]
     real, ALLOCATABLE, dimension(:,:) :: &
          alk_h2s                                  ! hydrogen sulfide alkalinity [mol/kg]
     real, ALLOCATABLE, dimension(:,:) :: &
          alk_water                                ! water alkalinity [mol/kg]
     real, ALLOCATABLE, dimension(:,:) :: &
          alk_po4_denominator                          ! denominator in phosphate alkalinity formula [mol3/kg3]
     real, ALLOCATABLE, dimension(:,:) :: &
          alk_po4                                  ! phosphate alkalinity [mol/kg]
     real, ALLOCATABLE, dimension(:,:) :: &
          alk_co2_denominator                          ! denominator in carbonate alkalinity formula [mol2/kg2]
     real, ALLOCATABLE, dimension(:,:) :: &
          alk_co2                                  ! carbonate alkalinity [mol/kg]
     real, ALLOCATABLE, dimension(:,:) :: &
          alk_residual                             ! error in total alkalinity calculation at the assumed pH [mol/kg]
     real, ALLOCATABLE, dimension(:,:) :: &
          dalkp_dh3o                               ! derivative of phosphate alkalinity with respect to h3o [1]
     real, ALLOCATABLE, dimension(:,:) :: &
          dalkc_dh3o                               ! derivative of carbonate alkalinity with respect to h3o [1]
     real, ALLOCATABLE, dimension(:,:) :: &
          dalkresidual_dpH                          ! derivative of residual_alk with respect to pH [mol/kg]
     real, ALLOCATABLE, dimension(:,:) :: &
          ph                                       ! newly determined pH value [1]
     real, ALLOCATABLE, dimension(:,:) :: &
          h3o                                      ! h3o ion concentration [mol/kg]
     real, ALLOCATABLE, dimension(:,:) :: &
          pco2                                     ! co2 partial pressure [Pa]
     real, ALLOCATABLE, dimension(:,:) :: &
          co2                                      ! CO2 concentration in the surface layer [mol/kg]
     real, ALLOCATABLE, dimension(:,:) :: &
          schmidtnumber_co2                          ! Schmidt number for CO2 surface flux [1]
     real, ALLOCATABLE, dimension(:,:) :: &
          solubility_o2                            ! solubility of oxygen [mol/kg/Pa]
     real, ALLOCATABLE, dimension(:,:) :: &
          schmidtnumber_o2                          ! Schmidt number for oxygen surface flux [1]
     real, ALLOCATABLE, dimension(:,:) :: &
          schmidtnumber_n2                          ! Schmidt number for nitrogen surface flux [1]

     real, ALLOCATABLE, dimension(:,:,:) :: &
          temp_k          , &                      ! absolute temperature [K]
          o2_sat          , &                      ! oxygen saturation concentration [mol/kg]
          n2_sat          , &                      ! dissolved molecular nitrogen saturation concentration [mol/kg]
          solubility_n2   , &                      ! solubility of molecular nitrogen [mol/kg/Pa]
          temp_sq         , &                      ! square of positive temperature [C * C]
          zoo_eff         , &                      ! effectice zooplankton concentration assumed for mortality and respiration process [mol/kg]
          din             , &                      ! dissolved inorganic nitrogen [mol/kg]
          din_sq          , &                      ! squared DIN [mol2/kg2]
          po4_sq          , &                      ! squared phosphate [mol**2/kg**2]
          pp              , &                      ! total phytoplankton [mol/kg]
          lpp_plus_lpp0   , &                      ! large-cell phytoplankton plus seed concentration [mol/kg]
          spp_plus_spp0   , &                      ! small-cell phytoplankton plus seed concentration [mol/kg]
          cya_plus_cya0   , &                      ! diazotroph cyanobacteria plus seed concentration [mol/kg]
          food_zoo        , &                      ! suitable food for zooplankton (weighted with food preferences) [mol/kg]
          lim_light_lpp   , &                      ! light limitation factor for large-cell phytoplankton growth [1]
          lim_light_spp   , &                      ! light limitation factor for small-cell phytoplankton growth [1]
          lim_light_cya   , &                      ! light limitation factor for diazotroph cyanobacteria growth [1]
          lr_assim_lpp    , &                      ! growth rate of large-cell phytoplankton, limited by DIN, DIP, light and oxygen [1/day]
          lr_assim_lpp_doc , &                      ! production rate of DOC by LPP
          lr_assim_spp_doc , &                      ! production rate of POC by SPP
          lr_assim_cya_doc , &                      ! production rate of POC by CYA
          lr_assim_spp    , &                      ! growth rate of small-cell phytoplankton, limited by DIN, DIP, light, oxygen and temperature [1/day]
          lr_assim_cya    , &                      ! growth rate of diazotroph cyanobacteria, limited by DIP, light, oxygen, temperature and salinity [1/day]
          lr_assim_lpp_dop , &                      ! production rate of POCP by LPP
          lr_assim_spp_dop , &                      ! production rate of POCP by SPP
          lr_assim_lpp_don , &                      ! production rate of POCN by LPP
          lr_assim_spp_don , &                      ! production rate of POCN by SPP
          lr_graz_zoo     , &                      ! growth rate of zooplankton, limited by food, oxygen and temperature [1/day]
          frac_po4retent  , &                      ! fraction of phosphate which is retained as iron-bound phosphate instead of being released after mineralization in the sediment [1]
          ref_p_sw        , &                      ! modifies pocp recycling towards Refield ratio if PO4 is depleted
          ref_n_sw        , &                      ! modifies pocn recycling towards Refield ratio if DIN is depleted
          lr_pocp         , &                      ! add an additional POCP recycling if PO4 below Redfield but sufficient DIN
          lr_dop          , &                      ! add an additional DOP recycling if PO4 is below Redfield but sufficient DIN
          lr_pocn         , &                      ! add an additional POCN recycling if DIN below Redfield but sufficient PO4
          lr_don          , &                      ! add an additional DON recycling if DIN below Redfield but sufficient PO4
          w_poc_var       , &                      ! depth dependent POC sinking speed
          w_pocn_var      , &                      ! depth dependent POCN sinking speed
          w_pocp_var      , &                      ! depth dependent POCP sinking speed
          p_no3_assim_lpp , &                      ! assimilation of nitrate by large-cell phytoplankton
          saved_rate_p_no3_assim_lpp , &           ! for Runge-Kutta method
          p_nh4_assim_lpp , &                      ! assimilation of ammonium by large-cell phytoplankton
          saved_rate_p_nh4_assim_lpp , &           ! for Runge-Kutta method
          p_no3_assim_spp , &                      ! assimilation of nitrate by small-cell phytoplankton
          saved_rate_p_no3_assim_spp , &           ! for Runge-Kutta method
          p_nh4_assim_spp , &                      ! assimilation of ammonium by small-cell phytoplankton
          saved_rate_p_nh4_assim_spp , &           ! for Runge-Kutta method
          p_n2_assim_cya  , &                      ! fixation of dinitrogen by diazotroph cyanobacteria
          saved_rate_p_n2_assim_cya  , &           ! for Runge-Kutta method
          p_assim_lpp_doc , &                      ! Production of DOC by LPP
          saved_rate_p_assim_lpp_doc , &           ! for Runge-Kutta method
          p_assim_spp_doc , &                      ! Production of DOC by SPP
          saved_rate_p_assim_spp_doc , &           ! for Runge-Kutta method
          p_assim_cya_doc , &                      ! Production of POC by CYA
          saved_rate_p_assim_cya_doc , &           ! for Runge-Kutta method
          p_assim_lpp_dop , &                      ! Production of DOP by LPP
          saved_rate_p_assim_lpp_dop , &           ! for Runge-Kutta method
          p_assim_spp_dop , &                      ! Production of DOP by SPP
          saved_rate_p_assim_spp_dop , &           ! for Runge-Kutta method
          p_nh4_assim_lpp_don , &                      ! Production of DON by LPP
          saved_rate_p_nh4_assim_lpp_don , &           ! for Runge-Kutta method
          p_no3_assim_lpp_don , &                      ! Production of DON by LPP
          saved_rate_p_no3_assim_lpp_don , &           ! for Runge-Kutta method
          p_nh4_assim_spp_don , &                      ! Production of DON by SPP
          saved_rate_p_nh4_assim_spp_don , &           ! for Runge-Kutta method
          p_no3_assim_spp_don , &                      ! Production of DON by SPP
          saved_rate_p_no3_assim_spp_don , &           ! for Runge-Kutta method
          p_poc_resp      , &                      ! respiration of POC
          saved_rate_p_poc_resp      , &           ! for Runge-Kutta method
          p_poc_denit     , &                      ! recycling of POC using nitrate (denitrification)
          saved_rate_p_poc_denit     , &           ! for Runge-Kutta method
          p_poc_sulf      , &                      ! Mineralization of POC, e-acceptor sulfate (sulfate reduction)
          saved_rate_p_poc_sulf      , &           ! for Runge-Kutta method
          p_pocp_resp     , &                      ! respiration of POCP
          saved_rate_p_pocp_resp     , &           ! for Runge-Kutta method
          p_pocp_denit    , &                      ! recycling of POC using nitrate (denitrification)
          saved_rate_p_pocp_denit    , &           ! for Runge-Kutta method
          p_pocp_sulf     , &                      ! Mineralization of POC, e-acceptor sulfate (sulfate reduction)
          saved_rate_p_pocp_sulf     , &           ! for Runge-Kutta method
          p_pocn_resp     , &                      ! respiration of POCN
          saved_rate_p_pocn_resp     , &           ! for Runge-Kutta method
          p_pocn_denit_noN2 , &                      ! recycling of POCN using nitrate (denitrification)
          saved_rate_p_pocn_denit_noN2 , &           ! for Runge-Kutta method
          p_pocn_denit_wiN2 , &                      ! recycling of POCN using nitrate (denitrification)
          saved_rate_p_pocn_denit_wiN2 , &           ! for Runge-Kutta method
          p_pocn_sulf     , &                      ! Mineralization of POCN, e-acceptor sulfate (sulfate reduction)
          saved_rate_p_pocn_sulf     , &           ! for Runge-Kutta method
          p_lpp_graz_zoo  , &                      ! grazing of zooplankton eating large-cell phytoplankton
          saved_rate_p_lpp_graz_zoo  , &           ! for Runge-Kutta method
          p_spp_graz_zoo  , &                      ! grazing of zooplankton eating small-cell phytoplankton
          saved_rate_p_spp_graz_zoo  , &           ! for Runge-Kutta method
          p_cya_graz_zoo  , &                      ! grazing of zooplankton eating diazotroph cyanobacteria
          saved_rate_p_cya_graz_zoo  , &           ! for Runge-Kutta method
          p_lpp_resp_nh4  , &                      ! respiration of large-cell phytoplankton
          saved_rate_p_lpp_resp_nh4  , &           ! for Runge-Kutta method
          p_spp_resp_nh4  , &                      ! respiration of small-cell phytoplankton
          saved_rate_p_spp_resp_nh4  , &           ! for Runge-Kutta method
          p_cya_resp_nh4  , &                      ! respiration of diazotroph cyanobacteria
          saved_rate_p_cya_resp_nh4  , &           ! for Runge-Kutta method
          p_zoo_resp_nh4  , &                      ! respiration of zooplankton
          saved_rate_p_zoo_resp_nh4  , &           ! for Runge-Kutta method
          p_lpp_mort_det  , &                      ! mortality of large-cell phytoplankton
          saved_rate_p_lpp_mort_det  , &           ! for Runge-Kutta method
          p_spp_mort_det  , &                      ! mortality of small-scale phytoplankton
          saved_rate_p_spp_mort_det  , &           ! for Runge-Kutta method
          p_cya_mort_det  , &                      ! mortality of diazotroph cyanobacteria
          saved_rate_p_cya_mort_det  , &           ! for Runge-Kutta method
          p_cya_mort_det_diff , &                      ! mortality of diazotroph cyanobacteria due to strong turbulence
          saved_rate_p_cya_mort_det_diff , &           ! for Runge-Kutta method
          p_zoo_mort_det  , &                      ! mortality of zooplankton
          saved_rate_p_zoo_mort_det  , &           ! for Runge-Kutta method
          p_nh4_nit_no3   , &                      ! nitrification
          saved_rate_p_nh4_nit_no3   , &           ! for Runge-Kutta method
          p_det_resp_nh4  , &                      ! recycling of detritus using oxygen (respiration)
          saved_rate_p_det_resp_nh4  , &           ! for Runge-Kutta method
          p_det_denit_nh4 , &                      ! recycling of detritus using nitrate (denitrification)
          saved_rate_p_det_denit_nh4 , &           ! for Runge-Kutta method
          p_det_sulf_nh4  , &                      ! recycling of detritus using sulfate (sulfate reduction)
          saved_rate_p_det_sulf_nh4  , &           ! for Runge-Kutta method
          p_h2s_oxo2_sul  , &                      ! oxidation of hydrogen sulfide with oxygen
          saved_rate_p_h2s_oxo2_sul  , &           ! for Runge-Kutta method
          p_h2s_oxno3_sul , &                      ! oxidation of hydrogen sulfide with nitrate
          saved_rate_p_h2s_oxno3_sul , &           ! for Runge-Kutta method
          p_sul_oxo2_so4  , &                      ! oxidation of elemental sulfur with oxygen
          saved_rate_p_sul_oxo2_so4  , &           ! for Runge-Kutta method
          p_sul_oxno3_so4 , &                      ! oxidation of elemental sulfur with nitrate
          saved_rate_p_sul_oxno3_so4 , &           ! for Runge-Kutta method
          p_doc2pco       , &                      ! particle formation from DOC
          saved_rate_p_doc2pco       , &           ! for Runge-Kutta method
          p_dop2pocp      , &                      ! particle formation from DOP
          saved_rate_p_dop2pocp      , &           ! for Runge-Kutta method
          p_don2pocn      , &                      ! particle formation from DON
          saved_rate_p_don2pocn      , &           ! for Runge-Kutta method
          p_doc_resp      , &                      ! respiration of DOC
          saved_rate_p_doc_resp      , &           ! for Runge-Kutta method
          p_doc_denit     , &                      ! recycling of DOC using nitrate (denitrification)
          saved_rate_p_doc_denit     , &           ! for Runge-Kutta method
          p_doc_sulf      , &                      ! Mineralization of DOC, e-acceptor sulfate (sulfate reduction)
          saved_rate_p_doc_sulf      , &           ! for Runge-Kutta method
          p_dop_resp      , &                      ! respiration of DOP
          saved_rate_p_dop_resp      , &           ! for Runge-Kutta method
          p_dop_denit     , &                      ! recycling of DOP using nitrate (denitrification)
          saved_rate_p_dop_denit     , &           ! for Runge-Kutta method
          p_dop_sulf      , &                      ! Mineralization of DOP, e-acceptor sulfate (sulfate reduction)
          saved_rate_p_dop_sulf      , &           ! for Runge-Kutta method
          p_don_resp      , &                      ! respiration of DON
          saved_rate_p_don_resp      , &           ! for Runge-Kutta method
          p_don_denit_noN2 , &                      ! recycling of DON using nitrate (denitrification)
          saved_rate_p_don_denit_noN2 , &           ! for Runge-Kutta method
          p_don_denit_wiN2 , &                      ! recycling of DON using nitrate (denitrification)
          saved_rate_p_don_denit_wiN2 , &           ! for Runge-Kutta method
          p_don_sulf      , &                      ! Mineralization of DON, e-acceptor sulfate (sulfate reduction)
          saved_rate_p_don_sulf      , &           ! for Runge-Kutta method
          p_no3_assim_lpp_atmos_tot_N , &                      ! assimilation of nitrate by large-cell phytoplankton; sub-process for atmos_tot nitrogen
          saved_rate_p_no3_assim_lpp_atmos_tot_N , &           ! for Runge-Kutta method
          p_nh4_assim_lpp_atmos_tot_N , &                      ! assimilation of ammonium by large-cell phytoplankton; sub-process for atmos_tot nitrogen
          saved_rate_p_nh4_assim_lpp_atmos_tot_N , &           ! for Runge-Kutta method
          p_no3_assim_spp_atmos_tot_N , &                      ! assimilation of nitrate by small-cell phytoplankton; sub-process for atmos_tot nitrogen
          saved_rate_p_no3_assim_spp_atmos_tot_N , &           ! for Runge-Kutta method
          p_nh4_assim_spp_atmos_tot_N , &                      ! assimilation of ammonium by small-cell phytoplankton; sub-process for atmos_tot nitrogen
          saved_rate_p_nh4_assim_spp_atmos_tot_N , &           ! for Runge-Kutta method
          p_nh4_assim_lpp_don_atmos_tot_N , &                      ! Production of DON by LPP; sub-process for atmos_tot nitrogen
          saved_rate_p_nh4_assim_lpp_don_atmos_tot_N , &           ! for Runge-Kutta method
          p_no3_assim_lpp_don_atmos_tot_N , &                      ! Production of DON by LPP; sub-process for atmos_tot nitrogen
          saved_rate_p_no3_assim_lpp_don_atmos_tot_N , &           ! for Runge-Kutta method
          p_nh4_assim_spp_don_atmos_tot_N , &                      ! Production of DON by SPP; sub-process for atmos_tot nitrogen
          saved_rate_p_nh4_assim_spp_don_atmos_tot_N , &           ! for Runge-Kutta method
          p_no3_assim_spp_don_atmos_tot_N , &                      ! Production of DON by SPP; sub-process for atmos_tot nitrogen
          saved_rate_p_no3_assim_spp_don_atmos_tot_N , &           ! for Runge-Kutta method
          p_pocn_resp_atmos_tot_N , &                      ! respiration of POCN; sub-process for atmos_tot nitrogen
          saved_rate_p_pocn_resp_atmos_tot_N , &           ! for Runge-Kutta method
          p_pocn_denit_noN2_atmos_tot_N , &                      ! recycling of POCN using nitrate (denitrification); sub-process for atmos_tot nitrogen
          saved_rate_p_pocn_denit_noN2_atmos_tot_N , &           ! for Runge-Kutta method
          p_pocn_sulf_atmos_tot_N , &                      ! Mineralization of POCN, e-acceptor sulfate (sulfate reduction); sub-process for atmos_tot nitrogen
          saved_rate_p_pocn_sulf_atmos_tot_N , &           ! for Runge-Kutta method
          p_lpp_graz_zoo_atmos_tot_N , &                      ! grazing of zooplankton eating large-cell phytoplankton; sub-process for atmos_tot nitrogen
          saved_rate_p_lpp_graz_zoo_atmos_tot_N , &           ! for Runge-Kutta method
          p_spp_graz_zoo_atmos_tot_N , &                      ! grazing of zooplankton eating small-cell phytoplankton; sub-process for atmos_tot nitrogen
          saved_rate_p_spp_graz_zoo_atmos_tot_N , &           ! for Runge-Kutta method
          p_cya_graz_zoo_atmos_tot_N , &                      ! grazing of zooplankton eating diazotroph cyanobacteria; sub-process for atmos_tot nitrogen
          saved_rate_p_cya_graz_zoo_atmos_tot_N , &           ! for Runge-Kutta method
          p_lpp_resp_nh4_atmos_tot_N , &                      ! respiration of large-cell phytoplankton; sub-process for atmos_tot nitrogen
          saved_rate_p_lpp_resp_nh4_atmos_tot_N , &           ! for Runge-Kutta method
          p_spp_resp_nh4_atmos_tot_N , &                      ! respiration of small-cell phytoplankton; sub-process for atmos_tot nitrogen
          saved_rate_p_spp_resp_nh4_atmos_tot_N , &           ! for Runge-Kutta method
          p_cya_resp_nh4_atmos_tot_N , &                      ! respiration of diazotroph cyanobacteria; sub-process for atmos_tot nitrogen
          saved_rate_p_cya_resp_nh4_atmos_tot_N , &           ! for Runge-Kutta method
          p_zoo_resp_nh4_atmos_tot_N , &                      ! respiration of zooplankton; sub-process for atmos_tot nitrogen
          saved_rate_p_zoo_resp_nh4_atmos_tot_N , &           ! for Runge-Kutta method
          p_lpp_mort_det_atmos_tot_N , &                      ! mortality of large-cell phytoplankton; sub-process for atmos_tot nitrogen
          saved_rate_p_lpp_mort_det_atmos_tot_N , &           ! for Runge-Kutta method
          p_spp_mort_det_atmos_tot_N , &                      ! mortality of small-scale phytoplankton; sub-process for atmos_tot nitrogen
          saved_rate_p_spp_mort_det_atmos_tot_N , &           ! for Runge-Kutta method
          p_cya_mort_det_atmos_tot_N , &                      ! mortality of diazotroph cyanobacteria; sub-process for atmos_tot nitrogen
          saved_rate_p_cya_mort_det_atmos_tot_N , &           ! for Runge-Kutta method
          p_cya_mort_det_diff_atmos_tot_N , &                      ! mortality of diazotroph cyanobacteria due to strong turbulence; sub-process for atmos_tot nitrogen
          saved_rate_p_cya_mort_det_diff_atmos_tot_N , &           ! for Runge-Kutta method
          p_zoo_mort_det_atmos_tot_N , &                      ! mortality of zooplankton; sub-process for atmos_tot nitrogen
          saved_rate_p_zoo_mort_det_atmos_tot_N , &           ! for Runge-Kutta method
          p_nh4_nit_no3_atmos_tot_N , &                      ! nitrification; sub-process for atmos_tot nitrogen
          saved_rate_p_nh4_nit_no3_atmos_tot_N , &           ! for Runge-Kutta method
          p_det_resp_nh4_atmos_tot_N , &                      ! recycling of detritus using oxygen (respiration); sub-process for atmos_tot nitrogen
          saved_rate_p_det_resp_nh4_atmos_tot_N , &           ! for Runge-Kutta method
          p_det_sulf_nh4_atmos_tot_N , &                      ! recycling of detritus using sulfate (sulfate reduction); sub-process for atmos_tot nitrogen
          saved_rate_p_det_sulf_nh4_atmos_tot_N , &           ! for Runge-Kutta method
          p_don2pocn_atmos_tot_N , &                      ! particle formation from DON; sub-process for atmos_tot nitrogen
          saved_rate_p_don2pocn_atmos_tot_N , &           ! for Runge-Kutta method
          p_don_resp_atmos_tot_N , &                      ! respiration of DON; sub-process for atmos_tot nitrogen
          saved_rate_p_don_resp_atmos_tot_N , &           ! for Runge-Kutta method
          p_don_denit_noN2_atmos_tot_N , &                      ! recycling of DON using nitrate (denitrification); sub-process for atmos_tot nitrogen
          saved_rate_p_don_denit_noN2_atmos_tot_N , &           ! for Runge-Kutta method
          p_don_sulf_atmos_tot_N , &                      ! Mineralization of DON, e-acceptor sulfate (sulfate reduction); sub-process for atmos_tot nitrogen
          saved_rate_p_don_sulf_atmos_tot_N , &           ! for Runge-Kutta method
          p_no3_assim_lpp_atmos_ship_N , &                      ! assimilation of nitrate by large-cell phytoplankton; sub-process for atmos_ship nitrogen
          saved_rate_p_no3_assim_lpp_atmos_ship_N , &           ! for Runge-Kutta method
          p_nh4_assim_lpp_atmos_ship_N , &                      ! assimilation of ammonium by large-cell phytoplankton; sub-process for atmos_ship nitrogen
          saved_rate_p_nh4_assim_lpp_atmos_ship_N , &           ! for Runge-Kutta method
          p_no3_assim_spp_atmos_ship_N , &                      ! assimilation of nitrate by small-cell phytoplankton; sub-process for atmos_ship nitrogen
          saved_rate_p_no3_assim_spp_atmos_ship_N , &           ! for Runge-Kutta method
          p_nh4_assim_spp_atmos_ship_N , &                      ! assimilation of ammonium by small-cell phytoplankton; sub-process for atmos_ship nitrogen
          saved_rate_p_nh4_assim_spp_atmos_ship_N , &           ! for Runge-Kutta method
          p_nh4_assim_lpp_don_atmos_ship_N , &                      ! Production of DON by LPP; sub-process for atmos_ship nitrogen
          saved_rate_p_nh4_assim_lpp_don_atmos_ship_N , &           ! for Runge-Kutta method
          p_no3_assim_lpp_don_atmos_ship_N , &                      ! Production of DON by LPP; sub-process for atmos_ship nitrogen
          saved_rate_p_no3_assim_lpp_don_atmos_ship_N , &           ! for Runge-Kutta method
          p_nh4_assim_spp_don_atmos_ship_N , &                      ! Production of DON by SPP; sub-process for atmos_ship nitrogen
          saved_rate_p_nh4_assim_spp_don_atmos_ship_N , &           ! for Runge-Kutta method
          p_no3_assim_spp_don_atmos_ship_N , &                      ! Production of DON by SPP; sub-process for atmos_ship nitrogen
          saved_rate_p_no3_assim_spp_don_atmos_ship_N , &           ! for Runge-Kutta method
          p_pocn_resp_atmos_ship_N , &                      ! respiration of POCN; sub-process for atmos_ship nitrogen
          saved_rate_p_pocn_resp_atmos_ship_N , &           ! for Runge-Kutta method
          p_pocn_denit_noN2_atmos_ship_N , &                      ! recycling of POCN using nitrate (denitrification); sub-process for atmos_ship nitrogen
          saved_rate_p_pocn_denit_noN2_atmos_ship_N , &           ! for Runge-Kutta method
          p_pocn_sulf_atmos_ship_N , &                      ! Mineralization of POCN, e-acceptor sulfate (sulfate reduction); sub-process for atmos_ship nitrogen
          saved_rate_p_pocn_sulf_atmos_ship_N , &           ! for Runge-Kutta method
          p_lpp_graz_zoo_atmos_ship_N , &                      ! grazing of zooplankton eating large-cell phytoplankton; sub-process for atmos_ship nitrogen
          saved_rate_p_lpp_graz_zoo_atmos_ship_N , &           ! for Runge-Kutta method
          p_spp_graz_zoo_atmos_ship_N , &                      ! grazing of zooplankton eating small-cell phytoplankton; sub-process for atmos_ship nitrogen
          saved_rate_p_spp_graz_zoo_atmos_ship_N , &           ! for Runge-Kutta method
          p_cya_graz_zoo_atmos_ship_N , &                      ! grazing of zooplankton eating diazotroph cyanobacteria; sub-process for atmos_ship nitrogen
          saved_rate_p_cya_graz_zoo_atmos_ship_N , &           ! for Runge-Kutta method
          p_lpp_resp_nh4_atmos_ship_N , &                      ! respiration of large-cell phytoplankton; sub-process for atmos_ship nitrogen
          saved_rate_p_lpp_resp_nh4_atmos_ship_N , &           ! for Runge-Kutta method
          p_spp_resp_nh4_atmos_ship_N , &                      ! respiration of small-cell phytoplankton; sub-process for atmos_ship nitrogen
          saved_rate_p_spp_resp_nh4_atmos_ship_N , &           ! for Runge-Kutta method
          p_cya_resp_nh4_atmos_ship_N , &                      ! respiration of diazotroph cyanobacteria; sub-process for atmos_ship nitrogen
          saved_rate_p_cya_resp_nh4_atmos_ship_N , &           ! for Runge-Kutta method
          p_zoo_resp_nh4_atmos_ship_N , &                      ! respiration of zooplankton; sub-process for atmos_ship nitrogen
          saved_rate_p_zoo_resp_nh4_atmos_ship_N , &           ! for Runge-Kutta method
          p_lpp_mort_det_atmos_ship_N , &                      ! mortality of large-cell phytoplankton; sub-process for atmos_ship nitrogen
          saved_rate_p_lpp_mort_det_atmos_ship_N , &           ! for Runge-Kutta method
          p_spp_mort_det_atmos_ship_N , &                      ! mortality of small-scale phytoplankton; sub-process for atmos_ship nitrogen
          saved_rate_p_spp_mort_det_atmos_ship_N , &           ! for Runge-Kutta method
          p_cya_mort_det_atmos_ship_N , &                      ! mortality of diazotroph cyanobacteria; sub-process for atmos_ship nitrogen
          saved_rate_p_cya_mort_det_atmos_ship_N , &           ! for Runge-Kutta method
          p_cya_mort_det_diff_atmos_ship_N , &                      ! mortality of diazotroph cyanobacteria due to strong turbulence; sub-process for atmos_ship nitrogen
          saved_rate_p_cya_mort_det_diff_atmos_ship_N , &           ! for Runge-Kutta method
          p_zoo_mort_det_atmos_ship_N , &                      ! mortality of zooplankton; sub-process for atmos_ship nitrogen
          saved_rate_p_zoo_mort_det_atmos_ship_N , &           ! for Runge-Kutta method
          p_nh4_nit_no3_atmos_ship_N , &                      ! nitrification; sub-process for atmos_ship nitrogen
          saved_rate_p_nh4_nit_no3_atmos_ship_N , &           ! for Runge-Kutta method
          p_det_resp_nh4_atmos_ship_N , &                      ! recycling of detritus using oxygen (respiration); sub-process for atmos_ship nitrogen
          saved_rate_p_det_resp_nh4_atmos_ship_N , &           ! for Runge-Kutta method
          p_det_sulf_nh4_atmos_ship_N , &                      ! recycling of detritus using sulfate (sulfate reduction); sub-process for atmos_ship nitrogen
          saved_rate_p_det_sulf_nh4_atmos_ship_N , &           ! for Runge-Kutta method
          p_don2pocn_atmos_ship_N , &                      ! particle formation from DON; sub-process for atmos_ship nitrogen
          saved_rate_p_don2pocn_atmos_ship_N , &           ! for Runge-Kutta method
          p_don_resp_atmos_ship_N , &                      ! respiration of DON; sub-process for atmos_ship nitrogen
          saved_rate_p_don_resp_atmos_ship_N , &           ! for Runge-Kutta method
          p_don_denit_noN2_atmos_ship_N , &                      ! recycling of DON using nitrate (denitrification); sub-process for atmos_ship nitrogen
          saved_rate_p_don_denit_noN2_atmos_ship_N , &           ! for Runge-Kutta method
          p_don_sulf_atmos_ship_N , &                      ! Mineralization of DON, e-acceptor sulfate (sulfate reduction); sub-process for atmos_ship nitrogen
          saved_rate_p_don_sulf_atmos_ship_N , &           ! for Runge-Kutta method
          temp3darray , &                 ! to temporarily store sediment tracers to extract fluffy layer
          vertspeedarray , &                 ! to temporarily store sediment tracers to extract fluffy layer
          irr_inst , &                    ! instantanuous radiation [W/m2]
          irr_zw , &                      ! instantanuous radiation at bottom of cell [W/m2]
          bio_opacity                     ! opacity of biological tracers [1/m]
     real, dimension(:,:,:,:), pointer :: &
          t_n2                     ! dissolved molecular nitrogen
     real, dimension(:,:), allocatable :: &
          btf_t_n2                 ! bottom flux of tracer t_n2            [mol/m2/s] if implicit_bottomflux=.true.
     real, dimension(:,:,:,:), pointer :: &
          t_o2                     ! dissolved oxygen
     real, dimension(:,:), allocatable :: &
          btf_t_o2                 ! bottom flux of tracer t_o2            [mol/m2/s] if implicit_bottomflux=.true.
     real, dimension(:,:,:,:), pointer :: &
          t_dic                    ! dissolved inorganic carbon, treated as carbon dioxide
     real, dimension(:,:), allocatable :: &
          btf_t_dic                ! bottom flux of tracer t_dic           [mol/m2/s] if implicit_bottomflux=.true.
     real, dimension(:,:,:,:), pointer :: &
          t_nh4                    ! ammonium
     real, dimension(:,:), allocatable :: &
          btf_t_nh4                ! bottom flux of tracer t_nh4           [mol/m2/s] if implicit_bottomflux=.true.
     real, dimension(:,:,:,:), pointer :: &
          t_no3                    ! nitrate
     real, dimension(:,:), allocatable :: &
          btf_t_no3                ! bottom flux of tracer t_no3           [mol/m2/s] if implicit_bottomflux=.true.
     real, dimension(:,:,:,:), pointer :: &
          t_po4                    ! phosphate
     real, dimension(:,:), allocatable :: &
          btf_t_po4                ! bottom flux of tracer t_po4           [mol/m2/s] if implicit_bottomflux=.true.
     real, dimension(:,:,:,:), pointer :: &
          t_spp                    ! small-cell phytoplankton
     real, dimension(:,:), allocatable :: &
          btf_t_spp                ! bottom flux of tracer t_spp           [mol/m2/s] if implicit_bottomflux=.true.
     real, dimension(:,:,:,:), pointer :: &
          t_zoo                    ! zooplankton
     real, dimension(:,:), allocatable :: &
          btf_t_zoo                ! bottom flux of tracer t_zoo           [mol/m2/s] if implicit_bottomflux=.true.
     real, dimension(:,:,:,:), pointer :: &
          t_h2s                    ! hydrogen sulfide
     real, dimension(:,:), allocatable :: &
          btf_t_h2s                ! bottom flux of tracer t_h2s           [mol/m2/s] if implicit_bottomflux=.true.
     real, dimension(:,:,:,:), pointer :: &
          t_sul                    ! sulfur
     real, dimension(:,:), allocatable :: &
          btf_t_sul                ! bottom flux of tracer t_sul           [mol/m2/s] if implicit_bottomflux=.true.
     real, dimension(:,:,:,:), pointer :: &
          t_alk                    ! total alkalinity
     real, dimension(:,:), allocatable :: &
          btf_t_alk                ! bottom flux of tracer t_alk           [mol/m2/s] if implicit_bottomflux=.true.
     real, dimension(:,:,:,:), pointer :: &
          t_doc                    ! dissolved organic carbon
     real, dimension(:,:), allocatable :: &
          btf_t_doc                ! bottom flux of tracer t_doc           [mol/m2/s] if implicit_bottomflux=.true.
     real, dimension(:,:,:,:), pointer :: &
          t_dop                    ! phosphorus in dissolved organic carbon in Redfield ratio
     real, dimension(:,:), allocatable :: &
          btf_t_dop                ! bottom flux of tracer t_dop           [mol/m2/s] if implicit_bottomflux=.true.
     real, dimension(:,:,:,:), pointer :: &
          total_atmos_tot_N          ! total_atmos_tot_N
     real, dimension(:,:), allocatable :: &
          btf_total_atmos_tot_N      ! bottom flux of tracer total_atmos_tot_N [mol/m2/s] if implicit_bottomflux=.true.
     real, dimension(:,:,:,:), pointer :: &
          total_atmos_ship_N          ! total_atmos_ship_N
     real, dimension(:,:), allocatable :: &
          btf_total_atmos_ship_N      ! bottom flux of tracer total_atmos_ship_N [mol/m2/s] if implicit_bottomflux=.true.
     real, dimension(:,:,:,:), pointer :: &
          t_n2_with_atmos_tot_N          ! dissolved molecular nitrogen; containing nitrogen from (total) atmospheric deposition
     real, dimension(:,:), allocatable :: &
          btf_t_n2_with_atmos_tot_N      ! bottom flux of tracer t_n2_with_atmos_tot_N [mol/m2/s] if implicit_bottomflux=.true.
     real, dimension(:,:,:,:), pointer :: &
          t_nh4_with_atmos_tot_N          ! ammonium; containing nitrogen from (total) atmospheric deposition
     real, dimension(:,:), allocatable :: &
          btf_t_nh4_with_atmos_tot_N      ! bottom flux of tracer t_nh4_with_atmos_tot_N [mol/m2/s] if implicit_bottomflux=.true.
     real, dimension(:,:,:,:), pointer :: &
          t_no3_with_atmos_tot_N          ! nitrate; containing nitrogen from (total) atmospheric deposition
     real, dimension(:,:), allocatable :: &
          btf_t_no3_with_atmos_tot_N      ! bottom flux of tracer t_no3_with_atmos_tot_N [mol/m2/s] if implicit_bottomflux=.true.
     real, dimension(:,:,:,:), pointer :: &
          t_spp_with_atmos_tot_N          ! small-cell phytoplankton; containing nitrogen from (total) atmospheric deposition
     real, dimension(:,:), allocatable :: &
          btf_t_spp_with_atmos_tot_N      ! bottom flux of tracer t_spp_with_atmos_tot_N [mol/m2/s] if implicit_bottomflux=.true.
     real, dimension(:,:,:,:), pointer :: &
          t_zoo_with_atmos_tot_N          ! zooplankton; containing nitrogen from (total) atmospheric deposition
     real, dimension(:,:), allocatable :: &
          btf_t_zoo_with_atmos_tot_N      ! bottom flux of tracer t_zoo_with_atmos_tot_N [mol/m2/s] if implicit_bottomflux=.true.
     real, dimension(:,:,:,:), pointer :: &
          t_n2_with_atmos_ship_N          ! dissolved molecular nitrogen; containing nitrogen from atmospheric deposition, which has been previously emitted by ships
     real, dimension(:,:), allocatable :: &
          btf_t_n2_with_atmos_ship_N      ! bottom flux of tracer t_n2_with_atmos_ship_N [mol/m2/s] if implicit_bottomflux=.true.
     real, dimension(:,:,:,:), pointer :: &
          t_nh4_with_atmos_ship_N          ! ammonium; containing nitrogen from atmospheric deposition, which has been previously emitted by ships
     real, dimension(:,:), allocatable :: &
          btf_t_nh4_with_atmos_ship_N      ! bottom flux of tracer t_nh4_with_atmos_ship_N [mol/m2/s] if implicit_bottomflux=.true.
     real, dimension(:,:,:,:), pointer :: &
          t_no3_with_atmos_ship_N          ! nitrate; containing nitrogen from atmospheric deposition, which has been previously emitted by ships
     real, dimension(:,:), allocatable :: &
          btf_t_no3_with_atmos_ship_N      ! bottom flux of tracer t_no3_with_atmos_ship_N [mol/m2/s] if implicit_bottomflux=.true.
     real, dimension(:,:,:,:), pointer :: &
          t_spp_with_atmos_ship_N          ! small-cell phytoplankton; containing nitrogen from atmospheric deposition, which has been previously emitted by ships
     real, dimension(:,:), allocatable :: &
          btf_t_spp_with_atmos_ship_N      ! bottom flux of tracer t_spp_with_atmos_ship_N [mol/m2/s] if implicit_bottomflux=.true.
     real, dimension(:,:,:,:), pointer :: &
          t_zoo_with_atmos_ship_N          ! zooplankton; containing nitrogen from atmospheric deposition, which has been previously emitted by ships
     real, dimension(:,:), allocatable :: &
          btf_t_zoo_with_atmos_ship_N      ! bottom flux of tracer t_zoo_with_atmos_ship_N [mol/m2/s] if implicit_bottomflux=.true.
     real, dimension(:,:,:,:), pointer :: &
          t_ipw                    ! suspended iron phosphate
     real, dimension(:,:), allocatable :: &
          btf_t_ipw                ! bottom flux of tracer t_ipw           [mol/m2/s] if implicit_bottomflux=.true.
     real, dimension(:,:,:,:), pointer :: &
          t_pocn_with_atmos_tot_N          ! nitrogen in particulate organic carbon in Redfield ratio; containing nitrogen from (total) atmospheric deposition
     real, dimension(:,:), allocatable :: &
          btf_t_pocn_with_atmos_tot_N      ! bottom flux of tracer t_pocn_with_atmos_tot_N [mol/m2/s] if implicit_bottomflux=.true.
     real, dimension(:,:,:,:), pointer :: &
          t_lpp_with_atmos_tot_N          ! large-cell phytoplankton; containing nitrogen from (total) atmospheric deposition
     real, dimension(:,:), allocatable :: &
          btf_t_lpp_with_atmos_tot_N      ! bottom flux of tracer t_lpp_with_atmos_tot_N [mol/m2/s] if implicit_bottomflux=.true.
     real, dimension(:,:,:,:), pointer :: &
          t_don_with_atmos_tot_N          ! nitrogen in dissolved organic carbon in Redfield ratio; containing nitrogen from (total) atmospheric deposition
     real, dimension(:,:), allocatable :: &
          btf_t_don_with_atmos_tot_N      ! bottom flux of tracer t_don_with_atmos_tot_N [mol/m2/s] if implicit_bottomflux=.true.
     real, dimension(:,:,:,:), pointer :: &
          t_cya_with_atmos_tot_N          ! diazotroph cyanobacteria; containing nitrogen from (total) atmospheric deposition
     real, dimension(:,:), allocatable :: &
          btf_t_cya_with_atmos_tot_N      ! bottom flux of tracer t_cya_with_atmos_tot_N [mol/m2/s] if implicit_bottomflux=.true.
     real, dimension(:,:,:,:), pointer :: &
          t_det_with_atmos_tot_N          ! detritus; containing nitrogen from (total) atmospheric deposition
     real, dimension(:,:), allocatable :: &
          btf_t_det_with_atmos_tot_N      ! bottom flux of tracer t_det_with_atmos_tot_N [mol/m2/s] if implicit_bottomflux=.true.
     real, dimension(:,:,:,:), pointer :: &
          t_lpp                    ! large-cell phytoplankton
     real, dimension(:,:), allocatable :: &
          btf_t_lpp                ! bottom flux of tracer t_lpp           [mol/m2/s] if implicit_bottomflux=.true.
     real, dimension(:,:,:,:), pointer :: &
          t_don                    ! nitrogen in dissolved organic carbon in Redfield ratio
     real, dimension(:,:), allocatable :: &
          btf_t_don                ! bottom flux of tracer t_don           [mol/m2/s] if implicit_bottomflux=.true.
     real, dimension(:,:,:,:), pointer :: &
          t_cya                    ! diazotroph cyanobacteria
     real, dimension(:,:), allocatable :: &
          btf_t_cya                ! bottom flux of tracer t_cya           [mol/m2/s] if implicit_bottomflux=.true.
     real, dimension(:,:,:,:), pointer :: &
          t_det                    ! detritus
     real, dimension(:,:), allocatable :: &
          btf_t_det                ! bottom flux of tracer t_det           [mol/m2/s] if implicit_bottomflux=.true.
     real, dimension(:,:,:,:), pointer :: &
          t_poc                    ! particulate organic carbon
     real, dimension(:,:), allocatable :: &
          btf_t_poc                ! bottom flux of tracer t_poc           [mol/m2/s] if implicit_bottomflux=.true.
     real, dimension(:,:,:,:), pointer :: &
          t_pocp                   ! phosphorus in particulate organic carbon in Redfield ratio
     real, dimension(:,:), allocatable :: &
          btf_t_pocp               ! bottom flux of tracer t_pocp          [mol/m2/s] if implicit_bottomflux=.true.
     real, dimension(:,:,:,:), pointer :: &
          t_pocn                   ! nitrogen in particulate organic carbon in Redfield ratio
     real, dimension(:,:), allocatable :: &
          btf_t_pocn               ! bottom flux of tracer t_pocn          [mol/m2/s] if implicit_bottomflux=.true.
     real, dimension(:,:,:,:), pointer :: &
          t_pocn_with_atmos_ship_N          ! nitrogen in particulate organic carbon in Redfield ratio; containing nitrogen from atmospheric deposition, which has been previously emitted by ships
     real, dimension(:,:), allocatable :: &
          btf_t_pocn_with_atmos_ship_N      ! bottom flux of tracer t_pocn_with_atmos_ship_N [mol/m2/s] if implicit_bottomflux=.true.
     real, dimension(:,:,:,:), pointer :: &
          t_lpp_with_atmos_ship_N          ! large-cell phytoplankton; containing nitrogen from atmospheric deposition, which has been previously emitted by ships
     real, dimension(:,:), allocatable :: &
          btf_t_lpp_with_atmos_ship_N      ! bottom flux of tracer t_lpp_with_atmos_ship_N [mol/m2/s] if implicit_bottomflux=.true.
     real, dimension(:,:,:,:), pointer :: &
          t_don_with_atmos_ship_N          ! nitrogen in dissolved organic carbon in Redfield ratio; containing nitrogen from atmospheric deposition, which has been previously emitted by ships
     real, dimension(:,:), allocatable :: &
          btf_t_don_with_atmos_ship_N      ! bottom flux of tracer t_don_with_atmos_ship_N [mol/m2/s] if implicit_bottomflux=.true.
     real, dimension(:,:,:,:), pointer :: &
          t_cya_with_atmos_ship_N          ! diazotroph cyanobacteria; containing nitrogen from atmospheric deposition, which has been previously emitted by ships
     real, dimension(:,:), allocatable :: &
          btf_t_cya_with_atmos_ship_N      ! bottom flux of tracer t_cya_with_atmos_ship_N [mol/m2/s] if implicit_bottomflux=.true.
     real, dimension(:,:,:,:), pointer :: &
          t_det_with_atmos_ship_N          ! detritus; containing nitrogen from atmospheric deposition, which has been previously emitted by ships
     real, dimension(:,:), allocatable :: &
          btf_t_det_with_atmos_ship_N      ! bottom flux of tracer t_det_with_atmos_ship_N [mol/m2/s] if implicit_bottomflux=.true.
!! TODO: workaround; these tracers are not automatically declared
     ! ersterer wird oben als Pointer allokiert
     real, dimension(:,:,:), allocatable   :: &
          sed_total_atmos_tot_N       ! total tagged element concentration in the sediment, porewater
     ! ersterer wird oben als Pointer allokiert
     real, dimension(:,:,:), allocatable   :: &
          sed_total_atmos_ship_N       ! total tagged element concentration in the sediment, porewater

     real, dimension(:,:), allocatable :: &
          t_sed                    ! fluffy layer concentration [mol/m2] of sediment detritus
     real, dimension(:,:), allocatable :: &
          t_ips                    ! fluffy layer concentration [mol/m2] of iron phosphate in sediment
     real, dimension(:,:), allocatable :: &
          t_sed_poc                ! fluffy layer concentration [mol/m2] of sediment particular carbon
     real, dimension(:,:), allocatable :: &
          t_sed_pocn               ! fluffy layer concentration [mol/m2] of sediment particular organic N+C
     real, dimension(:,:), allocatable :: &
          t_sed_pocp               ! fluffy layer concentration [mol/m2] of sediment particular organic P+C
     real, dimension(:,:), allocatable :: &
          total_atmos_tot_N_at_bottom          ! fluffy layer concentration [mol/m2] of total_atmos_tot_N_at_bottom
     real, dimension(:,:), allocatable :: &
          total_atmos_ship_N_at_bottom          ! fluffy layer concentration [mol/m2] of total_atmos_ship_N_at_bottom
     real, dimension(:,:), allocatable :: &
          t_sed_with_atmos_tot_N          ! fluffy layer concentration [mol/m2] of sediment detritus; containing nitrogen from (total) atmospheric deposition
     real, dimension(:,:), allocatable :: &
          t_sed_pocn_with_atmos_tot_N          ! fluffy layer concentration [mol/m2] of sediment particular organic N+C; containing nitrogen from (total) atmospheric deposition
     real, dimension(:,:), allocatable :: &
          t_sed_with_atmos_ship_N          ! fluffy layer concentration [mol/m2] of sediment detritus; containing nitrogen from atmospheric deposition, which has been previously emitted by ships
     real, dimension(:,:), allocatable :: &
          t_sed_pocn_with_atmos_ship_N          ! fluffy layer concentration [mol/m2] of sediment particular organic N+C; containing nitrogen from atmospheric deposition, which has been previously emitted by ships
     real, dimension(:,:,:), pointer :: &
          vmove_t_ipw           , & ! vertical movement [m/s]
          vdiff_t_ipw               ! vertical diffusion [m2/s]
     real, dimension(:,:,:), pointer :: &
          vmove_t_pocn_with_atmos_tot_N , & ! vertical movement [m/s]
          vdiff_t_pocn_with_atmos_tot_N     ! vertical diffusion [m2/s]
     real, dimension(:,:,:), pointer :: &
          vmove_t_lpp_with_atmos_tot_N , & ! vertical movement [m/s]
          vdiff_t_lpp_with_atmos_tot_N     ! vertical diffusion [m2/s]
     real, dimension(:,:,:), pointer :: &
          vmove_t_don_with_atmos_tot_N , & ! vertical movement [m/s]
          vdiff_t_don_with_atmos_tot_N     ! vertical diffusion [m2/s]
     real, dimension(:,:,:), pointer :: &
          vmove_t_cya_with_atmos_tot_N , & ! vertical movement [m/s]
          vdiff_t_cya_with_atmos_tot_N     ! vertical diffusion [m2/s]
     real, dimension(:,:,:), pointer :: &
          vmove_t_det_with_atmos_tot_N , & ! vertical movement [m/s]
          vdiff_t_det_with_atmos_tot_N     ! vertical diffusion [m2/s]
     real, dimension(:,:,:), pointer :: &
          vmove_t_lpp           , & ! vertical movement [m/s]
          vdiff_t_lpp               ! vertical diffusion [m2/s]
     real, dimension(:,:,:), pointer :: &
          vmove_t_don           , & ! vertical movement [m/s]
          vdiff_t_don               ! vertical diffusion [m2/s]
     real, dimension(:,:,:), pointer :: &
          vmove_t_cya           , & ! vertical movement [m/s]
          vdiff_t_cya               ! vertical diffusion [m2/s]
     real, dimension(:,:,:), pointer :: &
          vmove_t_det           , & ! vertical movement [m/s]
          vdiff_t_det               ! vertical diffusion [m2/s]
     real, dimension(:,:,:), pointer :: &
          vmove_t_poc           , & ! vertical movement [m/s]
          vdiff_t_poc               ! vertical diffusion [m2/s]
     real, dimension(:,:,:), pointer :: &
          vmove_t_pocp          , & ! vertical movement [m/s]
          vdiff_t_pocp              ! vertical diffusion [m2/s]
     real, dimension(:,:,:), pointer :: &
          vmove_t_pocn          , & ! vertical movement [m/s]
          vdiff_t_pocn              ! vertical diffusion [m2/s]
     real, dimension(:,:,:), pointer :: &
          vmove_t_pocn_with_atmos_ship_N , & ! vertical movement [m/s]
          vdiff_t_pocn_with_atmos_ship_N     ! vertical diffusion [m2/s]
     real, dimension(:,:,:), pointer :: &
          vmove_t_lpp_with_atmos_ship_N , & ! vertical movement [m/s]
          vdiff_t_lpp_with_atmos_ship_N     ! vertical diffusion [m2/s]
     real, dimension(:,:,:), pointer :: &
          vmove_t_don_with_atmos_ship_N , & ! vertical movement [m/s]
          vdiff_t_don_with_atmos_ship_N     ! vertical diffusion [m2/s]
     real, dimension(:,:,:), pointer :: &
          vmove_t_cya_with_atmos_ship_N , & ! vertical movement [m/s]
          vdiff_t_cya_with_atmos_ship_N     ! vertical diffusion [m2/s]
     real, dimension(:,:,:), pointer :: &
          vmove_t_det_with_atmos_ship_N , & ! vertical movement [m/s]
          vdiff_t_det_with_atmos_ship_N     ! vertical diffusion [m2/s]
     real, dimension(:,:,:), allocatable :: &
          tracer_array_intermediate_t_n2           , & ! for Runge-Kutta time step
          patankar_modification_t_n2                   ! for Runge-Kutta Patankar
     real, dimension(:,:,:), allocatable :: &
          tracer_array_intermediate_t_o2           , & ! for Runge-Kutta time step
          patankar_modification_t_o2                   ! for Runge-Kutta Patankar
     real, dimension(:,:,:), allocatable :: &
          tracer_array_intermediate_t_dic          , & ! for Runge-Kutta time step
          patankar_modification_t_dic                  ! for Runge-Kutta Patankar
     real, dimension(:,:,:), allocatable :: &
          tracer_array_intermediate_t_nh4          , & ! for Runge-Kutta time step
          patankar_modification_t_nh4                  ! for Runge-Kutta Patankar
     real, dimension(:,:,:), allocatable :: &
          tracer_array_intermediate_t_no3          , & ! for Runge-Kutta time step
          patankar_modification_t_no3                  ! for Runge-Kutta Patankar
     real, dimension(:,:,:), allocatable :: &
          tracer_array_intermediate_t_po4          , & ! for Runge-Kutta time step
          patankar_modification_t_po4                  ! for Runge-Kutta Patankar
     real, dimension(:,:,:), allocatable :: &
          tracer_array_intermediate_t_spp          , & ! for Runge-Kutta time step
          patankar_modification_t_spp                  ! for Runge-Kutta Patankar
     real, dimension(:,:,:), allocatable :: &
          tracer_array_intermediate_t_zoo          , & ! for Runge-Kutta time step
          patankar_modification_t_zoo                  ! for Runge-Kutta Patankar
     real, dimension(:,:,:), allocatable :: &
          tracer_array_intermediate_t_h2s          , & ! for Runge-Kutta time step
          patankar_modification_t_h2s                  ! for Runge-Kutta Patankar
     real, dimension(:,:,:), allocatable :: &
          tracer_array_intermediate_t_sul          , & ! for Runge-Kutta time step
          patankar_modification_t_sul                  ! for Runge-Kutta Patankar
     real, dimension(:,:,:), allocatable :: &
          tracer_array_intermediate_t_alk          , & ! for Runge-Kutta time step
          patankar_modification_t_alk                  ! for Runge-Kutta Patankar
     real, dimension(:,:,:), allocatable :: &
          tracer_array_intermediate_t_doc          , & ! for Runge-Kutta time step
          patankar_modification_t_doc                  ! for Runge-Kutta Patankar
     real, dimension(:,:,:), allocatable :: &
          tracer_array_intermediate_t_dop          , & ! for Runge-Kutta time step
          patankar_modification_t_dop                  ! for Runge-Kutta Patankar
     real, dimension(:,:,:), allocatable :: &
          tracer_array_intermediate_total_atmos_tot_N, & ! for Runge-Kutta time step
          patankar_modification_total_atmos_tot_N        ! for Runge-Kutta Patankar
     real, dimension(:,:,:), allocatable :: &
          tracer_array_intermediate_total_atmos_ship_N, & ! for Runge-Kutta time step
          patankar_modification_total_atmos_ship_N        ! for Runge-Kutta Patankar
     real, dimension(:,:,:), allocatable :: &
          tracer_array_intermediate_t_n2_with_atmos_tot_N, & ! for Runge-Kutta time step
          patankar_modification_t_n2_with_atmos_tot_N        ! for Runge-Kutta Patankar
     real, dimension(:,:,:), allocatable :: &
          tracer_array_intermediate_t_nh4_with_atmos_tot_N, & ! for Runge-Kutta time step
          patankar_modification_t_nh4_with_atmos_tot_N        ! for Runge-Kutta Patankar
     real, dimension(:,:,:), allocatable :: &
          tracer_array_intermediate_t_no3_with_atmos_tot_N, & ! for Runge-Kutta time step
          patankar_modification_t_no3_with_atmos_tot_N        ! for Runge-Kutta Patankar
     real, dimension(:,:,:), allocatable :: &
          tracer_array_intermediate_t_spp_with_atmos_tot_N, & ! for Runge-Kutta time step
          patankar_modification_t_spp_with_atmos_tot_N        ! for Runge-Kutta Patankar
     real, dimension(:,:,:), allocatable :: &
          tracer_array_intermediate_t_zoo_with_atmos_tot_N, & ! for Runge-Kutta time step
          patankar_modification_t_zoo_with_atmos_tot_N        ! for Runge-Kutta Patankar
     real, dimension(:,:,:), allocatable :: &
          tracer_array_intermediate_t_n2_with_atmos_ship_N, & ! for Runge-Kutta time step
          patankar_modification_t_n2_with_atmos_ship_N        ! for Runge-Kutta Patankar
     real, dimension(:,:,:), allocatable :: &
          tracer_array_intermediate_t_nh4_with_atmos_ship_N, & ! for Runge-Kutta time step
          patankar_modification_t_nh4_with_atmos_ship_N        ! for Runge-Kutta Patankar
     real, dimension(:,:,:), allocatable :: &
          tracer_array_intermediate_t_no3_with_atmos_ship_N, & ! for Runge-Kutta time step
          patankar_modification_t_no3_with_atmos_ship_N        ! for Runge-Kutta Patankar
     real, dimension(:,:,:), allocatable :: &
          tracer_array_intermediate_t_spp_with_atmos_ship_N, & ! for Runge-Kutta time step
          patankar_modification_t_spp_with_atmos_ship_N        ! for Runge-Kutta Patankar
     real, dimension(:,:,:), allocatable :: &
          tracer_array_intermediate_t_zoo_with_atmos_ship_N, & ! for Runge-Kutta time step
          patankar_modification_t_zoo_with_atmos_ship_N        ! for Runge-Kutta Patankar
     real, dimension(:,:,:), allocatable :: &
          tracer_array_intermediate_t_ipw          , & ! for Runge-Kutta time step
          patankar_modification_t_ipw                  ! for Runge-Kutta Patankar
     real, dimension(:,:,:), allocatable :: &
          tracer_array_intermediate_t_pocn_with_atmos_tot_N, & ! for Runge-Kutta time step
          patankar_modification_t_pocn_with_atmos_tot_N        ! for Runge-Kutta Patankar
     real, dimension(:,:,:), allocatable :: &
          tracer_array_intermediate_t_lpp_with_atmos_tot_N, & ! for Runge-Kutta time step
          patankar_modification_t_lpp_with_atmos_tot_N        ! for Runge-Kutta Patankar
     real, dimension(:,:,:), allocatable :: &
          tracer_array_intermediate_t_don_with_atmos_tot_N, & ! for Runge-Kutta time step
          patankar_modification_t_don_with_atmos_tot_N        ! for Runge-Kutta Patankar
     real, dimension(:,:,:), allocatable :: &
          tracer_array_intermediate_t_cya_with_atmos_tot_N, & ! for Runge-Kutta time step
          patankar_modification_t_cya_with_atmos_tot_N        ! for Runge-Kutta Patankar
     real, dimension(:,:,:), allocatable :: &
          tracer_array_intermediate_t_det_with_atmos_tot_N, & ! for Runge-Kutta time step
          patankar_modification_t_det_with_atmos_tot_N        ! for Runge-Kutta Patankar
     real, dimension(:,:,:), allocatable :: &
          tracer_array_intermediate_t_lpp          , & ! for Runge-Kutta time step
          patankar_modification_t_lpp                  ! for Runge-Kutta Patankar
     real, dimension(:,:,:), allocatable :: &
          tracer_array_intermediate_t_don          , & ! for Runge-Kutta time step
          patankar_modification_t_don                  ! for Runge-Kutta Patankar
     real, dimension(:,:,:), allocatable :: &
          tracer_array_intermediate_t_cya          , & ! for Runge-Kutta time step
          patankar_modification_t_cya                  ! for Runge-Kutta Patankar
     real, dimension(:,:,:), allocatable :: &
          tracer_array_intermediate_t_det          , & ! for Runge-Kutta time step
          patankar_modification_t_det                  ! for Runge-Kutta Patankar
     real, dimension(:,:,:), allocatable :: &
          tracer_array_intermediate_t_poc          , & ! for Runge-Kutta time step
          patankar_modification_t_poc                  ! for Runge-Kutta Patankar
     real, dimension(:,:,:), allocatable :: &
          tracer_array_intermediate_t_pocp         , & ! for Runge-Kutta time step
          patankar_modification_t_pocp                 ! for Runge-Kutta Patankar
     real, dimension(:,:,:), allocatable :: &
          tracer_array_intermediate_t_pocn         , & ! for Runge-Kutta time step
          patankar_modification_t_pocn                 ! for Runge-Kutta Patankar
     real, dimension(:,:,:), allocatable :: &
          tracer_array_intermediate_t_pocn_with_atmos_ship_N, & ! for Runge-Kutta time step
          patankar_modification_t_pocn_with_atmos_ship_N        ! for Runge-Kutta Patankar
     real, dimension(:,:,:), allocatable :: &
          tracer_array_intermediate_t_lpp_with_atmos_ship_N, & ! for Runge-Kutta time step
          patankar_modification_t_lpp_with_atmos_ship_N        ! for Runge-Kutta Patankar
     real, dimension(:,:,:), allocatable :: &
          tracer_array_intermediate_t_don_with_atmos_ship_N, & ! for Runge-Kutta time step
          patankar_modification_t_don_with_atmos_ship_N        ! for Runge-Kutta Patankar
     real, dimension(:,:,:), allocatable :: &
          tracer_array_intermediate_t_cya_with_atmos_ship_N, & ! for Runge-Kutta time step
          patankar_modification_t_cya_with_atmos_ship_N        ! for Runge-Kutta Patankar
     real, dimension(:,:,:), allocatable :: &
          tracer_array_intermediate_t_det_with_atmos_ship_N, & ! for Runge-Kutta time step
          patankar_modification_t_det_with_atmos_ship_N        ! for Runge-Kutta Patankar
     real, dimension(:,:), allocatable ::   &
          tracer_array_intermediate_t_sed          , & ! for Runge-Kutta time step
          patankar_modification_t_sed                  ! for Runge-Kutta Patankar
     real, dimension(:,:), allocatable ::   &
          tracer_array_intermediate_t_ips          , & ! for Runge-Kutta time step
          patankar_modification_t_ips                  ! for Runge-Kutta Patankar
     real, dimension(:,:), allocatable ::   &
          tracer_array_intermediate_t_sed_poc      , & ! for Runge-Kutta time step
          patankar_modification_t_sed_poc              ! for Runge-Kutta Patankar
     real, dimension(:,:), allocatable ::   &
          tracer_array_intermediate_t_sed_pocn     , & ! for Runge-Kutta time step
          patankar_modification_t_sed_pocn             ! for Runge-Kutta Patankar
     real, dimension(:,:), allocatable ::   &
          tracer_array_intermediate_t_sed_pocp     , & ! for Runge-Kutta time step
          patankar_modification_t_sed_pocp             ! for Runge-Kutta Patankar
     real, dimension(:,:), allocatable ::   &
          tracer_array_intermediate_total_atmos_tot_N_at_bottom, & ! for Runge-Kutta time step
          patankar_modification_total_atmos_tot_N_at_bottom        ! for Runge-Kutta Patankar
     real, dimension(:,:), allocatable ::   &
          tracer_array_intermediate_total_atmos_ship_N_at_bottom, & ! for Runge-Kutta time step
          patankar_modification_total_atmos_ship_N_at_bottom        ! for Runge-Kutta Patankar
     real, dimension(:,:), allocatable ::   &
          tracer_array_intermediate_t_sed_with_atmos_tot_N, & ! for Runge-Kutta time step
          patankar_modification_t_sed_with_atmos_tot_N        ! for Runge-Kutta Patankar
     real, dimension(:,:), allocatable ::   &
          tracer_array_intermediate_t_sed_pocn_with_atmos_tot_N, & ! for Runge-Kutta time step
          patankar_modification_t_sed_pocn_with_atmos_tot_N        ! for Runge-Kutta Patankar
     real, dimension(:,:), allocatable ::   &
          tracer_array_intermediate_t_sed_with_atmos_ship_N, & ! for Runge-Kutta time step
          patankar_modification_t_sed_with_atmos_ship_N        ! for Runge-Kutta Patankar
     real, dimension(:,:), allocatable ::   &
          tracer_array_intermediate_t_sed_pocn_with_atmos_ship_N, & ! for Runge-Kutta time step
          patankar_modification_t_sed_pocn_with_atmos_ship_N        ! for Runge-Kutta Patankar

     real    :: gamma_1                  ! constant for opacity contribution of chlorophyll [kg/g/m]
     real    :: rho_0                    ! water density for sediment module [kg/m3]
     integer :: &
          id_p_no3_assim_lpp , &                  ! diag id for assimilation of nitrate by large-cell phytoplankton
          id_p_nh4_assim_lpp , &                  ! diag id for assimilation of ammonium by large-cell phytoplankton
          id_p_no3_assim_spp , &                  ! diag id for assimilation of nitrate by small-cell phytoplankton
          id_p_nh4_assim_spp , &                  ! diag id for assimilation of ammonium by small-cell phytoplankton
          id_p_n2_assim_cya  , &                  ! diag id for fixation of dinitrogen by diazotroph cyanobacteria
          id_p_assim_lpp_doc , &                  ! diag id for Production of DOC by LPP
          id_p_assim_spp_doc , &                  ! diag id for Production of DOC by SPP
          id_p_assim_cya_doc , &                  ! diag id for Production of POC by CYA
          id_p_assim_lpp_dop , &                  ! diag id for Production of DOP by LPP
          id_p_assim_spp_dop , &                  ! diag id for Production of DOP by SPP
          id_p_nh4_assim_lpp_don , &                  ! diag id for Production of DON by LPP
          id_p_no3_assim_lpp_don , &                  ! diag id for Production of DON by LPP
          id_p_nh4_assim_spp_don , &                  ! diag id for Production of DON by SPP
          id_p_no3_assim_spp_don , &                  ! diag id for Production of DON by SPP
          id_p_poc_resp      , &                  ! diag id for respiration of POC
          id_p_poc_denit     , &                  ! diag id for recycling of POC using nitrate (denitrification)
          id_p_poc_sulf      , &                  ! diag id for Mineralization of POC, e-acceptor sulfate (sulfate reduction)
          id_p_pocp_resp     , &                  ! diag id for respiration of POCP
          id_p_pocp_denit    , &                  ! diag id for recycling of POC using nitrate (denitrification)
          id_p_pocp_sulf     , &                  ! diag id for Mineralization of POC, e-acceptor sulfate (sulfate reduction)
          id_p_pocn_resp     , &                  ! diag id for respiration of POCN
          id_p_pocn_denit_noN2 , &                  ! diag id for recycling of POCN using nitrate (denitrification)
          id_p_pocn_denit_wiN2 , &                  ! diag id for recycling of POCN using nitrate (denitrification)
          id_p_pocn_sulf     , &                  ! diag id for Mineralization of POCN, e-acceptor sulfate (sulfate reduction)
          id_p_lpp_graz_zoo  , &                  ! diag id for grazing of zooplankton eating large-cell phytoplankton
          id_p_spp_graz_zoo  , &                  ! diag id for grazing of zooplankton eating small-cell phytoplankton
          id_p_cya_graz_zoo  , &                  ! diag id for grazing of zooplankton eating diazotroph cyanobacteria
          id_p_lpp_resp_nh4  , &                  ! diag id for respiration of large-cell phytoplankton
          id_p_spp_resp_nh4  , &                  ! diag id for respiration of small-cell phytoplankton
          id_p_cya_resp_nh4  , &                  ! diag id for respiration of diazotroph cyanobacteria
          id_p_zoo_resp_nh4  , &                  ! diag id for respiration of zooplankton
          id_p_lpp_mort_det  , &                  ! diag id for mortality of large-cell phytoplankton
          id_p_spp_mort_det  , &                  ! diag id for mortality of small-scale phytoplankton
          id_p_cya_mort_det  , &                  ! diag id for mortality of diazotroph cyanobacteria
          id_p_cya_mort_det_diff , &                  ! diag id for mortality of diazotroph cyanobacteria due to strong turbulence
          id_p_zoo_mort_det  , &                  ! diag id for mortality of zooplankton
          id_p_nh4_nit_no3   , &                  ! diag id for nitrification
          id_p_det_resp_nh4  , &                  ! diag id for recycling of detritus using oxygen (respiration)
          id_p_det_denit_nh4 , &                  ! diag id for recycling of detritus using nitrate (denitrification)
          id_p_det_sulf_nh4  , &                  ! diag id for recycling of detritus using sulfate (sulfate reduction)
          id_p_sed_resp_nh4  , &                  ! diag id for recycling of sedimentary detritus to ammonium using oxygen (respiration)
          id_p_nh4_nitdenit_n2 , &                  ! diag id for coupled nitrification and denitrification after mineralization of detritus in oxic sediments
          id_p_sed_denit_nh4_noN2 , &                  ! diag id for recycling of sedimentary detritus to ammonium using nitrate (denitrification)
          id_p_sed_denit_nh4_wiN2 , &                  ! diag id for recycling of sedimentary detritus to ammonium using nitrate (denitrification)
          id_p_sed_sulf_nh4  , &                  ! diag id for recycling of sedimentary detritus to ammonium using sulfate (sulfate reduction)
          id_p_sed_poc_resp  , &                  ! diag id for recycling of sedimentary poc to dic using oxygen (respiration)
          id_p_sed_poc_denit , &                  ! diag id for recycling of sedimentary poc to dic using nitrate (denitrification)
          id_p_sed_poc_sulf  , &                  ! diag id for recycling of sedimentary poc to dic using sulfate (sulfate reduction)
          id_p_po4_retent_ips , &                  ! diag id for retention of phosphate in the sediment under oxic conditions
          id_p_ips_liber_po4 , &                  ! diag id for liberation of phosphate from the sediment under anoxic conditions
          id_p_h2s_oxo2_sul  , &                  ! diag id for oxidation of hydrogen sulfide with oxygen
          id_p_h2s_oxno3_sul , &                  ! diag id for oxidation of hydrogen sulfide with nitrate
          id_p_sul_oxo2_so4  , &                  ! diag id for oxidation of elemental sulfur with oxygen
          id_p_sul_oxno3_so4 , &                  ! diag id for oxidation of elemental sulfur with nitrate
          id_p_det_sedi_sed  , &                  ! diag id for detritus sedimentation
          id_p_ipw_sedi_ips  , &                  ! diag id for sedimentation of iron PO4
          id_p_poc_sedi_sed  , &                  ! diag id for poc sedimentation
          id_p_pocn_sedi_sed , &                  ! diag id for pocn sedimentation
          id_p_pocp_sedi_sed , &                  ! diag id for pocp sedimentation
          id_p_sed_ero_det   , &                  ! diag id for sedimentary detritus erosion
          id_p_ips_ero_ipw   , &                  ! diag id for erosion of iron PO4
          id_p_sed_ero_poc   , &                  ! diag id for sedimentary poc erosion
          id_p_sed_ero_pocn  , &                  ! diag id for sedimentary pocn erosion
          id_p_sed_ero_pocp  , &                  ! diag id for sedimentary pocp erosion
          id_p_sed_biores_det , &                  ! diag id for bio resuspension of sedimentary detritus
          id_p_ips_biores_ipw , &                  ! diag id for bio resuspension of iron PO4
          id_p_sed_biores_poc , &                  ! diag id for bio resuspension of sedimentary poc
          id_p_sed_biores_pocn , &                  ! diag id for bio resuspension of sedimentary pocn
          id_p_sed_biores_pocp , &                  ! diag id for bio resuspension of sedimentary pocp
          id_p_sed_burial    , &                  ! diag id for burial of detritus deeper than max_sed
          id_p_ips_burial    , &                  ! diag id for burial of iron PO4
          id_p_poc_burial    , &                  ! diag id for burial of poc deeper than max_sed
          id_p_pocn_burial   , &                  ! diag id for burial of pocn deeper than max_sed
          id_p_pocp_burial   , &                  ! diag id for burial of pocp deeper than max_sed
          id_p_sed_pocn_resp , &                  ! diag id for recycling of sedimentary pocn to dic and NH4 using oxygen (respiration)
          id_p_sed_pocp_resp , &                  ! diag id for recycling of sedimentary pocp to dic and PO4 using oxygen (respiration)
          id_p_sed_pocn_denit_noN2 , &                  ! diag id for recycling of sedimentary pocn to dic and NH4 using nitrate (denitrification)
          id_p_sed_pocn_denit_wiN2 , &                  ! diag id for recycling of sedimentary pocn to dic and NH4 using nitrate (denitrification)
          id_p_sed_pocp_denit , &                  ! diag id for recycling of sedimentary pocp to dic and PO4 using nitrate (denitrification)
          id_p_sed_pocn_sulf , &                  ! diag id for recycling of sedimentary pocn to dic and NH4 using sulfate (sulfate reduction)
          id_p_sed_pocp_sulf , &                  ! diag id for recycling of sedimentary pocp to dic and PO4 using sulfate (sulfate reduction)
          id_p_nh4_nitdenit_pocn_n2 , &                  ! diag id for coupled nitrification and denitrification after mineralization of pocn-detritus in oxic sediments
          id_p_doc2pco       , &                  ! diag id for particle formation from DOC
          id_p_dop2pocp      , &                  ! diag id for particle formation from DOP
          id_p_don2pocn      , &                  ! diag id for particle formation from DON
          id_p_doc_resp      , &                  ! diag id for respiration of DOC
          id_p_doc_denit     , &                  ! diag id for recycling of DOC using nitrate (denitrification)
          id_p_doc_sulf      , &                  ! diag id for Mineralization of DOC, e-acceptor sulfate (sulfate reduction)
          id_p_dop_resp      , &                  ! diag id for respiration of DOP
          id_p_dop_denit     , &                  ! diag id for recycling of DOP using nitrate (denitrification)
          id_p_dop_sulf      , &                  ! diag id for Mineralization of DOP, e-acceptor sulfate (sulfate reduction)
          id_p_don_resp      , &                  ! diag id for respiration of DON
          id_p_don_denit_noN2 , &                  ! diag id for recycling of DON using nitrate (denitrification)
          id_p_don_denit_wiN2 , &                  ! diag id for recycling of DON using nitrate (denitrification)
          id_p_don_sulf      , &                  ! diag id for Mineralization of DON, e-acceptor sulfate (sulfate reduction)
          id_p_no3_assim_lpp_atmos_tot_N , &                  ! diag id for assimilation of nitrate by large-cell phytoplankton; sub-process for atmos_tot nitrogen
          id_p_nh4_assim_lpp_atmos_tot_N , &                  ! diag id for assimilation of ammonium by large-cell phytoplankton; sub-process for atmos_tot nitrogen
          id_p_no3_assim_spp_atmos_tot_N , &                  ! diag id for assimilation of nitrate by small-cell phytoplankton; sub-process for atmos_tot nitrogen
          id_p_nh4_assim_spp_atmos_tot_N , &                  ! diag id for assimilation of ammonium by small-cell phytoplankton; sub-process for atmos_tot nitrogen
          id_p_nh4_assim_lpp_don_atmos_tot_N , &                  ! diag id for Production of DON by LPP; sub-process for atmos_tot nitrogen
          id_p_no3_assim_lpp_don_atmos_tot_N , &                  ! diag id for Production of DON by LPP; sub-process for atmos_tot nitrogen
          id_p_nh4_assim_spp_don_atmos_tot_N , &                  ! diag id for Production of DON by SPP; sub-process for atmos_tot nitrogen
          id_p_no3_assim_spp_don_atmos_tot_N , &                  ! diag id for Production of DON by SPP; sub-process for atmos_tot nitrogen
          id_p_pocn_resp_atmos_tot_N , &                  ! diag id for respiration of POCN; sub-process for atmos_tot nitrogen
          id_p_pocn_denit_noN2_atmos_tot_N , &                  ! diag id for recycling of POCN using nitrate (denitrification); sub-process for atmos_tot nitrogen
          id_p_pocn_sulf_atmos_tot_N , &                  ! diag id for Mineralization of POCN, e-acceptor sulfate (sulfate reduction); sub-process for atmos_tot nitrogen
          id_p_lpp_graz_zoo_atmos_tot_N , &                  ! diag id for grazing of zooplankton eating large-cell phytoplankton; sub-process for atmos_tot nitrogen
          id_p_spp_graz_zoo_atmos_tot_N , &                  ! diag id for grazing of zooplankton eating small-cell phytoplankton; sub-process for atmos_tot nitrogen
          id_p_cya_graz_zoo_atmos_tot_N , &                  ! diag id for grazing of zooplankton eating diazotroph cyanobacteria; sub-process for atmos_tot nitrogen
          id_p_lpp_resp_nh4_atmos_tot_N , &                  ! diag id for respiration of large-cell phytoplankton; sub-process for atmos_tot nitrogen
          id_p_spp_resp_nh4_atmos_tot_N , &                  ! diag id for respiration of small-cell phytoplankton; sub-process for atmos_tot nitrogen
          id_p_cya_resp_nh4_atmos_tot_N , &                  ! diag id for respiration of diazotroph cyanobacteria; sub-process for atmos_tot nitrogen
          id_p_zoo_resp_nh4_atmos_tot_N , &                  ! diag id for respiration of zooplankton; sub-process for atmos_tot nitrogen
          id_p_lpp_mort_det_atmos_tot_N , &                  ! diag id for mortality of large-cell phytoplankton; sub-process for atmos_tot nitrogen
          id_p_spp_mort_det_atmos_tot_N , &                  ! diag id for mortality of small-scale phytoplankton; sub-process for atmos_tot nitrogen
          id_p_cya_mort_det_atmos_tot_N , &                  ! diag id for mortality of diazotroph cyanobacteria; sub-process for atmos_tot nitrogen
          id_p_cya_mort_det_diff_atmos_tot_N , &                  ! diag id for mortality of diazotroph cyanobacteria due to strong turbulence; sub-process for atmos_tot nitrogen
          id_p_zoo_mort_det_atmos_tot_N , &                  ! diag id for mortality of zooplankton; sub-process for atmos_tot nitrogen
          id_p_nh4_nit_no3_atmos_tot_N , &                  ! diag id for nitrification; sub-process for atmos_tot nitrogen
          id_p_det_resp_nh4_atmos_tot_N , &                  ! diag id for recycling of detritus using oxygen (respiration); sub-process for atmos_tot nitrogen
          id_p_det_sulf_nh4_atmos_tot_N , &                  ! diag id for recycling of detritus using sulfate (sulfate reduction); sub-process for atmos_tot nitrogen
          id_p_sed_resp_nh4_atmos_tot_N , &                  ! diag id for recycling of sedimentary detritus to ammonium using oxygen (respiration); sub-process for atmos_tot nitrogen
          id_p_sed_denit_nh4_noN2_atmos_tot_N , &                  ! diag id for recycling of sedimentary detritus to ammonium using nitrate (denitrification); sub-process for atmos_tot nitrogen
          id_p_sed_sulf_nh4_atmos_tot_N , &                  ! diag id for recycling of sedimentary detritus to ammonium using sulfate (sulfate reduction); sub-process for atmos_tot nitrogen
          id_p_det_sedi_sed_atmos_tot_N , &                  ! diag id for detritus sedimentation; sub-process for atmos_tot nitrogen
          id_p_pocn_sedi_sed_atmos_tot_N , &                  ! diag id for pocn sedimentation; sub-process for atmos_tot nitrogen
          id_p_sed_ero_det_atmos_tot_N , &                  ! diag id for sedimentary detritus erosion; sub-process for atmos_tot nitrogen
          id_p_sed_ero_pocn_atmos_tot_N , &                  ! diag id for sedimentary pocn erosion; sub-process for atmos_tot nitrogen
          id_p_sed_biores_det_atmos_tot_N , &                  ! diag id for bio resuspension of sedimentary detritus; sub-process for atmos_tot nitrogen
          id_p_sed_biores_pocn_atmos_tot_N , &                  ! diag id for bio resuspension of sedimentary pocn; sub-process for atmos_tot nitrogen
          id_p_sed_burial_atmos_tot_N , &                  ! diag id for burial of detritus deeper than max_sed; sub-process for atmos_tot nitrogen
          id_p_pocn_burial_atmos_tot_N , &                  ! diag id for burial of pocn deeper than max_sed; sub-process for atmos_tot nitrogen
          id_p_sed_pocn_resp_atmos_tot_N , &                  ! diag id for recycling of sedimentary pocn to dic and NH4 using oxygen (respiration); sub-process for atmos_tot nitrogen
          id_p_sed_pocn_denit_noN2_atmos_tot_N , &                  ! diag id for recycling of sedimentary pocn to dic and NH4 using nitrate (denitrification); sub-process for atmos_tot nitrogen
          id_p_sed_pocn_sulf_atmos_tot_N , &                  ! diag id for recycling of sedimentary pocn to dic and NH4 using sulfate (sulfate reduction); sub-process for atmos_tot nitrogen
          id_p_don2pocn_atmos_tot_N , &                  ! diag id for particle formation from DON; sub-process for atmos_tot nitrogen
          id_p_don_resp_atmos_tot_N , &                  ! diag id for respiration of DON; sub-process for atmos_tot nitrogen
          id_p_don_denit_noN2_atmos_tot_N , &                  ! diag id for recycling of DON using nitrate (denitrification); sub-process for atmos_tot nitrogen
          id_p_don_sulf_atmos_tot_N , &                  ! diag id for Mineralization of DON, e-acceptor sulfate (sulfate reduction); sub-process for atmos_tot nitrogen
          id_p_no3_assim_lpp_atmos_ship_N , &                  ! diag id for assimilation of nitrate by large-cell phytoplankton; sub-process for atmos_ship nitrogen
          id_p_nh4_assim_lpp_atmos_ship_N , &                  ! diag id for assimilation of ammonium by large-cell phytoplankton; sub-process for atmos_ship nitrogen
          id_p_no3_assim_spp_atmos_ship_N , &                  ! diag id for assimilation of nitrate by small-cell phytoplankton; sub-process for atmos_ship nitrogen
          id_p_nh4_assim_spp_atmos_ship_N , &                  ! diag id for assimilation of ammonium by small-cell phytoplankton; sub-process for atmos_ship nitrogen
          id_p_nh4_assim_lpp_don_atmos_ship_N , &                  ! diag id for Production of DON by LPP; sub-process for atmos_ship nitrogen
          id_p_no3_assim_lpp_don_atmos_ship_N , &                  ! diag id for Production of DON by LPP; sub-process for atmos_ship nitrogen
          id_p_nh4_assim_spp_don_atmos_ship_N , &                  ! diag id for Production of DON by SPP; sub-process for atmos_ship nitrogen
          id_p_no3_assim_spp_don_atmos_ship_N , &                  ! diag id for Production of DON by SPP; sub-process for atmos_ship nitrogen
          id_p_pocn_resp_atmos_ship_N , &                  ! diag id for respiration of POCN; sub-process for atmos_ship nitrogen
          id_p_pocn_denit_noN2_atmos_ship_N , &                  ! diag id for recycling of POCN using nitrate (denitrification); sub-process for atmos_ship nitrogen
          id_p_pocn_sulf_atmos_ship_N , &                  ! diag id for Mineralization of POCN, e-acceptor sulfate (sulfate reduction); sub-process for atmos_ship nitrogen
          id_p_lpp_graz_zoo_atmos_ship_N , &                  ! diag id for grazing of zooplankton eating large-cell phytoplankton; sub-process for atmos_ship nitrogen
          id_p_spp_graz_zoo_atmos_ship_N , &                  ! diag id for grazing of zooplankton eating small-cell phytoplankton; sub-process for atmos_ship nitrogen
          id_p_cya_graz_zoo_atmos_ship_N , &                  ! diag id for grazing of zooplankton eating diazotroph cyanobacteria; sub-process for atmos_ship nitrogen
          id_p_lpp_resp_nh4_atmos_ship_N , &                  ! diag id for respiration of large-cell phytoplankton; sub-process for atmos_ship nitrogen
          id_p_spp_resp_nh4_atmos_ship_N , &                  ! diag id for respiration of small-cell phytoplankton; sub-process for atmos_ship nitrogen
          id_p_cya_resp_nh4_atmos_ship_N , &                  ! diag id for respiration of diazotroph cyanobacteria; sub-process for atmos_ship nitrogen
          id_p_zoo_resp_nh4_atmos_ship_N , &                  ! diag id for respiration of zooplankton; sub-process for atmos_ship nitrogen
          id_p_lpp_mort_det_atmos_ship_N , &                  ! diag id for mortality of large-cell phytoplankton; sub-process for atmos_ship nitrogen
          id_p_spp_mort_det_atmos_ship_N , &                  ! diag id for mortality of small-scale phytoplankton; sub-process for atmos_ship nitrogen
          id_p_cya_mort_det_atmos_ship_N , &                  ! diag id for mortality of diazotroph cyanobacteria; sub-process for atmos_ship nitrogen
          id_p_cya_mort_det_diff_atmos_ship_N , &                  ! diag id for mortality of diazotroph cyanobacteria due to strong turbulence; sub-process for atmos_ship nitrogen
          id_p_zoo_mort_det_atmos_ship_N , &                  ! diag id for mortality of zooplankton; sub-process for atmos_ship nitrogen
          id_p_nh4_nit_no3_atmos_ship_N , &                  ! diag id for nitrification; sub-process for atmos_ship nitrogen
          id_p_det_resp_nh4_atmos_ship_N , &                  ! diag id for recycling of detritus using oxygen (respiration); sub-process for atmos_ship nitrogen
          id_p_det_sulf_nh4_atmos_ship_N , &                  ! diag id for recycling of detritus using sulfate (sulfate reduction); sub-process for atmos_ship nitrogen
          id_p_sed_resp_nh4_atmos_ship_N , &                  ! diag id for recycling of sedimentary detritus to ammonium using oxygen (respiration); sub-process for atmos_ship nitrogen
          id_p_sed_denit_nh4_noN2_atmos_ship_N , &                  ! diag id for recycling of sedimentary detritus to ammonium using nitrate (denitrification); sub-process for atmos_ship nitrogen
          id_p_sed_sulf_nh4_atmos_ship_N , &                  ! diag id for recycling of sedimentary detritus to ammonium using sulfate (sulfate reduction); sub-process for atmos_ship nitrogen
          id_p_det_sedi_sed_atmos_ship_N , &                  ! diag id for detritus sedimentation; sub-process for atmos_ship nitrogen
          id_p_pocn_sedi_sed_atmos_ship_N , &                  ! diag id for pocn sedimentation; sub-process for atmos_ship nitrogen
          id_p_sed_ero_det_atmos_ship_N , &                  ! diag id for sedimentary detritus erosion; sub-process for atmos_ship nitrogen
          id_p_sed_ero_pocn_atmos_ship_N , &                  ! diag id for sedimentary pocn erosion; sub-process for atmos_ship nitrogen
          id_p_sed_biores_det_atmos_ship_N , &                  ! diag id for bio resuspension of sedimentary detritus; sub-process for atmos_ship nitrogen
          id_p_sed_biores_pocn_atmos_ship_N , &                  ! diag id for bio resuspension of sedimentary pocn; sub-process for atmos_ship nitrogen
          id_p_sed_burial_atmos_ship_N , &                  ! diag id for burial of detritus deeper than max_sed; sub-process for atmos_ship nitrogen
          id_p_pocn_burial_atmos_ship_N , &                  ! diag id for burial of pocn deeper than max_sed; sub-process for atmos_ship nitrogen
          id_p_sed_pocn_resp_atmos_ship_N , &                  ! diag id for recycling of sedimentary pocn to dic and NH4 using oxygen (respiration); sub-process for atmos_ship nitrogen
          id_p_sed_pocn_denit_noN2_atmos_ship_N , &                  ! diag id for recycling of sedimentary pocn to dic and NH4 using nitrate (denitrification); sub-process for atmos_ship nitrogen
          id_p_sed_pocn_sulf_atmos_ship_N , &                  ! diag id for recycling of sedimentary pocn to dic and NH4 using sulfate (sulfate reduction); sub-process for atmos_ship nitrogen
          id_p_don2pocn_atmos_ship_N , &                  ! diag id for particle formation from DON; sub-process for atmos_ship nitrogen
          id_p_don_resp_atmos_ship_N , &                  ! diag id for respiration of DON; sub-process for atmos_ship nitrogen
          id_p_don_denit_noN2_atmos_ship_N , &                  ! diag id for recycling of DON using nitrate (denitrification); sub-process for atmos_ship nitrogen
          id_p_don_sulf_atmos_ship_N , &                  ! diag id for Mineralization of DON, e-acceptor sulfate (sulfate reduction); sub-process for atmos_ship nitrogen
          id_temp_k          , &                  ! diag id for absolute temperature [K]
          id_ph_temp         , &                  ! diag id for temporary value assumed for pH [1]
          id_k_water         , &                  ! diag id for self-ionization constant of Water [mol2/kg2]
          id_k0_co2          , &                  ! diag id for Solubility of CO2 [mol/kg/Pa]
          id_k1_co2          , &                  ! diag id for Acid dissociation constant CO2 + 2 H2O <-> HCO3- + H3O+ [mol/kg]
          id_k2_co2          , &                  ! diag id for Acid dissociation constant HCO3- + H2O <-> [CO3 2-] + H3O+ [mol/kg]
          id_k_boron         , &                  ! diag id for Acid dissociation constant of boric acid [mol/kg]
          id_k1_po4          , &                  ! diag id for Acid dissociation constant H3PO4 + H2O <-> [H2PO4 -] + H3O+ [mol/kg]
          id_k2_po4          , &                  ! diag id for Acid dissociation constant [H2PO4 -] + H2O+ <-> [HPO4 2-] + H3O+ [mol/kg]
          id_k3_po4          , &                  ! diag id for Acid dissociation constant [HPO4 2-] + H2O <-> [PO4 3-] + H3O+ [mol/kg]
          id_k1_h2s          , &                  ! diag id for Acid dissociation constant H2S + H2O <-> HS- + H3O+ [mol/kg]
          id_boron_total     , &                  ! diag id for total concentration of boron [mol/kg]
          id_alk_boron       , &                  ! diag id for boron alkalinity [mol/kg]
          id_alk_h2s         , &                  ! diag id for hydrogen sulfide alkalinity [mol/kg]
          id_alk_water       , &                  ! diag id for water alkalinity [mol/kg]
          id_alk_po4_denominator , &                  ! diag id for denominator in phosphate alkalinity formula [mol3/kg3]
          id_alk_po4         , &                  ! diag id for phosphate alkalinity [mol/kg]
          id_alk_co2_denominator , &                  ! diag id for denominator in carbonate alkalinity formula [mol2/kg2]
          id_alk_co2         , &                  ! diag id for carbonate alkalinity [mol/kg]
          id_alk_residual    , &                  ! diag id for error in total alkalinity calculation at the assumed pH [mol/kg]
          id_dalkp_dh3o      , &                  ! diag id for derivative of phosphate alkalinity with respect to h3o [1]
          id_dalkc_dh3o      , &                  ! diag id for derivative of carbonate alkalinity with respect to h3o [1]
          id_dalkresidual_dpH , &                  ! diag id for derivative of residual_alk with respect to pH [mol/kg]
          id_ph              , &                  ! diag id for newly determined pH value [1]
          id_h3o             , &                  ! diag id for h3o ion concentration [mol/kg]
          id_pco2            , &                  ! diag id for co2 partial pressure [Pa]
          id_co2             , &                  ! diag id for CO2 concentration in the surface layer [mol/kg]
          id_schmidtnumber_co2 , &                  ! diag id for Schmidt number for CO2 surface flux [1]
          id_frac_denit_sed  , &                  ! diag id for fraction of ammonium that is immediately nitrified and denitrified after remineralization in oxic sediments
          id_o2_sat          , &                  ! diag id for oxygen saturation concentration [mol/kg]
          id_solubility_o2   , &                  ! diag id for solubility of oxygen [mol/kg/Pa]
          id_schmidtnumber_o2 , &                  ! diag id for Schmidt number for oxygen surface flux [1]
          id_n2_sat          , &                  ! diag id for dissolved molecular nitrogen saturation concentration [mol/kg]
          id_solubility_n2   , &                  ! diag id for solubility of molecular nitrogen [mol/kg/Pa]
          id_schmidtnumber_n2 , &                  ! diag id for Schmidt number for nitrogen surface flux [1]
          id_temp_sq         , &                  ! diag id for square of positive temperature [C * C]
          id_zoo_eff         , &                  ! diag id for effectice zooplankton concentration assumed for mortality and respiration process [mol/kg]
          id_din             , &                  ! diag id for dissolved inorganic nitrogen [mol/kg]
          id_din_sq          , &                  ! diag id for squared DIN [mol2/kg2]
          id_po4_sq          , &                  ! diag id for squared phosphate [mol**2/kg**2]
          id_pp              , &                  ! diag id for total phytoplankton [mol/kg]
          id_lpp_plus_lpp0   , &                  ! diag id for large-cell phytoplankton plus seed concentration [mol/kg]
          id_spp_plus_spp0   , &                  ! diag id for small-cell phytoplankton plus seed concentration [mol/kg]
          id_cya_plus_cya0   , &                  ! diag id for diazotroph cyanobacteria plus seed concentration [mol/kg]
          id_food_zoo        , &                  ! diag id for suitable food for zooplankton (weighted with food preferences) [mol/kg]
          id_lim_light_lpp   , &                  ! diag id for light limitation factor for large-cell phytoplankton growth [1]
          id_lim_light_spp   , &                  ! diag id for light limitation factor for small-cell phytoplankton growth [1]
          id_lim_light_cya   , &                  ! diag id for light limitation factor for diazotroph cyanobacteria growth [1]
          id_lr_assim_lpp    , &                  ! diag id for growth rate of large-cell phytoplankton, limited by DIN, DIP, light and oxygen [1/day]
          id_lr_assim_lpp_doc , &                  ! diag id for production rate of DOC by LPP
          id_lr_assim_spp_doc , &                  ! diag id for production rate of POC by SPP
          id_lr_assim_cya_doc , &                  ! diag id for production rate of POC by CYA
          id_lr_assim_spp    , &                  ! diag id for growth rate of small-cell phytoplankton, limited by DIN, DIP, light, oxygen and temperature [1/day]
          id_lr_assim_cya    , &                  ! diag id for growth rate of diazotroph cyanobacteria, limited by DIP, light, oxygen, temperature and salinity [1/day]
          id_lr_assim_lpp_dop , &                  ! diag id for production rate of POCP by LPP
          id_lr_assim_spp_dop , &                  ! diag id for production rate of POCP by SPP
          id_lr_assim_lpp_don , &                  ! diag id for production rate of POCN by LPP
          id_lr_assim_spp_don , &                  ! diag id for production rate of POCN by SPP
          id_lr_graz_zoo     , &                  ! diag id for growth rate of zooplankton, limited by food, oxygen and temperature [1/day]
          id_sed_tot         , &                  ! diag id for total carbon in sediment layer [mol/m**2]
          id_sed_tot_active  , &                  ! diag id for total carbon in active sediment layer [mol/m**2]
          id_sed_active      , &                  ! diag id for detritus in active sediment layer [mol/m**2]
          id_lr_sed_rec      , &                  ! diag id for recycling rate of sediment detritus, limited by oxygen [1/d]
          id_ips_eff         , &                  ! diag id for effective concentration of iron phosphate in the sediment assumed for burial (enhanced burial above a threshold) [mol/m**2]
          id_frac_po4retent  , &                  ! diag id for fraction of phosphate which is retained as iron-bound phosphate instead of being released after mineralization in the sediment [1]
          id_erosion_is_active , &                  ! diag id for switch (1=erosion, 0=no erosion) which depends on the combined bottom stress of currents and waves
          id_ref_p_sw        , &                  ! diag id for modifies pocp recycling towards Refield ratio if PO4 is depleted
          id_ref_n_sw        , &                  ! diag id for modifies pocn recycling towards Refield ratio if DIN is depleted
          id_lr_pocp         , &                  ! diag id for add an additional POCP recycling if PO4 below Redfield but sufficient DIN
          id_lr_dop          , &                  ! diag id for add an additional DOP recycling if PO4 is below Redfield but sufficient DIN
          id_lr_pocn         , &                  ! diag id for add an additional POCN recycling if DIN below Redfield but sufficient PO4
          id_lr_don          , &                  ! diag id for add an additional DON recycling if DIN below Redfield but sufficient PO4
          id_poc_active      , &                  ! diag id for poc in active sediment layer [mol/m**2]
          id_pocn_active     , &                  ! diag id for pocn in active sediment layer [mol/m**2]
          id_pocp_active     , &                  ! diag id for pocp in active sediment layer [mol/m**2]
          id_w_poc_var       , &                  ! diag id for depth dependent POC sinking speed
          id_w_pocn_var      , &                  ! diag id for depth dependent POCN sinking speed
          id_w_pocp_var      , &                  ! diag id for depth dependent POCP sinking speed
          id_dep_wet_t_nh4               = -1,  & ! ammonium atmospheric deposition
          id_dep_wet_t_no3               = -1,  & ! nitrate atmospheric deposition
          id_dep_wet_t_po4               = -1,  & ! phosphate atmospheric deposition
          id_dep_wet_t_nh4_with_atmos_tot_N     = -1,  & ! ammonium; containing nitrogen from (total) atmospheric deposition atmospheric deposition
          id_dep_wet_t_no3_with_atmos_tot_N     = -1,  & ! nitrate; containing nitrogen from (total) atmospheric deposition atmospheric deposition
          id_dep_wet_t_nh4_with_atmos_ship_N     = -1,  & ! ammonium; containing nitrogen from atmospheric deposition, which has been previously emitted by ships atmospheric deposition
          id_dep_wet_t_no3_with_atmos_ship_N     = -1,  & ! nitrate; containing nitrogen from atmospheric deposition, which has been previously emitted by ships atmospheric deposition
          id_runoff_flux_t_o2            = -1,  & ! dissolved oxygen runoff flux to the ocean
          id_diffusive_flux_t_o2            = -1,  & ! dissolved oxygen diffusive flux from land to the ocean
          id_runoff_flux_t_dic           = -1,  & ! dissolved inorganic carbon, treated as carbon dioxide runoff flux to the ocean
          id_diffusive_flux_t_dic           = -1,  & ! dissolved inorganic carbon, treated as carbon dioxide diffusive flux from land to the ocean
          id_runoff_flux_t_nh4           = -1,  & ! ammonium runoff flux to the ocean
          id_diffusive_flux_t_nh4           = -1,  & ! ammonium diffusive flux from land to the ocean
          id_runoff_flux_t_no3           = -1,  & ! nitrate runoff flux to the ocean
          id_diffusive_flux_t_no3           = -1,  & ! nitrate diffusive flux from land to the ocean
          id_runoff_flux_t_po4           = -1,  & ! phosphate runoff flux to the ocean
          id_diffusive_flux_t_po4           = -1,  & ! phosphate diffusive flux from land to the ocean
          id_runoff_flux_t_alk           = -1,  & ! total alkalinity runoff flux to the ocean
          id_diffusive_flux_t_alk           = -1,  & ! total alkalinity diffusive flux from land to the ocean
          id_runoff_flux_t_det           = -1,  & ! detritus runoff flux to the ocean
          id_diffusive_flux_t_det           = -1,  & ! detritus diffusive flux from land to the ocean
          id_irr_inst   = -1             ! instantaneous light [W/m2]
     ! SEDIMENT MODEL FIELDS FOLLOW
     real, dimension(:,:,:), allocatable :: &
          sed_t_sed                                    , & ! sediment concentration of sediment detritus
          tracer_array_intermediate_sed_t_sed          , & ! for Runge-Kutta time step
          patankar_modification_sed_t_sed                  ! for Runge-Kutta Patankar
     real, dimension(:,:,:), allocatable :: &
          sed_t_ips                                    , & ! sediment concentration of iron phosphate in sediment
          tracer_array_intermediate_sed_t_ips          , & ! for Runge-Kutta time step
          patankar_modification_sed_t_ips                  ! for Runge-Kutta Patankar
     real, dimension(:,:,:), allocatable :: &
          sed_t_sed_poc                                , & ! sediment concentration of sediment particular carbon
          tracer_array_intermediate_sed_t_sed_poc      , & ! for Runge-Kutta time step
          patankar_modification_sed_t_sed_poc              ! for Runge-Kutta Patankar
     real, dimension(:,:,:), allocatable :: &
          sed_t_sed_pocn                               , & ! sediment concentration of sediment particular organic N+C
          tracer_array_intermediate_sed_t_sed_pocn     , & ! for Runge-Kutta time step
          patankar_modification_sed_t_sed_pocn             ! for Runge-Kutta Patankar
     real, dimension(:,:,:), allocatable :: &
          sed_t_sed_pocp                               , & ! sediment concentration of sediment particular organic P+C
          tracer_array_intermediate_sed_t_sed_pocp     , & ! for Runge-Kutta time step
          patankar_modification_sed_t_sed_pocp             ! for Runge-Kutta Patankar
     real, dimension(:,:,:), allocatable :: &
          sed_total_atmos_tot_N_at_bottom                          , & ! sediment concentration of total_atmos_tot_N_at_bottom
          tracer_array_intermediate_sed_total_atmos_tot_N_at_bottom, & ! for Runge-Kutta time step
          patankar_modification_sed_total_atmos_tot_N_at_bottom        ! for Runge-Kutta Patankar
     real, dimension(:,:,:), allocatable :: &
          sed_total_atmos_ship_N_at_bottom                          , & ! sediment concentration of total_atmos_ship_N_at_bottom
          tracer_array_intermediate_sed_total_atmos_ship_N_at_bottom, & ! for Runge-Kutta time step
          patankar_modification_sed_total_atmos_ship_N_at_bottom        ! for Runge-Kutta Patankar
     real, dimension(:,:,:), allocatable :: &
          sed_t_sed_with_atmos_tot_N                          , & ! sediment concentration of sediment detritus; containing nitrogen from (total) atmospheric deposition
          tracer_array_intermediate_sed_t_sed_with_atmos_tot_N, & ! for Runge-Kutta time step
          patankar_modification_sed_t_sed_with_atmos_tot_N        ! for Runge-Kutta Patankar
     real, dimension(:,:,:), allocatable :: &
          sed_t_sed_pocn_with_atmos_tot_N                          , & ! sediment concentration of sediment particular organic N+C; containing nitrogen from (total) atmospheric deposition
          tracer_array_intermediate_sed_t_sed_pocn_with_atmos_tot_N, & ! for Runge-Kutta time step
          patankar_modification_sed_t_sed_pocn_with_atmos_tot_N        ! for Runge-Kutta Patankar
     real, dimension(:,:,:), allocatable :: &
          sed_t_sed_with_atmos_ship_N                          , & ! sediment concentration of sediment detritus; containing nitrogen from atmospheric deposition, which has been previously emitted by ships
          tracer_array_intermediate_sed_t_sed_with_atmos_ship_N, & ! for Runge-Kutta time step
          patankar_modification_sed_t_sed_with_atmos_ship_N        ! for Runge-Kutta Patankar
     real, dimension(:,:,:), allocatable :: &
          sed_t_sed_pocn_with_atmos_ship_N                          , & ! sediment concentration of sediment particular organic N+C; containing nitrogen from atmospheric deposition, which has been previously emitted by ships
          tracer_array_intermediate_sed_t_sed_pocn_with_atmos_ship_N, & ! for Runge-Kutta time step
          patankar_modification_sed_t_sed_pocn_with_atmos_ship_N        ! for Runge-Kutta Patankar
     real, ALLOCATABLE, dimension(:,:,:) :: &
          sed_temp_k                     ! array to be allocated if sedimentary values are written to output
     real, ALLOCATABLE, dimension(:,:,:) :: &
          sed_ph_temp                    ! array to be allocated if sedimentary values are written to output
     real, ALLOCATABLE, dimension(:,:,:) :: &
          sed_k_water                    ! array to be allocated if sedimentary values are written to output
     real, ALLOCATABLE, dimension(:,:,:) :: &
          sed_k0_co2                     ! array to be allocated if sedimentary values are written to output
     real, ALLOCATABLE, dimension(:,:,:) :: &
          sed_k1_co2                     ! array to be allocated if sedimentary values are written to output
     real, ALLOCATABLE, dimension(:,:,:) :: &
          sed_k2_co2                     ! array to be allocated if sedimentary values are written to output
     real, ALLOCATABLE, dimension(:,:,:) :: &
          sed_k_boron                    ! array to be allocated if sedimentary values are written to output
     real, ALLOCATABLE, dimension(:,:,:) :: &
          sed_k1_po4                     ! array to be allocated if sedimentary values are written to output
     real, ALLOCATABLE, dimension(:,:,:) :: &
          sed_k2_po4                     ! array to be allocated if sedimentary values are written to output
     real, ALLOCATABLE, dimension(:,:,:) :: &
          sed_k3_po4                     ! array to be allocated if sedimentary values are written to output
     real, ALLOCATABLE, dimension(:,:,:) :: &
          sed_k1_h2s                     ! array to be allocated if sedimentary values are written to output
     real, ALLOCATABLE, dimension(:,:,:) :: &
          sed_boron_total                ! array to be allocated if sedimentary values are written to output
     real, ALLOCATABLE, dimension(:,:,:) :: &
          sed_alk_boron                  ! array to be allocated if sedimentary values are written to output
     real, ALLOCATABLE, dimension(:,:,:) :: &
          sed_alk_h2s                    ! array to be allocated if sedimentary values are written to output
     real, ALLOCATABLE, dimension(:,:,:) :: &
          sed_alk_water                  ! array to be allocated if sedimentary values are written to output
     real, ALLOCATABLE, dimension(:,:,:) :: &
          sed_alk_po4_denominator            ! array to be allocated if sedimentary values are written to output
     real, ALLOCATABLE, dimension(:,:,:) :: &
          sed_alk_po4                    ! array to be allocated if sedimentary values are written to output
     real, ALLOCATABLE, dimension(:,:,:) :: &
          sed_alk_co2_denominator            ! array to be allocated if sedimentary values are written to output
     real, ALLOCATABLE, dimension(:,:,:) :: &
          sed_alk_co2                    ! array to be allocated if sedimentary values are written to output
     real, ALLOCATABLE, dimension(:,:,:) :: &
          sed_alk_residual               ! array to be allocated if sedimentary values are written to output
     real, ALLOCATABLE, dimension(:,:,:) :: &
          sed_dalkp_dh3o                 ! array to be allocated if sedimentary values are written to output
     real, ALLOCATABLE, dimension(:,:,:) :: &
          sed_dalkc_dh3o                 ! array to be allocated if sedimentary values are written to output
     real, ALLOCATABLE, dimension(:,:,:) :: &
          sed_dalkresidual_dpH            ! array to be allocated if sedimentary values are written to output
     real, ALLOCATABLE, dimension(:,:,:) :: &
          sed_ph                         ! array to be allocated if sedimentary values are written to output
     real, ALLOCATABLE, dimension(:,:,:) :: &
          sed_h3o                        ! array to be allocated if sedimentary values are written to output
     real, ALLOCATABLE, dimension(:,:,:) :: &
          sed_pco2                       ! array to be allocated if sedimentary values are written to output
     real, ALLOCATABLE, dimension(:,:,:) :: &
          sed_co2                        ! array to be allocated if sedimentary values are written to output
     real, ALLOCATABLE, dimension(:,:,:) :: &
          sed_schmidtnumber_co2            ! array to be allocated if sedimentary values are written to output
     real, ALLOCATABLE, dimension(:,:,:) :: &
          sed_frac_denit_sed             ! array to be allocated if sedimentary values are written to output
     real, ALLOCATABLE, dimension(:,:,:) :: &
          sed_o2_sat                     ! array to be allocated if sedimentary values are written to output
     real, ALLOCATABLE, dimension(:,:,:) :: &
          sed_solubility_o2              ! array to be allocated if sedimentary values are written to output
     real, ALLOCATABLE, dimension(:,:,:) :: &
          sed_schmidtnumber_o2            ! array to be allocated if sedimentary values are written to output
     real, ALLOCATABLE, dimension(:,:,:) :: &
          sed_n2_sat                     ! array to be allocated if sedimentary values are written to output
     real, ALLOCATABLE, dimension(:,:,:) :: &
          sed_solubility_n2              ! array to be allocated if sedimentary values are written to output
     real, ALLOCATABLE, dimension(:,:,:) :: &
          sed_schmidtnumber_n2            ! array to be allocated if sedimentary values are written to output
     real, ALLOCATABLE, dimension(:,:,:) :: &
          sed_temp_sq                    ! array to be allocated if sedimentary values are written to output
     real, ALLOCATABLE, dimension(:,:,:) :: &
          sed_zoo_eff                    ! array to be allocated if sedimentary values are written to output
     real, ALLOCATABLE, dimension(:,:,:) :: &
          sed_din                        ! array to be allocated if sedimentary values are written to output
     real, ALLOCATABLE, dimension(:,:,:) :: &
          sed_din_sq                     ! array to be allocated if sedimentary values are written to output
     real, ALLOCATABLE, dimension(:,:,:) :: &
          sed_po4_sq                     ! array to be allocated if sedimentary values are written to output
     real, ALLOCATABLE, dimension(:,:,:) :: &
          sed_pp                         ! array to be allocated if sedimentary values are written to output
     real, ALLOCATABLE, dimension(:,:,:) :: &
          sed_lpp_plus_lpp0              ! array to be allocated if sedimentary values are written to output
     real, ALLOCATABLE, dimension(:,:,:) :: &
          sed_spp_plus_spp0              ! array to be allocated if sedimentary values are written to output
     real, ALLOCATABLE, dimension(:,:,:) :: &
          sed_cya_plus_cya0              ! array to be allocated if sedimentary values are written to output
     real, ALLOCATABLE, dimension(:,:,:) :: &
          sed_food_zoo                   ! array to be allocated if sedimentary values are written to output
     real, ALLOCATABLE, dimension(:,:,:) :: &
          sed_lim_light_lpp              ! array to be allocated if sedimentary values are written to output
     real, ALLOCATABLE, dimension(:,:,:) :: &
          sed_lim_light_spp              ! array to be allocated if sedimentary values are written to output
     real, ALLOCATABLE, dimension(:,:,:) :: &
          sed_lim_light_cya              ! array to be allocated if sedimentary values are written to output
     real, ALLOCATABLE, dimension(:,:,:) :: &
          sed_lr_assim_lpp               ! array to be allocated if sedimentary values are written to output
     real, ALLOCATABLE, dimension(:,:,:) :: &
          sed_lr_assim_lpp_doc            ! array to be allocated if sedimentary values are written to output
     real, ALLOCATABLE, dimension(:,:,:) :: &
          sed_lr_assim_spp_doc            ! array to be allocated if sedimentary values are written to output
     real, ALLOCATABLE, dimension(:,:,:) :: &
          sed_lr_assim_cya_doc            ! array to be allocated if sedimentary values are written to output
     real, ALLOCATABLE, dimension(:,:,:) :: &
          sed_lr_assim_spp               ! array to be allocated if sedimentary values are written to output
     real, ALLOCATABLE, dimension(:,:,:) :: &
          sed_lr_assim_cya               ! array to be allocated if sedimentary values are written to output
     real, ALLOCATABLE, dimension(:,:,:) :: &
          sed_lr_assim_lpp_dop            ! array to be allocated if sedimentary values are written to output
     real, ALLOCATABLE, dimension(:,:,:) :: &
          sed_lr_assim_spp_dop            ! array to be allocated if sedimentary values are written to output
     real, ALLOCATABLE, dimension(:,:,:) :: &
          sed_lr_assim_lpp_don            ! array to be allocated if sedimentary values are written to output
     real, ALLOCATABLE, dimension(:,:,:) :: &
          sed_lr_assim_spp_don            ! array to be allocated if sedimentary values are written to output
     real, ALLOCATABLE, dimension(:,:,:) :: &
          sed_lr_graz_zoo                ! array to be allocated if sedimentary values are written to output
     real, ALLOCATABLE, dimension(:,:,:) :: &
          sed_sed_tot                    ! array to be allocated if sedimentary values are written to output
     real, ALLOCATABLE, dimension(:,:,:) :: &
          sed_sed_tot_active             ! array to be allocated if sedimentary values are written to output
     real, ALLOCATABLE, dimension(:,:,:) :: &
          sed_sed_active                 ! array to be allocated if sedimentary values are written to output
     real, ALLOCATABLE, dimension(:,:,:) :: &
          sed_lr_sed_rec                 ! array to be allocated if sedimentary values are written to output
     real, ALLOCATABLE, dimension(:,:,:) :: &
          sed_ips_eff                    ! array to be allocated if sedimentary values are written to output
     real, ALLOCATABLE, dimension(:,:,:) :: &
          sed_frac_po4retent             ! array to be allocated if sedimentary values are written to output
     real, ALLOCATABLE, dimension(:,:,:) :: &
          sed_erosion_is_active            ! array to be allocated if sedimentary values are written to output
     real, ALLOCATABLE, dimension(:,:,:) :: &
          sed_ref_p_sw                   ! array to be allocated if sedimentary values are written to output
     real, ALLOCATABLE, dimension(:,:,:) :: &
          sed_ref_n_sw                   ! array to be allocated if sedimentary values are written to output
     real, ALLOCATABLE, dimension(:,:,:) :: &
          sed_lr_pocp                    ! array to be allocated if sedimentary values are written to output
     real, ALLOCATABLE, dimension(:,:,:) :: &
          sed_lr_dop                     ! array to be allocated if sedimentary values are written to output
     real, ALLOCATABLE, dimension(:,:,:) :: &
          sed_lr_pocn                    ! array to be allocated if sedimentary values are written to output
     real, ALLOCATABLE, dimension(:,:,:) :: &
          sed_lr_don                     ! array to be allocated if sedimentary values are written to output
     real, ALLOCATABLE, dimension(:,:,:) :: &
          sed_poc_active                 ! array to be allocated if sedimentary values are written to output
     real, ALLOCATABLE, dimension(:,:,:) :: &
          sed_pocn_active                ! array to be allocated if sedimentary values are written to output
     real, ALLOCATABLE, dimension(:,:,:) :: &
          sed_pocp_active                ! array to be allocated if sedimentary values are written to output
     real, ALLOCATABLE, dimension(:,:,:) :: &
          sed_w_poc_var                  ! array to be allocated if sedimentary values are written to output
     real, ALLOCATABLE, dimension(:,:,:) :: &
          sed_w_pocn_var                 ! array to be allocated if sedimentary values are written to output
     real, ALLOCATABLE, dimension(:,:,:) :: &
          sed_w_pocp_var                 ! array to be allocated if sedimentary values are written to output
     real, ALLOCATABLE, dimension(:,:,:) :: &
          moldiff_t_sed                  ! molecular diffusivity [m2/s]
     real, ALLOCATABLE, dimension(:,:,:) :: &
          moldiff_t_ips                  ! molecular diffusivity [m2/s]
     real, ALLOCATABLE, dimension(:,:,:) :: &
          moldiff_t_sed_poc              ! molecular diffusivity [m2/s]
     real, ALLOCATABLE, dimension(:,:,:) :: &
          moldiff_t_sed_pocn             ! molecular diffusivity [m2/s]
     real, ALLOCATABLE, dimension(:,:,:) :: &
          moldiff_t_sed_pocp             ! molecular diffusivity [m2/s]
     real, ALLOCATABLE, dimension(:,:,:) :: &
          moldiff_total_atmos_tot_N_at_bottom        ! molecular diffusivity [m2/s]
     real, ALLOCATABLE, dimension(:,:,:) :: &
          moldiff_total_atmos_ship_N_at_bottom        ! molecular diffusivity [m2/s]
     real, ALLOCATABLE, dimension(:,:,:) :: &
          moldiff_t_sed_with_atmos_tot_N        ! molecular diffusivity [m2/s]
     real, ALLOCATABLE, dimension(:,:,:) :: &
          moldiff_t_sed_pocn_with_atmos_tot_N        ! molecular diffusivity [m2/s]
     real, ALLOCATABLE, dimension(:,:,:) :: &
          moldiff_t_sed_with_atmos_ship_N        ! molecular diffusivity [m2/s]
     real, ALLOCATABLE, dimension(:,:,:) :: &
          moldiff_t_sed_pocn_with_atmos_ship_N        ! molecular diffusivity [m2/s]
     real, ALLOCATABLE, dimension(:,:,:) :: &
          sed_p_sed_burial    , &        ! array to be allocated if sedimentary values are written to output
          saved_rate_sed_p_sed_burial    ! for Runge-Kutta method
     real, ALLOCATABLE, dimension(:,:,:) :: &
          sed_p_ips_burial    , &        ! array to be allocated if sedimentary values are written to output
          saved_rate_sed_p_ips_burial    ! for Runge-Kutta method
     real, ALLOCATABLE, dimension(:,:,:) :: &
          sed_p_poc_burial    , &        ! array to be allocated if sedimentary values are written to output
          saved_rate_sed_p_poc_burial    ! for Runge-Kutta method
     real, ALLOCATABLE, dimension(:,:,:) :: &
          sed_p_pocn_burial   , &        ! array to be allocated if sedimentary values are written to output
          saved_rate_sed_p_pocn_burial   ! for Runge-Kutta method
     real, ALLOCATABLE, dimension(:,:,:) :: &
          sed_p_pocp_burial   , &        ! array to be allocated if sedimentary values are written to output
          saved_rate_sed_p_pocp_burial   ! for Runge-Kutta method
     real, ALLOCATABLE, dimension(:,:,:) :: &
          sed_p_det_sedi_sed_atmos_tot_N , &        ! array to be allocated if sedimentary values are written to output
          saved_rate_sed_p_det_sedi_sed_atmos_tot_N ! for Runge-Kutta method
     real, ALLOCATABLE, dimension(:,:,:) :: &
          sed_p_pocn_sedi_sed_atmos_tot_N , &        ! array to be allocated if sedimentary values are written to output
          saved_rate_sed_p_pocn_sedi_sed_atmos_tot_N ! for Runge-Kutta method
     real, ALLOCATABLE, dimension(:,:,:) :: &
          sed_p_sed_burial_atmos_tot_N , &        ! array to be allocated if sedimentary values are written to output
          saved_rate_sed_p_sed_burial_atmos_tot_N ! for Runge-Kutta method
     real, ALLOCATABLE, dimension(:,:,:) :: &
          sed_p_pocn_burial_atmos_tot_N , &        ! array to be allocated if sedimentary values are written to output
          saved_rate_sed_p_pocn_burial_atmos_tot_N ! for Runge-Kutta method
     real, ALLOCATABLE, dimension(:,:,:) :: &
          sed_p_det_sedi_sed_atmos_ship_N , &        ! array to be allocated if sedimentary values are written to output
          saved_rate_sed_p_det_sedi_sed_atmos_ship_N ! for Runge-Kutta method
     real, ALLOCATABLE, dimension(:,:,:) :: &
          sed_p_pocn_sedi_sed_atmos_ship_N , &        ! array to be allocated if sedimentary values are written to output
          saved_rate_sed_p_pocn_sedi_sed_atmos_ship_N ! for Runge-Kutta method
     real, ALLOCATABLE, dimension(:,:,:) :: &
          sed_p_sed_burial_atmos_ship_N , &        ! array to be allocated if sedimentary values are written to output
          saved_rate_sed_p_sed_burial_atmos_ship_N ! for Runge-Kutta method
     real, ALLOCATABLE, dimension(:,:,:) :: &
          sed_p_pocn_burial_atmos_ship_N , &        ! array to be allocated if sedimentary values are written to output
          saved_rate_sed_p_pocn_burial_atmos_ship_N ! for Runge-Kutta method
     integer :: id_sed_temp_k            ! diag id for sediment values of absolute temperature [K]
     integer :: id_sed_ph_temp           ! diag id for sediment values of temporary value assumed for pH [1]
     integer :: id_sed_k_water           ! diag id for sediment values of self-ionization constant of Water [mol2/kg2]
     integer :: id_sed_k0_co2            ! diag id for sediment values of Solubility of CO2 [mol/kg/Pa]
     integer :: id_sed_k1_co2            ! diag id for sediment values of Acid dissociation constant CO2 + 2 H2O <-> HCO3- + H3O+ [mol/kg]
     integer :: id_sed_k2_co2            ! diag id for sediment values of Acid dissociation constant HCO3- + H2O <-> [CO3 2-] + H3O+ [mol/kg]
     integer :: id_sed_k_boron           ! diag id for sediment values of Acid dissociation constant of boric acid [mol/kg]
     integer :: id_sed_k1_po4            ! diag id for sediment values of Acid dissociation constant H3PO4 + H2O <-> [H2PO4 -] + H3O+ [mol/kg]
     integer :: id_sed_k2_po4            ! diag id for sediment values of Acid dissociation constant [H2PO4 -] + H2O+ <-> [HPO4 2-] + H3O+ [mol/kg]
     integer :: id_sed_k3_po4            ! diag id for sediment values of Acid dissociation constant [HPO4 2-] + H2O <-> [PO4 3-] + H3O+ [mol/kg]
     integer :: id_sed_k1_h2s            ! diag id for sediment values of Acid dissociation constant H2S + H2O <-> HS- + H3O+ [mol/kg]
     integer :: id_sed_boron_total       ! diag id for sediment values of total concentration of boron [mol/kg]
     integer :: id_sed_alk_boron         ! diag id for sediment values of boron alkalinity [mol/kg]
     integer :: id_sed_alk_h2s           ! diag id for sediment values of hydrogen sulfide alkalinity [mol/kg]
     integer :: id_sed_alk_water         ! diag id for sediment values of water alkalinity [mol/kg]
     integer :: id_sed_alk_po4_denominator   ! diag id for sediment values of denominator in phosphate alkalinity formula [mol3/kg3]
     integer :: id_sed_alk_po4           ! diag id for sediment values of phosphate alkalinity [mol/kg]
     integer :: id_sed_alk_co2_denominator   ! diag id for sediment values of denominator in carbonate alkalinity formula [mol2/kg2]
     integer :: id_sed_alk_co2           ! diag id for sediment values of carbonate alkalinity [mol/kg]
     integer :: id_sed_alk_residual      ! diag id for sediment values of error in total alkalinity calculation at the assumed pH [mol/kg]
     integer :: id_sed_dalkp_dh3o        ! diag id for sediment values of derivative of phosphate alkalinity with respect to h3o [1]
     integer :: id_sed_dalkc_dh3o        ! diag id for sediment values of derivative of carbonate alkalinity with respect to h3o [1]
     integer :: id_sed_dalkresidual_dpH   ! diag id for sediment values of derivative of residual_alk with respect to pH [mol/kg]
     integer :: id_sed_ph                ! diag id for sediment values of newly determined pH value [1]
     integer :: id_sed_h3o               ! diag id for sediment values of h3o ion concentration [mol/kg]
     integer :: id_sed_pco2              ! diag id for sediment values of co2 partial pressure [Pa]
     integer :: id_sed_co2               ! diag id for sediment values of CO2 concentration in the surface layer [mol/kg]
     integer :: id_sed_schmidtnumber_co2   ! diag id for sediment values of Schmidt number for CO2 surface flux [1]
     integer :: id_sed_frac_denit_sed    ! diag id for sediment values of fraction of ammonium that is immediately nitrified and denitrified after remineralization in oxic sediments
     integer :: id_sed_o2_sat            ! diag id for sediment values of oxygen saturation concentration [mol/kg]
     integer :: id_sed_solubility_o2     ! diag id for sediment values of solubility of oxygen [mol/kg/Pa]
     integer :: id_sed_schmidtnumber_o2   ! diag id for sediment values of Schmidt number for oxygen surface flux [1]
     integer :: id_sed_n2_sat            ! diag id for sediment values of dissolved molecular nitrogen saturation concentration [mol/kg]
     integer :: id_sed_solubility_n2     ! diag id for sediment values of solubility of molecular nitrogen [mol/kg/Pa]
     integer :: id_sed_schmidtnumber_n2   ! diag id for sediment values of Schmidt number for nitrogen surface flux [1]
     integer :: id_sed_temp_sq           ! diag id for sediment values of square of positive temperature [C * C]
     integer :: id_sed_zoo_eff           ! diag id for sediment values of effectice zooplankton concentration assumed for mortality and respiration process [mol/kg]
     integer :: id_sed_din               ! diag id for sediment values of dissolved inorganic nitrogen [mol/kg]
     integer :: id_sed_din_sq            ! diag id for sediment values of squared DIN [mol2/kg2]
     integer :: id_sed_po4_sq            ! diag id for sediment values of squared phosphate [mol**2/kg**2]
     integer :: id_sed_pp                ! diag id for sediment values of total phytoplankton [mol/kg]
     integer :: id_sed_lpp_plus_lpp0     ! diag id for sediment values of large-cell phytoplankton plus seed concentration [mol/kg]
     integer :: id_sed_spp_plus_spp0     ! diag id for sediment values of small-cell phytoplankton plus seed concentration [mol/kg]
     integer :: id_sed_cya_plus_cya0     ! diag id for sediment values of diazotroph cyanobacteria plus seed concentration [mol/kg]
     integer :: id_sed_food_zoo          ! diag id for sediment values of suitable food for zooplankton (weighted with food preferences) [mol/kg]
     integer :: id_sed_lim_light_lpp     ! diag id for sediment values of light limitation factor for large-cell phytoplankton growth [1]
     integer :: id_sed_lim_light_spp     ! diag id for sediment values of light limitation factor for small-cell phytoplankton growth [1]
     integer :: id_sed_lim_light_cya     ! diag id for sediment values of light limitation factor for diazotroph cyanobacteria growth [1]
     integer :: id_sed_lr_assim_lpp      ! diag id for sediment values of growth rate of large-cell phytoplankton, limited by DIN, DIP, light and oxygen [1/day]
     integer :: id_sed_lr_assim_lpp_doc   ! diag id for sediment values of production rate of DOC by LPP
     integer :: id_sed_lr_assim_spp_doc   ! diag id for sediment values of production rate of POC by SPP
     integer :: id_sed_lr_assim_cya_doc   ! diag id for sediment values of production rate of POC by CYA
     integer :: id_sed_lr_assim_spp      ! diag id for sediment values of growth rate of small-cell phytoplankton, limited by DIN, DIP, light, oxygen and temperature [1/day]
     integer :: id_sed_lr_assim_cya      ! diag id for sediment values of growth rate of diazotroph cyanobacteria, limited by DIP, light, oxygen, temperature and salinity [1/day]
     integer :: id_sed_lr_assim_lpp_dop   ! diag id for sediment values of production rate of POCP by LPP
     integer :: id_sed_lr_assim_spp_dop   ! diag id for sediment values of production rate of POCP by SPP
     integer :: id_sed_lr_assim_lpp_don   ! diag id for sediment values of production rate of POCN by LPP
     integer :: id_sed_lr_assim_spp_don   ! diag id for sediment values of production rate of POCN by SPP
     integer :: id_sed_lr_graz_zoo       ! diag id for sediment values of growth rate of zooplankton, limited by food, oxygen and temperature [1/day]
     integer :: id_sed_sed_tot           ! diag id for sediment values of total carbon in sediment layer [mol/m**2]
     integer :: id_sed_sed_tot_active    ! diag id for sediment values of total carbon in active sediment layer [mol/m**2]
     integer :: id_sed_sed_active        ! diag id for sediment values of detritus in active sediment layer [mol/m**2]
     integer :: id_sed_lr_sed_rec        ! diag id for sediment values of recycling rate of sediment detritus, limited by oxygen [1/d]
     integer :: id_sed_ips_eff           ! diag id for sediment values of effective concentration of iron phosphate in the sediment assumed for burial (enhanced burial above a threshold) [mol/m**2]
     integer :: id_sed_frac_po4retent    ! diag id for sediment values of fraction of phosphate which is retained as iron-bound phosphate instead of being released after mineralization in the sediment [1]
     integer :: id_sed_erosion_is_active   ! diag id for sediment values of switch (1=erosion, 0=no erosion) which depends on the combined bottom stress of currents and waves
     integer :: id_sed_ref_p_sw          ! diag id for sediment values of modifies pocp recycling towards Refield ratio if PO4 is depleted
     integer :: id_sed_ref_n_sw          ! diag id for sediment values of modifies pocn recycling towards Refield ratio if DIN is depleted
     integer :: id_sed_lr_pocp           ! diag id for sediment values of add an additional POCP recycling if PO4 below Redfield but sufficient DIN
     integer :: id_sed_lr_dop            ! diag id for sediment values of add an additional DOP recycling if PO4 is below Redfield but sufficient DIN
     integer :: id_sed_lr_pocn           ! diag id for sediment values of add an additional POCN recycling if DIN below Redfield but sufficient PO4
     integer :: id_sed_lr_don            ! diag id for sediment values of add an additional DON recycling if DIN below Redfield but sufficient PO4
     integer :: id_sed_poc_active        ! diag id for sediment values of poc in active sediment layer [mol/m**2]
     integer :: id_sed_pocn_active       ! diag id for sediment values of pocn in active sediment layer [mol/m**2]
     integer :: id_sed_pocp_active       ! diag id for sediment values of pocp in active sediment layer [mol/m**2]
     integer :: id_sed_w_poc_var         ! diag id for sediment values of depth dependent POC sinking speed
     integer :: id_sed_w_pocn_var        ! diag id for sediment values of depth dependent POCN sinking speed
     integer :: id_sed_w_pocp_var        ! diag id for sediment values of depth dependent POCP sinking speed
     integer :: id_sed_p_sed_burial      ! diag id for sediment values of burial of detritus deeper than max_sed
     integer :: id_sed_p_ips_burial      ! diag id for sediment values of burial of iron PO4
     integer :: id_sed_p_poc_burial      ! diag id for sediment values of burial of poc deeper than max_sed
     integer :: id_sed_p_pocn_burial     ! diag id for sediment values of burial of pocn deeper than max_sed
     integer :: id_sed_p_pocp_burial     ! diag id for sediment values of burial of pocp deeper than max_sed
     integer :: id_sed_p_det_sedi_sed_atmos_tot_N   ! diag id for sediment values of detritus sedimentation; sub-process for atmos_tot nitrogen
     integer :: id_sed_p_pocn_sedi_sed_atmos_tot_N   ! diag id for sediment values of pocn sedimentation; sub-process for atmos_tot nitrogen
     integer :: id_sed_p_sed_burial_atmos_tot_N   ! diag id for sediment values of burial of detritus deeper than max_sed; sub-process for atmos_tot nitrogen
     integer :: id_sed_p_pocn_burial_atmos_tot_N   ! diag id for sediment values of burial of pocn deeper than max_sed; sub-process for atmos_tot nitrogen
     integer :: id_sed_p_det_sedi_sed_atmos_ship_N   ! diag id for sediment values of detritus sedimentation; sub-process for atmos_ship nitrogen
     integer :: id_sed_p_pocn_sedi_sed_atmos_ship_N   ! diag id for sediment values of pocn sedimentation; sub-process for atmos_ship nitrogen
     integer :: id_sed_p_sed_burial_atmos_ship_N   ! diag id for sediment values of burial of detritus deeper than max_sed; sub-process for atmos_ship nitrogen
     integer :: id_sed_p_pocn_burial_atmos_ship_N   ! diag id for sediment values of burial of pocn deeper than max_sed; sub-process for atmos_ship nitrogen

     real, dimension(:,:,:), allocatable :: & ! sediment model fields follow
          sed_cellheights           , &  ! cell heights in the sediment [m]
          sed_diffusivity_porewater , &  ! bioturbation-generated diffusivity for pore water species [m2/s]
          sed_diffusivity_solids    , &  ! bioturbation-generated diffusivity for solid species [m2/s]
          sed_2d_params             , &  ! sed_inert_deposition[m/s], temperature[degC], salinity[g/kg], bottomdepth[m], fluffy_layer_thickness[m], diffusive layer thickness[m]
          sed_inert_ratio                ! volume fraction of bioinert material in the sediments [1]
     ! END OF SEDIMENT MODEL FIELDS
     character(len=fm_string_len) :: ice_restart_file
     character(len=fm_string_len) :: ocean_restart_file, IC_file
  end type generic_ERGOM_type

  type tracer_2d
    character(len=fm_string_len) ::  name               = 'none'  ! name of the 2d tracer
    character(len=fm_string_len) ::  longname           = 'none'  ! longname of the 2d tracer
    character(len=fm_string_len) ::  units              = 'none'  ! units of the 2d tracer
    character(len=fm_string_len) ::  name_of_3d_tracer  = 'none'  ! name of the 3d tracer
    integer                      ::  layer_in_3d_tracer = 0       ! z-level inside the 3d tracer
    integer                      ::  diag_field         = -1      ! handler returned from register_diag_field
    real, dimension(:,:), pointer::  p_field                      ! pointer to the 2d field stored
    logical                      ::  field_assigned     = .false. ! whether a 2d field has been assigned
  end type tracer_2d

  real, parameter :: missing_value1=-1.0e+20

  real :: critical_stress = 0.016    ! critical shear stress for sediment erosion [N/m2]
  real :: cya0            = 9.0E-8   ! seed concentration for diazotroph cyanobacteria [mol/kg]
  real :: din_min_lpp     = 1.0E-6   ! DIN half saturation constant for large-cell phytoplankton growth [mol/kg]
  real :: din_min_spp     = 1.6E-7   ! DIN half saturation constant for small-cell phytoplankton growth [mol/kg]
  real :: dip_min_cya     = 1.0E-8   ! DIP half saturation constant for diazotroph cyanobacteria growth [mol/kg]
  real :: epsilon         = 4.5E-17  ! no division by 0
  real :: food_min_zoo    = 4.108E-6 ! Ivlev phytoplankton concentration for zooplankton grazing [mol/kg]
  real :: gamma0          = 0.027    ! light attentuation parameter (opacity of clear water) [1/m], DO NOT CHANGE NAME gamma0 SINCE THIS NAME WILL BE USED IN THE TEMPLATE
  real :: gamma1          = 58.0     ! light attentuation parameter (opacity of POM containing chlorophyll) [m**2/mol]
  real :: gamma2          = 53.2     ! light attentuation parameter (opacity of POM detritus) [m**2/mol]
  real :: gamma3          = 12.6     ! light attentuation parameter (opacity of DON) [m**2/mol]
  real :: h2s_min_po4_liber = 1.0E-6   ! minimum h2s concentration for liberation of iron phosphate from the sediment [mol/kg]
  real :: ips_threshold   = 0.1      ! threshold for increased PO4 burial [mol/m**2]
  real :: ips_cl          = 0.02025  ! iron phosphate in sediment closure parameter [mol/m2]
  real :: k_h2s_no3       = 800000.0 ! reaction constant h2s oxidation with no3 [kg/mol/day]
  real :: k_h2s_o2        = 800000.0 ! reaction constant h2s oxidation with o2 [kg/mol/day]
  real :: k_sul_no3       = 20000.0  ! reaction constant sul oxidation with no3 [kg/mol/day]
  real :: k_sul_o2        = 20000.0  ! reaction constant sul oxidation with o2 [kg/mol/day]
  real :: light_opt_cya   = 50.0     ! optimal light for diazotroph cyanobacteria growth [W/m**2]
  real :: light_opt_lpp   = 35.0     ! optimal light for large-cell phytoplankton growth [W/m**2]
  real :: light_opt_spp   = 50.0     ! optimal light for small-cell phytoplankton growth [W/m**2]
  real :: lpp0            = 4.5E-9   ! seed concentration for large-cell phytoplankton [mol/kg]
  real :: no3_min_sed_denit = 1.423E-7 ! nitrate half-saturation concentration for denitrification in the water column [mol/kg]
  real :: no3_min_det_denit = 1.0E-9   ! minimum no3 concentration for recycling of detritus using nitrate (denitrification)
  real :: o2_min_det_resp = 1.0E-6   ! oxygen half-saturation constant for detritus recycling [mol/kg]
  real :: o2_min_nit      = 3.75E-6  ! oxygen half-saturation constant for nitrification [mol/kg]
  real :: o2_min_po4_retent = 0.0000375 ! oxygen half-saturation concentration for retension of phosphate during sediment denitrification [mol/kg]
  real :: o2_min_sed_resp = 0.000064952 ! oxygen half-saturation constant for recycling of sediment detritus using oxygen [mol/kg]
  real :: patm_co2        = 38.0     ! atmospheric partial pressure of CO2 [Pa]
  real :: q10_det_rec     = 0.15     ! q10 rule factor for recycling [1/K]
  real :: q10_doc_rec     = 0.069    ! q10 rule factor for DOC recycling [1/K]
  real :: q10_h2s         = 0.0693   ! q10 rule factor for oxidation of h2s and sul [1/K]
  real :: q10_nit         = 0.11     ! q10 rule factor for nitrification [1/K]
  real :: q10_sed_rec     = 0.175    ! q10 rule factor for detritus recycling in the sediment [1/K]
  real :: r_biores        = 0.015    ! bio-resuspension rate [1/day]
  real :: r_cya_assim     = 0.75     ! maximum rate for nutrient uptake of diazotroph cyanobacteria [1/day]
  real :: r_cya_resp      = 0.01     ! respiration rate of cyanobacteria to ammonium [1/day]
  real :: r_det_rec       = 0.003    ! recycling rate (detritus to ammonium) at 0C [1/day]
  real :: r_ips_burial    = 0.0018   ! final burial rate for PO4 [1/day]
  real :: r_ips_ero       = 6.0      ! erosion rate for iron PO4 [1/day]
  real :: r_ips_liber     = 0.1      ! PO4 liberation rate under anoxic conditions [1/day]
  real :: r_lpp_assim     = 1.38     ! maximum rate for nutrient uptake of large-cell phytoplankton [1/day]
  real :: r_lpp_resp      = 0.075    ! respiration rate of large phytoplankton to ammonium [1/day]
  real :: r_nh4_nitrif    = 0.05     ! nitrification rate at 0C [1/day]
  real :: r_pp_mort       = 0.03     ! mortality rate of phytoplankton [1/day]
  real :: r_cya_mort_diff = 40.0     ! enhanced cya mortality due to strong turbulence
  real :: r_cya_mort_thresh = 0.02     ! diffusivity threshold for enhanced cyano mortality
  real :: r_sed_ero       = 6.0      ! maximum sediment detritus erosion rate [1/day]
  real :: r_sed_rec       = 0.002    ! maximum recycling rate of sediment to ammonium [1/day]
  real :: r_spp_assim     = 0.4      ! maximum rate for nutrient uptake of small-cell phytoplankton [1/day]
  real :: r_spp_resp      = 0.0175   ! respiration rate of small phytoplankton to ammonium [1/day]
  real :: r_zoo_graz      = 0.5      ! maximum zooplankton grazing rate [1/day]
  real :: r_zoo_mort      = 0.03     ! mortality rate of zooplankton [1/day]
  real :: r_zoo_resp      = 0.01     ! respiration rate of zooplankton [1/day]
  real :: rfr_c           = 6.625    ! redfield ratio C/N
  real :: rfr_h           = 16.4375  ! redfield ratio H/N
  real :: rfr_o           = 6.875    ! redfield ratio O/N
  real :: rfr_p           = 0.0625   ! redfield ratio P/N
  real :: rfr_cp          = 106.0    ! redfield ratio C/P
  real :: sali_max_cya    = 8.0      ! upper salinity limit - diazotroph cyanobacteria [psu]
  real :: sali_min_cya    = 4.0      ! lower salinity limit - diazotroph cyanobacteria [psu]
  real :: sed_max         = 1.0      ! maximum sediment detritus concentration that feels erosion [mol/m**2]
  real :: spp0            = 4.5E-9   ! seed concentration for small-cell phytoplankton [mol/kg]
  real :: temp_min_cya    = 13.5     ! lower temperature limit - diazotroph cyanobacteria [C]
  real :: temp_min_spp    = 10.0     ! lower temperature limit - small-cell phytoplankton [C]
  real :: temp_opt_zoo    = 20.0     ! optimal temperature for zooplankton grazing [C]
  real :: w_co2_stf       = 4.0      ! piston velocity for co2 surface flux [m/d]
  real :: w_cya           = 1.0      ! vertical speed of diazotroph cyanobacteria [m/day]
  real :: w_det           = -4.5     ! vertical speed of detritus [m/day]
  real :: w_det_sedi      = -2.25    ! sedimentation velocity (negative for downward) [m/day]
  real :: w_ipw           = -1.0     ! vertical speed of suspended iron PO4 [m/day]
  real :: w_ipw_sedi      = -0.5     ! sedimentation velocity for iron PO4 [m/day]
  real :: w_lpp           = -0.5     ! vertical speed of large-cell phytoplankton [m/day]
  real :: w_n2_stf        = 5.0      ! piston velocity for n2 surface flux [m/d]
  real :: w_o2_stf        = 5.0      ! piston velocity for oxygen surface flux [m/d]
  real :: zoo0            = 4.5E-9   ! seed concentration for zooplankton [mol/kg]
  real :: zoo_cl          = 9.0E-8   ! zooplankton closure parameter [mol/kg]
  real :: don_fraction    = 0.0      ! fraction of DON in respiration products
  real :: r_poc_rec       = 0.003    ! recycling rate (poc to dic) at 0C [1/day]
  real :: r_pocp_rec      = 0.002    ! recycling rate (pocp to dic and po4) at 0C [1/day]
  real :: r_pocn_rec      = 0.002    ! recycling rate (pocn to dic and nh4) at 0C [1/day]
  real :: w_poc           = -0.2     ! vertical speed of poc [m/day]
  real :: w_poc_sedi      = -0.1     ! sedimentation velocity (negative for downward) [m/day]
  real :: w_pocp          = -0.1     ! vertical speed of pocp [m/day]
  real :: w_pocp_sedi     = -0.05    ! sedimentation velocity (negative for downward) [m/day]
  real :: w_pocn          = -0.1     ! vertical speed of pocn [m/day]
  real :: w_pocn_sedi     = -0.05    ! sedimentation velocity (negative for downward) [m/day]
  real :: fac_doc_assim   = 1.0      ! factor modifying assimilation rate for POC production
  real :: fac_dop_assim   = 0.5      ! factor modifying assimilation rate for POCP production
  real :: fac_don_assim   = 1.0      ! factor modifying assimilation rate for POCN production
  real :: fac_enh_rec     = 10.0     ! enhance recyclig of DON,POCN/DOP,POCP in case of limiting DIN/DIP
  real :: ret_po4_1       = 0.15     ! PO4 retension in oxic sediments
  real :: ret_po4_2       = 0.5      ! additional PO4 retension in oxic sediments of the Bothnian Sea
  real :: frac_denit_scal = 1.0      ! scaling frac_denit_sed
  real :: reduced_rec     = 0.8      ! decrease recycling in sed under anoxia by reduce_rec
  real :: martin_fac_poc  = 0.06     ! [1/d], depth dependence of POC sinking speed
  real :: r_doc2poc       = 0.01     ! POC formation rate
  real :: r_don2pocn      = 0.01     ! POCN formation rate
  real :: r_dop2pocp      = 0.01     ! POCP formation rate
  real :: r_doc_rec       = 0.001    ! recycling rate (doc to dic) at 0C [1/day]
  real :: r_don_rec       = 0.001    ! recycling rate (don to dic and NH4) at 0C [1/day]
  real :: r_dop_rec       = 0.001    ! recycling rate (dop to dic and PO4) at 0C [1/day]

  type(generic_ERGOM_type), save   :: ergom
  type(tracer_2d),            ALLOCATABLE, dimension(:), save :: tracers_2d

  !The following logical for using this module is overwritten
  ! by generic_tracer_nml namelist
  logical, save :: do_generic_ERGOM = .false.

  real :: gamma_1 = 0.0150943    ! constant for opacity contribution of chlorophyll [kg/g/m]
                                 !
                                 ! This is used to estimate a chlorophyll concentration
                                 ! from the bio_opacity of all tracers, assuming all bio_opacity is
                                 ! caused by chlorophyll.
                                 ! This chl concentration is used to provide it for
                                 ! ocean_shortwave_gfdl.F90 which does not want opacity but
                                 ! chl concentration from the biomodel and calculates its own
                                 ! opacity from it

  integer :: NUM_SEDIMENT_LAYERS = 1   ! Default setting is 1 which means fluff layer only.
                                       ! Setting it to a larger value implies the use of a sediment model.
  integer :: NUM_VMOVE_STEPS       = 1
  integer :: RUNGE_KUTTA_DEPTH     = 1
  integer :: SPLITTING_FACTOR_ERGOM= 1
  integer :: n
  integer :: vlev_sed = 2                ! number of 2d tracers that may be stored in one diagnostic 3d tracer

  logical :: genus_style_par = .false.       ! calculate photosynthetically active radiation as in GENUS project
  logical :: implicit_bottomfluxes  = .true. ! tracer concentration changes due to water-sediment interaction are
                                             !   applied outside this module
  logical :: implicit_surfacefluxes = .true. ! tracer concentration changes due to gas exchange in the surface are
                                             !   applied outside this module
  logical :: implicit_movement = .true.      ! vertical migration, sinking and diffusion is applied outside this
                                             !   module

  ! identification numbers for mpp clocks
  integer :: id_source, id_init, id_alloc, id_preloop, id_mainloop, id_vertmig, id_output
  integer :: id_sedsource, id_sedalloc, id_sedpreloop, id_sedmainloop, id_sedvertmig, id_sedoutput

  namelist /ergom_nml/  &
! constants for biomodel
   critical_stress       , & ! critical shear stress for sediment erosion [N/m2]
   cya0                  , & ! seed concentration for diazotroph cyanobacteria [mol/kg]
   din_min_lpp           , & ! DIN half saturation constant for large-cell phytoplankton growth [mol/kg]
   din_min_spp           , & ! DIN half saturation constant for small-cell phytoplankton growth [mol/kg]
   dip_min_cya           , & ! DIP half saturation constant for diazotroph cyanobacteria growth [mol/kg]
   epsilon               , & ! no division by 0
   food_min_zoo          , & ! Ivlev phytoplankton concentration for zooplankton grazing [mol/kg]
   gamma0                , & ! light attentuation parameter (opacity of clear water) [1/m], DO NOT CHANGE NAME gamma0 SINCE THIS NAME WILL BE USED IN THE TEMPLATE
   gamma1                , & ! light attentuation parameter (opacity of POM containing chlorophyll) [m**2/mol]
   gamma2                , & ! light attentuation parameter (opacity of POM detritus) [m**2/mol]
   gamma3                , & ! light attentuation parameter (opacity of DON) [m**2/mol]
   h2s_min_po4_liber       , & ! minimum h2s concentration for liberation of iron phosphate from the sediment [mol/kg]
   ips_threshold         , & ! threshold for increased PO4 burial [mol/m**2]
   ips_cl                , & ! iron phosphate in sediment closure parameter [mol/m2]
   k_h2s_no3             , & ! reaction constant h2s oxidation with no3 [kg/mol/day]
   k_h2s_o2              , & ! reaction constant h2s oxidation with o2 [kg/mol/day]
   k_sul_no3             , & ! reaction constant sul oxidation with no3 [kg/mol/day]
   k_sul_o2              , & ! reaction constant sul oxidation with o2 [kg/mol/day]
   light_opt_cya         , & ! optimal light for diazotroph cyanobacteria growth [W/m**2]
   light_opt_lpp         , & ! optimal light for large-cell phytoplankton growth [W/m**2]
   light_opt_spp         , & ! optimal light for small-cell phytoplankton growth [W/m**2]
   lpp0                  , & ! seed concentration for large-cell phytoplankton [mol/kg]
   no3_min_sed_denit       , & ! nitrate half-saturation concentration for denitrification in the water column [mol/kg]
   no3_min_det_denit       , & ! minimum no3 concentration for recycling of detritus using nitrate (denitrification)
   o2_min_det_resp       , & ! oxygen half-saturation constant for detritus recycling [mol/kg]
   o2_min_nit            , & ! oxygen half-saturation constant for nitrification [mol/kg]
   o2_min_po4_retent       , & ! oxygen half-saturation concentration for retension of phosphate during sediment denitrification [mol/kg]
   o2_min_sed_resp       , & ! oxygen half-saturation constant for recycling of sediment detritus using oxygen [mol/kg]
   patm_co2              , & ! atmospheric partial pressure of CO2 [Pa]
   q10_det_rec           , & ! q10 rule factor for recycling [1/K]
   q10_doc_rec           , & ! q10 rule factor for DOC recycling [1/K]
   q10_h2s               , & ! q10 rule factor for oxidation of h2s and sul [1/K]
   q10_nit               , & ! q10 rule factor for nitrification [1/K]
   q10_sed_rec           , & ! q10 rule factor for detritus recycling in the sediment [1/K]
   r_biores              , & ! bio-resuspension rate [1/day]
   r_cya_assim           , & ! maximum rate for nutrient uptake of diazotroph cyanobacteria [1/day]
   r_cya_resp            , & ! respiration rate of cyanobacteria to ammonium [1/day]
   r_det_rec             , & ! recycling rate (detritus to ammonium) at 0C [1/day]
   r_ips_burial          , & ! final burial rate for PO4 [1/day]
   r_ips_ero             , & ! erosion rate for iron PO4 [1/day]
   r_ips_liber           , & ! PO4 liberation rate under anoxic conditions [1/day]
   r_lpp_assim           , & ! maximum rate for nutrient uptake of large-cell phytoplankton [1/day]
   r_lpp_resp            , & ! respiration rate of large phytoplankton to ammonium [1/day]
   r_nh4_nitrif          , & ! nitrification rate at 0C [1/day]
   r_pp_mort             , & ! mortality rate of phytoplankton [1/day]
   r_cya_mort_diff       , & ! enhanced cya mortality due to strong turbulence
   r_cya_mort_thresh       , & ! diffusivity threshold for enhanced cyano mortality
   r_sed_ero             , & ! maximum sediment detritus erosion rate [1/day]
   r_sed_rec             , & ! maximum recycling rate of sediment to ammonium [1/day]
   r_spp_assim           , & ! maximum rate for nutrient uptake of small-cell phytoplankton [1/day]
   r_spp_resp            , & ! respiration rate of small phytoplankton to ammonium [1/day]
   r_zoo_graz            , & ! maximum zooplankton grazing rate [1/day]
   r_zoo_mort            , & ! mortality rate of zooplankton [1/day]
   r_zoo_resp            , & ! respiration rate of zooplankton [1/day]
   rfr_c                 , & ! redfield ratio C/N
   rfr_h                 , & ! redfield ratio H/N
   rfr_o                 , & ! redfield ratio O/N
   rfr_p                 , & ! redfield ratio P/N
   rfr_cp                , & ! redfield ratio C/P
   sali_max_cya          , & ! upper salinity limit - diazotroph cyanobacteria [psu]
   sali_min_cya          , & ! lower salinity limit - diazotroph cyanobacteria [psu]
   sed_max               , & ! maximum sediment detritus concentration that feels erosion [mol/m**2]
   spp0                  , & ! seed concentration for small-cell phytoplankton [mol/kg]
   temp_min_cya          , & ! lower temperature limit - diazotroph cyanobacteria [C]
   temp_min_spp          , & ! lower temperature limit - small-cell phytoplankton [C]
   temp_opt_zoo          , & ! optimal temperature for zooplankton grazing [C]
   w_co2_stf             , & ! piston velocity for co2 surface flux [m/d]
   w_cya                 , & ! vertical speed of diazotroph cyanobacteria [m/day]
   w_det                 , & ! vertical speed of detritus [m/day]
   w_det_sedi            , & ! sedimentation velocity (negative for downward) [m/day]
   w_ipw                 , & ! vertical speed of suspended iron PO4 [m/day]
   w_ipw_sedi            , & ! sedimentation velocity for iron PO4 [m/day]
   w_lpp                 , & ! vertical speed of large-cell phytoplankton [m/day]
   w_n2_stf              , & ! piston velocity for n2 surface flux [m/d]
   w_o2_stf              , & ! piston velocity for oxygen surface flux [m/d]
   zoo0                  , & ! seed concentration for zooplankton [mol/kg]
   zoo_cl                , & ! zooplankton closure parameter [mol/kg]
   don_fraction          , & ! fraction of DON in respiration products
   r_poc_rec             , & ! recycling rate (poc to dic) at 0C [1/day]
   r_pocp_rec            , & ! recycling rate (pocp to dic and po4) at 0C [1/day]
   r_pocn_rec            , & ! recycling rate (pocn to dic and nh4) at 0C [1/day]
   w_poc                 , & ! vertical speed of poc [m/day]
   w_poc_sedi            , & ! sedimentation velocity (negative for downward) [m/day]
   w_pocp                , & ! vertical speed of pocp [m/day]
   w_pocp_sedi           , & ! sedimentation velocity (negative for downward) [m/day]
   w_pocn                , & ! vertical speed of pocn [m/day]
   w_pocn_sedi           , & ! sedimentation velocity (negative for downward) [m/day]
   fac_doc_assim         , & ! factor modifying assimilation rate for POC production
   fac_dop_assim         , & ! factor modifying assimilation rate for POCP production
   fac_don_assim         , & ! factor modifying assimilation rate for POCN production
   fac_enh_rec           , & ! enhance recyclig of DON,POCN/DOP,POCP in case of limiting DIN/DIP
   ret_po4_1             , & ! PO4 retension in oxic sediments
   ret_po4_2             , & ! additional PO4 retension in oxic sediments of the Bothnian Sea
   frac_denit_scal       , & ! scaling frac_denit_sed
   reduced_rec           , & ! decrease recycling in sed under anoxia by reduce_rec
   martin_fac_poc        , & ! [1/d], depth dependence of POC sinking speed
   r_doc2poc             , & ! POC formation rate
   r_don2pocn            , & ! POCN formation rate
   r_dop2pocp            , & ! POCP formation rate
   r_doc_rec             , & ! recycling rate (doc to dic) at 0C [1/day]
   r_don_rec             , & ! recycling rate (don to dic and NH4) at 0C [1/day]
   r_dop_rec             , & ! recycling rate (dop to dic and PO4) at 0C [1/day]
   NUM_SEDIMENT_LAYERS , & ! Default value is 1 which means one fluffy layer only.
                           ! Setting it to a value larger than 1 means a sediment model will be used.
   NUM_VMOVE_STEPS     , &
   RUNGE_KUTTA_DEPTH   , &
   SPLITTING_FACTOR_ERGOM , & ! how many ocean model time steps are one ERGOM time step
   gamma_1                , & ! constant for opacity contribution of chlorophyll [kg/g/m]
   genus_style_par        , & ! calculate light intensity as it was done in the GENUS model
   implicit_bottomfluxes  , & ! tracer concentration changes due to water-sediment interaction are
                              !   applied outside this module
   implicit_surfacefluxes , & ! tracer concentration changes due to gas exchange in the surface are
                              !   applied outside this module
   implicit_movement      , & ! vertical migration, sinking and diffusion is applied outside this
                              !   module by an implicit method
   vlev_sed

contains

  subroutine generic_ERGOM_register(tracer_list)
    type(g_tracer_type), pointer :: tracer_list

    character(len=fm_string_len), parameter :: sub_name = 'generic_ERGOM_register'
    character(len=fm_string_len) :: errorstring
    integer :: ioun, io_status, ierr, i, j
    logical :: found

    ! provide for namelist over-ride of defaults
    ioun = open_namelist_file()
    read  (ioun, ergom_nml,iostat=io_status)
    write (stdout(),'(/)')
    write (stdout(), ergom_nml)
    write (stdlog(), ergom_nml)
    ierr = check_nml_error(io_status,'ergom_nml')
    call close_file (ioun)

    !Specify all prognostic and diagnostic tracers of this modules.
    call user_add_tracers(tracer_list)

  end subroutine generic_ERGOM_register

  ! <SUBROUTINE NAME="generic_ERGOM_init">
  !  <OVERVIEW>
  !   Initialize the generic ERGOM module
  !  </OVERVIEW>
  !  Ecological ReGional Ocean Model
  !   This subroutine:
  !       Adds all the CFC Tracers to the list of generic Tracers passed to it
  !       via utility subroutine g_tracer_add().
  !       Adds all the parameters used by this module via utility subroutine g_tracer_add_param().
  !       Allocates all work arrays used in the module.
  !  </DESCRIPTION>
  !  <TEMPLATE>
  !   call generic_ERGOM_init(tracer_list)
  !  </TEMPLATE>
  !  <IN NAME="tracer_list" TYPE="type(g_tracer_type), pointer">
  !   Pointer to the head of generic tracer list.
  !  </IN>
  ! </SUBROUTINE>

  subroutine generic_ERGOM_init(tracer_list)
    type(g_tracer_type), pointer :: tracer_list

    character(len=fm_string_len), parameter :: sub_name = 'generic_ERGOM_init'
    integer :: ioun, io_status, ierr

    id_init     = mpp_clock_id('(ERGOM init) '            ,grain=CLOCK_ROUTINE)
    id_alloc    = mpp_clock_id('(ERGOM allocate) '        ,grain=CLOCK_ROUTINE)
    id_source   = mpp_clock_id('(ERGOM source) '          ,grain=CLOCK_ROUTINE)
    id_preloop  = mpp_clock_id('(ERGOM source pre-loop) ' ,grain=CLOCK_ROUTINE)
    id_mainloop = mpp_clock_id('(ERGOM source main loop) ',grain=CLOCK_ROUTINE)
    id_vertmig  = mpp_clock_id('(ERGOM source vmove) '    ,grain=CLOCK_ROUTINE)
    id_output   = mpp_clock_id('(ERGOM source output) '   ,grain=CLOCK_ROUTINE)

    call mpp_clock_begin(id_init)
    call write_version_number( version, tagname )

    ! provide for namelist over-ride of defaults
    ioun = open_namelist_file()
    read  (ioun, ergom_nml,iostat=io_status)
    write (stdout(),'(/)')
    write (stdout(), ergom_nml)
    write (stdlog(), ergom_nml)
    ierr = check_nml_error(io_status,'ergom_nml')
    call close_file (ioun)

    if (NUM_SEDIMENT_LAYERS .gt. 1) then
       id_sedalloc    = mpp_clock_id('(ERGOM SED allocate) '        ,grain=CLOCK_ROUTINE)
       id_sedsource   = mpp_clock_id('(ERGOM SED source) '          ,grain=CLOCK_ROUTINE)
       id_sedpreloop  = mpp_clock_id('(ERGOM SED source pre-loop) ' ,grain=CLOCK_ROUTINE)
       id_sedmainloop = mpp_clock_id('(ERGOM SED source main loop) ',grain=CLOCK_ROUTINE)
       id_sedvertmig  = mpp_clock_id('(ERGOM SED source vmove) '    ,grain=CLOCK_ROUTINE)
       id_sedoutput   = mpp_clock_id('(ERGOM SED source output) '   ,grain=CLOCK_ROUTINE)
    endif

    !Specify and initialize all parameters used by this package
    call user_add_params

    !Allocate and initiate all the private work arrays used by this module.
    call user_allocate_arrays

    ! now print a summary of all parameters
    write (stdout(),'(/)')
    write (stdout(),*) 'Summary of the ERGOM model setup'
    write (stdout(),*) 'CONSTANTS:'
    write (stdout(),'((a), e13.6)')'    critical_stress		        : ', critical_stress
    write (stdout(),'(a)')         '        = critical shear stress for sediment erosion [N/m2]'
    write (stdout(),'((a), e13.6)')'    cya0           		        : ', cya0           
    write (stdout(),'(a)')         '        = seed concentration for diazotroph cyanobacteria [mol/kg]'
    write (stdout(),'((a), e13.6)')'    din_min_lpp    		        : ', din_min_lpp    
    write (stdout(),'(a)')         '        = DIN half saturation constant for large-cell phytoplankton growth [mol/kg]'
    write (stdout(),'((a), e13.6)')'    din_min_spp    		        : ', din_min_spp    
    write (stdout(),'(a)')         '        = DIN half saturation constant for small-cell phytoplankton growth [mol/kg]'
    write (stdout(),'((a), e13.6)')'    dip_min_cya    		        : ', dip_min_cya    
    write (stdout(),'(a)')         '        = DIP half saturation constant for diazotroph cyanobacteria growth [mol/kg]'
    write (stdout(),'((a), e13.6)')'    epsilon        		        : ', epsilon        
    write (stdout(),'(a)')         '        = no division by 0'
    write (stdout(),'((a), e13.6)')'    food_min_zoo   		        : ', food_min_zoo   
    write (stdout(),'(a)')         '        = Ivlev phytoplankton concentration for zooplankton grazing [mol/kg]'
    write (stdout(),'((a), e13.6)')'    gamma0         		        : ', gamma0         
    write (stdout(),'(a)')         '        = light attentuation parameter (opacity of clear water) [1/m], DO NOT CHANGE NAME gamma0 SINCE THIS NAME WILL BE USED IN THE TEMPLATE'
    write (stdout(),'((a), e13.6)')'    gamma1         		        : ', gamma1         
    write (stdout(),'(a)')         '        = light attentuation parameter (opacity of POM containing chlorophyll) [m**2/mol]'
    write (stdout(),'((a), e13.6)')'    gamma2         		        : ', gamma2         
    write (stdout(),'(a)')         '        = light attentuation parameter (opacity of POM detritus) [m**2/mol]'
    write (stdout(),'((a), e13.6)')'    gamma3         		        : ', gamma3         
    write (stdout(),'(a)')         '        = light attentuation parameter (opacity of DON) [m**2/mol]'
    write (stdout(),'((a), e13.6)')'    h2s_min_po4_liber		        : ', h2s_min_po4_liber
    write (stdout(),'(a)')         '        = minimum h2s concentration for liberation of iron phosphate from the sediment [mol/kg]'
    write (stdout(),'((a), e13.6)')'    ips_threshold  		        : ', ips_threshold  
    write (stdout(),'(a)')         '        = threshold for increased PO4 burial [mol/m**2]'
    write (stdout(),'((a), e13.6)')'    ips_cl         		        : ', ips_cl         
    write (stdout(),'(a)')         '        = iron phosphate in sediment closure parameter [mol/m2]'
    write (stdout(),'((a), e13.6)')'    k_h2s_no3      		        : ', k_h2s_no3      
    write (stdout(),'(a)')         '        = reaction constant h2s oxidation with no3 [kg/mol/day]'
    write (stdout(),'((a), e13.6)')'    k_h2s_o2       		        : ', k_h2s_o2       
    write (stdout(),'(a)')         '        = reaction constant h2s oxidation with o2 [kg/mol/day]'
    write (stdout(),'((a), e13.6)')'    k_sul_no3      		        : ', k_sul_no3      
    write (stdout(),'(a)')         '        = reaction constant sul oxidation with no3 [kg/mol/day]'
    write (stdout(),'((a), e13.6)')'    k_sul_o2       		        : ', k_sul_o2       
    write (stdout(),'(a)')         '        = reaction constant sul oxidation with o2 [kg/mol/day]'
    write (stdout(),'((a), e13.6)')'    light_opt_cya  		        : ', light_opt_cya  
    write (stdout(),'(a)')         '        = optimal light for diazotroph cyanobacteria growth [W/m**2]'
    write (stdout(),'((a), e13.6)')'    light_opt_lpp  		        : ', light_opt_lpp  
    write (stdout(),'(a)')         '        = optimal light for large-cell phytoplankton growth [W/m**2]'
    write (stdout(),'((a), e13.6)')'    light_opt_spp  		        : ', light_opt_spp  
    write (stdout(),'(a)')         '        = optimal light for small-cell phytoplankton growth [W/m**2]'
    write (stdout(),'((a), e13.6)')'    lpp0           		        : ', lpp0           
    write (stdout(),'(a)')         '        = seed concentration for large-cell phytoplankton [mol/kg]'
    write (stdout(),'((a), e13.6)')'    no3_min_sed_denit		        : ', no3_min_sed_denit
    write (stdout(),'(a)')         '        = nitrate half-saturation concentration for denitrification in the water column [mol/kg]'
    write (stdout(),'((a), e13.6)')'    no3_min_det_denit		        : ', no3_min_det_denit
    write (stdout(),'(a)')         '        = minimum no3 concentration for recycling of detritus using nitrate (denitrification)'
    write (stdout(),'((a), e13.6)')'    o2_min_det_resp		        : ', o2_min_det_resp
    write (stdout(),'(a)')         '        = oxygen half-saturation constant for detritus recycling [mol/kg]'
    write (stdout(),'((a), e13.6)')'    o2_min_nit     		        : ', o2_min_nit     
    write (stdout(),'(a)')         '        = oxygen half-saturation constant for nitrification [mol/kg]'
    write (stdout(),'((a), e13.6)')'    o2_min_po4_retent		        : ', o2_min_po4_retent
    write (stdout(),'(a)')         '        = oxygen half-saturation concentration for retension of phosphate during sediment denitrification [mol/kg]'
    write (stdout(),'((a), e13.6)')'    o2_min_sed_resp		        : ', o2_min_sed_resp
    write (stdout(),'(a)')         '        = oxygen half-saturation constant for recycling of sediment detritus using oxygen [mol/kg]'
    write (stdout(),'((a), e13.6)')'    patm_co2       		        : ', patm_co2       
    write (stdout(),'(a)')         '        = atmospheric partial pressure of CO2 [Pa]'
    write (stdout(),'((a), e13.6)')'    q10_det_rec    		        : ', q10_det_rec    
    write (stdout(),'(a)')         '        = q10 rule factor for recycling [1/K]'
    write (stdout(),'((a), e13.6)')'    q10_doc_rec    		        : ', q10_doc_rec    
    write (stdout(),'(a)')         '        = q10 rule factor for DOC recycling [1/K]'
    write (stdout(),'((a), e13.6)')'    q10_h2s        		        : ', q10_h2s        
    write (stdout(),'(a)')         '        = q10 rule factor for oxidation of h2s and sul [1/K]'
    write (stdout(),'((a), e13.6)')'    q10_nit        		        : ', q10_nit        
    write (stdout(),'(a)')         '        = q10 rule factor for nitrification [1/K]'
    write (stdout(),'((a), e13.6)')'    q10_sed_rec    		        : ', q10_sed_rec    
    write (stdout(),'(a)')         '        = q10 rule factor for detritus recycling in the sediment [1/K]'
    write (stdout(),'((a), e13.6)')'    r_biores       		        : ', r_biores       
    write (stdout(),'(a)')         '        = bio-resuspension rate [1/day]'
    write (stdout(),'((a), e13.6)')'    r_cya_assim    		        : ', r_cya_assim    
    write (stdout(),'(a)')         '        = maximum rate for nutrient uptake of diazotroph cyanobacteria [1/day]'
    write (stdout(),'((a), e13.6)')'    r_cya_resp     		        : ', r_cya_resp     
    write (stdout(),'(a)')         '        = respiration rate of cyanobacteria to ammonium [1/day]'
    write (stdout(),'((a), e13.6)')'    r_det_rec      		        : ', r_det_rec      
    write (stdout(),'(a)')         '        = recycling rate (detritus to ammonium) at 0C [1/day]'
    write (stdout(),'((a), e13.6)')'    r_ips_burial   		        : ', r_ips_burial   
    write (stdout(),'(a)')         '        = final burial rate for PO4 [1/day]'
    write (stdout(),'((a), e13.6)')'    r_ips_ero      		        : ', r_ips_ero      
    write (stdout(),'(a)')         '        = erosion rate for iron PO4 [1/day]'
    write (stdout(),'((a), e13.6)')'    r_ips_liber    		        : ', r_ips_liber    
    write (stdout(),'(a)')         '        = PO4 liberation rate under anoxic conditions [1/day]'
    write (stdout(),'((a), e13.6)')'    r_lpp_assim    		        : ', r_lpp_assim    
    write (stdout(),'(a)')         '        = maximum rate for nutrient uptake of large-cell phytoplankton [1/day]'
    write (stdout(),'((a), e13.6)')'    r_lpp_resp     		        : ', r_lpp_resp     
    write (stdout(),'(a)')         '        = respiration rate of large phytoplankton to ammonium [1/day]'
    write (stdout(),'((a), e13.6)')'    r_nh4_nitrif   		        : ', r_nh4_nitrif   
    write (stdout(),'(a)')         '        = nitrification rate at 0C [1/day]'
    write (stdout(),'((a), e13.6)')'    r_pp_mort      		        : ', r_pp_mort      
    write (stdout(),'(a)')         '        = mortality rate of phytoplankton [1/day]'
    write (stdout(),'((a), e13.6)')'    r_cya_mort_diff		        : ', r_cya_mort_diff
    write (stdout(),'(a)')         '        = enhanced cya mortality due to strong turbulence'
    write (stdout(),'((a), e13.6)')'    r_cya_mort_thresh		        : ', r_cya_mort_thresh
    write (stdout(),'(a)')         '        = diffusivity threshold for enhanced cyano mortality'
    write (stdout(),'((a), e13.6)')'    r_sed_ero      		        : ', r_sed_ero      
    write (stdout(),'(a)')         '        = maximum sediment detritus erosion rate [1/day]'
    write (stdout(),'((a), e13.6)')'    r_sed_rec      		        : ', r_sed_rec      
    write (stdout(),'(a)')         '        = maximum recycling rate of sediment to ammonium [1/day]'
    write (stdout(),'((a), e13.6)')'    r_spp_assim    		        : ', r_spp_assim    
    write (stdout(),'(a)')         '        = maximum rate for nutrient uptake of small-cell phytoplankton [1/day]'
    write (stdout(),'((a), e13.6)')'    r_spp_resp     		        : ', r_spp_resp     
    write (stdout(),'(a)')         '        = respiration rate of small phytoplankton to ammonium [1/day]'
    write (stdout(),'((a), e13.6)')'    r_zoo_graz     		        : ', r_zoo_graz     
    write (stdout(),'(a)')         '        = maximum zooplankton grazing rate [1/day]'
    write (stdout(),'((a), e13.6)')'    r_zoo_mort     		        : ', r_zoo_mort     
    write (stdout(),'(a)')         '        = mortality rate of zooplankton [1/day]'
    write (stdout(),'((a), e13.6)')'    r_zoo_resp     		        : ', r_zoo_resp     
    write (stdout(),'(a)')         '        = respiration rate of zooplankton [1/day]'
    write (stdout(),'((a), e13.6)')'    rfr_c          		        : ', rfr_c          
    write (stdout(),'(a)')         '        = redfield ratio C/N'
    write (stdout(),'((a), e13.6)')'    rfr_h          		        : ', rfr_h          
    write (stdout(),'(a)')         '        = redfield ratio H/N'
    write (stdout(),'((a), e13.6)')'    rfr_o          		        : ', rfr_o          
    write (stdout(),'(a)')         '        = redfield ratio O/N'
    write (stdout(),'((a), e13.6)')'    rfr_p          		        : ', rfr_p          
    write (stdout(),'(a)')         '        = redfield ratio P/N'
    write (stdout(),'((a), e13.6)')'    rfr_cp         		        : ', rfr_cp         
    write (stdout(),'(a)')         '        = redfield ratio C/P'
    write (stdout(),'((a), e13.6)')'    sali_max_cya   		        : ', sali_max_cya   
    write (stdout(),'(a)')         '        = upper salinity limit - diazotroph cyanobacteria [psu]'
    write (stdout(),'((a), e13.6)')'    sali_min_cya   		        : ', sali_min_cya   
    write (stdout(),'(a)')         '        = lower salinity limit - diazotroph cyanobacteria [psu]'
    write (stdout(),'((a), e13.6)')'    sed_max        		        : ', sed_max        
    write (stdout(),'(a)')         '        = maximum sediment detritus concentration that feels erosion [mol/m**2]'
    write (stdout(),'((a), e13.6)')'    spp0           		        : ', spp0           
    write (stdout(),'(a)')         '        = seed concentration for small-cell phytoplankton [mol/kg]'
    write (stdout(),'((a), e13.6)')'    temp_min_cya   		        : ', temp_min_cya   
    write (stdout(),'(a)')         '        = lower temperature limit - diazotroph cyanobacteria [C]'
    write (stdout(),'((a), e13.6)')'    temp_min_spp   		        : ', temp_min_spp   
    write (stdout(),'(a)')         '        = lower temperature limit - small-cell phytoplankton [C]'
    write (stdout(),'((a), e13.6)')'    temp_opt_zoo   		        : ', temp_opt_zoo   
    write (stdout(),'(a)')         '        = optimal temperature for zooplankton grazing [C]'
    write (stdout(),'((a), e13.6)')'    w_co2_stf      		        : ', w_co2_stf      
    write (stdout(),'(a)')         '        = piston velocity for co2 surface flux [m/d]'
    write (stdout(),'((a), e13.6)')'    w_cya          		        : ', w_cya          
    write (stdout(),'(a)')         '        = vertical speed of diazotroph cyanobacteria [m/day]'
    write (stdout(),'((a), e13.6)')'    w_det          		        : ', w_det          
    write (stdout(),'(a)')         '        = vertical speed of detritus [m/day]'
    write (stdout(),'((a), e13.6)')'    w_det_sedi     		        : ', w_det_sedi     
    write (stdout(),'(a)')         '        = sedimentation velocity (negative for downward) [m/day]'
    write (stdout(),'((a), e13.6)')'    w_ipw          		        : ', w_ipw          
    write (stdout(),'(a)')         '        = vertical speed of suspended iron PO4 [m/day]'
    write (stdout(),'((a), e13.6)')'    w_ipw_sedi     		        : ', w_ipw_sedi     
    write (stdout(),'(a)')         '        = sedimentation velocity for iron PO4 [m/day]'
    write (stdout(),'((a), e13.6)')'    w_lpp          		        : ', w_lpp          
    write (stdout(),'(a)')         '        = vertical speed of large-cell phytoplankton [m/day]'
    write (stdout(),'((a), e13.6)')'    w_n2_stf       		        : ', w_n2_stf       
    write (stdout(),'(a)')         '        = piston velocity for n2 surface flux [m/d]'
    write (stdout(),'((a), e13.6)')'    w_o2_stf       		        : ', w_o2_stf       
    write (stdout(),'(a)')         '        = piston velocity for oxygen surface flux [m/d]'
    write (stdout(),'((a), e13.6)')'    zoo0           		        : ', zoo0           
    write (stdout(),'(a)')         '        = seed concentration for zooplankton [mol/kg]'
    write (stdout(),'((a), e13.6)')'    zoo_cl         		        : ', zoo_cl         
    write (stdout(),'(a)')         '        = zooplankton closure parameter [mol/kg]'
    write (stdout(),'((a), e13.6)')'    don_fraction   		        : ', don_fraction   
    write (stdout(),'(a)')         '        = fraction of DON in respiration products'
    write (stdout(),'((a), e13.6)')'    r_poc_rec      		        : ', r_poc_rec      
    write (stdout(),'(a)')         '        = recycling rate (poc to dic) at 0C [1/day]'
    write (stdout(),'((a), e13.6)')'    r_pocp_rec     		        : ', r_pocp_rec     
    write (stdout(),'(a)')         '        = recycling rate (pocp to dic and po4) at 0C [1/day]'
    write (stdout(),'((a), e13.6)')'    r_pocn_rec     		        : ', r_pocn_rec     
    write (stdout(),'(a)')         '        = recycling rate (pocn to dic and nh4) at 0C [1/day]'
    write (stdout(),'((a), e13.6)')'    w_poc          		        : ', w_poc          
    write (stdout(),'(a)')         '        = vertical speed of poc [m/day]'
    write (stdout(),'((a), e13.6)')'    w_poc_sedi     		        : ', w_poc_sedi     
    write (stdout(),'(a)')         '        = sedimentation velocity (negative for downward) [m/day]'
    write (stdout(),'((a), e13.6)')'    w_pocp         		        : ', w_pocp         
    write (stdout(),'(a)')         '        = vertical speed of pocp [m/day]'
    write (stdout(),'((a), e13.6)')'    w_pocp_sedi    		        : ', w_pocp_sedi    
    write (stdout(),'(a)')         '        = sedimentation velocity (negative for downward) [m/day]'
    write (stdout(),'((a), e13.6)')'    w_pocn         		        : ', w_pocn         
    write (stdout(),'(a)')         '        = vertical speed of pocn [m/day]'
    write (stdout(),'((a), e13.6)')'    w_pocn_sedi    		        : ', w_pocn_sedi    
    write (stdout(),'(a)')         '        = sedimentation velocity (negative for downward) [m/day]'
    write (stdout(),'((a), e13.6)')'    fac_doc_assim  		        : ', fac_doc_assim  
    write (stdout(),'(a)')         '        = factor modifying assimilation rate for POC production'
    write (stdout(),'((a), e13.6)')'    fac_dop_assim  		        : ', fac_dop_assim  
    write (stdout(),'(a)')         '        = factor modifying assimilation rate for POCP production'
    write (stdout(),'((a), e13.6)')'    fac_don_assim  		        : ', fac_don_assim  
    write (stdout(),'(a)')         '        = factor modifying assimilation rate for POCN production'
    write (stdout(),'((a), e13.6)')'    fac_enh_rec    		        : ', fac_enh_rec    
    write (stdout(),'(a)')         '        = enhance recyclig of DON,POCN/DOP,POCP in case of limiting DIN/DIP'
    write (stdout(),'((a), e13.6)')'    ret_po4_1      		        : ', ret_po4_1      
    write (stdout(),'(a)')         '        = PO4 retension in oxic sediments'
    write (stdout(),'((a), e13.6)')'    ret_po4_2      		        : ', ret_po4_2      
    write (stdout(),'(a)')         '        = additional PO4 retension in oxic sediments of the Bothnian Sea'
    write (stdout(),'((a), e13.6)')'    frac_denit_scal		        : ', frac_denit_scal
    write (stdout(),'(a)')         '        = scaling frac_denit_sed'
    write (stdout(),'((a), e13.6)')'    reduced_rec    		        : ', reduced_rec    
    write (stdout(),'(a)')         '        = decrease recycling in sed under anoxia by reduce_rec'
    write (stdout(),'((a), e13.6)')'    martin_fac_poc 		        : ', martin_fac_poc 
    write (stdout(),'(a)')         '        = [1/d], depth dependence of POC sinking speed'
    write (stdout(),'((a), e13.6)')'    r_doc2poc      		        : ', r_doc2poc      
    write (stdout(),'(a)')         '        = POC formation rate'
    write (stdout(),'((a), e13.6)')'    r_don2pocn     		        : ', r_don2pocn     
    write (stdout(),'(a)')         '        = POCN formation rate'
    write (stdout(),'((a), e13.6)')'    r_dop2pocp     		        : ', r_dop2pocp     
    write (stdout(),'(a)')         '        = POCP formation rate'
    write (stdout(),'((a), e13.6)')'    r_doc_rec      		        : ', r_doc_rec      
    write (stdout(),'(a)')         '        = recycling rate (doc to dic) at 0C [1/day]'
    write (stdout(),'((a), e13.6)')'    r_don_rec      		        : ', r_don_rec      
    write (stdout(),'(a)')         '        = recycling rate (don to dic and NH4) at 0C [1/day]'
    write (stdout(),'((a), e13.6)')'    r_dop_rec      		        : ', r_dop_rec      
    write (stdout(),'(a)')         '        = recycling rate (dop to dic and PO4) at 0C [1/day]'
    write (stdout(),'(/)')
    write (stdout(),*) 'TRACERS (3d, no vertical movement):'
    write (stdout(),'(a)')         '    t_n2           '
    write (stdout(),'((a), e13.6)')'        opacity        [m2/mol]: ',0.0
    write (stdout(),'(a)')         '    t_o2           '
    write (stdout(),'((a), e13.6)')'        opacity        [m2/mol]: ',0.0
    write (stdout(),'(a)')         '    t_dic          '
    write (stdout(),'((a), e13.6)')'        opacity        [m2/mol]: ',0.0
    write (stdout(),'(a)')         '    t_nh4          '
    write (stdout(),'((a), e13.6)')'        opacity        [m2/mol]: ',0.0
    write (stdout(),'(a)')         '    t_no3          '
    write (stdout(),'((a), e13.6)')'        opacity        [m2/mol]: ',0.0
    write (stdout(),'(a)')         '    t_po4          '
    write (stdout(),'((a), e13.6)')'        opacity        [m2/mol]: ',0.0
    write (stdout(),'(a)')         '    t_spp          '
    write (stdout(),'((a), e13.6)')'        opacity        [m2/mol]: ',gamma1
    write (stdout(),'(a)')         '    t_zoo          '
    write (stdout(),'((a), e13.6)')'        opacity        [m2/mol]: ',0.0
    write (stdout(),'(a)')         '    t_h2s          '
    write (stdout(),'((a), e13.6)')'        opacity        [m2/mol]: ',0.0
    write (stdout(),'(a)')         '    t_sul          '
    write (stdout(),'((a), e13.6)')'        opacity        [m2/mol]: ',0.0
    write (stdout(),'(a)')         '    t_alk          '
    write (stdout(),'((a), e13.6)')'        opacity        [m2/mol]: ',0.0
    write (stdout(),'(a)')         '    t_doc          '
    write (stdout(),'((a), e13.6)')'        opacity        [m2/mol]: ',0.0
    write (stdout(),'(a)')         '    t_dop          '
    write (stdout(),'((a), e13.6)')'        opacity        [m2/mol]: ',0.0
    write (stdout(),'(a)')         '    total_atmos_tot_N'
    write (stdout(),'((a), e13.6)')'        opacity        [m2/mol]: ',0.0
    write (stdout(),'(a)')         '    total_atmos_ship_N'
    write (stdout(),'((a), e13.6)')'        opacity        [m2/mol]: ',0.0
    write (stdout(),'(a)')         '    t_n2_with_atmos_tot_N'
    write (stdout(),'((a), e13.6)')'        opacity        [m2/mol]: ',0.0
    write (stdout(),'(a)')         '    t_nh4_with_atmos_tot_N'
    write (stdout(),'((a), e13.6)')'        opacity        [m2/mol]: ',0.0
    write (stdout(),'(a)')         '    t_no3_with_atmos_tot_N'
    write (stdout(),'((a), e13.6)')'        opacity        [m2/mol]: ',0.0
    write (stdout(),'(a)')         '    t_spp_with_atmos_tot_N'
    write (stdout(),'((a), e13.6)')'        opacity        [m2/mol]: ',0.0
    write (stdout(),'(a)')         '    t_zoo_with_atmos_tot_N'
    write (stdout(),'((a), e13.6)')'        opacity        [m2/mol]: ',0.0
    write (stdout(),'(a)')         '    t_n2_with_atmos_ship_N'
    write (stdout(),'((a), e13.6)')'        opacity        [m2/mol]: ',0.0
    write (stdout(),'(a)')         '    t_nh4_with_atmos_ship_N'
    write (stdout(),'((a), e13.6)')'        opacity        [m2/mol]: ',0.0
    write (stdout(),'(a)')         '    t_no3_with_atmos_ship_N'
    write (stdout(),'((a), e13.6)')'        opacity        [m2/mol]: ',0.0
    write (stdout(),'(a)')         '    t_spp_with_atmos_ship_N'
    write (stdout(),'((a), e13.6)')'        opacity        [m2/mol]: ',0.0
    write (stdout(),'(a)')         '    t_zoo_with_atmos_ship_N'
    write (stdout(),'((a), e13.6)')'        opacity        [m2/mol]: ',0.0
    write (stdout(),'(/)')
    write (stdout(),*) 'TRACERS (3d, vertical movement):'
    write (stdout(),'(a)')         '    t_ipw            (suspended iron phosphate)'
    write (stdout(),'((a), e13.6)')'        vertical speed [m /day]: '//'w_ipw=',-1.0
    write (stdout(),'((a), e13.6)')'        opacity        [m2/mol]: ',0.0
    write (stdout(),'(a)')         '    t_pocn_with_atmos_tot_N  (nitrogen in particulate organic carbon in Redfield ratio; containing nitrogen from (total) atmospheric deposition)'
    write (stdout(),'((a), e13.6)')'        vertical speed [m /day]: '//'w_pocn=',-0.1
    write (stdout(),'((a), e13.6)')'        opacity        [m2/mol]: ',0.0
    write (stdout(),'(a)')         '    t_lpp_with_atmos_tot_N  (large-cell phytoplankton; containing nitrogen from (total) atmospheric deposition)'
    write (stdout(),'((a), e13.6)')'        vertical speed [m /day]: '//'w_lpp=',-0.5
    write (stdout(),'((a), e13.6)')'        opacity        [m2/mol]: ',0.0
    write (stdout(),'(a)')         '    t_don_with_atmos_tot_N  (nitrogen in dissolved organic carbon in Redfield ratio; containing nitrogen from (total) atmospheric deposition)'
    write (stdout(),'((a), e13.6)')'        vertical speed [m /day]: '//'w_pocn=',-0.1
    write (stdout(),'((a), e13.6)')'        opacity        [m2/mol]: ',0.0
    write (stdout(),'(a)')         '    t_cya_with_atmos_tot_N  (diazotroph cyanobacteria; containing nitrogen from (total) atmospheric deposition)'
    write (stdout(),'((a), e13.6)')'        vertical speed [m /day]: '//'w_cya=',1.0
    write (stdout(),'((a), e13.6)')'        opacity        [m2/mol]: ',0.0
    write (stdout(),'(a)')         '    t_det_with_atmos_tot_N  (detritus; containing nitrogen from (total) atmospheric deposition)'
    write (stdout(),'((a), e13.6)')'        vertical speed [m /day]: '//'w_det=',-4.5
    write (stdout(),'((a), e13.6)')'        opacity        [m2/mol]: ',0.0
    write (stdout(),'(a)')         '    t_lpp            (large-cell phytoplankton)'
    write (stdout(),'((a), e13.6)')'        vertical speed [m /day]: '//'w_lpp=',-0.5
    write (stdout(),'((a), e13.6)')'        opacity        [m2/mol]: ',gamma1
    write (stdout(),'(a)')         '    t_don            (nitrogen in dissolved organic carbon in Redfield ratio)'
    write (stdout(),'((a), e13.6)')'        vertical speed [m /day]: '//'w_pocn=',-0.1
    write (stdout(),'((a), e13.6)')'        opacity        [m2/mol]: ',gamma3
    write (stdout(),'(a)')         '    t_cya            (diazotroph cyanobacteria)'
    write (stdout(),'((a), e13.6)')'        vertical speed [m /day]: '//'w_cya=',1.0
    write (stdout(),'((a), e13.6)')'        opacity        [m2/mol]: ',gamma1
    write (stdout(),'(a)')         '    t_det            (detritus)'
    write (stdout(),'((a), e13.6)')'        vertical speed [m /day]: '//'w_det=',-4.5
    write (stdout(),'((a), e13.6)')'        opacity        [m2/mol]: ',gamma2
    write (stdout(),'(a)')         '    t_poc            (particulate organic carbon)'
    write (stdout(),'((a), e13.6)')'        vertical speed [m /day]: '//'w_poc=',-0.2
    write (stdout(),'((a), e13.6)')'        opacity        [m2/mol]: ',0.0
    write (stdout(),'(a)')         '    t_pocp           (phosphorus in particulate organic carbon in Redfield ratio)'
    write (stdout(),'((a), e13.6)')'        vertical speed [m /day]: '//'w_pocp=',-0.1
    write (stdout(),'((a), e13.6)')'        opacity        [m2/mol]: ',0.0
    write (stdout(),'(a)')         '    t_pocn           (nitrogen in particulate organic carbon in Redfield ratio)'
    write (stdout(),'((a), e13.6)')'        vertical speed [m /day]: '//'w_pocn=',-0.1
    write (stdout(),'((a), e13.6)')'        opacity        [m2/mol]: ',0.0
    write (stdout(),'(a)')         '    t_pocn_with_atmos_ship_N  (nitrogen in particulate organic carbon in Redfield ratio; containing nitrogen from atmospheric deposition, which has been previously emitted by ships)'
    write (stdout(),'((a), e13.6)')'        vertical speed [m /day]: '//'w_pocn=',-0.1
    write (stdout(),'((a), e13.6)')'        opacity        [m2/mol]: ',0.0
    write (stdout(),'(a)')         '    t_lpp_with_atmos_ship_N  (large-cell phytoplankton; containing nitrogen from atmospheric deposition, which has been previously emitted by ships)'
    write (stdout(),'((a), e13.6)')'        vertical speed [m /day]: '//'w_lpp=',-0.5
    write (stdout(),'((a), e13.6)')'        opacity        [m2/mol]: ',0.0
    write (stdout(),'(a)')         '    t_don_with_atmos_ship_N  (nitrogen in dissolved organic carbon in Redfield ratio; containing nitrogen from atmospheric deposition, which has been previously emitted by ships)'
    write (stdout(),'((a), e13.6)')'        vertical speed [m /day]: '//'w_pocn=',-0.1
    write (stdout(),'((a), e13.6)')'        opacity        [m2/mol]: ',0.0
    write (stdout(),'(a)')         '    t_cya_with_atmos_ship_N  (diazotroph cyanobacteria; containing nitrogen from atmospheric deposition, which has been previously emitted by ships)'
    write (stdout(),'((a), e13.6)')'        vertical speed [m /day]: '//'w_cya=',1.0
    write (stdout(),'((a), e13.6)')'        opacity        [m2/mol]: ',0.0
    write (stdout(),'(a)')         '    t_det_with_atmos_ship_N  (detritus; containing nitrogen from atmospheric deposition, which has been previously emitted by ships)'
    write (stdout(),'((a), e13.6)')'        vertical speed [m /day]: '//'w_det=',-4.5
    write (stdout(),'((a), e13.6)')'        opacity        [m2/mol]: ',0.0
    write (stdout(),'(/)')
    write (stdout(),*) 'TRACERS (2d, at the surface):'
    write (stdout(),'(/)')
    write (stdout(),*) 'TRACERS (2d, at the bottom):'
    write (stdout(),'(a)')         '    t_sed            (sediment detritus)'
    write (stdout(),'(a)')         '    t_ips            (iron phosphate in sediment)'
    write (stdout(),'(a)')         '    t_sed_poc        (sediment particular carbon)'
    write (stdout(),'(a)')         '    t_sed_pocn       (sediment particular organic N+C)'
    write (stdout(),'(a)')         '    t_sed_pocp       (sediment particular organic P+C)'
    write (stdout(),'(a)')         '    total_atmos_tot_N_at_bottom  (total_atmos_tot_N_at_bottom)'
    write (stdout(),'(a)')         '    total_atmos_ship_N_at_bottom  (total_atmos_ship_N_at_bottom)'
    write (stdout(),'(a)')         '    t_sed_with_atmos_tot_N  (sediment detritus; containing nitrogen from (total) atmospheric deposition)'
    write (stdout(),'(a)')         '    t_sed_pocn_with_atmos_tot_N  (sediment particular organic N+C; containing nitrogen from (total) atmospheric deposition)'
    write (stdout(),'(a)')         '    t_sed_with_atmos_ship_N  (sediment detritus; containing nitrogen from atmospheric deposition, which has been previously emitted by ships)'
    write (stdout(),'(a)')         '    t_sed_pocn_with_atmos_ship_N  (sediment particular organic N+C; containing nitrogen from atmospheric deposition, which has been previously emitted by ships)'
    write (stdout(),'(/)')
write (stdout(),*) 'TRACERS (pseudo-3d (fish)):'
    write (stdout(),'(/)')
    write (stdout(),*) 'PROCESSES in the surface layer:'
    write (stdout(),'(/)')
    write (stdout(),*) 'PROCESSES in the water column:'
    write (stdout(),'(a)')         '    p_no3_assim_lpp  (assimilation of nitrate by large-cell phytoplankton)'
    write (stdout(),'(a)')         '    p_nh4_assim_lpp  (assimilation of ammonium by large-cell phytoplankton)'
    write (stdout(),'(a)')         '    p_no3_assim_spp  (assimilation of nitrate by small-cell phytoplankton)'
    write (stdout(),'(a)')         '    p_nh4_assim_spp  (assimilation of ammonium by small-cell phytoplankton)'
    write (stdout(),'(a)')         '    p_n2_assim_cya   (fixation of dinitrogen by diazotroph cyanobacteria)'
    write (stdout(),'(a)')         '    p_assim_lpp_doc  (Production of DOC by LPP)'
    write (stdout(),'(a)')         '    p_assim_spp_doc  (Production of DOC by SPP)'
    write (stdout(),'(a)')         '    p_assim_cya_doc  (Production of POC by CYA)'
    write (stdout(),'(a)')         '    p_assim_lpp_dop  (Production of DOP by LPP)'
    write (stdout(),'(a)')         '    p_assim_spp_dop  (Production of DOP by SPP)'
    write (stdout(),'(a)')         '    p_nh4_assim_lpp_don  (Production of DON by LPP)'
    write (stdout(),'(a)')         '    p_no3_assim_lpp_don  (Production of DON by LPP)'
    write (stdout(),'(a)')         '    p_nh4_assim_spp_don  (Production of DON by SPP)'
    write (stdout(),'(a)')         '    p_no3_assim_spp_don  (Production of DON by SPP)'
    write (stdout(),'(a)')         '    p_poc_resp       (respiration of POC)'
    write (stdout(),'(a)')         '    p_poc_denit      (recycling of POC using nitrate (denitrification))'
    write (stdout(),'(a)')         '    p_poc_sulf       (Mineralization of POC, e-acceptor sulfate (sulfate reduction))'
    write (stdout(),'(a)')         '    p_pocp_resp      (respiration of POCP)'
    write (stdout(),'(a)')         '    p_pocp_denit     (recycling of POC using nitrate (denitrification))'
    write (stdout(),'(a)')         '    p_pocp_sulf      (Mineralization of POC, e-acceptor sulfate (sulfate reduction))'
    write (stdout(),'(a)')         '    p_pocn_resp      (respiration of POCN)'
    write (stdout(),'(a)')         '    p_pocn_denit_noN2  (recycling of POCN using nitrate (denitrification))'
    write (stdout(),'(a)')         '    p_pocn_denit_wiN2  (recycling of POCN using nitrate (denitrification))'
    write (stdout(),'(a)')         '    p_pocn_sulf      (Mineralization of POCN, e-acceptor sulfate (sulfate reduction))'
    write (stdout(),'(a)')         '    p_lpp_graz_zoo   (grazing of zooplankton eating large-cell phytoplankton)'
    write (stdout(),'(a)')         '    p_spp_graz_zoo   (grazing of zooplankton eating small-cell phytoplankton)'
    write (stdout(),'(a)')         '    p_cya_graz_zoo   (grazing of zooplankton eating diazotroph cyanobacteria)'
    write (stdout(),'(a)')         '    p_lpp_resp_nh4   (respiration of large-cell phytoplankton)'
    write (stdout(),'(a)')         '    p_spp_resp_nh4   (respiration of small-cell phytoplankton)'
    write (stdout(),'(a)')         '    p_cya_resp_nh4   (respiration of diazotroph cyanobacteria)'
    write (stdout(),'(a)')         '    p_zoo_resp_nh4   (respiration of zooplankton)'
    write (stdout(),'(a)')         '    p_lpp_mort_det   (mortality of large-cell phytoplankton)'
    write (stdout(),'(a)')         '    p_spp_mort_det   (mortality of small-scale phytoplankton)'
    write (stdout(),'(a)')         '    p_cya_mort_det   (mortality of diazotroph cyanobacteria)'
    write (stdout(),'(a)')         '    p_cya_mort_det_diff  (mortality of diazotroph cyanobacteria due to strong turbulence)'
    write (stdout(),'(a)')         '    p_zoo_mort_det   (mortality of zooplankton)'
    write (stdout(),'(a)')         '    p_nh4_nit_no3    (nitrification)'
    write (stdout(),'(a)')         '    p_det_resp_nh4   (recycling of detritus using oxygen (respiration))'
    write (stdout(),'(a)')         '    p_det_denit_nh4  (recycling of detritus using nitrate (denitrification))'
    write (stdout(),'(a)')         '    p_det_sulf_nh4   (recycling of detritus using sulfate (sulfate reduction))'
    write (stdout(),'(a)')         '    p_h2s_oxo2_sul   (oxidation of hydrogen sulfide with oxygen)'
    write (stdout(),'(a)')         '    p_h2s_oxno3_sul  (oxidation of hydrogen sulfide with nitrate)'
    write (stdout(),'(a)')         '    p_sul_oxo2_so4   (oxidation of elemental sulfur with oxygen)'
    write (stdout(),'(a)')         '    p_sul_oxno3_so4  (oxidation of elemental sulfur with nitrate)'
    write (stdout(),'(a)')         '    p_doc2pco        (particle formation from DOC)'
    write (stdout(),'(a)')         '    p_dop2pocp       (particle formation from DOP)'
    write (stdout(),'(a)')         '    p_don2pocn       (particle formation from DON)'
    write (stdout(),'(a)')         '    p_doc_resp       (respiration of DOC)'
    write (stdout(),'(a)')         '    p_doc_denit      (recycling of DOC using nitrate (denitrification))'
    write (stdout(),'(a)')         '    p_doc_sulf       (Mineralization of DOC, e-acceptor sulfate (sulfate reduction))'
    write (stdout(),'(a)')         '    p_dop_resp       (respiration of DOP)'
    write (stdout(),'(a)')         '    p_dop_denit      (recycling of DOP using nitrate (denitrification))'
    write (stdout(),'(a)')         '    p_dop_sulf       (Mineralization of DOP, e-acceptor sulfate (sulfate reduction))'
    write (stdout(),'(a)')         '    p_don_resp       (respiration of DON)'
    write (stdout(),'(a)')         '    p_don_denit_noN2  (recycling of DON using nitrate (denitrification))'
    write (stdout(),'(a)')         '    p_don_denit_wiN2  (recycling of DON using nitrate (denitrification))'
    write (stdout(),'(a)')         '    p_don_sulf       (Mineralization of DON, e-acceptor sulfate (sulfate reduction))'
    write (stdout(),'(a)')         '    p_no3_assim_lpp_atmos_tot_N  (assimilation of nitrate by large-cell phytoplankton; sub-process for atmos_tot nitrogen)'
    write (stdout(),'(a)')         '    p_nh4_assim_lpp_atmos_tot_N  (assimilation of ammonium by large-cell phytoplankton; sub-process for atmos_tot nitrogen)'
    write (stdout(),'(a)')         '    p_no3_assim_spp_atmos_tot_N  (assimilation of nitrate by small-cell phytoplankton; sub-process for atmos_tot nitrogen)'
    write (stdout(),'(a)')         '    p_nh4_assim_spp_atmos_tot_N  (assimilation of ammonium by small-cell phytoplankton; sub-process for atmos_tot nitrogen)'
    write (stdout(),'(a)')         '    p_nh4_assim_lpp_don_atmos_tot_N  (Production of DON by LPP; sub-process for atmos_tot nitrogen)'
    write (stdout(),'(a)')         '    p_no3_assim_lpp_don_atmos_tot_N  (Production of DON by LPP; sub-process for atmos_tot nitrogen)'
    write (stdout(),'(a)')         '    p_nh4_assim_spp_don_atmos_tot_N  (Production of DON by SPP; sub-process for atmos_tot nitrogen)'
    write (stdout(),'(a)')         '    p_no3_assim_spp_don_atmos_tot_N  (Production of DON by SPP; sub-process for atmos_tot nitrogen)'
    write (stdout(),'(a)')         '    p_pocn_resp_atmos_tot_N  (respiration of POCN; sub-process for atmos_tot nitrogen)'
    write (stdout(),'(a)')         '    p_pocn_denit_noN2_atmos_tot_N  (recycling of POCN using nitrate (denitrification); sub-process for atmos_tot nitrogen)'
    write (stdout(),'(a)')         '    p_pocn_sulf_atmos_tot_N  (Mineralization of POCN, e-acceptor sulfate (sulfate reduction); sub-process for atmos_tot nitrogen)'
    write (stdout(),'(a)')         '    p_lpp_graz_zoo_atmos_tot_N  (grazing of zooplankton eating large-cell phytoplankton; sub-process for atmos_tot nitrogen)'
    write (stdout(),'(a)')         '    p_spp_graz_zoo_atmos_tot_N  (grazing of zooplankton eating small-cell phytoplankton; sub-process for atmos_tot nitrogen)'
    write (stdout(),'(a)')         '    p_cya_graz_zoo_atmos_tot_N  (grazing of zooplankton eating diazotroph cyanobacteria; sub-process for atmos_tot nitrogen)'
    write (stdout(),'(a)')         '    p_lpp_resp_nh4_atmos_tot_N  (respiration of large-cell phytoplankton; sub-process for atmos_tot nitrogen)'
    write (stdout(),'(a)')         '    p_spp_resp_nh4_atmos_tot_N  (respiration of small-cell phytoplankton; sub-process for atmos_tot nitrogen)'
    write (stdout(),'(a)')         '    p_cya_resp_nh4_atmos_tot_N  (respiration of diazotroph cyanobacteria; sub-process for atmos_tot nitrogen)'
    write (stdout(),'(a)')         '    p_zoo_resp_nh4_atmos_tot_N  (respiration of zooplankton; sub-process for atmos_tot nitrogen)'
    write (stdout(),'(a)')         '    p_lpp_mort_det_atmos_tot_N  (mortality of large-cell phytoplankton; sub-process for atmos_tot nitrogen)'
    write (stdout(),'(a)')         '    p_spp_mort_det_atmos_tot_N  (mortality of small-scale phytoplankton; sub-process for atmos_tot nitrogen)'
    write (stdout(),'(a)')         '    p_cya_mort_det_atmos_tot_N  (mortality of diazotroph cyanobacteria; sub-process for atmos_tot nitrogen)'
    write (stdout(),'(a)')         '    p_cya_mort_det_diff_atmos_tot_N  (mortality of diazotroph cyanobacteria due to strong turbulence; sub-process for atmos_tot nitrogen)'
    write (stdout(),'(a)')         '    p_zoo_mort_det_atmos_tot_N  (mortality of zooplankton; sub-process for atmos_tot nitrogen)'
    write (stdout(),'(a)')         '    p_nh4_nit_no3_atmos_tot_N  (nitrification; sub-process for atmos_tot nitrogen)'
    write (stdout(),'(a)')         '    p_det_resp_nh4_atmos_tot_N  (recycling of detritus using oxygen (respiration); sub-process for atmos_tot nitrogen)'
    write (stdout(),'(a)')         '    p_det_sulf_nh4_atmos_tot_N  (recycling of detritus using sulfate (sulfate reduction); sub-process for atmos_tot nitrogen)'
    write (stdout(),'(a)')         '    p_don2pocn_atmos_tot_N  (particle formation from DON; sub-process for atmos_tot nitrogen)'
    write (stdout(),'(a)')         '    p_don_resp_atmos_tot_N  (respiration of DON; sub-process for atmos_tot nitrogen)'
    write (stdout(),'(a)')         '    p_don_denit_noN2_atmos_tot_N  (recycling of DON using nitrate (denitrification); sub-process for atmos_tot nitrogen)'
    write (stdout(),'(a)')         '    p_don_sulf_atmos_tot_N  (Mineralization of DON, e-acceptor sulfate (sulfate reduction); sub-process for atmos_tot nitrogen)'
    write (stdout(),'(a)')         '    p_no3_assim_lpp_atmos_ship_N  (assimilation of nitrate by large-cell phytoplankton; sub-process for atmos_ship nitrogen)'
    write (stdout(),'(a)')         '    p_nh4_assim_lpp_atmos_ship_N  (assimilation of ammonium by large-cell phytoplankton; sub-process for atmos_ship nitrogen)'
    write (stdout(),'(a)')         '    p_no3_assim_spp_atmos_ship_N  (assimilation of nitrate by small-cell phytoplankton; sub-process for atmos_ship nitrogen)'
    write (stdout(),'(a)')         '    p_nh4_assim_spp_atmos_ship_N  (assimilation of ammonium by small-cell phytoplankton; sub-process for atmos_ship nitrogen)'
    write (stdout(),'(a)')         '    p_nh4_assim_lpp_don_atmos_ship_N  (Production of DON by LPP; sub-process for atmos_ship nitrogen)'
    write (stdout(),'(a)')         '    p_no3_assim_lpp_don_atmos_ship_N  (Production of DON by LPP; sub-process for atmos_ship nitrogen)'
    write (stdout(),'(a)')         '    p_nh4_assim_spp_don_atmos_ship_N  (Production of DON by SPP; sub-process for atmos_ship nitrogen)'
    write (stdout(),'(a)')         '    p_no3_assim_spp_don_atmos_ship_N  (Production of DON by SPP; sub-process for atmos_ship nitrogen)'
    write (stdout(),'(a)')         '    p_pocn_resp_atmos_ship_N  (respiration of POCN; sub-process for atmos_ship nitrogen)'
    write (stdout(),'(a)')         '    p_pocn_denit_noN2_atmos_ship_N  (recycling of POCN using nitrate (denitrification); sub-process for atmos_ship nitrogen)'
    write (stdout(),'(a)')         '    p_pocn_sulf_atmos_ship_N  (Mineralization of POCN, e-acceptor sulfate (sulfate reduction); sub-process for atmos_ship nitrogen)'
    write (stdout(),'(a)')         '    p_lpp_graz_zoo_atmos_ship_N  (grazing of zooplankton eating large-cell phytoplankton; sub-process for atmos_ship nitrogen)'
    write (stdout(),'(a)')         '    p_spp_graz_zoo_atmos_ship_N  (grazing of zooplankton eating small-cell phytoplankton; sub-process for atmos_ship nitrogen)'
    write (stdout(),'(a)')         '    p_cya_graz_zoo_atmos_ship_N  (grazing of zooplankton eating diazotroph cyanobacteria; sub-process for atmos_ship nitrogen)'
    write (stdout(),'(a)')         '    p_lpp_resp_nh4_atmos_ship_N  (respiration of large-cell phytoplankton; sub-process for atmos_ship nitrogen)'
    write (stdout(),'(a)')         '    p_spp_resp_nh4_atmos_ship_N  (respiration of small-cell phytoplankton; sub-process for atmos_ship nitrogen)'
    write (stdout(),'(a)')         '    p_cya_resp_nh4_atmos_ship_N  (respiration of diazotroph cyanobacteria; sub-process for atmos_ship nitrogen)'
    write (stdout(),'(a)')         '    p_zoo_resp_nh4_atmos_ship_N  (respiration of zooplankton; sub-process for atmos_ship nitrogen)'
    write (stdout(),'(a)')         '    p_lpp_mort_det_atmos_ship_N  (mortality of large-cell phytoplankton; sub-process for atmos_ship nitrogen)'
    write (stdout(),'(a)')         '    p_spp_mort_det_atmos_ship_N  (mortality of small-scale phytoplankton; sub-process for atmos_ship nitrogen)'
    write (stdout(),'(a)')         '    p_cya_mort_det_atmos_ship_N  (mortality of diazotroph cyanobacteria; sub-process for atmos_ship nitrogen)'
    write (stdout(),'(a)')         '    p_cya_mort_det_diff_atmos_ship_N  (mortality of diazotroph cyanobacteria due to strong turbulence; sub-process for atmos_ship nitrogen)'
    write (stdout(),'(a)')         '    p_zoo_mort_det_atmos_ship_N  (mortality of zooplankton; sub-process for atmos_ship nitrogen)'
    write (stdout(),'(a)')         '    p_nh4_nit_no3_atmos_ship_N  (nitrification; sub-process for atmos_ship nitrogen)'
    write (stdout(),'(a)')         '    p_det_resp_nh4_atmos_ship_N  (recycling of detritus using oxygen (respiration); sub-process for atmos_ship nitrogen)'
    write (stdout(),'(a)')         '    p_det_sulf_nh4_atmos_ship_N  (recycling of detritus using sulfate (sulfate reduction); sub-process for atmos_ship nitrogen)'
    write (stdout(),'(a)')         '    p_don2pocn_atmos_ship_N  (particle formation from DON; sub-process for atmos_ship nitrogen)'
    write (stdout(),'(a)')         '    p_don_resp_atmos_ship_N  (respiration of DON; sub-process for atmos_ship nitrogen)'
    write (stdout(),'(a)')         '    p_don_denit_noN2_atmos_ship_N  (recycling of DON using nitrate (denitrification); sub-process for atmos_ship nitrogen)'
    write (stdout(),'(a)')         '    p_don_sulf_atmos_ship_N  (Mineralization of DON, e-acceptor sulfate (sulfate reduction); sub-process for atmos_ship nitrogen)'
    write (stdout(),'(/)')
    write (stdout(),*) 'PROCESSES in the bottom layer:'
    write (stdout(),'(a)')         '    p_sed_resp_nh4   (recycling of sedimentary detritus to ammonium using oxygen (respiration))'
    write (stdout(),'(a)')         '    p_nh4_nitdenit_n2  (coupled nitrification and denitrification after mineralization of detritus in oxic sediments)'
    write (stdout(),'(a)')         '    p_sed_denit_nh4_noN2  (recycling of sedimentary detritus to ammonium using nitrate (denitrification))'
    write (stdout(),'(a)')         '    p_sed_denit_nh4_wiN2  (recycling of sedimentary detritus to ammonium using nitrate (denitrification))'
    write (stdout(),'(a)')         '    p_sed_sulf_nh4   (recycling of sedimentary detritus to ammonium using sulfate (sulfate reduction))'
    write (stdout(),'(a)')         '    p_sed_poc_resp   (recycling of sedimentary poc to dic using oxygen (respiration))'
    write (stdout(),'(a)')         '    p_sed_poc_denit  (recycling of sedimentary poc to dic using nitrate (denitrification))'
    write (stdout(),'(a)')         '    p_sed_poc_sulf   (recycling of sedimentary poc to dic using sulfate (sulfate reduction))'
    write (stdout(),'(a)')         '    p_po4_retent_ips  (retention of phosphate in the sediment under oxic conditions)'
    write (stdout(),'(a)')         '    p_ips_liber_po4  (liberation of phosphate from the sediment under anoxic conditions)'
    write (stdout(),'(a)')         '    p_det_sedi_sed   (detritus sedimentation)'
    write (stdout(),'(a)')         '    p_ipw_sedi_ips   (sedimentation of iron PO4)'
    write (stdout(),'(a)')         '    p_poc_sedi_sed   (poc sedimentation)'
    write (stdout(),'(a)')         '    p_pocn_sedi_sed  (pocn sedimentation)'
    write (stdout(),'(a)')         '    p_pocp_sedi_sed  (pocp sedimentation)'
    write (stdout(),'(a)')         '    p_sed_ero_det    (sedimentary detritus erosion)'
    write (stdout(),'(a)')         '    p_ips_ero_ipw    (erosion of iron PO4)'
    write (stdout(),'(a)')         '    p_sed_ero_poc    (sedimentary poc erosion)'
    write (stdout(),'(a)')         '    p_sed_ero_pocn   (sedimentary pocn erosion)'
    write (stdout(),'(a)')         '    p_sed_ero_pocp   (sedimentary pocp erosion)'
    write (stdout(),'(a)')         '    p_sed_biores_det  (bio resuspension of sedimentary detritus)'
    write (stdout(),'(a)')         '    p_ips_biores_ipw  (bio resuspension of iron PO4)'
    write (stdout(),'(a)')         '    p_sed_biores_poc  (bio resuspension of sedimentary poc)'
    write (stdout(),'(a)')         '    p_sed_biores_pocn  (bio resuspension of sedimentary pocn)'
    write (stdout(),'(a)')         '    p_sed_biores_pocp  (bio resuspension of sedimentary pocp)'
    write (stdout(),'(a)')         '    p_sed_burial     (burial of detritus deeper than max_sed)'
    write (stdout(),'(a)')         '    p_ips_burial     (burial of iron PO4)'
    write (stdout(),'(a)')         '    p_poc_burial     (burial of poc deeper than max_sed)'
    write (stdout(),'(a)')         '    p_pocn_burial    (burial of pocn deeper than max_sed)'
    write (stdout(),'(a)')         '    p_pocp_burial    (burial of pocp deeper than max_sed)'
    write (stdout(),'(a)')         '    p_sed_pocn_resp  (recycling of sedimentary pocn to dic and NH4 using oxygen (respiration))'
    write (stdout(),'(a)')         '    p_sed_pocp_resp  (recycling of sedimentary pocp to dic and PO4 using oxygen (respiration))'
    write (stdout(),'(a)')         '    p_sed_pocn_denit_noN2  (recycling of sedimentary pocn to dic and NH4 using nitrate (denitrification))'
    write (stdout(),'(a)')         '    p_sed_pocn_denit_wiN2  (recycling of sedimentary pocn to dic and NH4 using nitrate (denitrification))'
    write (stdout(),'(a)')         '    p_sed_pocp_denit  (recycling of sedimentary pocp to dic and PO4 using nitrate (denitrification))'
    write (stdout(),'(a)')         '    p_sed_pocn_sulf  (recycling of sedimentary pocn to dic and NH4 using sulfate (sulfate reduction))'
    write (stdout(),'(a)')         '    p_sed_pocp_sulf  (recycling of sedimentary pocp to dic and PO4 using sulfate (sulfate reduction))'
    write (stdout(),'(a)')         '    p_nh4_nitdenit_pocn_n2  (coupled nitrification and denitrification after mineralization of pocn-detritus in oxic sediments)'
    write (stdout(),'(a)')         '    p_sed_resp_nh4_atmos_tot_N  (recycling of sedimentary detritus to ammonium using oxygen (respiration); sub-process for atmos_tot nitrogen)'
    write (stdout(),'(a)')         '    p_sed_denit_nh4_noN2_atmos_tot_N  (recycling of sedimentary detritus to ammonium using nitrate (denitrification); sub-process for atmos_tot nitrogen)'
    write (stdout(),'(a)')         '    p_sed_sulf_nh4_atmos_tot_N  (recycling of sedimentary detritus to ammonium using sulfate (sulfate reduction); sub-process for atmos_tot nitrogen)'
    write (stdout(),'(a)')         '    p_det_sedi_sed_atmos_tot_N  (detritus sedimentation; sub-process for atmos_tot nitrogen)'
    write (stdout(),'(a)')         '    p_pocn_sedi_sed_atmos_tot_N  (pocn sedimentation; sub-process for atmos_tot nitrogen)'
    write (stdout(),'(a)')         '    p_sed_ero_det_atmos_tot_N  (sedimentary detritus erosion; sub-process for atmos_tot nitrogen)'
    write (stdout(),'(a)')         '    p_sed_ero_pocn_atmos_tot_N  (sedimentary pocn erosion; sub-process for atmos_tot nitrogen)'
    write (stdout(),'(a)')         '    p_sed_biores_det_atmos_tot_N  (bio resuspension of sedimentary detritus; sub-process for atmos_tot nitrogen)'
    write (stdout(),'(a)')         '    p_sed_biores_pocn_atmos_tot_N  (bio resuspension of sedimentary pocn; sub-process for atmos_tot nitrogen)'
    write (stdout(),'(a)')         '    p_sed_burial_atmos_tot_N  (burial of detritus deeper than max_sed; sub-process for atmos_tot nitrogen)'
    write (stdout(),'(a)')         '    p_pocn_burial_atmos_tot_N  (burial of pocn deeper than max_sed; sub-process for atmos_tot nitrogen)'
    write (stdout(),'(a)')         '    p_sed_pocn_resp_atmos_tot_N  (recycling of sedimentary pocn to dic and NH4 using oxygen (respiration); sub-process for atmos_tot nitrogen)'
    write (stdout(),'(a)')         '    p_sed_pocn_denit_noN2_atmos_tot_N  (recycling of sedimentary pocn to dic and NH4 using nitrate (denitrification); sub-process for atmos_tot nitrogen)'
    write (stdout(),'(a)')         '    p_sed_pocn_sulf_atmos_tot_N  (recycling of sedimentary pocn to dic and NH4 using sulfate (sulfate reduction); sub-process for atmos_tot nitrogen)'
    write (stdout(),'(a)')         '    p_sed_resp_nh4_atmos_ship_N  (recycling of sedimentary detritus to ammonium using oxygen (respiration); sub-process for atmos_ship nitrogen)'
    write (stdout(),'(a)')         '    p_sed_denit_nh4_noN2_atmos_ship_N  (recycling of sedimentary detritus to ammonium using nitrate (denitrification); sub-process for atmos_ship nitrogen)'
    write (stdout(),'(a)')         '    p_sed_sulf_nh4_atmos_ship_N  (recycling of sedimentary detritus to ammonium using sulfate (sulfate reduction); sub-process for atmos_ship nitrogen)'
    write (stdout(),'(a)')         '    p_det_sedi_sed_atmos_ship_N  (detritus sedimentation; sub-process for atmos_ship nitrogen)'
    write (stdout(),'(a)')         '    p_pocn_sedi_sed_atmos_ship_N  (pocn sedimentation; sub-process for atmos_ship nitrogen)'
    write (stdout(),'(a)')         '    p_sed_ero_det_atmos_ship_N  (sedimentary detritus erosion; sub-process for atmos_ship nitrogen)'
    write (stdout(),'(a)')         '    p_sed_ero_pocn_atmos_ship_N  (sedimentary pocn erosion; sub-process for atmos_ship nitrogen)'
    write (stdout(),'(a)')         '    p_sed_biores_det_atmos_ship_N  (bio resuspension of sedimentary detritus; sub-process for atmos_ship nitrogen)'
    write (stdout(),'(a)')         '    p_sed_biores_pocn_atmos_ship_N  (bio resuspension of sedimentary pocn; sub-process for atmos_ship nitrogen)'
    write (stdout(),'(a)')         '    p_sed_burial_atmos_ship_N  (burial of detritus deeper than max_sed; sub-process for atmos_ship nitrogen)'
    write (stdout(),'(a)')         '    p_pocn_burial_atmos_ship_N  (burial of pocn deeper than max_sed; sub-process for atmos_ship nitrogen)'
    write (stdout(),'(a)')         '    p_sed_pocn_resp_atmos_ship_N  (recycling of sedimentary pocn to dic and NH4 using oxygen (respiration); sub-process for atmos_ship nitrogen)'
    write (stdout(),'(a)')         '    p_sed_pocn_denit_noN2_atmos_ship_N  (recycling of sedimentary pocn to dic and NH4 using nitrate (denitrification); sub-process for atmos_ship nitrogen)'
    write (stdout(),'(a)')         '    p_sed_pocn_sulf_atmos_ship_N  (recycling of sedimentary pocn to dic and NH4 using sulfate (sulfate reduction); sub-process for atmos_ship nitrogen)'
    write (stdout(),'(/)')
    if (implicit_surfacefluxes) then
       write (stdout(),'(a)') 'Using implicit surface fluxes for gas exchange'
       write (stdout(),'(a)') '   TRACERS with solubility and Schmidt number:'
       write (stdout(),'(a)')    '       t_n2           '
       write (stdout(),'(a)')    '       t_o2           '
       write (stdout(),'(a)')    '       t_dic          '
       write (stdout(),'(a)')    '       t_n2_with_atmos_tot_N'
       write (stdout(),'(a)')    '       t_n2_with_atmos_ship_N'
    else
       write (stdout(),'(a)') 'Using explicit surface fluxes for gas exchange'
       write (stdout(),'(a)') '   (see processes in the surface layer)'
    endif
    if (implicit_movement) then
       write (stdout(),'(a)') 'Using implicit scheme for vertical migration and additional diffusion'
    else
       write (stdout(),'(a)') 'Using explicit scheme for vertical migration and additional diffusion'
       write (stdout(),'(a,I2)') '   Number of vertical movement steps per bio-timestep: ', NUM_VMOVE_STEPS
    endif
    if (implicit_bottomfluxes) then
       write (stdout(),'(a)') 'Using implicit bottom fluxes'
       write (stdout(),'(a)') '   (Update of bottom cell concentration is done via providing bottom fluxes) '
    else
       write (stdout(),'(a)') 'Using explicit bottom fluxes'
       write (stdout(),'(a)') '   (Update of bottom cell concentration is done in this module) '
    endif
    if (genus_style_par) then
       write (stdout(),'(a)') 'Using GENUS model style vertical light extinction'
    else
       write (stdout(),'(a)') 'Using classical ERGOM style vertical light extinction'
    endif
    write (stdout(),'(a,I2)') 'Depth of Runge-Kutta scheme (1=Euler-Forward) : ', RUNGE_KUTTA_DEPTH
    write (stdout(),'(a,I2)') 'split factor (ERGOM timestep/ocean timestep)  :' , SPLITTING_FACTOR_ERGOM
    write (stdout(),'(a,I2)') 'Number of vertical sediment layers            : ', NUM_SEDIMENT_LAYERS
    if (NUM_SEDIMENT_LAYERS .gt. 1) then
       write (stdout(),'(a)') '  => vertically resolved sediment model is used '
       write (stdout(),'(a)') '     TRACERS in pore water: '
    else
       write (stdout(),'(a)') '  => no vertically resolved sediment model is used '
    endif

    call mpp_clock_end(id_init)

  end subroutine generic_ERGOM_init

  subroutine user_allocate_arrays
    integer :: isc,iec,jsc,jec,isd,ied,jsd,jed,nk,ntau, n, i
    character(len=fm_string_len) :: mystring

    call mpp_clock_begin(id_alloc)

    call g_tracer_get_common(isc,iec,jsc,jec,isd,ied,jsd,jed,nk,ntau)
    !Allocate all the private arrays.

    if (implicit_surfacefluxes) then
       allocate(ergom%t_n2_t_n2_csurf(isd:ied,jsd:jed)); ergom%t_n2_t_n2_csurf=0.0
       allocate(ergom%t_o2_t_o2_csurf(isd:ied,jsd:jed)); ergom%t_o2_t_o2_csurf=0.0
       allocate(ergom%co2_t_dic_csurf(isd:ied,jsd:jed)); ergom%co2_t_dic_csurf=0.0
       allocate(ergom%t_n2_t_n2_with_atmos_tot_N_csurf(isd:ied,jsd:jed)); ergom%t_n2_t_n2_with_atmos_tot_N_csurf=0.0
       allocate(ergom%t_n2_t_n2_with_atmos_ship_N_csurf(isd:ied,jsd:jed)); ergom%t_n2_t_n2_with_atmos_ship_N_csurf=0.0
       allocate(ergom%t_n2_alpha(isd:ied,jsd:jed)); ergom%t_n2_alpha=0.0
       allocate(ergom%t_n2_sc_no(isd:ied,jsd:jed)); ergom%t_n2_sc_no=0.0
       allocate(ergom%t_o2_alpha(isd:ied,jsd:jed)); ergom%t_o2_alpha=0.0
       allocate(ergom%t_o2_sc_no(isd:ied,jsd:jed)); ergom%t_o2_sc_no=0.0
       allocate(ergom%co2_alpha(isd:ied,jsd:jed)); ergom%co2_alpha=0.0
       allocate(ergom%co2_sc_no(isd:ied,jsd:jed)); ergom%co2_sc_no=0.0
    endif

    allocate(ergom%t_sed          (isd:ied,jsd:jed)); ergom%t_sed          =0.0
    allocate(ergom%t_ips          (isd:ied,jsd:jed)); ergom%t_ips          =0.0
    allocate(ergom%t_sed_poc      (isd:ied,jsd:jed)); ergom%t_sed_poc      =0.0
    allocate(ergom%t_sed_pocn     (isd:ied,jsd:jed)); ergom%t_sed_pocn     =0.0
    allocate(ergom%t_sed_pocp     (isd:ied,jsd:jed)); ergom%t_sed_pocp     =0.0
    allocate(ergom%total_atmos_tot_N_at_bottom(isd:ied,jsd:jed)); ergom%total_atmos_tot_N_at_bottom=0.0
    allocate(ergom%total_atmos_ship_N_at_bottom(isd:ied,jsd:jed)); ergom%total_atmos_ship_N_at_bottom=0.0
    allocate(ergom%t_sed_with_atmos_tot_N(isd:ied,jsd:jed)); ergom%t_sed_with_atmos_tot_N=0.0
    allocate(ergom%t_sed_pocn_with_atmos_tot_N(isd:ied,jsd:jed)); ergom%t_sed_pocn_with_atmos_tot_N=0.0
    allocate(ergom%t_sed_with_atmos_ship_N(isd:ied,jsd:jed)); ergom%t_sed_with_atmos_ship_N=0.0
    allocate(ergom%t_sed_pocn_with_atmos_ship_N(isd:ied,jsd:jed)); ergom%t_sed_pocn_with_atmos_ship_N=0.0
    if (NUM_SEDIMENT_LAYERS .eq. 1) then
       call user_2d_tracer_assign_array('t_sed', ergom%t_sed          )
       call user_2d_tracer_assign_array('t_ips', ergom%t_ips          )
       call user_2d_tracer_assign_array('t_sed_poc', ergom%t_sed_poc      )
       call user_2d_tracer_assign_array('t_sed_pocn', ergom%t_sed_pocn     )
       call user_2d_tracer_assign_array('t_sed_pocp', ergom%t_sed_pocp     )
       call user_2d_tracer_assign_array('total_atmos_tot_N_at_bottom', ergom%total_atmos_tot_N_at_bottom)
       call user_2d_tracer_assign_array('total_atmos_ship_N_at_bottom', ergom%total_atmos_ship_N_at_bottom)
       call user_2d_tracer_assign_array('t_sed_with_atmos_tot_N', ergom%t_sed_with_atmos_tot_N)
       call user_2d_tracer_assign_array('t_sed_pocn_with_atmos_tot_N', ergom%t_sed_pocn_with_atmos_tot_N)
       call user_2d_tracer_assign_array('t_sed_with_atmos_ship_N', ergom%t_sed_with_atmos_ship_N)
       call user_2d_tracer_assign_array('t_sed_pocn_with_atmos_ship_N', ergom%t_sed_pocn_with_atmos_ship_N)
    else
       allocate(ergom%temp3darray(isd:ied,jsd:jed,nk)); ergom%temp3darray=0.0
       allocate(ergom%vertspeedarray(isd:ied,jsd:jed,nk)); ergom%vertspeedarray=0.0
       allocate(ergom%moldiff_t_sed          (isd:ied,jsd:jed,nk)); ergom%moldiff_t_sed          =0.0
       allocate(ergom%moldiff_t_ips          (isd:ied,jsd:jed,nk)); ergom%moldiff_t_ips          =0.0
       allocate(ergom%moldiff_t_sed_poc      (isd:ied,jsd:jed,nk)); ergom%moldiff_t_sed_poc      =0.0
       allocate(ergom%moldiff_t_sed_pocn     (isd:ied,jsd:jed,nk)); ergom%moldiff_t_sed_pocn     =0.0
       allocate(ergom%moldiff_t_sed_pocp     (isd:ied,jsd:jed,nk)); ergom%moldiff_t_sed_pocp     =0.0
       allocate(ergom%moldiff_total_atmos_tot_N_at_bottom(isd:ied,jsd:jed,nk)); ergom%moldiff_total_atmos_tot_N_at_bottom=0.0
       allocate(ergom%moldiff_total_atmos_ship_N_at_bottom(isd:ied,jsd:jed,nk)); ergom%moldiff_total_atmos_ship_N_at_bottom=0.0
       allocate(ergom%moldiff_t_sed_with_atmos_tot_N(isd:ied,jsd:jed,nk)); ergom%moldiff_t_sed_with_atmos_tot_N=0.0
       allocate(ergom%moldiff_t_sed_pocn_with_atmos_tot_N(isd:ied,jsd:jed,nk)); ergom%moldiff_t_sed_pocn_with_atmos_tot_N=0.0
       allocate(ergom%moldiff_t_sed_with_atmos_ship_N(isd:ied,jsd:jed,nk)); ergom%moldiff_t_sed_with_atmos_ship_N=0.0
       allocate(ergom%moldiff_t_sed_pocn_with_atmos_ship_N(isd:ied,jsd:jed,nk)); ergom%moldiff_t_sed_pocn_with_atmos_ship_N=0.0
       allocate(ergom%sed_t_sed          (isd:ied,jsd:jed,nk)); ergom%sed_t_sed          =0.0
       allocate(ergom%sed_t_ips          (isd:ied,jsd:jed,nk)); ergom%sed_t_ips          =0.0
       allocate(ergom%sed_t_sed_poc      (isd:ied,jsd:jed,nk)); ergom%sed_t_sed_poc      =0.0
       allocate(ergom%sed_t_sed_pocn     (isd:ied,jsd:jed,nk)); ergom%sed_t_sed_pocn     =0.0
       allocate(ergom%sed_t_sed_pocp     (isd:ied,jsd:jed,nk)); ergom%sed_t_sed_pocp     =0.0
       allocate(ergom%sed_total_atmos_tot_N_at_bottom(isd:ied,jsd:jed,nk)); ergom%sed_total_atmos_tot_N_at_bottom=0.0
       allocate(ergom%sed_total_atmos_ship_N_at_bottom(isd:ied,jsd:jed,nk)); ergom%sed_total_atmos_ship_N_at_bottom=0.0
       allocate(ergom%sed_t_sed_with_atmos_tot_N(isd:ied,jsd:jed,nk)); ergom%sed_t_sed_with_atmos_tot_N=0.0
       allocate(ergom%sed_t_sed_pocn_with_atmos_tot_N(isd:ied,jsd:jed,nk)); ergom%sed_t_sed_pocn_with_atmos_tot_N=0.0
       allocate(ergom%sed_t_sed_with_atmos_ship_N(isd:ied,jsd:jed,nk)); ergom%sed_t_sed_with_atmos_ship_N=0.0
       allocate(ergom%sed_t_sed_pocn_with_atmos_ship_N(isd:ied,jsd:jed,nk)); ergom%sed_t_sed_pocn_with_atmos_ship_N=0.0
!! TODO: workaround; these tracers are not automatically allocated
       allocate(ergom%sed_total_atmos_tot_N(isd:ied,jsd:jed,nk)); ergom%sed_total_atmos_tot_N=0.0
       allocate(ergom%sed_total_atmos_ship_N(isd:ied,jsd:jed,nk)); ergom%sed_total_atmos_ship_N=0.0
       allocate(ergom%sed_cellheights          (isd:ied,jsd:jed,nk)); ergom%sed_cellheights=0.0
       allocate(ergom%sed_diffusivity_porewater(isd:ied,jsd:jed,nk)); ergom%sed_diffusivity_porewater=0.0
       allocate(ergom%sed_diffusivity_solids   (isd:ied,jsd:jed,nk)); ergom%sed_diffusivity_solids=0.0
       allocate(ergom%sed_2d_params            (isd:ied,jsd:jed,nk)); ergom%sed_2d_params=0.0
       allocate(ergom%sed_inert_ratio          (isd:ied,jsd:jed,nk)); ergom%sed_inert_ratio=0.0
    endif

    if (implicit_bottomfluxes) then
      allocate(ergom%btf_t_n2           (isd:ied,jsd:jed)); ergom%btf_t_n2           =0.0
      allocate(ergom%btf_t_o2           (isd:ied,jsd:jed)); ergom%btf_t_o2           =0.0
      allocate(ergom%btf_t_dic          (isd:ied,jsd:jed)); ergom%btf_t_dic          =0.0
      allocate(ergom%btf_t_nh4          (isd:ied,jsd:jed)); ergom%btf_t_nh4          =0.0
      allocate(ergom%btf_t_no3          (isd:ied,jsd:jed)); ergom%btf_t_no3          =0.0
      allocate(ergom%btf_t_po4          (isd:ied,jsd:jed)); ergom%btf_t_po4          =0.0
      allocate(ergom%btf_t_spp          (isd:ied,jsd:jed)); ergom%btf_t_spp          =0.0
      allocate(ergom%btf_t_zoo          (isd:ied,jsd:jed)); ergom%btf_t_zoo          =0.0
      allocate(ergom%btf_t_h2s          (isd:ied,jsd:jed)); ergom%btf_t_h2s          =0.0
      allocate(ergom%btf_t_sul          (isd:ied,jsd:jed)); ergom%btf_t_sul          =0.0
      allocate(ergom%btf_t_alk          (isd:ied,jsd:jed)); ergom%btf_t_alk          =0.0
      allocate(ergom%btf_t_doc          (isd:ied,jsd:jed)); ergom%btf_t_doc          =0.0
      allocate(ergom%btf_t_dop          (isd:ied,jsd:jed)); ergom%btf_t_dop          =0.0
      allocate(ergom%btf_total_atmos_tot_N(isd:ied,jsd:jed)); ergom%btf_total_atmos_tot_N=0.0
      allocate(ergom%btf_total_atmos_ship_N(isd:ied,jsd:jed)); ergom%btf_total_atmos_ship_N=0.0
      allocate(ergom%btf_t_n2_with_atmos_tot_N(isd:ied,jsd:jed)); ergom%btf_t_n2_with_atmos_tot_N=0.0
      allocate(ergom%btf_t_nh4_with_atmos_tot_N(isd:ied,jsd:jed)); ergom%btf_t_nh4_with_atmos_tot_N=0.0
      allocate(ergom%btf_t_no3_with_atmos_tot_N(isd:ied,jsd:jed)); ergom%btf_t_no3_with_atmos_tot_N=0.0
      allocate(ergom%btf_t_spp_with_atmos_tot_N(isd:ied,jsd:jed)); ergom%btf_t_spp_with_atmos_tot_N=0.0
      allocate(ergom%btf_t_zoo_with_atmos_tot_N(isd:ied,jsd:jed)); ergom%btf_t_zoo_with_atmos_tot_N=0.0
      allocate(ergom%btf_t_n2_with_atmos_ship_N(isd:ied,jsd:jed)); ergom%btf_t_n2_with_atmos_ship_N=0.0
      allocate(ergom%btf_t_nh4_with_atmos_ship_N(isd:ied,jsd:jed)); ergom%btf_t_nh4_with_atmos_ship_N=0.0
      allocate(ergom%btf_t_no3_with_atmos_ship_N(isd:ied,jsd:jed)); ergom%btf_t_no3_with_atmos_ship_N=0.0
      allocate(ergom%btf_t_spp_with_atmos_ship_N(isd:ied,jsd:jed)); ergom%btf_t_spp_with_atmos_ship_N=0.0
      allocate(ergom%btf_t_zoo_with_atmos_ship_N(isd:ied,jsd:jed)); ergom%btf_t_zoo_with_atmos_ship_N=0.0
      allocate(ergom%btf_t_ipw          (isd:ied,jsd:jed)); ergom%btf_t_ipw          =0.0
      allocate(ergom%btf_t_pocn_with_atmos_tot_N(isd:ied,jsd:jed)); ergom%btf_t_pocn_with_atmos_tot_N=0.0
      allocate(ergom%btf_t_lpp_with_atmos_tot_N(isd:ied,jsd:jed)); ergom%btf_t_lpp_with_atmos_tot_N=0.0
      allocate(ergom%btf_t_don_with_atmos_tot_N(isd:ied,jsd:jed)); ergom%btf_t_don_with_atmos_tot_N=0.0
      allocate(ergom%btf_t_cya_with_atmos_tot_N(isd:ied,jsd:jed)); ergom%btf_t_cya_with_atmos_tot_N=0.0
      allocate(ergom%btf_t_det_with_atmos_tot_N(isd:ied,jsd:jed)); ergom%btf_t_det_with_atmos_tot_N=0.0
      allocate(ergom%btf_t_lpp          (isd:ied,jsd:jed)); ergom%btf_t_lpp          =0.0
      allocate(ergom%btf_t_don          (isd:ied,jsd:jed)); ergom%btf_t_don          =0.0
      allocate(ergom%btf_t_cya          (isd:ied,jsd:jed)); ergom%btf_t_cya          =0.0
      allocate(ergom%btf_t_det          (isd:ied,jsd:jed)); ergom%btf_t_det          =0.0
      allocate(ergom%btf_t_poc          (isd:ied,jsd:jed)); ergom%btf_t_poc          =0.0
      allocate(ergom%btf_t_pocp         (isd:ied,jsd:jed)); ergom%btf_t_pocp         =0.0
      allocate(ergom%btf_t_pocn         (isd:ied,jsd:jed)); ergom%btf_t_pocn         =0.0
      allocate(ergom%btf_t_pocn_with_atmos_ship_N(isd:ied,jsd:jed)); ergom%btf_t_pocn_with_atmos_ship_N=0.0
      allocate(ergom%btf_t_lpp_with_atmos_ship_N(isd:ied,jsd:jed)); ergom%btf_t_lpp_with_atmos_ship_N=0.0
      allocate(ergom%btf_t_don_with_atmos_ship_N(isd:ied,jsd:jed)); ergom%btf_t_don_with_atmos_ship_N=0.0
      allocate(ergom%btf_t_cya_with_atmos_ship_N(isd:ied,jsd:jed)); ergom%btf_t_cya_with_atmos_ship_N=0.0
      allocate(ergom%btf_t_det_with_atmos_ship_N(isd:ied,jsd:jed)); ergom%btf_t_det_with_atmos_ship_N=0.0
    endif

    allocate(ergom%irr_inst(isd:ied,jsd:jed,nk)); ergom%irr_inst=0.0
    allocate(ergom%irr_zw(isd:ied,jsd:jed,nk)); ergom%irr_zw=0.0
    allocate(ergom%bio_opacity(isd:ied,jsd:jed,nk)); ergom%bio_opacity=0.0

    !allocations only for Runge-Kutta method
    if (RUNGE_KUTTA_DEPTH .eq. 2) then
       allocate(ergom%tracer_array_intermediate_t_n2           (isd:ied,jsd:jed,nk)) ; ergom%tracer_array_intermediate_t_n2           =0.0
       allocate(ergom%patankar_modification_t_n2           (isd:ied,jsd:jed,nk))     ; ergom%patankar_modification_t_n2               =0.0
       allocate(ergom%tracer_array_intermediate_t_o2           (isd:ied,jsd:jed,nk)) ; ergom%tracer_array_intermediate_t_o2           =0.0
       allocate(ergom%patankar_modification_t_o2           (isd:ied,jsd:jed,nk))     ; ergom%patankar_modification_t_o2               =0.0
       allocate(ergom%tracer_array_intermediate_t_dic          (isd:ied,jsd:jed,nk)) ; ergom%tracer_array_intermediate_t_dic          =0.0
       allocate(ergom%patankar_modification_t_dic          (isd:ied,jsd:jed,nk))     ; ergom%patankar_modification_t_dic              =0.0
       allocate(ergom%tracer_array_intermediate_t_nh4          (isd:ied,jsd:jed,nk)) ; ergom%tracer_array_intermediate_t_nh4          =0.0
       allocate(ergom%patankar_modification_t_nh4          (isd:ied,jsd:jed,nk))     ; ergom%patankar_modification_t_nh4              =0.0
       allocate(ergom%tracer_array_intermediate_t_no3          (isd:ied,jsd:jed,nk)) ; ergom%tracer_array_intermediate_t_no3          =0.0
       allocate(ergom%patankar_modification_t_no3          (isd:ied,jsd:jed,nk))     ; ergom%patankar_modification_t_no3              =0.0
       allocate(ergom%tracer_array_intermediate_t_po4          (isd:ied,jsd:jed,nk)) ; ergom%tracer_array_intermediate_t_po4          =0.0
       allocate(ergom%patankar_modification_t_po4          (isd:ied,jsd:jed,nk))     ; ergom%patankar_modification_t_po4              =0.0
       allocate(ergom%tracer_array_intermediate_t_spp          (isd:ied,jsd:jed,nk)) ; ergom%tracer_array_intermediate_t_spp          =0.0
       allocate(ergom%patankar_modification_t_spp          (isd:ied,jsd:jed,nk))     ; ergom%patankar_modification_t_spp              =0.0
       allocate(ergom%tracer_array_intermediate_t_zoo          (isd:ied,jsd:jed,nk)) ; ergom%tracer_array_intermediate_t_zoo          =0.0
       allocate(ergom%patankar_modification_t_zoo          (isd:ied,jsd:jed,nk))     ; ergom%patankar_modification_t_zoo              =0.0
       allocate(ergom%tracer_array_intermediate_t_h2s          (isd:ied,jsd:jed,nk)) ; ergom%tracer_array_intermediate_t_h2s          =0.0
       allocate(ergom%patankar_modification_t_h2s          (isd:ied,jsd:jed,nk))     ; ergom%patankar_modification_t_h2s              =0.0
       allocate(ergom%tracer_array_intermediate_t_sul          (isd:ied,jsd:jed,nk)) ; ergom%tracer_array_intermediate_t_sul          =0.0
       allocate(ergom%patankar_modification_t_sul          (isd:ied,jsd:jed,nk))     ; ergom%patankar_modification_t_sul              =0.0
       allocate(ergom%tracer_array_intermediate_t_alk          (isd:ied,jsd:jed,nk)) ; ergom%tracer_array_intermediate_t_alk          =0.0
       allocate(ergom%patankar_modification_t_alk          (isd:ied,jsd:jed,nk))     ; ergom%patankar_modification_t_alk              =0.0
       allocate(ergom%tracer_array_intermediate_t_doc          (isd:ied,jsd:jed,nk)) ; ergom%tracer_array_intermediate_t_doc          =0.0
       allocate(ergom%patankar_modification_t_doc          (isd:ied,jsd:jed,nk))     ; ergom%patankar_modification_t_doc              =0.0
       allocate(ergom%tracer_array_intermediate_t_dop          (isd:ied,jsd:jed,nk)) ; ergom%tracer_array_intermediate_t_dop          =0.0
       allocate(ergom%patankar_modification_t_dop          (isd:ied,jsd:jed,nk))     ; ergom%patankar_modification_t_dop              =0.0
       allocate(ergom%tracer_array_intermediate_total_atmos_tot_N(isd:ied,jsd:jed,nk)) ; ergom%tracer_array_intermediate_total_atmos_tot_N=0.0
       allocate(ergom%patankar_modification_total_atmos_tot_N(isd:ied,jsd:jed,nk))     ; ergom%patankar_modification_total_atmos_tot_N    =0.0
       allocate(ergom%tracer_array_intermediate_total_atmos_ship_N(isd:ied,jsd:jed,nk)) ; ergom%tracer_array_intermediate_total_atmos_ship_N=0.0
       allocate(ergom%patankar_modification_total_atmos_ship_N(isd:ied,jsd:jed,nk))     ; ergom%patankar_modification_total_atmos_ship_N    =0.0
       allocate(ergom%tracer_array_intermediate_t_n2_with_atmos_tot_N(isd:ied,jsd:jed,nk)) ; ergom%tracer_array_intermediate_t_n2_with_atmos_tot_N=0.0
       allocate(ergom%patankar_modification_t_n2_with_atmos_tot_N(isd:ied,jsd:jed,nk))     ; ergom%patankar_modification_t_n2_with_atmos_tot_N    =0.0
       allocate(ergom%tracer_array_intermediate_t_nh4_with_atmos_tot_N(isd:ied,jsd:jed,nk)) ; ergom%tracer_array_intermediate_t_nh4_with_atmos_tot_N=0.0
       allocate(ergom%patankar_modification_t_nh4_with_atmos_tot_N(isd:ied,jsd:jed,nk))     ; ergom%patankar_modification_t_nh4_with_atmos_tot_N    =0.0
       allocate(ergom%tracer_array_intermediate_t_no3_with_atmos_tot_N(isd:ied,jsd:jed,nk)) ; ergom%tracer_array_intermediate_t_no3_with_atmos_tot_N=0.0
       allocate(ergom%patankar_modification_t_no3_with_atmos_tot_N(isd:ied,jsd:jed,nk))     ; ergom%patankar_modification_t_no3_with_atmos_tot_N    =0.0
       allocate(ergom%tracer_array_intermediate_t_spp_with_atmos_tot_N(isd:ied,jsd:jed,nk)) ; ergom%tracer_array_intermediate_t_spp_with_atmos_tot_N=0.0
       allocate(ergom%patankar_modification_t_spp_with_atmos_tot_N(isd:ied,jsd:jed,nk))     ; ergom%patankar_modification_t_spp_with_atmos_tot_N    =0.0
       allocate(ergom%tracer_array_intermediate_t_zoo_with_atmos_tot_N(isd:ied,jsd:jed,nk)) ; ergom%tracer_array_intermediate_t_zoo_with_atmos_tot_N=0.0
       allocate(ergom%patankar_modification_t_zoo_with_atmos_tot_N(isd:ied,jsd:jed,nk))     ; ergom%patankar_modification_t_zoo_with_atmos_tot_N    =0.0
       allocate(ergom%tracer_array_intermediate_t_n2_with_atmos_ship_N(isd:ied,jsd:jed,nk)) ; ergom%tracer_array_intermediate_t_n2_with_atmos_ship_N=0.0
       allocate(ergom%patankar_modification_t_n2_with_atmos_ship_N(isd:ied,jsd:jed,nk))     ; ergom%patankar_modification_t_n2_with_atmos_ship_N    =0.0
       allocate(ergom%tracer_array_intermediate_t_nh4_with_atmos_ship_N(isd:ied,jsd:jed,nk)) ; ergom%tracer_array_intermediate_t_nh4_with_atmos_ship_N=0.0
       allocate(ergom%patankar_modification_t_nh4_with_atmos_ship_N(isd:ied,jsd:jed,nk))     ; ergom%patankar_modification_t_nh4_with_atmos_ship_N    =0.0
       allocate(ergom%tracer_array_intermediate_t_no3_with_atmos_ship_N(isd:ied,jsd:jed,nk)) ; ergom%tracer_array_intermediate_t_no3_with_atmos_ship_N=0.0
       allocate(ergom%patankar_modification_t_no3_with_atmos_ship_N(isd:ied,jsd:jed,nk))     ; ergom%patankar_modification_t_no3_with_atmos_ship_N    =0.0
       allocate(ergom%tracer_array_intermediate_t_spp_with_atmos_ship_N(isd:ied,jsd:jed,nk)) ; ergom%tracer_array_intermediate_t_spp_with_atmos_ship_N=0.0
       allocate(ergom%patankar_modification_t_spp_with_atmos_ship_N(isd:ied,jsd:jed,nk))     ; ergom%patankar_modification_t_spp_with_atmos_ship_N    =0.0
       allocate(ergom%tracer_array_intermediate_t_zoo_with_atmos_ship_N(isd:ied,jsd:jed,nk)) ; ergom%tracer_array_intermediate_t_zoo_with_atmos_ship_N=0.0
       allocate(ergom%patankar_modification_t_zoo_with_atmos_ship_N(isd:ied,jsd:jed,nk))     ; ergom%patankar_modification_t_zoo_with_atmos_ship_N    =0.0
       allocate(ergom%tracer_array_intermediate_t_ipw          (isd:ied,jsd:jed,nk)) ; ergom%tracer_array_intermediate_t_ipw          =0.0
       allocate(ergom%patankar_modification_t_ipw          (isd:ied,jsd:jed,nk))     ; ergom%patankar_modification_t_ipw              =0.0
       allocate(ergom%tracer_array_intermediate_t_pocn_with_atmos_tot_N(isd:ied,jsd:jed,nk)) ; ergom%tracer_array_intermediate_t_pocn_with_atmos_tot_N=0.0
       allocate(ergom%patankar_modification_t_pocn_with_atmos_tot_N(isd:ied,jsd:jed,nk))     ; ergom%patankar_modification_t_pocn_with_atmos_tot_N    =0.0
       allocate(ergom%tracer_array_intermediate_t_lpp_with_atmos_tot_N(isd:ied,jsd:jed,nk)) ; ergom%tracer_array_intermediate_t_lpp_with_atmos_tot_N=0.0
       allocate(ergom%patankar_modification_t_lpp_with_atmos_tot_N(isd:ied,jsd:jed,nk))     ; ergom%patankar_modification_t_lpp_with_atmos_tot_N    =0.0
       allocate(ergom%tracer_array_intermediate_t_don_with_atmos_tot_N(isd:ied,jsd:jed,nk)) ; ergom%tracer_array_intermediate_t_don_with_atmos_tot_N=0.0
       allocate(ergom%patankar_modification_t_don_with_atmos_tot_N(isd:ied,jsd:jed,nk))     ; ergom%patankar_modification_t_don_with_atmos_tot_N    =0.0
       allocate(ergom%tracer_array_intermediate_t_cya_with_atmos_tot_N(isd:ied,jsd:jed,nk)) ; ergom%tracer_array_intermediate_t_cya_with_atmos_tot_N=0.0
       allocate(ergom%patankar_modification_t_cya_with_atmos_tot_N(isd:ied,jsd:jed,nk))     ; ergom%patankar_modification_t_cya_with_atmos_tot_N    =0.0
       allocate(ergom%tracer_array_intermediate_t_det_with_atmos_tot_N(isd:ied,jsd:jed,nk)) ; ergom%tracer_array_intermediate_t_det_with_atmos_tot_N=0.0
       allocate(ergom%patankar_modification_t_det_with_atmos_tot_N(isd:ied,jsd:jed,nk))     ; ergom%patankar_modification_t_det_with_atmos_tot_N    =0.0
       allocate(ergom%tracer_array_intermediate_t_lpp          (isd:ied,jsd:jed,nk)) ; ergom%tracer_array_intermediate_t_lpp          =0.0
       allocate(ergom%patankar_modification_t_lpp          (isd:ied,jsd:jed,nk))     ; ergom%patankar_modification_t_lpp              =0.0
       allocate(ergom%tracer_array_intermediate_t_don          (isd:ied,jsd:jed,nk)) ; ergom%tracer_array_intermediate_t_don          =0.0
       allocate(ergom%patankar_modification_t_don          (isd:ied,jsd:jed,nk))     ; ergom%patankar_modification_t_don              =0.0
       allocate(ergom%tracer_array_intermediate_t_cya          (isd:ied,jsd:jed,nk)) ; ergom%tracer_array_intermediate_t_cya          =0.0
       allocate(ergom%patankar_modification_t_cya          (isd:ied,jsd:jed,nk))     ; ergom%patankar_modification_t_cya              =0.0
       allocate(ergom%tracer_array_intermediate_t_det          (isd:ied,jsd:jed,nk)) ; ergom%tracer_array_intermediate_t_det          =0.0
       allocate(ergom%patankar_modification_t_det          (isd:ied,jsd:jed,nk))     ; ergom%patankar_modification_t_det              =0.0
       allocate(ergom%tracer_array_intermediate_t_poc          (isd:ied,jsd:jed,nk)) ; ergom%tracer_array_intermediate_t_poc          =0.0
       allocate(ergom%patankar_modification_t_poc          (isd:ied,jsd:jed,nk))     ; ergom%patankar_modification_t_poc              =0.0
       allocate(ergom%tracer_array_intermediate_t_pocp         (isd:ied,jsd:jed,nk)) ; ergom%tracer_array_intermediate_t_pocp         =0.0
       allocate(ergom%patankar_modification_t_pocp         (isd:ied,jsd:jed,nk))     ; ergom%patankar_modification_t_pocp             =0.0
       allocate(ergom%tracer_array_intermediate_t_pocn         (isd:ied,jsd:jed,nk)) ; ergom%tracer_array_intermediate_t_pocn         =0.0
       allocate(ergom%patankar_modification_t_pocn         (isd:ied,jsd:jed,nk))     ; ergom%patankar_modification_t_pocn             =0.0
       allocate(ergom%tracer_array_intermediate_t_pocn_with_atmos_ship_N(isd:ied,jsd:jed,nk)) ; ergom%tracer_array_intermediate_t_pocn_with_atmos_ship_N=0.0
       allocate(ergom%patankar_modification_t_pocn_with_atmos_ship_N(isd:ied,jsd:jed,nk))     ; ergom%patankar_modification_t_pocn_with_atmos_ship_N    =0.0
       allocate(ergom%tracer_array_intermediate_t_lpp_with_atmos_ship_N(isd:ied,jsd:jed,nk)) ; ergom%tracer_array_intermediate_t_lpp_with_atmos_ship_N=0.0
       allocate(ergom%patankar_modification_t_lpp_with_atmos_ship_N(isd:ied,jsd:jed,nk))     ; ergom%patankar_modification_t_lpp_with_atmos_ship_N    =0.0
       allocate(ergom%tracer_array_intermediate_t_don_with_atmos_ship_N(isd:ied,jsd:jed,nk)) ; ergom%tracer_array_intermediate_t_don_with_atmos_ship_N=0.0
       allocate(ergom%patankar_modification_t_don_with_atmos_ship_N(isd:ied,jsd:jed,nk))     ; ergom%patankar_modification_t_don_with_atmos_ship_N    =0.0
       allocate(ergom%tracer_array_intermediate_t_cya_with_atmos_ship_N(isd:ied,jsd:jed,nk)) ; ergom%tracer_array_intermediate_t_cya_with_atmos_ship_N=0.0
       allocate(ergom%patankar_modification_t_cya_with_atmos_ship_N(isd:ied,jsd:jed,nk))     ; ergom%patankar_modification_t_cya_with_atmos_ship_N    =0.0
       allocate(ergom%tracer_array_intermediate_t_det_with_atmos_ship_N(isd:ied,jsd:jed,nk)) ; ergom%tracer_array_intermediate_t_det_with_atmos_ship_N=0.0
       allocate(ergom%patankar_modification_t_det_with_atmos_ship_N(isd:ied,jsd:jed,nk))     ; ergom%patankar_modification_t_det_with_atmos_ship_N    =0.0
       allocate(ergom%tracer_array_intermediate_t_sed          (isd:ied,jsd:jed))    ; ergom%tracer_array_intermediate_t_sed          =0.0
       allocate(ergom%patankar_modification_t_sed          (isd:ied,jsd:jed))        ; ergom%patankar_modification_t_sed              =0.0
       allocate(ergom%tracer_array_intermediate_t_ips          (isd:ied,jsd:jed))    ; ergom%tracer_array_intermediate_t_ips          =0.0
       allocate(ergom%patankar_modification_t_ips          (isd:ied,jsd:jed))        ; ergom%patankar_modification_t_ips              =0.0
       allocate(ergom%tracer_array_intermediate_t_sed_poc      (isd:ied,jsd:jed))    ; ergom%tracer_array_intermediate_t_sed_poc      =0.0
       allocate(ergom%patankar_modification_t_sed_poc      (isd:ied,jsd:jed))        ; ergom%patankar_modification_t_sed_poc          =0.0
       allocate(ergom%tracer_array_intermediate_t_sed_pocn     (isd:ied,jsd:jed))    ; ergom%tracer_array_intermediate_t_sed_pocn     =0.0
       allocate(ergom%patankar_modification_t_sed_pocn     (isd:ied,jsd:jed))        ; ergom%patankar_modification_t_sed_pocn         =0.0
       allocate(ergom%tracer_array_intermediate_t_sed_pocp     (isd:ied,jsd:jed))    ; ergom%tracer_array_intermediate_t_sed_pocp     =0.0
       allocate(ergom%patankar_modification_t_sed_pocp     (isd:ied,jsd:jed))        ; ergom%patankar_modification_t_sed_pocp         =0.0
       allocate(ergom%tracer_array_intermediate_total_atmos_tot_N_at_bottom(isd:ied,jsd:jed))    ; ergom%tracer_array_intermediate_total_atmos_tot_N_at_bottom=0.0
       allocate(ergom%patankar_modification_total_atmos_tot_N_at_bottom(isd:ied,jsd:jed))        ; ergom%patankar_modification_total_atmos_tot_N_at_bottom    =0.0
       allocate(ergom%tracer_array_intermediate_total_atmos_ship_N_at_bottom(isd:ied,jsd:jed))    ; ergom%tracer_array_intermediate_total_atmos_ship_N_at_bottom=0.0
       allocate(ergom%patankar_modification_total_atmos_ship_N_at_bottom(isd:ied,jsd:jed))        ; ergom%patankar_modification_total_atmos_ship_N_at_bottom    =0.0
       allocate(ergom%tracer_array_intermediate_t_sed_with_atmos_tot_N(isd:ied,jsd:jed))    ; ergom%tracer_array_intermediate_t_sed_with_atmos_tot_N=0.0
       allocate(ergom%patankar_modification_t_sed_with_atmos_tot_N(isd:ied,jsd:jed))        ; ergom%patankar_modification_t_sed_with_atmos_tot_N    =0.0
       allocate(ergom%tracer_array_intermediate_t_sed_pocn_with_atmos_tot_N(isd:ied,jsd:jed))    ; ergom%tracer_array_intermediate_t_sed_pocn_with_atmos_tot_N=0.0
       allocate(ergom%patankar_modification_t_sed_pocn_with_atmos_tot_N(isd:ied,jsd:jed))        ; ergom%patankar_modification_t_sed_pocn_with_atmos_tot_N    =0.0
       allocate(ergom%tracer_array_intermediate_t_sed_with_atmos_ship_N(isd:ied,jsd:jed))    ; ergom%tracer_array_intermediate_t_sed_with_atmos_ship_N=0.0
       allocate(ergom%patankar_modification_t_sed_with_atmos_ship_N(isd:ied,jsd:jed))        ; ergom%patankar_modification_t_sed_with_atmos_ship_N    =0.0
       allocate(ergom%tracer_array_intermediate_t_sed_pocn_with_atmos_ship_N(isd:ied,jsd:jed))    ; ergom%tracer_array_intermediate_t_sed_pocn_with_atmos_ship_N=0.0
       allocate(ergom%patankar_modification_t_sed_pocn_with_atmos_ship_N(isd:ied,jsd:jed))        ; ergom%patankar_modification_t_sed_pocn_with_atmos_ship_N    =0.0
       allocate(ergom%saved_rate_p_no3_assim_lpp(isd:ied,jsd:jed,nk)) ; ergom%saved_rate_p_no3_assim_lpp=0.0
       allocate(ergom%saved_rate_p_nh4_assim_lpp(isd:ied,jsd:jed,nk)) ; ergom%saved_rate_p_nh4_assim_lpp=0.0
       allocate(ergom%saved_rate_p_no3_assim_spp(isd:ied,jsd:jed,nk)) ; ergom%saved_rate_p_no3_assim_spp=0.0
       allocate(ergom%saved_rate_p_nh4_assim_spp(isd:ied,jsd:jed,nk)) ; ergom%saved_rate_p_nh4_assim_spp=0.0
       allocate(ergom%saved_rate_p_n2_assim_cya (isd:ied,jsd:jed,nk)) ; ergom%saved_rate_p_n2_assim_cya =0.0
       allocate(ergom%saved_rate_p_assim_lpp_doc(isd:ied,jsd:jed,nk)) ; ergom%saved_rate_p_assim_lpp_doc=0.0
       allocate(ergom%saved_rate_p_assim_spp_doc(isd:ied,jsd:jed,nk)) ; ergom%saved_rate_p_assim_spp_doc=0.0
       allocate(ergom%saved_rate_p_assim_cya_doc(isd:ied,jsd:jed,nk)) ; ergom%saved_rate_p_assim_cya_doc=0.0
       allocate(ergom%saved_rate_p_assim_lpp_dop(isd:ied,jsd:jed,nk)) ; ergom%saved_rate_p_assim_lpp_dop=0.0
       allocate(ergom%saved_rate_p_assim_spp_dop(isd:ied,jsd:jed,nk)) ; ergom%saved_rate_p_assim_spp_dop=0.0
       allocate(ergom%saved_rate_p_nh4_assim_lpp_don(isd:ied,jsd:jed,nk)) ; ergom%saved_rate_p_nh4_assim_lpp_don=0.0
       allocate(ergom%saved_rate_p_no3_assim_lpp_don(isd:ied,jsd:jed,nk)) ; ergom%saved_rate_p_no3_assim_lpp_don=0.0
       allocate(ergom%saved_rate_p_nh4_assim_spp_don(isd:ied,jsd:jed,nk)) ; ergom%saved_rate_p_nh4_assim_spp_don=0.0
       allocate(ergom%saved_rate_p_no3_assim_spp_don(isd:ied,jsd:jed,nk)) ; ergom%saved_rate_p_no3_assim_spp_don=0.0
       allocate(ergom%saved_rate_p_poc_resp     (isd:ied,jsd:jed,nk)) ; ergom%saved_rate_p_poc_resp     =0.0
       allocate(ergom%saved_rate_p_poc_denit    (isd:ied,jsd:jed,nk)) ; ergom%saved_rate_p_poc_denit    =0.0
       allocate(ergom%saved_rate_p_poc_sulf     (isd:ied,jsd:jed,nk)) ; ergom%saved_rate_p_poc_sulf     =0.0
       allocate(ergom%saved_rate_p_pocp_resp    (isd:ied,jsd:jed,nk)) ; ergom%saved_rate_p_pocp_resp    =0.0
       allocate(ergom%saved_rate_p_pocp_denit   (isd:ied,jsd:jed,nk)) ; ergom%saved_rate_p_pocp_denit   =0.0
       allocate(ergom%saved_rate_p_pocp_sulf    (isd:ied,jsd:jed,nk)) ; ergom%saved_rate_p_pocp_sulf    =0.0
       allocate(ergom%saved_rate_p_pocn_resp    (isd:ied,jsd:jed,nk)) ; ergom%saved_rate_p_pocn_resp    =0.0
       allocate(ergom%saved_rate_p_pocn_denit_noN2(isd:ied,jsd:jed,nk)) ; ergom%saved_rate_p_pocn_denit_noN2=0.0
       allocate(ergom%saved_rate_p_pocn_denit_wiN2(isd:ied,jsd:jed,nk)) ; ergom%saved_rate_p_pocn_denit_wiN2=0.0
       allocate(ergom%saved_rate_p_pocn_sulf    (isd:ied,jsd:jed,nk)) ; ergom%saved_rate_p_pocn_sulf    =0.0
       allocate(ergom%saved_rate_p_lpp_graz_zoo (isd:ied,jsd:jed,nk)) ; ergom%saved_rate_p_lpp_graz_zoo =0.0
       allocate(ergom%saved_rate_p_spp_graz_zoo (isd:ied,jsd:jed,nk)) ; ergom%saved_rate_p_spp_graz_zoo =0.0
       allocate(ergom%saved_rate_p_cya_graz_zoo (isd:ied,jsd:jed,nk)) ; ergom%saved_rate_p_cya_graz_zoo =0.0
       allocate(ergom%saved_rate_p_lpp_resp_nh4 (isd:ied,jsd:jed,nk)) ; ergom%saved_rate_p_lpp_resp_nh4 =0.0
       allocate(ergom%saved_rate_p_spp_resp_nh4 (isd:ied,jsd:jed,nk)) ; ergom%saved_rate_p_spp_resp_nh4 =0.0
       allocate(ergom%saved_rate_p_cya_resp_nh4 (isd:ied,jsd:jed,nk)) ; ergom%saved_rate_p_cya_resp_nh4 =0.0
       allocate(ergom%saved_rate_p_zoo_resp_nh4 (isd:ied,jsd:jed,nk)) ; ergom%saved_rate_p_zoo_resp_nh4 =0.0
       allocate(ergom%saved_rate_p_lpp_mort_det (isd:ied,jsd:jed,nk)) ; ergom%saved_rate_p_lpp_mort_det =0.0
       allocate(ergom%saved_rate_p_spp_mort_det (isd:ied,jsd:jed,nk)) ; ergom%saved_rate_p_spp_mort_det =0.0
       allocate(ergom%saved_rate_p_cya_mort_det (isd:ied,jsd:jed,nk)) ; ergom%saved_rate_p_cya_mort_det =0.0
       allocate(ergom%saved_rate_p_cya_mort_det_diff(isd:ied,jsd:jed,nk)) ; ergom%saved_rate_p_cya_mort_det_diff=0.0
       allocate(ergom%saved_rate_p_zoo_mort_det (isd:ied,jsd:jed,nk)) ; ergom%saved_rate_p_zoo_mort_det =0.0
       allocate(ergom%saved_rate_p_nh4_nit_no3  (isd:ied,jsd:jed,nk)) ; ergom%saved_rate_p_nh4_nit_no3  =0.0
       allocate(ergom%saved_rate_p_det_resp_nh4 (isd:ied,jsd:jed,nk)) ; ergom%saved_rate_p_det_resp_nh4 =0.0
       allocate(ergom%saved_rate_p_det_denit_nh4(isd:ied,jsd:jed,nk)) ; ergom%saved_rate_p_det_denit_nh4=0.0
       allocate(ergom%saved_rate_p_det_sulf_nh4 (isd:ied,jsd:jed,nk)) ; ergom%saved_rate_p_det_sulf_nh4 =0.0
       allocate(ergom%saved_rate_p_h2s_oxo2_sul (isd:ied,jsd:jed,nk)) ; ergom%saved_rate_p_h2s_oxo2_sul =0.0
       allocate(ergom%saved_rate_p_h2s_oxno3_sul(isd:ied,jsd:jed,nk)) ; ergom%saved_rate_p_h2s_oxno3_sul=0.0
       allocate(ergom%saved_rate_p_sul_oxo2_so4 (isd:ied,jsd:jed,nk)) ; ergom%saved_rate_p_sul_oxo2_so4 =0.0
       allocate(ergom%saved_rate_p_sul_oxno3_so4(isd:ied,jsd:jed,nk)) ; ergom%saved_rate_p_sul_oxno3_so4=0.0
       allocate(ergom%saved_rate_p_doc2pco      (isd:ied,jsd:jed,nk)) ; ergom%saved_rate_p_doc2pco      =0.0
       allocate(ergom%saved_rate_p_dop2pocp     (isd:ied,jsd:jed,nk)) ; ergom%saved_rate_p_dop2pocp     =0.0
       allocate(ergom%saved_rate_p_don2pocn     (isd:ied,jsd:jed,nk)) ; ergom%saved_rate_p_don2pocn     =0.0
       allocate(ergom%saved_rate_p_doc_resp     (isd:ied,jsd:jed,nk)) ; ergom%saved_rate_p_doc_resp     =0.0
       allocate(ergom%saved_rate_p_doc_denit    (isd:ied,jsd:jed,nk)) ; ergom%saved_rate_p_doc_denit    =0.0
       allocate(ergom%saved_rate_p_doc_sulf     (isd:ied,jsd:jed,nk)) ; ergom%saved_rate_p_doc_sulf     =0.0
       allocate(ergom%saved_rate_p_dop_resp     (isd:ied,jsd:jed,nk)) ; ergom%saved_rate_p_dop_resp     =0.0
       allocate(ergom%saved_rate_p_dop_denit    (isd:ied,jsd:jed,nk)) ; ergom%saved_rate_p_dop_denit    =0.0
       allocate(ergom%saved_rate_p_dop_sulf     (isd:ied,jsd:jed,nk)) ; ergom%saved_rate_p_dop_sulf     =0.0
       allocate(ergom%saved_rate_p_don_resp     (isd:ied,jsd:jed,nk)) ; ergom%saved_rate_p_don_resp     =0.0
       allocate(ergom%saved_rate_p_don_denit_noN2(isd:ied,jsd:jed,nk)) ; ergom%saved_rate_p_don_denit_noN2=0.0
       allocate(ergom%saved_rate_p_don_denit_wiN2(isd:ied,jsd:jed,nk)) ; ergom%saved_rate_p_don_denit_wiN2=0.0
       allocate(ergom%saved_rate_p_don_sulf     (isd:ied,jsd:jed,nk)) ; ergom%saved_rate_p_don_sulf     =0.0
       allocate(ergom%saved_rate_p_no3_assim_lpp_atmos_tot_N(isd:ied,jsd:jed,nk)) ; ergom%saved_rate_p_no3_assim_lpp_atmos_tot_N=0.0
       allocate(ergom%saved_rate_p_nh4_assim_lpp_atmos_tot_N(isd:ied,jsd:jed,nk)) ; ergom%saved_rate_p_nh4_assim_lpp_atmos_tot_N=0.0
       allocate(ergom%saved_rate_p_no3_assim_spp_atmos_tot_N(isd:ied,jsd:jed,nk)) ; ergom%saved_rate_p_no3_assim_spp_atmos_tot_N=0.0
       allocate(ergom%saved_rate_p_nh4_assim_spp_atmos_tot_N(isd:ied,jsd:jed,nk)) ; ergom%saved_rate_p_nh4_assim_spp_atmos_tot_N=0.0
       allocate(ergom%saved_rate_p_nh4_assim_lpp_don_atmos_tot_N(isd:ied,jsd:jed,nk)) ; ergom%saved_rate_p_nh4_assim_lpp_don_atmos_tot_N=0.0
       allocate(ergom%saved_rate_p_no3_assim_lpp_don_atmos_tot_N(isd:ied,jsd:jed,nk)) ; ergom%saved_rate_p_no3_assim_lpp_don_atmos_tot_N=0.0
       allocate(ergom%saved_rate_p_nh4_assim_spp_don_atmos_tot_N(isd:ied,jsd:jed,nk)) ; ergom%saved_rate_p_nh4_assim_spp_don_atmos_tot_N=0.0
       allocate(ergom%saved_rate_p_no3_assim_spp_don_atmos_tot_N(isd:ied,jsd:jed,nk)) ; ergom%saved_rate_p_no3_assim_spp_don_atmos_tot_N=0.0
       allocate(ergom%saved_rate_p_pocn_resp_atmos_tot_N(isd:ied,jsd:jed,nk)) ; ergom%saved_rate_p_pocn_resp_atmos_tot_N=0.0
       allocate(ergom%saved_rate_p_pocn_denit_noN2_atmos_tot_N(isd:ied,jsd:jed,nk)) ; ergom%saved_rate_p_pocn_denit_noN2_atmos_tot_N=0.0
       allocate(ergom%saved_rate_p_pocn_sulf_atmos_tot_N(isd:ied,jsd:jed,nk)) ; ergom%saved_rate_p_pocn_sulf_atmos_tot_N=0.0
       allocate(ergom%saved_rate_p_lpp_graz_zoo_atmos_tot_N(isd:ied,jsd:jed,nk)) ; ergom%saved_rate_p_lpp_graz_zoo_atmos_tot_N=0.0
       allocate(ergom%saved_rate_p_spp_graz_zoo_atmos_tot_N(isd:ied,jsd:jed,nk)) ; ergom%saved_rate_p_spp_graz_zoo_atmos_tot_N=0.0
       allocate(ergom%saved_rate_p_cya_graz_zoo_atmos_tot_N(isd:ied,jsd:jed,nk)) ; ergom%saved_rate_p_cya_graz_zoo_atmos_tot_N=0.0
       allocate(ergom%saved_rate_p_lpp_resp_nh4_atmos_tot_N(isd:ied,jsd:jed,nk)) ; ergom%saved_rate_p_lpp_resp_nh4_atmos_tot_N=0.0
       allocate(ergom%saved_rate_p_spp_resp_nh4_atmos_tot_N(isd:ied,jsd:jed,nk)) ; ergom%saved_rate_p_spp_resp_nh4_atmos_tot_N=0.0
       allocate(ergom%saved_rate_p_cya_resp_nh4_atmos_tot_N(isd:ied,jsd:jed,nk)) ; ergom%saved_rate_p_cya_resp_nh4_atmos_tot_N=0.0
       allocate(ergom%saved_rate_p_zoo_resp_nh4_atmos_tot_N(isd:ied,jsd:jed,nk)) ; ergom%saved_rate_p_zoo_resp_nh4_atmos_tot_N=0.0
       allocate(ergom%saved_rate_p_lpp_mort_det_atmos_tot_N(isd:ied,jsd:jed,nk)) ; ergom%saved_rate_p_lpp_mort_det_atmos_tot_N=0.0
       allocate(ergom%saved_rate_p_spp_mort_det_atmos_tot_N(isd:ied,jsd:jed,nk)) ; ergom%saved_rate_p_spp_mort_det_atmos_tot_N=0.0
       allocate(ergom%saved_rate_p_cya_mort_det_atmos_tot_N(isd:ied,jsd:jed,nk)) ; ergom%saved_rate_p_cya_mort_det_atmos_tot_N=0.0
       allocate(ergom%saved_rate_p_cya_mort_det_diff_atmos_tot_N(isd:ied,jsd:jed,nk)) ; ergom%saved_rate_p_cya_mort_det_diff_atmos_tot_N=0.0
       allocate(ergom%saved_rate_p_zoo_mort_det_atmos_tot_N(isd:ied,jsd:jed,nk)) ; ergom%saved_rate_p_zoo_mort_det_atmos_tot_N=0.0
       allocate(ergom%saved_rate_p_nh4_nit_no3_atmos_tot_N(isd:ied,jsd:jed,nk)) ; ergom%saved_rate_p_nh4_nit_no3_atmos_tot_N=0.0
       allocate(ergom%saved_rate_p_det_resp_nh4_atmos_tot_N(isd:ied,jsd:jed,nk)) ; ergom%saved_rate_p_det_resp_nh4_atmos_tot_N=0.0
       allocate(ergom%saved_rate_p_det_sulf_nh4_atmos_tot_N(isd:ied,jsd:jed,nk)) ; ergom%saved_rate_p_det_sulf_nh4_atmos_tot_N=0.0
       allocate(ergom%saved_rate_p_don2pocn_atmos_tot_N(isd:ied,jsd:jed,nk)) ; ergom%saved_rate_p_don2pocn_atmos_tot_N=0.0
       allocate(ergom%saved_rate_p_don_resp_atmos_tot_N(isd:ied,jsd:jed,nk)) ; ergom%saved_rate_p_don_resp_atmos_tot_N=0.0
       allocate(ergom%saved_rate_p_don_denit_noN2_atmos_tot_N(isd:ied,jsd:jed,nk)) ; ergom%saved_rate_p_don_denit_noN2_atmos_tot_N=0.0
       allocate(ergom%saved_rate_p_don_sulf_atmos_tot_N(isd:ied,jsd:jed,nk)) ; ergom%saved_rate_p_don_sulf_atmos_tot_N=0.0
       allocate(ergom%saved_rate_p_no3_assim_lpp_atmos_ship_N(isd:ied,jsd:jed,nk)) ; ergom%saved_rate_p_no3_assim_lpp_atmos_ship_N=0.0
       allocate(ergom%saved_rate_p_nh4_assim_lpp_atmos_ship_N(isd:ied,jsd:jed,nk)) ; ergom%saved_rate_p_nh4_assim_lpp_atmos_ship_N=0.0
       allocate(ergom%saved_rate_p_no3_assim_spp_atmos_ship_N(isd:ied,jsd:jed,nk)) ; ergom%saved_rate_p_no3_assim_spp_atmos_ship_N=0.0
       allocate(ergom%saved_rate_p_nh4_assim_spp_atmos_ship_N(isd:ied,jsd:jed,nk)) ; ergom%saved_rate_p_nh4_assim_spp_atmos_ship_N=0.0
       allocate(ergom%saved_rate_p_nh4_assim_lpp_don_atmos_ship_N(isd:ied,jsd:jed,nk)) ; ergom%saved_rate_p_nh4_assim_lpp_don_atmos_ship_N=0.0
       allocate(ergom%saved_rate_p_no3_assim_lpp_don_atmos_ship_N(isd:ied,jsd:jed,nk)) ; ergom%saved_rate_p_no3_assim_lpp_don_atmos_ship_N=0.0
       allocate(ergom%saved_rate_p_nh4_assim_spp_don_atmos_ship_N(isd:ied,jsd:jed,nk)) ; ergom%saved_rate_p_nh4_assim_spp_don_atmos_ship_N=0.0
       allocate(ergom%saved_rate_p_no3_assim_spp_don_atmos_ship_N(isd:ied,jsd:jed,nk)) ; ergom%saved_rate_p_no3_assim_spp_don_atmos_ship_N=0.0
       allocate(ergom%saved_rate_p_pocn_resp_atmos_ship_N(isd:ied,jsd:jed,nk)) ; ergom%saved_rate_p_pocn_resp_atmos_ship_N=0.0
       allocate(ergom%saved_rate_p_pocn_denit_noN2_atmos_ship_N(isd:ied,jsd:jed,nk)) ; ergom%saved_rate_p_pocn_denit_noN2_atmos_ship_N=0.0
       allocate(ergom%saved_rate_p_pocn_sulf_atmos_ship_N(isd:ied,jsd:jed,nk)) ; ergom%saved_rate_p_pocn_sulf_atmos_ship_N=0.0
       allocate(ergom%saved_rate_p_lpp_graz_zoo_atmos_ship_N(isd:ied,jsd:jed,nk)) ; ergom%saved_rate_p_lpp_graz_zoo_atmos_ship_N=0.0
       allocate(ergom%saved_rate_p_spp_graz_zoo_atmos_ship_N(isd:ied,jsd:jed,nk)) ; ergom%saved_rate_p_spp_graz_zoo_atmos_ship_N=0.0
       allocate(ergom%saved_rate_p_cya_graz_zoo_atmos_ship_N(isd:ied,jsd:jed,nk)) ; ergom%saved_rate_p_cya_graz_zoo_atmos_ship_N=0.0
       allocate(ergom%saved_rate_p_lpp_resp_nh4_atmos_ship_N(isd:ied,jsd:jed,nk)) ; ergom%saved_rate_p_lpp_resp_nh4_atmos_ship_N=0.0
       allocate(ergom%saved_rate_p_spp_resp_nh4_atmos_ship_N(isd:ied,jsd:jed,nk)) ; ergom%saved_rate_p_spp_resp_nh4_atmos_ship_N=0.0
       allocate(ergom%saved_rate_p_cya_resp_nh4_atmos_ship_N(isd:ied,jsd:jed,nk)) ; ergom%saved_rate_p_cya_resp_nh4_atmos_ship_N=0.0
       allocate(ergom%saved_rate_p_zoo_resp_nh4_atmos_ship_N(isd:ied,jsd:jed,nk)) ; ergom%saved_rate_p_zoo_resp_nh4_atmos_ship_N=0.0
       allocate(ergom%saved_rate_p_lpp_mort_det_atmos_ship_N(isd:ied,jsd:jed,nk)) ; ergom%saved_rate_p_lpp_mort_det_atmos_ship_N=0.0
       allocate(ergom%saved_rate_p_spp_mort_det_atmos_ship_N(isd:ied,jsd:jed,nk)) ; ergom%saved_rate_p_spp_mort_det_atmos_ship_N=0.0
       allocate(ergom%saved_rate_p_cya_mort_det_atmos_ship_N(isd:ied,jsd:jed,nk)) ; ergom%saved_rate_p_cya_mort_det_atmos_ship_N=0.0
       allocate(ergom%saved_rate_p_cya_mort_det_diff_atmos_ship_N(isd:ied,jsd:jed,nk)) ; ergom%saved_rate_p_cya_mort_det_diff_atmos_ship_N=0.0
       allocate(ergom%saved_rate_p_zoo_mort_det_atmos_ship_N(isd:ied,jsd:jed,nk)) ; ergom%saved_rate_p_zoo_mort_det_atmos_ship_N=0.0
       allocate(ergom%saved_rate_p_nh4_nit_no3_atmos_ship_N(isd:ied,jsd:jed,nk)) ; ergom%saved_rate_p_nh4_nit_no3_atmos_ship_N=0.0
       allocate(ergom%saved_rate_p_det_resp_nh4_atmos_ship_N(isd:ied,jsd:jed,nk)) ; ergom%saved_rate_p_det_resp_nh4_atmos_ship_N=0.0
       allocate(ergom%saved_rate_p_det_sulf_nh4_atmos_ship_N(isd:ied,jsd:jed,nk)) ; ergom%saved_rate_p_det_sulf_nh4_atmos_ship_N=0.0
       allocate(ergom%saved_rate_p_don2pocn_atmos_ship_N(isd:ied,jsd:jed,nk)) ; ergom%saved_rate_p_don2pocn_atmos_ship_N=0.0
       allocate(ergom%saved_rate_p_don_resp_atmos_ship_N(isd:ied,jsd:jed,nk)) ; ergom%saved_rate_p_don_resp_atmos_ship_N=0.0
       allocate(ergom%saved_rate_p_don_denit_noN2_atmos_ship_N(isd:ied,jsd:jed,nk)) ; ergom%saved_rate_p_don_denit_noN2_atmos_ship_N=0.0
       allocate(ergom%saved_rate_p_don_sulf_atmos_ship_N(isd:ied,jsd:jed,nk)) ; ergom%saved_rate_p_don_sulf_atmos_ship_N=0.0
       allocate(ergom%saved_rate_p_sed_resp_nh4 (isd:ied,jsd:jed)) ;    ergom%saved_rate_p_sed_resp_nh4 =0.0
       allocate(ergom%saved_rate_p_nh4_nitdenit_n2(isd:ied,jsd:jed)) ;    ergom%saved_rate_p_nh4_nitdenit_n2=0.0
       allocate(ergom%saved_rate_p_sed_denit_nh4_noN2(isd:ied,jsd:jed)) ;    ergom%saved_rate_p_sed_denit_nh4_noN2=0.0
       allocate(ergom%saved_rate_p_sed_denit_nh4_wiN2(isd:ied,jsd:jed)) ;    ergom%saved_rate_p_sed_denit_nh4_wiN2=0.0
       allocate(ergom%saved_rate_p_sed_sulf_nh4 (isd:ied,jsd:jed)) ;    ergom%saved_rate_p_sed_sulf_nh4 =0.0
       allocate(ergom%saved_rate_p_sed_poc_resp (isd:ied,jsd:jed)) ;    ergom%saved_rate_p_sed_poc_resp =0.0
       allocate(ergom%saved_rate_p_sed_poc_denit(isd:ied,jsd:jed)) ;    ergom%saved_rate_p_sed_poc_denit=0.0
       allocate(ergom%saved_rate_p_sed_poc_sulf (isd:ied,jsd:jed)) ;    ergom%saved_rate_p_sed_poc_sulf =0.0
       allocate(ergom%saved_rate_p_po4_retent_ips(isd:ied,jsd:jed)) ;    ergom%saved_rate_p_po4_retent_ips=0.0
       allocate(ergom%saved_rate_p_ips_liber_po4(isd:ied,jsd:jed)) ;    ergom%saved_rate_p_ips_liber_po4=0.0
       allocate(ergom%saved_rate_p_det_sedi_sed (isd:ied,jsd:jed)) ;    ergom%saved_rate_p_det_sedi_sed =0.0
       allocate(ergom%saved_rate_p_ipw_sedi_ips (isd:ied,jsd:jed)) ;    ergom%saved_rate_p_ipw_sedi_ips =0.0
       allocate(ergom%saved_rate_p_poc_sedi_sed (isd:ied,jsd:jed)) ;    ergom%saved_rate_p_poc_sedi_sed =0.0
       allocate(ergom%saved_rate_p_pocn_sedi_sed(isd:ied,jsd:jed)) ;    ergom%saved_rate_p_pocn_sedi_sed=0.0
       allocate(ergom%saved_rate_p_pocp_sedi_sed(isd:ied,jsd:jed)) ;    ergom%saved_rate_p_pocp_sedi_sed=0.0
       allocate(ergom%saved_rate_p_sed_ero_det  (isd:ied,jsd:jed)) ;    ergom%saved_rate_p_sed_ero_det  =0.0
       allocate(ergom%saved_rate_p_ips_ero_ipw  (isd:ied,jsd:jed)) ;    ergom%saved_rate_p_ips_ero_ipw  =0.0
       allocate(ergom%saved_rate_p_sed_ero_poc  (isd:ied,jsd:jed)) ;    ergom%saved_rate_p_sed_ero_poc  =0.0
       allocate(ergom%saved_rate_p_sed_ero_pocn (isd:ied,jsd:jed)) ;    ergom%saved_rate_p_sed_ero_pocn =0.0
       allocate(ergom%saved_rate_p_sed_ero_pocp (isd:ied,jsd:jed)) ;    ergom%saved_rate_p_sed_ero_pocp =0.0
       allocate(ergom%saved_rate_p_sed_biores_det(isd:ied,jsd:jed)) ;    ergom%saved_rate_p_sed_biores_det=0.0
       allocate(ergom%saved_rate_p_ips_biores_ipw(isd:ied,jsd:jed)) ;    ergom%saved_rate_p_ips_biores_ipw=0.0
       allocate(ergom%saved_rate_p_sed_biores_poc(isd:ied,jsd:jed)) ;    ergom%saved_rate_p_sed_biores_poc=0.0
       allocate(ergom%saved_rate_p_sed_biores_pocn(isd:ied,jsd:jed)) ;    ergom%saved_rate_p_sed_biores_pocn=0.0
       allocate(ergom%saved_rate_p_sed_biores_pocp(isd:ied,jsd:jed)) ;    ergom%saved_rate_p_sed_biores_pocp=0.0
       allocate(ergom%saved_rate_p_sed_burial   (isd:ied,jsd:jed)) ;    ergom%saved_rate_p_sed_burial   =0.0
       allocate(ergom%saved_rate_p_ips_burial   (isd:ied,jsd:jed)) ;    ergom%saved_rate_p_ips_burial   =0.0
       allocate(ergom%saved_rate_p_poc_burial   (isd:ied,jsd:jed)) ;    ergom%saved_rate_p_poc_burial   =0.0
       allocate(ergom%saved_rate_p_pocn_burial  (isd:ied,jsd:jed)) ;    ergom%saved_rate_p_pocn_burial  =0.0
       allocate(ergom%saved_rate_p_pocp_burial  (isd:ied,jsd:jed)) ;    ergom%saved_rate_p_pocp_burial  =0.0
       allocate(ergom%saved_rate_p_sed_pocn_resp(isd:ied,jsd:jed)) ;    ergom%saved_rate_p_sed_pocn_resp=0.0
       allocate(ergom%saved_rate_p_sed_pocp_resp(isd:ied,jsd:jed)) ;    ergom%saved_rate_p_sed_pocp_resp=0.0
       allocate(ergom%saved_rate_p_sed_pocn_denit_noN2(isd:ied,jsd:jed)) ;    ergom%saved_rate_p_sed_pocn_denit_noN2=0.0
       allocate(ergom%saved_rate_p_sed_pocn_denit_wiN2(isd:ied,jsd:jed)) ;    ergom%saved_rate_p_sed_pocn_denit_wiN2=0.0
       allocate(ergom%saved_rate_p_sed_pocp_denit(isd:ied,jsd:jed)) ;    ergom%saved_rate_p_sed_pocp_denit=0.0
       allocate(ergom%saved_rate_p_sed_pocn_sulf(isd:ied,jsd:jed)) ;    ergom%saved_rate_p_sed_pocn_sulf=0.0
       allocate(ergom%saved_rate_p_sed_pocp_sulf(isd:ied,jsd:jed)) ;    ergom%saved_rate_p_sed_pocp_sulf=0.0
       allocate(ergom%saved_rate_p_nh4_nitdenit_pocn_n2(isd:ied,jsd:jed)) ;    ergom%saved_rate_p_nh4_nitdenit_pocn_n2=0.0
       allocate(ergom%saved_rate_p_sed_resp_nh4_atmos_tot_N(isd:ied,jsd:jed)) ;    ergom%saved_rate_p_sed_resp_nh4_atmos_tot_N=0.0
       allocate(ergom%saved_rate_p_sed_denit_nh4_noN2_atmos_tot_N(isd:ied,jsd:jed)) ;    ergom%saved_rate_p_sed_denit_nh4_noN2_atmos_tot_N=0.0
       allocate(ergom%saved_rate_p_sed_sulf_nh4_atmos_tot_N(isd:ied,jsd:jed)) ;    ergom%saved_rate_p_sed_sulf_nh4_atmos_tot_N=0.0
       allocate(ergom%saved_rate_p_det_sedi_sed_atmos_tot_N(isd:ied,jsd:jed)) ;    ergom%saved_rate_p_det_sedi_sed_atmos_tot_N=0.0
       allocate(ergom%saved_rate_p_pocn_sedi_sed_atmos_tot_N(isd:ied,jsd:jed)) ;    ergom%saved_rate_p_pocn_sedi_sed_atmos_tot_N=0.0
       allocate(ergom%saved_rate_p_sed_ero_det_atmos_tot_N(isd:ied,jsd:jed)) ;    ergom%saved_rate_p_sed_ero_det_atmos_tot_N=0.0
       allocate(ergom%saved_rate_p_sed_ero_pocn_atmos_tot_N(isd:ied,jsd:jed)) ;    ergom%saved_rate_p_sed_ero_pocn_atmos_tot_N=0.0
       allocate(ergom%saved_rate_p_sed_biores_det_atmos_tot_N(isd:ied,jsd:jed)) ;    ergom%saved_rate_p_sed_biores_det_atmos_tot_N=0.0
       allocate(ergom%saved_rate_p_sed_biores_pocn_atmos_tot_N(isd:ied,jsd:jed)) ;    ergom%saved_rate_p_sed_biores_pocn_atmos_tot_N=0.0
       allocate(ergom%saved_rate_p_sed_burial_atmos_tot_N(isd:ied,jsd:jed)) ;    ergom%saved_rate_p_sed_burial_atmos_tot_N=0.0
       allocate(ergom%saved_rate_p_pocn_burial_atmos_tot_N(isd:ied,jsd:jed)) ;    ergom%saved_rate_p_pocn_burial_atmos_tot_N=0.0
       allocate(ergom%saved_rate_p_sed_pocn_resp_atmos_tot_N(isd:ied,jsd:jed)) ;    ergom%saved_rate_p_sed_pocn_resp_atmos_tot_N=0.0
       allocate(ergom%saved_rate_p_sed_pocn_denit_noN2_atmos_tot_N(isd:ied,jsd:jed)) ;    ergom%saved_rate_p_sed_pocn_denit_noN2_atmos_tot_N=0.0
       allocate(ergom%saved_rate_p_sed_pocn_sulf_atmos_tot_N(isd:ied,jsd:jed)) ;    ergom%saved_rate_p_sed_pocn_sulf_atmos_tot_N=0.0
       allocate(ergom%saved_rate_p_sed_resp_nh4_atmos_ship_N(isd:ied,jsd:jed)) ;    ergom%saved_rate_p_sed_resp_nh4_atmos_ship_N=0.0
       allocate(ergom%saved_rate_p_sed_denit_nh4_noN2_atmos_ship_N(isd:ied,jsd:jed)) ;    ergom%saved_rate_p_sed_denit_nh4_noN2_atmos_ship_N=0.0
       allocate(ergom%saved_rate_p_sed_sulf_nh4_atmos_ship_N(isd:ied,jsd:jed)) ;    ergom%saved_rate_p_sed_sulf_nh4_atmos_ship_N=0.0
       allocate(ergom%saved_rate_p_det_sedi_sed_atmos_ship_N(isd:ied,jsd:jed)) ;    ergom%saved_rate_p_det_sedi_sed_atmos_ship_N=0.0
       allocate(ergom%saved_rate_p_pocn_sedi_sed_atmos_ship_N(isd:ied,jsd:jed)) ;    ergom%saved_rate_p_pocn_sedi_sed_atmos_ship_N=0.0
       allocate(ergom%saved_rate_p_sed_ero_det_atmos_ship_N(isd:ied,jsd:jed)) ;    ergom%saved_rate_p_sed_ero_det_atmos_ship_N=0.0
       allocate(ergom%saved_rate_p_sed_ero_pocn_atmos_ship_N(isd:ied,jsd:jed)) ;    ergom%saved_rate_p_sed_ero_pocn_atmos_ship_N=0.0
       allocate(ergom%saved_rate_p_sed_biores_det_atmos_ship_N(isd:ied,jsd:jed)) ;    ergom%saved_rate_p_sed_biores_det_atmos_ship_N=0.0
       allocate(ergom%saved_rate_p_sed_biores_pocn_atmos_ship_N(isd:ied,jsd:jed)) ;    ergom%saved_rate_p_sed_biores_pocn_atmos_ship_N=0.0
       allocate(ergom%saved_rate_p_sed_burial_atmos_ship_N(isd:ied,jsd:jed)) ;    ergom%saved_rate_p_sed_burial_atmos_ship_N=0.0
       allocate(ergom%saved_rate_p_pocn_burial_atmos_ship_N(isd:ied,jsd:jed)) ;    ergom%saved_rate_p_pocn_burial_atmos_ship_N=0.0
       allocate(ergom%saved_rate_p_sed_pocn_resp_atmos_ship_N(isd:ied,jsd:jed)) ;    ergom%saved_rate_p_sed_pocn_resp_atmos_ship_N=0.0
       allocate(ergom%saved_rate_p_sed_pocn_denit_noN2_atmos_ship_N(isd:ied,jsd:jed)) ;    ergom%saved_rate_p_sed_pocn_denit_noN2_atmos_ship_N=0.0
       allocate(ergom%saved_rate_p_sed_pocn_sulf_atmos_ship_N(isd:ied,jsd:jed)) ;    ergom%saved_rate_p_sed_pocn_sulf_atmos_ship_N=0.0
       if (NUM_SEDIMENT_LAYERS .gt. 1) then
          allocate(ergom%tracer_array_intermediate_sed_t_sed          (isd:ied,jsd:jed,nk)) ; ergom%tracer_array_intermediate_sed_t_sed          =0.0
          allocate(ergom%patankar_modification_sed_t_sed          (isd:ied,jsd:jed,nk))     ; ergom%patankar_modification_sed_t_sed              =0.0
          allocate(ergom%tracer_array_intermediate_sed_t_ips          (isd:ied,jsd:jed,nk)) ; ergom%tracer_array_intermediate_sed_t_ips          =0.0
          allocate(ergom%patankar_modification_sed_t_ips          (isd:ied,jsd:jed,nk))     ; ergom%patankar_modification_sed_t_ips              =0.0
          allocate(ergom%tracer_array_intermediate_sed_t_sed_poc      (isd:ied,jsd:jed,nk)) ; ergom%tracer_array_intermediate_sed_t_sed_poc      =0.0
          allocate(ergom%patankar_modification_sed_t_sed_poc      (isd:ied,jsd:jed,nk))     ; ergom%patankar_modification_sed_t_sed_poc          =0.0
          allocate(ergom%tracer_array_intermediate_sed_t_sed_pocn     (isd:ied,jsd:jed,nk)) ; ergom%tracer_array_intermediate_sed_t_sed_pocn     =0.0
          allocate(ergom%patankar_modification_sed_t_sed_pocn     (isd:ied,jsd:jed,nk))     ; ergom%patankar_modification_sed_t_sed_pocn         =0.0
          allocate(ergom%tracer_array_intermediate_sed_t_sed_pocp     (isd:ied,jsd:jed,nk)) ; ergom%tracer_array_intermediate_sed_t_sed_pocp     =0.0
          allocate(ergom%patankar_modification_sed_t_sed_pocp     (isd:ied,jsd:jed,nk))     ; ergom%patankar_modification_sed_t_sed_pocp         =0.0
          allocate(ergom%tracer_array_intermediate_sed_total_atmos_tot_N_at_bottom(isd:ied,jsd:jed,nk)) ; ergom%tracer_array_intermediate_sed_total_atmos_tot_N_at_bottom=0.0
          allocate(ergom%patankar_modification_sed_total_atmos_tot_N_at_bottom(isd:ied,jsd:jed,nk))     ; ergom%patankar_modification_sed_total_atmos_tot_N_at_bottom    =0.0
          allocate(ergom%tracer_array_intermediate_sed_total_atmos_ship_N_at_bottom(isd:ied,jsd:jed,nk)) ; ergom%tracer_array_intermediate_sed_total_atmos_ship_N_at_bottom=0.0
          allocate(ergom%patankar_modification_sed_total_atmos_ship_N_at_bottom(isd:ied,jsd:jed,nk))     ; ergom%patankar_modification_sed_total_atmos_ship_N_at_bottom    =0.0
          allocate(ergom%tracer_array_intermediate_sed_t_sed_with_atmos_tot_N(isd:ied,jsd:jed,nk)) ; ergom%tracer_array_intermediate_sed_t_sed_with_atmos_tot_N=0.0
          allocate(ergom%patankar_modification_sed_t_sed_with_atmos_tot_N(isd:ied,jsd:jed,nk))     ; ergom%patankar_modification_sed_t_sed_with_atmos_tot_N    =0.0
          allocate(ergom%tracer_array_intermediate_sed_t_sed_pocn_with_atmos_tot_N(isd:ied,jsd:jed,nk)) ; ergom%tracer_array_intermediate_sed_t_sed_pocn_with_atmos_tot_N=0.0
          allocate(ergom%patankar_modification_sed_t_sed_pocn_with_atmos_tot_N(isd:ied,jsd:jed,nk))     ; ergom%patankar_modification_sed_t_sed_pocn_with_atmos_tot_N    =0.0
          allocate(ergom%tracer_array_intermediate_sed_t_sed_with_atmos_ship_N(isd:ied,jsd:jed,nk)) ; ergom%tracer_array_intermediate_sed_t_sed_with_atmos_ship_N=0.0
          allocate(ergom%patankar_modification_sed_t_sed_with_atmos_ship_N(isd:ied,jsd:jed,nk))     ; ergom%patankar_modification_sed_t_sed_with_atmos_ship_N    =0.0
          allocate(ergom%tracer_array_intermediate_sed_t_sed_pocn_with_atmos_ship_N(isd:ied,jsd:jed,nk)) ; ergom%tracer_array_intermediate_sed_t_sed_pocn_with_atmos_ship_N=0.0
          allocate(ergom%patankar_modification_sed_t_sed_pocn_with_atmos_ship_N(isd:ied,jsd:jed,nk))     ; ergom%patankar_modification_sed_t_sed_pocn_with_atmos_ship_N    =0.0
          allocate(ergom%saved_rate_sed_p_sed_burial   (isd:ied,jsd:jed,nk)) ; ergom%saved_rate_sed_p_sed_burial   =0.0
          allocate(ergom%saved_rate_sed_p_ips_burial   (isd:ied,jsd:jed,nk)) ; ergom%saved_rate_sed_p_ips_burial   =0.0
          allocate(ergom%saved_rate_sed_p_poc_burial   (isd:ied,jsd:jed,nk)) ; ergom%saved_rate_sed_p_poc_burial   =0.0
          allocate(ergom%saved_rate_sed_p_pocn_burial  (isd:ied,jsd:jed,nk)) ; ergom%saved_rate_sed_p_pocn_burial  =0.0
          allocate(ergom%saved_rate_sed_p_pocp_burial  (isd:ied,jsd:jed,nk)) ; ergom%saved_rate_sed_p_pocp_burial  =0.0
          allocate(ergom%saved_rate_sed_p_det_sedi_sed_atmos_tot_N(isd:ied,jsd:jed,nk)) ; ergom%saved_rate_sed_p_det_sedi_sed_atmos_tot_N=0.0
          allocate(ergom%saved_rate_sed_p_pocn_sedi_sed_atmos_tot_N(isd:ied,jsd:jed,nk)) ; ergom%saved_rate_sed_p_pocn_sedi_sed_atmos_tot_N=0.0
          allocate(ergom%saved_rate_sed_p_sed_burial_atmos_tot_N(isd:ied,jsd:jed,nk)) ; ergom%saved_rate_sed_p_sed_burial_atmos_tot_N=0.0
          allocate(ergom%saved_rate_sed_p_pocn_burial_atmos_tot_N(isd:ied,jsd:jed,nk)) ; ergom%saved_rate_sed_p_pocn_burial_atmos_tot_N=0.0
          allocate(ergom%saved_rate_sed_p_det_sedi_sed_atmos_ship_N(isd:ied,jsd:jed,nk)) ; ergom%saved_rate_sed_p_det_sedi_sed_atmos_ship_N=0.0
          allocate(ergom%saved_rate_sed_p_pocn_sedi_sed_atmos_ship_N(isd:ied,jsd:jed,nk)) ; ergom%saved_rate_sed_p_pocn_sedi_sed_atmos_ship_N=0.0
          allocate(ergom%saved_rate_sed_p_sed_burial_atmos_ship_N(isd:ied,jsd:jed,nk)) ; ergom%saved_rate_sed_p_sed_burial_atmos_ship_N=0.0
          allocate(ergom%saved_rate_sed_p_pocn_burial_atmos_ship_N(isd:ied,jsd:jed,nk)) ; ergom%saved_rate_sed_p_pocn_burial_atmos_ship_N=0.0
       endif
    endif

    call mpp_clock_end(id_alloc)

  end subroutine user_allocate_arrays

  subroutine generic_ERGOM_register_diag(diag_list)
    type(g_diag_type), pointer :: diag_list
    type(vardesc)  :: vardesc_temp
    integer        :: isc,iec,jsc,jec,isd,ied,jsd,jed,nk,ntau, axes(3)
    type(time_type):: init_time

    call g_tracer_get_common(isc,iec,jsc,jec,isd,ied,jsd,jed,nk,ntau,axes=axes,init_time=init_time)

    vardesc_temp = vardesc("p_no3_assim_lpp","assimilation of nitrate by large-cell phytoplankton",'h','1','s','mol kg-1 d-1','f')
    ergom%id_p_no3_assim_lpp = register_diag_field(package_name, vardesc_temp%name, axes(1:3),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    if (ergom%id_p_no3_assim_lpp .gt. 0) then
      allocate(ergom%p_no3_assim_lpp(isd:ied,jsd:jed,nk))
      ergom%p_no3_assim_lpp = 0.0
    endif
    vardesc_temp = vardesc("p_nh4_assim_lpp","assimilation of ammonium by large-cell phytoplankton",'h','1','s','mol kg-1 d-1','f')
    ergom%id_p_nh4_assim_lpp = register_diag_field(package_name, vardesc_temp%name, axes(1:3),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    if (ergom%id_p_nh4_assim_lpp .gt. 0) then
      allocate(ergom%p_nh4_assim_lpp(isd:ied,jsd:jed,nk))
      ergom%p_nh4_assim_lpp = 0.0
    endif
    vardesc_temp = vardesc("p_no3_assim_spp","assimilation of nitrate by small-cell phytoplankton",'h','1','s','mol kg-1 d-1','f')
    ergom%id_p_no3_assim_spp = register_diag_field(package_name, vardesc_temp%name, axes(1:3),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    if (ergom%id_p_no3_assim_spp .gt. 0) then
      allocate(ergom%p_no3_assim_spp(isd:ied,jsd:jed,nk))
      ergom%p_no3_assim_spp = 0.0
    endif
    vardesc_temp = vardesc("p_nh4_assim_spp","assimilation of ammonium by small-cell phytoplankton",'h','1','s','mol kg-1 d-1','f')
    ergom%id_p_nh4_assim_spp = register_diag_field(package_name, vardesc_temp%name, axes(1:3),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    if (ergom%id_p_nh4_assim_spp .gt. 0) then
      allocate(ergom%p_nh4_assim_spp(isd:ied,jsd:jed,nk))
      ergom%p_nh4_assim_spp = 0.0
    endif
    vardesc_temp = vardesc("p_n2_assim_cya ","fixation of dinitrogen by diazotroph cyanobacteria",'h','1','s','mol kg-1 d-1','f')
    ergom%id_p_n2_assim_cya  = register_diag_field(package_name, vardesc_temp%name, axes(1:3),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    if (ergom%id_p_n2_assim_cya  .gt. 0) then
      allocate(ergom%p_n2_assim_cya (isd:ied,jsd:jed,nk))
      ergom%p_n2_assim_cya  = 0.0
    endif
    vardesc_temp = vardesc("p_assim_lpp_doc","Production of DOC by LPP",'h','1','s','mol kg-1 d-1','f')
    ergom%id_p_assim_lpp_doc = register_diag_field(package_name, vardesc_temp%name, axes(1:3),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    if (ergom%id_p_assim_lpp_doc .gt. 0) then
      allocate(ergom%p_assim_lpp_doc(isd:ied,jsd:jed,nk))
      ergom%p_assim_lpp_doc = 0.0
    endif
    vardesc_temp = vardesc("p_assim_spp_doc","Production of DOC by SPP",'h','1','s','mol kg-1 d-1','f')
    ergom%id_p_assim_spp_doc = register_diag_field(package_name, vardesc_temp%name, axes(1:3),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    if (ergom%id_p_assim_spp_doc .gt. 0) then
      allocate(ergom%p_assim_spp_doc(isd:ied,jsd:jed,nk))
      ergom%p_assim_spp_doc = 0.0
    endif
    vardesc_temp = vardesc("p_assim_cya_doc","Production of POC by CYA",'h','1','s','mol kg-1 d-1','f')
    ergom%id_p_assim_cya_doc = register_diag_field(package_name, vardesc_temp%name, axes(1:3),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    if (ergom%id_p_assim_cya_doc .gt. 0) then
      allocate(ergom%p_assim_cya_doc(isd:ied,jsd:jed,nk))
      ergom%p_assim_cya_doc = 0.0
    endif
    vardesc_temp = vardesc("p_assim_lpp_dop","Production of DOP by LPP",'h','1','s','mol kg-1 d-1','f')
    ergom%id_p_assim_lpp_dop = register_diag_field(package_name, vardesc_temp%name, axes(1:3),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    if (ergom%id_p_assim_lpp_dop .gt. 0) then
      allocate(ergom%p_assim_lpp_dop(isd:ied,jsd:jed,nk))
      ergom%p_assim_lpp_dop = 0.0
    endif
    vardesc_temp = vardesc("p_assim_spp_dop","Production of DOP by SPP",'h','1','s','mol kg-1 d-1','f')
    ergom%id_p_assim_spp_dop = register_diag_field(package_name, vardesc_temp%name, axes(1:3),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    if (ergom%id_p_assim_spp_dop .gt. 0) then
      allocate(ergom%p_assim_spp_dop(isd:ied,jsd:jed,nk))
      ergom%p_assim_spp_dop = 0.0
    endif
    vardesc_temp = vardesc("p_nh4_assim_lpp_don","Production of DON by LPP",'h','1','s','mol kg-1 d-1','f')
    ergom%id_p_nh4_assim_lpp_don = register_diag_field(package_name, vardesc_temp%name, axes(1:3),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    if (ergom%id_p_nh4_assim_lpp_don .gt. 0) then
      allocate(ergom%p_nh4_assim_lpp_don(isd:ied,jsd:jed,nk))
      ergom%p_nh4_assim_lpp_don = 0.0
    endif
    vardesc_temp = vardesc("p_no3_assim_lpp_don","Production of DON by LPP",'h','1','s','mol kg-1 d-1','f')
    ergom%id_p_no3_assim_lpp_don = register_diag_field(package_name, vardesc_temp%name, axes(1:3),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    if (ergom%id_p_no3_assim_lpp_don .gt. 0) then
      allocate(ergom%p_no3_assim_lpp_don(isd:ied,jsd:jed,nk))
      ergom%p_no3_assim_lpp_don = 0.0
    endif
    vardesc_temp = vardesc("p_nh4_assim_spp_don","Production of DON by SPP",'h','1','s','mol kg-1 d-1','f')
    ergom%id_p_nh4_assim_spp_don = register_diag_field(package_name, vardesc_temp%name, axes(1:3),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    if (ergom%id_p_nh4_assim_spp_don .gt. 0) then
      allocate(ergom%p_nh4_assim_spp_don(isd:ied,jsd:jed,nk))
      ergom%p_nh4_assim_spp_don = 0.0
    endif
    vardesc_temp = vardesc("p_no3_assim_spp_don","Production of DON by SPP",'h','1','s','mol kg-1 d-1','f')
    ergom%id_p_no3_assim_spp_don = register_diag_field(package_name, vardesc_temp%name, axes(1:3),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    if (ergom%id_p_no3_assim_spp_don .gt. 0) then
      allocate(ergom%p_no3_assim_spp_don(isd:ied,jsd:jed,nk))
      ergom%p_no3_assim_spp_don = 0.0
    endif
    vardesc_temp = vardesc("p_poc_resp     ","respiration of POC",'h','1','s','mol kg-1 d-1','f')
    ergom%id_p_poc_resp      = register_diag_field(package_name, vardesc_temp%name, axes(1:3),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    if (ergom%id_p_poc_resp      .gt. 0) then
      allocate(ergom%p_poc_resp     (isd:ied,jsd:jed,nk))
      ergom%p_poc_resp      = 0.0
    endif
    vardesc_temp = vardesc("p_poc_denit    ","recycling of POC using nitrate (denitrification)",'h','1','s','mol kg-1 d-1','f')
    ergom%id_p_poc_denit     = register_diag_field(package_name, vardesc_temp%name, axes(1:3),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    if (ergom%id_p_poc_denit     .gt. 0) then
      allocate(ergom%p_poc_denit    (isd:ied,jsd:jed,nk))
      ergom%p_poc_denit     = 0.0
    endif
    vardesc_temp = vardesc("p_poc_sulf     ","Mineralization of POC, e-acceptor sulfate (sulfate reduction)",'h','1','s','mol kg-1 d-1','f')
    ergom%id_p_poc_sulf      = register_diag_field(package_name, vardesc_temp%name, axes(1:3),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    if (ergom%id_p_poc_sulf      .gt. 0) then
      allocate(ergom%p_poc_sulf     (isd:ied,jsd:jed,nk))
      ergom%p_poc_sulf      = 0.0
    endif
    vardesc_temp = vardesc("p_pocp_resp    ","respiration of POCP",'h','1','s','mol kg-1 d-1','f')
    ergom%id_p_pocp_resp     = register_diag_field(package_name, vardesc_temp%name, axes(1:3),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    if (ergom%id_p_pocp_resp     .gt. 0) then
      allocate(ergom%p_pocp_resp    (isd:ied,jsd:jed,nk))
      ergom%p_pocp_resp     = 0.0
    endif
    vardesc_temp = vardesc("p_pocp_denit   ","recycling of POC using nitrate (denitrification)",'h','1','s','mol kg-1 d-1','f')
    ergom%id_p_pocp_denit    = register_diag_field(package_name, vardesc_temp%name, axes(1:3),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    if (ergom%id_p_pocp_denit    .gt. 0) then
      allocate(ergom%p_pocp_denit   (isd:ied,jsd:jed,nk))
      ergom%p_pocp_denit    = 0.0
    endif
    vardesc_temp = vardesc("p_pocp_sulf    ","Mineralization of POC, e-acceptor sulfate (sulfate reduction)",'h','1','s','mol kg-1 d-1','f')
    ergom%id_p_pocp_sulf     = register_diag_field(package_name, vardesc_temp%name, axes(1:3),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    if (ergom%id_p_pocp_sulf     .gt. 0) then
      allocate(ergom%p_pocp_sulf    (isd:ied,jsd:jed,nk))
      ergom%p_pocp_sulf     = 0.0
    endif
    vardesc_temp = vardesc("p_pocn_resp    ","respiration of POCN",'h','1','s','mol kg-1 d-1','f')
    ergom%id_p_pocn_resp     = register_diag_field(package_name, vardesc_temp%name, axes(1:3),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    if (ergom%id_p_pocn_resp     .gt. 0) then
      allocate(ergom%p_pocn_resp    (isd:ied,jsd:jed,nk))
      ergom%p_pocn_resp     = 0.0
    endif
    vardesc_temp = vardesc("p_pocn_denit_noN2","recycling of POCN using nitrate (denitrification)",'h','1','s','mol kg-1 d-1','f')
    ergom%id_p_pocn_denit_noN2 = register_diag_field(package_name, vardesc_temp%name, axes(1:3),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    if (ergom%id_p_pocn_denit_noN2 .gt. 0) then
      allocate(ergom%p_pocn_denit_noN2(isd:ied,jsd:jed,nk))
      ergom%p_pocn_denit_noN2 = 0.0
    endif
    vardesc_temp = vardesc("p_pocn_denit_wiN2","recycling of POCN using nitrate (denitrification)",'h','1','s','mol kg-1 d-1','f')
    ergom%id_p_pocn_denit_wiN2 = register_diag_field(package_name, vardesc_temp%name, axes(1:3),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    if (ergom%id_p_pocn_denit_wiN2 .gt. 0) then
      allocate(ergom%p_pocn_denit_wiN2(isd:ied,jsd:jed,nk))
      ergom%p_pocn_denit_wiN2 = 0.0
    endif
    vardesc_temp = vardesc("p_pocn_sulf    ","Mineralization of POCN, e-acceptor sulfate (sulfate reduction)",'h','1','s','mol kg-1 d-1','f')
    ergom%id_p_pocn_sulf     = register_diag_field(package_name, vardesc_temp%name, axes(1:3),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    if (ergom%id_p_pocn_sulf     .gt. 0) then
      allocate(ergom%p_pocn_sulf    (isd:ied,jsd:jed,nk))
      ergom%p_pocn_sulf     = 0.0
    endif
    vardesc_temp = vardesc("p_lpp_graz_zoo ","grazing of zooplankton eating large-cell phytoplankton",'h','1','s','mol kg-1 d-1','f')
    ergom%id_p_lpp_graz_zoo  = register_diag_field(package_name, vardesc_temp%name, axes(1:3),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    if (ergom%id_p_lpp_graz_zoo  .gt. 0) then
      allocate(ergom%p_lpp_graz_zoo (isd:ied,jsd:jed,nk))
      ergom%p_lpp_graz_zoo  = 0.0
    endif
    vardesc_temp = vardesc("p_spp_graz_zoo ","grazing of zooplankton eating small-cell phytoplankton",'h','1','s','mol kg-1 d-1','f')
    ergom%id_p_spp_graz_zoo  = register_diag_field(package_name, vardesc_temp%name, axes(1:3),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    if (ergom%id_p_spp_graz_zoo  .gt. 0) then
      allocate(ergom%p_spp_graz_zoo (isd:ied,jsd:jed,nk))
      ergom%p_spp_graz_zoo  = 0.0
    endif
    vardesc_temp = vardesc("p_cya_graz_zoo ","grazing of zooplankton eating diazotroph cyanobacteria",'h','1','s','mol kg-1 d-1','f')
    ergom%id_p_cya_graz_zoo  = register_diag_field(package_name, vardesc_temp%name, axes(1:3),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    if (ergom%id_p_cya_graz_zoo  .gt. 0) then
      allocate(ergom%p_cya_graz_zoo (isd:ied,jsd:jed,nk))
      ergom%p_cya_graz_zoo  = 0.0
    endif
    vardesc_temp = vardesc("p_lpp_resp_nh4 ","respiration of large-cell phytoplankton",'h','1','s','mol kg-1 d-1','f')
    ergom%id_p_lpp_resp_nh4  = register_diag_field(package_name, vardesc_temp%name, axes(1:3),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    if (ergom%id_p_lpp_resp_nh4  .gt. 0) then
      allocate(ergom%p_lpp_resp_nh4 (isd:ied,jsd:jed,nk))
      ergom%p_lpp_resp_nh4  = 0.0
    endif
    vardesc_temp = vardesc("p_spp_resp_nh4 ","respiration of small-cell phytoplankton",'h','1','s','mol kg-1 d-1','f')
    ergom%id_p_spp_resp_nh4  = register_diag_field(package_name, vardesc_temp%name, axes(1:3),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    if (ergom%id_p_spp_resp_nh4  .gt. 0) then
      allocate(ergom%p_spp_resp_nh4 (isd:ied,jsd:jed,nk))
      ergom%p_spp_resp_nh4  = 0.0
    endif
    vardesc_temp = vardesc("p_cya_resp_nh4 ","respiration of diazotroph cyanobacteria",'h','1','s','mol kg-1 d-1','f')
    ergom%id_p_cya_resp_nh4  = register_diag_field(package_name, vardesc_temp%name, axes(1:3),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    if (ergom%id_p_cya_resp_nh4  .gt. 0) then
      allocate(ergom%p_cya_resp_nh4 (isd:ied,jsd:jed,nk))
      ergom%p_cya_resp_nh4  = 0.0
    endif
    vardesc_temp = vardesc("p_zoo_resp_nh4 ","respiration of zooplankton",'h','1','s','mol kg-1 d-1','f')
    ergom%id_p_zoo_resp_nh4  = register_diag_field(package_name, vardesc_temp%name, axes(1:3),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    if (ergom%id_p_zoo_resp_nh4  .gt. 0) then
      allocate(ergom%p_zoo_resp_nh4 (isd:ied,jsd:jed,nk))
      ergom%p_zoo_resp_nh4  = 0.0
    endif
    vardesc_temp = vardesc("p_lpp_mort_det ","mortality of large-cell phytoplankton",'h','1','s','mol kg-1 d-1','f')
    ergom%id_p_lpp_mort_det  = register_diag_field(package_name, vardesc_temp%name, axes(1:3),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    if (ergom%id_p_lpp_mort_det  .gt. 0) then
      allocate(ergom%p_lpp_mort_det (isd:ied,jsd:jed,nk))
      ergom%p_lpp_mort_det  = 0.0
    endif
    vardesc_temp = vardesc("p_spp_mort_det ","mortality of small-scale phytoplankton",'h','1','s','mol kg-1 d-1','f')
    ergom%id_p_spp_mort_det  = register_diag_field(package_name, vardesc_temp%name, axes(1:3),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    if (ergom%id_p_spp_mort_det  .gt. 0) then
      allocate(ergom%p_spp_mort_det (isd:ied,jsd:jed,nk))
      ergom%p_spp_mort_det  = 0.0
    endif
    vardesc_temp = vardesc("p_cya_mort_det ","mortality of diazotroph cyanobacteria",'h','1','s','mol kg-1 d-1','f')
    ergom%id_p_cya_mort_det  = register_diag_field(package_name, vardesc_temp%name, axes(1:3),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    if (ergom%id_p_cya_mort_det  .gt. 0) then
      allocate(ergom%p_cya_mort_det (isd:ied,jsd:jed,nk))
      ergom%p_cya_mort_det  = 0.0
    endif
    vardesc_temp = vardesc("p_cya_mort_det_diff","mortality of diazotroph cyanobacteria due to strong turbulence",'h','1','s','mol kg-1 d-1','f')
    ergom%id_p_cya_mort_det_diff = register_diag_field(package_name, vardesc_temp%name, axes(1:3),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    if (ergom%id_p_cya_mort_det_diff .gt. 0) then
      allocate(ergom%p_cya_mort_det_diff(isd:ied,jsd:jed,nk))
      ergom%p_cya_mort_det_diff = 0.0
    endif
    vardesc_temp = vardesc("p_zoo_mort_det ","mortality of zooplankton",'h','1','s','mol kg-1 d-1','f')
    ergom%id_p_zoo_mort_det  = register_diag_field(package_name, vardesc_temp%name, axes(1:3),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    if (ergom%id_p_zoo_mort_det  .gt. 0) then
      allocate(ergom%p_zoo_mort_det (isd:ied,jsd:jed,nk))
      ergom%p_zoo_mort_det  = 0.0
    endif
    vardesc_temp = vardesc("p_nh4_nit_no3  ","nitrification",'h','1','s','mol kg-1 d-1','f')
    ergom%id_p_nh4_nit_no3   = register_diag_field(package_name, vardesc_temp%name, axes(1:3),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    if (ergom%id_p_nh4_nit_no3   .gt. 0) then
      allocate(ergom%p_nh4_nit_no3  (isd:ied,jsd:jed,nk))
      ergom%p_nh4_nit_no3   = 0.0
    endif
    vardesc_temp = vardesc("p_det_resp_nh4 ","recycling of detritus using oxygen (respiration)",'h','1','s','mol kg-1 d-1','f')
    ergom%id_p_det_resp_nh4  = register_diag_field(package_name, vardesc_temp%name, axes(1:3),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    if (ergom%id_p_det_resp_nh4  .gt. 0) then
      allocate(ergom%p_det_resp_nh4 (isd:ied,jsd:jed,nk))
      ergom%p_det_resp_nh4  = 0.0
    endif
    vardesc_temp = vardesc("p_det_denit_nh4","recycling of detritus using nitrate (denitrification)",'h','1','s','mol kg-1 d-1','f')
    ergom%id_p_det_denit_nh4 = register_diag_field(package_name, vardesc_temp%name, axes(1:3),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    if (ergom%id_p_det_denit_nh4 .gt. 0) then
      allocate(ergom%p_det_denit_nh4(isd:ied,jsd:jed,nk))
      ergom%p_det_denit_nh4 = 0.0
    endif
    vardesc_temp = vardesc("p_det_sulf_nh4 ","recycling of detritus using sulfate (sulfate reduction)",'h','1','s','mol kg-1 d-1','f')
    ergom%id_p_det_sulf_nh4  = register_diag_field(package_name, vardesc_temp%name, axes(1:3),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    if (ergom%id_p_det_sulf_nh4  .gt. 0) then
      allocate(ergom%p_det_sulf_nh4 (isd:ied,jsd:jed,nk))
      ergom%p_det_sulf_nh4  = 0.0
    endif
    vardesc_temp = vardesc("p_h2s_oxo2_sul ","oxidation of hydrogen sulfide with oxygen",'h','1','s','mol kg-1 d-1','f')
    ergom%id_p_h2s_oxo2_sul  = register_diag_field(package_name, vardesc_temp%name, axes(1:3),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    if (ergom%id_p_h2s_oxo2_sul  .gt. 0) then
      allocate(ergom%p_h2s_oxo2_sul (isd:ied,jsd:jed,nk))
      ergom%p_h2s_oxo2_sul  = 0.0
    endif
    vardesc_temp = vardesc("p_h2s_oxno3_sul","oxidation of hydrogen sulfide with nitrate",'h','1','s','mol kg-1 d-1','f')
    ergom%id_p_h2s_oxno3_sul = register_diag_field(package_name, vardesc_temp%name, axes(1:3),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    if (ergom%id_p_h2s_oxno3_sul .gt. 0) then
      allocate(ergom%p_h2s_oxno3_sul(isd:ied,jsd:jed,nk))
      ergom%p_h2s_oxno3_sul = 0.0
    endif
    vardesc_temp = vardesc("p_sul_oxo2_so4 ","oxidation of elemental sulfur with oxygen",'h','1','s','mol kg-1 d-1','f')
    ergom%id_p_sul_oxo2_so4  = register_diag_field(package_name, vardesc_temp%name, axes(1:3),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    if (ergom%id_p_sul_oxo2_so4  .gt. 0) then
      allocate(ergom%p_sul_oxo2_so4 (isd:ied,jsd:jed,nk))
      ergom%p_sul_oxo2_so4  = 0.0
    endif
    vardesc_temp = vardesc("p_sul_oxno3_so4","oxidation of elemental sulfur with nitrate",'h','1','s','mol kg-1 d-1','f')
    ergom%id_p_sul_oxno3_so4 = register_diag_field(package_name, vardesc_temp%name, axes(1:3),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    if (ergom%id_p_sul_oxno3_so4 .gt. 0) then
      allocate(ergom%p_sul_oxno3_so4(isd:ied,jsd:jed,nk))
      ergom%p_sul_oxno3_so4 = 0.0
    endif
    vardesc_temp = vardesc("p_doc2pco      ","particle formation from DOC",'h','1','s','mol kg-1 d-1','f')
    ergom%id_p_doc2pco       = register_diag_field(package_name, vardesc_temp%name, axes(1:3),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    if (ergom%id_p_doc2pco       .gt. 0) then
      allocate(ergom%p_doc2pco      (isd:ied,jsd:jed,nk))
      ergom%p_doc2pco       = 0.0
    endif
    vardesc_temp = vardesc("p_dop2pocp     ","particle formation from DOP",'h','1','s','mol kg-1 d-1','f')
    ergom%id_p_dop2pocp      = register_diag_field(package_name, vardesc_temp%name, axes(1:3),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    if (ergom%id_p_dop2pocp      .gt. 0) then
      allocate(ergom%p_dop2pocp     (isd:ied,jsd:jed,nk))
      ergom%p_dop2pocp      = 0.0
    endif
    vardesc_temp = vardesc("p_don2pocn     ","particle formation from DON",'h','1','s','mol kg-1 d-1','f')
    ergom%id_p_don2pocn      = register_diag_field(package_name, vardesc_temp%name, axes(1:3),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    if (ergom%id_p_don2pocn      .gt. 0) then
      allocate(ergom%p_don2pocn     (isd:ied,jsd:jed,nk))
      ergom%p_don2pocn      = 0.0
    endif
    vardesc_temp = vardesc("p_doc_resp     ","respiration of DOC",'h','1','s','mol kg-1 d-1','f')
    ergom%id_p_doc_resp      = register_diag_field(package_name, vardesc_temp%name, axes(1:3),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    if (ergom%id_p_doc_resp      .gt. 0) then
      allocate(ergom%p_doc_resp     (isd:ied,jsd:jed,nk))
      ergom%p_doc_resp      = 0.0
    endif
    vardesc_temp = vardesc("p_doc_denit    ","recycling of DOC using nitrate (denitrification)",'h','1','s','mol kg-1 d-1','f')
    ergom%id_p_doc_denit     = register_diag_field(package_name, vardesc_temp%name, axes(1:3),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    if (ergom%id_p_doc_denit     .gt. 0) then
      allocate(ergom%p_doc_denit    (isd:ied,jsd:jed,nk))
      ergom%p_doc_denit     = 0.0
    endif
    vardesc_temp = vardesc("p_doc_sulf     ","Mineralization of DOC, e-acceptor sulfate (sulfate reduction)",'h','1','s','mol kg-1 d-1','f')
    ergom%id_p_doc_sulf      = register_diag_field(package_name, vardesc_temp%name, axes(1:3),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    if (ergom%id_p_doc_sulf      .gt. 0) then
      allocate(ergom%p_doc_sulf     (isd:ied,jsd:jed,nk))
      ergom%p_doc_sulf      = 0.0
    endif
    vardesc_temp = vardesc("p_dop_resp     ","respiration of DOP",'h','1','s','mol kg-1 d-1','f')
    ergom%id_p_dop_resp      = register_diag_field(package_name, vardesc_temp%name, axes(1:3),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    if (ergom%id_p_dop_resp      .gt. 0) then
      allocate(ergom%p_dop_resp     (isd:ied,jsd:jed,nk))
      ergom%p_dop_resp      = 0.0
    endif
    vardesc_temp = vardesc("p_dop_denit    ","recycling of DOP using nitrate (denitrification)",'h','1','s','mol kg-1 d-1','f')
    ergom%id_p_dop_denit     = register_diag_field(package_name, vardesc_temp%name, axes(1:3),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    if (ergom%id_p_dop_denit     .gt. 0) then
      allocate(ergom%p_dop_denit    (isd:ied,jsd:jed,nk))
      ergom%p_dop_denit     = 0.0
    endif
    vardesc_temp = vardesc("p_dop_sulf     ","Mineralization of DOP, e-acceptor sulfate (sulfate reduction)",'h','1','s','mol kg-1 d-1','f')
    ergom%id_p_dop_sulf      = register_diag_field(package_name, vardesc_temp%name, axes(1:3),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    if (ergom%id_p_dop_sulf      .gt. 0) then
      allocate(ergom%p_dop_sulf     (isd:ied,jsd:jed,nk))
      ergom%p_dop_sulf      = 0.0
    endif
    vardesc_temp = vardesc("p_don_resp     ","respiration of DON",'h','1','s','mol kg-1 d-1','f')
    ergom%id_p_don_resp      = register_diag_field(package_name, vardesc_temp%name, axes(1:3),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    if (ergom%id_p_don_resp      .gt. 0) then
      allocate(ergom%p_don_resp     (isd:ied,jsd:jed,nk))
      ergom%p_don_resp      = 0.0
    endif
    vardesc_temp = vardesc("p_don_denit_noN2","recycling of DON using nitrate (denitrification)",'h','1','s','mol kg-1 d-1','f')
    ergom%id_p_don_denit_noN2 = register_diag_field(package_name, vardesc_temp%name, axes(1:3),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    if (ergom%id_p_don_denit_noN2 .gt. 0) then
      allocate(ergom%p_don_denit_noN2(isd:ied,jsd:jed,nk))
      ergom%p_don_denit_noN2 = 0.0
    endif
    vardesc_temp = vardesc("p_don_denit_wiN2","recycling of DON using nitrate (denitrification)",'h','1','s','mol kg-1 d-1','f')
    ergom%id_p_don_denit_wiN2 = register_diag_field(package_name, vardesc_temp%name, axes(1:3),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    if (ergom%id_p_don_denit_wiN2 .gt. 0) then
      allocate(ergom%p_don_denit_wiN2(isd:ied,jsd:jed,nk))
      ergom%p_don_denit_wiN2 = 0.0
    endif
    vardesc_temp = vardesc("p_don_sulf     ","Mineralization of DON, e-acceptor sulfate (sulfate reduction)",'h','1','s','mol kg-1 d-1','f')
    ergom%id_p_don_sulf      = register_diag_field(package_name, vardesc_temp%name, axes(1:3),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    if (ergom%id_p_don_sulf      .gt. 0) then
      allocate(ergom%p_don_sulf     (isd:ied,jsd:jed,nk))
      ergom%p_don_sulf      = 0.0
    endif
    vardesc_temp = vardesc("p_no3_assim_lpp_atmos_tot_N","assimilation of nitrate by large-cell phytoplankton; sub-process for atmos_tot nitrogen",'h','1','s','mol kg-1 d-1','f')
    ergom%id_p_no3_assim_lpp_atmos_tot_N = register_diag_field(package_name, vardesc_temp%name, axes(1:3),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    if (ergom%id_p_no3_assim_lpp_atmos_tot_N .gt. 0) then
      allocate(ergom%p_no3_assim_lpp_atmos_tot_N(isd:ied,jsd:jed,nk))
      ergom%p_no3_assim_lpp_atmos_tot_N = 0.0
    endif
    vardesc_temp = vardesc("p_nh4_assim_lpp_atmos_tot_N","assimilation of ammonium by large-cell phytoplankton; sub-process for atmos_tot nitrogen",'h','1','s','mol kg-1 d-1','f')
    ergom%id_p_nh4_assim_lpp_atmos_tot_N = register_diag_field(package_name, vardesc_temp%name, axes(1:3),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    if (ergom%id_p_nh4_assim_lpp_atmos_tot_N .gt. 0) then
      allocate(ergom%p_nh4_assim_lpp_atmos_tot_N(isd:ied,jsd:jed,nk))
      ergom%p_nh4_assim_lpp_atmos_tot_N = 0.0
    endif
    vardesc_temp = vardesc("p_no3_assim_spp_atmos_tot_N","assimilation of nitrate by small-cell phytoplankton; sub-process for atmos_tot nitrogen",'h','1','s','mol kg-1 d-1','f')
    ergom%id_p_no3_assim_spp_atmos_tot_N = register_diag_field(package_name, vardesc_temp%name, axes(1:3),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    if (ergom%id_p_no3_assim_spp_atmos_tot_N .gt. 0) then
      allocate(ergom%p_no3_assim_spp_atmos_tot_N(isd:ied,jsd:jed,nk))
      ergom%p_no3_assim_spp_atmos_tot_N = 0.0
    endif
    vardesc_temp = vardesc("p_nh4_assim_spp_atmos_tot_N","assimilation of ammonium by small-cell phytoplankton; sub-process for atmos_tot nitrogen",'h','1','s','mol kg-1 d-1','f')
    ergom%id_p_nh4_assim_spp_atmos_tot_N = register_diag_field(package_name, vardesc_temp%name, axes(1:3),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    if (ergom%id_p_nh4_assim_spp_atmos_tot_N .gt. 0) then
      allocate(ergom%p_nh4_assim_spp_atmos_tot_N(isd:ied,jsd:jed,nk))
      ergom%p_nh4_assim_spp_atmos_tot_N = 0.0
    endif
    vardesc_temp = vardesc("p_nh4_assim_lpp_don_atmos_tot_N","Production of DON by LPP; sub-process for atmos_tot nitrogen",'h','1','s','mol kg-1 d-1','f')
    ergom%id_p_nh4_assim_lpp_don_atmos_tot_N = register_diag_field(package_name, vardesc_temp%name, axes(1:3),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    if (ergom%id_p_nh4_assim_lpp_don_atmos_tot_N .gt. 0) then
      allocate(ergom%p_nh4_assim_lpp_don_atmos_tot_N(isd:ied,jsd:jed,nk))
      ergom%p_nh4_assim_lpp_don_atmos_tot_N = 0.0
    endif
    vardesc_temp = vardesc("p_no3_assim_lpp_don_atmos_tot_N","Production of DON by LPP; sub-process for atmos_tot nitrogen",'h','1','s','mol kg-1 d-1','f')
    ergom%id_p_no3_assim_lpp_don_atmos_tot_N = register_diag_field(package_name, vardesc_temp%name, axes(1:3),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    if (ergom%id_p_no3_assim_lpp_don_atmos_tot_N .gt. 0) then
      allocate(ergom%p_no3_assim_lpp_don_atmos_tot_N(isd:ied,jsd:jed,nk))
      ergom%p_no3_assim_lpp_don_atmos_tot_N = 0.0
    endif
    vardesc_temp = vardesc("p_nh4_assim_spp_don_atmos_tot_N","Production of DON by SPP; sub-process for atmos_tot nitrogen",'h','1','s','mol kg-1 d-1','f')
    ergom%id_p_nh4_assim_spp_don_atmos_tot_N = register_diag_field(package_name, vardesc_temp%name, axes(1:3),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    if (ergom%id_p_nh4_assim_spp_don_atmos_tot_N .gt. 0) then
      allocate(ergom%p_nh4_assim_spp_don_atmos_tot_N(isd:ied,jsd:jed,nk))
      ergom%p_nh4_assim_spp_don_atmos_tot_N = 0.0
    endif
    vardesc_temp = vardesc("p_no3_assim_spp_don_atmos_tot_N","Production of DON by SPP; sub-process for atmos_tot nitrogen",'h','1','s','mol kg-1 d-1','f')
    ergom%id_p_no3_assim_spp_don_atmos_tot_N = register_diag_field(package_name, vardesc_temp%name, axes(1:3),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    if (ergom%id_p_no3_assim_spp_don_atmos_tot_N .gt. 0) then
      allocate(ergom%p_no3_assim_spp_don_atmos_tot_N(isd:ied,jsd:jed,nk))
      ergom%p_no3_assim_spp_don_atmos_tot_N = 0.0
    endif
    vardesc_temp = vardesc("p_pocn_resp_atmos_tot_N","respiration of POCN; sub-process for atmos_tot nitrogen",'h','1','s','mol kg-1 d-1','f')
    ergom%id_p_pocn_resp_atmos_tot_N = register_diag_field(package_name, vardesc_temp%name, axes(1:3),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    if (ergom%id_p_pocn_resp_atmos_tot_N .gt. 0) then
      allocate(ergom%p_pocn_resp_atmos_tot_N(isd:ied,jsd:jed,nk))
      ergom%p_pocn_resp_atmos_tot_N = 0.0
    endif
    vardesc_temp = vardesc("p_pocn_denit_noN2_atmos_tot_N","recycling of POCN using nitrate (denitrification); sub-process for atmos_tot nitrogen",'h','1','s','mol kg-1 d-1','f')
    ergom%id_p_pocn_denit_noN2_atmos_tot_N = register_diag_field(package_name, vardesc_temp%name, axes(1:3),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    if (ergom%id_p_pocn_denit_noN2_atmos_tot_N .gt. 0) then
      allocate(ergom%p_pocn_denit_noN2_atmos_tot_N(isd:ied,jsd:jed,nk))
      ergom%p_pocn_denit_noN2_atmos_tot_N = 0.0
    endif
    vardesc_temp = vardesc("p_pocn_sulf_atmos_tot_N","Mineralization of POCN, e-acceptor sulfate (sulfate reduction); sub-process for atmos_tot nitrogen",'h','1','s','mol kg-1 d-1','f')
    ergom%id_p_pocn_sulf_atmos_tot_N = register_diag_field(package_name, vardesc_temp%name, axes(1:3),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    if (ergom%id_p_pocn_sulf_atmos_tot_N .gt. 0) then
      allocate(ergom%p_pocn_sulf_atmos_tot_N(isd:ied,jsd:jed,nk))
      ergom%p_pocn_sulf_atmos_tot_N = 0.0
    endif
    vardesc_temp = vardesc("p_lpp_graz_zoo_atmos_tot_N","grazing of zooplankton eating large-cell phytoplankton; sub-process for atmos_tot nitrogen",'h','1','s','mol kg-1 d-1','f')
    ergom%id_p_lpp_graz_zoo_atmos_tot_N = register_diag_field(package_name, vardesc_temp%name, axes(1:3),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    if (ergom%id_p_lpp_graz_zoo_atmos_tot_N .gt. 0) then
      allocate(ergom%p_lpp_graz_zoo_atmos_tot_N(isd:ied,jsd:jed,nk))
      ergom%p_lpp_graz_zoo_atmos_tot_N = 0.0
    endif
    vardesc_temp = vardesc("p_spp_graz_zoo_atmos_tot_N","grazing of zooplankton eating small-cell phytoplankton; sub-process for atmos_tot nitrogen",'h','1','s','mol kg-1 d-1','f')
    ergom%id_p_spp_graz_zoo_atmos_tot_N = register_diag_field(package_name, vardesc_temp%name, axes(1:3),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    if (ergom%id_p_spp_graz_zoo_atmos_tot_N .gt. 0) then
      allocate(ergom%p_spp_graz_zoo_atmos_tot_N(isd:ied,jsd:jed,nk))
      ergom%p_spp_graz_zoo_atmos_tot_N = 0.0
    endif
    vardesc_temp = vardesc("p_cya_graz_zoo_atmos_tot_N","grazing of zooplankton eating diazotroph cyanobacteria; sub-process for atmos_tot nitrogen",'h','1','s','mol kg-1 d-1','f')
    ergom%id_p_cya_graz_zoo_atmos_tot_N = register_diag_field(package_name, vardesc_temp%name, axes(1:3),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    if (ergom%id_p_cya_graz_zoo_atmos_tot_N .gt. 0) then
      allocate(ergom%p_cya_graz_zoo_atmos_tot_N(isd:ied,jsd:jed,nk))
      ergom%p_cya_graz_zoo_atmos_tot_N = 0.0
    endif
    vardesc_temp = vardesc("p_lpp_resp_nh4_atmos_tot_N","respiration of large-cell phytoplankton; sub-process for atmos_tot nitrogen",'h','1','s','mol kg-1 d-1','f')
    ergom%id_p_lpp_resp_nh4_atmos_tot_N = register_diag_field(package_name, vardesc_temp%name, axes(1:3),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    if (ergom%id_p_lpp_resp_nh4_atmos_tot_N .gt. 0) then
      allocate(ergom%p_lpp_resp_nh4_atmos_tot_N(isd:ied,jsd:jed,nk))
      ergom%p_lpp_resp_nh4_atmos_tot_N = 0.0
    endif
    vardesc_temp = vardesc("p_spp_resp_nh4_atmos_tot_N","respiration of small-cell phytoplankton; sub-process for atmos_tot nitrogen",'h','1','s','mol kg-1 d-1','f')
    ergom%id_p_spp_resp_nh4_atmos_tot_N = register_diag_field(package_name, vardesc_temp%name, axes(1:3),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    if (ergom%id_p_spp_resp_nh4_atmos_tot_N .gt. 0) then
      allocate(ergom%p_spp_resp_nh4_atmos_tot_N(isd:ied,jsd:jed,nk))
      ergom%p_spp_resp_nh4_atmos_tot_N = 0.0
    endif
    vardesc_temp = vardesc("p_cya_resp_nh4_atmos_tot_N","respiration of diazotroph cyanobacteria; sub-process for atmos_tot nitrogen",'h','1','s','mol kg-1 d-1','f')
    ergom%id_p_cya_resp_nh4_atmos_tot_N = register_diag_field(package_name, vardesc_temp%name, axes(1:3),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    if (ergom%id_p_cya_resp_nh4_atmos_tot_N .gt. 0) then
      allocate(ergom%p_cya_resp_nh4_atmos_tot_N(isd:ied,jsd:jed,nk))
      ergom%p_cya_resp_nh4_atmos_tot_N = 0.0
    endif
    vardesc_temp = vardesc("p_zoo_resp_nh4_atmos_tot_N","respiration of zooplankton; sub-process for atmos_tot nitrogen",'h','1','s','mol kg-1 d-1','f')
    ergom%id_p_zoo_resp_nh4_atmos_tot_N = register_diag_field(package_name, vardesc_temp%name, axes(1:3),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    if (ergom%id_p_zoo_resp_nh4_atmos_tot_N .gt. 0) then
      allocate(ergom%p_zoo_resp_nh4_atmos_tot_N(isd:ied,jsd:jed,nk))
      ergom%p_zoo_resp_nh4_atmos_tot_N = 0.0
    endif
    vardesc_temp = vardesc("p_lpp_mort_det_atmos_tot_N","mortality of large-cell phytoplankton; sub-process for atmos_tot nitrogen",'h','1','s','mol kg-1 d-1','f')
    ergom%id_p_lpp_mort_det_atmos_tot_N = register_diag_field(package_name, vardesc_temp%name, axes(1:3),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    if (ergom%id_p_lpp_mort_det_atmos_tot_N .gt. 0) then
      allocate(ergom%p_lpp_mort_det_atmos_tot_N(isd:ied,jsd:jed,nk))
      ergom%p_lpp_mort_det_atmos_tot_N = 0.0
    endif
    vardesc_temp = vardesc("p_spp_mort_det_atmos_tot_N","mortality of small-scale phytoplankton; sub-process for atmos_tot nitrogen",'h','1','s','mol kg-1 d-1','f')
    ergom%id_p_spp_mort_det_atmos_tot_N = register_diag_field(package_name, vardesc_temp%name, axes(1:3),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    if (ergom%id_p_spp_mort_det_atmos_tot_N .gt. 0) then
      allocate(ergom%p_spp_mort_det_atmos_tot_N(isd:ied,jsd:jed,nk))
      ergom%p_spp_mort_det_atmos_tot_N = 0.0
    endif
    vardesc_temp = vardesc("p_cya_mort_det_atmos_tot_N","mortality of diazotroph cyanobacteria; sub-process for atmos_tot nitrogen",'h','1','s','mol kg-1 d-1','f')
    ergom%id_p_cya_mort_det_atmos_tot_N = register_diag_field(package_name, vardesc_temp%name, axes(1:3),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    if (ergom%id_p_cya_mort_det_atmos_tot_N .gt. 0) then
      allocate(ergom%p_cya_mort_det_atmos_tot_N(isd:ied,jsd:jed,nk))
      ergom%p_cya_mort_det_atmos_tot_N = 0.0
    endif
    vardesc_temp = vardesc("p_cya_mort_det_diff_atmos_tot_N","mortality of diazotroph cyanobacteria due to strong turbulence; sub-process for atmos_tot nitrogen",'h','1','s','mol kg-1 d-1','f')
    ergom%id_p_cya_mort_det_diff_atmos_tot_N = register_diag_field(package_name, vardesc_temp%name, axes(1:3),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    if (ergom%id_p_cya_mort_det_diff_atmos_tot_N .gt. 0) then
      allocate(ergom%p_cya_mort_det_diff_atmos_tot_N(isd:ied,jsd:jed,nk))
      ergom%p_cya_mort_det_diff_atmos_tot_N = 0.0
    endif
    vardesc_temp = vardesc("p_zoo_mort_det_atmos_tot_N","mortality of zooplankton; sub-process for atmos_tot nitrogen",'h','1','s','mol kg-1 d-1','f')
    ergom%id_p_zoo_mort_det_atmos_tot_N = register_diag_field(package_name, vardesc_temp%name, axes(1:3),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    if (ergom%id_p_zoo_mort_det_atmos_tot_N .gt. 0) then
      allocate(ergom%p_zoo_mort_det_atmos_tot_N(isd:ied,jsd:jed,nk))
      ergom%p_zoo_mort_det_atmos_tot_N = 0.0
    endif
    vardesc_temp = vardesc("p_nh4_nit_no3_atmos_tot_N","nitrification; sub-process for atmos_tot nitrogen",'h','1','s','mol kg-1 d-1','f')
    ergom%id_p_nh4_nit_no3_atmos_tot_N = register_diag_field(package_name, vardesc_temp%name, axes(1:3),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    if (ergom%id_p_nh4_nit_no3_atmos_tot_N .gt. 0) then
      allocate(ergom%p_nh4_nit_no3_atmos_tot_N(isd:ied,jsd:jed,nk))
      ergom%p_nh4_nit_no3_atmos_tot_N = 0.0
    endif
    vardesc_temp = vardesc("p_det_resp_nh4_atmos_tot_N","recycling of detritus using oxygen (respiration); sub-process for atmos_tot nitrogen",'h','1','s','mol kg-1 d-1','f')
    ergom%id_p_det_resp_nh4_atmos_tot_N = register_diag_field(package_name, vardesc_temp%name, axes(1:3),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    if (ergom%id_p_det_resp_nh4_atmos_tot_N .gt. 0) then
      allocate(ergom%p_det_resp_nh4_atmos_tot_N(isd:ied,jsd:jed,nk))
      ergom%p_det_resp_nh4_atmos_tot_N = 0.0
    endif
    vardesc_temp = vardesc("p_det_sulf_nh4_atmos_tot_N","recycling of detritus using sulfate (sulfate reduction); sub-process for atmos_tot nitrogen",'h','1','s','mol kg-1 d-1','f')
    ergom%id_p_det_sulf_nh4_atmos_tot_N = register_diag_field(package_name, vardesc_temp%name, axes(1:3),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    if (ergom%id_p_det_sulf_nh4_atmos_tot_N .gt. 0) then
      allocate(ergom%p_det_sulf_nh4_atmos_tot_N(isd:ied,jsd:jed,nk))
      ergom%p_det_sulf_nh4_atmos_tot_N = 0.0
    endif
    vardesc_temp = vardesc("p_don2pocn_atmos_tot_N","particle formation from DON; sub-process for atmos_tot nitrogen",'h','1','s','mol kg-1 d-1','f')
    ergom%id_p_don2pocn_atmos_tot_N = register_diag_field(package_name, vardesc_temp%name, axes(1:3),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    if (ergom%id_p_don2pocn_atmos_tot_N .gt. 0) then
      allocate(ergom%p_don2pocn_atmos_tot_N(isd:ied,jsd:jed,nk))
      ergom%p_don2pocn_atmos_tot_N = 0.0
    endif
    vardesc_temp = vardesc("p_don_resp_atmos_tot_N","respiration of DON; sub-process for atmos_tot nitrogen",'h','1','s','mol kg-1 d-1','f')
    ergom%id_p_don_resp_atmos_tot_N = register_diag_field(package_name, vardesc_temp%name, axes(1:3),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    if (ergom%id_p_don_resp_atmos_tot_N .gt. 0) then
      allocate(ergom%p_don_resp_atmos_tot_N(isd:ied,jsd:jed,nk))
      ergom%p_don_resp_atmos_tot_N = 0.0
    endif
    vardesc_temp = vardesc("p_don_denit_noN2_atmos_tot_N","recycling of DON using nitrate (denitrification); sub-process for atmos_tot nitrogen",'h','1','s','mol kg-1 d-1','f')
    ergom%id_p_don_denit_noN2_atmos_tot_N = register_diag_field(package_name, vardesc_temp%name, axes(1:3),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    if (ergom%id_p_don_denit_noN2_atmos_tot_N .gt. 0) then
      allocate(ergom%p_don_denit_noN2_atmos_tot_N(isd:ied,jsd:jed,nk))
      ergom%p_don_denit_noN2_atmos_tot_N = 0.0
    endif
    vardesc_temp = vardesc("p_don_sulf_atmos_tot_N","Mineralization of DON, e-acceptor sulfate (sulfate reduction); sub-process for atmos_tot nitrogen",'h','1','s','mol kg-1 d-1','f')
    ergom%id_p_don_sulf_atmos_tot_N = register_diag_field(package_name, vardesc_temp%name, axes(1:3),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    if (ergom%id_p_don_sulf_atmos_tot_N .gt. 0) then
      allocate(ergom%p_don_sulf_atmos_tot_N(isd:ied,jsd:jed,nk))
      ergom%p_don_sulf_atmos_tot_N = 0.0
    endif
    vardesc_temp = vardesc("p_no3_assim_lpp_atmos_ship_N","assimilation of nitrate by large-cell phytoplankton; sub-process for atmos_ship nitrogen",'h','1','s','mol kg-1 d-1','f')
    ergom%id_p_no3_assim_lpp_atmos_ship_N = register_diag_field(package_name, vardesc_temp%name, axes(1:3),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    if (ergom%id_p_no3_assim_lpp_atmos_ship_N .gt. 0) then
      allocate(ergom%p_no3_assim_lpp_atmos_ship_N(isd:ied,jsd:jed,nk))
      ergom%p_no3_assim_lpp_atmos_ship_N = 0.0
    endif
    vardesc_temp = vardesc("p_nh4_assim_lpp_atmos_ship_N","assimilation of ammonium by large-cell phytoplankton; sub-process for atmos_ship nitrogen",'h','1','s','mol kg-1 d-1','f')
    ergom%id_p_nh4_assim_lpp_atmos_ship_N = register_diag_field(package_name, vardesc_temp%name, axes(1:3),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    if (ergom%id_p_nh4_assim_lpp_atmos_ship_N .gt. 0) then
      allocate(ergom%p_nh4_assim_lpp_atmos_ship_N(isd:ied,jsd:jed,nk))
      ergom%p_nh4_assim_lpp_atmos_ship_N = 0.0
    endif
    vardesc_temp = vardesc("p_no3_assim_spp_atmos_ship_N","assimilation of nitrate by small-cell phytoplankton; sub-process for atmos_ship nitrogen",'h','1','s','mol kg-1 d-1','f')
    ergom%id_p_no3_assim_spp_atmos_ship_N = register_diag_field(package_name, vardesc_temp%name, axes(1:3),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    if (ergom%id_p_no3_assim_spp_atmos_ship_N .gt. 0) then
      allocate(ergom%p_no3_assim_spp_atmos_ship_N(isd:ied,jsd:jed,nk))
      ergom%p_no3_assim_spp_atmos_ship_N = 0.0
    endif
    vardesc_temp = vardesc("p_nh4_assim_spp_atmos_ship_N","assimilation of ammonium by small-cell phytoplankton; sub-process for atmos_ship nitrogen",'h','1','s','mol kg-1 d-1','f')
    ergom%id_p_nh4_assim_spp_atmos_ship_N = register_diag_field(package_name, vardesc_temp%name, axes(1:3),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    if (ergom%id_p_nh4_assim_spp_atmos_ship_N .gt. 0) then
      allocate(ergom%p_nh4_assim_spp_atmos_ship_N(isd:ied,jsd:jed,nk))
      ergom%p_nh4_assim_spp_atmos_ship_N = 0.0
    endif
    vardesc_temp = vardesc("p_nh4_assim_lpp_don_atmos_ship_N","Production of DON by LPP; sub-process for atmos_ship nitrogen",'h','1','s','mol kg-1 d-1','f')
    ergom%id_p_nh4_assim_lpp_don_atmos_ship_N = register_diag_field(package_name, vardesc_temp%name, axes(1:3),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    if (ergom%id_p_nh4_assim_lpp_don_atmos_ship_N .gt. 0) then
      allocate(ergom%p_nh4_assim_lpp_don_atmos_ship_N(isd:ied,jsd:jed,nk))
      ergom%p_nh4_assim_lpp_don_atmos_ship_N = 0.0
    endif
    vardesc_temp = vardesc("p_no3_assim_lpp_don_atmos_ship_N","Production of DON by LPP; sub-process for atmos_ship nitrogen",'h','1','s','mol kg-1 d-1','f')
    ergom%id_p_no3_assim_lpp_don_atmos_ship_N = register_diag_field(package_name, vardesc_temp%name, axes(1:3),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    if (ergom%id_p_no3_assim_lpp_don_atmos_ship_N .gt. 0) then
      allocate(ergom%p_no3_assim_lpp_don_atmos_ship_N(isd:ied,jsd:jed,nk))
      ergom%p_no3_assim_lpp_don_atmos_ship_N = 0.0
    endif
    vardesc_temp = vardesc("p_nh4_assim_spp_don_atmos_ship_N","Production of DON by SPP; sub-process for atmos_ship nitrogen",'h','1','s','mol kg-1 d-1','f')
    ergom%id_p_nh4_assim_spp_don_atmos_ship_N = register_diag_field(package_name, vardesc_temp%name, axes(1:3),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    if (ergom%id_p_nh4_assim_spp_don_atmos_ship_N .gt. 0) then
      allocate(ergom%p_nh4_assim_spp_don_atmos_ship_N(isd:ied,jsd:jed,nk))
      ergom%p_nh4_assim_spp_don_atmos_ship_N = 0.0
    endif
    vardesc_temp = vardesc("p_no3_assim_spp_don_atmos_ship_N","Production of DON by SPP; sub-process for atmos_ship nitrogen",'h','1','s','mol kg-1 d-1','f')
    ergom%id_p_no3_assim_spp_don_atmos_ship_N = register_diag_field(package_name, vardesc_temp%name, axes(1:3),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    if (ergom%id_p_no3_assim_spp_don_atmos_ship_N .gt. 0) then
      allocate(ergom%p_no3_assim_spp_don_atmos_ship_N(isd:ied,jsd:jed,nk))
      ergom%p_no3_assim_spp_don_atmos_ship_N = 0.0
    endif
    vardesc_temp = vardesc("p_pocn_resp_atmos_ship_N","respiration of POCN; sub-process for atmos_ship nitrogen",'h','1','s','mol kg-1 d-1','f')
    ergom%id_p_pocn_resp_atmos_ship_N = register_diag_field(package_name, vardesc_temp%name, axes(1:3),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    if (ergom%id_p_pocn_resp_atmos_ship_N .gt. 0) then
      allocate(ergom%p_pocn_resp_atmos_ship_N(isd:ied,jsd:jed,nk))
      ergom%p_pocn_resp_atmos_ship_N = 0.0
    endif
    vardesc_temp = vardesc("p_pocn_denit_noN2_atmos_ship_N","recycling of POCN using nitrate (denitrification); sub-process for atmos_ship nitrogen",'h','1','s','mol kg-1 d-1','f')
    ergom%id_p_pocn_denit_noN2_atmos_ship_N = register_diag_field(package_name, vardesc_temp%name, axes(1:3),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    if (ergom%id_p_pocn_denit_noN2_atmos_ship_N .gt. 0) then
      allocate(ergom%p_pocn_denit_noN2_atmos_ship_N(isd:ied,jsd:jed,nk))
      ergom%p_pocn_denit_noN2_atmos_ship_N = 0.0
    endif
    vardesc_temp = vardesc("p_pocn_sulf_atmos_ship_N","Mineralization of POCN, e-acceptor sulfate (sulfate reduction); sub-process for atmos_ship nitrogen",'h','1','s','mol kg-1 d-1','f')
    ergom%id_p_pocn_sulf_atmos_ship_N = register_diag_field(package_name, vardesc_temp%name, axes(1:3),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    if (ergom%id_p_pocn_sulf_atmos_ship_N .gt. 0) then
      allocate(ergom%p_pocn_sulf_atmos_ship_N(isd:ied,jsd:jed,nk))
      ergom%p_pocn_sulf_atmos_ship_N = 0.0
    endif
    vardesc_temp = vardesc("p_lpp_graz_zoo_atmos_ship_N","grazing of zooplankton eating large-cell phytoplankton; sub-process for atmos_ship nitrogen",'h','1','s','mol kg-1 d-1','f')
    ergom%id_p_lpp_graz_zoo_atmos_ship_N = register_diag_field(package_name, vardesc_temp%name, axes(1:3),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    if (ergom%id_p_lpp_graz_zoo_atmos_ship_N .gt. 0) then
      allocate(ergom%p_lpp_graz_zoo_atmos_ship_N(isd:ied,jsd:jed,nk))
      ergom%p_lpp_graz_zoo_atmos_ship_N = 0.0
    endif
    vardesc_temp = vardesc("p_spp_graz_zoo_atmos_ship_N","grazing of zooplankton eating small-cell phytoplankton; sub-process for atmos_ship nitrogen",'h','1','s','mol kg-1 d-1','f')
    ergom%id_p_spp_graz_zoo_atmos_ship_N = register_diag_field(package_name, vardesc_temp%name, axes(1:3),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    if (ergom%id_p_spp_graz_zoo_atmos_ship_N .gt. 0) then
      allocate(ergom%p_spp_graz_zoo_atmos_ship_N(isd:ied,jsd:jed,nk))
      ergom%p_spp_graz_zoo_atmos_ship_N = 0.0
    endif
    vardesc_temp = vardesc("p_cya_graz_zoo_atmos_ship_N","grazing of zooplankton eating diazotroph cyanobacteria; sub-process for atmos_ship nitrogen",'h','1','s','mol kg-1 d-1','f')
    ergom%id_p_cya_graz_zoo_atmos_ship_N = register_diag_field(package_name, vardesc_temp%name, axes(1:3),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    if (ergom%id_p_cya_graz_zoo_atmos_ship_N .gt. 0) then
      allocate(ergom%p_cya_graz_zoo_atmos_ship_N(isd:ied,jsd:jed,nk))
      ergom%p_cya_graz_zoo_atmos_ship_N = 0.0
    endif
    vardesc_temp = vardesc("p_lpp_resp_nh4_atmos_ship_N","respiration of large-cell phytoplankton; sub-process for atmos_ship nitrogen",'h','1','s','mol kg-1 d-1','f')
    ergom%id_p_lpp_resp_nh4_atmos_ship_N = register_diag_field(package_name, vardesc_temp%name, axes(1:3),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    if (ergom%id_p_lpp_resp_nh4_atmos_ship_N .gt. 0) then
      allocate(ergom%p_lpp_resp_nh4_atmos_ship_N(isd:ied,jsd:jed,nk))
      ergom%p_lpp_resp_nh4_atmos_ship_N = 0.0
    endif
    vardesc_temp = vardesc("p_spp_resp_nh4_atmos_ship_N","respiration of small-cell phytoplankton; sub-process for atmos_ship nitrogen",'h','1','s','mol kg-1 d-1','f')
    ergom%id_p_spp_resp_nh4_atmos_ship_N = register_diag_field(package_name, vardesc_temp%name, axes(1:3),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    if (ergom%id_p_spp_resp_nh4_atmos_ship_N .gt. 0) then
      allocate(ergom%p_spp_resp_nh4_atmos_ship_N(isd:ied,jsd:jed,nk))
      ergom%p_spp_resp_nh4_atmos_ship_N = 0.0
    endif
    vardesc_temp = vardesc("p_cya_resp_nh4_atmos_ship_N","respiration of diazotroph cyanobacteria; sub-process for atmos_ship nitrogen",'h','1','s','mol kg-1 d-1','f')
    ergom%id_p_cya_resp_nh4_atmos_ship_N = register_diag_field(package_name, vardesc_temp%name, axes(1:3),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    if (ergom%id_p_cya_resp_nh4_atmos_ship_N .gt. 0) then
      allocate(ergom%p_cya_resp_nh4_atmos_ship_N(isd:ied,jsd:jed,nk))
      ergom%p_cya_resp_nh4_atmos_ship_N = 0.0
    endif
    vardesc_temp = vardesc("p_zoo_resp_nh4_atmos_ship_N","respiration of zooplankton; sub-process for atmos_ship nitrogen",'h','1','s','mol kg-1 d-1','f')
    ergom%id_p_zoo_resp_nh4_atmos_ship_N = register_diag_field(package_name, vardesc_temp%name, axes(1:3),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    if (ergom%id_p_zoo_resp_nh4_atmos_ship_N .gt. 0) then
      allocate(ergom%p_zoo_resp_nh4_atmos_ship_N(isd:ied,jsd:jed,nk))
      ergom%p_zoo_resp_nh4_atmos_ship_N = 0.0
    endif
    vardesc_temp = vardesc("p_lpp_mort_det_atmos_ship_N","mortality of large-cell phytoplankton; sub-process for atmos_ship nitrogen",'h','1','s','mol kg-1 d-1','f')
    ergom%id_p_lpp_mort_det_atmos_ship_N = register_diag_field(package_name, vardesc_temp%name, axes(1:3),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    if (ergom%id_p_lpp_mort_det_atmos_ship_N .gt. 0) then
      allocate(ergom%p_lpp_mort_det_atmos_ship_N(isd:ied,jsd:jed,nk))
      ergom%p_lpp_mort_det_atmos_ship_N = 0.0
    endif
    vardesc_temp = vardesc("p_spp_mort_det_atmos_ship_N","mortality of small-scale phytoplankton; sub-process for atmos_ship nitrogen",'h','1','s','mol kg-1 d-1','f')
    ergom%id_p_spp_mort_det_atmos_ship_N = register_diag_field(package_name, vardesc_temp%name, axes(1:3),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    if (ergom%id_p_spp_mort_det_atmos_ship_N .gt. 0) then
      allocate(ergom%p_spp_mort_det_atmos_ship_N(isd:ied,jsd:jed,nk))
      ergom%p_spp_mort_det_atmos_ship_N = 0.0
    endif
    vardesc_temp = vardesc("p_cya_mort_det_atmos_ship_N","mortality of diazotroph cyanobacteria; sub-process for atmos_ship nitrogen",'h','1','s','mol kg-1 d-1','f')
    ergom%id_p_cya_mort_det_atmos_ship_N = register_diag_field(package_name, vardesc_temp%name, axes(1:3),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    if (ergom%id_p_cya_mort_det_atmos_ship_N .gt. 0) then
      allocate(ergom%p_cya_mort_det_atmos_ship_N(isd:ied,jsd:jed,nk))
      ergom%p_cya_mort_det_atmos_ship_N = 0.0
    endif
    vardesc_temp = vardesc("p_cya_mort_det_diff_atmos_ship_N","mortality of diazotroph cyanobacteria due to strong turbulence; sub-process for atmos_ship nitrogen",'h','1','s','mol kg-1 d-1','f')
    ergom%id_p_cya_mort_det_diff_atmos_ship_N = register_diag_field(package_name, vardesc_temp%name, axes(1:3),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    if (ergom%id_p_cya_mort_det_diff_atmos_ship_N .gt. 0) then
      allocate(ergom%p_cya_mort_det_diff_atmos_ship_N(isd:ied,jsd:jed,nk))
      ergom%p_cya_mort_det_diff_atmos_ship_N = 0.0
    endif
    vardesc_temp = vardesc("p_zoo_mort_det_atmos_ship_N","mortality of zooplankton; sub-process for atmos_ship nitrogen",'h','1','s','mol kg-1 d-1','f')
    ergom%id_p_zoo_mort_det_atmos_ship_N = register_diag_field(package_name, vardesc_temp%name, axes(1:3),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    if (ergom%id_p_zoo_mort_det_atmos_ship_N .gt. 0) then
      allocate(ergom%p_zoo_mort_det_atmos_ship_N(isd:ied,jsd:jed,nk))
      ergom%p_zoo_mort_det_atmos_ship_N = 0.0
    endif
    vardesc_temp = vardesc("p_nh4_nit_no3_atmos_ship_N","nitrification; sub-process for atmos_ship nitrogen",'h','1','s','mol kg-1 d-1','f')
    ergom%id_p_nh4_nit_no3_atmos_ship_N = register_diag_field(package_name, vardesc_temp%name, axes(1:3),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    if (ergom%id_p_nh4_nit_no3_atmos_ship_N .gt. 0) then
      allocate(ergom%p_nh4_nit_no3_atmos_ship_N(isd:ied,jsd:jed,nk))
      ergom%p_nh4_nit_no3_atmos_ship_N = 0.0
    endif
    vardesc_temp = vardesc("p_det_resp_nh4_atmos_ship_N","recycling of detritus using oxygen (respiration); sub-process for atmos_ship nitrogen",'h','1','s','mol kg-1 d-1','f')
    ergom%id_p_det_resp_nh4_atmos_ship_N = register_diag_field(package_name, vardesc_temp%name, axes(1:3),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    if (ergom%id_p_det_resp_nh4_atmos_ship_N .gt. 0) then
      allocate(ergom%p_det_resp_nh4_atmos_ship_N(isd:ied,jsd:jed,nk))
      ergom%p_det_resp_nh4_atmos_ship_N = 0.0
    endif
    vardesc_temp = vardesc("p_det_sulf_nh4_atmos_ship_N","recycling of detritus using sulfate (sulfate reduction); sub-process for atmos_ship nitrogen",'h','1','s','mol kg-1 d-1','f')
    ergom%id_p_det_sulf_nh4_atmos_ship_N = register_diag_field(package_name, vardesc_temp%name, axes(1:3),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    if (ergom%id_p_det_sulf_nh4_atmos_ship_N .gt. 0) then
      allocate(ergom%p_det_sulf_nh4_atmos_ship_N(isd:ied,jsd:jed,nk))
      ergom%p_det_sulf_nh4_atmos_ship_N = 0.0
    endif
    vardesc_temp = vardesc("p_don2pocn_atmos_ship_N","particle formation from DON; sub-process for atmos_ship nitrogen",'h','1','s','mol kg-1 d-1','f')
    ergom%id_p_don2pocn_atmos_ship_N = register_diag_field(package_name, vardesc_temp%name, axes(1:3),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    if (ergom%id_p_don2pocn_atmos_ship_N .gt. 0) then
      allocate(ergom%p_don2pocn_atmos_ship_N(isd:ied,jsd:jed,nk))
      ergom%p_don2pocn_atmos_ship_N = 0.0
    endif
    vardesc_temp = vardesc("p_don_resp_atmos_ship_N","respiration of DON; sub-process for atmos_ship nitrogen",'h','1','s','mol kg-1 d-1','f')
    ergom%id_p_don_resp_atmos_ship_N = register_diag_field(package_name, vardesc_temp%name, axes(1:3),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    if (ergom%id_p_don_resp_atmos_ship_N .gt. 0) then
      allocate(ergom%p_don_resp_atmos_ship_N(isd:ied,jsd:jed,nk))
      ergom%p_don_resp_atmos_ship_N = 0.0
    endif
    vardesc_temp = vardesc("p_don_denit_noN2_atmos_ship_N","recycling of DON using nitrate (denitrification); sub-process for atmos_ship nitrogen",'h','1','s','mol kg-1 d-1','f')
    ergom%id_p_don_denit_noN2_atmos_ship_N = register_diag_field(package_name, vardesc_temp%name, axes(1:3),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    if (ergom%id_p_don_denit_noN2_atmos_ship_N .gt. 0) then
      allocate(ergom%p_don_denit_noN2_atmos_ship_N(isd:ied,jsd:jed,nk))
      ergom%p_don_denit_noN2_atmos_ship_N = 0.0
    endif
    vardesc_temp = vardesc("p_don_sulf_atmos_ship_N","Mineralization of DON, e-acceptor sulfate (sulfate reduction); sub-process for atmos_ship nitrogen",'h','1','s','mol kg-1 d-1','f')
    ergom%id_p_don_sulf_atmos_ship_N = register_diag_field(package_name, vardesc_temp%name, axes(1:3),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    if (ergom%id_p_don_sulf_atmos_ship_N .gt. 0) then
      allocate(ergom%p_don_sulf_atmos_ship_N(isd:ied,jsd:jed,nk))
      ergom%p_don_sulf_atmos_ship_N = 0.0
    endif

    vardesc_temp = vardesc("p_sed_resp_nh4 ","recycling of sedimentary detritus to ammonium using oxygen (respiration)",'h','1','s','mol m-2 d-1','f')
    ergom%id_p_sed_resp_nh4  = register_diag_field(package_name, vardesc_temp%name, axes(1:2),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    if (ergom%id_p_sed_resp_nh4  .gt. 0) then
      allocate(ergom%p_sed_resp_nh4 (isd:ied,jsd:jed))
      ergom%p_sed_resp_nh4  = 0.0
    endif
    vardesc_temp = vardesc("p_nh4_nitdenit_n2","coupled nitrification and denitrification after mineralization of detritus in oxic sediments",'h','1','s','mol m-2 d-1','f')
    ergom%id_p_nh4_nitdenit_n2 = register_diag_field(package_name, vardesc_temp%name, axes(1:2),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    if (ergom%id_p_nh4_nitdenit_n2 .gt. 0) then
      allocate(ergom%p_nh4_nitdenit_n2(isd:ied,jsd:jed))
      ergom%p_nh4_nitdenit_n2 = 0.0
    endif
    vardesc_temp = vardesc("p_sed_denit_nh4_noN2","recycling of sedimentary detritus to ammonium using nitrate (denitrification)",'h','1','s','mol m-2 d-1','f')
    ergom%id_p_sed_denit_nh4_noN2 = register_diag_field(package_name, vardesc_temp%name, axes(1:2),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    if (ergom%id_p_sed_denit_nh4_noN2 .gt. 0) then
      allocate(ergom%p_sed_denit_nh4_noN2(isd:ied,jsd:jed))
      ergom%p_sed_denit_nh4_noN2 = 0.0
    endif
    vardesc_temp = vardesc("p_sed_denit_nh4_wiN2","recycling of sedimentary detritus to ammonium using nitrate (denitrification)",'h','1','s','mol m-2 d-1','f')
    ergom%id_p_sed_denit_nh4_wiN2 = register_diag_field(package_name, vardesc_temp%name, axes(1:2),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    if (ergom%id_p_sed_denit_nh4_wiN2 .gt. 0) then
      allocate(ergom%p_sed_denit_nh4_wiN2(isd:ied,jsd:jed))
      ergom%p_sed_denit_nh4_wiN2 = 0.0
    endif
    vardesc_temp = vardesc("p_sed_sulf_nh4 ","recycling of sedimentary detritus to ammonium using sulfate (sulfate reduction)",'h','1','s','mol m-2 d-1','f')
    ergom%id_p_sed_sulf_nh4  = register_diag_field(package_name, vardesc_temp%name, axes(1:2),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    if (ergom%id_p_sed_sulf_nh4  .gt. 0) then
      allocate(ergom%p_sed_sulf_nh4 (isd:ied,jsd:jed))
      ergom%p_sed_sulf_nh4  = 0.0
    endif
    vardesc_temp = vardesc("p_sed_poc_resp ","recycling of sedimentary poc to dic using oxygen (respiration)",'h','1','s','mol m-2 d-1','f')
    ergom%id_p_sed_poc_resp  = register_diag_field(package_name, vardesc_temp%name, axes(1:2),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    if (ergom%id_p_sed_poc_resp  .gt. 0) then
      allocate(ergom%p_sed_poc_resp (isd:ied,jsd:jed))
      ergom%p_sed_poc_resp  = 0.0
    endif
    vardesc_temp = vardesc("p_sed_poc_denit","recycling of sedimentary poc to dic using nitrate (denitrification)",'h','1','s','mol m-2 d-1','f')
    ergom%id_p_sed_poc_denit = register_diag_field(package_name, vardesc_temp%name, axes(1:2),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    if (ergom%id_p_sed_poc_denit .gt. 0) then
      allocate(ergom%p_sed_poc_denit(isd:ied,jsd:jed))
      ergom%p_sed_poc_denit = 0.0
    endif
    vardesc_temp = vardesc("p_sed_poc_sulf ","recycling of sedimentary poc to dic using sulfate (sulfate reduction)",'h','1','s','mol m-2 d-1','f')
    ergom%id_p_sed_poc_sulf  = register_diag_field(package_name, vardesc_temp%name, axes(1:2),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    if (ergom%id_p_sed_poc_sulf  .gt. 0) then
      allocate(ergom%p_sed_poc_sulf (isd:ied,jsd:jed))
      ergom%p_sed_poc_sulf  = 0.0
    endif
    vardesc_temp = vardesc("p_po4_retent_ips","retention of phosphate in the sediment under oxic conditions",'h','1','s','mol m-2 d-1','f')
    ergom%id_p_po4_retent_ips = register_diag_field(package_name, vardesc_temp%name, axes(1:2),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    if (ergom%id_p_po4_retent_ips .gt. 0) then
      allocate(ergom%p_po4_retent_ips(isd:ied,jsd:jed))
      ergom%p_po4_retent_ips = 0.0
    endif
    vardesc_temp = vardesc("p_ips_liber_po4","liberation of phosphate from the sediment under anoxic conditions",'h','1','s','mol m-2 d-1','f')
    ergom%id_p_ips_liber_po4 = register_diag_field(package_name, vardesc_temp%name, axes(1:2),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    if (ergom%id_p_ips_liber_po4 .gt. 0) then
      allocate(ergom%p_ips_liber_po4(isd:ied,jsd:jed))
      ergom%p_ips_liber_po4 = 0.0
    endif
    vardesc_temp = vardesc("p_det_sedi_sed ","detritus sedimentation",'h','1','s','mol m-2 d-1','f')
    ergom%id_p_det_sedi_sed  = register_diag_field(package_name, vardesc_temp%name, axes(1:2),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    if (ergom%id_p_det_sedi_sed  .gt. 0) then
      allocate(ergom%p_det_sedi_sed (isd:ied,jsd:jed))
      ergom%p_det_sedi_sed  = 0.0
    endif
    vardesc_temp = vardesc("p_ipw_sedi_ips ","sedimentation of iron PO4",'h','1','s','mol m-2 d-1','f')
    ergom%id_p_ipw_sedi_ips  = register_diag_field(package_name, vardesc_temp%name, axes(1:2),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    if (ergom%id_p_ipw_sedi_ips  .gt. 0) then
      allocate(ergom%p_ipw_sedi_ips (isd:ied,jsd:jed))
      ergom%p_ipw_sedi_ips  = 0.0
    endif
    vardesc_temp = vardesc("p_poc_sedi_sed ","poc sedimentation",'h','1','s','mol m-2 d-1','f')
    ergom%id_p_poc_sedi_sed  = register_diag_field(package_name, vardesc_temp%name, axes(1:2),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    if (ergom%id_p_poc_sedi_sed  .gt. 0) then
      allocate(ergom%p_poc_sedi_sed (isd:ied,jsd:jed))
      ergom%p_poc_sedi_sed  = 0.0
    endif
    vardesc_temp = vardesc("p_pocn_sedi_sed","pocn sedimentation",'h','1','s','mol m-2 d-1','f')
    ergom%id_p_pocn_sedi_sed = register_diag_field(package_name, vardesc_temp%name, axes(1:2),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    if (ergom%id_p_pocn_sedi_sed .gt. 0) then
      allocate(ergom%p_pocn_sedi_sed(isd:ied,jsd:jed))
      ergom%p_pocn_sedi_sed = 0.0
    endif
    vardesc_temp = vardesc("p_pocp_sedi_sed","pocp sedimentation",'h','1','s','mol m-2 d-1','f')
    ergom%id_p_pocp_sedi_sed = register_diag_field(package_name, vardesc_temp%name, axes(1:2),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    if (ergom%id_p_pocp_sedi_sed .gt. 0) then
      allocate(ergom%p_pocp_sedi_sed(isd:ied,jsd:jed))
      ergom%p_pocp_sedi_sed = 0.0
    endif
    vardesc_temp = vardesc("p_sed_ero_det  ","sedimentary detritus erosion",'h','1','s','mol m-2 d-1','f')
    ergom%id_p_sed_ero_det   = register_diag_field(package_name, vardesc_temp%name, axes(1:2),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    if (ergom%id_p_sed_ero_det   .gt. 0) then
      allocate(ergom%p_sed_ero_det  (isd:ied,jsd:jed))
      ergom%p_sed_ero_det   = 0.0
    endif
    vardesc_temp = vardesc("p_ips_ero_ipw  ","erosion of iron PO4",'h','1','s','mol m-2 d-1','f')
    ergom%id_p_ips_ero_ipw   = register_diag_field(package_name, vardesc_temp%name, axes(1:2),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    if (ergom%id_p_ips_ero_ipw   .gt. 0) then
      allocate(ergom%p_ips_ero_ipw  (isd:ied,jsd:jed))
      ergom%p_ips_ero_ipw   = 0.0
    endif
    vardesc_temp = vardesc("p_sed_ero_poc  ","sedimentary poc erosion",'h','1','s','mol m-2 d-1','f')
    ergom%id_p_sed_ero_poc   = register_diag_field(package_name, vardesc_temp%name, axes(1:2),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    if (ergom%id_p_sed_ero_poc   .gt. 0) then
      allocate(ergom%p_sed_ero_poc  (isd:ied,jsd:jed))
      ergom%p_sed_ero_poc   = 0.0
    endif
    vardesc_temp = vardesc("p_sed_ero_pocn ","sedimentary pocn erosion",'h','1','s','mol m-2 d-1','f')
    ergom%id_p_sed_ero_pocn  = register_diag_field(package_name, vardesc_temp%name, axes(1:2),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    if (ergom%id_p_sed_ero_pocn  .gt. 0) then
      allocate(ergom%p_sed_ero_pocn (isd:ied,jsd:jed))
      ergom%p_sed_ero_pocn  = 0.0
    endif
    vardesc_temp = vardesc("p_sed_ero_pocp ","sedimentary pocp erosion",'h','1','s','mol m-2 d-1','f')
    ergom%id_p_sed_ero_pocp  = register_diag_field(package_name, vardesc_temp%name, axes(1:2),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    if (ergom%id_p_sed_ero_pocp  .gt. 0) then
      allocate(ergom%p_sed_ero_pocp (isd:ied,jsd:jed))
      ergom%p_sed_ero_pocp  = 0.0
    endif
    vardesc_temp = vardesc("p_sed_biores_det","bio resuspension of sedimentary detritus",'h','1','s','mol m-2 d-1','f')
    ergom%id_p_sed_biores_det = register_diag_field(package_name, vardesc_temp%name, axes(1:2),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    if (ergom%id_p_sed_biores_det .gt. 0) then
      allocate(ergom%p_sed_biores_det(isd:ied,jsd:jed))
      ergom%p_sed_biores_det = 0.0
    endif
    vardesc_temp = vardesc("p_ips_biores_ipw","bio resuspension of iron PO4",'h','1','s','mol m-2 d-1','f')
    ergom%id_p_ips_biores_ipw = register_diag_field(package_name, vardesc_temp%name, axes(1:2),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    if (ergom%id_p_ips_biores_ipw .gt. 0) then
      allocate(ergom%p_ips_biores_ipw(isd:ied,jsd:jed))
      ergom%p_ips_biores_ipw = 0.0
    endif
    vardesc_temp = vardesc("p_sed_biores_poc","bio resuspension of sedimentary poc",'h','1','s','mol m-2 d-1','f')
    ergom%id_p_sed_biores_poc = register_diag_field(package_name, vardesc_temp%name, axes(1:2),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    if (ergom%id_p_sed_biores_poc .gt. 0) then
      allocate(ergom%p_sed_biores_poc(isd:ied,jsd:jed))
      ergom%p_sed_biores_poc = 0.0
    endif
    vardesc_temp = vardesc("p_sed_biores_pocn","bio resuspension of sedimentary pocn",'h','1','s','mol m-2 d-1','f')
    ergom%id_p_sed_biores_pocn = register_diag_field(package_name, vardesc_temp%name, axes(1:2),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    if (ergom%id_p_sed_biores_pocn .gt. 0) then
      allocate(ergom%p_sed_biores_pocn(isd:ied,jsd:jed))
      ergom%p_sed_biores_pocn = 0.0
    endif
    vardesc_temp = vardesc("p_sed_biores_pocp","bio resuspension of sedimentary pocp",'h','1','s','mol m-2 d-1','f')
    ergom%id_p_sed_biores_pocp = register_diag_field(package_name, vardesc_temp%name, axes(1:2),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    if (ergom%id_p_sed_biores_pocp .gt. 0) then
      allocate(ergom%p_sed_biores_pocp(isd:ied,jsd:jed))
      ergom%p_sed_biores_pocp = 0.0
    endif
    vardesc_temp = vardesc("p_sed_burial   ","burial of detritus deeper than max_sed",'h','1','s','mol m-2 d-1','f')
    ergom%id_p_sed_burial    = register_diag_field(package_name, vardesc_temp%name, axes(1:2),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    if (ergom%id_p_sed_burial    .gt. 0) then
      allocate(ergom%p_sed_burial   (isd:ied,jsd:jed))
      ergom%p_sed_burial    = 0.0
    endif
    vardesc_temp = vardesc("p_ips_burial   ","burial of iron PO4",'h','1','s','mol m-2 d-1','f')
    ergom%id_p_ips_burial    = register_diag_field(package_name, vardesc_temp%name, axes(1:2),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    if (ergom%id_p_ips_burial    .gt. 0) then
      allocate(ergom%p_ips_burial   (isd:ied,jsd:jed))
      ergom%p_ips_burial    = 0.0
    endif
    vardesc_temp = vardesc("p_poc_burial   ","burial of poc deeper than max_sed",'h','1','s','mol m-2 d-1','f')
    ergom%id_p_poc_burial    = register_diag_field(package_name, vardesc_temp%name, axes(1:2),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    if (ergom%id_p_poc_burial    .gt. 0) then
      allocate(ergom%p_poc_burial   (isd:ied,jsd:jed))
      ergom%p_poc_burial    = 0.0
    endif
    vardesc_temp = vardesc("p_pocn_burial  ","burial of pocn deeper than max_sed",'h','1','s','mol m-2 d-1','f')
    ergom%id_p_pocn_burial   = register_diag_field(package_name, vardesc_temp%name, axes(1:2),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    if (ergom%id_p_pocn_burial   .gt. 0) then
      allocate(ergom%p_pocn_burial  (isd:ied,jsd:jed))
      ergom%p_pocn_burial   = 0.0
    endif
    vardesc_temp = vardesc("p_pocp_burial  ","burial of pocp deeper than max_sed",'h','1','s','mol m-2 d-1','f')
    ergom%id_p_pocp_burial   = register_diag_field(package_name, vardesc_temp%name, axes(1:2),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    if (ergom%id_p_pocp_burial   .gt. 0) then
      allocate(ergom%p_pocp_burial  (isd:ied,jsd:jed))
      ergom%p_pocp_burial   = 0.0
    endif
    vardesc_temp = vardesc("p_sed_pocn_resp","recycling of sedimentary pocn to dic and NH4 using oxygen (respiration)",'h','1','s','mol m-2 d-1','f')
    ergom%id_p_sed_pocn_resp = register_diag_field(package_name, vardesc_temp%name, axes(1:2),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    if (ergom%id_p_sed_pocn_resp .gt. 0) then
      allocate(ergom%p_sed_pocn_resp(isd:ied,jsd:jed))
      ergom%p_sed_pocn_resp = 0.0
    endif
    vardesc_temp = vardesc("p_sed_pocp_resp","recycling of sedimentary pocp to dic and PO4 using oxygen (respiration)",'h','1','s','mol m-2 d-1','f')
    ergom%id_p_sed_pocp_resp = register_diag_field(package_name, vardesc_temp%name, axes(1:2),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    if (ergom%id_p_sed_pocp_resp .gt. 0) then
      allocate(ergom%p_sed_pocp_resp(isd:ied,jsd:jed))
      ergom%p_sed_pocp_resp = 0.0
    endif
    vardesc_temp = vardesc("p_sed_pocn_denit_noN2","recycling of sedimentary pocn to dic and NH4 using nitrate (denitrification)",'h','1','s','mol m-2 d-1','f')
    ergom%id_p_sed_pocn_denit_noN2 = register_diag_field(package_name, vardesc_temp%name, axes(1:2),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    if (ergom%id_p_sed_pocn_denit_noN2 .gt. 0) then
      allocate(ergom%p_sed_pocn_denit_noN2(isd:ied,jsd:jed))
      ergom%p_sed_pocn_denit_noN2 = 0.0
    endif
    vardesc_temp = vardesc("p_sed_pocn_denit_wiN2","recycling of sedimentary pocn to dic and NH4 using nitrate (denitrification)",'h','1','s','mol m-2 d-1','f')
    ergom%id_p_sed_pocn_denit_wiN2 = register_diag_field(package_name, vardesc_temp%name, axes(1:2),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    if (ergom%id_p_sed_pocn_denit_wiN2 .gt. 0) then
      allocate(ergom%p_sed_pocn_denit_wiN2(isd:ied,jsd:jed))
      ergom%p_sed_pocn_denit_wiN2 = 0.0
    endif
    vardesc_temp = vardesc("p_sed_pocp_denit","recycling of sedimentary pocp to dic and PO4 using nitrate (denitrification)",'h','1','s','mol m-2 d-1','f')
    ergom%id_p_sed_pocp_denit = register_diag_field(package_name, vardesc_temp%name, axes(1:2),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    if (ergom%id_p_sed_pocp_denit .gt. 0) then
      allocate(ergom%p_sed_pocp_denit(isd:ied,jsd:jed))
      ergom%p_sed_pocp_denit = 0.0
    endif
    vardesc_temp = vardesc("p_sed_pocn_sulf","recycling of sedimentary pocn to dic and NH4 using sulfate (sulfate reduction)",'h','1','s','mol m-2 d-1','f')
    ergom%id_p_sed_pocn_sulf = register_diag_field(package_name, vardesc_temp%name, axes(1:2),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    if (ergom%id_p_sed_pocn_sulf .gt. 0) then
      allocate(ergom%p_sed_pocn_sulf(isd:ied,jsd:jed))
      ergom%p_sed_pocn_sulf = 0.0
    endif
    vardesc_temp = vardesc("p_sed_pocp_sulf","recycling of sedimentary pocp to dic and PO4 using sulfate (sulfate reduction)",'h','1','s','mol m-2 d-1','f')
    ergom%id_p_sed_pocp_sulf = register_diag_field(package_name, vardesc_temp%name, axes(1:2),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    if (ergom%id_p_sed_pocp_sulf .gt. 0) then
      allocate(ergom%p_sed_pocp_sulf(isd:ied,jsd:jed))
      ergom%p_sed_pocp_sulf = 0.0
    endif
    vardesc_temp = vardesc("p_nh4_nitdenit_pocn_n2","coupled nitrification and denitrification after mineralization of pocn-detritus in oxic sediments",'h','1','s','mol m-2 d-1','f')
    ergom%id_p_nh4_nitdenit_pocn_n2 = register_diag_field(package_name, vardesc_temp%name, axes(1:2),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    if (ergom%id_p_nh4_nitdenit_pocn_n2 .gt. 0) then
      allocate(ergom%p_nh4_nitdenit_pocn_n2(isd:ied,jsd:jed))
      ergom%p_nh4_nitdenit_pocn_n2 = 0.0
    endif
    vardesc_temp = vardesc("p_sed_resp_nh4_atmos_tot_N","recycling of sedimentary detritus to ammonium using oxygen (respiration); sub-process for atmos_tot nitrogen",'h','1','s','mol m-2 d-1','f')
    ergom%id_p_sed_resp_nh4_atmos_tot_N = register_diag_field(package_name, vardesc_temp%name, axes(1:2),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    if (ergom%id_p_sed_resp_nh4_atmos_tot_N .gt. 0) then
      allocate(ergom%p_sed_resp_nh4_atmos_tot_N(isd:ied,jsd:jed))
      ergom%p_sed_resp_nh4_atmos_tot_N = 0.0
    endif
    vardesc_temp = vardesc("p_sed_denit_nh4_noN2_atmos_tot_N","recycling of sedimentary detritus to ammonium using nitrate (denitrification); sub-process for atmos_tot nitrogen",'h','1','s','mol m-2 d-1','f')
    ergom%id_p_sed_denit_nh4_noN2_atmos_tot_N = register_diag_field(package_name, vardesc_temp%name, axes(1:2),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    if (ergom%id_p_sed_denit_nh4_noN2_atmos_tot_N .gt. 0) then
      allocate(ergom%p_sed_denit_nh4_noN2_atmos_tot_N(isd:ied,jsd:jed))
      ergom%p_sed_denit_nh4_noN2_atmos_tot_N = 0.0
    endif
    vardesc_temp = vardesc("p_sed_sulf_nh4_atmos_tot_N","recycling of sedimentary detritus to ammonium using sulfate (sulfate reduction); sub-process for atmos_tot nitrogen",'h','1','s','mol m-2 d-1','f')
    ergom%id_p_sed_sulf_nh4_atmos_tot_N = register_diag_field(package_name, vardesc_temp%name, axes(1:2),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    if (ergom%id_p_sed_sulf_nh4_atmos_tot_N .gt. 0) then
      allocate(ergom%p_sed_sulf_nh4_atmos_tot_N(isd:ied,jsd:jed))
      ergom%p_sed_sulf_nh4_atmos_tot_N = 0.0
    endif
    vardesc_temp = vardesc("p_det_sedi_sed_atmos_tot_N","detritus sedimentation; sub-process for atmos_tot nitrogen",'h','1','s','mol m-2 d-1','f')
    ergom%id_p_det_sedi_sed_atmos_tot_N = register_diag_field(package_name, vardesc_temp%name, axes(1:2),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    if (ergom%id_p_det_sedi_sed_atmos_tot_N .gt. 0) then
      allocate(ergom%p_det_sedi_sed_atmos_tot_N(isd:ied,jsd:jed))
      ergom%p_det_sedi_sed_atmos_tot_N = 0.0
    endif
    vardesc_temp = vardesc("p_pocn_sedi_sed_atmos_tot_N","pocn sedimentation; sub-process for atmos_tot nitrogen",'h','1','s','mol m-2 d-1','f')
    ergom%id_p_pocn_sedi_sed_atmos_tot_N = register_diag_field(package_name, vardesc_temp%name, axes(1:2),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    if (ergom%id_p_pocn_sedi_sed_atmos_tot_N .gt. 0) then
      allocate(ergom%p_pocn_sedi_sed_atmos_tot_N(isd:ied,jsd:jed))
      ergom%p_pocn_sedi_sed_atmos_tot_N = 0.0
    endif
    vardesc_temp = vardesc("p_sed_ero_det_atmos_tot_N","sedimentary detritus erosion; sub-process for atmos_tot nitrogen",'h','1','s','mol m-2 d-1','f')
    ergom%id_p_sed_ero_det_atmos_tot_N = register_diag_field(package_name, vardesc_temp%name, axes(1:2),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    if (ergom%id_p_sed_ero_det_atmos_tot_N .gt. 0) then
      allocate(ergom%p_sed_ero_det_atmos_tot_N(isd:ied,jsd:jed))
      ergom%p_sed_ero_det_atmos_tot_N = 0.0
    endif
    vardesc_temp = vardesc("p_sed_ero_pocn_atmos_tot_N","sedimentary pocn erosion; sub-process for atmos_tot nitrogen",'h','1','s','mol m-2 d-1','f')
    ergom%id_p_sed_ero_pocn_atmos_tot_N = register_diag_field(package_name, vardesc_temp%name, axes(1:2),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    if (ergom%id_p_sed_ero_pocn_atmos_tot_N .gt. 0) then
      allocate(ergom%p_sed_ero_pocn_atmos_tot_N(isd:ied,jsd:jed))
      ergom%p_sed_ero_pocn_atmos_tot_N = 0.0
    endif
    vardesc_temp = vardesc("p_sed_biores_det_atmos_tot_N","bio resuspension of sedimentary detritus; sub-process for atmos_tot nitrogen",'h','1','s','mol m-2 d-1','f')
    ergom%id_p_sed_biores_det_atmos_tot_N = register_diag_field(package_name, vardesc_temp%name, axes(1:2),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    if (ergom%id_p_sed_biores_det_atmos_tot_N .gt. 0) then
      allocate(ergom%p_sed_biores_det_atmos_tot_N(isd:ied,jsd:jed))
      ergom%p_sed_biores_det_atmos_tot_N = 0.0
    endif
    vardesc_temp = vardesc("p_sed_biores_pocn_atmos_tot_N","bio resuspension of sedimentary pocn; sub-process for atmos_tot nitrogen",'h','1','s','mol m-2 d-1','f')
    ergom%id_p_sed_biores_pocn_atmos_tot_N = register_diag_field(package_name, vardesc_temp%name, axes(1:2),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    if (ergom%id_p_sed_biores_pocn_atmos_tot_N .gt. 0) then
      allocate(ergom%p_sed_biores_pocn_atmos_tot_N(isd:ied,jsd:jed))
      ergom%p_sed_biores_pocn_atmos_tot_N = 0.0
    endif
    vardesc_temp = vardesc("p_sed_burial_atmos_tot_N","burial of detritus deeper than max_sed; sub-process for atmos_tot nitrogen",'h','1','s','mol m-2 d-1','f')
    ergom%id_p_sed_burial_atmos_tot_N = register_diag_field(package_name, vardesc_temp%name, axes(1:2),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    if (ergom%id_p_sed_burial_atmos_tot_N .gt. 0) then
      allocate(ergom%p_sed_burial_atmos_tot_N(isd:ied,jsd:jed))
      ergom%p_sed_burial_atmos_tot_N = 0.0
    endif
    vardesc_temp = vardesc("p_pocn_burial_atmos_tot_N","burial of pocn deeper than max_sed; sub-process for atmos_tot nitrogen",'h','1','s','mol m-2 d-1','f')
    ergom%id_p_pocn_burial_atmos_tot_N = register_diag_field(package_name, vardesc_temp%name, axes(1:2),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    if (ergom%id_p_pocn_burial_atmos_tot_N .gt. 0) then
      allocate(ergom%p_pocn_burial_atmos_tot_N(isd:ied,jsd:jed))
      ergom%p_pocn_burial_atmos_tot_N = 0.0
    endif
    vardesc_temp = vardesc("p_sed_pocn_resp_atmos_tot_N","recycling of sedimentary pocn to dic and NH4 using oxygen (respiration); sub-process for atmos_tot nitrogen",'h','1','s','mol m-2 d-1','f')
    ergom%id_p_sed_pocn_resp_atmos_tot_N = register_diag_field(package_name, vardesc_temp%name, axes(1:2),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    if (ergom%id_p_sed_pocn_resp_atmos_tot_N .gt. 0) then
      allocate(ergom%p_sed_pocn_resp_atmos_tot_N(isd:ied,jsd:jed))
      ergom%p_sed_pocn_resp_atmos_tot_N = 0.0
    endif
    vardesc_temp = vardesc("p_sed_pocn_denit_noN2_atmos_tot_N","recycling of sedimentary pocn to dic and NH4 using nitrate (denitrification); sub-process for atmos_tot nitrogen",'h','1','s','mol m-2 d-1','f')
    ergom%id_p_sed_pocn_denit_noN2_atmos_tot_N = register_diag_field(package_name, vardesc_temp%name, axes(1:2),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    if (ergom%id_p_sed_pocn_denit_noN2_atmos_tot_N .gt. 0) then
      allocate(ergom%p_sed_pocn_denit_noN2_atmos_tot_N(isd:ied,jsd:jed))
      ergom%p_sed_pocn_denit_noN2_atmos_tot_N = 0.0
    endif
    vardesc_temp = vardesc("p_sed_pocn_sulf_atmos_tot_N","recycling of sedimentary pocn to dic and NH4 using sulfate (sulfate reduction); sub-process for atmos_tot nitrogen",'h','1','s','mol m-2 d-1','f')
    ergom%id_p_sed_pocn_sulf_atmos_tot_N = register_diag_field(package_name, vardesc_temp%name, axes(1:2),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    if (ergom%id_p_sed_pocn_sulf_atmos_tot_N .gt. 0) then
      allocate(ergom%p_sed_pocn_sulf_atmos_tot_N(isd:ied,jsd:jed))
      ergom%p_sed_pocn_sulf_atmos_tot_N = 0.0
    endif
    vardesc_temp = vardesc("p_sed_resp_nh4_atmos_ship_N","recycling of sedimentary detritus to ammonium using oxygen (respiration); sub-process for atmos_ship nitrogen",'h','1','s','mol m-2 d-1','f')
    ergom%id_p_sed_resp_nh4_atmos_ship_N = register_diag_field(package_name, vardesc_temp%name, axes(1:2),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    if (ergom%id_p_sed_resp_nh4_atmos_ship_N .gt. 0) then
      allocate(ergom%p_sed_resp_nh4_atmos_ship_N(isd:ied,jsd:jed))
      ergom%p_sed_resp_nh4_atmos_ship_N = 0.0
    endif
    vardesc_temp = vardesc("p_sed_denit_nh4_noN2_atmos_ship_N","recycling of sedimentary detritus to ammonium using nitrate (denitrification); sub-process for atmos_ship nitrogen",'h','1','s','mol m-2 d-1','f')
    ergom%id_p_sed_denit_nh4_noN2_atmos_ship_N = register_diag_field(package_name, vardesc_temp%name, axes(1:2),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    if (ergom%id_p_sed_denit_nh4_noN2_atmos_ship_N .gt. 0) then
      allocate(ergom%p_sed_denit_nh4_noN2_atmos_ship_N(isd:ied,jsd:jed))
      ergom%p_sed_denit_nh4_noN2_atmos_ship_N = 0.0
    endif
    vardesc_temp = vardesc("p_sed_sulf_nh4_atmos_ship_N","recycling of sedimentary detritus to ammonium using sulfate (sulfate reduction); sub-process for atmos_ship nitrogen",'h','1','s','mol m-2 d-1','f')
    ergom%id_p_sed_sulf_nh4_atmos_ship_N = register_diag_field(package_name, vardesc_temp%name, axes(1:2),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    if (ergom%id_p_sed_sulf_nh4_atmos_ship_N .gt. 0) then
      allocate(ergom%p_sed_sulf_nh4_atmos_ship_N(isd:ied,jsd:jed))
      ergom%p_sed_sulf_nh4_atmos_ship_N = 0.0
    endif
    vardesc_temp = vardesc("p_det_sedi_sed_atmos_ship_N","detritus sedimentation; sub-process for atmos_ship nitrogen",'h','1','s','mol m-2 d-1','f')
    ergom%id_p_det_sedi_sed_atmos_ship_N = register_diag_field(package_name, vardesc_temp%name, axes(1:2),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    if (ergom%id_p_det_sedi_sed_atmos_ship_N .gt. 0) then
      allocate(ergom%p_det_sedi_sed_atmos_ship_N(isd:ied,jsd:jed))
      ergom%p_det_sedi_sed_atmos_ship_N = 0.0
    endif
    vardesc_temp = vardesc("p_pocn_sedi_sed_atmos_ship_N","pocn sedimentation; sub-process for atmos_ship nitrogen",'h','1','s','mol m-2 d-1','f')
    ergom%id_p_pocn_sedi_sed_atmos_ship_N = register_diag_field(package_name, vardesc_temp%name, axes(1:2),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    if (ergom%id_p_pocn_sedi_sed_atmos_ship_N .gt. 0) then
      allocate(ergom%p_pocn_sedi_sed_atmos_ship_N(isd:ied,jsd:jed))
      ergom%p_pocn_sedi_sed_atmos_ship_N = 0.0
    endif
    vardesc_temp = vardesc("p_sed_ero_det_atmos_ship_N","sedimentary detritus erosion; sub-process for atmos_ship nitrogen",'h','1','s','mol m-2 d-1','f')
    ergom%id_p_sed_ero_det_atmos_ship_N = register_diag_field(package_name, vardesc_temp%name, axes(1:2),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    if (ergom%id_p_sed_ero_det_atmos_ship_N .gt. 0) then
      allocate(ergom%p_sed_ero_det_atmos_ship_N(isd:ied,jsd:jed))
      ergom%p_sed_ero_det_atmos_ship_N = 0.0
    endif
    vardesc_temp = vardesc("p_sed_ero_pocn_atmos_ship_N","sedimentary pocn erosion; sub-process for atmos_ship nitrogen",'h','1','s','mol m-2 d-1','f')
    ergom%id_p_sed_ero_pocn_atmos_ship_N = register_diag_field(package_name, vardesc_temp%name, axes(1:2),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    if (ergom%id_p_sed_ero_pocn_atmos_ship_N .gt. 0) then
      allocate(ergom%p_sed_ero_pocn_atmos_ship_N(isd:ied,jsd:jed))
      ergom%p_sed_ero_pocn_atmos_ship_N = 0.0
    endif
    vardesc_temp = vardesc("p_sed_biores_det_atmos_ship_N","bio resuspension of sedimentary detritus; sub-process for atmos_ship nitrogen",'h','1','s','mol m-2 d-1','f')
    ergom%id_p_sed_biores_det_atmos_ship_N = register_diag_field(package_name, vardesc_temp%name, axes(1:2),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    if (ergom%id_p_sed_biores_det_atmos_ship_N .gt. 0) then
      allocate(ergom%p_sed_biores_det_atmos_ship_N(isd:ied,jsd:jed))
      ergom%p_sed_biores_det_atmos_ship_N = 0.0
    endif
    vardesc_temp = vardesc("p_sed_biores_pocn_atmos_ship_N","bio resuspension of sedimentary pocn; sub-process for atmos_ship nitrogen",'h','1','s','mol m-2 d-1','f')
    ergom%id_p_sed_biores_pocn_atmos_ship_N = register_diag_field(package_name, vardesc_temp%name, axes(1:2),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    if (ergom%id_p_sed_biores_pocn_atmos_ship_N .gt. 0) then
      allocate(ergom%p_sed_biores_pocn_atmos_ship_N(isd:ied,jsd:jed))
      ergom%p_sed_biores_pocn_atmos_ship_N = 0.0
    endif
    vardesc_temp = vardesc("p_sed_burial_atmos_ship_N","burial of detritus deeper than max_sed; sub-process for atmos_ship nitrogen",'h','1','s','mol m-2 d-1','f')
    ergom%id_p_sed_burial_atmos_ship_N = register_diag_field(package_name, vardesc_temp%name, axes(1:2),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    if (ergom%id_p_sed_burial_atmos_ship_N .gt. 0) then
      allocate(ergom%p_sed_burial_atmos_ship_N(isd:ied,jsd:jed))
      ergom%p_sed_burial_atmos_ship_N = 0.0
    endif
    vardesc_temp = vardesc("p_pocn_burial_atmos_ship_N","burial of pocn deeper than max_sed; sub-process for atmos_ship nitrogen",'h','1','s','mol m-2 d-1','f')
    ergom%id_p_pocn_burial_atmos_ship_N = register_diag_field(package_name, vardesc_temp%name, axes(1:2),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    if (ergom%id_p_pocn_burial_atmos_ship_N .gt. 0) then
      allocate(ergom%p_pocn_burial_atmos_ship_N(isd:ied,jsd:jed))
      ergom%p_pocn_burial_atmos_ship_N = 0.0
    endif
    vardesc_temp = vardesc("p_sed_pocn_resp_atmos_ship_N","recycling of sedimentary pocn to dic and NH4 using oxygen (respiration); sub-process for atmos_ship nitrogen",'h','1','s','mol m-2 d-1','f')
    ergom%id_p_sed_pocn_resp_atmos_ship_N = register_diag_field(package_name, vardesc_temp%name, axes(1:2),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    if (ergom%id_p_sed_pocn_resp_atmos_ship_N .gt. 0) then
      allocate(ergom%p_sed_pocn_resp_atmos_ship_N(isd:ied,jsd:jed))
      ergom%p_sed_pocn_resp_atmos_ship_N = 0.0
    endif
    vardesc_temp = vardesc("p_sed_pocn_denit_noN2_atmos_ship_N","recycling of sedimentary pocn to dic and NH4 using nitrate (denitrification); sub-process for atmos_ship nitrogen",'h','1','s','mol m-2 d-1','f')
    ergom%id_p_sed_pocn_denit_noN2_atmos_ship_N = register_diag_field(package_name, vardesc_temp%name, axes(1:2),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    if (ergom%id_p_sed_pocn_denit_noN2_atmos_ship_N .gt. 0) then
      allocate(ergom%p_sed_pocn_denit_noN2_atmos_ship_N(isd:ied,jsd:jed))
      ergom%p_sed_pocn_denit_noN2_atmos_ship_N = 0.0
    endif
    vardesc_temp = vardesc("p_sed_pocn_sulf_atmos_ship_N","recycling of sedimentary pocn to dic and NH4 using sulfate (sulfate reduction); sub-process for atmos_ship nitrogen",'h','1','s','mol m-2 d-1','f')
    ergom%id_p_sed_pocn_sulf_atmos_ship_N = register_diag_field(package_name, vardesc_temp%name, axes(1:2),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    if (ergom%id_p_sed_pocn_sulf_atmos_ship_N .gt. 0) then
      allocate(ergom%p_sed_pocn_sulf_atmos_ship_N(isd:ied,jsd:jed))
      ergom%p_sed_pocn_sulf_atmos_ship_N = 0.0
    endif

    if (NUM_SEDIMENT_LAYERS .gt. 1) then

       vardesc_temp = vardesc("sed_p_sed_burial   ","burial of detritus deeper than max_sed",'h','1','s','mol m-2 d-1','f')
       ergom%id_sed_p_sed_burial    = register_diag_field(package_name, vardesc_temp%name, axes(1:3),&
            init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
       if (ergom%id_p_sed_burial    .gt. 0) then
         allocate(ergom%sed_p_sed_burial   (isd:ied,jsd:jed,nk))
         ergom%p_sed_burial    = 0.0
       endif
       vardesc_temp = vardesc("sed_p_ips_burial   ","burial of iron PO4",'h','1','s','mol m-2 d-1','f')
       ergom%id_sed_p_ips_burial    = register_diag_field(package_name, vardesc_temp%name, axes(1:3),&
            init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
       if (ergom%id_p_ips_burial    .gt. 0) then
         allocate(ergom%sed_p_ips_burial   (isd:ied,jsd:jed,nk))
         ergom%p_ips_burial    = 0.0
       endif
       vardesc_temp = vardesc("sed_p_poc_burial   ","burial of poc deeper than max_sed",'h','1','s','mol m-2 d-1','f')
       ergom%id_sed_p_poc_burial    = register_diag_field(package_name, vardesc_temp%name, axes(1:3),&
            init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
       if (ergom%id_p_poc_burial    .gt. 0) then
         allocate(ergom%sed_p_poc_burial   (isd:ied,jsd:jed,nk))
         ergom%p_poc_burial    = 0.0
       endif
       vardesc_temp = vardesc("sed_p_pocn_burial  ","burial of pocn deeper than max_sed",'h','1','s','mol m-2 d-1','f')
       ergom%id_sed_p_pocn_burial   = register_diag_field(package_name, vardesc_temp%name, axes(1:3),&
            init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
       if (ergom%id_p_pocn_burial   .gt. 0) then
         allocate(ergom%sed_p_pocn_burial  (isd:ied,jsd:jed,nk))
         ergom%p_pocn_burial   = 0.0
       endif
       vardesc_temp = vardesc("sed_p_pocp_burial  ","burial of pocp deeper than max_sed",'h','1','s','mol m-2 d-1','f')
       ergom%id_sed_p_pocp_burial   = register_diag_field(package_name, vardesc_temp%name, axes(1:3),&
            init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
       if (ergom%id_p_pocp_burial   .gt. 0) then
         allocate(ergom%sed_p_pocp_burial  (isd:ied,jsd:jed,nk))
         ergom%p_pocp_burial   = 0.0
       endif
       vardesc_temp = vardesc("sed_p_det_sedi_sed_atmos_tot_N","detritus sedimentation; sub-process for atmos_tot nitrogen",'h','1','s','mol m-2 d-1','f')
       ergom%id_sed_p_det_sedi_sed_atmos_tot_N = register_diag_field(package_name, vardesc_temp%name, axes(1:3),&
            init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
       if (ergom%id_p_det_sedi_sed_atmos_tot_N .gt. 0) then
         allocate(ergom%sed_p_det_sedi_sed_atmos_tot_N(isd:ied,jsd:jed,nk))
         ergom%p_det_sedi_sed_atmos_tot_N = 0.0
       endif
       vardesc_temp = vardesc("sed_p_pocn_sedi_sed_atmos_tot_N","pocn sedimentation; sub-process for atmos_tot nitrogen",'h','1','s','mol m-2 d-1','f')
       ergom%id_sed_p_pocn_sedi_sed_atmos_tot_N = register_diag_field(package_name, vardesc_temp%name, axes(1:3),&
            init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
       if (ergom%id_p_pocn_sedi_sed_atmos_tot_N .gt. 0) then
         allocate(ergom%sed_p_pocn_sedi_sed_atmos_tot_N(isd:ied,jsd:jed,nk))
         ergom%p_pocn_sedi_sed_atmos_tot_N = 0.0
       endif
       vardesc_temp = vardesc("sed_p_sed_burial_atmos_tot_N","burial of detritus deeper than max_sed; sub-process for atmos_tot nitrogen",'h','1','s','mol m-2 d-1','f')
       ergom%id_sed_p_sed_burial_atmos_tot_N = register_diag_field(package_name, vardesc_temp%name, axes(1:3),&
            init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
       if (ergom%id_p_sed_burial_atmos_tot_N .gt. 0) then
         allocate(ergom%sed_p_sed_burial_atmos_tot_N(isd:ied,jsd:jed,nk))
         ergom%p_sed_burial_atmos_tot_N = 0.0
       endif
       vardesc_temp = vardesc("sed_p_pocn_burial_atmos_tot_N","burial of pocn deeper than max_sed; sub-process for atmos_tot nitrogen",'h','1','s','mol m-2 d-1','f')
       ergom%id_sed_p_pocn_burial_atmos_tot_N = register_diag_field(package_name, vardesc_temp%name, axes(1:3),&
            init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
       if (ergom%id_p_pocn_burial_atmos_tot_N .gt. 0) then
         allocate(ergom%sed_p_pocn_burial_atmos_tot_N(isd:ied,jsd:jed,nk))
         ergom%p_pocn_burial_atmos_tot_N = 0.0
       endif
       vardesc_temp = vardesc("sed_p_det_sedi_sed_atmos_ship_N","detritus sedimentation; sub-process for atmos_ship nitrogen",'h','1','s','mol m-2 d-1','f')
       ergom%id_sed_p_det_sedi_sed_atmos_ship_N = register_diag_field(package_name, vardesc_temp%name, axes(1:3),&
            init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
       if (ergom%id_p_det_sedi_sed_atmos_ship_N .gt. 0) then
         allocate(ergom%sed_p_det_sedi_sed_atmos_ship_N(isd:ied,jsd:jed,nk))
         ergom%p_det_sedi_sed_atmos_ship_N = 0.0
       endif
       vardesc_temp = vardesc("sed_p_pocn_sedi_sed_atmos_ship_N","pocn sedimentation; sub-process for atmos_ship nitrogen",'h','1','s','mol m-2 d-1','f')
       ergom%id_sed_p_pocn_sedi_sed_atmos_ship_N = register_diag_field(package_name, vardesc_temp%name, axes(1:3),&
            init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
       if (ergom%id_p_pocn_sedi_sed_atmos_ship_N .gt. 0) then
         allocate(ergom%sed_p_pocn_sedi_sed_atmos_ship_N(isd:ied,jsd:jed,nk))
         ergom%p_pocn_sedi_sed_atmos_ship_N = 0.0
       endif
       vardesc_temp = vardesc("sed_p_sed_burial_atmos_ship_N","burial of detritus deeper than max_sed; sub-process for atmos_ship nitrogen",'h','1','s','mol m-2 d-1','f')
       ergom%id_sed_p_sed_burial_atmos_ship_N = register_diag_field(package_name, vardesc_temp%name, axes(1:3),&
            init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
       if (ergom%id_p_sed_burial_atmos_ship_N .gt. 0) then
         allocate(ergom%sed_p_sed_burial_atmos_ship_N(isd:ied,jsd:jed,nk))
         ergom%p_sed_burial_atmos_ship_N = 0.0
       endif
       vardesc_temp = vardesc("sed_p_pocn_burial_atmos_ship_N","burial of pocn deeper than max_sed; sub-process for atmos_ship nitrogen",'h','1','s','mol m-2 d-1','f')
       ergom%id_sed_p_pocn_burial_atmos_ship_N = register_diag_field(package_name, vardesc_temp%name, axes(1:3),&
            init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
       if (ergom%id_p_pocn_burial_atmos_ship_N .gt. 0) then
         allocate(ergom%sed_p_pocn_burial_atmos_ship_N(isd:ied,jsd:jed,nk))
         ergom%p_pocn_burial_atmos_ship_N = 0.0
       endif
    endif

    vardesc_temp = vardesc("temp_k         ","absolute temperature [K]",'h','1','s','1','f')
    ergom%id_temp_k          = register_diag_field(package_name, vardesc_temp%name, axes(1:3),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    if (ergom%id_temp_k          .gt. 0) then
      allocate(ergom%temp_k         (isd:ied,jsd:jed,nk))
      ergom%temp_k          = 0.0
    endif
    vardesc_temp = vardesc("o2_sat         ","oxygen saturation concentration [mol/kg]",'h','1','s','1','f')
    ergom%id_o2_sat          = register_diag_field(package_name, vardesc_temp%name, axes(1:3),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    if (ergom%id_o2_sat          .gt. 0) then
      allocate(ergom%o2_sat         (isd:ied,jsd:jed,nk))
      ergom%o2_sat          = 0.0
    endif
    vardesc_temp = vardesc("n2_sat         ","dissolved molecular nitrogen saturation concentration [mol/kg]",'h','1','s','1','f')
    ergom%id_n2_sat          = register_diag_field(package_name, vardesc_temp%name, axes(1:3),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    if (ergom%id_n2_sat          .gt. 0) then
      allocate(ergom%n2_sat         (isd:ied,jsd:jed,nk))
      ergom%n2_sat          = 0.0
    endif
    vardesc_temp = vardesc("solubility_n2  ","solubility of molecular nitrogen [mol/kg/Pa]",'h','1','s','1','f')
    ergom%id_solubility_n2   = register_diag_field(package_name, vardesc_temp%name, axes(1:3),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    if (ergom%id_solubility_n2   .gt. 0) then
      allocate(ergom%solubility_n2  (isd:ied,jsd:jed,nk))
      ergom%solubility_n2   = 0.0
    endif
    vardesc_temp = vardesc("temp_sq        ","square of positive temperature [C * C]",'h','1','s','1','f')
    ergom%id_temp_sq         = register_diag_field(package_name, vardesc_temp%name, axes(1:3),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    if (ergom%id_temp_sq         .gt. 0) then
      allocate(ergom%temp_sq        (isd:ied,jsd:jed,nk))
      ergom%temp_sq         = 0.0
    endif
    vardesc_temp = vardesc("zoo_eff        ","effectice zooplankton concentration assumed for mortality and respiration process [mol/kg]",'h','1','s','1','f')
    ergom%id_zoo_eff         = register_diag_field(package_name, vardesc_temp%name, axes(1:3),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    if (ergom%id_zoo_eff         .gt. 0) then
      allocate(ergom%zoo_eff        (isd:ied,jsd:jed,nk))
      ergom%zoo_eff         = 0.0
    endif
    vardesc_temp = vardesc("din            ","dissolved inorganic nitrogen [mol/kg]",'h','1','s','1','f')
    ergom%id_din             = register_diag_field(package_name, vardesc_temp%name, axes(1:3),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    if (ergom%id_din             .gt. 0) then
      allocate(ergom%din            (isd:ied,jsd:jed,nk))
      ergom%din             = 0.0
    endif
    vardesc_temp = vardesc("din_sq         ","squared DIN [mol2/kg2]",'h','1','s','1','f')
    ergom%id_din_sq          = register_diag_field(package_name, vardesc_temp%name, axes(1:3),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    if (ergom%id_din_sq          .gt. 0) then
      allocate(ergom%din_sq         (isd:ied,jsd:jed,nk))
      ergom%din_sq          = 0.0
    endif
    vardesc_temp = vardesc("po4_sq         ","squared phosphate [mol**2/kg**2]",'h','1','s','1','f')
    ergom%id_po4_sq          = register_diag_field(package_name, vardesc_temp%name, axes(1:3),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    if (ergom%id_po4_sq          .gt. 0) then
      allocate(ergom%po4_sq         (isd:ied,jsd:jed,nk))
      ergom%po4_sq          = 0.0
    endif
    vardesc_temp = vardesc("pp             ","total phytoplankton [mol/kg]",'h','1','s','1','f')
    ergom%id_pp              = register_diag_field(package_name, vardesc_temp%name, axes(1:3),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    if (ergom%id_pp              .gt. 0) then
      allocate(ergom%pp             (isd:ied,jsd:jed,nk))
      ergom%pp              = 0.0
    endif
    vardesc_temp = vardesc("lpp_plus_lpp0  ","large-cell phytoplankton plus seed concentration [mol/kg]",'h','1','s','1','f')
    ergom%id_lpp_plus_lpp0   = register_diag_field(package_name, vardesc_temp%name, axes(1:3),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    if (ergom%id_lpp_plus_lpp0   .gt. 0) then
      allocate(ergom%lpp_plus_lpp0  (isd:ied,jsd:jed,nk))
      ergom%lpp_plus_lpp0   = 0.0
    endif
    vardesc_temp = vardesc("spp_plus_spp0  ","small-cell phytoplankton plus seed concentration [mol/kg]",'h','1','s','1','f')
    ergom%id_spp_plus_spp0   = register_diag_field(package_name, vardesc_temp%name, axes(1:3),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    if (ergom%id_spp_plus_spp0   .gt. 0) then
      allocate(ergom%spp_plus_spp0  (isd:ied,jsd:jed,nk))
      ergom%spp_plus_spp0   = 0.0
    endif
    vardesc_temp = vardesc("cya_plus_cya0  ","diazotroph cyanobacteria plus seed concentration [mol/kg]",'h','1','s','1','f')
    ergom%id_cya_plus_cya0   = register_diag_field(package_name, vardesc_temp%name, axes(1:3),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    if (ergom%id_cya_plus_cya0   .gt. 0) then
      allocate(ergom%cya_plus_cya0  (isd:ied,jsd:jed,nk))
      ergom%cya_plus_cya0   = 0.0
    endif
    vardesc_temp = vardesc("food_zoo       ","suitable food for zooplankton (weighted with food preferences) [mol/kg]",'h','1','s','1','f')
    ergom%id_food_zoo        = register_diag_field(package_name, vardesc_temp%name, axes(1:3),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    if (ergom%id_food_zoo        .gt. 0) then
      allocate(ergom%food_zoo       (isd:ied,jsd:jed,nk))
      ergom%food_zoo        = 0.0
    endif
    vardesc_temp = vardesc("lim_light_lpp  ","light limitation factor for large-cell phytoplankton growth [1]",'h','1','s','1','f')
    ergom%id_lim_light_lpp   = register_diag_field(package_name, vardesc_temp%name, axes(1:3),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    if (ergom%id_lim_light_lpp   .gt. 0) then
      allocate(ergom%lim_light_lpp  (isd:ied,jsd:jed,nk))
      ergom%lim_light_lpp   = 0.0
    endif
    vardesc_temp = vardesc("lim_light_spp  ","light limitation factor for small-cell phytoplankton growth [1]",'h','1','s','1','f')
    ergom%id_lim_light_spp   = register_diag_field(package_name, vardesc_temp%name, axes(1:3),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    if (ergom%id_lim_light_spp   .gt. 0) then
      allocate(ergom%lim_light_spp  (isd:ied,jsd:jed,nk))
      ergom%lim_light_spp   = 0.0
    endif
    vardesc_temp = vardesc("lim_light_cya  ","light limitation factor for diazotroph cyanobacteria growth [1]",'h','1','s','1','f')
    ergom%id_lim_light_cya   = register_diag_field(package_name, vardesc_temp%name, axes(1:3),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    if (ergom%id_lim_light_cya   .gt. 0) then
      allocate(ergom%lim_light_cya  (isd:ied,jsd:jed,nk))
      ergom%lim_light_cya   = 0.0
    endif
    vardesc_temp = vardesc("lr_assim_lpp   ","growth rate of large-cell phytoplankton, limited by DIN, DIP, light and oxygen [1/day]",'h','1','s','1','f')
    ergom%id_lr_assim_lpp    = register_diag_field(package_name, vardesc_temp%name, axes(1:3),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    if (ergom%id_lr_assim_lpp    .gt. 0) then
      allocate(ergom%lr_assim_lpp   (isd:ied,jsd:jed,nk))
      ergom%lr_assim_lpp    = 0.0
    endif
    vardesc_temp = vardesc("lr_assim_lpp_doc","production rate of DOC by LPP",'h','1','s','1','f')
    ergom%id_lr_assim_lpp_doc = register_diag_field(package_name, vardesc_temp%name, axes(1:3),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    if (ergom%id_lr_assim_lpp_doc .gt. 0) then
      allocate(ergom%lr_assim_lpp_doc(isd:ied,jsd:jed,nk))
      ergom%lr_assim_lpp_doc = 0.0
    endif
    vardesc_temp = vardesc("lr_assim_spp_doc","production rate of POC by SPP",'h','1','s','1','f')
    ergom%id_lr_assim_spp_doc = register_diag_field(package_name, vardesc_temp%name, axes(1:3),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    if (ergom%id_lr_assim_spp_doc .gt. 0) then
      allocate(ergom%lr_assim_spp_doc(isd:ied,jsd:jed,nk))
      ergom%lr_assim_spp_doc = 0.0
    endif
    vardesc_temp = vardesc("lr_assim_cya_doc","production rate of POC by CYA",'h','1','s','1','f')
    ergom%id_lr_assim_cya_doc = register_diag_field(package_name, vardesc_temp%name, axes(1:3),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    if (ergom%id_lr_assim_cya_doc .gt. 0) then
      allocate(ergom%lr_assim_cya_doc(isd:ied,jsd:jed,nk))
      ergom%lr_assim_cya_doc = 0.0
    endif
    vardesc_temp = vardesc("lr_assim_spp   ","growth rate of small-cell phytoplankton, limited by DIN, DIP, light, oxygen and temperature [1/day]",'h','1','s','1','f')
    ergom%id_lr_assim_spp    = register_diag_field(package_name, vardesc_temp%name, axes(1:3),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    if (ergom%id_lr_assim_spp    .gt. 0) then
      allocate(ergom%lr_assim_spp   (isd:ied,jsd:jed,nk))
      ergom%lr_assim_spp    = 0.0
    endif
    vardesc_temp = vardesc("lr_assim_cya   ","growth rate of diazotroph cyanobacteria, limited by DIP, light, oxygen, temperature and salinity [1/day]",'h','1','s','1','f')
    ergom%id_lr_assim_cya    = register_diag_field(package_name, vardesc_temp%name, axes(1:3),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    if (ergom%id_lr_assim_cya    .gt. 0) then
      allocate(ergom%lr_assim_cya   (isd:ied,jsd:jed,nk))
      ergom%lr_assim_cya    = 0.0
    endif
    vardesc_temp = vardesc("lr_assim_lpp_dop","production rate of POCP by LPP",'h','1','s','1','f')
    ergom%id_lr_assim_lpp_dop = register_diag_field(package_name, vardesc_temp%name, axes(1:3),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    if (ergom%id_lr_assim_lpp_dop .gt. 0) then
      allocate(ergom%lr_assim_lpp_dop(isd:ied,jsd:jed,nk))
      ergom%lr_assim_lpp_dop = 0.0
    endif
    vardesc_temp = vardesc("lr_assim_spp_dop","production rate of POCP by SPP",'h','1','s','1','f')
    ergom%id_lr_assim_spp_dop = register_diag_field(package_name, vardesc_temp%name, axes(1:3),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    if (ergom%id_lr_assim_spp_dop .gt. 0) then
      allocate(ergom%lr_assim_spp_dop(isd:ied,jsd:jed,nk))
      ergom%lr_assim_spp_dop = 0.0
    endif
    vardesc_temp = vardesc("lr_assim_lpp_don","production rate of POCN by LPP",'h','1','s','1','f')
    ergom%id_lr_assim_lpp_don = register_diag_field(package_name, vardesc_temp%name, axes(1:3),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    if (ergom%id_lr_assim_lpp_don .gt. 0) then
      allocate(ergom%lr_assim_lpp_don(isd:ied,jsd:jed,nk))
      ergom%lr_assim_lpp_don = 0.0
    endif
    vardesc_temp = vardesc("lr_assim_spp_don","production rate of POCN by SPP",'h','1','s','1','f')
    ergom%id_lr_assim_spp_don = register_diag_field(package_name, vardesc_temp%name, axes(1:3),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    if (ergom%id_lr_assim_spp_don .gt. 0) then
      allocate(ergom%lr_assim_spp_don(isd:ied,jsd:jed,nk))
      ergom%lr_assim_spp_don = 0.0
    endif
    vardesc_temp = vardesc("lr_graz_zoo    ","growth rate of zooplankton, limited by food, oxygen and temperature [1/day]",'h','1','s','1','f')
    ergom%id_lr_graz_zoo     = register_diag_field(package_name, vardesc_temp%name, axes(1:3),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    if (ergom%id_lr_graz_zoo     .gt. 0) then
      allocate(ergom%lr_graz_zoo    (isd:ied,jsd:jed,nk))
      ergom%lr_graz_zoo     = 0.0
    endif
    vardesc_temp = vardesc("frac_po4retent ","fraction of phosphate which is retained as iron-bound phosphate instead of being released after mineralization in the sediment [1]",'h','1','s','1','f')
    ergom%id_frac_po4retent  = register_diag_field(package_name, vardesc_temp%name, axes(1:3),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    if (ergom%id_frac_po4retent  .gt. 0) then
      allocate(ergom%frac_po4retent (isd:ied,jsd:jed,nk))
      ergom%frac_po4retent  = 0.0
    endif
    vardesc_temp = vardesc("ref_p_sw       ","modifies pocp recycling towards Refield ratio if PO4 is depleted",'h','1','s','1','f')
    ergom%id_ref_p_sw        = register_diag_field(package_name, vardesc_temp%name, axes(1:3),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    if (ergom%id_ref_p_sw        .gt. 0) then
      allocate(ergom%ref_p_sw       (isd:ied,jsd:jed,nk))
      ergom%ref_p_sw        = 0.0
    endif
    vardesc_temp = vardesc("ref_n_sw       ","modifies pocn recycling towards Refield ratio if DIN is depleted",'h','1','s','1','f')
    ergom%id_ref_n_sw        = register_diag_field(package_name, vardesc_temp%name, axes(1:3),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    if (ergom%id_ref_n_sw        .gt. 0) then
      allocate(ergom%ref_n_sw       (isd:ied,jsd:jed,nk))
      ergom%ref_n_sw        = 0.0
    endif
    vardesc_temp = vardesc("lr_pocp        ","add an additional POCP recycling if PO4 below Redfield but sufficient DIN",'h','1','s','1','f')
    ergom%id_lr_pocp         = register_diag_field(package_name, vardesc_temp%name, axes(1:3),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    if (ergom%id_lr_pocp         .gt. 0) then
      allocate(ergom%lr_pocp        (isd:ied,jsd:jed,nk))
      ergom%lr_pocp         = 0.0
    endif
    vardesc_temp = vardesc("lr_dop         ","add an additional DOP recycling if PO4 is below Redfield but sufficient DIN",'h','1','s','1','f')
    ergom%id_lr_dop          = register_diag_field(package_name, vardesc_temp%name, axes(1:3),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    if (ergom%id_lr_dop          .gt. 0) then
      allocate(ergom%lr_dop         (isd:ied,jsd:jed,nk))
      ergom%lr_dop          = 0.0
    endif
    vardesc_temp = vardesc("lr_pocn        ","add an additional POCN recycling if DIN below Redfield but sufficient PO4",'h','1','s','1','f')
    ergom%id_lr_pocn         = register_diag_field(package_name, vardesc_temp%name, axes(1:3),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    if (ergom%id_lr_pocn         .gt. 0) then
      allocate(ergom%lr_pocn        (isd:ied,jsd:jed,nk))
      ergom%lr_pocn         = 0.0
    endif
    vardesc_temp = vardesc("lr_don         ","add an additional DON recycling if DIN below Redfield but sufficient PO4",'h','1','s','1','f')
    ergom%id_lr_don          = register_diag_field(package_name, vardesc_temp%name, axes(1:3),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    if (ergom%id_lr_don          .gt. 0) then
      allocate(ergom%lr_don         (isd:ied,jsd:jed,nk))
      ergom%lr_don          = 0.0
    endif
    vardesc_temp = vardesc("w_poc_var      ","depth dependent POC sinking speed",'h','1','s','1','f')
    ergom%id_w_poc_var       = register_diag_field(package_name, vardesc_temp%name, axes(1:3),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    if (ergom%id_w_poc_var       .gt. 0) then
      allocate(ergom%w_poc_var      (isd:ied,jsd:jed,nk))
      ergom%w_poc_var       = 0.0
    endif
    vardesc_temp = vardesc("w_pocn_var     ","depth dependent POCN sinking speed",'h','1','s','1','f')
    ergom%id_w_pocn_var      = register_diag_field(package_name, vardesc_temp%name, axes(1:3),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    if (ergom%id_w_pocn_var      .gt. 0) then
      allocate(ergom%w_pocn_var     (isd:ied,jsd:jed,nk))
      ergom%w_pocn_var      = 0.0
    endif
    vardesc_temp = vardesc("w_pocp_var     ","depth dependent POCP sinking speed",'h','1','s','1','f')
    ergom%id_w_pocp_var      = register_diag_field(package_name, vardesc_temp%name, axes(1:3),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    if (ergom%id_w_pocp_var      .gt. 0) then
      allocate(ergom%w_pocp_var     (isd:ied,jsd:jed,nk))
      ergom%w_pocp_var      = 0.0
    endif

    vardesc_temp = vardesc("ph_temp        ","temporary value assumed for pH [1]",'h','1','s','1','f')
    ergom%id_ph_temp         = register_diag_field(package_name, vardesc_temp%name, axes(1:2),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    if (ergom%id_ph_temp         .gt. 0) then
      allocate(ergom%ph_temp        (isd:ied,jsd:jed))
      ergom%ph_temp         = 0.0
    endif
    vardesc_temp = vardesc("k_water        ","self-ionization constant of Water [mol2/kg2]",'h','1','s','1','f')
    ergom%id_k_water         = register_diag_field(package_name, vardesc_temp%name, axes(1:2),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    if (ergom%id_k_water         .gt. 0) then
      allocate(ergom%k_water        (isd:ied,jsd:jed))
      ergom%k_water         = 0.0
    endif
    vardesc_temp = vardesc("k0_co2         ","Solubility of CO2 [mol/kg/Pa]",'h','1','s','1','f')
    ergom%id_k0_co2          = register_diag_field(package_name, vardesc_temp%name, axes(1:2),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    if (ergom%id_k0_co2          .gt. 0) then
      allocate(ergom%k0_co2         (isd:ied,jsd:jed))
      ergom%k0_co2          = 0.0
    endif
    vardesc_temp = vardesc("k1_co2         ","Acid dissociation constant CO2 + 2 H2O <-> HCO3- + H3O+ [mol/kg]",'h','1','s','1','f')
    ergom%id_k1_co2          = register_diag_field(package_name, vardesc_temp%name, axes(1:2),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    if (ergom%id_k1_co2          .gt. 0) then
      allocate(ergom%k1_co2         (isd:ied,jsd:jed))
      ergom%k1_co2          = 0.0
    endif
    vardesc_temp = vardesc("k2_co2         ","Acid dissociation constant HCO3- + H2O <-> [CO3 2-] + H3O+ [mol/kg]",'h','1','s','1','f')
    ergom%id_k2_co2          = register_diag_field(package_name, vardesc_temp%name, axes(1:2),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    if (ergom%id_k2_co2          .gt. 0) then
      allocate(ergom%k2_co2         (isd:ied,jsd:jed))
      ergom%k2_co2          = 0.0
    endif
    vardesc_temp = vardesc("k_boron        ","Acid dissociation constant of boric acid [mol/kg]",'h','1','s','1','f')
    ergom%id_k_boron         = register_diag_field(package_name, vardesc_temp%name, axes(1:2),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    if (ergom%id_k_boron         .gt. 0) then
      allocate(ergom%k_boron        (isd:ied,jsd:jed))
      ergom%k_boron         = 0.0
    endif
    vardesc_temp = vardesc("k1_po4         ","Acid dissociation constant H3PO4 + H2O <-> [H2PO4 -] + H3O+ [mol/kg]",'h','1','s','1','f')
    ergom%id_k1_po4          = register_diag_field(package_name, vardesc_temp%name, axes(1:2),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    if (ergom%id_k1_po4          .gt. 0) then
      allocate(ergom%k1_po4         (isd:ied,jsd:jed))
      ergom%k1_po4          = 0.0
    endif
    vardesc_temp = vardesc("k2_po4         ","Acid dissociation constant [H2PO4 -] + H2O+ <-> [HPO4 2-] + H3O+ [mol/kg]",'h','1','s','1','f')
    ergom%id_k2_po4          = register_diag_field(package_name, vardesc_temp%name, axes(1:2),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    if (ergom%id_k2_po4          .gt. 0) then
      allocate(ergom%k2_po4         (isd:ied,jsd:jed))
      ergom%k2_po4          = 0.0
    endif
    vardesc_temp = vardesc("k3_po4         ","Acid dissociation constant [HPO4 2-] + H2O <-> [PO4 3-] + H3O+ [mol/kg]",'h','1','s','1','f')
    ergom%id_k3_po4          = register_diag_field(package_name, vardesc_temp%name, axes(1:2),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    if (ergom%id_k3_po4          .gt. 0) then
      allocate(ergom%k3_po4         (isd:ied,jsd:jed))
      ergom%k3_po4          = 0.0
    endif
    vardesc_temp = vardesc("k1_h2s         ","Acid dissociation constant H2S + H2O <-> HS- + H3O+ [mol/kg]",'h','1','s','1','f')
    ergom%id_k1_h2s          = register_diag_field(package_name, vardesc_temp%name, axes(1:2),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    if (ergom%id_k1_h2s          .gt. 0) then
      allocate(ergom%k1_h2s         (isd:ied,jsd:jed))
      ergom%k1_h2s          = 0.0
    endif
    vardesc_temp = vardesc("boron_total    ","total concentration of boron [mol/kg]",'h','1','s','1','f')
    ergom%id_boron_total     = register_diag_field(package_name, vardesc_temp%name, axes(1:2),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    if (ergom%id_boron_total     .gt. 0) then
      allocate(ergom%boron_total    (isd:ied,jsd:jed))
      ergom%boron_total     = 0.0
    endif
    vardesc_temp = vardesc("alk_boron      ","boron alkalinity [mol/kg]",'h','1','s','1','f')
    ergom%id_alk_boron       = register_diag_field(package_name, vardesc_temp%name, axes(1:2),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    if (ergom%id_alk_boron       .gt. 0) then
      allocate(ergom%alk_boron      (isd:ied,jsd:jed))
      ergom%alk_boron       = 0.0
    endif
    vardesc_temp = vardesc("alk_h2s        ","hydrogen sulfide alkalinity [mol/kg]",'h','1','s','1','f')
    ergom%id_alk_h2s         = register_diag_field(package_name, vardesc_temp%name, axes(1:2),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    if (ergom%id_alk_h2s         .gt. 0) then
      allocate(ergom%alk_h2s        (isd:ied,jsd:jed))
      ergom%alk_h2s         = 0.0
    endif
    vardesc_temp = vardesc("alk_water      ","water alkalinity [mol/kg]",'h','1','s','1','f')
    ergom%id_alk_water       = register_diag_field(package_name, vardesc_temp%name, axes(1:2),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    if (ergom%id_alk_water       .gt. 0) then
      allocate(ergom%alk_water      (isd:ied,jsd:jed))
      ergom%alk_water       = 0.0
    endif
    vardesc_temp = vardesc("alk_po4_denominator","denominator in phosphate alkalinity formula [mol3/kg3]",'h','1','s','1','f')
    ergom%id_alk_po4_denominator = register_diag_field(package_name, vardesc_temp%name, axes(1:2),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    if (ergom%id_alk_po4_denominator .gt. 0) then
      allocate(ergom%alk_po4_denominator(isd:ied,jsd:jed))
      ergom%alk_po4_denominator = 0.0
    endif
    vardesc_temp = vardesc("alk_po4        ","phosphate alkalinity [mol/kg]",'h','1','s','1','f')
    ergom%id_alk_po4         = register_diag_field(package_name, vardesc_temp%name, axes(1:2),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    if (ergom%id_alk_po4         .gt. 0) then
      allocate(ergom%alk_po4        (isd:ied,jsd:jed))
      ergom%alk_po4         = 0.0
    endif
    vardesc_temp = vardesc("alk_co2_denominator","denominator in carbonate alkalinity formula [mol2/kg2]",'h','1','s','1','f')
    ergom%id_alk_co2_denominator = register_diag_field(package_name, vardesc_temp%name, axes(1:2),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    if (ergom%id_alk_co2_denominator .gt. 0) then
      allocate(ergom%alk_co2_denominator(isd:ied,jsd:jed))
      ergom%alk_co2_denominator = 0.0
    endif
    vardesc_temp = vardesc("alk_co2        ","carbonate alkalinity [mol/kg]",'h','1','s','1','f')
    ergom%id_alk_co2         = register_diag_field(package_name, vardesc_temp%name, axes(1:2),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    if (ergom%id_alk_co2         .gt. 0) then
      allocate(ergom%alk_co2        (isd:ied,jsd:jed))
      ergom%alk_co2         = 0.0
    endif
    vardesc_temp = vardesc("alk_residual   ","error in total alkalinity calculation at the assumed pH [mol/kg]",'h','1','s','1','f')
    ergom%id_alk_residual    = register_diag_field(package_name, vardesc_temp%name, axes(1:2),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    if (ergom%id_alk_residual    .gt. 0) then
      allocate(ergom%alk_residual   (isd:ied,jsd:jed))
      ergom%alk_residual    = 0.0
    endif
    vardesc_temp = vardesc("dalkp_dh3o     ","derivative of phosphate alkalinity with respect to h3o [1]",'h','1','s','1','f')
    ergom%id_dalkp_dh3o      = register_diag_field(package_name, vardesc_temp%name, axes(1:2),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    if (ergom%id_dalkp_dh3o      .gt. 0) then
      allocate(ergom%dalkp_dh3o     (isd:ied,jsd:jed))
      ergom%dalkp_dh3o      = 0.0
    endif
    vardesc_temp = vardesc("dalkc_dh3o     ","derivative of carbonate alkalinity with respect to h3o [1]",'h','1','s','1','f')
    ergom%id_dalkc_dh3o      = register_diag_field(package_name, vardesc_temp%name, axes(1:2),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    if (ergom%id_dalkc_dh3o      .gt. 0) then
      allocate(ergom%dalkc_dh3o     (isd:ied,jsd:jed))
      ergom%dalkc_dh3o      = 0.0
    endif
    vardesc_temp = vardesc("dalkresidual_dpH","derivative of residual_alk with respect to pH [mol/kg]",'h','1','s','1','f')
    ergom%id_dalkresidual_dpH = register_diag_field(package_name, vardesc_temp%name, axes(1:2),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    if (ergom%id_dalkresidual_dpH .gt. 0) then
      allocate(ergom%dalkresidual_dpH(isd:ied,jsd:jed))
      ergom%dalkresidual_dpH = 0.0
    endif
    vardesc_temp = vardesc("ph             ","newly determined pH value [1]",'h','1','s','1','f')
    ergom%id_ph              = register_diag_field(package_name, vardesc_temp%name, axes(1:2),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    if (ergom%id_ph              .gt. 0) then
      allocate(ergom%ph             (isd:ied,jsd:jed))
      ergom%ph              = 0.0
    endif
    vardesc_temp = vardesc("h3o            ","h3o ion concentration [mol/kg]",'h','1','s','1','f')
    ergom%id_h3o             = register_diag_field(package_name, vardesc_temp%name, axes(1:2),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    if (ergom%id_h3o             .gt. 0) then
      allocate(ergom%h3o            (isd:ied,jsd:jed))
      ergom%h3o             = 0.0
    endif
    vardesc_temp = vardesc("pco2           ","co2 partial pressure [Pa]",'h','1','s','1','f')
    ergom%id_pco2            = register_diag_field(package_name, vardesc_temp%name, axes(1:2),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    if (ergom%id_pco2            .gt. 0) then
      allocate(ergom%pco2           (isd:ied,jsd:jed))
      ergom%pco2            = 0.0
    endif
    vardesc_temp = vardesc("co2            ","CO2 concentration in the surface layer [mol/kg]",'h','1','s','1','f')
    ergom%id_co2             = register_diag_field(package_name, vardesc_temp%name, axes(1:2),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    if (ergom%id_co2             .gt. 0) then
      allocate(ergom%co2            (isd:ied,jsd:jed))
      ergom%co2             = 0.0
    endif
    vardesc_temp = vardesc("schmidtnumber_co2","Schmidt number for CO2 surface flux [1]",'h','1','s','1','f')
    ergom%id_schmidtnumber_co2 = register_diag_field(package_name, vardesc_temp%name, axes(1:2),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    if (ergom%id_schmidtnumber_co2 .gt. 0) then
      allocate(ergom%schmidtnumber_co2(isd:ied,jsd:jed))
      ergom%schmidtnumber_co2 = 0.0
    endif
    vardesc_temp = vardesc("frac_denit_sed ","fraction of ammonium that is immediately nitrified and denitrified after remineralization in oxic sediments",'h','1','s','1','f')
    ergom%id_frac_denit_sed  = register_diag_field(package_name, vardesc_temp%name, axes(1:2),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    if (ergom%id_frac_denit_sed  .gt. 0) then
      allocate(ergom%frac_denit_sed (isd:ied,jsd:jed))
      ergom%frac_denit_sed  = 0.0
    endif
    vardesc_temp = vardesc("solubility_o2  ","solubility of oxygen [mol/kg/Pa]",'h','1','s','1','f')
    ergom%id_solubility_o2   = register_diag_field(package_name, vardesc_temp%name, axes(1:2),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    if (ergom%id_solubility_o2   .gt. 0) then
      allocate(ergom%solubility_o2  (isd:ied,jsd:jed))
      ergom%solubility_o2   = 0.0
    endif
    vardesc_temp = vardesc("schmidtnumber_o2","Schmidt number for oxygen surface flux [1]",'h','1','s','1','f')
    ergom%id_schmidtnumber_o2 = register_diag_field(package_name, vardesc_temp%name, axes(1:2),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    if (ergom%id_schmidtnumber_o2 .gt. 0) then
      allocate(ergom%schmidtnumber_o2(isd:ied,jsd:jed))
      ergom%schmidtnumber_o2 = 0.0
    endif
    vardesc_temp = vardesc("schmidtnumber_n2","Schmidt number for nitrogen surface flux [1]",'h','1','s','1','f')
    ergom%id_schmidtnumber_n2 = register_diag_field(package_name, vardesc_temp%name, axes(1:2),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    if (ergom%id_schmidtnumber_n2 .gt. 0) then
      allocate(ergom%schmidtnumber_n2(isd:ied,jsd:jed))
      ergom%schmidtnumber_n2 = 0.0
    endif
    vardesc_temp = vardesc("sed_tot        ","total carbon in sediment layer [mol/m**2]",'h','1','s','1','f')
    ergom%id_sed_tot         = register_diag_field(package_name, vardesc_temp%name, axes(1:2),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    if (ergom%id_sed_tot         .gt. 0) then
      allocate(ergom%sed_tot        (isd:ied,jsd:jed))
      ergom%sed_tot         = 0.0
    endif
    vardesc_temp = vardesc("sed_tot_active ","total carbon in active sediment layer [mol/m**2]",'h','1','s','1','f')
    ergom%id_sed_tot_active  = register_diag_field(package_name, vardesc_temp%name, axes(1:2),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    if (ergom%id_sed_tot_active  .gt. 0) then
      allocate(ergom%sed_tot_active (isd:ied,jsd:jed))
      ergom%sed_tot_active  = 0.0
    endif
    vardesc_temp = vardesc("sed_active     ","detritus in active sediment layer [mol/m**2]",'h','1','s','1','f')
    ergom%id_sed_active      = register_diag_field(package_name, vardesc_temp%name, axes(1:2),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    if (ergom%id_sed_active      .gt. 0) then
      allocate(ergom%sed_active     (isd:ied,jsd:jed))
      ergom%sed_active      = 0.0
    endif
    vardesc_temp = vardesc("lr_sed_rec     ","recycling rate of sediment detritus, limited by oxygen [1/d]",'h','1','s','1','f')
    ergom%id_lr_sed_rec      = register_diag_field(package_name, vardesc_temp%name, axes(1:2),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    if (ergom%id_lr_sed_rec      .gt. 0) then
      allocate(ergom%lr_sed_rec     (isd:ied,jsd:jed))
      ergom%lr_sed_rec      = 0.0
    endif
    vardesc_temp = vardesc("ips_eff        ","effective concentration of iron phosphate in the sediment assumed for burial (enhanced burial above a threshold) [mol/m**2]",'h','1','s','1','f')
    ergom%id_ips_eff         = register_diag_field(package_name, vardesc_temp%name, axes(1:2),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    if (ergom%id_ips_eff         .gt. 0) then
      allocate(ergom%ips_eff        (isd:ied,jsd:jed))
      ergom%ips_eff         = 0.0
    endif
    vardesc_temp = vardesc("erosion_is_active","switch (1=erosion, 0=no erosion) which depends on the combined bottom stress of currents and waves",'h','1','s','1','f')
    ergom%id_erosion_is_active = register_diag_field(package_name, vardesc_temp%name, axes(1:2),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    if (ergom%id_erosion_is_active .gt. 0) then
      allocate(ergom%erosion_is_active(isd:ied,jsd:jed))
      ergom%erosion_is_active = 0.0
    endif
    vardesc_temp = vardesc("poc_active     ","poc in active sediment layer [mol/m**2]",'h','1','s','1','f')
    ergom%id_poc_active      = register_diag_field(package_name, vardesc_temp%name, axes(1:2),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    if (ergom%id_poc_active      .gt. 0) then
      allocate(ergom%poc_active     (isd:ied,jsd:jed))
      ergom%poc_active      = 0.0
    endif
    vardesc_temp = vardesc("pocn_active    ","pocn in active sediment layer [mol/m**2]",'h','1','s','1','f')
    ergom%id_pocn_active     = register_diag_field(package_name, vardesc_temp%name, axes(1:2),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    if (ergom%id_pocn_active     .gt. 0) then
      allocate(ergom%pocn_active    (isd:ied,jsd:jed))
      ergom%pocn_active     = 0.0
    endif
    vardesc_temp = vardesc("pocp_active    ","pocp in active sediment layer [mol/m**2]",'h','1','s','1','f')
    ergom%id_pocp_active     = register_diag_field(package_name, vardesc_temp%name, axes(1:2),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    if (ergom%id_pocp_active     .gt. 0) then
      allocate(ergom%pocp_active    (isd:ied,jsd:jed))
      ergom%pocp_active     = 0.0
    endif

    if (NUM_SEDIMENT_LAYERS .gt. 1) then
       vardesc_temp = vardesc("sed_temp_k         ","absolute temperature [K]",'h','1','s','1','f')
       ergom%id_sed_temp_k          = register_diag_field(package_name, vardesc_temp%name, axes(1:3),&
            init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
       if (ergom%id_sed_temp_k          .gt. 0) then
         allocate(ergom%sed_temp_k         (isd:ied,jsd:jed,nk))
         ergom%sed_temp_k          = 0.0
       endif
       vardesc_temp = vardesc("sed_o2_sat         ","oxygen saturation concentration [mol/kg]",'h','1','s','1','f')
       ergom%id_sed_o2_sat          = register_diag_field(package_name, vardesc_temp%name, axes(1:3),&
            init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
       if (ergom%id_sed_o2_sat          .gt. 0) then
         allocate(ergom%sed_o2_sat         (isd:ied,jsd:jed,nk))
         ergom%sed_o2_sat          = 0.0
       endif
       vardesc_temp = vardesc("sed_n2_sat         ","dissolved molecular nitrogen saturation concentration [mol/kg]",'h','1','s','1','f')
       ergom%id_sed_n2_sat          = register_diag_field(package_name, vardesc_temp%name, axes(1:3),&
            init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
       if (ergom%id_sed_n2_sat          .gt. 0) then
         allocate(ergom%sed_n2_sat         (isd:ied,jsd:jed,nk))
         ergom%sed_n2_sat          = 0.0
       endif
       vardesc_temp = vardesc("sed_solubility_n2  ","solubility of molecular nitrogen [mol/kg/Pa]",'h','1','s','1','f')
       ergom%id_sed_solubility_n2   = register_diag_field(package_name, vardesc_temp%name, axes(1:3),&
            init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
       if (ergom%id_sed_solubility_n2   .gt. 0) then
         allocate(ergom%sed_solubility_n2  (isd:ied,jsd:jed,nk))
         ergom%sed_solubility_n2   = 0.0
       endif
       vardesc_temp = vardesc("sed_temp_sq        ","square of positive temperature [C * C]",'h','1','s','1','f')
       ergom%id_sed_temp_sq         = register_diag_field(package_name, vardesc_temp%name, axes(1:3),&
            init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
       if (ergom%id_sed_temp_sq         .gt. 0) then
         allocate(ergom%sed_temp_sq        (isd:ied,jsd:jed,nk))
         ergom%sed_temp_sq         = 0.0
       endif
       vardesc_temp = vardesc("sed_zoo_eff        ","effectice zooplankton concentration assumed for mortality and respiration process [mol/kg]",'h','1','s','1','f')
       ergom%id_sed_zoo_eff         = register_diag_field(package_name, vardesc_temp%name, axes(1:3),&
            init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
       if (ergom%id_sed_zoo_eff         .gt. 0) then
         allocate(ergom%sed_zoo_eff        (isd:ied,jsd:jed,nk))
         ergom%sed_zoo_eff         = 0.0
       endif
       vardesc_temp = vardesc("sed_din            ","dissolved inorganic nitrogen [mol/kg]",'h','1','s','1','f')
       ergom%id_sed_din             = register_diag_field(package_name, vardesc_temp%name, axes(1:3),&
            init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
       if (ergom%id_sed_din             .gt. 0) then
         allocate(ergom%sed_din            (isd:ied,jsd:jed,nk))
         ergom%sed_din             = 0.0
       endif
       vardesc_temp = vardesc("sed_din_sq         ","squared DIN [mol2/kg2]",'h','1','s','1','f')
       ergom%id_sed_din_sq          = register_diag_field(package_name, vardesc_temp%name, axes(1:3),&
            init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
       if (ergom%id_sed_din_sq          .gt. 0) then
         allocate(ergom%sed_din_sq         (isd:ied,jsd:jed,nk))
         ergom%sed_din_sq          = 0.0
       endif
       vardesc_temp = vardesc("sed_po4_sq         ","squared phosphate [mol**2/kg**2]",'h','1','s','1','f')
       ergom%id_sed_po4_sq          = register_diag_field(package_name, vardesc_temp%name, axes(1:3),&
            init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
       if (ergom%id_sed_po4_sq          .gt. 0) then
         allocate(ergom%sed_po4_sq         (isd:ied,jsd:jed,nk))
         ergom%sed_po4_sq          = 0.0
       endif
       vardesc_temp = vardesc("sed_pp             ","total phytoplankton [mol/kg]",'h','1','s','1','f')
       ergom%id_sed_pp              = register_diag_field(package_name, vardesc_temp%name, axes(1:3),&
            init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
       if (ergom%id_sed_pp              .gt. 0) then
         allocate(ergom%sed_pp             (isd:ied,jsd:jed,nk))
         ergom%sed_pp              = 0.0
       endif
       vardesc_temp = vardesc("sed_lpp_plus_lpp0  ","large-cell phytoplankton plus seed concentration [mol/kg]",'h','1','s','1','f')
       ergom%id_sed_lpp_plus_lpp0   = register_diag_field(package_name, vardesc_temp%name, axes(1:3),&
            init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
       if (ergom%id_sed_lpp_plus_lpp0   .gt. 0) then
         allocate(ergom%sed_lpp_plus_lpp0  (isd:ied,jsd:jed,nk))
         ergom%sed_lpp_plus_lpp0   = 0.0
       endif
       vardesc_temp = vardesc("sed_spp_plus_spp0  ","small-cell phytoplankton plus seed concentration [mol/kg]",'h','1','s','1','f')
       ergom%id_sed_spp_plus_spp0   = register_diag_field(package_name, vardesc_temp%name, axes(1:3),&
            init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
       if (ergom%id_sed_spp_plus_spp0   .gt. 0) then
         allocate(ergom%sed_spp_plus_spp0  (isd:ied,jsd:jed,nk))
         ergom%sed_spp_plus_spp0   = 0.0
       endif
       vardesc_temp = vardesc("sed_cya_plus_cya0  ","diazotroph cyanobacteria plus seed concentration [mol/kg]",'h','1','s','1','f')
       ergom%id_sed_cya_plus_cya0   = register_diag_field(package_name, vardesc_temp%name, axes(1:3),&
            init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
       if (ergom%id_sed_cya_plus_cya0   .gt. 0) then
         allocate(ergom%sed_cya_plus_cya0  (isd:ied,jsd:jed,nk))
         ergom%sed_cya_plus_cya0   = 0.0
       endif
       vardesc_temp = vardesc("sed_food_zoo       ","suitable food for zooplankton (weighted with food preferences) [mol/kg]",'h','1','s','1','f')
       ergom%id_sed_food_zoo        = register_diag_field(package_name, vardesc_temp%name, axes(1:3),&
            init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
       if (ergom%id_sed_food_zoo        .gt. 0) then
         allocate(ergom%sed_food_zoo       (isd:ied,jsd:jed,nk))
         ergom%sed_food_zoo        = 0.0
       endif
       vardesc_temp = vardesc("sed_lim_light_lpp  ","light limitation factor for large-cell phytoplankton growth [1]",'h','1','s','1','f')
       ergom%id_sed_lim_light_lpp   = register_diag_field(package_name, vardesc_temp%name, axes(1:3),&
            init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
       if (ergom%id_sed_lim_light_lpp   .gt. 0) then
         allocate(ergom%sed_lim_light_lpp  (isd:ied,jsd:jed,nk))
         ergom%sed_lim_light_lpp   = 0.0
       endif
       vardesc_temp = vardesc("sed_lim_light_spp  ","light limitation factor for small-cell phytoplankton growth [1]",'h','1','s','1','f')
       ergom%id_sed_lim_light_spp   = register_diag_field(package_name, vardesc_temp%name, axes(1:3),&
            init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
       if (ergom%id_sed_lim_light_spp   .gt. 0) then
         allocate(ergom%sed_lim_light_spp  (isd:ied,jsd:jed,nk))
         ergom%sed_lim_light_spp   = 0.0
       endif
       vardesc_temp = vardesc("sed_lim_light_cya  ","light limitation factor for diazotroph cyanobacteria growth [1]",'h','1','s','1','f')
       ergom%id_sed_lim_light_cya   = register_diag_field(package_name, vardesc_temp%name, axes(1:3),&
            init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
       if (ergom%id_sed_lim_light_cya   .gt. 0) then
         allocate(ergom%sed_lim_light_cya  (isd:ied,jsd:jed,nk))
         ergom%sed_lim_light_cya   = 0.0
       endif
       vardesc_temp = vardesc("sed_lr_assim_lpp   ","growth rate of large-cell phytoplankton, limited by DIN, DIP, light and oxygen [1/day]",'h','1','s','1','f')
       ergom%id_sed_lr_assim_lpp    = register_diag_field(package_name, vardesc_temp%name, axes(1:3),&
            init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
       if (ergom%id_sed_lr_assim_lpp    .gt. 0) then
         allocate(ergom%sed_lr_assim_lpp   (isd:ied,jsd:jed,nk))
         ergom%sed_lr_assim_lpp    = 0.0
       endif
       vardesc_temp = vardesc("sed_lr_assim_lpp_doc","production rate of DOC by LPP",'h','1','s','1','f')
       ergom%id_sed_lr_assim_lpp_doc = register_diag_field(package_name, vardesc_temp%name, axes(1:3),&
            init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
       if (ergom%id_sed_lr_assim_lpp_doc .gt. 0) then
         allocate(ergom%sed_lr_assim_lpp_doc(isd:ied,jsd:jed,nk))
         ergom%sed_lr_assim_lpp_doc = 0.0
       endif
       vardesc_temp = vardesc("sed_lr_assim_spp_doc","production rate of POC by SPP",'h','1','s','1','f')
       ergom%id_sed_lr_assim_spp_doc = register_diag_field(package_name, vardesc_temp%name, axes(1:3),&
            init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
       if (ergom%id_sed_lr_assim_spp_doc .gt. 0) then
         allocate(ergom%sed_lr_assim_spp_doc(isd:ied,jsd:jed,nk))
         ergom%sed_lr_assim_spp_doc = 0.0
       endif
       vardesc_temp = vardesc("sed_lr_assim_cya_doc","production rate of POC by CYA",'h','1','s','1','f')
       ergom%id_sed_lr_assim_cya_doc = register_diag_field(package_name, vardesc_temp%name, axes(1:3),&
            init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
       if (ergom%id_sed_lr_assim_cya_doc .gt. 0) then
         allocate(ergom%sed_lr_assim_cya_doc(isd:ied,jsd:jed,nk))
         ergom%sed_lr_assim_cya_doc = 0.0
       endif
       vardesc_temp = vardesc("sed_lr_assim_spp   ","growth rate of small-cell phytoplankton, limited by DIN, DIP, light, oxygen and temperature [1/day]",'h','1','s','1','f')
       ergom%id_sed_lr_assim_spp    = register_diag_field(package_name, vardesc_temp%name, axes(1:3),&
            init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
       if (ergom%id_sed_lr_assim_spp    .gt. 0) then
         allocate(ergom%sed_lr_assim_spp   (isd:ied,jsd:jed,nk))
         ergom%sed_lr_assim_spp    = 0.0
       endif
       vardesc_temp = vardesc("sed_lr_assim_cya   ","growth rate of diazotroph cyanobacteria, limited by DIP, light, oxygen, temperature and salinity [1/day]",'h','1','s','1','f')
       ergom%id_sed_lr_assim_cya    = register_diag_field(package_name, vardesc_temp%name, axes(1:3),&
            init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
       if (ergom%id_sed_lr_assim_cya    .gt. 0) then
         allocate(ergom%sed_lr_assim_cya   (isd:ied,jsd:jed,nk))
         ergom%sed_lr_assim_cya    = 0.0
       endif
       vardesc_temp = vardesc("sed_lr_assim_lpp_dop","production rate of POCP by LPP",'h','1','s','1','f')
       ergom%id_sed_lr_assim_lpp_dop = register_diag_field(package_name, vardesc_temp%name, axes(1:3),&
            init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
       if (ergom%id_sed_lr_assim_lpp_dop .gt. 0) then
         allocate(ergom%sed_lr_assim_lpp_dop(isd:ied,jsd:jed,nk))
         ergom%sed_lr_assim_lpp_dop = 0.0
       endif
       vardesc_temp = vardesc("sed_lr_assim_spp_dop","production rate of POCP by SPP",'h','1','s','1','f')
       ergom%id_sed_lr_assim_spp_dop = register_diag_field(package_name, vardesc_temp%name, axes(1:3),&
            init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
       if (ergom%id_sed_lr_assim_spp_dop .gt. 0) then
         allocate(ergom%sed_lr_assim_spp_dop(isd:ied,jsd:jed,nk))
         ergom%sed_lr_assim_spp_dop = 0.0
       endif
       vardesc_temp = vardesc("sed_lr_assim_lpp_don","production rate of POCN by LPP",'h','1','s','1','f')
       ergom%id_sed_lr_assim_lpp_don = register_diag_field(package_name, vardesc_temp%name, axes(1:3),&
            init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
       if (ergom%id_sed_lr_assim_lpp_don .gt. 0) then
         allocate(ergom%sed_lr_assim_lpp_don(isd:ied,jsd:jed,nk))
         ergom%sed_lr_assim_lpp_don = 0.0
       endif
       vardesc_temp = vardesc("sed_lr_assim_spp_don","production rate of POCN by SPP",'h','1','s','1','f')
       ergom%id_sed_lr_assim_spp_don = register_diag_field(package_name, vardesc_temp%name, axes(1:3),&
            init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
       if (ergom%id_sed_lr_assim_spp_don .gt. 0) then
         allocate(ergom%sed_lr_assim_spp_don(isd:ied,jsd:jed,nk))
         ergom%sed_lr_assim_spp_don = 0.0
       endif
       vardesc_temp = vardesc("sed_lr_graz_zoo    ","growth rate of zooplankton, limited by food, oxygen and temperature [1/day]",'h','1','s','1','f')
       ergom%id_sed_lr_graz_zoo     = register_diag_field(package_name, vardesc_temp%name, axes(1:3),&
            init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
       if (ergom%id_sed_lr_graz_zoo     .gt. 0) then
         allocate(ergom%sed_lr_graz_zoo    (isd:ied,jsd:jed,nk))
         ergom%sed_lr_graz_zoo     = 0.0
       endif
       vardesc_temp = vardesc("sed_frac_po4retent ","fraction of phosphate which is retained as iron-bound phosphate instead of being released after mineralization in the sediment [1]",'h','1','s','1','f')
       ergom%id_sed_frac_po4retent  = register_diag_field(package_name, vardesc_temp%name, axes(1:3),&
            init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
       if (ergom%id_sed_frac_po4retent  .gt. 0) then
         allocate(ergom%sed_frac_po4retent (isd:ied,jsd:jed,nk))
         ergom%sed_frac_po4retent  = 0.0
       endif
       vardesc_temp = vardesc("sed_ref_p_sw       ","modifies pocp recycling towards Refield ratio if PO4 is depleted",'h','1','s','1','f')
       ergom%id_sed_ref_p_sw        = register_diag_field(package_name, vardesc_temp%name, axes(1:3),&
            init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
       if (ergom%id_sed_ref_p_sw        .gt. 0) then
         allocate(ergom%sed_ref_p_sw       (isd:ied,jsd:jed,nk))
         ergom%sed_ref_p_sw        = 0.0
       endif
       vardesc_temp = vardesc("sed_ref_n_sw       ","modifies pocn recycling towards Refield ratio if DIN is depleted",'h','1','s','1','f')
       ergom%id_sed_ref_n_sw        = register_diag_field(package_name, vardesc_temp%name, axes(1:3),&
            init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
       if (ergom%id_sed_ref_n_sw        .gt. 0) then
         allocate(ergom%sed_ref_n_sw       (isd:ied,jsd:jed,nk))
         ergom%sed_ref_n_sw        = 0.0
       endif
       vardesc_temp = vardesc("sed_lr_pocp        ","add an additional POCP recycling if PO4 below Redfield but sufficient DIN",'h','1','s','1','f')
       ergom%id_sed_lr_pocp         = register_diag_field(package_name, vardesc_temp%name, axes(1:3),&
            init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
       if (ergom%id_sed_lr_pocp         .gt. 0) then
         allocate(ergom%sed_lr_pocp        (isd:ied,jsd:jed,nk))
         ergom%sed_lr_pocp         = 0.0
       endif
       vardesc_temp = vardesc("sed_lr_dop         ","add an additional DOP recycling if PO4 is below Redfield but sufficient DIN",'h','1','s','1','f')
       ergom%id_sed_lr_dop          = register_diag_field(package_name, vardesc_temp%name, axes(1:3),&
            init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
       if (ergom%id_sed_lr_dop          .gt. 0) then
         allocate(ergom%sed_lr_dop         (isd:ied,jsd:jed,nk))
         ergom%sed_lr_dop          = 0.0
       endif
       vardesc_temp = vardesc("sed_lr_pocn        ","add an additional POCN recycling if DIN below Redfield but sufficient PO4",'h','1','s','1','f')
       ergom%id_sed_lr_pocn         = register_diag_field(package_name, vardesc_temp%name, axes(1:3),&
            init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
       if (ergom%id_sed_lr_pocn         .gt. 0) then
         allocate(ergom%sed_lr_pocn        (isd:ied,jsd:jed,nk))
         ergom%sed_lr_pocn         = 0.0
       endif
       vardesc_temp = vardesc("sed_lr_don         ","add an additional DON recycling if DIN below Redfield but sufficient PO4",'h','1','s','1','f')
       ergom%id_sed_lr_don          = register_diag_field(package_name, vardesc_temp%name, axes(1:3),&
            init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
       if (ergom%id_sed_lr_don          .gt. 0) then
         allocate(ergom%sed_lr_don         (isd:ied,jsd:jed,nk))
         ergom%sed_lr_don          = 0.0
       endif
       vardesc_temp = vardesc("sed_w_poc_var      ","depth dependent POC sinking speed",'h','1','s','1','f')
       ergom%id_sed_w_poc_var       = register_diag_field(package_name, vardesc_temp%name, axes(1:3),&
            init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
       if (ergom%id_sed_w_poc_var       .gt. 0) then
         allocate(ergom%sed_w_poc_var      (isd:ied,jsd:jed,nk))
         ergom%sed_w_poc_var       = 0.0
       endif
       vardesc_temp = vardesc("sed_w_pocn_var     ","depth dependent POCN sinking speed",'h','1','s','1','f')
       ergom%id_sed_w_pocn_var      = register_diag_field(package_name, vardesc_temp%name, axes(1:3),&
            init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
       if (ergom%id_sed_w_pocn_var      .gt. 0) then
         allocate(ergom%sed_w_pocn_var     (isd:ied,jsd:jed,nk))
         ergom%sed_w_pocn_var      = 0.0
       endif
       vardesc_temp = vardesc("sed_w_pocp_var     ","depth dependent POCP sinking speed",'h','1','s','1','f')
       ergom%id_sed_w_pocp_var      = register_diag_field(package_name, vardesc_temp%name, axes(1:3),&
            init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
       if (ergom%id_sed_w_pocp_var      .gt. 0) then
         allocate(ergom%sed_w_pocp_var     (isd:ied,jsd:jed,nk))
         ergom%sed_w_pocp_var      = 0.0
       endif

       vardesc_temp = vardesc("sed_ph_temp        ","temporary value assumed for pH [1]",'h','1','s','1','f')
       ergom%id_sed_ph_temp         = register_diag_field(package_name, vardesc_temp%name, axes(1:3),&
            init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
       if (ergom%id_sed_ph_temp         .gt. 0) then
         allocate(ergom%sed_ph_temp        (isd:ied,jsd:jed,nk))
         ergom%sed_ph_temp         = 0.0
       endif
       vardesc_temp = vardesc("sed_k_water        ","self-ionization constant of Water [mol2/kg2]",'h','1','s','1','f')
       ergom%id_sed_k_water         = register_diag_field(package_name, vardesc_temp%name, axes(1:3),&
            init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
       if (ergom%id_sed_k_water         .gt. 0) then
         allocate(ergom%sed_k_water        (isd:ied,jsd:jed,nk))
         ergom%sed_k_water         = 0.0
       endif
       vardesc_temp = vardesc("sed_k0_co2         ","Solubility of CO2 [mol/kg/Pa]",'h','1','s','1','f')
       ergom%id_sed_k0_co2          = register_diag_field(package_name, vardesc_temp%name, axes(1:3),&
            init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
       if (ergom%id_sed_k0_co2          .gt. 0) then
         allocate(ergom%sed_k0_co2         (isd:ied,jsd:jed,nk))
         ergom%sed_k0_co2          = 0.0
       endif
       vardesc_temp = vardesc("sed_k1_co2         ","Acid dissociation constant CO2 + 2 H2O <-> HCO3- + H3O+ [mol/kg]",'h','1','s','1','f')
       ergom%id_sed_k1_co2          = register_diag_field(package_name, vardesc_temp%name, axes(1:3),&
            init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
       if (ergom%id_sed_k1_co2          .gt. 0) then
         allocate(ergom%sed_k1_co2         (isd:ied,jsd:jed,nk))
         ergom%sed_k1_co2          = 0.0
       endif
       vardesc_temp = vardesc("sed_k2_co2         ","Acid dissociation constant HCO3- + H2O <-> [CO3 2-] + H3O+ [mol/kg]",'h','1','s','1','f')
       ergom%id_sed_k2_co2          = register_diag_field(package_name, vardesc_temp%name, axes(1:3),&
            init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
       if (ergom%id_sed_k2_co2          .gt. 0) then
         allocate(ergom%sed_k2_co2         (isd:ied,jsd:jed,nk))
         ergom%sed_k2_co2          = 0.0
       endif
       vardesc_temp = vardesc("sed_k_boron        ","Acid dissociation constant of boric acid [mol/kg]",'h','1','s','1','f')
       ergom%id_sed_k_boron         = register_diag_field(package_name, vardesc_temp%name, axes(1:3),&
            init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
       if (ergom%id_sed_k_boron         .gt. 0) then
         allocate(ergom%sed_k_boron        (isd:ied,jsd:jed,nk))
         ergom%sed_k_boron         = 0.0
       endif
       vardesc_temp = vardesc("sed_k1_po4         ","Acid dissociation constant H3PO4 + H2O <-> [H2PO4 -] + H3O+ [mol/kg]",'h','1','s','1','f')
       ergom%id_sed_k1_po4          = register_diag_field(package_name, vardesc_temp%name, axes(1:3),&
            init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
       if (ergom%id_sed_k1_po4          .gt. 0) then
         allocate(ergom%sed_k1_po4         (isd:ied,jsd:jed,nk))
         ergom%sed_k1_po4          = 0.0
       endif
       vardesc_temp = vardesc("sed_k2_po4         ","Acid dissociation constant [H2PO4 -] + H2O+ <-> [HPO4 2-] + H3O+ [mol/kg]",'h','1','s','1','f')
       ergom%id_sed_k2_po4          = register_diag_field(package_name, vardesc_temp%name, axes(1:3),&
            init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
       if (ergom%id_sed_k2_po4          .gt. 0) then
         allocate(ergom%sed_k2_po4         (isd:ied,jsd:jed,nk))
         ergom%sed_k2_po4          = 0.0
       endif
       vardesc_temp = vardesc("sed_k3_po4         ","Acid dissociation constant [HPO4 2-] + H2O <-> [PO4 3-] + H3O+ [mol/kg]",'h','1','s','1','f')
       ergom%id_sed_k3_po4          = register_diag_field(package_name, vardesc_temp%name, axes(1:3),&
            init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
       if (ergom%id_sed_k3_po4          .gt. 0) then
         allocate(ergom%sed_k3_po4         (isd:ied,jsd:jed,nk))
         ergom%sed_k3_po4          = 0.0
       endif
       vardesc_temp = vardesc("sed_k1_h2s         ","Acid dissociation constant H2S + H2O <-> HS- + H3O+ [mol/kg]",'h','1','s','1','f')
       ergom%id_sed_k1_h2s          = register_diag_field(package_name, vardesc_temp%name, axes(1:3),&
            init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
       if (ergom%id_sed_k1_h2s          .gt. 0) then
         allocate(ergom%sed_k1_h2s         (isd:ied,jsd:jed,nk))
         ergom%sed_k1_h2s          = 0.0
       endif
       vardesc_temp = vardesc("sed_boron_total    ","total concentration of boron [mol/kg]",'h','1','s','1','f')
       ergom%id_sed_boron_total     = register_diag_field(package_name, vardesc_temp%name, axes(1:3),&
            init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
       if (ergom%id_sed_boron_total     .gt. 0) then
         allocate(ergom%sed_boron_total    (isd:ied,jsd:jed,nk))
         ergom%sed_boron_total     = 0.0
       endif
       vardesc_temp = vardesc("sed_alk_boron      ","boron alkalinity [mol/kg]",'h','1','s','1','f')
       ergom%id_sed_alk_boron       = register_diag_field(package_name, vardesc_temp%name, axes(1:3),&
            init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
       if (ergom%id_sed_alk_boron       .gt. 0) then
         allocate(ergom%sed_alk_boron      (isd:ied,jsd:jed,nk))
         ergom%sed_alk_boron       = 0.0
       endif
       vardesc_temp = vardesc("sed_alk_h2s        ","hydrogen sulfide alkalinity [mol/kg]",'h','1','s','1','f')
       ergom%id_sed_alk_h2s         = register_diag_field(package_name, vardesc_temp%name, axes(1:3),&
            init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
       if (ergom%id_sed_alk_h2s         .gt. 0) then
         allocate(ergom%sed_alk_h2s        (isd:ied,jsd:jed,nk))
         ergom%sed_alk_h2s         = 0.0
       endif
       vardesc_temp = vardesc("sed_alk_water      ","water alkalinity [mol/kg]",'h','1','s','1','f')
       ergom%id_sed_alk_water       = register_diag_field(package_name, vardesc_temp%name, axes(1:3),&
            init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
       if (ergom%id_sed_alk_water       .gt. 0) then
         allocate(ergom%sed_alk_water      (isd:ied,jsd:jed,nk))
         ergom%sed_alk_water       = 0.0
       endif
       vardesc_temp = vardesc("sed_alk_po4_denominator","denominator in phosphate alkalinity formula [mol3/kg3]",'h','1','s','1','f')
       ergom%id_sed_alk_po4_denominator = register_diag_field(package_name, vardesc_temp%name, axes(1:3),&
            init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
       if (ergom%id_sed_alk_po4_denominator .gt. 0) then
         allocate(ergom%sed_alk_po4_denominator(isd:ied,jsd:jed,nk))
         ergom%sed_alk_po4_denominator = 0.0
       endif
       vardesc_temp = vardesc("sed_alk_po4        ","phosphate alkalinity [mol/kg]",'h','1','s','1','f')
       ergom%id_sed_alk_po4         = register_diag_field(package_name, vardesc_temp%name, axes(1:3),&
            init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
       if (ergom%id_sed_alk_po4         .gt. 0) then
         allocate(ergom%sed_alk_po4        (isd:ied,jsd:jed,nk))
         ergom%sed_alk_po4         = 0.0
       endif
       vardesc_temp = vardesc("sed_alk_co2_denominator","denominator in carbonate alkalinity formula [mol2/kg2]",'h','1','s','1','f')
       ergom%id_sed_alk_co2_denominator = register_diag_field(package_name, vardesc_temp%name, axes(1:3),&
            init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
       if (ergom%id_sed_alk_co2_denominator .gt. 0) then
         allocate(ergom%sed_alk_co2_denominator(isd:ied,jsd:jed,nk))
         ergom%sed_alk_co2_denominator = 0.0
       endif
       vardesc_temp = vardesc("sed_alk_co2        ","carbonate alkalinity [mol/kg]",'h','1','s','1','f')
       ergom%id_sed_alk_co2         = register_diag_field(package_name, vardesc_temp%name, axes(1:3),&
            init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
       if (ergom%id_sed_alk_co2         .gt. 0) then
         allocate(ergom%sed_alk_co2        (isd:ied,jsd:jed,nk))
         ergom%sed_alk_co2         = 0.0
       endif
       vardesc_temp = vardesc("sed_alk_residual   ","error in total alkalinity calculation at the assumed pH [mol/kg]",'h','1','s','1','f')
       ergom%id_sed_alk_residual    = register_diag_field(package_name, vardesc_temp%name, axes(1:3),&
            init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
       if (ergom%id_sed_alk_residual    .gt. 0) then
         allocate(ergom%sed_alk_residual   (isd:ied,jsd:jed,nk))
         ergom%sed_alk_residual    = 0.0
       endif
       vardesc_temp = vardesc("sed_dalkp_dh3o     ","derivative of phosphate alkalinity with respect to h3o [1]",'h','1','s','1','f')
       ergom%id_sed_dalkp_dh3o      = register_diag_field(package_name, vardesc_temp%name, axes(1:3),&
            init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
       if (ergom%id_sed_dalkp_dh3o      .gt. 0) then
         allocate(ergom%sed_dalkp_dh3o     (isd:ied,jsd:jed,nk))
         ergom%sed_dalkp_dh3o      = 0.0
       endif
       vardesc_temp = vardesc("sed_dalkc_dh3o     ","derivative of carbonate alkalinity with respect to h3o [1]",'h','1','s','1','f')
       ergom%id_sed_dalkc_dh3o      = register_diag_field(package_name, vardesc_temp%name, axes(1:3),&
            init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
       if (ergom%id_sed_dalkc_dh3o      .gt. 0) then
         allocate(ergom%sed_dalkc_dh3o     (isd:ied,jsd:jed,nk))
         ergom%sed_dalkc_dh3o      = 0.0
       endif
       vardesc_temp = vardesc("sed_dalkresidual_dpH","derivative of residual_alk with respect to pH [mol/kg]",'h','1','s','1','f')
       ergom%id_sed_dalkresidual_dpH = register_diag_field(package_name, vardesc_temp%name, axes(1:3),&
            init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
       if (ergom%id_sed_dalkresidual_dpH .gt. 0) then
         allocate(ergom%sed_dalkresidual_dpH(isd:ied,jsd:jed,nk))
         ergom%sed_dalkresidual_dpH = 0.0
       endif
       vardesc_temp = vardesc("sed_ph             ","newly determined pH value [1]",'h','1','s','1','f')
       ergom%id_sed_ph              = register_diag_field(package_name, vardesc_temp%name, axes(1:3),&
            init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
       if (ergom%id_sed_ph              .gt. 0) then
         allocate(ergom%sed_ph             (isd:ied,jsd:jed,nk))
         ergom%sed_ph              = 0.0
       endif
       vardesc_temp = vardesc("sed_h3o            ","h3o ion concentration [mol/kg]",'h','1','s','1','f')
       ergom%id_sed_h3o             = register_diag_field(package_name, vardesc_temp%name, axes(1:3),&
            init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
       if (ergom%id_sed_h3o             .gt. 0) then
         allocate(ergom%sed_h3o            (isd:ied,jsd:jed,nk))
         ergom%sed_h3o             = 0.0
       endif
       vardesc_temp = vardesc("sed_pco2           ","co2 partial pressure [Pa]",'h','1','s','1','f')
       ergom%id_sed_pco2            = register_diag_field(package_name, vardesc_temp%name, axes(1:3),&
            init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
       if (ergom%id_sed_pco2            .gt. 0) then
         allocate(ergom%sed_pco2           (isd:ied,jsd:jed,nk))
         ergom%sed_pco2            = 0.0
       endif
       vardesc_temp = vardesc("sed_co2            ","CO2 concentration in the surface layer [mol/kg]",'h','1','s','1','f')
       ergom%id_sed_co2             = register_diag_field(package_name, vardesc_temp%name, axes(1:3),&
            init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
       if (ergom%id_sed_co2             .gt. 0) then
         allocate(ergom%sed_co2            (isd:ied,jsd:jed,nk))
         ergom%sed_co2             = 0.0
       endif
       vardesc_temp = vardesc("sed_schmidtnumber_co2","Schmidt number for CO2 surface flux [1]",'h','1','s','1','f')
       ergom%id_sed_schmidtnumber_co2 = register_diag_field(package_name, vardesc_temp%name, axes(1:3),&
            init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
       if (ergom%id_sed_schmidtnumber_co2 .gt. 0) then
         allocate(ergom%sed_schmidtnumber_co2(isd:ied,jsd:jed,nk))
         ergom%sed_schmidtnumber_co2 = 0.0
       endif
       vardesc_temp = vardesc("sed_frac_denit_sed ","fraction of ammonium that is immediately nitrified and denitrified after remineralization in oxic sediments",'h','1','s','1','f')
       ergom%id_sed_frac_denit_sed  = register_diag_field(package_name, vardesc_temp%name, axes(1:3),&
            init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
       if (ergom%id_sed_frac_denit_sed  .gt. 0) then
         allocate(ergom%sed_frac_denit_sed (isd:ied,jsd:jed,nk))
         ergom%sed_frac_denit_sed  = 0.0
       endif
       vardesc_temp = vardesc("sed_solubility_o2  ","solubility of oxygen [mol/kg/Pa]",'h','1','s','1','f')
       ergom%id_sed_solubility_o2   = register_diag_field(package_name, vardesc_temp%name, axes(1:3),&
            init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
       if (ergom%id_sed_solubility_o2   .gt. 0) then
         allocate(ergom%sed_solubility_o2  (isd:ied,jsd:jed,nk))
         ergom%sed_solubility_o2   = 0.0
       endif
       vardesc_temp = vardesc("sed_schmidtnumber_o2","Schmidt number for oxygen surface flux [1]",'h','1','s','1','f')
       ergom%id_sed_schmidtnumber_o2 = register_diag_field(package_name, vardesc_temp%name, axes(1:3),&
            init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
       if (ergom%id_sed_schmidtnumber_o2 .gt. 0) then
         allocate(ergom%sed_schmidtnumber_o2(isd:ied,jsd:jed,nk))
         ergom%sed_schmidtnumber_o2 = 0.0
       endif
       vardesc_temp = vardesc("sed_schmidtnumber_n2","Schmidt number for nitrogen surface flux [1]",'h','1','s','1','f')
       ergom%id_sed_schmidtnumber_n2 = register_diag_field(package_name, vardesc_temp%name, axes(1:3),&
            init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
       if (ergom%id_sed_schmidtnumber_n2 .gt. 0) then
         allocate(ergom%sed_schmidtnumber_n2(isd:ied,jsd:jed,nk))
         ergom%sed_schmidtnumber_n2 = 0.0
       endif
       vardesc_temp = vardesc("sed_sed_tot        ","total carbon in sediment layer [mol/m**2]",'h','1','s','1','f')
       ergom%id_sed_sed_tot         = register_diag_field(package_name, vardesc_temp%name, axes(1:3),&
            init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
       if (ergom%id_sed_sed_tot         .gt. 0) then
         allocate(ergom%sed_sed_tot        (isd:ied,jsd:jed,nk))
         ergom%sed_sed_tot         = 0.0
       endif
       vardesc_temp = vardesc("sed_sed_tot_active ","total carbon in active sediment layer [mol/m**2]",'h','1','s','1','f')
       ergom%id_sed_sed_tot_active  = register_diag_field(package_name, vardesc_temp%name, axes(1:3),&
            init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
       if (ergom%id_sed_sed_tot_active  .gt. 0) then
         allocate(ergom%sed_sed_tot_active (isd:ied,jsd:jed,nk))
         ergom%sed_sed_tot_active  = 0.0
       endif
       vardesc_temp = vardesc("sed_sed_active     ","detritus in active sediment layer [mol/m**2]",'h','1','s','1','f')
       ergom%id_sed_sed_active      = register_diag_field(package_name, vardesc_temp%name, axes(1:3),&
            init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
       if (ergom%id_sed_sed_active      .gt. 0) then
         allocate(ergom%sed_sed_active     (isd:ied,jsd:jed,nk))
         ergom%sed_sed_active      = 0.0
       endif
       vardesc_temp = vardesc("sed_lr_sed_rec     ","recycling rate of sediment detritus, limited by oxygen [1/d]",'h','1','s','1','f')
       ergom%id_sed_lr_sed_rec      = register_diag_field(package_name, vardesc_temp%name, axes(1:3),&
            init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
       if (ergom%id_sed_lr_sed_rec      .gt. 0) then
         allocate(ergom%sed_lr_sed_rec     (isd:ied,jsd:jed,nk))
         ergom%sed_lr_sed_rec      = 0.0
       endif
       vardesc_temp = vardesc("sed_ips_eff        ","effective concentration of iron phosphate in the sediment assumed for burial (enhanced burial above a threshold) [mol/m**2]",'h','1','s','1','f')
       ergom%id_sed_ips_eff         = register_diag_field(package_name, vardesc_temp%name, axes(1:3),&
            init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
       if (ergom%id_sed_ips_eff         .gt. 0) then
         allocate(ergom%sed_ips_eff        (isd:ied,jsd:jed,nk))
         ergom%sed_ips_eff         = 0.0
       endif
       vardesc_temp = vardesc("sed_erosion_is_active","switch (1=erosion, 0=no erosion) which depends on the combined bottom stress of currents and waves",'h','1','s','1','f')
       ergom%id_sed_erosion_is_active = register_diag_field(package_name, vardesc_temp%name, axes(1:3),&
            init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
       if (ergom%id_sed_erosion_is_active .gt. 0) then
         allocate(ergom%sed_erosion_is_active(isd:ied,jsd:jed,nk))
         ergom%sed_erosion_is_active = 0.0
       endif
       vardesc_temp = vardesc("sed_poc_active     ","poc in active sediment layer [mol/m**2]",'h','1','s','1','f')
       ergom%id_sed_poc_active      = register_diag_field(package_name, vardesc_temp%name, axes(1:3),&
            init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
       if (ergom%id_sed_poc_active      .gt. 0) then
         allocate(ergom%sed_poc_active     (isd:ied,jsd:jed,nk))
         ergom%sed_poc_active      = 0.0
       endif
       vardesc_temp = vardesc("sed_pocn_active    ","pocn in active sediment layer [mol/m**2]",'h','1','s','1','f')
       ergom%id_sed_pocn_active     = register_diag_field(package_name, vardesc_temp%name, axes(1:3),&
            init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
       if (ergom%id_sed_pocn_active     .gt. 0) then
         allocate(ergom%sed_pocn_active    (isd:ied,jsd:jed,nk))
         ergom%sed_pocn_active     = 0.0
       endif
       vardesc_temp = vardesc("sed_pocp_active    ","pocp in active sediment layer [mol/m**2]",'h','1','s','1','f')
       ergom%id_sed_pocp_active     = register_diag_field(package_name, vardesc_temp%name, axes(1:3),&
            init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
       if (ergom%id_sed_pocp_active     .gt. 0) then
         allocate(ergom%sed_pocp_active    (isd:ied,jsd:jed,nk))
         ergom%sed_pocp_active     = 0.0
       endif
    endif

    vardesc_temp = vardesc("dep_wet_t_nh4          ","Atmospheric deposition of ammonium to the ocean",'h','1','s','mol m-2 s-1','f')
    ergom%id_dep_wet_t_nh4           = register_diag_field(package_name, vardesc_temp%name, axes(1:2),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)

    vardesc_temp = vardesc("dep_wet_t_no3          ","Atmospheric deposition of nitrate to the ocean",'h','1','s','mol m-2 s-1','f')
    ergom%id_dep_wet_t_no3           = register_diag_field(package_name, vardesc_temp%name, axes(1:2),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)

    vardesc_temp = vardesc("dep_wet_t_po4          ","Atmospheric deposition of phosphate to the ocean",'h','1','s','mol m-2 s-1','f')
    ergom%id_dep_wet_t_po4           = register_diag_field(package_name, vardesc_temp%name, axes(1:2),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)

    vardesc_temp = vardesc("dep_wet_t_nh4_with_atmos_tot_N","Atmospheric deposition of ammonium; containing nitrogen from (total) atmospheric deposition to the ocean",'h','1','s','mol m-2 s-1','f')
    ergom%id_dep_wet_t_nh4_with_atmos_tot_N = register_diag_field(package_name, vardesc_temp%name, axes(1:2),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)

    vardesc_temp = vardesc("dep_wet_t_no3_with_atmos_tot_N","Atmospheric deposition of nitrate; containing nitrogen from (total) atmospheric deposition to the ocean",'h','1','s','mol m-2 s-1','f')
    ergom%id_dep_wet_t_no3_with_atmos_tot_N = register_diag_field(package_name, vardesc_temp%name, axes(1:2),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)

    vardesc_temp = vardesc("dep_wet_t_nh4_with_atmos_ship_N","Atmospheric deposition of ammonium; containing nitrogen from atmospheric deposition, which has been previously emitted by ships to the ocean",'h','1','s','mol m-2 s-1','f')
    ergom%id_dep_wet_t_nh4_with_atmos_ship_N = register_diag_field(package_name, vardesc_temp%name, axes(1:2),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)

    vardesc_temp = vardesc("dep_wet_t_no3_with_atmos_ship_N","Atmospheric deposition of nitrate; containing nitrogen from atmospheric deposition, which has been previously emitted by ships to the ocean",'h','1','s','mol m-2 s-1','f')
    ergom%id_dep_wet_t_no3_with_atmos_ship_N = register_diag_field(package_name, vardesc_temp%name, axes(1:2),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)

    vardesc_temp = vardesc("runoff_flux_t_o2           ","dissolved oxygen runoff flux to the ocean",'h','1','s','mol m-2 s-1','f')
    ergom%id_runoff_flux_t_o2            = register_diag_field(package_name, vardesc_temp%name, axes(1:2),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    vardesc_temp = vardesc("diffusive_flux_t_o2           ","dissolved oxygen diffusive flux from land to ocean",'h','1','s','mol m-2 s-1','f')
    ergom%id_diffusive_flux_t_o2            = register_diag_field(package_name, vardesc_temp%name, axes(1:2),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)

    vardesc_temp = vardesc("runoff_flux_t_dic          ","dissolved inorganic carbon, treated as carbon dioxide runoff flux to the ocean",'h','1','s','mol m-2 s-1','f')
    ergom%id_runoff_flux_t_dic           = register_diag_field(package_name, vardesc_temp%name, axes(1:2),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    vardesc_temp = vardesc("diffusive_flux_t_dic          ","dissolved inorganic carbon, treated as carbon dioxide diffusive flux from land to ocean",'h','1','s','mol m-2 s-1','f')
    ergom%id_diffusive_flux_t_dic           = register_diag_field(package_name, vardesc_temp%name, axes(1:2),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)

    vardesc_temp = vardesc("runoff_flux_t_nh4          ","ammonium runoff flux to the ocean",'h','1','s','mol m-2 s-1','f')
    ergom%id_runoff_flux_t_nh4           = register_diag_field(package_name, vardesc_temp%name, axes(1:2),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    vardesc_temp = vardesc("diffusive_flux_t_nh4          ","ammonium diffusive flux from land to ocean",'h','1','s','mol m-2 s-1','f')
    ergom%id_diffusive_flux_t_nh4           = register_diag_field(package_name, vardesc_temp%name, axes(1:2),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)

    vardesc_temp = vardesc("runoff_flux_t_no3          ","nitrate runoff flux to the ocean",'h','1','s','mol m-2 s-1','f')
    ergom%id_runoff_flux_t_no3           = register_diag_field(package_name, vardesc_temp%name, axes(1:2),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    vardesc_temp = vardesc("diffusive_flux_t_no3          ","nitrate diffusive flux from land to ocean",'h','1','s','mol m-2 s-1','f')
    ergom%id_diffusive_flux_t_no3           = register_diag_field(package_name, vardesc_temp%name, axes(1:2),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)

    vardesc_temp = vardesc("runoff_flux_t_po4          ","phosphate runoff flux to the ocean",'h','1','s','mol m-2 s-1','f')
    ergom%id_runoff_flux_t_po4           = register_diag_field(package_name, vardesc_temp%name, axes(1:2),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    vardesc_temp = vardesc("diffusive_flux_t_po4          ","phosphate diffusive flux from land to ocean",'h','1','s','mol m-2 s-1','f')
    ergom%id_diffusive_flux_t_po4           = register_diag_field(package_name, vardesc_temp%name, axes(1:2),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)

    vardesc_temp = vardesc("runoff_flux_t_alk          ","total alkalinity runoff flux to the ocean",'h','1','s','mol m-2 s-1','f')
    ergom%id_runoff_flux_t_alk           = register_diag_field(package_name, vardesc_temp%name, axes(1:2),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    vardesc_temp = vardesc("diffusive_flux_t_alk          ","total alkalinity diffusive flux from land to ocean",'h','1','s','mol m-2 s-1','f')
    ergom%id_diffusive_flux_t_alk           = register_diag_field(package_name, vardesc_temp%name, axes(1:2),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)

    vardesc_temp = vardesc("runoff_flux_t_det          ","detritus runoff flux to the ocean",'h','1','s','mol m-2 s-1','f')
    ergom%id_runoff_flux_t_det           = register_diag_field(package_name, vardesc_temp%name, axes(1:2),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    vardesc_temp = vardesc("diffusive_flux_t_det          ","detritus diffusive flux from land to ocean",'h','1','s','mol m-2 s-1','f')
    ergom%id_diffusive_flux_t_det           = register_diag_field(package_name, vardesc_temp%name, axes(1:2),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)


    vardesc_temp = vardesc("irr_inst","Instantaneous Light",'h','L','s','W m-2','f')
    ergom%id_irr_inst = register_diag_field(package_name, vardesc_temp%name, axes(1:3),&
         init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)

    call user_register_2d_tracers

  end subroutine generic_ERGOM_register_diag

  !
  !   This is an internal sub, not a public interface.
  !   Add all the parameters to be used in this module.
  !
  subroutine user_add_params

  !Specify all parameters used in this modules.
  !=============================================================================

  !Add the known experimental parameters used for calculations
  !in this module.
  !All the g_tracer_add_param calls must happen between
  !g_tracer_start_param_list and g_tracer_end_param_list  calls.
  !This implementation enables runtime overwrite via field_table.

    integer                      :: n
    character(len=fm_string_len) :: mystring
    call g_tracer_start_param_list(package_name)

    call g_tracer_add_param('gamma_1'  , ergom%gamma_1       , gamma_1   )
    call g_tracer_add_param('RHO_0'    , ergom%rho_0         , 1035.0   )

    call g_tracer_end_param_list(package_name)

  end subroutine user_add_params

  !
  !   This is an internal sub, not a public interface.
  !   Add all the tracers to be used in this module.
  !
  subroutine user_add_tracers(tracer_list)
    type(g_tracer_type), pointer :: tracer_list

    character(len=fm_string_len), parameter :: sub_name = 'user_add_tracers'
    integer                                 :: i, n
    character(len=fm_string_len)            :: mystring

    call g_tracer_start_param_list(package_name)
    call g_tracer_add_param('ice_restart_file'   , ergom%ice_restart_file   , 'ice_ergom.res.nc')
    call g_tracer_add_param('ocean_restart_file' , ergom%ocean_restart_file , 'ocean_ergom.res.nc' )
    call g_tracer_add_param('IC_file'            , ergom%IC_file       , '')
    call g_tracer_end_param_list(package_name)

    ! Set Restart files
    call g_tracer_set_files(ice_restart_file=ergom%ice_restart_file, ocean_restart_file=ergom%ocean_restart_file )

    !=====================================================
    !Specify all prognostic tracers of this modules.
    !=====================================================
    !User adds one call for each prognostic tracer below!
    !User should specify if fluxes must be extracted from boundary
    !by passing one or more of the following methods as .true.
    !and provide the corresponding parameters array
    !methods: flux_gas,flux_runoff,flux_wetdep,flux_drydep
    !
    !prog_tracers: nitrogen
    !diag_tracers: none
    !

    call user_init_2d_tracer_list

    call g_tracer_add(tracer_list,package_name,&
       name       = 't_det_with_atmos_ship_N',          &
       longname   = 'detritus; containing nitrogen from atmospheric deposition, which has been previously emitted by ships',   &
       const_init_value = 0.0, &
       flux_runoff= (0 > 0),  &
         flux_gas   = .false.,         &
       flux_wetdep= (0 > 0),  &
       flux_drydep= (0 > 0),  &
       flux_param = (/ 1.0 /),         &
       units      = 'mol/kg',          &
       prog       = .true. ,           &
       flux_bottom= implicit_bottomfluxes , &
       move_vertical = .true. ,        &
       diff_vertical = .true.)
    call g_tracer_add(tracer_list,package_name,&
       name       = 't_cya_with_atmos_ship_N',          &
       longname   = 'diazotroph cyanobacteria; containing nitrogen from atmospheric deposition, which has been previously emitted by ships',   &
       const_init_value = 0.0, &
       flux_runoff= (0 > 0),  &
         flux_gas   = .false.,         &
       flux_wetdep= (0 > 0),  &
       flux_drydep= (0 > 0),  &
       flux_param = (/ 1.0 /),         &
       units      = 'mol/kg',          &
       prog       = .true. ,           &
       flux_bottom= implicit_bottomfluxes , &
       move_vertical = .true. ,        &
       diff_vertical = .true.)
    call g_tracer_add(tracer_list,package_name,&
       name       = 't_don_with_atmos_ship_N',          &
       longname   = 'nitrogen in dissolved organic carbon in Redfield ratio; containing nitrogen from atmospheric deposition, which has been previously emitted by ships',   &
       const_init_value = 0.0, &
       flux_runoff= (0 > 0),  &
         flux_gas   = .false.,         &
       flux_wetdep= (0 > 0),  &
       flux_drydep= (0 > 0),  &
       flux_param = (/ 1.0 /),         &
       units      = 'mol/kg',          &
       prog       = .true. ,           &
       flux_bottom= implicit_bottomfluxes , &
       move_vertical = .true. ,        &
       diff_vertical = .true.)
    call g_tracer_add(tracer_list,package_name,&
       name       = 't_lpp_with_atmos_ship_N',          &
       longname   = 'large-cell phytoplankton; containing nitrogen from atmospheric deposition, which has been previously emitted by ships',   &
       const_init_value = 0.0, &
       flux_runoff= (0 > 0),  &
         flux_gas   = .false.,         &
       flux_wetdep= (0 > 0),  &
       flux_drydep= (0 > 0),  &
       flux_param = (/ 1.0 /),         &
       units      = 'mol/kg',          &
       prog       = .true. ,           &
       flux_bottom= implicit_bottomfluxes , &
       move_vertical = .true. ,        &
       diff_vertical = .true.)
    call g_tracer_add(tracer_list,package_name,&
       name       = 't_pocn_with_atmos_ship_N',          &
       longname   = 'nitrogen in particulate organic carbon in Redfield ratio; containing nitrogen from atmospheric deposition, which has been previously emitted by ships',   &
       const_init_value = 0.0, &
       flux_runoff= (0 > 0),  &
         flux_gas   = .false.,         &
       flux_wetdep= (0 > 0),  &
       flux_drydep= (0 > 0),  &
       flux_param = (/ 1.0 /),         &
       units      = 'mol/kg',          &
       prog       = .true. ,           &
       flux_bottom= implicit_bottomfluxes , &
       move_vertical = .true. ,        &
       diff_vertical = .true.)
    call g_tracer_add(tracer_list,package_name,&
       name       = 't_pocn         ',          &
       longname   = 'nitrogen in particulate organic carbon in Redfield ratio',   &
       const_init_value = 0.0, &
       flux_runoff= (0 > 0),  &
         flux_gas   = .false.,         &
       flux_wetdep= (0 > 0),  &
       flux_drydep= (0 > 0),  &
       flux_param = (/ 1.0 /),         &
       units      = 'mol/kg',          &
       prog       = .true. ,           &
       flux_bottom= implicit_bottomfluxes , &
       move_vertical = .true. ,        &
       diff_vertical = .true.)
    call g_tracer_add(tracer_list,package_name,&
       name       = 't_pocp         ',          &
       longname   = 'phosphorus in particulate organic carbon in Redfield ratio',   &
       const_init_value = 0.0, &
       flux_runoff= (0 > 0),  &
         flux_gas   = .false.,         &
       flux_wetdep= (0 > 0),  &
       flux_drydep= (0 > 0),  &
       flux_param = (/ 1.0 /),         &
       units      = 'mol/kg',          &
       prog       = .true. ,           &
       flux_bottom= implicit_bottomfluxes , &
       move_vertical = .true. ,        &
       diff_vertical = .true.)
    call g_tracer_add(tracer_list,package_name,&
       name       = 't_poc          ',          &
       longname   = 'particulate organic carbon',   &
       const_init_value = 0.0, &
       flux_runoff= (0 > 0),  &
         flux_gas   = .false.,         &
       flux_wetdep= (0 > 0),  &
       flux_drydep= (0 > 0),  &
       flux_param = (/ 1.0 /),         &
       units      = 'mol/kg',          &
       prog       = .true. ,           &
       flux_bottom= implicit_bottomfluxes , &
       move_vertical = .true. ,        &
       diff_vertical = .true.)
    call g_tracer_add(tracer_list,package_name,&
       name       = 't_det          ',          &
       longname   = 'detritus',   &
       flux_runoff= (1 > 0),  &
         flux_gas   = .false.,         &
       flux_wetdep= (0 > 0),  &
       flux_drydep= (1 > 0),  &
       flux_param = (/ 1.0 /),         &
       units      = 'mol/kg',          &
       prog       = .true. ,           &
       flux_bottom= implicit_bottomfluxes , &
       move_vertical = .true. ,        &
       diff_vertical = .true.)
    call g_tracer_add(tracer_list,package_name,&
       name       = 't_cya          ',          &
       longname   = 'diazotroph cyanobacteria',   &
       flux_runoff= (0 > 0),  &
         flux_gas   = .false.,         &
       flux_wetdep= (0 > 0),  &
       flux_drydep= (0 > 0),  &
       flux_param = (/ 1.0 /),         &
       units      = 'mol/kg',          &
       prog       = .true. ,           &
       flux_bottom= implicit_bottomfluxes , &
       move_vertical = .true. ,        &
       diff_vertical = .true.)
    call g_tracer_add(tracer_list,package_name,&
       name       = 't_don          ',          &
       longname   = 'nitrogen in dissolved organic carbon in Redfield ratio',   &
       const_init_value = 0.0, &
       flux_runoff= (0 > 0),  &
         flux_gas   = .false.,         &
       flux_wetdep= (0 > 0),  &
       flux_drydep= (0 > 0),  &
       flux_param = (/ 1.0 /),         &
       units      = 'mol/kg',          &
       prog       = .true. ,           &
       flux_bottom= implicit_bottomfluxes , &
       move_vertical = .true. ,        &
       diff_vertical = .true.)
    call g_tracer_add(tracer_list,package_name,&
       name       = 't_lpp          ',          &
       longname   = 'large-cell phytoplankton',   &
       flux_runoff= (0 > 0),  &
         flux_gas   = .false.,         &
       flux_wetdep= (0 > 0),  &
       flux_drydep= (0 > 0),  &
       flux_param = (/ 1.0 /),         &
       units      = 'mol/kg',          &
       prog       = .true. ,           &
       flux_bottom= implicit_bottomfluxes , &
       move_vertical = .true. ,        &
       diff_vertical = .true.)
    call g_tracer_add(tracer_list,package_name,&
       name       = 't_det_with_atmos_tot_N',          &
       longname   = 'detritus; containing nitrogen from (total) atmospheric deposition',   &
       const_init_value = 0.0, &
       flux_runoff= (0 > 0),  &
         flux_gas   = .false.,         &
       flux_wetdep= (0 > 0),  &
       flux_drydep= (0 > 0),  &
       flux_param = (/ 1.0 /),         &
       units      = 'mol/kg',          &
       prog       = .true. ,           &
       flux_bottom= implicit_bottomfluxes , &
       move_vertical = .true. ,        &
       diff_vertical = .true.)
    call g_tracer_add(tracer_list,package_name,&
       name       = 't_cya_with_atmos_tot_N',          &
       longname   = 'diazotroph cyanobacteria; containing nitrogen from (total) atmospheric deposition',   &
       const_init_value = 0.0, &
       flux_runoff= (0 > 0),  &
         flux_gas   = .false.,         &
       flux_wetdep= (0 > 0),  &
       flux_drydep= (0 > 0),  &
       flux_param = (/ 1.0 /),         &
       units      = 'mol/kg',          &
       prog       = .true. ,           &
       flux_bottom= implicit_bottomfluxes , &
       move_vertical = .true. ,        &
       diff_vertical = .true.)
    call g_tracer_add(tracer_list,package_name,&
       name       = 't_don_with_atmos_tot_N',          &
       longname   = 'nitrogen in dissolved organic carbon in Redfield ratio; containing nitrogen from (total) atmospheric deposition',   &
       const_init_value = 0.0, &
       flux_runoff= (0 > 0),  &
         flux_gas   = .false.,         &
       flux_wetdep= (0 > 0),  &
       flux_drydep= (0 > 0),  &
       flux_param = (/ 1.0 /),         &
       units      = 'mol/kg',          &
       prog       = .true. ,           &
       flux_bottom= implicit_bottomfluxes , &
       move_vertical = .true. ,        &
       diff_vertical = .true.)
    call g_tracer_add(tracer_list,package_name,&
       name       = 't_lpp_with_atmos_tot_N',          &
       longname   = 'large-cell phytoplankton; containing nitrogen from (total) atmospheric deposition',   &
       const_init_value = 0.0, &
       flux_runoff= (0 > 0),  &
         flux_gas   = .false.,         &
       flux_wetdep= (0 > 0),  &
       flux_drydep= (0 > 0),  &
       flux_param = (/ 1.0 /),         &
       units      = 'mol/kg',          &
       prog       = .true. ,           &
       flux_bottom= implicit_bottomfluxes , &
       move_vertical = .true. ,        &
       diff_vertical = .true.)
    call g_tracer_add(tracer_list,package_name,&
       name       = 't_pocn_with_atmos_tot_N',          &
       longname   = 'nitrogen in particulate organic carbon in Redfield ratio; containing nitrogen from (total) atmospheric deposition',   &
       const_init_value = 0.0, &
       flux_runoff= (0 > 0),  &
         flux_gas   = .false.,         &
       flux_wetdep= (0 > 0),  &
       flux_drydep= (0 > 0),  &
       flux_param = (/ 1.0 /),         &
       units      = 'mol/kg',          &
       prog       = .true. ,           &
       flux_bottom= implicit_bottomfluxes , &
       move_vertical = .true. ,        &
       diff_vertical = .true.)
    call g_tracer_add(tracer_list,package_name,&
       name       = 't_ipw          ',          &
       longname   = 'suspended iron phosphate',   &
       flux_runoff= (0 > 0),  &
         flux_gas   = .false.,         &
       flux_wetdep= (0 > 0),  &
       flux_drydep= (0 > 0),  &
       flux_param = (/ 1.0 /),         &
       units      = 'mol/kg',          &
       prog       = .true. ,           &
       flux_bottom= implicit_bottomfluxes , &
       move_vertical = .true. ,        &
       diff_vertical = .true.)
    call g_tracer_add(tracer_list,package_name,&
         name       = 't_zoo_with_atmos_ship_N',    &
         longname   = 'zooplankton; containing nitrogen from atmospheric deposition, which has been previously emitted by ships',      &
         const_init_value = 1.0e-20,     &
         units      = 'mol/kg',          &
         prog       = .true.,            &
         flux_gas   = .false.,           &
         flux_bottom= implicit_bottomfluxes,           &
         flux_runoff= (0 > 0),  &
         flux_param = (/ 1.0 /),         &
         flux_wetdep= (0 > 0),  &
         flux_drydep= (0 > 0),  &
         btm_reservoir=.false. )
    call g_tracer_add(tracer_list,package_name,&
         name       = 't_spp_with_atmos_ship_N',    &
         longname   = 'small-cell phytoplankton; containing nitrogen from atmospheric deposition, which has been previously emitted by ships',      &
         const_init_value = 1.0e-20,     &
         units      = 'mol/kg',          &
         prog       = .true.,            &
         flux_gas   = .false.,           &
         flux_bottom= implicit_bottomfluxes,           &
         flux_runoff= (0 > 0),  &
         flux_param = (/ 1.0 /),         &
         flux_wetdep= (0 > 0),  &
         flux_drydep= (0 > 0),  &
         btm_reservoir=.false. )
    call g_tracer_add(tracer_list,package_name,&
         name       = 't_no3_with_atmos_ship_N',    &
         longname   = 'nitrate; containing nitrogen from atmospheric deposition, which has been previously emitted by ships',      &
         const_init_value = 1.0e-20,     &
         units      = 'mol/kg',          &
         prog       = .true.,            &
         flux_gas   = .false.,           &
         flux_bottom= implicit_bottomfluxes,           &
         flux_runoff= (0 > 0),  &
         flux_param = (/ 1.0 /),         &
         flux_wetdep= (1 > 0),  &
         flux_drydep= (0 > 0),  &
         btm_reservoir=.false. )
    call g_tracer_add(tracer_list,package_name,&
         name       = 't_nh4_with_atmos_ship_N',    &
         longname   = 'ammonium; containing nitrogen from atmospheric deposition, which has been previously emitted by ships',      &
         const_init_value = 1.0e-20,     &
         units      = 'mol/kg',          &
         prog       = .true.,            &
         flux_gas   = .false.,           &
         flux_bottom= implicit_bottomfluxes,           &
         flux_runoff= (0 > 0),  &
         flux_param = (/ 1.0 /),         &
         flux_wetdep= (1 > 0),  &
         flux_drydep= (0 > 0),  &
         btm_reservoir=.false. )
    ! a comment to "flux_gas_param":
    ! The first term of flux_gas_param [s/m] describes the relation between (10m wind speed)**2 and gas transfer velocity:
    ! flux       = (csat-c) * sqrt(660/schmidt_number) * param1 * u10**2
    ! [mol/m2/s] = [mol/m3] * [1]                      * [s/m]  * [m2/s2]
    ! param1 = 8.61e-7 according to eqn. 3 in: Wannikhof (1992): Relationship between Wind Speed and Gas Exchange over the Ocean, JGR, 1997,
    ! Wannikhof (1992): Relationship between Wind Speed and Gas Exchange over the Ocean, JGR, Vol. 97, page 7376
    ! more recent Wanninkhof estimetes propose piston velocity by 0.24*U10*U10 
    call g_tracer_add(tracer_list,package_name,&
         name       = 't_n2_with_atmos_ship_N',    &
         longname   = 'dissolved molecular nitrogen; containing nitrogen from atmospheric deposition, which has been previously emitted by ships',      &
         const_init_value = 1.0e-20,     &
         units      = 'mol/kg',          &
         prog       = .true.,            &
         flux_gas   = implicit_surfacefluxes,        &
         flux_gas_name  = 't_n2_with_atmos_ship_N_flux',          &
         flux_gas_type  = 'air_sea_gas_flux_generic',&
         flux_gas_param = (/ 6.67e-07, 1.0 /),       &
         flux_gas_restart_file  = 'ocean_ergom_airsea_flux.res.nc', &
         flux_gas_molwt = 0.0, &
         flux_bottom= implicit_bottomfluxes,           &
         flux_runoff= (0 > 0),  &
         flux_param = (/ 1.0 /),         &
         flux_wetdep= (0 > 0),  &
         flux_drydep= (0 > 0),  &
         btm_reservoir=.false. )
    call g_tracer_add(tracer_list,package_name,&
         name       = 't_zoo_with_atmos_tot_N',    &
         longname   = 'zooplankton; containing nitrogen from (total) atmospheric deposition',      &
         const_init_value = 1.0e-20,     &
         units      = 'mol/kg',          &
         prog       = .true.,            &
         flux_gas   = .false.,           &
         flux_bottom= implicit_bottomfluxes,           &
         flux_runoff= (0 > 0),  &
         flux_param = (/ 1.0 /),         &
         flux_wetdep= (0 > 0),  &
         flux_drydep= (0 > 0),  &
         btm_reservoir=.false. )
    call g_tracer_add(tracer_list,package_name,&
         name       = 't_spp_with_atmos_tot_N',    &
         longname   = 'small-cell phytoplankton; containing nitrogen from (total) atmospheric deposition',      &
         const_init_value = 1.0e-20,     &
         units      = 'mol/kg',          &
         prog       = .true.,            &
         flux_gas   = .false.,           &
         flux_bottom= implicit_bottomfluxes,           &
         flux_runoff= (0 > 0),  &
         flux_param = (/ 1.0 /),         &
         flux_wetdep= (0 > 0),  &
         flux_drydep= (0 > 0),  &
         btm_reservoir=.false. )
    call g_tracer_add(tracer_list,package_name,&
         name       = 't_no3_with_atmos_tot_N',    &
         longname   = 'nitrate; containing nitrogen from (total) atmospheric deposition',      &
         const_init_value = 1.0e-20,     &
         units      = 'mol/kg',          &
         prog       = .true.,            &
         flux_gas   = .false.,           &
         flux_bottom= implicit_bottomfluxes,           &
         flux_runoff= (0 > 0),  &
         flux_param = (/ 1.0 /),         &
         flux_wetdep= (1 > 0),  &
         flux_drydep= (0 > 0),  &
         btm_reservoir=.false. )
    call g_tracer_add(tracer_list,package_name,&
         name       = 't_nh4_with_atmos_tot_N',    &
         longname   = 'ammonium; containing nitrogen from (total) atmospheric deposition',      &
         const_init_value = 1.0e-20,     &
         units      = 'mol/kg',          &
         prog       = .true.,            &
         flux_gas   = .false.,           &
         flux_bottom= implicit_bottomfluxes,           &
         flux_runoff= (0 > 0),  &
         flux_param = (/ 1.0 /),         &
         flux_wetdep= (1 > 0),  &
         flux_drydep= (0 > 0),  &
         btm_reservoir=.false. )
    ! a comment to "flux_gas_param":
    ! The first term of flux_gas_param [s/m] describes the relation between (10m wind speed)**2 and gas transfer velocity:
    ! flux       = (csat-c) * sqrt(660/schmidt_number) * param1 * u10**2
    ! [mol/m2/s] = [mol/m3] * [1]                      * [s/m]  * [m2/s2]
    ! param1 = 8.61e-7 according to eqn. 3 in: Wannikhof (1992): Relationship between Wind Speed and Gas Exchange over the Ocean, JGR, 1997,
    ! Wannikhof (1992): Relationship between Wind Speed and Gas Exchange over the Ocean, JGR, Vol. 97, page 7376
    ! more recent Wanninkhof estimetes propose piston velocity by 0.24*U10*U10 
    call g_tracer_add(tracer_list,package_name,&
         name       = 't_n2_with_atmos_tot_N',    &
         longname   = 'dissolved molecular nitrogen; containing nitrogen from (total) atmospheric deposition',      &
         const_init_value = 1.0e-20,     &
         units      = 'mol/kg',          &
         prog       = .true.,            &
         flux_gas   = implicit_surfacefluxes,        &
         flux_gas_name  = 't_n2_with_atmos_tot_N_flux',          &
         flux_gas_type  = 'air_sea_gas_flux_generic',&
         flux_gas_param = (/ 6.67e-07, 1.0 /),       &
         flux_gas_restart_file  = 'ocean_ergom_airsea_flux.res.nc', &
         flux_gas_molwt = 0.0, &
         flux_bottom= implicit_bottomfluxes,           &
         flux_runoff= (0 > 0),  &
         flux_param = (/ 1.0 /),         &
         flux_wetdep= (0 > 0),  &
         flux_drydep= (0 > 0),  &
         btm_reservoir=.false. )
    call g_tracer_add(tracer_list,package_name,&
         name       = 'total_atmos_ship_N',    &
         longname   = 'total_atmos_ship_N',      &
         const_init_value = 1.0e-20,     &
         units      = 'mol/kg',          &
         prog       = .true.,            &
         flux_gas   = .false.,           &
         flux_bottom= implicit_bottomfluxes,           &
         flux_runoff= (0 > 0),  &
         flux_param = (/ 1.0 /),         &
         flux_wetdep= (0 > 0),  &
         flux_drydep= (0 > 0),  &
         btm_reservoir=.false. )
    call g_tracer_add(tracer_list,package_name,&
         name       = 'total_atmos_tot_N',    &
         longname   = 'total_atmos_tot_N',      &
         const_init_value = 1.0e-20,     &
         units      = 'mol/kg',          &
         prog       = .true.,            &
         flux_gas   = .false.,           &
         flux_bottom= implicit_bottomfluxes,           &
         flux_runoff= (0 > 0),  &
         flux_param = (/ 1.0 /),         &
         flux_wetdep= (0 > 0),  &
         flux_drydep= (0 > 0),  &
         btm_reservoir=.false. )
    call g_tracer_add(tracer_list,package_name,&
         name       = 't_dop          ',    &
         longname   = 'phosphorus in dissolved organic carbon in Redfield ratio',      &
         const_init_value = 1.0e-20,     &
         units      = 'mol/kg',          &
         prog       = .true.,            &
         flux_gas   = .false.,           &
         flux_bottom= implicit_bottomfluxes,           &
         flux_runoff= (0 > 0),  &
         flux_param = (/ 1.0 /),         &
         flux_wetdep= (0 > 0),  &
         flux_drydep= (0 > 0),  &
         btm_reservoir=.false. )
    call g_tracer_add(tracer_list,package_name,&
         name       = 't_doc          ',    &
         longname   = 'dissolved organic carbon',      &
         const_init_value = 1.0e-20,     &
         units      = 'mol/kg',          &
         prog       = .true.,            &
         flux_gas   = .false.,           &
         flux_bottom= implicit_bottomfluxes,           &
         flux_runoff= (0 > 0),  &
         flux_param = (/ 1.0 /),         &
         flux_wetdep= (0 > 0),  &
         flux_drydep= (0 > 0),  &
         btm_reservoir=.false. )
    call g_tracer_add(tracer_list,package_name,&
         name       = 't_alk          ',    &
         longname   = 'total alkalinity',      &
         units      = 'mol/kg',          &
         prog       = .true.,            &
         flux_gas   = .false.,           &
         flux_bottom= implicit_bottomfluxes,           &
         flux_runoff= (1 > 0),  &
         flux_param = (/ 1.0 /),         &
         flux_wetdep= (0 > 0),  &
         flux_drydep= (1 > 0),  &
         btm_reservoir=.false. )
    call g_tracer_add(tracer_list,package_name,&
         name       = 't_sul          ',    &
         longname   = 'sulfur',      &
         const_init_value = 1.0e-20,     &
         units      = 'mol/kg',          &
         prog       = .true.,            &
         flux_gas   = .false.,           &
         flux_bottom= implicit_bottomfluxes,           &
         flux_runoff= (0 > 0),  &
         flux_param = (/ 1.0 /),         &
         flux_wetdep= (0 > 0),  &
         flux_drydep= (0 > 0),  &
         btm_reservoir=.false. )
    call g_tracer_add(tracer_list,package_name,&
         name       = 't_h2s          ',    &
         longname   = 'hydrogen sulfide',      &
         units      = 'mol/kg',          &
         prog       = .true.,            &
         flux_gas   = .false.,           &
         flux_bottom= implicit_bottomfluxes,           &
         flux_runoff= (0 > 0),  &
         flux_param = (/ 1.0 /),         &
         flux_wetdep= (0 > 0),  &
         flux_drydep= (0 > 0),  &
         btm_reservoir=.false. )
    call g_tracer_add(tracer_list,package_name,&
         name       = 't_zoo          ',    &
         longname   = 'zooplankton',      &
         units      = 'mol/kg',          &
         prog       = .true.,            &
         flux_gas   = .false.,           &
         flux_bottom= implicit_bottomfluxes,           &
         flux_runoff= (0 > 0),  &
         flux_param = (/ 1.0 /),         &
         flux_wetdep= (0 > 0),  &
         flux_drydep= (0 > 0),  &
         btm_reservoir=.false. )
    call g_tracer_add(tracer_list,package_name,&
         name       = 't_spp          ',    &
         longname   = 'small-cell phytoplankton',      &
         units      = 'mol/kg',          &
         prog       = .true.,            &
         flux_gas   = .false.,           &
         flux_bottom= implicit_bottomfluxes,           &
         flux_runoff= (0 > 0),  &
         flux_param = (/ 1.0 /),         &
         flux_wetdep= (0 > 0),  &
         flux_drydep= (0 > 0),  &
         btm_reservoir=.false. )
    call g_tracer_add(tracer_list,package_name,&
         name       = 't_po4          ',    &
         longname   = 'phosphate',      &
         units      = 'mol/kg',          &
         prog       = .true.,            &
         flux_gas   = .false.,           &
         flux_bottom= implicit_bottomfluxes,           &
         flux_runoff= (1 > 0),  &
         flux_param = (/ 1.0 /),         &
         flux_wetdep= (1 > 0),  &
         flux_drydep= (1 > 0),  &
         btm_reservoir=.false. )
    call g_tracer_add(tracer_list,package_name,&
         name       = 't_no3          ',    &
         longname   = 'nitrate',      &
         units      = 'mol/kg',          &
         prog       = .true.,            &
         flux_gas   = .false.,           &
         flux_bottom= implicit_bottomfluxes,           &
         flux_runoff= (1 > 0),  &
         flux_param = (/ 1.0 /),         &
         flux_wetdep= (1 > 0),  &
         flux_drydep= (1 > 0),  &
         btm_reservoir=.false. )
    call g_tracer_add(tracer_list,package_name,&
         name       = 't_nh4          ',    &
         longname   = 'ammonium',      &
         units      = 'mol/kg',          &
         prog       = .true.,            &
         flux_gas   = .false.,           &
         flux_bottom= implicit_bottomfluxes,           &
         flux_runoff= (1 > 0),  &
         flux_param = (/ 1.0 /),         &
         flux_wetdep= (1 > 0),  &
         flux_drydep= (1 > 0),  &
         btm_reservoir=.false. )
    ! a comment to "flux_gas_param":
    ! The first term of flux_gas_param [s/m] describes the relation between (10m wind speed)**2 and gas transfer velocity:
    ! flux       = (csat-c) * sqrt(660/schmidt_number) * param1 * u10**2
    ! [mol/m2/s] = [mol/m3] * [1]                      * [s/m]  * [m2/s2]
    ! param1 = 8.61e-7 according to eqn. 3 in: Wannikhof (1992): Relationship between Wind Speed and Gas Exchange over the Ocean, JGR, 1997,
    ! Wannikhof (1992): Relationship between Wind Speed and Gas Exchange over the Ocean, JGR, Vol. 97, page 7376
    ! more recent Wanninkhof estimetes propose piston velocity by 0.24*U10*U10 
    call g_tracer_add(tracer_list,package_name,&
         name       = 't_dic          ',    &
         longname   = 'dissolved inorganic carbon, treated as carbon dioxide',      &
         units      = 'mol/kg',          &
         prog       = .true.,            &
         flux_gas   = implicit_surfacefluxes,        &
         flux_gas_name  = 't_dic_flux',          &
         flux_gas_type  = 'air_sea_gas_flux_generic',&
         flux_gas_param = (/ 6.67e-07, 1.0 /),       &
         flux_gas_restart_file  = 'ocean_ergom_airsea_flux.res.nc', &
         flux_gas_molwt = 44.00995, &
         flux_bottom= implicit_bottomfluxes,           &
         flux_runoff= (1 > 0),  &
         flux_param = (/ 1.0 /),         &
         flux_wetdep= (0 > 0),  &
         flux_drydep= (1 > 0),  &
         btm_reservoir=.false. )
    ! a comment to "flux_gas_param":
    ! The first term of flux_gas_param [s/m] describes the relation between (10m wind speed)**2 and gas transfer velocity:
    ! flux       = (csat-c) * sqrt(660/schmidt_number) * param1 * u10**2
    ! [mol/m2/s] = [mol/m3] * [1]                      * [s/m]  * [m2/s2]
    ! param1 = 8.61e-7 according to eqn. 3 in: Wannikhof (1992): Relationship between Wind Speed and Gas Exchange over the Ocean, JGR, 1997,
    ! Wannikhof (1992): Relationship between Wind Speed and Gas Exchange over the Ocean, JGR, Vol. 97, page 7376
    ! more recent Wanninkhof estimetes propose piston velocity by 0.24*U10*U10 
    call g_tracer_add(tracer_list,package_name,&
         name       = 't_o2           ',    &
         longname   = 'dissolved oxygen',      &
         units      = 'mol/kg',          &
         prog       = .true.,            &
         flux_gas   = implicit_surfacefluxes,        &
         flux_gas_name  = 't_o2_flux',          &
         flux_gas_type  = 'air_sea_gas_flux_generic',&
         flux_gas_param = (/ 6.67e-07, 1.0 /),       &
         flux_gas_restart_file  = 'ocean_ergom_airsea_flux.res.nc', &
         flux_gas_molwt = 31.9988, &
         flux_bottom= implicit_bottomfluxes,           &
         flux_runoff= (1 > 0),  &
         flux_param = (/ 1.0 /),         &
         flux_wetdep= (0 > 0),  &
         flux_drydep= (1 > 0),  &
         btm_reservoir=.false. )
    ! a comment to "flux_gas_param":
    ! The first term of flux_gas_param [s/m] describes the relation between (10m wind speed)**2 and gas transfer velocity:
    ! flux       = (csat-c) * sqrt(660/schmidt_number) * param1 * u10**2
    ! [mol/m2/s] = [mol/m3] * [1]                      * [s/m]  * [m2/s2]
    ! param1 = 8.61e-7 according to eqn. 3 in: Wannikhof (1992): Relationship between Wind Speed and Gas Exchange over the Ocean, JGR, 1997,
    ! Wannikhof (1992): Relationship between Wind Speed and Gas Exchange over the Ocean, JGR, Vol. 97, page 7376
    ! more recent Wanninkhof estimetes propose piston velocity by 0.24*U10*U10 
    call g_tracer_add(tracer_list,package_name,&
         name       = 't_n2           ',    &
         longname   = 'dissolved molecular nitrogen',      &
         units      = 'mol/kg',          &
         prog       = .true.,            &
         flux_gas   = implicit_surfacefluxes,        &
         flux_gas_name  = 't_n2_flux',          &
         flux_gas_type  = 'air_sea_gas_flux_generic',&
         flux_gas_param = (/ 6.67e-07, 1.0 /),       &
         flux_gas_restart_file  = 'ocean_ergom_airsea_flux.res.nc', &
         flux_gas_molwt = 28.0134, &
         flux_bottom= implicit_bottomfluxes,           &
         flux_runoff= (0 > 0),  &
         flux_param = (/ 1.0 /),         &
         flux_wetdep= (0 > 0),  &
         flux_drydep= (0 > 0),  &
         btm_reservoir=.false. )

    if (NUM_SEDIMENT_LAYERS .eq. 1) then
       ! only one sediment layer exists (=fluffy layer), so try to store several sediment tracers in one
       ! 3-d diagnostic tracer
       call user_add_2d_tracer(tracer_list,    &
                               name       = 't_sed',  &
                               longname   = 'sediment detritus', &
                               units      = 'mol/m^2')
       call user_add_2d_tracer(tracer_list,    &
                               name       = 't_ips',  &
                               longname   = 'iron phosphate in sediment', &
                               units      = 'mol/m^2')
       call user_add_2d_tracer(tracer_list,    &
                               name       = 't_sed_poc',  &
                               longname   = 'sediment particular carbon', &
                               units      = 'mol/m^2')
       call user_add_2d_tracer(tracer_list,    &
                               name       = 't_sed_pocn',  &
                               longname   = 'sediment particular organic N+C', &
                               units      = 'mol/m^2')
       call user_add_2d_tracer(tracer_list,    &
                               name       = 't_sed_pocp',  &
                               longname   = 'sediment particular organic P+C', &
                               units      = 'mol/m^2')
       call user_add_2d_tracer(tracer_list,    &
                               name       = 'total_atmos_tot_N_at_bottom',  &
                               longname   = 'total_atmos_tot_N_at_bottom', &
                               units      = 'mol/m^2')
       call user_add_2d_tracer(tracer_list,    &
                               name       = 'total_atmos_ship_N_at_bottom',  &
                               longname   = 'total_atmos_ship_N_at_bottom', &
                               units      = 'mol/m^2')
       call user_add_2d_tracer(tracer_list,    &
                               name       = 't_sed_with_atmos_tot_N',  &
                               longname   = 'sediment detritus; containing nitrogen from (total) atmospheric deposition', &
                               units      = 'mol/m^2')
       call user_add_2d_tracer(tracer_list,    &
                               name       = 't_sed_pocn_with_atmos_tot_N',  &
                               longname   = 'sediment particular organic N+C; containing nitrogen from (total) atmospheric deposition', &
                               units      = 'mol/m^2')
       call user_add_2d_tracer(tracer_list,    &
                               name       = 't_sed_with_atmos_ship_N',  &
                               longname   = 'sediment detritus; containing nitrogen from atmospheric deposition, which has been previously emitted by ships', &
                               units      = 'mol/m^2')
       call user_add_2d_tracer(tracer_list,    &
                               name       = 't_sed_pocn_with_atmos_ship_N',  &
                               longname   = 'sediment particular organic N+C; containing nitrogen from atmospheric deposition, which has been previously emitted by ships', &
                               units      = 'mol/m^2')
    else
       ! several sediment layers exist (1=fluffy layer, 2..NUM_SEDIMENT_LAYERS=inside the sediment),
       ! so every sediment tracer gets its own 3-d diagnostic tracer
       call g_tracer_add(tracer_list,package_name,&
                         name       = 't_sed          ', &
                         longname   = 'sediment detritus', &
                         units      = 'mol m-2',     &
                         prog       = .false.                )
       call g_tracer_add(tracer_list,package_name,&
                         name       = 't_ips          ', &
                         longname   = 'iron phosphate in sediment', &
                         units      = 'mol m-2',     &
                         prog       = .false.                )
       call g_tracer_add(tracer_list,package_name,&
                         name       = 't_sed_poc      ', &
                         longname   = 'sediment particular carbon', &
                         units      = 'mol m-2',     &
                         prog       = .false.                )
       call g_tracer_add(tracer_list,package_name,&
                         name       = 't_sed_pocn     ', &
                         longname   = 'sediment particular organic N+C', &
                         units      = 'mol m-2',     &
                         prog       = .false.                )
       call g_tracer_add(tracer_list,package_name,&
                         name       = 't_sed_pocp     ', &
                         longname   = 'sediment particular organic P+C', &
                         units      = 'mol m-2',     &
                         prog       = .false.                )
       call g_tracer_add(tracer_list,package_name,&
                         name       = 'total_atmos_tot_N_at_bottom', &
                         longname   = 'total_atmos_tot_N_at_bottom', &
                         units      = 'mol m-2',     &
                         prog       = .false.                )
       call g_tracer_add(tracer_list,package_name,&
                         name       = 'total_atmos_ship_N_at_bottom', &
                         longname   = 'total_atmos_ship_N_at_bottom', &
                         units      = 'mol m-2',     &
                         prog       = .false.                )
       call g_tracer_add(tracer_list,package_name,&
                         name       = 't_sed_with_atmos_tot_N', &
                         longname   = 'sediment detritus; containing nitrogen from (total) atmospheric deposition', &
                         units      = 'mol m-2',     &
                         prog       = .false.                )
       call g_tracer_add(tracer_list,package_name,&
                         name       = 't_sed_pocn_with_atmos_tot_N', &
                         longname   = 'sediment particular organic N+C; containing nitrogen from (total) atmospheric deposition', &
                         units      = 'mol m-2',     &
                         prog       = .false.                )
       call g_tracer_add(tracer_list,package_name,&
                         name       = 't_sed_with_atmos_ship_N', &
                         longname   = 'sediment detritus; containing nitrogen from atmospheric deposition, which has been previously emitted by ships', &
                         units      = 'mol m-2',     &
                         prog       = .false.                )
       call g_tracer_add(tracer_list,package_name,&
                         name       = 't_sed_pocn_with_atmos_ship_N', &
                         longname   = 'sediment particular organic N+C; containing nitrogen from atmospheric deposition, which has been previously emitted by ships', &
                         units      = 'mol m-2',     &
                         prog       = .false.                )
       ! In this case, we need additional information about the sediment
       call g_tracer_add(tracer_list,package_name,&
                         name       = 'sed_cellheights', &
                         longname   = 'cell heights in the sediment', &
                         units      = 'm',     &
                         prog       = .false.                )
       call g_tracer_add(tracer_list,package_name,&
                         name       = 'sed_diffusivity_porewater', &
                         longname   = 'bioturbation-generated diffusivity for pore water species', &
                         units      = 'm2/s',     &
                         prog       = .false.                )
       call g_tracer_add(tracer_list,package_name,&
                         name       = 'sed_diffusivity_solids', &
                         longname   = 'bioturbation-generated diffusivity for solid species', &
                         units      = 'm2/s',     &
                         prog       = .false.                )
       call g_tracer_add(tracer_list,package_name,&
                         name       = 'sed_2d_params', &
                         longname   = 'sed_inert_deposition, temperature, salinity, bottomdepth, fluffy_layer_thickness, diffusive_layer_thickness', &
                         units      = 'm/s',     &
                         prog       = .false.            )
       call g_tracer_add(tracer_list,package_name,&
                         name       = 'sed_inert_ratio', &
                         longname   = 'volume fraction of bioinert material in the sediments', &
                         units      = '1.0',     &
                         prog       = .false.            )
    endif



   call g_tracer_add(tracer_list,package_name,&
         name       = 'chl',         &
         longname   = 'Chlorophyll', &
         units      = 'ug kg-1',     &
         prog       = .false.,       &
         const_init_value = 0.08           )

    call g_tracer_add(tracer_list,package_name,&
         name       = 'opacity_bio', &
         longname   = 'Opacity of water ingredients', &
         units      = 'm-1',     &
         prog       = .false.,       &
         const_init_value = 1.0e-20           )

    call g_tracer_add(tracer_list,package_name,&
         name       = 'opacity_water', &
         longname   = 'Opacity of pure water', &
         units      = 'm-1',     &
         prog       = .false.,       &
         const_init_value = gamma0           )

  end subroutine user_add_tracers

  !
  !   This is an internal sub, not a public interface.
  !   initialize the list of 2d tracers with a length of zero
  !
  subroutine user_init_2d_tracer_list
    character(len=fm_string_len), parameter :: sub_name = 'user_init_2d_tracer_list'
    allocate(tracers_2d(0))
  end subroutine user_init_2d_tracer_list
  !
  !   This is an internal sub, not a public interface.
  !   Insert a 2d tracer into the 2d tracer list
  !   2d tracers are stored  together in diagnostic 3d tracers.
  !   Those are registered for output and in the restart list.
  !
  subroutine user_add_2d_tracer(tracer_list,name,longname,units)
    type(g_tracer_type), pointer :: tracer_list
    character(len=*), intent(in) :: name, longname, units

    character(len=fm_string_len), parameter :: sub_name = 'user_add_2d_tracer'
    integer                      :: m, n, dummy
    character(len=fm_string_len) :: temp_string
    type(tracer_2d), ALLOCATABLE, dimension(:) :: temp_tracers_2d

    n  = size(tracers_2d)
    allocate(temp_tracers_2d(n))
    do m=1,n
      temp_tracers_2d(m)=tracers_2d(m)
    end do
    deallocate(tracers_2d)
    allocate(tracers_2d(n+1))
    do m=1,n
      tracers_2d(m)=temp_tracers_2d(m)
    end do
    deallocate(temp_tracers_2d)

    tracers_2d(n+1)%name     = trim(adjustl(name))
    tracers_2d(n+1)%longname = trim(adjustl(longname))
    tracers_2d(n+1)%units    = trim(adjustl(units))
    tracers_2d(n+1)%layer_in_3d_tracer = mod(n,vlev_sed)+1
    tracers_2d(n+1)%field_assigned     = .false.  ! whether a 2d field has been assigned

    m = n/vlev_sed+1
    write( temp_string, '(i4)' )  m; temp_string = adjustl(temp_string)
    tracers_2d(n+1)%name_of_3d_tracer = 'tracer_2d_'//trim(temp_string)
    if (mod(n,vlev_sed) .eq. 0) then
      call g_tracer_add(tracer_list,package_name,                              &
         name       = 'tracer_2d_'//trim(temp_string),                         &
         longname   = 'Tracer '//trim(temp_string)//' containing 2d variables',&
         units      = 'none',                                                  &
         prog       = .false.)
    endif
  end subroutine user_add_2d_tracer

  !   This is an internal sub, not a public interface.
  !   Register the 2d tracer for output via a 2d output field
  subroutine user_register_2d_tracers
    real,parameter :: missing_value1=-1.0e+20
    type(vardesc)  :: vardesc_temp
    integer        :: isc,iec,jsc,jec,isd,ied,jsd,jed,nk,ntau, axes(3)
    type(time_type):: init_time
    integer        :: m,n

    call g_tracer_get_common(isc,iec,jsc,jec,isd,ied,jsd,jed,nk,ntau,axes=axes,init_time=init_time)

    n=size(tracers_2d)
    do m=1,n
      vardesc_temp = vardesc(                                                                   &
      tracers_2d(m)%name, tracers_2d(m)%longname,'h','L','s',tracers_2d(m)%units,'f')
      tracers_2d(m)%diag_field = register_diag_field(package_name, vardesc_temp%name, axes(1:2),&
	      init_time, vardesc_temp%longname,vardesc_temp%units, missing_value = missing_value1)
    end do
  end subroutine user_register_2d_tracers

  !   This is an internal sub, not a public interface.
  !   Let the p_field pointer of the 2d tracer point to the data array (for read and write)
  subroutine user_2d_tracer_assign_array(name,array)
    character(len=*), intent(in)           :: name
    real,dimension(:,:),target             :: array
    integer                                :: n
    logical                                :: found_tracer
    character(len=fm_string_len)           :: errorstring

    found_tracer=.false.
    do n=1,size(tracers_2d)
      if (trim(adjustl(name)) .eq. trim(adjustl(tracers_2d(n)%name))) then
        tracers_2d(n)%p_field => array
        tracers_2d(n)%field_assigned = .true.
        found_tracer=.true.
      end if
    end do
    if (.not. found_tracer) then
       write(errorstring, '(a)') &
       'array assigned to tracer '//trim(name)// &
       ', but that tracer was not added by user_add_2d_tracer'
       call  mpp_error(FATAL, errorstring)
    end if
  end subroutine user_2d_tracer_assign_array

  !   This is an internal sub, not a public interface.
  !   Load all data stored in the (3d tracers containing 2d tracer data) into their temporary 2d arrays
   subroutine user_get_2d_tracer_values(tracer_list,isd,ied,jsd,jed,nk)
    type(g_tracer_type),    pointer      :: tracer_list
    integer,                  intent(in) :: isd,ied,jsd,jed,nk
    real,dimension(:,:,:),allocatable    :: a3d
    integer                              :: n
    character(len=fm_string_len)         :: loaded_3d_tracer
    allocate(a3d(isd:ied,jsd:jed,1:nk))
    loaded_3d_tracer=''
    do n=1,size(tracers_2d)
      if (tracers_2d(n)%field_assigned) then
        if (trim(adjustl(tracers_2d(n)%name_of_3d_tracer)) .ne. trim(adjustl(loaded_3d_tracer))) then
          call g_tracer_get_values(     &
	  tracer_list,tracers_2d(n)%name_of_3d_tracer,'field',a3d,isd,jsd,ntau=1,positive=.true.)
          loaded_3d_tracer=tracers_2d(n)%name_of_3d_tracer
        end if
        tracers_2d(n)%p_field = a3d(:,:,tracers_2d(n)%layer_in_3d_tracer)
      end if
    end do
    deallocate(a3d)
  end subroutine user_get_2d_tracer_values

  !   This is an internal sub, not a public interface.
  !   Save all 2d tracer data from their temporary 2d arrays into the 3d tracers containing 2d tracer data
  subroutine user_set_2d_tracer_values(tracer_list ,model_time)
    type(g_tracer_type),      pointer         :: tracer_list
    type(time_type),          intent(in)      :: model_time
    real, dimension(:,:,:),   pointer         :: grid_tmask

    integer                                   :: isc,iec,jsc,jec,isd,ied,jsd,jed,nk,ntau
    real,dimension(:,:,:),allocatable         :: a3d
    integer                                   :: n, layer
    character(len=fm_string_len)              :: loaded_3d_tracer
    logical                                   :: used

    call g_tracer_get_common(isc,iec,jsc,jec,isd,ied,jsd,jed,nk,ntau,grid_tmask=grid_tmask)

    allocate(a3d(isd:ied,jsd:jed,1:nk))
    loaded_3d_tracer=''
    do n=1,size(tracers_2d)
      if (tracers_2d(n)%field_assigned) then
        if (trim(adjustl(tracers_2d(n)%name_of_3d_tracer)) .ne. trim(adjustl(loaded_3d_tracer))) then
          ! a new 3d tracer starts -> first save the temporarily stored data into the old 3d tracer
          if (loaded_3d_tracer .ne. '') then
            call g_tracer_set_values(tracer_list,loaded_3d_tracer,'field',a3d,isd,jsd,ntau=1)
          end if
          ! then, nullify the temporary tracer
          a3d=0.0
          loaded_3d_tracer=tracers_2d(n)%name_of_3d_tracer
        end if
        ! save the data to the temporary tracer
        layer = tracers_2d(n)%layer_in_3d_tracer
        a3d(:,:,layer)  = tracers_2d(n)%p_field
        ! save the values to the diagnostic field
        used = send_data(tracers_2d(n)%diag_field, a3d(:,:,layer),      &
                  model_time, rmask = grid_tmask(:,:,1), is_in=isc, js_in=jsc, ie_in=iec, je_in=jec)
      end if
    end do
    !now, save the last tracer
    if (loaded_3d_tracer .ne. '') then
      call g_tracer_set_values(tracer_list,loaded_3d_tracer,'field',a3d,isd,jsd,ntau=1)
    end if
    deallocate(a3d)
  end subroutine user_set_2d_tracer_values

  ! <SUBROUTINE NAME="generic_ERGOM_update_from_coupler">
  !  <OVERVIEW>
  !   Modify the values obtained from the coupler if necessary.
  !  </OVERVIEW>
  !  Ecological ReGional Ocean Model
  !   Currently an empty stub for CFCs.
  !   Some tracer fields need to be modified after values are obtained from the coupler.
  !   This subroutine is the place for specific tracer manipulations.
  !  </DESCRIPTION>
  !  <TEMPLATE>
  !   call generic_ERGOM_update_from_coupler(tracer_list)
  !  </TEMPLATE>
  !  <IN NAME="tracer_list" TYPE="type(g_tracer_type), pointer">
  !   Pointer to the head of generic tracer list.
  !  </IN>
  ! </SUBROUTINE>
  subroutine generic_ERGOM_update_from_coupler(tracer_list)
    type(g_tracer_type), pointer :: tracer_list
    character(len=fm_string_len), parameter :: sub_name = 'generic_ERGOM_update_from_coupler'
    !
    ! Nothing to be done for ERGOM
    !
    return
  end subroutine generic_ERGOM_update_from_coupler

  ! <SUBROUTINE NAME="generic_ERGOM_update_from_bottom">
  !  <OVERVIEW>
  !   Set values of bottom fluxes and reservoirs
  !  </OVERVIEW>
  !  Ecological ReGional Ocean Model
  !   Some tracers have bottom fluxes and reservoirs.
  !   This subroutine is the place for specific tracer manipulations.
  !  </DESCRIPTION>
  !  <TEMPLATE>
  !   call generic_ERGOM_update_from_bottom(tracer_list,dt, tau, model_time)
  !  </TEMPLATE>
  !  <IN NAME="tracer_list" TYPE="type(g_tracer_type), pointer">
  !   Pointer to the head of generic tracer list.
  !  </IN>
  !  <IN NAME="dt" TYPE="real">
  !   Time step increment
  !  </IN>
  !  <IN NAME="tau" TYPE="integer">
  !   Time step index to be used for %field
  !  </IN>
  ! </SUBROUTINE>
  subroutine generic_ERGOM_update_from_bottom(tracer_list, dt, tau, model_time)
    type(g_tracer_type), pointer :: tracer_list
    real,               intent(in) :: dt
    integer,            intent(in) :: tau
    type(time_type),    intent(in) :: model_time
    integer :: isc,iec, jsc,jec,isd,ied,jsd,jed,nk,ntau
    logical :: used
    real, dimension(:,:,:),pointer :: grid_tmask
    real, dimension(:,:,:,:),ALLOCATABLE :: temp_field
    !
    ! Nothing to be done for ERGOM
    !
   end subroutine generic_ERGOM_update_from_bottom

   real function theta(x)
      real, intent(in) :: x
      if (x > 0) then
         theta=1.0
      else
         theta=0.0
      endif
      return
   end function theta

   real function power(x,y)
      real, intent(in) :: x, y
      power = x**y
      return
   end function power


  ! <SUBROUTINE NAME="cgt_bio_timestep">
  !  <OVERVIEW>
  !   Update tracer concentration fields due to the source/sink contributions.
  !  </OVERVIEW>
  !  Ecological ReGional Ocean Model
  !   Ecosystem model code automatically generated by Code Generation Tool - see www.ergom.net
  !  </DESCRIPTION>
  ! </SUBROUTINE>
  subroutine cgt_bio_timestep(tracer_list,Temp,Salt, rho_dzt,dzt,xt,yt,hblt_depth,&
       ilb,jlb,tau,dt,grid_dat,model_time,nbands,max_wavelength_band, sw_pen_band,opacity_band, &
       current_wave_stress,use_saved_rates,intermediate,diff_cbt)

    type(g_tracer_type),            pointer    :: tracer_list
    real, dimension(ilb:,jlb:,:),   intent(in) :: Temp,Salt,rho_dzt,dzt
    real, dimension(ilb:,jlb:),     intent(in) :: xt,yt
    real, dimension(ilb:,jlb:),     intent(in) :: hblt_depth
    integer,                        intent(in) :: ilb,jlb,tau
    real,                           intent(in) :: dt
    real, dimension(ilb:,jlb:),     intent(in) :: grid_dat
    type(time_type),                intent(in) :: model_time

    integer,                        intent(in) :: nbands
    real, dimension(:),             intent(in) :: max_wavelength_band
    real, dimension(:,ilb:,jlb:),   intent(in) :: sw_pen_band
    real, dimension(:,ilb:,jlb:,:), intent(in) :: opacity_band
    real, dimension(ilb:,jlb:),     intent(in) :: current_wave_stress
    logical,                        intent(in) :: use_saved_rates
    logical,                        intent(in) :: intermediate
    real, dimension(ilb:,jlb:,:,:),optional,intent(in) :: diff_cbt

    ! abiotic parameters for biological processes
    real :: cgt_temp                ! potential temperature     [Celsius]
    real :: cgt_sali                ! salinity                  [g/kg]
    real :: cgt_light               ! downward light flux (PAR) [W/m2]
    real :: cgt_cellheight          ! cell height               [m]
    real :: cgt_density             ! density                   [kg/m3]
    real :: cgt_bottomdepth         ! bottom depth              [m]
    real :: cgt_timestep            ! timestep in days          [days]
    real :: cgt_current_wave_stress ! combined bottom stress of waves and current [N/m2]
    real :: cgt_longitude           ! longitude of grid cell    [deg]
    real :: cgt_latitude            ! latitude of grid cell     [deg]
    real :: cgt_diffusivity         ! diffusivity at cell bottom for T [m**2/s]
    integer :: cgt_iteration        ! current number of iteration in the iterative loop
    integer :: cgt_year, cgt_dayofyear, cgt_mymonth, cgt_myday, cgt_myhour, cgt_myminute, cgt_mysecond ! some date/time variables
    real :: cgt_hour                ! fractional hour (0..23.9999)
    real :: cgt_in_sediment         ! whether we are below the sediment surface

    character(len=fm_string_len), parameter :: sub_name = 'cgt_bio_timestep'
    integer :: isc,iec, jsc,jec,isd,ied,jsd,jed,nk,ntau, i, j, k , kblt, n, m, nband
    real    :: light_itemp, light_ntemp
    real, dimension(:,:,:) ,pointer :: grid_tmask
    integer, dimension(:,:),pointer :: mask_coast,grid_kmt
    logical                         :: used

    integer                         :: number_of_loop

    real                            :: temp1
    real                            :: temp2
    real                            :: temp3
    real                            :: temp4
    real                            :: temp5
    real                            :: temp6
    real                            :: temp7
    real                            :: temp8
    real                            :: temp9
    real,  allocatable, dimension(:,:) :: cgt_bottomdepth_temp
    real,  allocatable, dimension(:,:) :: light1, light2
    real                            :: t_n2              ! dissolved molecular nitrogen
    real                            :: lim_t_n2_7          
    real                            :: t_o2              ! dissolved oxygen
    real                            :: lim_t_o2_0          
    real                            :: lim_t_o2_2          
    real                            :: lim_t_o2_4          
    real                            :: lim_t_o2_6          
    real                            :: t_dic             ! dissolved inorganic carbon, treated as carbon dioxide
    real                            :: lim_t_dic_8         
    real                            :: t_nh4             ! ammonium
    real                            :: lim_t_nh4_11        
    real                            :: t_no3             ! nitrate
    real                            :: lim_t_no3_1         
    real                            :: lim_t_no3_3         
    real                            :: lim_t_no3_10        
    real                            :: t_po4             ! phosphate
    real                            :: lim_t_po4_9         
    real                            :: t_spp             ! small-cell phytoplankton
    real                            :: lim_t_spp_16        
    real                            :: t_zoo             ! zooplankton
    real                            :: lim_t_zoo_18        
    real                            :: t_h2s             ! hydrogen sulfide
    real                            :: lim_t_h2s_5         
    real                            :: lim_t_h2s_23        
    real                            :: t_sul             ! sulfur
    real                            :: lim_t_sul_24        
    real                            :: t_alk             ! total alkalinity
    real                            :: t_sed             ! sediment detritus
    real                            :: lim_t_sed_20        
    real                            :: t_ips             ! iron phosphate in sediment
    real                            :: lim_t_ips_22        
    real                            :: t_doc             ! dissolved organic carbon
    real                            :: lim_t_doc_28        
    real                            :: t_dop             ! phosphorus in dissolved organic carbon in Redfield ratio
    real                            :: lim_t_dop_29        
    real                            :: t_sed_poc         ! sediment particular carbon
    real                            :: lim_t_sed_poc_21    
    real                            :: t_sed_pocn        ! sediment particular organic N+C
    real                            :: lim_t_sed_pocn_26   
    real                            :: t_sed_pocp        ! sediment particular organic P+C
    real                            :: lim_t_sed_pocp_27   
    real                            :: total_atmos_tot_N   ! total_atmos_tot_N
    real                            :: total_atmos_tot_N_at_bottom   ! total_atmos_tot_N_at_bottom
    real                            :: total_atmos_ship_N   ! total_atmos_ship_N
    real                            :: total_atmos_ship_N_at_bottom   ! total_atmos_ship_N_at_bottom
    real                            :: t_n2_with_atmos_tot_N   ! dissolved molecular nitrogen; containing nitrogen from (total) atmospheric deposition
    real                            :: t_nh4_with_atmos_tot_N   ! ammonium; containing nitrogen from (total) atmospheric deposition
    real                            :: t_no3_with_atmos_tot_N   ! nitrate; containing nitrogen from (total) atmospheric deposition
    real                            :: t_spp_with_atmos_tot_N   ! small-cell phytoplankton; containing nitrogen from (total) atmospheric deposition
    real                            :: t_zoo_with_atmos_tot_N   ! zooplankton; containing nitrogen from (total) atmospheric deposition
    real                            :: t_sed_with_atmos_tot_N   ! sediment detritus; containing nitrogen from (total) atmospheric deposition
    real                            :: t_sed_pocn_with_atmos_tot_N   ! sediment particular organic N+C; containing nitrogen from (total) atmospheric deposition
    real                            :: t_n2_with_atmos_ship_N   ! dissolved molecular nitrogen; containing nitrogen from atmospheric deposition, which has been previously emitted by ships
    real                            :: t_nh4_with_atmos_ship_N   ! ammonium; containing nitrogen from atmospheric deposition, which has been previously emitted by ships
    real                            :: t_no3_with_atmos_ship_N   ! nitrate; containing nitrogen from atmospheric deposition, which has been previously emitted by ships
    real                            :: t_spp_with_atmos_ship_N   ! small-cell phytoplankton; containing nitrogen from atmospheric deposition, which has been previously emitted by ships
    real                            :: t_zoo_with_atmos_ship_N   ! zooplankton; containing nitrogen from atmospheric deposition, which has been previously emitted by ships
    real                            :: t_sed_with_atmos_ship_N   ! sediment detritus; containing nitrogen from atmospheric deposition, which has been previously emitted by ships
    real                            :: t_sed_pocn_with_atmos_ship_N   ! sediment particular organic N+C; containing nitrogen from atmospheric deposition, which has been previously emitted by ships
    real                            :: t_ipw             ! suspended iron phosphate
    real                            :: lim_t_ipw_25        
    real                            :: t_pocn_with_atmos_tot_N   ! nitrogen in particulate organic carbon in Redfield ratio; containing nitrogen from (total) atmospheric deposition
    real                            :: t_lpp_with_atmos_tot_N   ! large-cell phytoplankton; containing nitrogen from (total) atmospheric deposition
    real                            :: t_don_with_atmos_tot_N   ! nitrogen in dissolved organic carbon in Redfield ratio; containing nitrogen from (total) atmospheric deposition
    real                            :: t_cya_with_atmos_tot_N   ! diazotroph cyanobacteria; containing nitrogen from (total) atmospheric deposition
    real                            :: t_det_with_atmos_tot_N   ! detritus; containing nitrogen from (total) atmospheric deposition
    real                            :: t_lpp             ! large-cell phytoplankton
    real                            :: lim_t_lpp_15        
    real                            :: t_don             ! nitrogen in dissolved organic carbon in Redfield ratio
    real                            :: lim_t_don_30        
    real                            :: t_cya             ! diazotroph cyanobacteria
    real                            :: lim_t_cya_17        
    real                            :: t_det             ! detritus
    real                            :: lim_t_det_19        
    real                            :: t_poc             ! particulate organic carbon
    real                            :: lim_t_poc_12        
    real                            :: t_pocp            ! phosphorus in particulate organic carbon in Redfield ratio
    real                            :: lim_t_pocp_13       
    real                            :: t_pocn            ! nitrogen in particulate organic carbon in Redfield ratio
    real                            :: lim_t_pocn_14       
    real                            :: t_pocn_with_atmos_ship_N   ! nitrogen in particulate organic carbon in Redfield ratio; containing nitrogen from atmospheric deposition, which has been previously emitted by ships
    real                            :: t_lpp_with_atmos_ship_N   ! large-cell phytoplankton; containing nitrogen from atmospheric deposition, which has been previously emitted by ships
    real                            :: t_don_with_atmos_ship_N   ! nitrogen in dissolved organic carbon in Redfield ratio; containing nitrogen from atmospheric deposition, which has been previously emitted by ships
    real                            :: t_cya_with_atmos_ship_N   ! diazotroph cyanobacteria; containing nitrogen from atmospheric deposition, which has been previously emitted by ships
    real                            :: t_det_with_atmos_ship_N   ! detritus; containing nitrogen from atmospheric deposition, which has been previously emitted by ships


    real                            :: temp_k            ! absolute temperature [K]
    real                            :: ph_temp           ! temporary value assumed for pH [1]
    real                            :: k_water           ! self-ionization constant of Water [mol2/kg2]
    real                            :: k0_co2            ! Solubility of CO2 [mol/kg/Pa]
    real                            :: k1_co2            ! Acid dissociation constant CO2 + 2 H2O <-> HCO3- + H3O+ [mol/kg]
    real                            :: k2_co2            ! Acid dissociation constant HCO3- + H2O <-> [CO3 2-] + H3O+ [mol/kg]
    real                            :: k_boron           ! Acid dissociation constant of boric acid [mol/kg]
    real                            :: k1_po4            ! Acid dissociation constant H3PO4 + H2O <-> [H2PO4 -] + H3O+ [mol/kg]
    real                            :: k2_po4            ! Acid dissociation constant [H2PO4 -] + H2O+ <-> [HPO4 2-] + H3O+ [mol/kg]
    real                            :: k3_po4            ! Acid dissociation constant [HPO4 2-] + H2O <-> [PO4 3-] + H3O+ [mol/kg]
    real                            :: k1_h2s            ! Acid dissociation constant H2S + H2O <-> HS- + H3O+ [mol/kg]
    real                            :: boron_total       ! total concentration of boron [mol/kg]
    real                            :: alk_boron         ! boron alkalinity [mol/kg]
    real                            :: alk_h2s           ! hydrogen sulfide alkalinity [mol/kg]
    real                            :: alk_water         ! water alkalinity [mol/kg]
    real                            :: alk_po4_denominator   ! denominator in phosphate alkalinity formula [mol3/kg3]
    real                            :: alk_po4           ! phosphate alkalinity [mol/kg]
    real                            :: alk_co2_denominator   ! denominator in carbonate alkalinity formula [mol2/kg2]
    real                            :: alk_co2           ! carbonate alkalinity [mol/kg]
    real                            :: alk_residual      ! error in total alkalinity calculation at the assumed pH [mol/kg]
    real                            :: dalkp_dh3o        ! derivative of phosphate alkalinity with respect to h3o [1]
    real                            :: dalkc_dh3o        ! derivative of carbonate alkalinity with respect to h3o [1]
    real                            :: dalkresidual_dpH   ! derivative of residual_alk with respect to pH [mol/kg]
    real                            :: ph                ! newly determined pH value [1]
    real                            :: h3o               ! h3o ion concentration [mol/kg]
    real                            :: pco2              ! co2 partial pressure [Pa]
    real                            :: co2               ! CO2 concentration in the surface layer [mol/kg]
    real                            :: schmidtnumber_co2   ! Schmidt number for CO2 surface flux [1]
    real                            :: frac_denit_sed    ! fraction of ammonium that is immediately nitrified and denitrified after remineralization in oxic sediments
    real                            :: o2_sat            ! oxygen saturation concentration [mol/kg]
    real                            :: solubility_o2     ! solubility of oxygen [mol/kg/Pa]
    real                            :: schmidtnumber_o2   ! Schmidt number for oxygen surface flux [1]
    real                            :: n2_sat            ! dissolved molecular nitrogen saturation concentration [mol/kg]
    real                            :: solubility_n2     ! solubility of molecular nitrogen [mol/kg/Pa]
    real                            :: schmidtnumber_n2   ! Schmidt number for nitrogen surface flux [1]
    real                            :: temp_sq           ! square of positive temperature [C * C]
    real                            :: zoo_eff           ! effectice zooplankton concentration assumed for mortality and respiration process [mol/kg]
    real                            :: din               ! dissolved inorganic nitrogen [mol/kg]
    real                            :: din_sq            ! squared DIN [mol2/kg2]
    real                            :: po4_sq            ! squared phosphate [mol**2/kg**2]
    real                            :: pp                ! total phytoplankton [mol/kg]
    real                            :: lpp_plus_lpp0     ! large-cell phytoplankton plus seed concentration [mol/kg]
    real                            :: spp_plus_spp0     ! small-cell phytoplankton plus seed concentration [mol/kg]
    real                            :: cya_plus_cya0     ! diazotroph cyanobacteria plus seed concentration [mol/kg]
    real                            :: food_zoo          ! suitable food for zooplankton (weighted with food preferences) [mol/kg]
    real                            :: lim_light_lpp     ! light limitation factor for large-cell phytoplankton growth [1]
    real                            :: lim_light_spp     ! light limitation factor for small-cell phytoplankton growth [1]
    real                            :: lim_light_cya     ! light limitation factor for diazotroph cyanobacteria growth [1]
    real                            :: lr_assim_lpp      ! growth rate of large-cell phytoplankton, limited by DIN, DIP, light and oxygen [1/day]
    real                            :: lr_assim_lpp_doc   ! production rate of DOC by LPP
    real                            :: lr_assim_spp_doc   ! production rate of POC by SPP
    real                            :: lr_assim_cya_doc   ! production rate of POC by CYA
    real                            :: lr_assim_spp      ! growth rate of small-cell phytoplankton, limited by DIN, DIP, light, oxygen and temperature [1/day]
    real                            :: lr_assim_cya      ! growth rate of diazotroph cyanobacteria, limited by DIP, light, oxygen, temperature and salinity [1/day]
    real                            :: lr_assim_lpp_dop   ! production rate of POCP by LPP
    real                            :: lr_assim_spp_dop   ! production rate of POCP by SPP
    real                            :: lr_assim_lpp_don   ! production rate of POCN by LPP
    real                            :: lr_assim_spp_don   ! production rate of POCN by SPP
    real                            :: lr_graz_zoo       ! growth rate of zooplankton, limited by food, oxygen and temperature [1/day]
    real                            :: sed_tot           ! total carbon in sediment layer [mol/m**2]
    real                            :: sed_tot_active    ! total carbon in active sediment layer [mol/m**2]
    real                            :: sed_active        ! detritus in active sediment layer [mol/m**2]
    real                            :: lr_sed_rec        ! recycling rate of sediment detritus, limited by oxygen [1/d]
    real                            :: ips_eff           ! effective concentration of iron phosphate in the sediment assumed for burial (enhanced burial above a threshold) [mol/m**2]
    real                            :: frac_po4retent    ! fraction of phosphate which is retained as iron-bound phosphate instead of being released after mineralization in the sediment [1]
    real                            :: erosion_is_active   ! switch (1=erosion, 0=no erosion) which depends on the combined bottom stress of currents and waves
    real                            :: ref_p_sw          ! modifies pocp recycling towards Refield ratio if PO4 is depleted
    real                            :: ref_n_sw          ! modifies pocn recycling towards Refield ratio if DIN is depleted
    real                            :: lr_pocp           ! add an additional POCP recycling if PO4 below Redfield but sufficient DIN
    real                            :: lr_dop            ! add an additional DOP recycling if PO4 is below Redfield but sufficient DIN
    real                            :: lr_pocn           ! add an additional POCN recycling if DIN below Redfield but sufficient PO4
    real                            :: lr_don            ! add an additional DON recycling if DIN below Redfield but sufficient PO4
    real                            :: poc_active        ! poc in active sediment layer [mol/m**2]
    real                            :: pocn_active       ! pocn in active sediment layer [mol/m**2]
    real                            :: pocp_active       ! pocp in active sediment layer [mol/m**2]
    real                            :: w_poc_var         ! depth dependent POC sinking speed
    real                            :: w_pocn_var        ! depth dependent POCN sinking speed
    real                            :: w_pocp_var        ! depth dependent POCP sinking speed

    real                            :: p_no3_assim_lpp   ! assimilation of nitrate by large-cell phytoplankton
    real                            :: p_nh4_assim_lpp   ! assimilation of ammonium by large-cell phytoplankton
    real                            :: p_no3_assim_spp   ! assimilation of nitrate by small-cell phytoplankton
    real                            :: p_nh4_assim_spp   ! assimilation of ammonium by small-cell phytoplankton
    real                            :: p_n2_assim_cya    ! fixation of dinitrogen by diazotroph cyanobacteria
    real                            :: p_assim_lpp_doc   ! Production of DOC by LPP
    real                            :: p_assim_spp_doc   ! Production of DOC by SPP
    real                            :: p_assim_cya_doc   ! Production of POC by CYA
    real                            :: p_assim_lpp_dop   ! Production of DOP by LPP
    real                            :: p_assim_spp_dop   ! Production of DOP by SPP
    real                            :: p_nh4_assim_lpp_don   ! Production of DON by LPP
    real                            :: p_no3_assim_lpp_don   ! Production of DON by LPP
    real                            :: p_nh4_assim_spp_don   ! Production of DON by SPP
    real                            :: p_no3_assim_spp_don   ! Production of DON by SPP
    real                            :: p_poc_resp        ! respiration of POC
    real                            :: p_poc_denit       ! recycling of POC using nitrate (denitrification)
    real                            :: p_poc_sulf        ! Mineralization of POC, e-acceptor sulfate (sulfate reduction)
    real                            :: p_pocp_resp       ! respiration of POCP
    real                            :: p_pocp_denit      ! recycling of POC using nitrate (denitrification)
    real                            :: p_pocp_sulf       ! Mineralization of POC, e-acceptor sulfate (sulfate reduction)
    real                            :: p_pocn_resp       ! respiration of POCN
    real                            :: p_pocn_denit_noN2   ! recycling of POCN using nitrate (denitrification)
    real                            :: p_pocn_denit_wiN2   ! recycling of POCN using nitrate (denitrification)
    real                            :: p_pocn_sulf       ! Mineralization of POCN, e-acceptor sulfate (sulfate reduction)
    real                            :: p_lpp_graz_zoo    ! grazing of zooplankton eating large-cell phytoplankton
    real                            :: p_spp_graz_zoo    ! grazing of zooplankton eating small-cell phytoplankton
    real                            :: p_cya_graz_zoo    ! grazing of zooplankton eating diazotroph cyanobacteria
    real                            :: p_lpp_resp_nh4    ! respiration of large-cell phytoplankton
    real                            :: p_spp_resp_nh4    ! respiration of small-cell phytoplankton
    real                            :: p_cya_resp_nh4    ! respiration of diazotroph cyanobacteria
    real                            :: p_zoo_resp_nh4    ! respiration of zooplankton
    real                            :: p_lpp_mort_det    ! mortality of large-cell phytoplankton
    real                            :: p_spp_mort_det    ! mortality of small-scale phytoplankton
    real                            :: p_cya_mort_det    ! mortality of diazotroph cyanobacteria
    real                            :: p_cya_mort_det_diff   ! mortality of diazotroph cyanobacteria due to strong turbulence
    real                            :: p_zoo_mort_det    ! mortality of zooplankton
    real                            :: p_nh4_nit_no3     ! nitrification
    real                            :: p_det_resp_nh4    ! recycling of detritus using oxygen (respiration)
    real                            :: p_det_denit_nh4   ! recycling of detritus using nitrate (denitrification)
    real                            :: p_det_sulf_nh4    ! recycling of detritus using sulfate (sulfate reduction)
    real                            :: p_sed_resp_nh4    ! recycling of sedimentary detritus to ammonium using oxygen (respiration)
    real                            :: p_nh4_nitdenit_n2   ! coupled nitrification and denitrification after mineralization of detritus in oxic sediments
    real                            :: p_sed_denit_nh4_noN2   ! recycling of sedimentary detritus to ammonium using nitrate (denitrification)
    real                            :: p_sed_denit_nh4_wiN2   ! recycling of sedimentary detritus to ammonium using nitrate (denitrification)
    real                            :: p_sed_sulf_nh4    ! recycling of sedimentary detritus to ammonium using sulfate (sulfate reduction)
    real                            :: p_sed_poc_resp    ! recycling of sedimentary poc to dic using oxygen (respiration)
    real                            :: p_sed_poc_denit   ! recycling of sedimentary poc to dic using nitrate (denitrification)
    real                            :: p_sed_poc_sulf    ! recycling of sedimentary poc to dic using sulfate (sulfate reduction)
    real                            :: p_po4_retent_ips   ! retention of phosphate in the sediment under oxic conditions
    real                            :: p_ips_liber_po4   ! liberation of phosphate from the sediment under anoxic conditions
    real                            :: p_h2s_oxo2_sul    ! oxidation of hydrogen sulfide with oxygen
    real                            :: p_h2s_oxno3_sul   ! oxidation of hydrogen sulfide with nitrate
    real                            :: p_sul_oxo2_so4    ! oxidation of elemental sulfur with oxygen
    real                            :: p_sul_oxno3_so4   ! oxidation of elemental sulfur with nitrate
    real                            :: p_det_sedi_sed    ! detritus sedimentation
    real                            :: p_ipw_sedi_ips    ! sedimentation of iron PO4
    real                            :: p_poc_sedi_sed    ! poc sedimentation
    real                            :: p_pocn_sedi_sed   ! pocn sedimentation
    real                            :: p_pocp_sedi_sed   ! pocp sedimentation
    real                            :: p_sed_ero_det     ! sedimentary detritus erosion
    real                            :: p_ips_ero_ipw     ! erosion of iron PO4
    real                            :: p_sed_ero_poc     ! sedimentary poc erosion
    real                            :: p_sed_ero_pocn    ! sedimentary pocn erosion
    real                            :: p_sed_ero_pocp    ! sedimentary pocp erosion
    real                            :: p_sed_biores_det   ! bio resuspension of sedimentary detritus
    real                            :: p_ips_biores_ipw   ! bio resuspension of iron PO4
    real                            :: p_sed_biores_poc   ! bio resuspension of sedimentary poc
    real                            :: p_sed_biores_pocn   ! bio resuspension of sedimentary pocn
    real                            :: p_sed_biores_pocp   ! bio resuspension of sedimentary pocp
    real                            :: p_sed_burial      ! burial of detritus deeper than max_sed
    real                            :: p_ips_burial      ! burial of iron PO4
    real                            :: p_poc_burial      ! burial of poc deeper than max_sed
    real                            :: p_pocn_burial     ! burial of pocn deeper than max_sed
    real                            :: p_pocp_burial     ! burial of pocp deeper than max_sed
    real                            :: p_sed_pocn_resp   ! recycling of sedimentary pocn to dic and NH4 using oxygen (respiration)
    real                            :: p_sed_pocp_resp   ! recycling of sedimentary pocp to dic and PO4 using oxygen (respiration)
    real                            :: p_sed_pocn_denit_noN2   ! recycling of sedimentary pocn to dic and NH4 using nitrate (denitrification)
    real                            :: p_sed_pocn_denit_wiN2   ! recycling of sedimentary pocn to dic and NH4 using nitrate (denitrification)
    real                            :: p_sed_pocp_denit   ! recycling of sedimentary pocp to dic and PO4 using nitrate (denitrification)
    real                            :: p_sed_pocn_sulf   ! recycling of sedimentary pocn to dic and NH4 using sulfate (sulfate reduction)
    real                            :: p_sed_pocp_sulf   ! recycling of sedimentary pocp to dic and PO4 using sulfate (sulfate reduction)
    real                            :: p_nh4_nitdenit_pocn_n2   ! coupled nitrification and denitrification after mineralization of pocn-detritus in oxic sediments
    real                            :: p_doc2pco         ! particle formation from DOC
    real                            :: p_dop2pocp        ! particle formation from DOP
    real                            :: p_don2pocn        ! particle formation from DON
    real                            :: p_doc_resp        ! respiration of DOC
    real                            :: p_doc_denit       ! recycling of DOC using nitrate (denitrification)
    real                            :: p_doc_sulf        ! Mineralization of DOC, e-acceptor sulfate (sulfate reduction)
    real                            :: p_dop_resp        ! respiration of DOP
    real                            :: p_dop_denit       ! recycling of DOP using nitrate (denitrification)
    real                            :: p_dop_sulf        ! Mineralization of DOP, e-acceptor sulfate (sulfate reduction)
    real                            :: p_don_resp        ! respiration of DON
    real                            :: p_don_denit_noN2   ! recycling of DON using nitrate (denitrification)
    real                            :: p_don_denit_wiN2   ! recycling of DON using nitrate (denitrification)
    real                            :: p_don_sulf        ! Mineralization of DON, e-acceptor sulfate (sulfate reduction)
    real                            :: p_no3_assim_lpp_atmos_tot_N   ! assimilation of nitrate by large-cell phytoplankton; sub-process for atmos_tot nitrogen
    real                            :: p_nh4_assim_lpp_atmos_tot_N   ! assimilation of ammonium by large-cell phytoplankton; sub-process for atmos_tot nitrogen
    real                            :: p_no3_assim_spp_atmos_tot_N   ! assimilation of nitrate by small-cell phytoplankton; sub-process for atmos_tot nitrogen
    real                            :: p_nh4_assim_spp_atmos_tot_N   ! assimilation of ammonium by small-cell phytoplankton; sub-process for atmos_tot nitrogen
    real                            :: p_nh4_assim_lpp_don_atmos_tot_N   ! Production of DON by LPP; sub-process for atmos_tot nitrogen
    real                            :: p_no3_assim_lpp_don_atmos_tot_N   ! Production of DON by LPP; sub-process for atmos_tot nitrogen
    real                            :: p_nh4_assim_spp_don_atmos_tot_N   ! Production of DON by SPP; sub-process for atmos_tot nitrogen
    real                            :: p_no3_assim_spp_don_atmos_tot_N   ! Production of DON by SPP; sub-process for atmos_tot nitrogen
    real                            :: p_pocn_resp_atmos_tot_N   ! respiration of POCN; sub-process for atmos_tot nitrogen
    real                            :: p_pocn_denit_noN2_atmos_tot_N   ! recycling of POCN using nitrate (denitrification); sub-process for atmos_tot nitrogen
    real                            :: p_pocn_sulf_atmos_tot_N   ! Mineralization of POCN, e-acceptor sulfate (sulfate reduction); sub-process for atmos_tot nitrogen
    real                            :: p_lpp_graz_zoo_atmos_tot_N   ! grazing of zooplankton eating large-cell phytoplankton; sub-process for atmos_tot nitrogen
    real                            :: p_spp_graz_zoo_atmos_tot_N   ! grazing of zooplankton eating small-cell phytoplankton; sub-process for atmos_tot nitrogen
    real                            :: p_cya_graz_zoo_atmos_tot_N   ! grazing of zooplankton eating diazotroph cyanobacteria; sub-process for atmos_tot nitrogen
    real                            :: p_lpp_resp_nh4_atmos_tot_N   ! respiration of large-cell phytoplankton; sub-process for atmos_tot nitrogen
    real                            :: p_spp_resp_nh4_atmos_tot_N   ! respiration of small-cell phytoplankton; sub-process for atmos_tot nitrogen
    real                            :: p_cya_resp_nh4_atmos_tot_N   ! respiration of diazotroph cyanobacteria; sub-process for atmos_tot nitrogen
    real                            :: p_zoo_resp_nh4_atmos_tot_N   ! respiration of zooplankton; sub-process for atmos_tot nitrogen
    real                            :: p_lpp_mort_det_atmos_tot_N   ! mortality of large-cell phytoplankton; sub-process for atmos_tot nitrogen
    real                            :: p_spp_mort_det_atmos_tot_N   ! mortality of small-scale phytoplankton; sub-process for atmos_tot nitrogen
    real                            :: p_cya_mort_det_atmos_tot_N   ! mortality of diazotroph cyanobacteria; sub-process for atmos_tot nitrogen
    real                            :: p_cya_mort_det_diff_atmos_tot_N   ! mortality of diazotroph cyanobacteria due to strong turbulence; sub-process for atmos_tot nitrogen
    real                            :: p_zoo_mort_det_atmos_tot_N   ! mortality of zooplankton; sub-process for atmos_tot nitrogen
    real                            :: p_nh4_nit_no3_atmos_tot_N   ! nitrification; sub-process for atmos_tot nitrogen
    real                            :: p_det_resp_nh4_atmos_tot_N   ! recycling of detritus using oxygen (respiration); sub-process for atmos_tot nitrogen
    real                            :: p_det_sulf_nh4_atmos_tot_N   ! recycling of detritus using sulfate (sulfate reduction); sub-process for atmos_tot nitrogen
    real                            :: p_sed_resp_nh4_atmos_tot_N   ! recycling of sedimentary detritus to ammonium using oxygen (respiration); sub-process for atmos_tot nitrogen
    real                            :: p_sed_denit_nh4_noN2_atmos_tot_N   ! recycling of sedimentary detritus to ammonium using nitrate (denitrification); sub-process for atmos_tot nitrogen
    real                            :: p_sed_sulf_nh4_atmos_tot_N   ! recycling of sedimentary detritus to ammonium using sulfate (sulfate reduction); sub-process for atmos_tot nitrogen
    real                            :: p_det_sedi_sed_atmos_tot_N   ! detritus sedimentation; sub-process for atmos_tot nitrogen
    real                            :: p_pocn_sedi_sed_atmos_tot_N   ! pocn sedimentation; sub-process for atmos_tot nitrogen
    real                            :: p_sed_ero_det_atmos_tot_N   ! sedimentary detritus erosion; sub-process for atmos_tot nitrogen
    real                            :: p_sed_ero_pocn_atmos_tot_N   ! sedimentary pocn erosion; sub-process for atmos_tot nitrogen
    real                            :: p_sed_biores_det_atmos_tot_N   ! bio resuspension of sedimentary detritus; sub-process for atmos_tot nitrogen
    real                            :: p_sed_biores_pocn_atmos_tot_N   ! bio resuspension of sedimentary pocn; sub-process for atmos_tot nitrogen
    real                            :: p_sed_burial_atmos_tot_N   ! burial of detritus deeper than max_sed; sub-process for atmos_tot nitrogen
    real                            :: p_pocn_burial_atmos_tot_N   ! burial of pocn deeper than max_sed; sub-process for atmos_tot nitrogen
    real                            :: p_sed_pocn_resp_atmos_tot_N   ! recycling of sedimentary pocn to dic and NH4 using oxygen (respiration); sub-process for atmos_tot nitrogen
    real                            :: p_sed_pocn_denit_noN2_atmos_tot_N   ! recycling of sedimentary pocn to dic and NH4 using nitrate (denitrification); sub-process for atmos_tot nitrogen
    real                            :: p_sed_pocn_sulf_atmos_tot_N   ! recycling of sedimentary pocn to dic and NH4 using sulfate (sulfate reduction); sub-process for atmos_tot nitrogen
    real                            :: p_don2pocn_atmos_tot_N   ! particle formation from DON; sub-process for atmos_tot nitrogen
    real                            :: p_don_resp_atmos_tot_N   ! respiration of DON; sub-process for atmos_tot nitrogen
    real                            :: p_don_denit_noN2_atmos_tot_N   ! recycling of DON using nitrate (denitrification); sub-process for atmos_tot nitrogen
    real                            :: p_don_sulf_atmos_tot_N   ! Mineralization of DON, e-acceptor sulfate (sulfate reduction); sub-process for atmos_tot nitrogen
    real                            :: p_no3_assim_lpp_atmos_ship_N   ! assimilation of nitrate by large-cell phytoplankton; sub-process for atmos_ship nitrogen
    real                            :: p_nh4_assim_lpp_atmos_ship_N   ! assimilation of ammonium by large-cell phytoplankton; sub-process for atmos_ship nitrogen
    real                            :: p_no3_assim_spp_atmos_ship_N   ! assimilation of nitrate by small-cell phytoplankton; sub-process for atmos_ship nitrogen
    real                            :: p_nh4_assim_spp_atmos_ship_N   ! assimilation of ammonium by small-cell phytoplankton; sub-process for atmos_ship nitrogen
    real                            :: p_nh4_assim_lpp_don_atmos_ship_N   ! Production of DON by LPP; sub-process for atmos_ship nitrogen
    real                            :: p_no3_assim_lpp_don_atmos_ship_N   ! Production of DON by LPP; sub-process for atmos_ship nitrogen
    real                            :: p_nh4_assim_spp_don_atmos_ship_N   ! Production of DON by SPP; sub-process for atmos_ship nitrogen
    real                            :: p_no3_assim_spp_don_atmos_ship_N   ! Production of DON by SPP; sub-process for atmos_ship nitrogen
    real                            :: p_pocn_resp_atmos_ship_N   ! respiration of POCN; sub-process for atmos_ship nitrogen
    real                            :: p_pocn_denit_noN2_atmos_ship_N   ! recycling of POCN using nitrate (denitrification); sub-process for atmos_ship nitrogen
    real                            :: p_pocn_sulf_atmos_ship_N   ! Mineralization of POCN, e-acceptor sulfate (sulfate reduction); sub-process for atmos_ship nitrogen
    real                            :: p_lpp_graz_zoo_atmos_ship_N   ! grazing of zooplankton eating large-cell phytoplankton; sub-process for atmos_ship nitrogen
    real                            :: p_spp_graz_zoo_atmos_ship_N   ! grazing of zooplankton eating small-cell phytoplankton; sub-process for atmos_ship nitrogen
    real                            :: p_cya_graz_zoo_atmos_ship_N   ! grazing of zooplankton eating diazotroph cyanobacteria; sub-process for atmos_ship nitrogen
    real                            :: p_lpp_resp_nh4_atmos_ship_N   ! respiration of large-cell phytoplankton; sub-process for atmos_ship nitrogen
    real                            :: p_spp_resp_nh4_atmos_ship_N   ! respiration of small-cell phytoplankton; sub-process for atmos_ship nitrogen
    real                            :: p_cya_resp_nh4_atmos_ship_N   ! respiration of diazotroph cyanobacteria; sub-process for atmos_ship nitrogen
    real                            :: p_zoo_resp_nh4_atmos_ship_N   ! respiration of zooplankton; sub-process for atmos_ship nitrogen
    real                            :: p_lpp_mort_det_atmos_ship_N   ! mortality of large-cell phytoplankton; sub-process for atmos_ship nitrogen
    real                            :: p_spp_mort_det_atmos_ship_N   ! mortality of small-scale phytoplankton; sub-process for atmos_ship nitrogen
    real                            :: p_cya_mort_det_atmos_ship_N   ! mortality of diazotroph cyanobacteria; sub-process for atmos_ship nitrogen
    real                            :: p_cya_mort_det_diff_atmos_ship_N   ! mortality of diazotroph cyanobacteria due to strong turbulence; sub-process for atmos_ship nitrogen
    real                            :: p_zoo_mort_det_atmos_ship_N   ! mortality of zooplankton; sub-process for atmos_ship nitrogen
    real                            :: p_nh4_nit_no3_atmos_ship_N   ! nitrification; sub-process for atmos_ship nitrogen
    real                            :: p_det_resp_nh4_atmos_ship_N   ! recycling of detritus using oxygen (respiration); sub-process for atmos_ship nitrogen
    real                            :: p_det_sulf_nh4_atmos_ship_N   ! recycling of detritus using sulfate (sulfate reduction); sub-process for atmos_ship nitrogen
    real                            :: p_sed_resp_nh4_atmos_ship_N   ! recycling of sedimentary detritus to ammonium using oxygen (respiration); sub-process for atmos_ship nitrogen
    real                            :: p_sed_denit_nh4_noN2_atmos_ship_N   ! recycling of sedimentary detritus to ammonium using nitrate (denitrification); sub-process for atmos_ship nitrogen
    real                            :: p_sed_sulf_nh4_atmos_ship_N   ! recycling of sedimentary detritus to ammonium using sulfate (sulfate reduction); sub-process for atmos_ship nitrogen
    real                            :: p_det_sedi_sed_atmos_ship_N   ! detritus sedimentation; sub-process for atmos_ship nitrogen
    real                            :: p_pocn_sedi_sed_atmos_ship_N   ! pocn sedimentation; sub-process for atmos_ship nitrogen
    real                            :: p_sed_ero_det_atmos_ship_N   ! sedimentary detritus erosion; sub-process for atmos_ship nitrogen
    real                            :: p_sed_ero_pocn_atmos_ship_N   ! sedimentary pocn erosion; sub-process for atmos_ship nitrogen
    real                            :: p_sed_biores_det_atmos_ship_N   ! bio resuspension of sedimentary detritus; sub-process for atmos_ship nitrogen
    real                            :: p_sed_biores_pocn_atmos_ship_N   ! bio resuspension of sedimentary pocn; sub-process for atmos_ship nitrogen
    real                            :: p_sed_burial_atmos_ship_N   ! burial of detritus deeper than max_sed; sub-process for atmos_ship nitrogen
    real                            :: p_pocn_burial_atmos_ship_N   ! burial of pocn deeper than max_sed; sub-process for atmos_ship nitrogen
    real                            :: p_sed_pocn_resp_atmos_ship_N   ! recycling of sedimentary pocn to dic and NH4 using oxygen (respiration); sub-process for atmos_ship nitrogen
    real                            :: p_sed_pocn_denit_noN2_atmos_ship_N   ! recycling of sedimentary pocn to dic and NH4 using nitrate (denitrification); sub-process for atmos_ship nitrogen
    real                            :: p_sed_pocn_sulf_atmos_ship_N   ! recycling of sedimentary pocn to dic and NH4 using sulfate (sulfate reduction); sub-process for atmos_ship nitrogen
    real                            :: p_don2pocn_atmos_ship_N   ! particle formation from DON; sub-process for atmos_ship nitrogen
    real                            :: p_don_resp_atmos_ship_N   ! respiration of DON; sub-process for atmos_ship nitrogen
    real                            :: p_don_denit_noN2_atmos_ship_N   ! recycling of DON using nitrate (denitrification); sub-process for atmos_ship nitrogen
    real                            :: p_don_sulf_atmos_ship_N   ! Mineralization of DON, e-acceptor sulfate (sulfate reduction); sub-process for atmos_ship nitrogen

    real                            :: above_t_n2              ! value one grid cell above
    real                            :: above_t_o2              ! value one grid cell above
    real                            :: above_t_dic             ! value one grid cell above
    real                            :: above_t_nh4             ! value one grid cell above
    real                            :: above_t_no3             ! value one grid cell above
    real                            :: above_t_po4             ! value one grid cell above
    real                            :: above_t_spp             ! value one grid cell above
    real                            :: above_t_zoo             ! value one grid cell above
    real                            :: above_t_h2s             ! value one grid cell above
    real                            :: above_t_sul             ! value one grid cell above
    real                            :: above_t_alk             ! value one grid cell above
    real                            :: above_t_doc             ! value one grid cell above
    real                            :: above_t_dop             ! value one grid cell above
    real                            :: above_total_atmos_tot_N   ! value one grid cell above
    real                            :: above_total_atmos_ship_N   ! value one grid cell above
    real                            :: above_t_n2_with_atmos_tot_N   ! value one grid cell above
    real                            :: above_t_nh4_with_atmos_tot_N   ! value one grid cell above
    real                            :: above_t_no3_with_atmos_tot_N   ! value one grid cell above
    real                            :: above_t_spp_with_atmos_tot_N   ! value one grid cell above
    real                            :: above_t_zoo_with_atmos_tot_N   ! value one grid cell above
    real                            :: above_t_n2_with_atmos_ship_N   ! value one grid cell above
    real                            :: above_t_nh4_with_atmos_ship_N   ! value one grid cell above
    real                            :: above_t_no3_with_atmos_ship_N   ! value one grid cell above
    real                            :: above_t_spp_with_atmos_ship_N   ! value one grid cell above
    real                            :: above_t_zoo_with_atmos_ship_N   ! value one grid cell above
    real                            :: above_t_ipw             ! value one grid cell above
    real                            :: above_t_pocn_with_atmos_tot_N   ! value one grid cell above
    real                            :: above_t_lpp_with_atmos_tot_N   ! value one grid cell above
    real                            :: above_t_don_with_atmos_tot_N   ! value one grid cell above
    real                            :: above_t_cya_with_atmos_tot_N   ! value one grid cell above
    real                            :: above_t_det_with_atmos_tot_N   ! value one grid cell above
    real                            :: above_t_lpp             ! value one grid cell above
    real                            :: above_t_don             ! value one grid cell above
    real                            :: above_t_cya             ! value one grid cell above
    real                            :: above_t_det             ! value one grid cell above
    real                            :: above_t_poc             ! value one grid cell above
    real                            :: above_t_pocp            ! value one grid cell above
    real                            :: above_t_pocn            ! value one grid cell above
    real                            :: above_t_pocn_with_atmos_ship_N   ! value one grid cell above
    real                            :: above_t_lpp_with_atmos_ship_N   ! value one grid cell above
    real                            :: above_t_don_with_atmos_ship_N   ! value one grid cell above
    real                            :: above_t_cya_with_atmos_ship_N   ! value one grid cell above
    real                            :: above_t_det_with_atmos_ship_N   ! value one grid cell above

    real, dimension(:,:)   ,pointer :: runoff_flux_t_o2           
    real, dimension(:,:)   ,pointer :: diffusive_flux_t_o2           
    real, dimension(:,:)   ,pointer :: runoff_flux_t_dic          
    real, dimension(:,:)   ,pointer :: diffusive_flux_t_dic          
    real, dimension(:,:)   ,pointer :: runoff_flux_t_nh4          
    real, dimension(:,:)   ,pointer :: diffusive_flux_t_nh4          
    real, dimension(:,:)   ,pointer :: runoff_flux_t_no3          
    real, dimension(:,:)   ,pointer :: diffusive_flux_t_no3          
    real, dimension(:,:)   ,pointer :: runoff_flux_t_po4          
    real, dimension(:,:)   ,pointer :: diffusive_flux_t_po4          
    real, dimension(:,:)   ,pointer :: runoff_flux_t_alk          
    real, dimension(:,:)   ,pointer :: diffusive_flux_t_alk          
    real, dimension(:,:)   ,pointer :: runoff_flux_t_det          
    real, dimension(:,:)   ,pointer :: diffusive_flux_t_det          
    real, dimension(:,:)   ,pointer :: wet_t_nh4          
    real, dimension(:,:)   ,pointer :: wet_t_no3          
    real, dimension(:,:)   ,pointer :: wet_t_po4          
    real, dimension(:,:)   ,pointer :: wet_t_nh4_with_atmos_tot_N
    real, dimension(:,:)   ,pointer :: wet_t_no3_with_atmos_tot_N
    real, dimension(:,:)   ,pointer :: wet_t_nh4_with_atmos_ship_N
    real, dimension(:,:)   ,pointer :: wet_t_no3_with_atmos_ship_N

    ! the following variables are used for the positive-definite scheme
    real :: timestep_fraction           ! ratio between allowed timestep and attempted timestep
    real :: timestep_fraction_new       ! ratio between timestep allowed by each tracer and attempted timestep
    real :: fraction_of_total_timestep  ! ratio between remaining timestep and original timestep
    real :: change_of_t_n2                       ! possible change during remaining timestep
    real :: change_btf_t_n2                      ! possible bottom tracer flux during remaining timestep
    real :: change_of_t_o2                       ! possible change during remaining timestep
    real :: change_btf_t_o2                      ! possible bottom tracer flux during remaining timestep
    real :: change_of_t_dic                      ! possible change during remaining timestep
    real :: change_btf_t_dic                     ! possible bottom tracer flux during remaining timestep
    real :: change_of_t_nh4                      ! possible change during remaining timestep
    real :: change_btf_t_nh4                     ! possible bottom tracer flux during remaining timestep
    real :: change_of_t_no3                      ! possible change during remaining timestep
    real :: change_btf_t_no3                     ! possible bottom tracer flux during remaining timestep
    real :: change_of_t_po4                      ! possible change during remaining timestep
    real :: change_btf_t_po4                     ! possible bottom tracer flux during remaining timestep
    real :: change_of_t_spp                      ! possible change during remaining timestep
    real :: change_btf_t_spp                     ! possible bottom tracer flux during remaining timestep
    real :: change_of_t_zoo                      ! possible change during remaining timestep
    real :: change_btf_t_zoo                     ! possible bottom tracer flux during remaining timestep
    real :: change_of_t_h2s                      ! possible change during remaining timestep
    real :: change_btf_t_h2s                     ! possible bottom tracer flux during remaining timestep
    real :: change_of_t_sul                      ! possible change during remaining timestep
    real :: change_btf_t_sul                     ! possible bottom tracer flux during remaining timestep
    real :: change_of_t_alk                      ! possible change during remaining timestep
    real :: change_btf_t_alk                     ! possible bottom tracer flux during remaining timestep
    real :: change_of_t_sed                      ! possible change during remaining timestep
    real :: change_btf_t_sed                     ! possible bottom tracer flux during remaining timestep
    real :: change_of_t_ips                      ! possible change during remaining timestep
    real :: change_btf_t_ips                     ! possible bottom tracer flux during remaining timestep
    real :: change_of_t_doc                      ! possible change during remaining timestep
    real :: change_btf_t_doc                     ! possible bottom tracer flux during remaining timestep
    real :: change_of_t_dop                      ! possible change during remaining timestep
    real :: change_btf_t_dop                     ! possible bottom tracer flux during remaining timestep
    real :: change_of_t_sed_poc                  ! possible change during remaining timestep
    real :: change_btf_t_sed_poc                 ! possible bottom tracer flux during remaining timestep
    real :: change_of_t_sed_pocn                 ! possible change during remaining timestep
    real :: change_btf_t_sed_pocn                ! possible bottom tracer flux during remaining timestep
    real :: change_of_t_sed_pocp                 ! possible change during remaining timestep
    real :: change_btf_t_sed_pocp                ! possible bottom tracer flux during remaining timestep
    real :: change_of_total_atmos_tot_N            ! possible change during remaining timestep
    real :: change_btf_total_atmos_tot_N           ! possible bottom tracer flux during remaining timestep
    real :: change_of_total_atmos_tot_N_at_bottom            ! possible change during remaining timestep
    real :: change_btf_total_atmos_tot_N_at_bottom           ! possible bottom tracer flux during remaining timestep
    real :: change_of_total_atmos_ship_N            ! possible change during remaining timestep
    real :: change_btf_total_atmos_ship_N           ! possible bottom tracer flux during remaining timestep
    real :: change_of_total_atmos_ship_N_at_bottom            ! possible change during remaining timestep
    real :: change_btf_total_atmos_ship_N_at_bottom           ! possible bottom tracer flux during remaining timestep
    real :: change_of_t_n2_with_atmos_tot_N            ! possible change during remaining timestep
    real :: change_btf_t_n2_with_atmos_tot_N           ! possible bottom tracer flux during remaining timestep
    real :: change_of_t_nh4_with_atmos_tot_N            ! possible change during remaining timestep
    real :: change_btf_t_nh4_with_atmos_tot_N           ! possible bottom tracer flux during remaining timestep
    real :: change_of_t_no3_with_atmos_tot_N            ! possible change during remaining timestep
    real :: change_btf_t_no3_with_atmos_tot_N           ! possible bottom tracer flux during remaining timestep
    real :: change_of_t_spp_with_atmos_tot_N            ! possible change during remaining timestep
    real :: change_btf_t_spp_with_atmos_tot_N           ! possible bottom tracer flux during remaining timestep
    real :: change_of_t_zoo_with_atmos_tot_N            ! possible change during remaining timestep
    real :: change_btf_t_zoo_with_atmos_tot_N           ! possible bottom tracer flux during remaining timestep
    real :: change_of_t_sed_with_atmos_tot_N            ! possible change during remaining timestep
    real :: change_btf_t_sed_with_atmos_tot_N           ! possible bottom tracer flux during remaining timestep
    real :: change_of_t_sed_pocn_with_atmos_tot_N            ! possible change during remaining timestep
    real :: change_btf_t_sed_pocn_with_atmos_tot_N           ! possible bottom tracer flux during remaining timestep
    real :: change_of_t_n2_with_atmos_ship_N            ! possible change during remaining timestep
    real :: change_btf_t_n2_with_atmos_ship_N           ! possible bottom tracer flux during remaining timestep
    real :: change_of_t_nh4_with_atmos_ship_N            ! possible change during remaining timestep
    real :: change_btf_t_nh4_with_atmos_ship_N           ! possible bottom tracer flux during remaining timestep
    real :: change_of_t_no3_with_atmos_ship_N            ! possible change during remaining timestep
    real :: change_btf_t_no3_with_atmos_ship_N           ! possible bottom tracer flux during remaining timestep
    real :: change_of_t_spp_with_atmos_ship_N            ! possible change during remaining timestep
    real :: change_btf_t_spp_with_atmos_ship_N           ! possible bottom tracer flux during remaining timestep
    real :: change_of_t_zoo_with_atmos_ship_N            ! possible change during remaining timestep
    real :: change_btf_t_zoo_with_atmos_ship_N           ! possible bottom tracer flux during remaining timestep
    real :: change_of_t_sed_with_atmos_ship_N            ! possible change during remaining timestep
    real :: change_btf_t_sed_with_atmos_ship_N           ! possible bottom tracer flux during remaining timestep
    real :: change_of_t_sed_pocn_with_atmos_ship_N            ! possible change during remaining timestep
    real :: change_btf_t_sed_pocn_with_atmos_ship_N           ! possible bottom tracer flux during remaining timestep
    real :: change_of_t_ipw                      ! possible change during remaining timestep
    real :: change_btf_t_ipw                     ! possible bottom tracer flux during remaining timestep
    real :: change_of_t_pocn_with_atmos_tot_N            ! possible change during remaining timestep
    real :: change_btf_t_pocn_with_atmos_tot_N           ! possible bottom tracer flux during remaining timestep
    real :: change_of_t_lpp_with_atmos_tot_N            ! possible change during remaining timestep
    real :: change_btf_t_lpp_with_atmos_tot_N           ! possible bottom tracer flux during remaining timestep
    real :: change_of_t_don_with_atmos_tot_N            ! possible change during remaining timestep
    real :: change_btf_t_don_with_atmos_tot_N           ! possible bottom tracer flux during remaining timestep
    real :: change_of_t_cya_with_atmos_tot_N            ! possible change during remaining timestep
    real :: change_btf_t_cya_with_atmos_tot_N           ! possible bottom tracer flux during remaining timestep
    real :: change_of_t_det_with_atmos_tot_N            ! possible change during remaining timestep
    real :: change_btf_t_det_with_atmos_tot_N           ! possible bottom tracer flux during remaining timestep
    real :: change_of_t_lpp                      ! possible change during remaining timestep
    real :: change_btf_t_lpp                     ! possible bottom tracer flux during remaining timestep
    real :: change_of_t_don                      ! possible change during remaining timestep
    real :: change_btf_t_don                     ! possible bottom tracer flux during remaining timestep
    real :: change_of_t_cya                      ! possible change during remaining timestep
    real :: change_btf_t_cya                     ! possible bottom tracer flux during remaining timestep
    real :: change_of_t_det                      ! possible change during remaining timestep
    real :: change_btf_t_det                     ! possible bottom tracer flux during remaining timestep
    real :: change_of_t_poc                      ! possible change during remaining timestep
    real :: change_btf_t_poc                     ! possible bottom tracer flux during remaining timestep
    real :: change_of_t_pocp                     ! possible change during remaining timestep
    real :: change_btf_t_pocp                    ! possible bottom tracer flux during remaining timestep
    real :: change_of_t_pocn                     ! possible change during remaining timestep
    real :: change_btf_t_pocn                    ! possible bottom tracer flux during remaining timestep
    real :: change_of_t_pocn_with_atmos_ship_N            ! possible change during remaining timestep
    real :: change_btf_t_pocn_with_atmos_ship_N           ! possible bottom tracer flux during remaining timestep
    real :: change_of_t_lpp_with_atmos_ship_N            ! possible change during remaining timestep
    real :: change_btf_t_lpp_with_atmos_ship_N           ! possible bottom tracer flux during remaining timestep
    real :: change_of_t_don_with_atmos_ship_N            ! possible change during remaining timestep
    real :: change_btf_t_don_with_atmos_ship_N           ! possible bottom tracer flux during remaining timestep
    real :: change_of_t_cya_with_atmos_ship_N            ! possible change during remaining timestep
    real :: change_btf_t_cya_with_atmos_ship_N           ! possible bottom tracer flux during remaining timestep
    real :: change_of_t_det_with_atmos_ship_N            ! possible change during remaining timestep
    real :: change_btf_t_det_with_atmos_ship_N           ! possible bottom tracer flux during remaining timestep
    real :: total_rate_p_no3_assim_lpp           ! total process rate accumulated during all sub-timesteps
    real :: total_rate_p_nh4_assim_lpp           ! total process rate accumulated during all sub-timesteps
    real :: total_rate_p_no3_assim_spp           ! total process rate accumulated during all sub-timesteps
    real :: total_rate_p_nh4_assim_spp           ! total process rate accumulated during all sub-timesteps
    real :: total_rate_p_n2_assim_cya            ! total process rate accumulated during all sub-timesteps
    real :: total_rate_p_assim_lpp_doc           ! total process rate accumulated during all sub-timesteps
    real :: total_rate_p_assim_spp_doc           ! total process rate accumulated during all sub-timesteps
    real :: total_rate_p_assim_cya_doc           ! total process rate accumulated during all sub-timesteps
    real :: total_rate_p_assim_lpp_dop           ! total process rate accumulated during all sub-timesteps
    real :: total_rate_p_assim_spp_dop           ! total process rate accumulated during all sub-timesteps
    real :: total_rate_p_nh4_assim_lpp_don           ! total process rate accumulated during all sub-timesteps
    real :: total_rate_p_no3_assim_lpp_don           ! total process rate accumulated during all sub-timesteps
    real :: total_rate_p_nh4_assim_spp_don           ! total process rate accumulated during all sub-timesteps
    real :: total_rate_p_no3_assim_spp_don           ! total process rate accumulated during all sub-timesteps
    real :: total_rate_p_poc_resp                ! total process rate accumulated during all sub-timesteps
    real :: total_rate_p_poc_denit               ! total process rate accumulated during all sub-timesteps
    real :: total_rate_p_poc_sulf                ! total process rate accumulated during all sub-timesteps
    real :: total_rate_p_pocp_resp               ! total process rate accumulated during all sub-timesteps
    real :: total_rate_p_pocp_denit              ! total process rate accumulated during all sub-timesteps
    real :: total_rate_p_pocp_sulf               ! total process rate accumulated during all sub-timesteps
    real :: total_rate_p_pocn_resp               ! total process rate accumulated during all sub-timesteps
    real :: total_rate_p_pocn_denit_noN2           ! total process rate accumulated during all sub-timesteps
    real :: total_rate_p_pocn_denit_wiN2           ! total process rate accumulated during all sub-timesteps
    real :: total_rate_p_pocn_sulf               ! total process rate accumulated during all sub-timesteps
    real :: total_rate_p_lpp_graz_zoo            ! total process rate accumulated during all sub-timesteps
    real :: total_rate_p_spp_graz_zoo            ! total process rate accumulated during all sub-timesteps
    real :: total_rate_p_cya_graz_zoo            ! total process rate accumulated during all sub-timesteps
    real :: total_rate_p_lpp_resp_nh4            ! total process rate accumulated during all sub-timesteps
    real :: total_rate_p_spp_resp_nh4            ! total process rate accumulated during all sub-timesteps
    real :: total_rate_p_cya_resp_nh4            ! total process rate accumulated during all sub-timesteps
    real :: total_rate_p_zoo_resp_nh4            ! total process rate accumulated during all sub-timesteps
    real :: total_rate_p_lpp_mort_det            ! total process rate accumulated during all sub-timesteps
    real :: total_rate_p_spp_mort_det            ! total process rate accumulated during all sub-timesteps
    real :: total_rate_p_cya_mort_det            ! total process rate accumulated during all sub-timesteps
    real :: total_rate_p_cya_mort_det_diff           ! total process rate accumulated during all sub-timesteps
    real :: total_rate_p_zoo_mort_det            ! total process rate accumulated during all sub-timesteps
    real :: total_rate_p_nh4_nit_no3             ! total process rate accumulated during all sub-timesteps
    real :: total_rate_p_det_resp_nh4            ! total process rate accumulated during all sub-timesteps
    real :: total_rate_p_det_denit_nh4           ! total process rate accumulated during all sub-timesteps
    real :: total_rate_p_det_sulf_nh4            ! total process rate accumulated during all sub-timesteps
    real :: total_rate_p_sed_resp_nh4            ! total process rate accumulated during all sub-timesteps
    real :: total_rate_p_nh4_nitdenit_n2           ! total process rate accumulated during all sub-timesteps
    real :: total_rate_p_sed_denit_nh4_noN2           ! total process rate accumulated during all sub-timesteps
    real :: total_rate_p_sed_denit_nh4_wiN2           ! total process rate accumulated during all sub-timesteps
    real :: total_rate_p_sed_sulf_nh4            ! total process rate accumulated during all sub-timesteps
    real :: total_rate_p_sed_poc_resp            ! total process rate accumulated during all sub-timesteps
    real :: total_rate_p_sed_poc_denit           ! total process rate accumulated during all sub-timesteps
    real :: total_rate_p_sed_poc_sulf            ! total process rate accumulated during all sub-timesteps
    real :: total_rate_p_po4_retent_ips           ! total process rate accumulated during all sub-timesteps
    real :: total_rate_p_ips_liber_po4           ! total process rate accumulated during all sub-timesteps
    real :: total_rate_p_h2s_oxo2_sul            ! total process rate accumulated during all sub-timesteps
    real :: total_rate_p_h2s_oxno3_sul           ! total process rate accumulated during all sub-timesteps
    real :: total_rate_p_sul_oxo2_so4            ! total process rate accumulated during all sub-timesteps
    real :: total_rate_p_sul_oxno3_so4           ! total process rate accumulated during all sub-timesteps
    real :: total_rate_p_det_sedi_sed            ! total process rate accumulated during all sub-timesteps
    real :: total_rate_p_ipw_sedi_ips            ! total process rate accumulated during all sub-timesteps
    real :: total_rate_p_poc_sedi_sed            ! total process rate accumulated during all sub-timesteps
    real :: total_rate_p_pocn_sedi_sed           ! total process rate accumulated during all sub-timesteps
    real :: total_rate_p_pocp_sedi_sed           ! total process rate accumulated during all sub-timesteps
    real :: total_rate_p_sed_ero_det             ! total process rate accumulated during all sub-timesteps
    real :: total_rate_p_ips_ero_ipw             ! total process rate accumulated during all sub-timesteps
    real :: total_rate_p_sed_ero_poc             ! total process rate accumulated during all sub-timesteps
    real :: total_rate_p_sed_ero_pocn            ! total process rate accumulated during all sub-timesteps
    real :: total_rate_p_sed_ero_pocp            ! total process rate accumulated during all sub-timesteps
    real :: total_rate_p_sed_biores_det           ! total process rate accumulated during all sub-timesteps
    real :: total_rate_p_ips_biores_ipw           ! total process rate accumulated during all sub-timesteps
    real :: total_rate_p_sed_biores_poc           ! total process rate accumulated during all sub-timesteps
    real :: total_rate_p_sed_biores_pocn           ! total process rate accumulated during all sub-timesteps
    real :: total_rate_p_sed_biores_pocp           ! total process rate accumulated during all sub-timesteps
    real :: total_rate_p_sed_burial              ! total process rate accumulated during all sub-timesteps
    real :: total_rate_p_ips_burial              ! total process rate accumulated during all sub-timesteps
    real :: total_rate_p_poc_burial              ! total process rate accumulated during all sub-timesteps
    real :: total_rate_p_pocn_burial             ! total process rate accumulated during all sub-timesteps
    real :: total_rate_p_pocp_burial             ! total process rate accumulated during all sub-timesteps
    real :: total_rate_p_sed_pocn_resp           ! total process rate accumulated during all sub-timesteps
    real :: total_rate_p_sed_pocp_resp           ! total process rate accumulated during all sub-timesteps
    real :: total_rate_p_sed_pocn_denit_noN2           ! total process rate accumulated during all sub-timesteps
    real :: total_rate_p_sed_pocn_denit_wiN2           ! total process rate accumulated during all sub-timesteps
    real :: total_rate_p_sed_pocp_denit           ! total process rate accumulated during all sub-timesteps
    real :: total_rate_p_sed_pocn_sulf           ! total process rate accumulated during all sub-timesteps
    real :: total_rate_p_sed_pocp_sulf           ! total process rate accumulated during all sub-timesteps
    real :: total_rate_p_nh4_nitdenit_pocn_n2           ! total process rate accumulated during all sub-timesteps
    real :: total_rate_p_doc2pco                 ! total process rate accumulated during all sub-timesteps
    real :: total_rate_p_dop2pocp                ! total process rate accumulated during all sub-timesteps
    real :: total_rate_p_don2pocn                ! total process rate accumulated during all sub-timesteps
    real :: total_rate_p_doc_resp                ! total process rate accumulated during all sub-timesteps
    real :: total_rate_p_doc_denit               ! total process rate accumulated during all sub-timesteps
    real :: total_rate_p_doc_sulf                ! total process rate accumulated during all sub-timesteps
    real :: total_rate_p_dop_resp                ! total process rate accumulated during all sub-timesteps
    real :: total_rate_p_dop_denit               ! total process rate accumulated during all sub-timesteps
    real :: total_rate_p_dop_sulf                ! total process rate accumulated during all sub-timesteps
    real :: total_rate_p_don_resp                ! total process rate accumulated during all sub-timesteps
    real :: total_rate_p_don_denit_noN2           ! total process rate accumulated during all sub-timesteps
    real :: total_rate_p_don_denit_wiN2           ! total process rate accumulated during all sub-timesteps
    real :: total_rate_p_don_sulf                ! total process rate accumulated during all sub-timesteps
    real :: total_rate_p_no3_assim_lpp_atmos_tot_N           ! total process rate accumulated during all sub-timesteps
    real :: total_rate_p_nh4_assim_lpp_atmos_tot_N           ! total process rate accumulated during all sub-timesteps
    real :: total_rate_p_no3_assim_spp_atmos_tot_N           ! total process rate accumulated during all sub-timesteps
    real :: total_rate_p_nh4_assim_spp_atmos_tot_N           ! total process rate accumulated during all sub-timesteps
    real :: total_rate_p_nh4_assim_lpp_don_atmos_tot_N           ! total process rate accumulated during all sub-timesteps
    real :: total_rate_p_no3_assim_lpp_don_atmos_tot_N           ! total process rate accumulated during all sub-timesteps
    real :: total_rate_p_nh4_assim_spp_don_atmos_tot_N           ! total process rate accumulated during all sub-timesteps
    real :: total_rate_p_no3_assim_spp_don_atmos_tot_N           ! total process rate accumulated during all sub-timesteps
    real :: total_rate_p_pocn_resp_atmos_tot_N           ! total process rate accumulated during all sub-timesteps
    real :: total_rate_p_pocn_denit_noN2_atmos_tot_N           ! total process rate accumulated during all sub-timesteps
    real :: total_rate_p_pocn_sulf_atmos_tot_N           ! total process rate accumulated during all sub-timesteps
    real :: total_rate_p_lpp_graz_zoo_atmos_tot_N           ! total process rate accumulated during all sub-timesteps
    real :: total_rate_p_spp_graz_zoo_atmos_tot_N           ! total process rate accumulated during all sub-timesteps
    real :: total_rate_p_cya_graz_zoo_atmos_tot_N           ! total process rate accumulated during all sub-timesteps
    real :: total_rate_p_lpp_resp_nh4_atmos_tot_N           ! total process rate accumulated during all sub-timesteps
    real :: total_rate_p_spp_resp_nh4_atmos_tot_N           ! total process rate accumulated during all sub-timesteps
    real :: total_rate_p_cya_resp_nh4_atmos_tot_N           ! total process rate accumulated during all sub-timesteps
    real :: total_rate_p_zoo_resp_nh4_atmos_tot_N           ! total process rate accumulated during all sub-timesteps
    real :: total_rate_p_lpp_mort_det_atmos_tot_N           ! total process rate accumulated during all sub-timesteps
    real :: total_rate_p_spp_mort_det_atmos_tot_N           ! total process rate accumulated during all sub-timesteps
    real :: total_rate_p_cya_mort_det_atmos_tot_N           ! total process rate accumulated during all sub-timesteps
    real :: total_rate_p_cya_mort_det_diff_atmos_tot_N           ! total process rate accumulated during all sub-timesteps
    real :: total_rate_p_zoo_mort_det_atmos_tot_N           ! total process rate accumulated during all sub-timesteps
    real :: total_rate_p_nh4_nit_no3_atmos_tot_N           ! total process rate accumulated during all sub-timesteps
    real :: total_rate_p_det_resp_nh4_atmos_tot_N           ! total process rate accumulated during all sub-timesteps
    real :: total_rate_p_det_sulf_nh4_atmos_tot_N           ! total process rate accumulated during all sub-timesteps
    real :: total_rate_p_sed_resp_nh4_atmos_tot_N           ! total process rate accumulated during all sub-timesteps
    real :: total_rate_p_sed_denit_nh4_noN2_atmos_tot_N           ! total process rate accumulated during all sub-timesteps
    real :: total_rate_p_sed_sulf_nh4_atmos_tot_N           ! total process rate accumulated during all sub-timesteps
    real :: total_rate_p_det_sedi_sed_atmos_tot_N           ! total process rate accumulated during all sub-timesteps
    real :: total_rate_p_pocn_sedi_sed_atmos_tot_N           ! total process rate accumulated during all sub-timesteps
    real :: total_rate_p_sed_ero_det_atmos_tot_N           ! total process rate accumulated during all sub-timesteps
    real :: total_rate_p_sed_ero_pocn_atmos_tot_N           ! total process rate accumulated during all sub-timesteps
    real :: total_rate_p_sed_biores_det_atmos_tot_N           ! total process rate accumulated during all sub-timesteps
    real :: total_rate_p_sed_biores_pocn_atmos_tot_N           ! total process rate accumulated during all sub-timesteps
    real :: total_rate_p_sed_burial_atmos_tot_N           ! total process rate accumulated during all sub-timesteps
    real :: total_rate_p_pocn_burial_atmos_tot_N           ! total process rate accumulated during all sub-timesteps
    real :: total_rate_p_sed_pocn_resp_atmos_tot_N           ! total process rate accumulated during all sub-timesteps
    real :: total_rate_p_sed_pocn_denit_noN2_atmos_tot_N           ! total process rate accumulated during all sub-timesteps
    real :: total_rate_p_sed_pocn_sulf_atmos_tot_N           ! total process rate accumulated during all sub-timesteps
    real :: total_rate_p_don2pocn_atmos_tot_N           ! total process rate accumulated during all sub-timesteps
    real :: total_rate_p_don_resp_atmos_tot_N           ! total process rate accumulated during all sub-timesteps
    real :: total_rate_p_don_denit_noN2_atmos_tot_N           ! total process rate accumulated during all sub-timesteps
    real :: total_rate_p_don_sulf_atmos_tot_N           ! total process rate accumulated during all sub-timesteps
    real :: total_rate_p_no3_assim_lpp_atmos_ship_N           ! total process rate accumulated during all sub-timesteps
    real :: total_rate_p_nh4_assim_lpp_atmos_ship_N           ! total process rate accumulated during all sub-timesteps
    real :: total_rate_p_no3_assim_spp_atmos_ship_N           ! total process rate accumulated during all sub-timesteps
    real :: total_rate_p_nh4_assim_spp_atmos_ship_N           ! total process rate accumulated during all sub-timesteps
    real :: total_rate_p_nh4_assim_lpp_don_atmos_ship_N           ! total process rate accumulated during all sub-timesteps
    real :: total_rate_p_no3_assim_lpp_don_atmos_ship_N           ! total process rate accumulated during all sub-timesteps
    real :: total_rate_p_nh4_assim_spp_don_atmos_ship_N           ! total process rate accumulated during all sub-timesteps
    real :: total_rate_p_no3_assim_spp_don_atmos_ship_N           ! total process rate accumulated during all sub-timesteps
    real :: total_rate_p_pocn_resp_atmos_ship_N           ! total process rate accumulated during all sub-timesteps
    real :: total_rate_p_pocn_denit_noN2_atmos_ship_N           ! total process rate accumulated during all sub-timesteps
    real :: total_rate_p_pocn_sulf_atmos_ship_N           ! total process rate accumulated during all sub-timesteps
    real :: total_rate_p_lpp_graz_zoo_atmos_ship_N           ! total process rate accumulated during all sub-timesteps
    real :: total_rate_p_spp_graz_zoo_atmos_ship_N           ! total process rate accumulated during all sub-timesteps
    real :: total_rate_p_cya_graz_zoo_atmos_ship_N           ! total process rate accumulated during all sub-timesteps
    real :: total_rate_p_lpp_resp_nh4_atmos_ship_N           ! total process rate accumulated during all sub-timesteps
    real :: total_rate_p_spp_resp_nh4_atmos_ship_N           ! total process rate accumulated during all sub-timesteps
    real :: total_rate_p_cya_resp_nh4_atmos_ship_N           ! total process rate accumulated during all sub-timesteps
    real :: total_rate_p_zoo_resp_nh4_atmos_ship_N           ! total process rate accumulated during all sub-timesteps
    real :: total_rate_p_lpp_mort_det_atmos_ship_N           ! total process rate accumulated during all sub-timesteps
    real :: total_rate_p_spp_mort_det_atmos_ship_N           ! total process rate accumulated during all sub-timesteps
    real :: total_rate_p_cya_mort_det_atmos_ship_N           ! total process rate accumulated during all sub-timesteps
    real :: total_rate_p_cya_mort_det_diff_atmos_ship_N           ! total process rate accumulated during all sub-timesteps
    real :: total_rate_p_zoo_mort_det_atmos_ship_N           ! total process rate accumulated during all sub-timesteps
    real :: total_rate_p_nh4_nit_no3_atmos_ship_N           ! total process rate accumulated during all sub-timesteps
    real :: total_rate_p_det_resp_nh4_atmos_ship_N           ! total process rate accumulated during all sub-timesteps
    real :: total_rate_p_det_sulf_nh4_atmos_ship_N           ! total process rate accumulated during all sub-timesteps
    real :: total_rate_p_sed_resp_nh4_atmos_ship_N           ! total process rate accumulated during all sub-timesteps
    real :: total_rate_p_sed_denit_nh4_noN2_atmos_ship_N           ! total process rate accumulated during all sub-timesteps
    real :: total_rate_p_sed_sulf_nh4_atmos_ship_N           ! total process rate accumulated during all sub-timesteps
    real :: total_rate_p_det_sedi_sed_atmos_ship_N           ! total process rate accumulated during all sub-timesteps
    real :: total_rate_p_pocn_sedi_sed_atmos_ship_N           ! total process rate accumulated during all sub-timesteps
    real :: total_rate_p_sed_ero_det_atmos_ship_N           ! total process rate accumulated during all sub-timesteps
    real :: total_rate_p_sed_ero_pocn_atmos_ship_N           ! total process rate accumulated during all sub-timesteps
    real :: total_rate_p_sed_biores_det_atmos_ship_N           ! total process rate accumulated during all sub-timesteps
    real :: total_rate_p_sed_biores_pocn_atmos_ship_N           ! total process rate accumulated during all sub-timesteps
    real :: total_rate_p_sed_burial_atmos_ship_N           ! total process rate accumulated during all sub-timesteps
    real :: total_rate_p_pocn_burial_atmos_ship_N           ! total process rate accumulated during all sub-timesteps
    real :: total_rate_p_sed_pocn_resp_atmos_ship_N           ! total process rate accumulated during all sub-timesteps
    real :: total_rate_p_sed_pocn_denit_noN2_atmos_ship_N           ! total process rate accumulated during all sub-timesteps
    real :: total_rate_p_sed_pocn_sulf_atmos_ship_N           ! total process rate accumulated during all sub-timesteps
    real :: total_rate_p_don2pocn_atmos_ship_N           ! total process rate accumulated during all sub-timesteps
    real :: total_rate_p_don_resp_atmos_ship_N           ! total process rate accumulated during all sub-timesteps
    real :: total_rate_p_don_denit_noN2_atmos_ship_N           ! total process rate accumulated during all sub-timesteps
    real :: total_rate_p_don_sulf_atmos_ship_N           ! total process rate accumulated during all sub-timesteps
    integer :: which_tracer_exhausted   ! stores the number of the exhausted tracer

    call mpp_clock_begin(id_source)
    call mpp_clock_begin(id_preloop)

    call g_tracer_get_common(isc,iec,jsc,jec,isd,ied,jsd,jed,nk,ntau,&
         grid_tmask=grid_tmask,grid_mask_coast=mask_coast,grid_kmt=grid_kmt)

    !Get all 2d tracer values
    call user_get_2d_tracer_values(tracer_list,isd,ied,jsd,jed,nk)
    if (NUM_SEDIMENT_LAYERS .gt. 1) then
       !Get values for fluffy layer
       call g_tracer_get_values(tracer_list,'t_sed          '  ,'field',ergom%temp3darray,isd,jsd,ntau=1)
       ergom%t_sed           = ergom%temp3darray(:,:,1)
       call g_tracer_get_values(tracer_list,'t_ips          '  ,'field',ergom%temp3darray,isd,jsd,ntau=1)
       ergom%t_ips           = ergom%temp3darray(:,:,1)
       call g_tracer_get_values(tracer_list,'t_sed_poc      '  ,'field',ergom%temp3darray,isd,jsd,ntau=1)
       ergom%t_sed_poc       = ergom%temp3darray(:,:,1)
       call g_tracer_get_values(tracer_list,'t_sed_pocn     '  ,'field',ergom%temp3darray,isd,jsd,ntau=1)
       ergom%t_sed_pocn      = ergom%temp3darray(:,:,1)
       call g_tracer_get_values(tracer_list,'t_sed_pocp     '  ,'field',ergom%temp3darray,isd,jsd,ntau=1)
       ergom%t_sed_pocp      = ergom%temp3darray(:,:,1)
       call g_tracer_get_values(tracer_list,'total_atmos_tot_N_at_bottom'  ,'field',ergom%temp3darray,isd,jsd,ntau=1)
       ergom%total_atmos_tot_N_at_bottom = ergom%temp3darray(:,:,1)
       call g_tracer_get_values(tracer_list,'total_atmos_ship_N_at_bottom'  ,'field',ergom%temp3darray,isd,jsd,ntau=1)
       ergom%total_atmos_ship_N_at_bottom = ergom%temp3darray(:,:,1)
       call g_tracer_get_values(tracer_list,'t_sed_with_atmos_tot_N'  ,'field',ergom%temp3darray,isd,jsd,ntau=1)
       ergom%t_sed_with_atmos_tot_N = ergom%temp3darray(:,:,1)
       call g_tracer_get_values(tracer_list,'t_sed_pocn_with_atmos_tot_N'  ,'field',ergom%temp3darray,isd,jsd,ntau=1)
       ergom%t_sed_pocn_with_atmos_tot_N = ergom%temp3darray(:,:,1)
       call g_tracer_get_values(tracer_list,'t_sed_with_atmos_ship_N'  ,'field',ergom%temp3darray,isd,jsd,ntau=1)
       ergom%t_sed_with_atmos_ship_N = ergom%temp3darray(:,:,1)
       call g_tracer_get_values(tracer_list,'t_sed_pocn_with_atmos_ship_N'  ,'field',ergom%temp3darray,isd,jsd,ntau=1)
       ergom%t_sed_pocn_with_atmos_ship_N = ergom%temp3darray(:,:,1)
    endif

    !Get the pointers to the prognostic tracers after applying the physics.
    call g_tracer_get_pointer(tracer_list,'t_n2           '  ,'field',ergom%t_n2               )
    call g_tracer_get_pointer(tracer_list,'t_o2           '  ,'field',ergom%t_o2               )
    call g_tracer_get_pointer(tracer_list,'t_dic          '  ,'field',ergom%t_dic              )
    call g_tracer_get_pointer(tracer_list,'t_nh4          '  ,'field',ergom%t_nh4              )
    call g_tracer_get_pointer(tracer_list,'t_no3          '  ,'field',ergom%t_no3              )
    call g_tracer_get_pointer(tracer_list,'t_po4          '  ,'field',ergom%t_po4              )
    call g_tracer_get_pointer(tracer_list,'t_spp          '  ,'field',ergom%t_spp              )
    call g_tracer_get_pointer(tracer_list,'t_zoo          '  ,'field',ergom%t_zoo              )
    call g_tracer_get_pointer(tracer_list,'t_h2s          '  ,'field',ergom%t_h2s              )
    call g_tracer_get_pointer(tracer_list,'t_sul          '  ,'field',ergom%t_sul              )
    call g_tracer_get_pointer(tracer_list,'t_alk          '  ,'field',ergom%t_alk              )
    call g_tracer_get_pointer(tracer_list,'t_doc          '  ,'field',ergom%t_doc              )
    call g_tracer_get_pointer(tracer_list,'t_dop          '  ,'field',ergom%t_dop              )
    call g_tracer_get_pointer(tracer_list,'total_atmos_tot_N'  ,'field',ergom%total_atmos_tot_N    )
    call g_tracer_get_pointer(tracer_list,'total_atmos_ship_N'  ,'field',ergom%total_atmos_ship_N    )
    call g_tracer_get_pointer(tracer_list,'t_n2_with_atmos_tot_N'  ,'field',ergom%t_n2_with_atmos_tot_N    )
    call g_tracer_get_pointer(tracer_list,'t_nh4_with_atmos_tot_N'  ,'field',ergom%t_nh4_with_atmos_tot_N    )
    call g_tracer_get_pointer(tracer_list,'t_no3_with_atmos_tot_N'  ,'field',ergom%t_no3_with_atmos_tot_N    )
    call g_tracer_get_pointer(tracer_list,'t_spp_with_atmos_tot_N'  ,'field',ergom%t_spp_with_atmos_tot_N    )
    call g_tracer_get_pointer(tracer_list,'t_zoo_with_atmos_tot_N'  ,'field',ergom%t_zoo_with_atmos_tot_N    )
    call g_tracer_get_pointer(tracer_list,'t_n2_with_atmos_ship_N'  ,'field',ergom%t_n2_with_atmos_ship_N    )
    call g_tracer_get_pointer(tracer_list,'t_nh4_with_atmos_ship_N'  ,'field',ergom%t_nh4_with_atmos_ship_N    )
    call g_tracer_get_pointer(tracer_list,'t_no3_with_atmos_ship_N'  ,'field',ergom%t_no3_with_atmos_ship_N    )
    call g_tracer_get_pointer(tracer_list,'t_spp_with_atmos_ship_N'  ,'field',ergom%t_spp_with_atmos_ship_N    )
    call g_tracer_get_pointer(tracer_list,'t_zoo_with_atmos_ship_N'  ,'field',ergom%t_zoo_with_atmos_ship_N    )
    call g_tracer_get_pointer(tracer_list,'t_ipw          '  ,'field',ergom%t_ipw              )
    call g_tracer_get_pointer(tracer_list,'t_pocn_with_atmos_tot_N'  ,'field',ergom%t_pocn_with_atmos_tot_N    )
    call g_tracer_get_pointer(tracer_list,'t_lpp_with_atmos_tot_N'  ,'field',ergom%t_lpp_with_atmos_tot_N    )
    call g_tracer_get_pointer(tracer_list,'t_don_with_atmos_tot_N'  ,'field',ergom%t_don_with_atmos_tot_N    )
    call g_tracer_get_pointer(tracer_list,'t_cya_with_atmos_tot_N'  ,'field',ergom%t_cya_with_atmos_tot_N    )
    call g_tracer_get_pointer(tracer_list,'t_det_with_atmos_tot_N'  ,'field',ergom%t_det_with_atmos_tot_N    )
    call g_tracer_get_pointer(tracer_list,'t_lpp          '  ,'field',ergom%t_lpp              )
    call g_tracer_get_pointer(tracer_list,'t_don          '  ,'field',ergom%t_don              )
    call g_tracer_get_pointer(tracer_list,'t_cya          '  ,'field',ergom%t_cya              )
    call g_tracer_get_pointer(tracer_list,'t_det          '  ,'field',ergom%t_det              )
    call g_tracer_get_pointer(tracer_list,'t_poc          '  ,'field',ergom%t_poc              )
    call g_tracer_get_pointer(tracer_list,'t_pocp         '  ,'field',ergom%t_pocp             )
    call g_tracer_get_pointer(tracer_list,'t_pocn         '  ,'field',ergom%t_pocn             )
    call g_tracer_get_pointer(tracer_list,'t_pocn_with_atmos_ship_N'  ,'field',ergom%t_pocn_with_atmos_ship_N    )
    call g_tracer_get_pointer(tracer_list,'t_lpp_with_atmos_ship_N'  ,'field',ergom%t_lpp_with_atmos_ship_N    )
    call g_tracer_get_pointer(tracer_list,'t_don_with_atmos_ship_N'  ,'field',ergom%t_don_with_atmos_ship_N    )
    call g_tracer_get_pointer(tracer_list,'t_cya_with_atmos_ship_N'  ,'field',ergom%t_cya_with_atmos_ship_N    )
    call g_tracer_get_pointer(tracer_list,'t_det_with_atmos_ship_N'  ,'field',ergom%t_det_with_atmos_ship_N    )

    ! get the pointers to vertical velocity and diffusivity fields
    call g_tracer_get_pointer(tracer_list,'t_ipw          ','vmove',ergom%vmove_t_ipw          )
    call g_tracer_get_pointer(tracer_list,'t_ipw          ','vdiff',ergom%vdiff_t_ipw          )
    call g_tracer_get_pointer(tracer_list,'t_pocn_with_atmos_tot_N','vmove',ergom%vmove_t_pocn_with_atmos_tot_N)
    call g_tracer_get_pointer(tracer_list,'t_pocn_with_atmos_tot_N','vdiff',ergom%vdiff_t_pocn_with_atmos_tot_N)
    call g_tracer_get_pointer(tracer_list,'t_lpp_with_atmos_tot_N','vmove',ergom%vmove_t_lpp_with_atmos_tot_N)
    call g_tracer_get_pointer(tracer_list,'t_lpp_with_atmos_tot_N','vdiff',ergom%vdiff_t_lpp_with_atmos_tot_N)
    call g_tracer_get_pointer(tracer_list,'t_don_with_atmos_tot_N','vmove',ergom%vmove_t_don_with_atmos_tot_N)
    call g_tracer_get_pointer(tracer_list,'t_don_with_atmos_tot_N','vdiff',ergom%vdiff_t_don_with_atmos_tot_N)
    call g_tracer_get_pointer(tracer_list,'t_cya_with_atmos_tot_N','vmove',ergom%vmove_t_cya_with_atmos_tot_N)
    call g_tracer_get_pointer(tracer_list,'t_cya_with_atmos_tot_N','vdiff',ergom%vdiff_t_cya_with_atmos_tot_N)
    call g_tracer_get_pointer(tracer_list,'t_det_with_atmos_tot_N','vmove',ergom%vmove_t_det_with_atmos_tot_N)
    call g_tracer_get_pointer(tracer_list,'t_det_with_atmos_tot_N','vdiff',ergom%vdiff_t_det_with_atmos_tot_N)
    call g_tracer_get_pointer(tracer_list,'t_lpp          ','vmove',ergom%vmove_t_lpp          )
    call g_tracer_get_pointer(tracer_list,'t_lpp          ','vdiff',ergom%vdiff_t_lpp          )
    call g_tracer_get_pointer(tracer_list,'t_don          ','vmove',ergom%vmove_t_don          )
    call g_tracer_get_pointer(tracer_list,'t_don          ','vdiff',ergom%vdiff_t_don          )
    call g_tracer_get_pointer(tracer_list,'t_cya          ','vmove',ergom%vmove_t_cya          )
    call g_tracer_get_pointer(tracer_list,'t_cya          ','vdiff',ergom%vdiff_t_cya          )
    call g_tracer_get_pointer(tracer_list,'t_det          ','vmove',ergom%vmove_t_det          )
    call g_tracer_get_pointer(tracer_list,'t_det          ','vdiff',ergom%vdiff_t_det          )
    call g_tracer_get_pointer(tracer_list,'t_poc          ','vmove',ergom%vmove_t_poc          )
    call g_tracer_get_pointer(tracer_list,'t_poc          ','vdiff',ergom%vdiff_t_poc          )
    call g_tracer_get_pointer(tracer_list,'t_pocp         ','vmove',ergom%vmove_t_pocp         )
    call g_tracer_get_pointer(tracer_list,'t_pocp         ','vdiff',ergom%vdiff_t_pocp         )
    call g_tracer_get_pointer(tracer_list,'t_pocn         ','vmove',ergom%vmove_t_pocn         )
    call g_tracer_get_pointer(tracer_list,'t_pocn         ','vdiff',ergom%vdiff_t_pocn         )
    call g_tracer_get_pointer(tracer_list,'t_pocn_with_atmos_ship_N','vmove',ergom%vmove_t_pocn_with_atmos_ship_N)
    call g_tracer_get_pointer(tracer_list,'t_pocn_with_atmos_ship_N','vdiff',ergom%vdiff_t_pocn_with_atmos_ship_N)
    call g_tracer_get_pointer(tracer_list,'t_lpp_with_atmos_ship_N','vmove',ergom%vmove_t_lpp_with_atmos_ship_N)
    call g_tracer_get_pointer(tracer_list,'t_lpp_with_atmos_ship_N','vdiff',ergom%vdiff_t_lpp_with_atmos_ship_N)
    call g_tracer_get_pointer(tracer_list,'t_don_with_atmos_ship_N','vmove',ergom%vmove_t_don_with_atmos_ship_N)
    call g_tracer_get_pointer(tracer_list,'t_don_with_atmos_ship_N','vdiff',ergom%vdiff_t_don_with_atmos_ship_N)
    call g_tracer_get_pointer(tracer_list,'t_cya_with_atmos_ship_N','vmove',ergom%vmove_t_cya_with_atmos_ship_N)
    call g_tracer_get_pointer(tracer_list,'t_cya_with_atmos_ship_N','vdiff',ergom%vdiff_t_cya_with_atmos_ship_N)
    call g_tracer_get_pointer(tracer_list,'t_det_with_atmos_ship_N','vmove',ergom%vmove_t_det_with_atmos_ship_N)
    call g_tracer_get_pointer(tracer_list,'t_det_with_atmos_ship_N','vdiff',ergom%vdiff_t_det_with_atmos_ship_N)

! light calculation
! note: opacity_band already includes light path extension due to sun angle, if respective namelist option is set
!       e.g. ocean_shortwave_jerlov.F90
    allocate(light1(isc:iec,jsc:jec))
    allocate(light2(isc:iec,jsc:jec))

    nband = 1
    if (.NOT. genus_style_par) then
!       k = 1
!       do j = jsc, jec ; do i = isc, iec  !{
!         ergom%irr_inst(i,j,k) = 0.5 * sw_pen_band(nband,i,j) * exp(-opacity_band(nband,i,j,k)* dzt(i,j,k)*0.5)
!       enddo; enddo  !} i,j
!       do k = 2, nk ; do j = jsc, jec ; do i = isc, iec  !{
!         ergom%irr_inst(i,j,k) = ergom%irr_inst(i,j,k-1) * exp(-opacity_band(nband,i,j,k)* dzt(i,j,k))
!       enddo; enddo ; enddo  !} i,j,k
      k=1  
!      estimate light at the middle of the tracer layer, this might not be exactly where the tracer point is
      do j = jsc, jec ; do i = isc, iec
         light1(i,j) = 0.5*sw_pen_band(nband,i,j)
      enddo; enddo
      do k=1, nk
         do j = jsc, jec ; do i = isc, iec
            light2(i,j) = light1(i,j)*exp(-opacity_band(nband,i,j,k)* dzt(i,j,k))
            ergom%irr_inst(i,j,k) = light1(i,j) * exp(-opacity_band(nband,i,j,k)* 0.5*dzt(i,j,k))
            light1(i,j) = light2(i,j)
         enddo; enddo
      enddo
    else
       k = 1
       do j = jsc, jec ; do i = isc, iec  !{
         light_itemp = opacity_band(nband,i,j,k)* dzt(i,j,k)
         light_ntemp = exp(-light_itemp)
         ergom%irr_zw(i,j,k)   = 0.5 * sw_pen_band(nband,i,j) * light_ntemp
         ergom%irr_inst(i,j,k) = 0.5 * sw_pen_band(nband,i,j) * ( 1. -  light_ntemp ) / light_itemp
       enddo; enddo  !} i,j
       do k = 2, nk ; do j = jsc, jec ; do i = isc, iec  !{
         light_itemp = opacity_band(nband,i,j,k)* dzt(i,j,k) + 1.0e-30  ! some schemes give zero opa. in the nk-layer
         light_ntemp = exp(-light_itemp)
         ergom%irr_zw(i,j,k)   = ergom%irr_zw(i,j,k-1) * light_ntemp
         ergom%irr_inst(i,j,k) = ergom%irr_zw(i,j,k-1) * ( 1.-  light_ntemp ) / light_itemp
       enddo; enddo ; enddo  !} i,j,k
    endif
    deallocate(light1)
    deallocate(light2)

    !------------------------------------
    ! STEP 1: calculate total element concentrations
    !------------------------------------

    !------------------------------------
    ! STEP 1.1: calculate total element concentrations in water column
    !------------------------------------
    do k = 1, nk
       do j = jsc, jec
          do i = isc, iec
             ergom%total_atmos_tot_N(i,j,k,tau) = &
                max(0.0,ergom%t_n2_with_atmos_tot_N(i,j,k,tau))*2 + &
                max(0.0,ergom%t_nh4_with_atmos_tot_N(i,j,k,tau))*1 + &
                max(0.0,ergom%t_no3_with_atmos_tot_N(i,j,k,tau))*1 + &
                max(0.0,ergom%t_spp_with_atmos_tot_N(i,j,k,tau))*1 + &
                max(0.0,ergom%t_zoo_with_atmos_tot_N(i,j,k,tau))*1 + &
                max(0.0,ergom%t_pocn_with_atmos_tot_N(i,j,k,tau))*1 + &
                max(0.0,ergom%t_lpp_with_atmos_tot_N(i,j,k,tau))*1 + &
                max(0.0,ergom%t_don_with_atmos_tot_N(i,j,k,tau))*1 + &
                max(0.0,ergom%t_cya_with_atmos_tot_N(i,j,k,tau))*1 + &
                max(0.0,ergom%t_det_with_atmos_tot_N(i,j,k,tau))*1 + &
                0.0
             ergom%total_atmos_ship_N(i,j,k,tau) = &
                max(0.0,ergom%t_n2_with_atmos_ship_N(i,j,k,tau))*2 + &
                max(0.0,ergom%t_nh4_with_atmos_ship_N(i,j,k,tau))*1 + &
                max(0.0,ergom%t_no3_with_atmos_ship_N(i,j,k,tau))*1 + &
                max(0.0,ergom%t_spp_with_atmos_ship_N(i,j,k,tau))*1 + &
                max(0.0,ergom%t_zoo_with_atmos_ship_N(i,j,k,tau))*1 + &
                max(0.0,ergom%t_pocn_with_atmos_ship_N(i,j,k,tau))*1 + &
                max(0.0,ergom%t_lpp_with_atmos_ship_N(i,j,k,tau))*1 + &
                max(0.0,ergom%t_don_with_atmos_ship_N(i,j,k,tau))*1 + &
                max(0.0,ergom%t_cya_with_atmos_ship_N(i,j,k,tau))*1 + &
                max(0.0,ergom%t_det_with_atmos_ship_N(i,j,k,tau))*1 + &
                0.0
          enddo
       enddo
    enddo

    !------------------------------------
    ! STEP 1.2: calculate total element concentrations in the fluff layer
    !------------------------------------
    do j = jsc, jec
       do i = isc, iec
          ergom%total_atmos_tot_N_at_bottom(i,j) = &
             ergom%t_sed_with_atmos_tot_N(i,j)*1 + &
             ergom%t_sed_pocn_with_atmos_tot_N(i,j)*1 + &
             0.0
          ergom%total_atmos_ship_N_at_bottom(i,j) = &
             ergom%t_sed_with_atmos_ship_N(i,j)*1 + &
             ergom%t_sed_pocn_with_atmos_ship_N(i,j)*1 + &
             0.0
       enddo
    enddo

    !------------------------------------
    ! STEP 2: calculate space-independent forcing variables
    !------------------------------------

    call get_date(model_time,cgt_year,cgt_mymonth,cgt_myday,cgt_myhour,cgt_myminute,cgt_mysecond)
    cgt_hour = cgt_myhour + cgt_myminute/60 + cgt_mysecond/3600
    cgt_myhour=days_in_year(model_time)
    if (cgt_myhour .eq. 366) then
       if (cgt_mymonth .eq.  1) cgt_dayofyear = cgt_myday
       if (cgt_mymonth .eq.  2) cgt_dayofyear = cgt_myday +  31
       if (cgt_mymonth .eq.  3) cgt_dayofyear = cgt_myday +  60
       if (cgt_mymonth .eq.  4) cgt_dayofyear = cgt_myday +  91
       if (cgt_mymonth .eq.  5) cgt_dayofyear = cgt_myday + 121
       if (cgt_mymonth .eq.  6) cgt_dayofyear = cgt_myday + 152
       if (cgt_mymonth .eq.  7) cgt_dayofyear = cgt_myday + 182
       if (cgt_mymonth .eq.  8) cgt_dayofyear = cgt_myday + 213
       if (cgt_mymonth .eq.  9) cgt_dayofyear = cgt_myday + 244
       if (cgt_mymonth .eq. 10) cgt_dayofyear = cgt_myday + 274
       if (cgt_mymonth .eq. 11) cgt_dayofyear = cgt_myday + 305
       if (cgt_mymonth .eq. 12) cgt_dayofyear = cgt_myday + 335
    else
       if (cgt_mymonth .eq.  1) cgt_dayofyear = cgt_myday
       if (cgt_mymonth .eq.  2) cgt_dayofyear = cgt_myday +  31
       if (cgt_mymonth .eq.  3) cgt_dayofyear = cgt_myday +  59
       if (cgt_mymonth .eq.  4) cgt_dayofyear = cgt_myday +  90
       if (cgt_mymonth .eq.  5) cgt_dayofyear = cgt_myday + 120
       if (cgt_mymonth .eq.  6) cgt_dayofyear = cgt_myday + 151
       if (cgt_mymonth .eq.  7) cgt_dayofyear = cgt_myday + 181
       if (cgt_mymonth .eq.  8) cgt_dayofyear = cgt_myday + 212
       if (cgt_mymonth .eq.  9) cgt_dayofyear = cgt_myday + 243
       if (cgt_mymonth .eq. 10) cgt_dayofyear = cgt_myday + 273
       if (cgt_mymonth .eq. 11) cgt_dayofyear = cgt_myday + 304
       if (cgt_mymonth .eq. 12) cgt_dayofyear = cgt_myday + 334
    endif

    !------------------------------------
    ! STEP 3: initialize isZIntegral=1 auxiliaries with zero
    !------------------------------------

    !------------------------------------
    ! STEP 4: Pre-loop where the isZIntegral=1 auxiliaries are calculated
    !------------------------------------
    allocate(cgt_bottomdepth_temp(isc:iec,jsc:jec))
    cgt_bottomdepth_temp = 0.0
    do k = 1, nk
       do j = jsc, jec
          do i = isc, iec
             if (k .gt. grid_kmt(i,j)) cycle
             cgt_bottomdepth_temp(i,j) = cgt_bottomdepth_temp(i,j) + dzt(i,j,k)
             cgt_bottomdepth = cgt_bottomdepth_temp(i,j)
             !------------------------------------
             ! STEP 4.1: prepare abiotic parameters
             !------------------------------------
             cgt_temp       = temp(i,j,k)               ! potential temperature     [Celsius]
             cgt_sali       = salt(i,j,k)               ! salinity                  [g/kg]
             cgt_diffusivity= diff_cbt(i,j,k,1)         ! diffusivity               [m**2/s]
             cgt_light      = ergom%irr_inst(i,j,k)     ! light intensity           [W/m2]
             cgt_cellheight = dzt(i,j,k)                ! cell height               [m]
             cgt_density    = rho_dzt(i,j,k)/dzt(i,j,k) ! density [kg/m3]
             cgt_timestep   = dt/(24*3600)              ! timestep in days
             cgt_longitude  = xt(i,j)                   ! longitude [deg]
             cgt_latitude   = yt(i,j)                   ! latitude [deg]
             cgt_in_sediment = 0.0                      ! we are above sediment surface
             if (k == grid_kmt(i,j)) then
                cgt_current_wave_stress=current_wave_stress(i,j)
             endif

             !------------------------------------
             ! STEP 4.2: load tracer values
             !------------------------------------



             if (k == grid_kmt(i,j)) then
                t_sed           = ergom%t_sed          (i,j) ! sediment detritus
                t_ips           = ergom%t_ips          (i,j) ! iron phosphate in sediment
                t_sed_poc       = ergom%t_sed_poc      (i,j) ! sediment particular carbon
                t_sed_pocn      = ergom%t_sed_pocn     (i,j) ! sediment particular organic N+C
                t_sed_pocp      = ergom%t_sed_pocp     (i,j) ! sediment particular organic P+C
                total_atmos_tot_N_at_bottom = ergom%total_atmos_tot_N_at_bottom(i,j) ! total_atmos_tot_N_at_bottom
                total_atmos_ship_N_at_bottom = ergom%total_atmos_ship_N_at_bottom(i,j) ! total_atmos_ship_N_at_bottom
                t_sed_with_atmos_tot_N = ergom%t_sed_with_atmos_tot_N(i,j) ! sediment detritus; containing nitrogen from (total) atmospheric deposition
                t_sed_pocn_with_atmos_tot_N = ergom%t_sed_pocn_with_atmos_tot_N(i,j) ! sediment particular organic N+C; containing nitrogen from (total) atmospheric deposition
                t_sed_with_atmos_ship_N = ergom%t_sed_with_atmos_ship_N(i,j) ! sediment detritus; containing nitrogen from atmospheric deposition, which has been previously emitted by ships
                t_sed_pocn_with_atmos_ship_N = ergom%t_sed_pocn_with_atmos_ship_N(i,j) ! sediment particular organic N+C; containing nitrogen from atmospheric deposition, which has been previously emitted by ships

                t_sed           = max(t_sed          ,0.0)
                t_ips           = max(t_ips          ,0.0)
                t_sed_poc       = max(t_sed_poc      ,0.0)
                t_sed_pocn      = max(t_sed_pocn     ,0.0)
                t_sed_pocp      = max(t_sed_pocp     ,0.0)
             endif

             !------------------------------------
             ! STEP 4.3: calculate auxiliaries
             !------------------------------------


             ! initialize auxiliaries for iterative loop

             ! iterative loop follows
             do cgt_iteration=1,10
             enddo

             ! normal auxiliaries (not iterative)

             !------------------------------------
             ! STEP 4.4: add contribution of the current layer k to the zIntegral
             !------------------------------------

             !------------------------------------
             ! STEP 4.5: pre-calculate auxiliaries with vertLoc=SED or vertLoc=SUR
             !------------------------------------

             if (k == grid_kmt(i,j)) then
                ! initialize auxiliaries for iterative loop

                ! iterative loop follows
                do cgt_iteration=1,10
                enddo

                ! normal auxiliaries (not iterative)
             endif

             if (k == 1) then
                ! initialize auxiliaries for iterative loop

                ! iterative loop follows
                do cgt_iteration=1,10
                enddo

                ! normal auxiliaries (not iterative)
             endif

          enddo
       enddo
    enddo

    call mpp_clock_end(id_preloop)
    call mpp_clock_begin(id_mainloop)

    !------------------------------------
    ! STEP 5: initializations before the main loop
    !------------------------------------

    !------------------------------------
    ! STEP 5.1: initialize isZIntegral=1 auxiliaries which are calculated after the process rates with zero
    !------------------------------------


    !------------------------------------
    ! STEP 5.2: initialize the arrays which cumulate the change of vertLoc=FIS tracers with zero
    !------------------------------------

    !------------------------------------
    ! STEP 6: Main loop
    !------------------------------------

    cgt_bottomdepth_temp = 0.0
    do k = 1, nk
       do j = jsc, jec
          do i = isc, iec
             if (k .gt. grid_kmt(i,j)) cycle
             cgt_bottomdepth_temp(i,j) = cgt_bottomdepth_temp(i,j) + dzt(i,j,k)
             cgt_bottomdepth = cgt_bottomdepth_temp(i,j)
             !------------------------------------
             ! STEP 6.1: prepare abiotic parameters
             !------------------------------------
             cgt_temp       = temp(i,j,k)               ! potential temperature     [Celsius]
             cgt_sali       = salt(i,j,k)               ! salinity                  [g/kg]
             cgt_diffusivity= diff_cbt(i,j,k,1)         ! diffusivity               [m**2/s]
             cgt_light      = ergom%irr_inst(i,j,k)     ! light intensity           [W/m2]
             cgt_cellheight = dzt(i,j,k)                ! cell height               [m]
             cgt_density    = rho_dzt(i,j,k)/dzt(i,j,k) ! density [kg/m3]
             cgt_timestep   = dt/(24*3600)              ! timestep in days
             cgt_longitude  = xt(i,j)                   ! longitude [deg]
             cgt_latitude   = yt(i,j)                   ! latitude [deg]
             cgt_in_sediment = 0.0                      ! we are above sediment surface
             if (k == grid_kmt(i,j)) then
                cgt_current_wave_stress=current_wave_stress(i,j)
             endif

             !------------------------------------
             ! STEP 6.2: load tracer values
             !------------------------------------
             t_n2            = ergom%t_n2           (i,j,k,tau) ! dissolved molecular nitrogen
             if (k .eq. 1) then
                above_t_n2            = ergom%t_n2           (i,j,k,tau)
             else
                above_t_n2            = ergom%t_n2           (i,j,k-1,tau)
             endif
             t_o2            = ergom%t_o2           (i,j,k,tau) ! dissolved oxygen
             if (k .eq. 1) then
                above_t_o2            = ergom%t_o2           (i,j,k,tau)
             else
                above_t_o2            = ergom%t_o2           (i,j,k-1,tau)
             endif
             t_dic           = ergom%t_dic          (i,j,k,tau) ! dissolved inorganic carbon, treated as carbon dioxide
             if (k .eq. 1) then
                above_t_dic           = ergom%t_dic          (i,j,k,tau)
             else
                above_t_dic           = ergom%t_dic          (i,j,k-1,tau)
             endif
             t_nh4           = ergom%t_nh4          (i,j,k,tau) ! ammonium
             if (k .eq. 1) then
                above_t_nh4           = ergom%t_nh4          (i,j,k,tau)
             else
                above_t_nh4           = ergom%t_nh4          (i,j,k-1,tau)
             endif
             t_no3           = ergom%t_no3          (i,j,k,tau) ! nitrate
             if (k .eq. 1) then
                above_t_no3           = ergom%t_no3          (i,j,k,tau)
             else
                above_t_no3           = ergom%t_no3          (i,j,k-1,tau)
             endif
             t_po4           = ergom%t_po4          (i,j,k,tau) ! phosphate
             if (k .eq. 1) then
                above_t_po4           = ergom%t_po4          (i,j,k,tau)
             else
                above_t_po4           = ergom%t_po4          (i,j,k-1,tau)
             endif
             t_spp           = ergom%t_spp          (i,j,k,tau) ! small-cell phytoplankton
             if (k .eq. 1) then
                above_t_spp           = ergom%t_spp          (i,j,k,tau)
             else
                above_t_spp           = ergom%t_spp          (i,j,k-1,tau)
             endif
             t_zoo           = ergom%t_zoo          (i,j,k,tau) ! zooplankton
             if (k .eq. 1) then
                above_t_zoo           = ergom%t_zoo          (i,j,k,tau)
             else
                above_t_zoo           = ergom%t_zoo          (i,j,k-1,tau)
             endif
             t_h2s           = ergom%t_h2s          (i,j,k,tau) ! hydrogen sulfide
             if (k .eq. 1) then
                above_t_h2s           = ergom%t_h2s          (i,j,k,tau)
             else
                above_t_h2s           = ergom%t_h2s          (i,j,k-1,tau)
             endif
             t_sul           = ergom%t_sul          (i,j,k,tau) ! sulfur
             if (k .eq. 1) then
                above_t_sul           = ergom%t_sul          (i,j,k,tau)
             else
                above_t_sul           = ergom%t_sul          (i,j,k-1,tau)
             endif
             t_alk           = ergom%t_alk          (i,j,k,tau) ! total alkalinity
             if (k .eq. 1) then
                above_t_alk           = ergom%t_alk          (i,j,k,tau)
             else
                above_t_alk           = ergom%t_alk          (i,j,k-1,tau)
             endif
             t_doc           = ergom%t_doc          (i,j,k,tau) ! dissolved organic carbon
             if (k .eq. 1) then
                above_t_doc           = ergom%t_doc          (i,j,k,tau)
             else
                above_t_doc           = ergom%t_doc          (i,j,k-1,tau)
             endif
             t_dop           = ergom%t_dop          (i,j,k,tau) ! phosphorus in dissolved organic carbon in Redfield ratio
             if (k .eq. 1) then
                above_t_dop           = ergom%t_dop          (i,j,k,tau)
             else
                above_t_dop           = ergom%t_dop          (i,j,k-1,tau)
             endif
             total_atmos_tot_N = ergom%total_atmos_tot_N(i,j,k,tau) ! total_atmos_tot_N
             if (k .eq. 1) then
                above_total_atmos_tot_N = ergom%total_atmos_tot_N(i,j,k,tau)
             else
                above_total_atmos_tot_N = ergom%total_atmos_tot_N(i,j,k-1,tau)
             endif
             total_atmos_ship_N = ergom%total_atmos_ship_N(i,j,k,tau) ! total_atmos_ship_N
             if (k .eq. 1) then
                above_total_atmos_ship_N = ergom%total_atmos_ship_N(i,j,k,tau)
             else
                above_total_atmos_ship_N = ergom%total_atmos_ship_N(i,j,k-1,tau)
             endif
             t_n2_with_atmos_tot_N = ergom%t_n2_with_atmos_tot_N(i,j,k,tau) ! dissolved molecular nitrogen; containing nitrogen from (total) atmospheric deposition
             if (k .eq. 1) then
                above_t_n2_with_atmos_tot_N = ergom%t_n2_with_atmos_tot_N(i,j,k,tau)
             else
                above_t_n2_with_atmos_tot_N = ergom%t_n2_with_atmos_tot_N(i,j,k-1,tau)
             endif
             t_nh4_with_atmos_tot_N = ergom%t_nh4_with_atmos_tot_N(i,j,k,tau) ! ammonium; containing nitrogen from (total) atmospheric deposition
             if (k .eq. 1) then
                above_t_nh4_with_atmos_tot_N = ergom%t_nh4_with_atmos_tot_N(i,j,k,tau)
             else
                above_t_nh4_with_atmos_tot_N = ergom%t_nh4_with_atmos_tot_N(i,j,k-1,tau)
             endif
             t_no3_with_atmos_tot_N = ergom%t_no3_with_atmos_tot_N(i,j,k,tau) ! nitrate; containing nitrogen from (total) atmospheric deposition
             if (k .eq. 1) then
                above_t_no3_with_atmos_tot_N = ergom%t_no3_with_atmos_tot_N(i,j,k,tau)
             else
                above_t_no3_with_atmos_tot_N = ergom%t_no3_with_atmos_tot_N(i,j,k-1,tau)
             endif
             t_spp_with_atmos_tot_N = ergom%t_spp_with_atmos_tot_N(i,j,k,tau) ! small-cell phytoplankton; containing nitrogen from (total) atmospheric deposition
             if (k .eq. 1) then
                above_t_spp_with_atmos_tot_N = ergom%t_spp_with_atmos_tot_N(i,j,k,tau)
             else
                above_t_spp_with_atmos_tot_N = ergom%t_spp_with_atmos_tot_N(i,j,k-1,tau)
             endif
             t_zoo_with_atmos_tot_N = ergom%t_zoo_with_atmos_tot_N(i,j,k,tau) ! zooplankton; containing nitrogen from (total) atmospheric deposition
             if (k .eq. 1) then
                above_t_zoo_with_atmos_tot_N = ergom%t_zoo_with_atmos_tot_N(i,j,k,tau)
             else
                above_t_zoo_with_atmos_tot_N = ergom%t_zoo_with_atmos_tot_N(i,j,k-1,tau)
             endif
             t_n2_with_atmos_ship_N = ergom%t_n2_with_atmos_ship_N(i,j,k,tau) ! dissolved molecular nitrogen; containing nitrogen from atmospheric deposition, which has been previously emitted by ships
             if (k .eq. 1) then
                above_t_n2_with_atmos_ship_N = ergom%t_n2_with_atmos_ship_N(i,j,k,tau)
             else
                above_t_n2_with_atmos_ship_N = ergom%t_n2_with_atmos_ship_N(i,j,k-1,tau)
             endif
             t_nh4_with_atmos_ship_N = ergom%t_nh4_with_atmos_ship_N(i,j,k,tau) ! ammonium; containing nitrogen from atmospheric deposition, which has been previously emitted by ships
             if (k .eq. 1) then
                above_t_nh4_with_atmos_ship_N = ergom%t_nh4_with_atmos_ship_N(i,j,k,tau)
             else
                above_t_nh4_with_atmos_ship_N = ergom%t_nh4_with_atmos_ship_N(i,j,k-1,tau)
             endif
             t_no3_with_atmos_ship_N = ergom%t_no3_with_atmos_ship_N(i,j,k,tau) ! nitrate; containing nitrogen from atmospheric deposition, which has been previously emitted by ships
             if (k .eq. 1) then
                above_t_no3_with_atmos_ship_N = ergom%t_no3_with_atmos_ship_N(i,j,k,tau)
             else
                above_t_no3_with_atmos_ship_N = ergom%t_no3_with_atmos_ship_N(i,j,k-1,tau)
             endif
             t_spp_with_atmos_ship_N = ergom%t_spp_with_atmos_ship_N(i,j,k,tau) ! small-cell phytoplankton; containing nitrogen from atmospheric deposition, which has been previously emitted by ships
             if (k .eq. 1) then
                above_t_spp_with_atmos_ship_N = ergom%t_spp_with_atmos_ship_N(i,j,k,tau)
             else
                above_t_spp_with_atmos_ship_N = ergom%t_spp_with_atmos_ship_N(i,j,k-1,tau)
             endif
             t_zoo_with_atmos_ship_N = ergom%t_zoo_with_atmos_ship_N(i,j,k,tau) ! zooplankton; containing nitrogen from atmospheric deposition, which has been previously emitted by ships
             if (k .eq. 1) then
                above_t_zoo_with_atmos_ship_N = ergom%t_zoo_with_atmos_ship_N(i,j,k,tau)
             else
                above_t_zoo_with_atmos_ship_N = ergom%t_zoo_with_atmos_ship_N(i,j,k-1,tau)
             endif
             t_ipw           = ergom%t_ipw          (i,j,k,tau) ! suspended iron phosphate
             if (k .eq. 1) then
                above_t_ipw           = ergom%t_ipw          (i,j,k,tau)
             else
                above_t_ipw           = ergom%t_ipw          (i,j,k-1,tau)
             endif
             t_pocn_with_atmos_tot_N = ergom%t_pocn_with_atmos_tot_N(i,j,k,tau) ! nitrogen in particulate organic carbon in Redfield ratio; containing nitrogen from (total) atmospheric deposition
             if (k .eq. 1) then
                above_t_pocn_with_atmos_tot_N = ergom%t_pocn_with_atmos_tot_N(i,j,k,tau)
             else
                above_t_pocn_with_atmos_tot_N = ergom%t_pocn_with_atmos_tot_N(i,j,k-1,tau)
             endif
             t_lpp_with_atmos_tot_N = ergom%t_lpp_with_atmos_tot_N(i,j,k,tau) ! large-cell phytoplankton; containing nitrogen from (total) atmospheric deposition
             if (k .eq. 1) then
                above_t_lpp_with_atmos_tot_N = ergom%t_lpp_with_atmos_tot_N(i,j,k,tau)
             else
                above_t_lpp_with_atmos_tot_N = ergom%t_lpp_with_atmos_tot_N(i,j,k-1,tau)
             endif
             t_don_with_atmos_tot_N = ergom%t_don_with_atmos_tot_N(i,j,k,tau) ! nitrogen in dissolved organic carbon in Redfield ratio; containing nitrogen from (total) atmospheric deposition
             if (k .eq. 1) then
                above_t_don_with_atmos_tot_N = ergom%t_don_with_atmos_tot_N(i,j,k,tau)
             else
                above_t_don_with_atmos_tot_N = ergom%t_don_with_atmos_tot_N(i,j,k-1,tau)
             endif
             t_cya_with_atmos_tot_N = ergom%t_cya_with_atmos_tot_N(i,j,k,tau) ! diazotroph cyanobacteria; containing nitrogen from (total) atmospheric deposition
             if (k .eq. 1) then
                above_t_cya_with_atmos_tot_N = ergom%t_cya_with_atmos_tot_N(i,j,k,tau)
             else
                above_t_cya_with_atmos_tot_N = ergom%t_cya_with_atmos_tot_N(i,j,k-1,tau)
             endif
             t_det_with_atmos_tot_N = ergom%t_det_with_atmos_tot_N(i,j,k,tau) ! detritus; containing nitrogen from (total) atmospheric deposition
             if (k .eq. 1) then
                above_t_det_with_atmos_tot_N = ergom%t_det_with_atmos_tot_N(i,j,k,tau)
             else
                above_t_det_with_atmos_tot_N = ergom%t_det_with_atmos_tot_N(i,j,k-1,tau)
             endif
             t_lpp           = ergom%t_lpp          (i,j,k,tau) ! large-cell phytoplankton
             if (k .eq. 1) then
                above_t_lpp           = ergom%t_lpp          (i,j,k,tau)
             else
                above_t_lpp           = ergom%t_lpp          (i,j,k-1,tau)
             endif
             t_don           = ergom%t_don          (i,j,k,tau) ! nitrogen in dissolved organic carbon in Redfield ratio
             if (k .eq. 1) then
                above_t_don           = ergom%t_don          (i,j,k,tau)
             else
                above_t_don           = ergom%t_don          (i,j,k-1,tau)
             endif
             t_cya           = ergom%t_cya          (i,j,k,tau) ! diazotroph cyanobacteria
             if (k .eq. 1) then
                above_t_cya           = ergom%t_cya          (i,j,k,tau)
             else
                above_t_cya           = ergom%t_cya          (i,j,k-1,tau)
             endif
             t_det           = ergom%t_det          (i,j,k,tau) ! detritus
             if (k .eq. 1) then
                above_t_det           = ergom%t_det          (i,j,k,tau)
             else
                above_t_det           = ergom%t_det          (i,j,k-1,tau)
             endif
             t_poc           = ergom%t_poc          (i,j,k,tau) ! particulate organic carbon
             if (k .eq. 1) then
                above_t_poc           = ergom%t_poc          (i,j,k,tau)
             else
                above_t_poc           = ergom%t_poc          (i,j,k-1,tau)
             endif
             t_pocp          = ergom%t_pocp         (i,j,k,tau) ! phosphorus in particulate organic carbon in Redfield ratio
             if (k .eq. 1) then
                above_t_pocp          = ergom%t_pocp         (i,j,k,tau)
             else
                above_t_pocp          = ergom%t_pocp         (i,j,k-1,tau)
             endif
             t_pocn          = ergom%t_pocn         (i,j,k,tau) ! nitrogen in particulate organic carbon in Redfield ratio
             if (k .eq. 1) then
                above_t_pocn          = ergom%t_pocn         (i,j,k,tau)
             else
                above_t_pocn          = ergom%t_pocn         (i,j,k-1,tau)
             endif
             t_pocn_with_atmos_ship_N = ergom%t_pocn_with_atmos_ship_N(i,j,k,tau) ! nitrogen in particulate organic carbon in Redfield ratio; containing nitrogen from atmospheric deposition, which has been previously emitted by ships
             if (k .eq. 1) then
                above_t_pocn_with_atmos_ship_N = ergom%t_pocn_with_atmos_ship_N(i,j,k,tau)
             else
                above_t_pocn_with_atmos_ship_N = ergom%t_pocn_with_atmos_ship_N(i,j,k-1,tau)
             endif
             t_lpp_with_atmos_ship_N = ergom%t_lpp_with_atmos_ship_N(i,j,k,tau) ! large-cell phytoplankton; containing nitrogen from atmospheric deposition, which has been previously emitted by ships
             if (k .eq. 1) then
                above_t_lpp_with_atmos_ship_N = ergom%t_lpp_with_atmos_ship_N(i,j,k,tau)
             else
                above_t_lpp_with_atmos_ship_N = ergom%t_lpp_with_atmos_ship_N(i,j,k-1,tau)
             endif
             t_don_with_atmos_ship_N = ergom%t_don_with_atmos_ship_N(i,j,k,tau) ! nitrogen in dissolved organic carbon in Redfield ratio; containing nitrogen from atmospheric deposition, which has been previously emitted by ships
             if (k .eq. 1) then
                above_t_don_with_atmos_ship_N = ergom%t_don_with_atmos_ship_N(i,j,k,tau)
             else
                above_t_don_with_atmos_ship_N = ergom%t_don_with_atmos_ship_N(i,j,k-1,tau)
             endif
             t_cya_with_atmos_ship_N = ergom%t_cya_with_atmos_ship_N(i,j,k,tau) ! diazotroph cyanobacteria; containing nitrogen from atmospheric deposition, which has been previously emitted by ships
             if (k .eq. 1) then
                above_t_cya_with_atmos_ship_N = ergom%t_cya_with_atmos_ship_N(i,j,k,tau)
             else
                above_t_cya_with_atmos_ship_N = ergom%t_cya_with_atmos_ship_N(i,j,k-1,tau)
             endif
             t_det_with_atmos_ship_N = ergom%t_det_with_atmos_ship_N(i,j,k,tau) ! detritus; containing nitrogen from atmospheric deposition, which has been previously emitted by ships
             if (k .eq. 1) then
                above_t_det_with_atmos_ship_N = ergom%t_det_with_atmos_ship_N(i,j,k,tau)
             else
                above_t_det_with_atmos_ship_N = ergom%t_det_with_atmos_ship_N(i,j,k-1,tau)
             endif


             t_n2                  = max(t_n2           ,0.0)
             above_t_n2            = max(above_t_n2           ,0.0)
             t_o2                  = max(t_o2           ,0.0)
             above_t_o2            = max(above_t_o2           ,0.0)
             t_dic                 = max(t_dic          ,0.0)
             above_t_dic           = max(above_t_dic          ,0.0)
             t_nh4                 = max(t_nh4          ,0.0)
             above_t_nh4           = max(above_t_nh4          ,0.0)
             t_no3                 = max(t_no3          ,0.0)
             above_t_no3           = max(above_t_no3          ,0.0)
             t_po4                 = max(t_po4          ,0.0)
             above_t_po4           = max(above_t_po4          ,0.0)
             t_spp                 = max(t_spp          ,0.0)
             above_t_spp           = max(above_t_spp          ,0.0)
             t_zoo                 = max(t_zoo          ,0.0)
             above_t_zoo           = max(above_t_zoo          ,0.0)
             t_h2s                 = max(t_h2s          ,0.0)
             above_t_h2s           = max(above_t_h2s          ,0.0)
             t_sul                 = max(t_sul          ,0.0)
             above_t_sul           = max(above_t_sul          ,0.0)
             t_doc                 = max(t_doc          ,0.0)
             above_t_doc           = max(above_t_doc          ,0.0)
             t_dop                 = max(t_dop          ,0.0)
             above_t_dop           = max(above_t_dop          ,0.0)
             t_ipw                 = max(t_ipw          ,0.0)
             above_t_ipw           = max(above_t_ipw          ,0.0)
             t_lpp                 = max(t_lpp          ,0.0)
             above_t_lpp           = max(above_t_lpp          ,0.0)
             t_don                 = max(t_don          ,0.0)
             above_t_don           = max(above_t_don          ,0.0)
             t_cya                 = max(t_cya          ,0.0)
             above_t_cya           = max(above_t_cya          ,0.0)
             t_det                 = max(t_det          ,0.0)
             above_t_det           = max(above_t_det          ,0.0)
             t_poc                 = max(t_poc          ,0.0)
             above_t_poc           = max(above_t_poc          ,0.0)
             t_pocp                = max(t_pocp         ,0.0)
             above_t_pocp          = max(above_t_pocp         ,0.0)
             t_pocn                = max(t_pocn         ,0.0)
             above_t_pocn          = max(above_t_pocn         ,0.0)

             if (k == grid_kmt(i,j)) then
                t_sed           = ergom%t_sed          (i,j) ! sediment detritus
                t_ips           = ergom%t_ips          (i,j) ! iron phosphate in sediment
                t_sed_poc       = ergom%t_sed_poc      (i,j) ! sediment particular carbon
                t_sed_pocn      = ergom%t_sed_pocn     (i,j) ! sediment particular organic N+C
                t_sed_pocp      = ergom%t_sed_pocp     (i,j) ! sediment particular organic P+C
                total_atmos_tot_N_at_bottom = ergom%total_atmos_tot_N_at_bottom(i,j) ! total_atmos_tot_N_at_bottom
                total_atmos_ship_N_at_bottom = ergom%total_atmos_ship_N_at_bottom(i,j) ! total_atmos_ship_N_at_bottom
                t_sed_with_atmos_tot_N = ergom%t_sed_with_atmos_tot_N(i,j) ! sediment detritus; containing nitrogen from (total) atmospheric deposition
                t_sed_pocn_with_atmos_tot_N = ergom%t_sed_pocn_with_atmos_tot_N(i,j) ! sediment particular organic N+C; containing nitrogen from (total) atmospheric deposition
                t_sed_with_atmos_ship_N = ergom%t_sed_with_atmos_ship_N(i,j) ! sediment detritus; containing nitrogen from atmospheric deposition, which has been previously emitted by ships
                t_sed_pocn_with_atmos_ship_N = ergom%t_sed_pocn_with_atmos_ship_N(i,j) ! sediment particular organic N+C; containing nitrogen from atmospheric deposition, which has been previously emitted by ships

                t_sed           = max(t_sed          ,0.0)
                t_ips           = max(t_ips          ,0.0)
                t_sed_poc       = max(t_sed_poc      ,0.0)
                t_sed_pocn      = max(t_sed_pocn     ,0.0)
                t_sed_pocp      = max(t_sed_pocp     ,0.0)
             endif

             !------------------------------------
             ! STEP 6.3: opacity calculation
             !------------------------------------
             ! some tracers contribute to the opacity
             ! opacity in m**2/mol, concentration in mol/kg -> result in m**2/kg
             ergom%bio_opacity(i,j,k) = (0.0 &
                + gamma1 * t_spp           &
                + gamma1 * t_lpp           &
                + gamma3 * t_don           &
                + gamma1 * t_cya           &
                + gamma2 * t_det           &
                )

             ! now, convert it from m**2/kg to 1/m
# if defined salt4yellowSubs
             ! in case salinity is used to parametrize yellow substances
             !  note: cgt_sali is reduced since MOM overestimates salinity
             ergom%bio_opacity(i,j,k) = ergom%bio_opacity(i,j,k) * ergom%rho_0 &
             + 0.2787 * max(0.3,cgt_sali-1.0)**(-0.627)
# else
             ergom%bio_opacity(i,j,k) = ergom%bio_opacity(i,j,k) * ergom%rho_0
# endif

             !------------------------------------
             ! STEP 6.4: calculate auxiliaries
             !------------------------------------
             !------------------------------------
             ! STEP 6.4.1: get isZIntegral values from pre-loop
             !------------------------------------

             !------------------------------------
             ! STEP 6.4.2: calculate isZGradient auxiliaries
             !------------------------------------

             !------------------------------------
             ! STEP 6.4.3: vertLoc=WAT auxiliaries calclated iteratively
             !------------------------------------

             ! initialize auxiliaries for iterative loop
             temp_k          = 0.0

             ! iterative loop follows
             do cgt_iteration=1,10
                if (cgt_iteration .le. 1) then
                   ! absolute temperature [K] :
                   temp_k          = cgt_temp + 273.15             
                endif
             enddo

             !------------------------------------
             ! STEP 6.4.4: vertLoc=WAT auxiliaries calclated normally (not iteratively)
             !------------------------------------
             ! oxygen saturation concentration [mol/kg] :
             o2_sat          = (10.18e0+((5.306e-3-4.8725e-5*cgt_temp)*cgt_temp-0.2785e0)*cgt_temp+cgt_sali*((2.2258e-3+(4.39e-7*cgt_temp-4.645e-5)*cgt_temp)*cgt_temp-6.33e-2))*44.66e0*1e-6

             ! dissolved molecular nitrogen saturation concentration [mol/kg] :
             temp1 = log((298.15-cgt_temp)/(273.15+cgt_temp))
             temp2 = temp1*temp1                   
             temp3 = temp2*temp1                   
             n2_sat          = 1e-6*exp(6.42931 + 2.92704*temp1 + 4.32531*temp2 + 4.69149*temp3 + cgt_sali*(0.0 -7.44129e-3 - 8.02566e-3*temp1 - 1.46775e-2*temp2))

             ! solubility of molecular nitrogen [mol/kg/Pa] :
             solubility_n2   = n2_sat * 1.263925e-5          

             ! square of positive temperature [C * C] :
             temp_sq         = max(0.0,cgt_temp)*max(0.0,cgt_temp)

             ! effectice zooplankton concentration assumed for mortality and respiration process [mol/kg] :
             zoo_eff         = t_zoo*t_zoo/zoo_cl            

             ! dissolved inorganic nitrogen [mol/kg] :
             din             = t_no3+t_nh4                   

             ! squared DIN [mol2/kg2] :
             din_sq          = din*din                       

             ! squared phosphate [mol**2/kg**2] :
             po4_sq          = t_po4*t_po4                   

             ! total phytoplankton [mol/kg] :
             pp              = t_lpp+t_spp+t_cya             

             ! large-cell phytoplankton plus seed concentration [mol/kg] :
             lpp_plus_lpp0   = t_lpp+lpp0                    

             ! small-cell phytoplankton plus seed concentration [mol/kg] :
             spp_plus_spp0   = t_spp+spp0                    

             ! diazotroph cyanobacteria plus seed concentration [mol/kg] :
             cya_plus_cya0   = t_cya+cya0                    

             ! suitable food for zooplankton (weighted with food preferences) [mol/kg] :
             food_zoo        = t_lpp+t_spp+0.5*t_cya         

             ! light limitation factor for large-cell phytoplankton growth [1] :
             temp1 = max(cgt_light/2.0,light_opt_lpp)
             lim_light_lpp   = cgt_light/temp1*exp(1-cgt_light/temp1)

             ! light limitation factor for small-cell phytoplankton growth [1] :
             temp1 = max(cgt_light/2.0,light_opt_spp)
             lim_light_spp   = cgt_light/temp1*exp(1-cgt_light/temp1)

             ! light limitation factor for diazotroph cyanobacteria growth [1] :
             temp1 = max(cgt_light/2.0,light_opt_cya)
             lim_light_cya   = cgt_light/temp1*exp(1-cgt_light/temp1)

             ! growth rate of large-cell phytoplankton, limited by DIN, DIP, light and oxygen [1/day] :
             lr_assim_lpp    = r_lpp_assim*theta(t_o2-2*t_h2s)*min(din_sq/(din_sq+din_min_lpp*din_min_lpp),min(po4_sq/(po4_sq+din_min_lpp*din_min_lpp*rfr_p*rfr_p),lim_light_lpp))

             ! production rate of DOC by LPP :
             lr_assim_lpp_doc = fac_doc_assim * r_lpp_assim * theta(t_o2-2*t_h2s) * min(max(1 - din_sq/(din_sq+din_min_lpp*din_min_lpp),1 - po4_sq/(din_min_lpp*din_min_lpp*rfr_p*rfr_p + po4_sq)), lim_light_lpp)

             ! production rate of POC by SPP :
             lr_assim_spp_doc = fac_doc_assim * r_spp_assim * theta(t_o2-2*t_h2s) * min(max(1 - din_sq/(din_sq+din_min_spp*din_min_spp),1 - po4_sq/(din_min_spp*din_min_spp*rfr_p*rfr_p + po4_sq)), lim_light_spp)*(1+temp_sq/(temp_sq+temp_min_spp*temp_min_spp))

             ! production rate of POC by CYA :
             lr_assim_cya_doc = fac_doc_assim * r_cya_assim*theta(t_o2-2*t_h2s)*min(1 - po4_sq/(po4_sq+dip_min_cya*dip_min_cya),lim_light_cya)*(1/(1+exp(temp_min_cya-cgt_temp)))*(1/(1+exp(cgt_sali-sali_max_cya)))*(1/(1+exp(sali_min_cya-cgt_sali)))

             ! growth rate of small-cell phytoplankton, limited by DIN, DIP, light, oxygen and temperature [1/day] :
             lr_assim_spp    = r_spp_assim*theta(t_o2-2*t_h2s)*min(din_sq/(din_sq+din_min_spp*din_min_spp),min(po4_sq/(po4_sq+din_min_spp*din_min_spp*rfr_p*rfr_p),lim_light_spp))*(1+temp_sq/(temp_sq+temp_min_spp*temp_min_spp))

             ! growth rate of diazotroph cyanobacteria, limited by DIP, light, oxygen, temperature and salinity [1/day] :
             lr_assim_cya    = r_cya_assim*theta(t_o2-2*t_h2s)*min(po4_sq/(po4_sq+dip_min_cya*dip_min_cya),lim_light_cya)*(1/(1+exp(temp_min_cya-cgt_temp)))*(1/(1+exp(cgt_sali-sali_max_cya)))*(1/(1+exp(sali_min_cya-cgt_sali)))

             ! production rate of POCP by LPP :
             lr_assim_lpp_dop = fac_dop_assim * r_lpp_assim * theta(t_o2-2*t_h2s) * min(min(1 - din_sq/(din_sq+din_min_lpp*din_min_lpp),po4_sq/(din_min_lpp*din_min_lpp*rfr_p*rfr_p + po4_sq)), lim_light_lpp)

             ! production rate of POCP by SPP :
             lr_assim_spp_dop = fac_dop_assim * r_spp_assim * theta(t_o2-2*t_h2s) * min(min(1 - din_sq/(din_sq+din_min_spp*din_min_spp),po4_sq/(din_min_spp*din_min_spp*rfr_p*rfr_p + po4_sq)), lim_light_spp)*(1+temp_sq/(temp_sq+temp_min_spp*temp_min_spp))

             ! production rate of POCN by LPP :
             lr_assim_lpp_don = fac_don_assim * r_lpp_assim * theta(t_o2-2*t_h2s) * min(min(din_sq/(din_sq+din_min_lpp*din_min_lpp),1 - po4_sq/(din_min_lpp*din_min_lpp*rfr_p*rfr_p + po4_sq)), lim_light_lpp)

             ! production rate of POCN by SPP :
             lr_assim_spp_don = fac_don_assim * r_spp_assim * theta(t_o2-2*t_h2s) * min(min(din_sq/(din_sq+din_min_spp*din_min_spp),1 - po4_sq/(din_min_spp*din_min_spp*rfr_p*rfr_p + po4_sq)), lim_light_spp)*(1+temp_sq/(temp_sq+temp_min_spp*temp_min_spp))

             ! growth rate of zooplankton, limited by food, oxygen and temperature [1/day] :
             lr_graz_zoo     = r_zoo_graz*(1-exp(-food_zoo*food_zoo/(food_min_zoo*food_min_zoo)))*theta(t_o2-2*t_h2s)*(1.0+temp_sq/(temp_opt_zoo*temp_opt_zoo)*exp(2.0-cgt_temp*2.0/temp_opt_zoo))

             ! fraction of phosphate which is retained as iron-bound phosphate instead of being released after mineralization in the sediment [1] :
             frac_po4retent  = ret_po4_1 + ret_po4_2*theta(cgt_latitude-60.75)

             ! modifies pocp recycling towards Refield ratio if PO4 is depleted :
             ref_p_sw        = (1 - (po4_sq/(rfr_p*din_min_lpp*rfr_p*din_min_lpp+po4_sq)))/(1+exp(6.0*(1-din/(t_po4/rfr_p+epsilon))))

             ! modifies pocn recycling towards Refield ratio if DIN is depleted :
             ref_n_sw        = (1 - (din_sq/(din_min_lpp*din_min_lpp+din_sq)))/(1+exp(6.0*(1-t_po4/rfr_p/(din+epsilon))))

             ! add an additional POCP recycling if PO4 below Redfield but sufficient DIN :
             lr_pocp         = r_pocp_rec*(1 + fac_enh_rec*ref_p_sw)

             ! add an additional DOP recycling if PO4 is below Redfield but sufficient DIN :
             lr_dop          = r_dop_rec*(1 + fac_enh_rec*ref_p_sw)

             ! add an additional POCN recycling if DIN below Redfield but sufficient PO4 :
             lr_pocn         = r_pocn_rec*(1 + fac_enh_rec*ref_n_sw)

             ! add an additional DON recycling if DIN below Redfield but sufficient PO4 :
             lr_don          = r_don_rec*(1 + fac_enh_rec*ref_n_sw)

             ! depth dependent POC sinking speed :
             w_poc_var       = (0.00098*cgt_temp*cgt_temp*cgt_temp) * (-1.0)

             ! depth dependent POCN sinking speed :
             w_pocn_var      = -0.15                         

             ! depth dependent POCP sinking speed :
             w_pocp_var      = -0.15                         


             !------------------------------------
             ! STEP 6.4.5: vertLoc=SED auxiliaries calclated iteratively
             !------------------------------------
             if (k == grid_kmt(i,j)) then
                ! initialize auxiliaries for iterative loop

                ! iterative loop follows
                do cgt_iteration=1,10
                enddo

             !------------------------------------
             ! STEP 6.4.6: vertLoc=SED auxiliaries calclated normally (not iteratively)
             !------------------------------------

                ! fraction of ammonium that is immediately nitrified and denitrified after remineralization in oxic sediments :
                frac_denit_sed  = frac_denit_scal*(0.5+0.5*exp(-0.01*cgt_bottomdepth))

                ! total carbon in sediment layer [mol/m**2] :
                sed_tot         = t_sed*rfr_c + t_sed_poc + t_sed_pocn*rfr_c + t_sed_pocp*rfr_cp

                ! total carbon in active sediment layer [mol/m**2] :
                sed_tot_active  = max(0.0,min(sed_tot,sed_max*rfr_c))

                ! detritus in active sediment layer [mol/m**2] :
                sed_active      = sed_tot_active * t_sed/sed_tot

                ! recycling rate of sediment detritus, limited by oxygen [1/d] :
                lr_sed_rec      = r_sed_rec*exp(q10_sed_rec*cgt_temp)*(1.0-reduced_rec*theta(2*t_h2s-t_o2))

                ! effective concentration of iron phosphate in the sediment assumed for burial (enhanced burial above a threshold) [mol/m**2] :
                ips_eff         = max(t_ips,t_ips+t_ips*(t_ips-ips_threshold)/ips_cl)

                ! switch (1=erosion, 0=no erosion) which depends on the combined bottom stress of currents and waves :
                erosion_is_active = theta(cgt_current_wave_stress - critical_stress)

                ! poc in active sediment layer [mol/m**2] :
                poc_active      = sed_tot_active * t_sed_poc/sed_tot

                ! pocn in active sediment layer [mol/m**2] :
                pocn_active     = sed_tot_active * t_sed_pocn/sed_tot

                ! pocp in active sediment layer [mol/m**2] :
                pocp_active     = sed_tot_active * t_sed_pocp/sed_tot

             endif

             !------------------------------------
             ! STEP 6.4.7: vertLoc=SUR auxiliaries calclated iteratively
             !------------------------------------

             if (k == 1) then
                ! initialize auxiliaries for iterative loop
                ph_temp         = 0.0
                k_water         = 0.0
                k0_co2          = 0.0
                k1_co2          = 0.0
                k2_co2          = 0.0
                k_boron         = 0.0
                k1_po4          = 0.0
                k2_po4          = 0.0
                k3_po4          = 0.0
                k1_h2s          = 0.0
                boron_total     = 0.0
                alk_boron       = 0.0
                alk_h2s         = 0.0
                alk_water       = 0.0
                alk_po4_denominator = 0.0
                alk_po4         = 0.0
                alk_co2_denominator = 0.0
                alk_co2         = 0.0
                alk_residual    = 0.0
                dalkp_dh3o      = 0.0
                dalkc_dh3o      = 0.0
                dalkresidual_dpH = 0.0
                ph              = 0.0
                h3o             = 1.0e-8

                ! iterative loop follows
                do cgt_iteration=1,10
                   if (cgt_iteration .le. 10) then
                      ! temporary value assumed for pH [1] :
                      ph_temp         = 0.0-log(h3o)/log(10.0)        
                   endif
                   if (cgt_iteration .le. 1) then
                      ! self-ionization constant of Water [mol2/kg2] :
                      k_water         = exp( -13847.26 / temp_k + 148.96502 - 23.6521 * log(temp_k) + (118.67/temp_k - 5.977 + 1.0495 * log(temp_k)) * sqrt(cgt_sali) - 0.01615 * cgt_sali)
                   endif
                   if (cgt_iteration .le. 1) then
                      ! Solubility of CO2 [mol/kg/Pa] :
                      k0_co2          = exp(9345.17 / temp_k - 60.2409 + 23.3585 * (log(temp_k) - 4.605170186) + cgt_sali*(0.023517 - 0.00023656 * temp_k + 0.00000047036 *temp_k*temp_k))/101325.0
                   endif
                   if (cgt_iteration .le. 1) then
                      ! Acid dissociation constant CO2 + 2 H2O <-> HCO3- + H3O+ [mol/kg] :
                      k1_co2          = power(10.0,( -3633.86 / temp_k + 61.2172 - 9.6777 * log(temp_k) + 0.011555 * cgt_sali - 0.0001152 * cgt_sali * cgt_sali))
                   endif
                   if (cgt_iteration .le. 1) then
                      ! Acid dissociation constant HCO3- + H2O <-> [CO3 2-] + H3O+ [mol/kg] :
                      k2_co2          = power(10.0,( -471.78 / temp_k - 25.929 + 3.16967 * log(temp_k) + 0.01781 * cgt_sali - 0.0001122 * cgt_sali * cgt_sali))
                   endif
                   if (cgt_iteration .le. 1) then
                      ! Acid dissociation constant of boric acid [mol/kg] :
                      k_boron         = exp(( -8966.9 - 2890.53*sqrt(cgt_sali) - 77.942*cgt_sali + 1.728*cgt_sali*sqrt(cgt_sali) - 0.0996*cgt_sali*cgt_sali) / temp_k + 148.0248 + 137.1942*sqrt(cgt_sali) + 1.62142*cgt_sali + (-24.4344 - 25.085*sqrt(cgt_sali) - 0.2474*cgt_sali)*log(temp_k) + 0.053105*sqrt(cgt_sali)*temp_k )
                   endif
                   if (cgt_iteration .le. 1) then
                      ! Acid dissociation constant H3PO4 + H2O <-> [H2PO4 -] + H3O+ [mol/kg] :
                      k1_po4          = exp( -4576.752/temp_k + 115.525 - 18.453*log(temp_k) + (0.69171 - 106.736/temp_k)*sqrt(cgt_sali) - (0.01844 + 0.65643/temp_k)*cgt_sali )
                   endif
                   if (cgt_iteration .le. 1) then
                      ! Acid dissociation constant [H2PO4 -] + H2O+ <-> [HPO4 2-] + H3O+ [mol/kg] :
                      k2_po4          = exp( -8814.715/temp_k + 172.0883 - 27.927*log(temp_k) + (1.35660 - 160.340/temp_k)*sqrt(cgt_sali) - (0.05778 - 0.37335/temp_k)*cgt_sali )
                   endif
                   if (cgt_iteration .le. 1) then
                      ! Acid dissociation constant [HPO4 2-] + H2O <-> [PO4 3-] + H3O+ [mol/kg] :
                      k3_po4          = exp( -3070.75/temp_k - 18.141 + (2.81197 + 17.27039/temp_k)*sqrt(cgt_sali) - (0.09984 + 44.99486/temp_k)*cgt_sali )
                   endif
                   if (cgt_iteration .le. 1) then
                      ! Acid dissociation constant H2S + H2O <-> HS- + H3O+ [mol/kg] :
                      k1_h2s          = exp( -3131.42/temp_k + 5.818 + 0.368*(power(max(0.0,cgt_sali),(1.0/3.0))))
                   endif
                   if (cgt_iteration .le. 1) then
                      ! total concentration of boron [mol/kg] :
                      boron_total     = 0.000416 * cgt_sali/35.0      
                   endif
                   if (cgt_iteration .le. 10) then
                      ! boron alkalinity [mol/kg] :
                      alk_boron       = boron_total * k_boron / (k_boron + h3o)
                   endif
                   if (cgt_iteration .le. 10) then
                      ! hydrogen sulfide alkalinity [mol/kg] :
                      alk_h2s         = t_h2s * k1_h2s / (k1_h2s + h3o)
                   endif
                   if (cgt_iteration .le. 10) then
                      ! water alkalinity [mol/kg] :
                      alk_water       = k_water / h3o - h3o           
                   endif
                   if (cgt_iteration .le. 10) then
                      ! denominator in phosphate alkalinity formula [mol3/kg3] :
                      alk_po4_denominator = (h3o*h3o*h3o + k1_po4*h3o*h3o + k1_po4*k2_po4*h3o + k1_po4*k2_po4*k3_po4)
                   endif
                   if (cgt_iteration .le. 10) then
                      ! phosphate alkalinity [mol/kg] :
                      alk_po4         = t_po4*(k1_po4*k2_po4*h3o + 2.0*k1_po4*k2_po4*k3_po4 - h3o*h3o*h3o) / alk_po4_denominator
                   endif
                   if (cgt_iteration .le. 10) then
                      ! denominator in carbonate alkalinity formula [mol2/kg2] :
                      alk_co2_denominator = (h3o*h3o + k1_co2*h3o + k1_co2*k2_co2)
                   endif
                   if (cgt_iteration .le. 10) then
                      ! carbonate alkalinity [mol/kg] :
                      alk_co2         = t_dic*k1_co2*(h3o+2*k2_co2)/alk_co2_denominator
                   endif
                   if (cgt_iteration .le. 10) then
                      ! error in total alkalinity calculation at the assumed pH [mol/kg] :
                      alk_residual    = t_alk - alk_co2 - alk_po4 - alk_boron - alk_h2s - alk_water
                   endif
                   if (cgt_iteration .le. 10) then
                      ! derivative of phosphate alkalinity with respect to h3o [1] :
                      dalkp_dh3o      = t_po4*(0.0-k1_po4*h3o*h3o*h3o*h3o-4*k1_po4*k2_po4*h3o*h3o*h3o-(k1_po4*k1_po4*k2_po4+9*k1_po4*k2_po4*k3_po4)*h3o*h3o-4*k1_po4*k1_po4*k2_po4*k3_po4*h3o-k1_po4*k1_po4*k2_po4*k2_po4*k3_po4)/(alk_po4_denominator*alk_po4_denominator)
                   endif
                   if (cgt_iteration .le. 10) then
                      ! derivative of carbonate alkalinity with respect to h3o [1] :
                      dalkc_dh3o      = t_dic*(0.0-k1_co2*h3o*h3o-k1_co2*k1_co2*k2_co2-4*k1_co2*k2_co2*h3o)/(alk_co2_denominator*alk_co2_denominator)
                   endif
                   if (cgt_iteration .le. 10) then
                      ! derivative of residual_alk with respect to pH [mol/kg] :
                      dalkresidual_dpH = 0.0-log(10.0)*h3o*(alk_boron/(k_boron+h3o)+alk_h2s/(k1_h2s+h3o)+k_water/(h3o*h3o)+1-dalkp_dh3o-dalkc_dh3o)
                   endif
                   if (cgt_iteration .le. 10) then
                      ! newly determined pH value [1] :
                      temp1 = alk_residual/dalkresidual_dpH 
                      ph              = ph_temp - temp1 + theta(abs(temp1) - 1)*0.5*temp1
                   endif
                   if (cgt_iteration .le. 10) then
                      ! h3o ion concentration [mol/kg] :
                      h3o             = power(10.0,0.0-max(1.0,min(13.0,ph)))
                   endif
                enddo

             !------------------------------------
             ! STEP 6.4.8: vertLoc=SUR auxiliaries calclated normally (not iteratively)
             !------------------------------------
                ! co2 partial pressure [Pa] :
                pco2            = t_dic / k0_co2 / (1 + k1_co2/h3o + k1_co2*k2_co2/h3o/h3o)

                ! CO2 concentration in the surface layer [mol/kg] :
                co2             = pco2*k0_co2                   

                ! Schmidt number for CO2 surface flux [1] :
                schmidtnumber_co2 = 2068.9 + cgt_temp*((-118.63) + cgt_temp*(2.9311 + cgt_temp*(-0.027)))

                ! solubility of oxygen [mol/kg/Pa] :
                solubility_o2   = o2_sat*4.71265e-5             

                ! Schmidt number for oxygen surface flux [1] :
                schmidtnumber_o2 = 1929.7 + cgt_temp*((-117.46) + cgt_temp*(3.116 + cgt_temp*(-0.0306)))

                ! Schmidt number for nitrogen surface flux [1] :
                schmidtnumber_n2 = 2206.1 + cgt_temp*((-144.86) + cgt_temp*(4.5413 + cgt_temp*(-0.056988)))

             endif


             !------------------------------------
             ! STEP 6.5: output of auxiliaries
             !------------------------------------
             if (.not. intermediate) then

                if (ergom%id_temp_k          .gt. 0) then
                  ergom%temp_k         (i,j,k) = temp_k         
                endif
                if (ergom%id_o2_sat          .gt. 0) then
                  ergom%o2_sat         (i,j,k) = o2_sat         
                endif
                if (ergom%id_n2_sat          .gt. 0) then
                  ergom%n2_sat         (i,j,k) = n2_sat         
                endif
                if (ergom%id_solubility_n2   .gt. 0) then
                  ergom%solubility_n2  (i,j,k) = solubility_n2  
                endif
                if (ergom%id_temp_sq         .gt. 0) then
                  ergom%temp_sq        (i,j,k) = temp_sq        
                endif
                if (ergom%id_zoo_eff         .gt. 0) then
                  ergom%zoo_eff        (i,j,k) = zoo_eff        
                endif
                if (ergom%id_din             .gt. 0) then
                  ergom%din            (i,j,k) = din            
                endif
                if (ergom%id_din_sq          .gt. 0) then
                  ergom%din_sq         (i,j,k) = din_sq         
                endif
                if (ergom%id_po4_sq          .gt. 0) then
                  ergom%po4_sq         (i,j,k) = po4_sq         
                endif
                if (ergom%id_pp              .gt. 0) then
                  ergom%pp             (i,j,k) = pp             
                endif
                if (ergom%id_lpp_plus_lpp0   .gt. 0) then
                  ergom%lpp_plus_lpp0  (i,j,k) = lpp_plus_lpp0  
                endif
                if (ergom%id_spp_plus_spp0   .gt. 0) then
                  ergom%spp_plus_spp0  (i,j,k) = spp_plus_spp0  
                endif
                if (ergom%id_cya_plus_cya0   .gt. 0) then
                  ergom%cya_plus_cya0  (i,j,k) = cya_plus_cya0  
                endif
                if (ergom%id_food_zoo        .gt. 0) then
                  ergom%food_zoo       (i,j,k) = food_zoo       
                endif
                if (ergom%id_lim_light_lpp   .gt. 0) then
                  ergom%lim_light_lpp  (i,j,k) = lim_light_lpp  
                endif
                if (ergom%id_lim_light_spp   .gt. 0) then
                  ergom%lim_light_spp  (i,j,k) = lim_light_spp  
                endif
                if (ergom%id_lim_light_cya   .gt. 0) then
                  ergom%lim_light_cya  (i,j,k) = lim_light_cya  
                endif
                if (ergom%id_lr_assim_lpp    .gt. 0) then
                  ergom%lr_assim_lpp   (i,j,k) = lr_assim_lpp   
                endif
                if (ergom%id_lr_assim_lpp_doc .gt. 0) then
                  ergom%lr_assim_lpp_doc(i,j,k) = lr_assim_lpp_doc
                endif
                if (ergom%id_lr_assim_spp_doc .gt. 0) then
                  ergom%lr_assim_spp_doc(i,j,k) = lr_assim_spp_doc
                endif
                if (ergom%id_lr_assim_cya_doc .gt. 0) then
                  ergom%lr_assim_cya_doc(i,j,k) = lr_assim_cya_doc
                endif
                if (ergom%id_lr_assim_spp    .gt. 0) then
                  ergom%lr_assim_spp   (i,j,k) = lr_assim_spp   
                endif
                if (ergom%id_lr_assim_cya    .gt. 0) then
                  ergom%lr_assim_cya   (i,j,k) = lr_assim_cya   
                endif
                if (ergom%id_lr_assim_lpp_dop .gt. 0) then
                  ergom%lr_assim_lpp_dop(i,j,k) = lr_assim_lpp_dop
                endif
                if (ergom%id_lr_assim_spp_dop .gt. 0) then
                  ergom%lr_assim_spp_dop(i,j,k) = lr_assim_spp_dop
                endif
                if (ergom%id_lr_assim_lpp_don .gt. 0) then
                  ergom%lr_assim_lpp_don(i,j,k) = lr_assim_lpp_don
                endif
                if (ergom%id_lr_assim_spp_don .gt. 0) then
                  ergom%lr_assim_spp_don(i,j,k) = lr_assim_spp_don
                endif
                if (ergom%id_lr_graz_zoo     .gt. 0) then
                  ergom%lr_graz_zoo    (i,j,k) = lr_graz_zoo    
                endif
                if (ergom%id_frac_po4retent  .gt. 0) then
                  ergom%frac_po4retent (i,j,k) = frac_po4retent 
                endif
                if (ergom%id_ref_p_sw        .gt. 0) then
                  ergom%ref_p_sw       (i,j,k) = ref_p_sw       
                endif
                if (ergom%id_ref_n_sw        .gt. 0) then
                  ergom%ref_n_sw       (i,j,k) = ref_n_sw       
                endif
                if (ergom%id_lr_pocp         .gt. 0) then
                  ergom%lr_pocp        (i,j,k) = lr_pocp        
                endif
                if (ergom%id_lr_dop          .gt. 0) then
                  ergom%lr_dop         (i,j,k) = lr_dop         
                endif
                if (ergom%id_lr_pocn         .gt. 0) then
                  ergom%lr_pocn        (i,j,k) = lr_pocn        
                endif
                if (ergom%id_lr_don          .gt. 0) then
                  ergom%lr_don         (i,j,k) = lr_don         
                endif
                if (ergom%id_w_poc_var       .gt. 0) then
                  ergom%w_poc_var      (i,j,k) = w_poc_var      
                endif
                if (ergom%id_w_pocn_var      .gt. 0) then
                  ergom%w_pocn_var     (i,j,k) = w_pocn_var     
                endif
                if (ergom%id_w_pocp_var      .gt. 0) then
                  ergom%w_pocp_var     (i,j,k) = w_pocp_var     
                endif

                if (k == grid_kmt(i,j)) then
                   if (ergom%id_frac_denit_sed  .gt. 0) then
                      ergom%frac_denit_sed (i,j) = frac_denit_sed 
                   endif
                   if (ergom%id_sed_tot         .gt. 0) then
                      ergom%sed_tot        (i,j) = sed_tot        
                   endif
                   if (ergom%id_sed_tot_active  .gt. 0) then
                      ergom%sed_tot_active (i,j) = sed_tot_active 
                   endif
                   if (ergom%id_sed_active      .gt. 0) then
                      ergom%sed_active     (i,j) = sed_active     
                   endif
                   if (ergom%id_lr_sed_rec      .gt. 0) then
                      ergom%lr_sed_rec     (i,j) = lr_sed_rec     
                   endif
                   if (ergom%id_ips_eff         .gt. 0) then
                      ergom%ips_eff        (i,j) = ips_eff        
                   endif
                   if (ergom%id_erosion_is_active .gt. 0) then
                      ergom%erosion_is_active(i,j) = erosion_is_active
                   endif
                   if (ergom%id_poc_active      .gt. 0) then
                      ergom%poc_active     (i,j) = poc_active     
                   endif
                   if (ergom%id_pocn_active     .gt. 0) then
                      ergom%pocn_active    (i,j) = pocn_active    
                   endif
                   if (ergom%id_pocp_active     .gt. 0) then
                      ergom%pocp_active    (i,j) = pocp_active    
                   endif
                endif
                if (k == 1) then
                   if (ergom%id_ph_temp         .gt. 0) then
                      ergom%ph_temp        (i,j) = ph_temp        
                   endif
                   if (ergom%id_k_water         .gt. 0) then
                      ergom%k_water        (i,j) = k_water        
                   endif
                   if (ergom%id_k0_co2          .gt. 0) then
                      ergom%k0_co2         (i,j) = k0_co2         
                   endif
                   if (ergom%id_k1_co2          .gt. 0) then
                      ergom%k1_co2         (i,j) = k1_co2         
                   endif
                   if (ergom%id_k2_co2          .gt. 0) then
                      ergom%k2_co2         (i,j) = k2_co2         
                   endif
                   if (ergom%id_k_boron         .gt. 0) then
                      ergom%k_boron        (i,j) = k_boron        
                   endif
                   if (ergom%id_k1_po4          .gt. 0) then
                      ergom%k1_po4         (i,j) = k1_po4         
                   endif
                   if (ergom%id_k2_po4          .gt. 0) then
                      ergom%k2_po4         (i,j) = k2_po4         
                   endif
                   if (ergom%id_k3_po4          .gt. 0) then
                      ergom%k3_po4         (i,j) = k3_po4         
                   endif
                   if (ergom%id_k1_h2s          .gt. 0) then
                      ergom%k1_h2s         (i,j) = k1_h2s         
                   endif
                   if (ergom%id_boron_total     .gt. 0) then
                      ergom%boron_total    (i,j) = boron_total    
                   endif
                   if (ergom%id_alk_boron       .gt. 0) then
                      ergom%alk_boron      (i,j) = alk_boron      
                   endif
                   if (ergom%id_alk_h2s         .gt. 0) then
                      ergom%alk_h2s        (i,j) = alk_h2s        
                   endif
                   if (ergom%id_alk_water       .gt. 0) then
                      ergom%alk_water      (i,j) = alk_water      
                   endif
                   if (ergom%id_alk_po4_denominator .gt. 0) then
                      ergom%alk_po4_denominator(i,j) = alk_po4_denominator
                   endif
                   if (ergom%id_alk_po4         .gt. 0) then
                      ergom%alk_po4        (i,j) = alk_po4        
                   endif
                   if (ergom%id_alk_co2_denominator .gt. 0) then
                      ergom%alk_co2_denominator(i,j) = alk_co2_denominator
                   endif
                   if (ergom%id_alk_co2         .gt. 0) then
                      ergom%alk_co2        (i,j) = alk_co2        
                   endif
                   if (ergom%id_alk_residual    .gt. 0) then
                      ergom%alk_residual   (i,j) = alk_residual   
                   endif
                   if (ergom%id_dalkp_dh3o      .gt. 0) then
                      ergom%dalkp_dh3o     (i,j) = dalkp_dh3o     
                   endif
                   if (ergom%id_dalkc_dh3o      .gt. 0) then
                      ergom%dalkc_dh3o     (i,j) = dalkc_dh3o     
                   endif
                   if (ergom%id_dalkresidual_dpH .gt. 0) then
                      ergom%dalkresidual_dpH(i,j) = dalkresidual_dpH
                   endif
                   if (ergom%id_ph              .gt. 0) then
                      ergom%ph             (i,j) = ph             
                   endif
                   if (ergom%id_h3o             .gt. 0) then
                      ergom%h3o            (i,j) = h3o            
                   endif
                   if (ergom%id_pco2            .gt. 0) then
                      ergom%pco2           (i,j) = pco2           
                   endif
                   if (ergom%id_co2             .gt. 0) then
                      ergom%co2            (i,j) = co2            
                   endif
                   if (ergom%id_schmidtnumber_co2 .gt. 0) then
                      ergom%schmidtnumber_co2(i,j) = schmidtnumber_co2
                   endif
                   if (ergom%id_solubility_o2   .gt. 0) then
                      ergom%solubility_o2  (i,j) = solubility_o2  
                   endif
                   if (ergom%id_schmidtnumber_o2 .gt. 0) then
                      ergom%schmidtnumber_o2(i,j) = schmidtnumber_o2
                   endif
                   if (ergom%id_schmidtnumber_n2 .gt. 0) then
                      ergom%schmidtnumber_n2(i,j) = schmidtnumber_n2
                   endif
                endif
             endif

             !------------------------------------
             ! STEP 6.6: calculate process limitations
             !------------------------------------
             lim_t_n2_7           = theta(t_n2-0.0)
             lim_t_o2_0           = 1.0-exp(-t_o2/o2_min_det_resp)
             lim_t_o2_2           = theta(t_o2-0.0)
             lim_t_o2_4           = t_o2*t_o2/(t_o2*t_o2+o2_min_po4_retent*o2_min_po4_retent)
             lim_t_o2_6           = t_o2*t_o2/(t_o2*t_o2+o2_min_sed_resp*o2_min_sed_resp)
             lim_t_dic_8          = theta(t_dic-0.0)
             lim_t_nh4_11         = theta(t_nh4-0.0)
             lim_t_no3_1          = 1.0-exp(-t_no3/no3_min_det_denit)
             lim_t_no3_3          = t_no3*t_no3/(t_no3*t_no3+no3_min_sed_denit*no3_min_sed_denit)
             lim_t_no3_10         = theta(t_no3-0.0)
             lim_t_po4_9          = theta(t_po4-0.0)
             lim_t_spp_16         = theta(t_spp-0.0)
             lim_t_zoo_18         = theta(t_zoo-0.0)
             lim_t_h2s_5          = theta(t_h2s-h2s_min_po4_liber)
             lim_t_h2s_23         = theta(t_h2s-0.0)
             lim_t_sul_24         = theta(t_sul-0.0)
             lim_t_doc_28         = theta(t_doc-0.0)
             lim_t_dop_29         = theta(t_dop-0.0)
             lim_t_ipw_25         = theta(t_ipw-0.0)
             lim_t_lpp_15         = theta(t_lpp-0.0)
             lim_t_don_30         = theta(t_don-0.0)
             lim_t_cya_17         = theta(t_cya-0.0)
             lim_t_det_19         = theta(t_det-0.0)
             lim_t_poc_12         = theta(t_poc-0.0)
             lim_t_pocp_13        = theta(t_pocp-0.0)
             lim_t_pocn_14        = theta(t_pocn-0.0)

             if (k == grid_kmt(i,j)) then
                lim_t_sed_20         = theta(t_sed-0.0)
                lim_t_ips_22         = theta(t_ips-0.0)
                lim_t_sed_poc_21     = theta(t_sed_poc-0.0)
                lim_t_sed_pocn_26    = theta(t_sed_pocn-0.0)
                lim_t_sed_pocp_27    = theta(t_sed_pocp-0.0)
             endif

             if (k == 1) then
             endif

             !------------------------------------
             ! STEP 6.7
             !
             !-- POSITIVE-DEFINITE SCHEME --------
             !-- means the following steps will be repeated as often as nessecary
             !------------------------------------
             number_of_loop = 1
             fraction_of_total_timestep = 1.0   ! how much of the original timestep is remaining
             total_rate_p_no3_assim_lpp          = 0.0
             total_rate_p_nh4_assim_lpp          = 0.0
             total_rate_p_no3_assim_spp          = 0.0
             total_rate_p_nh4_assim_spp          = 0.0
             total_rate_p_n2_assim_cya           = 0.0
             total_rate_p_assim_lpp_doc          = 0.0
             total_rate_p_assim_spp_doc          = 0.0
             total_rate_p_assim_cya_doc          = 0.0
             total_rate_p_assim_lpp_dop          = 0.0
             total_rate_p_assim_spp_dop          = 0.0
             total_rate_p_nh4_assim_lpp_don          = 0.0
             total_rate_p_no3_assim_lpp_don          = 0.0
             total_rate_p_nh4_assim_spp_don          = 0.0
             total_rate_p_no3_assim_spp_don          = 0.0
             total_rate_p_poc_resp               = 0.0
             total_rate_p_poc_denit              = 0.0
             total_rate_p_poc_sulf               = 0.0
             total_rate_p_pocp_resp              = 0.0
             total_rate_p_pocp_denit             = 0.0
             total_rate_p_pocp_sulf              = 0.0
             total_rate_p_pocn_resp              = 0.0
             total_rate_p_pocn_denit_noN2          = 0.0
             total_rate_p_pocn_denit_wiN2          = 0.0
             total_rate_p_pocn_sulf              = 0.0
             total_rate_p_lpp_graz_zoo           = 0.0
             total_rate_p_spp_graz_zoo           = 0.0
             total_rate_p_cya_graz_zoo           = 0.0
             total_rate_p_lpp_resp_nh4           = 0.0
             total_rate_p_spp_resp_nh4           = 0.0
             total_rate_p_cya_resp_nh4           = 0.0
             total_rate_p_zoo_resp_nh4           = 0.0
             total_rate_p_lpp_mort_det           = 0.0
             total_rate_p_spp_mort_det           = 0.0
             total_rate_p_cya_mort_det           = 0.0
             total_rate_p_cya_mort_det_diff          = 0.0
             total_rate_p_zoo_mort_det           = 0.0
             total_rate_p_nh4_nit_no3            = 0.0
             total_rate_p_det_resp_nh4           = 0.0
             total_rate_p_det_denit_nh4          = 0.0
             total_rate_p_det_sulf_nh4           = 0.0
             total_rate_p_sed_resp_nh4           = 0.0
             total_rate_p_nh4_nitdenit_n2          = 0.0
             total_rate_p_sed_denit_nh4_noN2          = 0.0
             total_rate_p_sed_denit_nh4_wiN2          = 0.0
             total_rate_p_sed_sulf_nh4           = 0.0
             total_rate_p_sed_poc_resp           = 0.0
             total_rate_p_sed_poc_denit          = 0.0
             total_rate_p_sed_poc_sulf           = 0.0
             total_rate_p_po4_retent_ips          = 0.0
             total_rate_p_ips_liber_po4          = 0.0
             total_rate_p_h2s_oxo2_sul           = 0.0
             total_rate_p_h2s_oxno3_sul          = 0.0
             total_rate_p_sul_oxo2_so4           = 0.0
             total_rate_p_sul_oxno3_so4          = 0.0
             total_rate_p_det_sedi_sed           = 0.0
             total_rate_p_ipw_sedi_ips           = 0.0
             total_rate_p_poc_sedi_sed           = 0.0
             total_rate_p_pocn_sedi_sed          = 0.0
             total_rate_p_pocp_sedi_sed          = 0.0
             total_rate_p_sed_ero_det            = 0.0
             total_rate_p_ips_ero_ipw            = 0.0
             total_rate_p_sed_ero_poc            = 0.0
             total_rate_p_sed_ero_pocn           = 0.0
             total_rate_p_sed_ero_pocp           = 0.0
             total_rate_p_sed_biores_det          = 0.0
             total_rate_p_ips_biores_ipw          = 0.0
             total_rate_p_sed_biores_poc          = 0.0
             total_rate_p_sed_biores_pocn          = 0.0
             total_rate_p_sed_biores_pocp          = 0.0
             total_rate_p_sed_burial             = 0.0
             total_rate_p_ips_burial             = 0.0
             total_rate_p_poc_burial             = 0.0
             total_rate_p_pocn_burial            = 0.0
             total_rate_p_pocp_burial            = 0.0
             total_rate_p_sed_pocn_resp          = 0.0
             total_rate_p_sed_pocp_resp          = 0.0
             total_rate_p_sed_pocn_denit_noN2          = 0.0
             total_rate_p_sed_pocn_denit_wiN2          = 0.0
             total_rate_p_sed_pocp_denit          = 0.0
             total_rate_p_sed_pocn_sulf          = 0.0
             total_rate_p_sed_pocp_sulf          = 0.0
             total_rate_p_nh4_nitdenit_pocn_n2          = 0.0
             total_rate_p_doc2pco                = 0.0
             total_rate_p_dop2pocp               = 0.0
             total_rate_p_don2pocn               = 0.0
             total_rate_p_doc_resp               = 0.0
             total_rate_p_doc_denit              = 0.0
             total_rate_p_doc_sulf               = 0.0
             total_rate_p_dop_resp               = 0.0
             total_rate_p_dop_denit              = 0.0
             total_rate_p_dop_sulf               = 0.0
             total_rate_p_don_resp               = 0.0
             total_rate_p_don_denit_noN2          = 0.0
             total_rate_p_don_denit_wiN2          = 0.0
             total_rate_p_don_sulf               = 0.0
             total_rate_p_no3_assim_lpp_atmos_tot_N          = 0.0
             total_rate_p_nh4_assim_lpp_atmos_tot_N          = 0.0
             total_rate_p_no3_assim_spp_atmos_tot_N          = 0.0
             total_rate_p_nh4_assim_spp_atmos_tot_N          = 0.0
             total_rate_p_nh4_assim_lpp_don_atmos_tot_N          = 0.0
             total_rate_p_no3_assim_lpp_don_atmos_tot_N          = 0.0
             total_rate_p_nh4_assim_spp_don_atmos_tot_N          = 0.0
             total_rate_p_no3_assim_spp_don_atmos_tot_N          = 0.0
             total_rate_p_pocn_resp_atmos_tot_N          = 0.0
             total_rate_p_pocn_denit_noN2_atmos_tot_N          = 0.0
             total_rate_p_pocn_sulf_atmos_tot_N          = 0.0
             total_rate_p_lpp_graz_zoo_atmos_tot_N          = 0.0
             total_rate_p_spp_graz_zoo_atmos_tot_N          = 0.0
             total_rate_p_cya_graz_zoo_atmos_tot_N          = 0.0
             total_rate_p_lpp_resp_nh4_atmos_tot_N          = 0.0
             total_rate_p_spp_resp_nh4_atmos_tot_N          = 0.0
             total_rate_p_cya_resp_nh4_atmos_tot_N          = 0.0
             total_rate_p_zoo_resp_nh4_atmos_tot_N          = 0.0
             total_rate_p_lpp_mort_det_atmos_tot_N          = 0.0
             total_rate_p_spp_mort_det_atmos_tot_N          = 0.0
             total_rate_p_cya_mort_det_atmos_tot_N          = 0.0
             total_rate_p_cya_mort_det_diff_atmos_tot_N          = 0.0
             total_rate_p_zoo_mort_det_atmos_tot_N          = 0.0
             total_rate_p_nh4_nit_no3_atmos_tot_N          = 0.0
             total_rate_p_det_resp_nh4_atmos_tot_N          = 0.0
             total_rate_p_det_sulf_nh4_atmos_tot_N          = 0.0
             total_rate_p_sed_resp_nh4_atmos_tot_N          = 0.0
             total_rate_p_sed_denit_nh4_noN2_atmos_tot_N          = 0.0
             total_rate_p_sed_sulf_nh4_atmos_tot_N          = 0.0
             total_rate_p_det_sedi_sed_atmos_tot_N          = 0.0
             total_rate_p_pocn_sedi_sed_atmos_tot_N          = 0.0
             total_rate_p_sed_ero_det_atmos_tot_N          = 0.0
             total_rate_p_sed_ero_pocn_atmos_tot_N          = 0.0
             total_rate_p_sed_biores_det_atmos_tot_N          = 0.0
             total_rate_p_sed_biores_pocn_atmos_tot_N          = 0.0
             total_rate_p_sed_burial_atmos_tot_N          = 0.0
             total_rate_p_pocn_burial_atmos_tot_N          = 0.0
             total_rate_p_sed_pocn_resp_atmos_tot_N          = 0.0
             total_rate_p_sed_pocn_denit_noN2_atmos_tot_N          = 0.0
             total_rate_p_sed_pocn_sulf_atmos_tot_N          = 0.0
             total_rate_p_don2pocn_atmos_tot_N          = 0.0
             total_rate_p_don_resp_atmos_tot_N          = 0.0
             total_rate_p_don_denit_noN2_atmos_tot_N          = 0.0
             total_rate_p_don_sulf_atmos_tot_N          = 0.0
             total_rate_p_no3_assim_lpp_atmos_ship_N          = 0.0
             total_rate_p_nh4_assim_lpp_atmos_ship_N          = 0.0
             total_rate_p_no3_assim_spp_atmos_ship_N          = 0.0
             total_rate_p_nh4_assim_spp_atmos_ship_N          = 0.0
             total_rate_p_nh4_assim_lpp_don_atmos_ship_N          = 0.0
             total_rate_p_no3_assim_lpp_don_atmos_ship_N          = 0.0
             total_rate_p_nh4_assim_spp_don_atmos_ship_N          = 0.0
             total_rate_p_no3_assim_spp_don_atmos_ship_N          = 0.0
             total_rate_p_pocn_resp_atmos_ship_N          = 0.0
             total_rate_p_pocn_denit_noN2_atmos_ship_N          = 0.0
             total_rate_p_pocn_sulf_atmos_ship_N          = 0.0
             total_rate_p_lpp_graz_zoo_atmos_ship_N          = 0.0
             total_rate_p_spp_graz_zoo_atmos_ship_N          = 0.0
             total_rate_p_cya_graz_zoo_atmos_ship_N          = 0.0
             total_rate_p_lpp_resp_nh4_atmos_ship_N          = 0.0
             total_rate_p_spp_resp_nh4_atmos_ship_N          = 0.0
             total_rate_p_cya_resp_nh4_atmos_ship_N          = 0.0
             total_rate_p_zoo_resp_nh4_atmos_ship_N          = 0.0
             total_rate_p_lpp_mort_det_atmos_ship_N          = 0.0
             total_rate_p_spp_mort_det_atmos_ship_N          = 0.0
             total_rate_p_cya_mort_det_atmos_ship_N          = 0.0
             total_rate_p_cya_mort_det_diff_atmos_ship_N          = 0.0
             total_rate_p_zoo_mort_det_atmos_ship_N          = 0.0
             total_rate_p_nh4_nit_no3_atmos_ship_N          = 0.0
             total_rate_p_det_resp_nh4_atmos_ship_N          = 0.0
             total_rate_p_det_sulf_nh4_atmos_ship_N          = 0.0
             total_rate_p_sed_resp_nh4_atmos_ship_N          = 0.0
             total_rate_p_sed_denit_nh4_noN2_atmos_ship_N          = 0.0
             total_rate_p_sed_sulf_nh4_atmos_ship_N          = 0.0
             total_rate_p_det_sedi_sed_atmos_ship_N          = 0.0
             total_rate_p_pocn_sedi_sed_atmos_ship_N          = 0.0
             total_rate_p_sed_ero_det_atmos_ship_N          = 0.0
             total_rate_p_sed_ero_pocn_atmos_ship_N          = 0.0
             total_rate_p_sed_biores_det_atmos_ship_N          = 0.0
             total_rate_p_sed_biores_pocn_atmos_ship_N          = 0.0
             total_rate_p_sed_burial_atmos_ship_N          = 0.0
             total_rate_p_pocn_burial_atmos_ship_N          = 0.0
             total_rate_p_sed_pocn_resp_atmos_ship_N          = 0.0
             total_rate_p_sed_pocn_denit_noN2_atmos_ship_N          = 0.0
             total_rate_p_sed_pocn_sulf_atmos_ship_N          = 0.0
             total_rate_p_don2pocn_atmos_ship_N          = 0.0
             total_rate_p_don_resp_atmos_ship_N          = 0.0
             total_rate_p_don_denit_noN2_atmos_ship_N          = 0.0
             total_rate_p_don_sulf_atmos_ship_N          = 0.0
             if (implicit_bottomfluxes) then
                ergom%btf_t_n2           (i,j) = 0.0
                ergom%btf_t_o2           (i,j) = 0.0
                ergom%btf_t_dic          (i,j) = 0.0
                ergom%btf_t_nh4          (i,j) = 0.0
                ergom%btf_t_no3          (i,j) = 0.0
                ergom%btf_t_po4          (i,j) = 0.0
                ergom%btf_t_spp          (i,j) = 0.0
                ergom%btf_t_zoo          (i,j) = 0.0
                ergom%btf_t_h2s          (i,j) = 0.0
                ergom%btf_t_sul          (i,j) = 0.0
                ergom%btf_t_alk          (i,j) = 0.0
                ergom%btf_t_doc          (i,j) = 0.0
                ergom%btf_t_dop          (i,j) = 0.0
                ergom%btf_total_atmos_tot_N(i,j) = 0.0
                ergom%btf_total_atmos_ship_N(i,j) = 0.0
                ergom%btf_t_n2_with_atmos_tot_N(i,j) = 0.0
                ergom%btf_t_nh4_with_atmos_tot_N(i,j) = 0.0
                ergom%btf_t_no3_with_atmos_tot_N(i,j) = 0.0
                ergom%btf_t_spp_with_atmos_tot_N(i,j) = 0.0
                ergom%btf_t_zoo_with_atmos_tot_N(i,j) = 0.0
                ergom%btf_t_n2_with_atmos_ship_N(i,j) = 0.0
                ergom%btf_t_nh4_with_atmos_ship_N(i,j) = 0.0
                ergom%btf_t_no3_with_atmos_ship_N(i,j) = 0.0
                ergom%btf_t_spp_with_atmos_ship_N(i,j) = 0.0
                ergom%btf_t_zoo_with_atmos_ship_N(i,j) = 0.0
                ergom%btf_t_ipw          (i,j) = 0.0
                ergom%btf_t_pocn_with_atmos_tot_N(i,j) = 0.0
                ergom%btf_t_lpp_with_atmos_tot_N(i,j) = 0.0
                ergom%btf_t_don_with_atmos_tot_N(i,j) = 0.0
                ergom%btf_t_cya_with_atmos_tot_N(i,j) = 0.0
                ergom%btf_t_det_with_atmos_tot_N(i,j) = 0.0
                ergom%btf_t_lpp          (i,j) = 0.0
                ergom%btf_t_don          (i,j) = 0.0
                ergom%btf_t_cya          (i,j) = 0.0
                ergom%btf_t_det          (i,j) = 0.0
                ergom%btf_t_poc          (i,j) = 0.0
                ergom%btf_t_pocp         (i,j) = 0.0
                ergom%btf_t_pocn         (i,j) = 0.0
                ergom%btf_t_pocn_with_atmos_ship_N(i,j) = 0.0
                ergom%btf_t_lpp_with_atmos_ship_N(i,j) = 0.0
                ergom%btf_t_don_with_atmos_ship_N(i,j) = 0.0
                ergom%btf_t_cya_with_atmos_ship_N(i,j) = 0.0
                ergom%btf_t_det_with_atmos_ship_N(i,j) = 0.0
             endif

             do while (cgt_timestep .gt. 0.0)

                !------------------------------------
                ! STEP 6.7.1: calculate process rates
                !------------------------------------
                ! assimilation of nitrate by large-cell phytoplankton :
                p_no3_assim_lpp = (lpp_plus_lpp0*lr_assim_lpp*t_no3/(din+epsilon))*lim_t_dic_8*lim_t_po4_9*lim_t_no3_10
                p_no3_assim_lpp = max(p_no3_assim_lpp,0.0)

                ! assimilation of ammonium by large-cell phytoplankton :
                p_nh4_assim_lpp = (lpp_plus_lpp0*lr_assim_lpp*t_nh4/(din+epsilon))*lim_t_nh4_11*lim_t_po4_9*lim_t_dic_8
                p_nh4_assim_lpp = max(p_nh4_assim_lpp,0.0)

                ! assimilation of nitrate by small-cell phytoplankton :
                p_no3_assim_spp = (spp_plus_spp0*lr_assim_spp*t_no3/(din+epsilon))*lim_t_dic_8*lim_t_po4_9*lim_t_no3_10
                p_no3_assim_spp = max(p_no3_assim_spp,0.0)

                ! assimilation of ammonium by small-cell phytoplankton :
                p_nh4_assim_spp = (spp_plus_spp0*lr_assim_spp*t_nh4/(din+epsilon))*lim_t_nh4_11*lim_t_po4_9*lim_t_dic_8
                p_nh4_assim_spp = max(p_nh4_assim_spp,0.0)

                ! fixation of dinitrogen by diazotroph cyanobacteria :
                p_n2_assim_cya  = (cya_plus_cya0*lr_assim_cya)*lim_t_dic_8*lim_t_po4_9*lim_t_n2_7
                p_n2_assim_cya  = max(p_n2_assim_cya ,0.0)

                ! Production of DOC by LPP :
                p_assim_lpp_doc = (rfr_c * t_lpp * lr_assim_lpp_doc)*lim_t_dic_8
                p_assim_lpp_doc = max(p_assim_lpp_doc,0.0)

                ! Production of DOC by SPP :
                p_assim_spp_doc = (rfr_c * t_spp * lr_assim_spp_doc)*lim_t_dic_8
                p_assim_spp_doc = max(p_assim_spp_doc,0.0)

                ! Production of POC by CYA :
                p_assim_cya_doc = (rfr_c * t_cya * lr_assim_cya_doc)*lim_t_dic_8
                p_assim_cya_doc = max(p_assim_cya_doc,0.0)

                ! Production of DOP by LPP :
                p_assim_lpp_dop = (rfr_p * t_lpp * lr_assim_lpp_dop)*lim_t_dic_8*lim_t_po4_9
                p_assim_lpp_dop = max(p_assim_lpp_dop,0.0)

                ! Production of DOP by SPP :
                p_assim_spp_dop = (rfr_p * t_spp * lr_assim_spp_dop)*lim_t_po4_9*lim_t_dic_8
                p_assim_spp_dop = max(p_assim_spp_dop,0.0)

                ! Production of DON by LPP :
                p_nh4_assim_lpp_don = (t_lpp * lr_assim_lpp_don*t_nh4/(din+epsilon))*lim_t_dic_8*lim_t_nh4_11
                p_nh4_assim_lpp_don = max(p_nh4_assim_lpp_don,0.0)

                ! Production of DON by LPP :
                p_no3_assim_lpp_don = (t_lpp * lr_assim_lpp_don*t_no3/(din+epsilon))*lim_t_no3_10*lim_t_dic_8
                p_no3_assim_lpp_don = max(p_no3_assim_lpp_don,0.0)

                ! Production of DON by SPP :
                p_nh4_assim_spp_don = (t_spp * lr_assim_spp_don*t_nh4/(din+epsilon))*lim_t_nh4_11*lim_t_dic_8
                p_nh4_assim_spp_don = max(p_nh4_assim_spp_don,0.0)

                ! Production of DON by SPP :
                p_no3_assim_spp_don = (t_spp * lr_assim_spp_don*t_no3/(din+epsilon))*lim_t_dic_8*lim_t_no3_10
                p_no3_assim_spp_don = max(p_no3_assim_spp_don,0.0)

                ! respiration of POC :
                p_poc_resp      = (t_poc * r_poc_rec * exp(q10_det_rec * cgt_temp))*lim_t_o2_0*lim_t_poc_12
                p_poc_resp      = max(p_poc_resp     ,0.0)

                ! recycling of POC using nitrate (denitrification) :
                p_poc_denit     = (t_poc*r_poc_rec*exp(q10_det_rec*cgt_temp))*(1.0-lim_t_o2_0)*lim_t_no3_1*lim_t_poc_12
                p_poc_denit     = max(p_poc_denit    ,0.0)

                ! Mineralization of POC, e-acceptor sulfate (sulfate reduction) :
                p_poc_sulf      = (t_poc*r_poc_rec*exp(q10_det_rec*cgt_temp))*(1.0-lim_t_o2_0)*(1.0-lim_t_no3_1)*lim_t_poc_12
                p_poc_sulf      = max(p_poc_sulf     ,0.0)

                ! respiration of POCP :
                p_pocp_resp     = (t_pocp * lr_pocp * exp(q10_det_rec * cgt_temp))*lim_t_o2_0*lim_t_pocp_13
                p_pocp_resp     = max(p_pocp_resp    ,0.0)

                ! recycling of POC using nitrate (denitrification) :
                p_pocp_denit    = (t_pocp*r_pocp_rec*exp(q10_det_rec*cgt_temp))*(1.0-lim_t_o2_0)*lim_t_no3_1*lim_t_pocp_13
                p_pocp_denit    = max(p_pocp_denit   ,0.0)

                ! Mineralization of POC, e-acceptor sulfate (sulfate reduction) :
                p_pocp_sulf     = (t_pocp*r_pocp_rec*exp(q10_det_rec*cgt_temp))*(1.0-lim_t_o2_0)*(1.0-lim_t_no3_1)*lim_t_pocp_13
                p_pocp_sulf     = max(p_pocp_sulf    ,0.0)

                ! respiration of POCN :
                p_pocn_resp     = (t_pocn * lr_pocn * exp(q10_det_rec * cgt_temp))*lim_t_o2_0*lim_t_pocn_14
                p_pocn_resp     = max(p_pocn_resp    ,0.0)

                ! recycling of POCN using nitrate (denitrification) :
                p_pocn_denit_noN2 = (t_pocn*r_pocn_rec*exp(q10_det_rec*cgt_temp))*(1.0-lim_t_o2_0)*lim_t_no3_1*lim_t_pocn_14
                p_pocn_denit_noN2 = max(p_pocn_denit_noN2,0.0)

                ! recycling of POCN using nitrate (denitrification) :
                p_pocn_denit_wiN2 = (t_pocn*r_pocn_rec*exp(q10_det_rec*cgt_temp))*(1.0-lim_t_o2_0)*lim_t_no3_1
                p_pocn_denit_wiN2 = max(p_pocn_denit_wiN2,0.0)

                ! Mineralization of POCN, e-acceptor sulfate (sulfate reduction) :
                p_pocn_sulf     = (t_pocn*r_pocn_rec*exp(q10_det_rec*cgt_temp))*(1.0-lim_t_o2_0)*(1.0-lim_t_no3_1)*lim_t_pocn_14
                p_pocn_sulf     = max(p_pocn_sulf    ,0.0)

                ! grazing of zooplankton eating large-cell phytoplankton :
                p_lpp_graz_zoo  = ((t_zoo+zoo0)*lr_graz_zoo*t_lpp/max(food_zoo,epsilon))*lim_t_lpp_15
                p_lpp_graz_zoo  = max(p_lpp_graz_zoo ,0.0)

                ! grazing of zooplankton eating small-cell phytoplankton :
                p_spp_graz_zoo  = ((t_zoo+zoo0)*lr_graz_zoo*t_spp/max(food_zoo,epsilon))*lim_t_spp_16
                p_spp_graz_zoo  = max(p_spp_graz_zoo ,0.0)

                ! grazing of zooplankton eating diazotroph cyanobacteria :
                p_cya_graz_zoo  = ((t_zoo+zoo0)*lr_graz_zoo*(0.5*t_cya)/max(food_zoo,epsilon))*lim_t_cya_17
                p_cya_graz_zoo  = max(p_cya_graz_zoo ,0.0)

                ! respiration of large-cell phytoplankton :
                p_lpp_resp_nh4  = (t_lpp*r_lpp_resp)*lim_t_o2_2*lim_t_lpp_15
                p_lpp_resp_nh4  = max(p_lpp_resp_nh4 ,0.0)

                ! respiration of small-cell phytoplankton :
                p_spp_resp_nh4  = (t_spp*r_spp_resp)*lim_t_spp_16*lim_t_o2_2
                p_spp_resp_nh4  = max(p_spp_resp_nh4 ,0.0)

                ! respiration of diazotroph cyanobacteria :
                p_cya_resp_nh4  = (t_cya*r_cya_resp)*lim_t_cya_17*lim_t_o2_2
                p_cya_resp_nh4  = max(p_cya_resp_nh4 ,0.0)

                ! respiration of zooplankton :
                p_zoo_resp_nh4  = (zoo_eff*r_zoo_resp)*lim_t_zoo_18*lim_t_o2_2
                p_zoo_resp_nh4  = max(p_zoo_resp_nh4 ,0.0)

                ! mortality of large-cell phytoplankton :
                p_lpp_mort_det  = (t_lpp*r_pp_mort*(1+9*theta(5.0e-6-t_o2)))*lim_t_lpp_15
                p_lpp_mort_det  = max(p_lpp_mort_det ,0.0)

                ! mortality of small-scale phytoplankton :
                p_spp_mort_det  = (t_spp*r_pp_mort*(1+9*theta(5.0e-6-t_o2)))*lim_t_spp_16
                p_spp_mort_det  = max(p_spp_mort_det ,0.0)

                ! mortality of diazotroph cyanobacteria :
                p_cya_mort_det  = (t_cya*r_pp_mort*(1+9*theta(5.0e-6-t_o2)))*lim_t_cya_17
                p_cya_mort_det  = max(p_cya_mort_det ,0.0)

                ! mortality of diazotroph cyanobacteria due to strong turbulence :
                p_cya_mort_det_diff = (t_cya*r_pp_mort*(r_cya_mort_diff*theta(cgt_diffusivity-r_cya_mort_thresh)))*lim_t_cya_17
                p_cya_mort_det_diff = max(p_cya_mort_det_diff,0.0)

                ! mortality of zooplankton :
                p_zoo_mort_det  = (zoo_eff*r_zoo_mort*(1+9*theta(5.0e-6-t_o2)))*lim_t_zoo_18
                p_zoo_mort_det  = max(p_zoo_mort_det ,0.0)

                ! nitrification :
                p_nh4_nit_no3   = (t_nh4*r_nh4_nitrif*exp(q10_nit*cgt_temp))*lim_t_o2_2*lim_t_nh4_11
                p_nh4_nit_no3   = max(p_nh4_nit_no3  ,0.0)

                ! recycling of detritus using oxygen (respiration) :
                p_det_resp_nh4  = (t_det*r_det_rec*exp(q10_det_rec*cgt_temp))*lim_t_o2_0*lim_t_det_19
                p_det_resp_nh4  = max(p_det_resp_nh4 ,0.0)

                ! recycling of detritus using nitrate (denitrification) :
                p_det_denit_nh4 = (t_det*r_det_rec*exp(q10_det_rec*cgt_temp))*(1.0-lim_t_o2_0)*lim_t_no3_1*lim_t_det_19
                p_det_denit_nh4 = max(p_det_denit_nh4,0.0)

                ! recycling of detritus using sulfate (sulfate reduction) :
                p_det_sulf_nh4  = (t_det*r_det_rec*exp(q10_det_rec*cgt_temp))*(1.0-lim_t_o2_0)*(1.0-lim_t_no3_1)*lim_t_det_19
                p_det_sulf_nh4  = max(p_det_sulf_nh4 ,0.0)

                ! oxidation of hydrogen sulfide with oxygen :
                p_h2s_oxo2_sul  = (t_h2s*t_o2*k_h2s_o2*exp(q10_h2s*cgt_temp))*lim_t_h2s_23*lim_t_o2_2
                p_h2s_oxo2_sul  = max(p_h2s_oxo2_sul ,0.0)

                ! oxidation of hydrogen sulfide with nitrate :
                p_h2s_oxno3_sul = (t_h2s*t_no3*k_h2s_no3*exp(q10_h2s*cgt_temp))*lim_t_h2s_23*lim_t_no3_10
                p_h2s_oxno3_sul = max(p_h2s_oxno3_sul,0.0)

                ! oxidation of elemental sulfur with oxygen :
                p_sul_oxo2_so4  = (t_sul*t_o2*k_sul_o2*exp(q10_h2s*cgt_temp))*lim_t_o2_2*lim_t_sul_24
                p_sul_oxo2_so4  = max(p_sul_oxo2_so4 ,0.0)

                ! oxidation of elemental sulfur with nitrate :
                p_sul_oxno3_so4 = (t_sul*t_no3*k_sul_no3*exp(q10_h2s*cgt_temp))*lim_t_sul_24*lim_t_no3_10
                p_sul_oxno3_so4 = max(p_sul_oxno3_so4,0.0)

                ! particle formation from DOC :
                p_doc2pco       = (t_doc * r_doc2poc)*lim_t_doc_28
                p_doc2pco       = max(p_doc2pco      ,0.0)

                ! particle formation from DOP :
                p_dop2pocp      = (t_dop * r_dop2pocp)*lim_t_dop_29
                p_dop2pocp      = max(p_dop2pocp     ,0.0)

                ! particle formation from DON :
                p_don2pocn      = (t_don * r_don2pocn)*lim_t_don_30
                p_don2pocn      = max(p_don2pocn     ,0.0)

                ! respiration of DOC :
                p_doc_resp      = (t_doc * r_doc_rec * exp(q10_doc_rec * cgt_temp))*lim_t_o2_0*lim_t_doc_28
                p_doc_resp      = max(p_doc_resp     ,0.0)

                ! recycling of DOC using nitrate (denitrification) :
                p_doc_denit     = (t_doc*r_doc_rec*exp(q10_det_rec*cgt_temp))*(1.0-lim_t_o2_0)*lim_t_no3_1*lim_t_doc_28
                p_doc_denit     = max(p_doc_denit    ,0.0)

                ! Mineralization of DOC, e-acceptor sulfate (sulfate reduction) :
                p_doc_sulf      = (t_doc*r_doc_rec*exp(q10_det_rec*cgt_temp))*(1.0-lim_t_o2_0)*(1.0-lim_t_no3_1)*lim_t_doc_28
                p_doc_sulf      = max(p_doc_sulf     ,0.0)

                ! respiration of DOP :
                p_dop_resp      = (t_dop * lr_dop * exp(q10_det_rec * cgt_temp))*lim_t_o2_0*lim_t_dop_29
                p_dop_resp      = max(p_dop_resp     ,0.0)

                ! recycling of DOP using nitrate (denitrification) :
                p_dop_denit     = (t_dop*r_dop_rec*exp(q10_det_rec*cgt_temp))*(1.0-lim_t_o2_0)*lim_t_no3_1*lim_t_dop_29
                p_dop_denit     = max(p_dop_denit    ,0.0)

                ! Mineralization of DOP, e-acceptor sulfate (sulfate reduction) :
                p_dop_sulf      = (t_dop*r_dop_rec*exp(q10_det_rec*cgt_temp))*(1.0-lim_t_o2_0)*(1.0-lim_t_no3_1)*lim_t_dop_29
                p_dop_sulf      = max(p_dop_sulf     ,0.0)

                ! respiration of DON :
                p_don_resp      = (t_don * lr_don * exp(q10_det_rec * cgt_temp))*lim_t_o2_0*lim_t_don_30
                p_don_resp      = max(p_don_resp     ,0.0)

                ! recycling of DON using nitrate (denitrification) :
                p_don_denit_noN2 = (t_don*r_don_rec*exp(q10_det_rec*cgt_temp))*(1.0-lim_t_o2_0)*lim_t_no3_1*lim_t_don_30
                p_don_denit_noN2 = max(p_don_denit_noN2,0.0)

                ! recycling of DON using nitrate (denitrification) :
                p_don_denit_wiN2 = (t_don*r_don_rec*exp(q10_det_rec*cgt_temp))*(1.0-lim_t_o2_0)*lim_t_no3_1
                p_don_denit_wiN2 = max(p_don_denit_wiN2,0.0)

                ! Mineralization of DON, e-acceptor sulfate (sulfate reduction) :
                p_don_sulf      = (t_don*r_don_rec*exp(q10_det_rec*cgt_temp))*(1.0-lim_t_o2_0)*(1.0-lim_t_no3_1)*lim_t_don_30
                p_don_sulf      = max(p_don_sulf     ,0.0)

                ! assimilation of nitrate by large-cell phytoplankton; sub-process for atmos_tot nitrogen :
                p_no3_assim_lpp_atmos_tot_N = p_no3_assim_lpp * ((1.0)*(1)*max(0.0,min(1.0,t_no3_with_atmos_tot_N/max(0.00000000001,t_no3)))) / ((1.0)*(1))
                p_no3_assim_lpp_atmos_tot_N = max(p_no3_assim_lpp_atmos_tot_N,0.0)

                ! assimilation of ammonium by large-cell phytoplankton; sub-process for atmos_tot nitrogen :
                p_nh4_assim_lpp_atmos_tot_N = p_nh4_assim_lpp * ((1.0)*(1)*max(0.0,min(1.0,t_nh4_with_atmos_tot_N/max(0.00000000001,t_nh4)))) / ((1.0)*(1))
                p_nh4_assim_lpp_atmos_tot_N = max(p_nh4_assim_lpp_atmos_tot_N,0.0)

                ! assimilation of nitrate by small-cell phytoplankton; sub-process for atmos_tot nitrogen :
                p_no3_assim_spp_atmos_tot_N = p_no3_assim_spp * ((1.0)*(1)*max(0.0,min(1.0,t_no3_with_atmos_tot_N/max(0.00000000001,t_no3)))) / ((1.0)*(1))
                p_no3_assim_spp_atmos_tot_N = max(p_no3_assim_spp_atmos_tot_N,0.0)

                ! assimilation of ammonium by small-cell phytoplankton; sub-process for atmos_tot nitrogen :
                p_nh4_assim_spp_atmos_tot_N = p_nh4_assim_spp * ((1.0)*(1)*max(0.0,min(1.0,t_nh4_with_atmos_tot_N/max(0.00000000001,t_nh4)))) / ((1.0)*(1))
                p_nh4_assim_spp_atmos_tot_N = max(p_nh4_assim_spp_atmos_tot_N,0.0)

                ! Production of DON by LPP; sub-process for atmos_tot nitrogen :
                p_nh4_assim_lpp_don_atmos_tot_N = p_nh4_assim_lpp_don * ((1.0)*(1)*max(0.0,min(1.0,t_nh4_with_atmos_tot_N/max(0.00000000001,t_nh4)))) / ((1.0)*(1))
                p_nh4_assim_lpp_don_atmos_tot_N = max(p_nh4_assim_lpp_don_atmos_tot_N,0.0)

                ! Production of DON by LPP; sub-process for atmos_tot nitrogen :
                p_no3_assim_lpp_don_atmos_tot_N = p_no3_assim_lpp_don * ((1.0)*(1)*max(0.0,min(1.0,t_no3_with_atmos_tot_N/max(0.00000000001,t_no3)))) / ((1.0)*(1))
                p_no3_assim_lpp_don_atmos_tot_N = max(p_no3_assim_lpp_don_atmos_tot_N,0.0)

                ! Production of DON by SPP; sub-process for atmos_tot nitrogen :
                p_nh4_assim_spp_don_atmos_tot_N = p_nh4_assim_spp_don * ((1.0)*(1)*max(0.0,min(1.0,t_nh4_with_atmos_tot_N/max(0.00000000001,t_nh4)))) / ((1.0)*(1))
                p_nh4_assim_spp_don_atmos_tot_N = max(p_nh4_assim_spp_don_atmos_tot_N,0.0)

                ! Production of DON by SPP; sub-process for atmos_tot nitrogen :
                p_no3_assim_spp_don_atmos_tot_N = p_no3_assim_spp_don * ((1.0)*(1)*max(0.0,min(1.0,t_no3_with_atmos_tot_N/max(0.00000000001,t_no3)))) / ((1.0)*(1))
                p_no3_assim_spp_don_atmos_tot_N = max(p_no3_assim_spp_don_atmos_tot_N,0.0)

                ! respiration of POCN; sub-process for atmos_tot nitrogen :
                p_pocn_resp_atmos_tot_N = p_pocn_resp * ((1.0)*(1)*max(0.0,min(1.0,t_pocn_with_atmos_tot_N/max(0.00000000001,t_pocn)))) / ((1.0)*(1))
                p_pocn_resp_atmos_tot_N = max(p_pocn_resp_atmos_tot_N,0.0)

                ! recycling of POCN using nitrate (denitrification); sub-process for atmos_tot nitrogen :
                p_pocn_denit_noN2_atmos_tot_N = p_pocn_denit_noN2 * ((1.0)*(1)*max(0.0,min(1.0,t_pocn_with_atmos_tot_N/max(0.00000000001,t_pocn)))) / ((1.0)*(1))
                p_pocn_denit_noN2_atmos_tot_N = max(p_pocn_denit_noN2_atmos_tot_N,0.0)

                ! Mineralization of POCN, e-acceptor sulfate (sulfate reduction); sub-process for atmos_tot nitrogen :
                p_pocn_sulf_atmos_tot_N = p_pocn_sulf * ((1.0)*(1)*max(0.0,min(1.0,t_pocn_with_atmos_tot_N/max(0.00000000001,t_pocn)))) / ((1.0)*(1))
                p_pocn_sulf_atmos_tot_N = max(p_pocn_sulf_atmos_tot_N,0.0)

                ! grazing of zooplankton eating large-cell phytoplankton; sub-process for atmos_tot nitrogen :
                p_lpp_graz_zoo_atmos_tot_N = p_lpp_graz_zoo * ((1.0)*(1)*max(0.0,min(1.0,t_lpp_with_atmos_tot_N/max(0.00000000001,t_lpp)))) / ((1.0)*(1))
                p_lpp_graz_zoo_atmos_tot_N = max(p_lpp_graz_zoo_atmos_tot_N,0.0)

                ! grazing of zooplankton eating small-cell phytoplankton; sub-process for atmos_tot nitrogen :
                p_spp_graz_zoo_atmos_tot_N = p_spp_graz_zoo * ((1.0)*(1)*max(0.0,min(1.0,t_spp_with_atmos_tot_N/max(0.00000000001,t_spp)))) / ((1.0)*(1))
                p_spp_graz_zoo_atmos_tot_N = max(p_spp_graz_zoo_atmos_tot_N,0.0)

                ! grazing of zooplankton eating diazotroph cyanobacteria; sub-process for atmos_tot nitrogen :
                p_cya_graz_zoo_atmos_tot_N = p_cya_graz_zoo * ((1.0)*(1)*max(0.0,min(1.0,t_cya_with_atmos_tot_N/max(0.00000000001,t_cya)))) / ((1.0)*(1))
                p_cya_graz_zoo_atmos_tot_N = max(p_cya_graz_zoo_atmos_tot_N,0.0)

                ! respiration of large-cell phytoplankton; sub-process for atmos_tot nitrogen :
                p_lpp_resp_nh4_atmos_tot_N = p_lpp_resp_nh4 * ((1.0)*(1)*max(0.0,min(1.0,t_lpp_with_atmos_tot_N/max(0.00000000001,t_lpp)))) / ((1.0)*(1))
                p_lpp_resp_nh4_atmos_tot_N = max(p_lpp_resp_nh4_atmos_tot_N,0.0)

                ! respiration of small-cell phytoplankton; sub-process for atmos_tot nitrogen :
                p_spp_resp_nh4_atmos_tot_N = p_spp_resp_nh4 * ((1.0)*(1)*max(0.0,min(1.0,t_spp_with_atmos_tot_N/max(0.00000000001,t_spp)))) / ((1.0)*(1))
                p_spp_resp_nh4_atmos_tot_N = max(p_spp_resp_nh4_atmos_tot_N,0.0)

                ! respiration of diazotroph cyanobacteria; sub-process for atmos_tot nitrogen :
                p_cya_resp_nh4_atmos_tot_N = p_cya_resp_nh4 * ((1.0)*(1)*max(0.0,min(1.0,t_cya_with_atmos_tot_N/max(0.00000000001,t_cya)))) / ((1.0)*(1))
                p_cya_resp_nh4_atmos_tot_N = max(p_cya_resp_nh4_atmos_tot_N,0.0)

                ! respiration of zooplankton; sub-process for atmos_tot nitrogen :
                p_zoo_resp_nh4_atmos_tot_N = p_zoo_resp_nh4 * ((1.0)*(1)*max(0.0,min(1.0,t_zoo_with_atmos_tot_N/max(0.00000000001,t_zoo)))) / ((1.0)*(1))
                p_zoo_resp_nh4_atmos_tot_N = max(p_zoo_resp_nh4_atmos_tot_N,0.0)

                ! mortality of large-cell phytoplankton; sub-process for atmos_tot nitrogen :
                p_lpp_mort_det_atmos_tot_N = p_lpp_mort_det * ((1.0)*(1)*max(0.0,min(1.0,t_lpp_with_atmos_tot_N/max(0.00000000001,t_lpp)))) / ((1.0)*(1))
                p_lpp_mort_det_atmos_tot_N = max(p_lpp_mort_det_atmos_tot_N,0.0)

                ! mortality of small-scale phytoplankton; sub-process for atmos_tot nitrogen :
                p_spp_mort_det_atmos_tot_N = p_spp_mort_det * ((1.0)*(1)*max(0.0,min(1.0,t_spp_with_atmos_tot_N/max(0.00000000001,t_spp)))) / ((1.0)*(1))
                p_spp_mort_det_atmos_tot_N = max(p_spp_mort_det_atmos_tot_N,0.0)

                ! mortality of diazotroph cyanobacteria; sub-process for atmos_tot nitrogen :
                p_cya_mort_det_atmos_tot_N = p_cya_mort_det * ((1.0)*(1)*max(0.0,min(1.0,t_cya_with_atmos_tot_N/max(0.00000000001,t_cya)))) / ((1.0)*(1))
                p_cya_mort_det_atmos_tot_N = max(p_cya_mort_det_atmos_tot_N,0.0)

                ! mortality of diazotroph cyanobacteria due to strong turbulence; sub-process for atmos_tot nitrogen :
                p_cya_mort_det_diff_atmos_tot_N = p_cya_mort_det_diff * ((1.0)*(1)*max(0.0,min(1.0,t_cya_with_atmos_tot_N/max(0.00000000001,t_cya)))) / ((1.0)*(1))
                p_cya_mort_det_diff_atmos_tot_N = max(p_cya_mort_det_diff_atmos_tot_N,0.0)

                ! mortality of zooplankton; sub-process for atmos_tot nitrogen :
                p_zoo_mort_det_atmos_tot_N = p_zoo_mort_det * ((1.0)*(1)*max(0.0,min(1.0,t_zoo_with_atmos_tot_N/max(0.00000000001,t_zoo)))) / ((1.0)*(1))
                p_zoo_mort_det_atmos_tot_N = max(p_zoo_mort_det_atmos_tot_N,0.0)

                ! nitrification; sub-process for atmos_tot nitrogen :
                p_nh4_nit_no3_atmos_tot_N = p_nh4_nit_no3 * ((1.0)*(1)*max(0.0,min(1.0,t_nh4_with_atmos_tot_N/max(0.00000000001,t_nh4)))) / ((1.0)*(1))
                p_nh4_nit_no3_atmos_tot_N = max(p_nh4_nit_no3_atmos_tot_N,0.0)

                ! recycling of detritus using oxygen (respiration); sub-process for atmos_tot nitrogen :
                p_det_resp_nh4_atmos_tot_N = p_det_resp_nh4 * ((1.0)*(1)*max(0.0,min(1.0,t_det_with_atmos_tot_N/max(0.00000000001,t_det)))) / ((1.0)*(1))
                p_det_resp_nh4_atmos_tot_N = max(p_det_resp_nh4_atmos_tot_N,0.0)

                ! recycling of detritus using sulfate (sulfate reduction); sub-process for atmos_tot nitrogen :
                p_det_sulf_nh4_atmos_tot_N = p_det_sulf_nh4 * ((1.0)*(1)*max(0.0,min(1.0,t_det_with_atmos_tot_N/max(0.00000000001,t_det)))) / ((1.0)*(1))
                p_det_sulf_nh4_atmos_tot_N = max(p_det_sulf_nh4_atmos_tot_N,0.0)

                ! particle formation from DON; sub-process for atmos_tot nitrogen :
                p_don2pocn_atmos_tot_N = p_don2pocn * ((1.0)*(1)*max(0.0,min(1.0,t_don_with_atmos_tot_N/max(0.00000000001,t_don)))) / ((1.0)*(1))
                p_don2pocn_atmos_tot_N = max(p_don2pocn_atmos_tot_N,0.0)

                ! respiration of DON; sub-process for atmos_tot nitrogen :
                p_don_resp_atmos_tot_N = p_don_resp * ((1.0)*(1)*max(0.0,min(1.0,t_don_with_atmos_tot_N/max(0.00000000001,t_don)))) / ((1.0)*(1))
                p_don_resp_atmos_tot_N = max(p_don_resp_atmos_tot_N,0.0)

                ! recycling of DON using nitrate (denitrification); sub-process for atmos_tot nitrogen :
                p_don_denit_noN2_atmos_tot_N = p_don_denit_noN2 * ((1.0)*(1)*max(0.0,min(1.0,t_don_with_atmos_tot_N/max(0.00000000001,t_don)))) / ((1.0)*(1))
                p_don_denit_noN2_atmos_tot_N = max(p_don_denit_noN2_atmos_tot_N,0.0)

                ! Mineralization of DON, e-acceptor sulfate (sulfate reduction); sub-process for atmos_tot nitrogen :
                p_don_sulf_atmos_tot_N = p_don_sulf * ((1.0)*(1)*max(0.0,min(1.0,t_don_with_atmos_tot_N/max(0.00000000001,t_don)))) / ((1.0)*(1))
                p_don_sulf_atmos_tot_N = max(p_don_sulf_atmos_tot_N,0.0)

                ! assimilation of nitrate by large-cell phytoplankton; sub-process for atmos_ship nitrogen :
                p_no3_assim_lpp_atmos_ship_N = p_no3_assim_lpp * ((1.0)*(1)*max(0.0,min(1.0,t_no3_with_atmos_ship_N/max(0.00000000001,t_no3)))) / ((1.0)*(1))
                p_no3_assim_lpp_atmos_ship_N = max(p_no3_assim_lpp_atmos_ship_N,0.0)

                ! assimilation of ammonium by large-cell phytoplankton; sub-process for atmos_ship nitrogen :
                p_nh4_assim_lpp_atmos_ship_N = p_nh4_assim_lpp * ((1.0)*(1)*max(0.0,min(1.0,t_nh4_with_atmos_ship_N/max(0.00000000001,t_nh4)))) / ((1.0)*(1))
                p_nh4_assim_lpp_atmos_ship_N = max(p_nh4_assim_lpp_atmos_ship_N,0.0)

                ! assimilation of nitrate by small-cell phytoplankton; sub-process for atmos_ship nitrogen :
                p_no3_assim_spp_atmos_ship_N = p_no3_assim_spp * ((1.0)*(1)*max(0.0,min(1.0,t_no3_with_atmos_ship_N/max(0.00000000001,t_no3)))) / ((1.0)*(1))
                p_no3_assim_spp_atmos_ship_N = max(p_no3_assim_spp_atmos_ship_N,0.0)

                ! assimilation of ammonium by small-cell phytoplankton; sub-process for atmos_ship nitrogen :
                p_nh4_assim_spp_atmos_ship_N = p_nh4_assim_spp * ((1.0)*(1)*max(0.0,min(1.0,t_nh4_with_atmos_ship_N/max(0.00000000001,t_nh4)))) / ((1.0)*(1))
                p_nh4_assim_spp_atmos_ship_N = max(p_nh4_assim_spp_atmos_ship_N,0.0)

                ! Production of DON by LPP; sub-process for atmos_ship nitrogen :
                p_nh4_assim_lpp_don_atmos_ship_N = p_nh4_assim_lpp_don * ((1.0)*(1)*max(0.0,min(1.0,t_nh4_with_atmos_ship_N/max(0.00000000001,t_nh4)))) / ((1.0)*(1))
                p_nh4_assim_lpp_don_atmos_ship_N = max(p_nh4_assim_lpp_don_atmos_ship_N,0.0)

                ! Production of DON by LPP; sub-process for atmos_ship nitrogen :
                p_no3_assim_lpp_don_atmos_ship_N = p_no3_assim_lpp_don * ((1.0)*(1)*max(0.0,min(1.0,t_no3_with_atmos_ship_N/max(0.00000000001,t_no3)))) / ((1.0)*(1))
                p_no3_assim_lpp_don_atmos_ship_N = max(p_no3_assim_lpp_don_atmos_ship_N,0.0)

                ! Production of DON by SPP; sub-process for atmos_ship nitrogen :
                p_nh4_assim_spp_don_atmos_ship_N = p_nh4_assim_spp_don * ((1.0)*(1)*max(0.0,min(1.0,t_nh4_with_atmos_ship_N/max(0.00000000001,t_nh4)))) / ((1.0)*(1))
                p_nh4_assim_spp_don_atmos_ship_N = max(p_nh4_assim_spp_don_atmos_ship_N,0.0)

                ! Production of DON by SPP; sub-process for atmos_ship nitrogen :
                p_no3_assim_spp_don_atmos_ship_N = p_no3_assim_spp_don * ((1.0)*(1)*max(0.0,min(1.0,t_no3_with_atmos_ship_N/max(0.00000000001,t_no3)))) / ((1.0)*(1))
                p_no3_assim_spp_don_atmos_ship_N = max(p_no3_assim_spp_don_atmos_ship_N,0.0)

                ! respiration of POCN; sub-process for atmos_ship nitrogen :
                p_pocn_resp_atmos_ship_N = p_pocn_resp * ((1.0)*(1)*max(0.0,min(1.0,t_pocn_with_atmos_ship_N/max(0.00000000001,t_pocn)))) / ((1.0)*(1))
                p_pocn_resp_atmos_ship_N = max(p_pocn_resp_atmos_ship_N,0.0)

                ! recycling of POCN using nitrate (denitrification); sub-process for atmos_ship nitrogen :
                p_pocn_denit_noN2_atmos_ship_N = p_pocn_denit_noN2 * ((1.0)*(1)*max(0.0,min(1.0,t_pocn_with_atmos_ship_N/max(0.00000000001,t_pocn)))) / ((1.0)*(1))
                p_pocn_denit_noN2_atmos_ship_N = max(p_pocn_denit_noN2_atmos_ship_N,0.0)

                ! Mineralization of POCN, e-acceptor sulfate (sulfate reduction); sub-process for atmos_ship nitrogen :
                p_pocn_sulf_atmos_ship_N = p_pocn_sulf * ((1.0)*(1)*max(0.0,min(1.0,t_pocn_with_atmos_ship_N/max(0.00000000001,t_pocn)))) / ((1.0)*(1))
                p_pocn_sulf_atmos_ship_N = max(p_pocn_sulf_atmos_ship_N,0.0)

                ! grazing of zooplankton eating large-cell phytoplankton; sub-process for atmos_ship nitrogen :
                p_lpp_graz_zoo_atmos_ship_N = p_lpp_graz_zoo * ((1.0)*(1)*max(0.0,min(1.0,t_lpp_with_atmos_ship_N/max(0.00000000001,t_lpp)))) / ((1.0)*(1))
                p_lpp_graz_zoo_atmos_ship_N = max(p_lpp_graz_zoo_atmos_ship_N,0.0)

                ! grazing of zooplankton eating small-cell phytoplankton; sub-process for atmos_ship nitrogen :
                p_spp_graz_zoo_atmos_ship_N = p_spp_graz_zoo * ((1.0)*(1)*max(0.0,min(1.0,t_spp_with_atmos_ship_N/max(0.00000000001,t_spp)))) / ((1.0)*(1))
                p_spp_graz_zoo_atmos_ship_N = max(p_spp_graz_zoo_atmos_ship_N,0.0)

                ! grazing of zooplankton eating diazotroph cyanobacteria; sub-process for atmos_ship nitrogen :
                p_cya_graz_zoo_atmos_ship_N = p_cya_graz_zoo * ((1.0)*(1)*max(0.0,min(1.0,t_cya_with_atmos_ship_N/max(0.00000000001,t_cya)))) / ((1.0)*(1))
                p_cya_graz_zoo_atmos_ship_N = max(p_cya_graz_zoo_atmos_ship_N,0.0)

                ! respiration of large-cell phytoplankton; sub-process for atmos_ship nitrogen :
                p_lpp_resp_nh4_atmos_ship_N = p_lpp_resp_nh4 * ((1.0)*(1)*max(0.0,min(1.0,t_lpp_with_atmos_ship_N/max(0.00000000001,t_lpp)))) / ((1.0)*(1))
                p_lpp_resp_nh4_atmos_ship_N = max(p_lpp_resp_nh4_atmos_ship_N,0.0)

                ! respiration of small-cell phytoplankton; sub-process for atmos_ship nitrogen :
                p_spp_resp_nh4_atmos_ship_N = p_spp_resp_nh4 * ((1.0)*(1)*max(0.0,min(1.0,t_spp_with_atmos_ship_N/max(0.00000000001,t_spp)))) / ((1.0)*(1))
                p_spp_resp_nh4_atmos_ship_N = max(p_spp_resp_nh4_atmos_ship_N,0.0)

                ! respiration of diazotroph cyanobacteria; sub-process for atmos_ship nitrogen :
                p_cya_resp_nh4_atmos_ship_N = p_cya_resp_nh4 * ((1.0)*(1)*max(0.0,min(1.0,t_cya_with_atmos_ship_N/max(0.00000000001,t_cya)))) / ((1.0)*(1))
                p_cya_resp_nh4_atmos_ship_N = max(p_cya_resp_nh4_atmos_ship_N,0.0)

                ! respiration of zooplankton; sub-process for atmos_ship nitrogen :
                p_zoo_resp_nh4_atmos_ship_N = p_zoo_resp_nh4 * ((1.0)*(1)*max(0.0,min(1.0,t_zoo_with_atmos_ship_N/max(0.00000000001,t_zoo)))) / ((1.0)*(1))
                p_zoo_resp_nh4_atmos_ship_N = max(p_zoo_resp_nh4_atmos_ship_N,0.0)

                ! mortality of large-cell phytoplankton; sub-process for atmos_ship nitrogen :
                p_lpp_mort_det_atmos_ship_N = p_lpp_mort_det * ((1.0)*(1)*max(0.0,min(1.0,t_lpp_with_atmos_ship_N/max(0.00000000001,t_lpp)))) / ((1.0)*(1))
                p_lpp_mort_det_atmos_ship_N = max(p_lpp_mort_det_atmos_ship_N,0.0)

                ! mortality of small-scale phytoplankton; sub-process for atmos_ship nitrogen :
                p_spp_mort_det_atmos_ship_N = p_spp_mort_det * ((1.0)*(1)*max(0.0,min(1.0,t_spp_with_atmos_ship_N/max(0.00000000001,t_spp)))) / ((1.0)*(1))
                p_spp_mort_det_atmos_ship_N = max(p_spp_mort_det_atmos_ship_N,0.0)

                ! mortality of diazotroph cyanobacteria; sub-process for atmos_ship nitrogen :
                p_cya_mort_det_atmos_ship_N = p_cya_mort_det * ((1.0)*(1)*max(0.0,min(1.0,t_cya_with_atmos_ship_N/max(0.00000000001,t_cya)))) / ((1.0)*(1))
                p_cya_mort_det_atmos_ship_N = max(p_cya_mort_det_atmos_ship_N,0.0)

                ! mortality of diazotroph cyanobacteria due to strong turbulence; sub-process for atmos_ship nitrogen :
                p_cya_mort_det_diff_atmos_ship_N = p_cya_mort_det_diff * ((1.0)*(1)*max(0.0,min(1.0,t_cya_with_atmos_ship_N/max(0.00000000001,t_cya)))) / ((1.0)*(1))
                p_cya_mort_det_diff_atmos_ship_N = max(p_cya_mort_det_diff_atmos_ship_N,0.0)

                ! mortality of zooplankton; sub-process for atmos_ship nitrogen :
                p_zoo_mort_det_atmos_ship_N = p_zoo_mort_det * ((1.0)*(1)*max(0.0,min(1.0,t_zoo_with_atmos_ship_N/max(0.00000000001,t_zoo)))) / ((1.0)*(1))
                p_zoo_mort_det_atmos_ship_N = max(p_zoo_mort_det_atmos_ship_N,0.0)

                ! nitrification; sub-process for atmos_ship nitrogen :
                p_nh4_nit_no3_atmos_ship_N = p_nh4_nit_no3 * ((1.0)*(1)*max(0.0,min(1.0,t_nh4_with_atmos_ship_N/max(0.00000000001,t_nh4)))) / ((1.0)*(1))
                p_nh4_nit_no3_atmos_ship_N = max(p_nh4_nit_no3_atmos_ship_N,0.0)

                ! recycling of detritus using oxygen (respiration); sub-process for atmos_ship nitrogen :
                p_det_resp_nh4_atmos_ship_N = p_det_resp_nh4 * ((1.0)*(1)*max(0.0,min(1.0,t_det_with_atmos_ship_N/max(0.00000000001,t_det)))) / ((1.0)*(1))
                p_det_resp_nh4_atmos_ship_N = max(p_det_resp_nh4_atmos_ship_N,0.0)

                ! recycling of detritus using sulfate (sulfate reduction); sub-process for atmos_ship nitrogen :
                p_det_sulf_nh4_atmos_ship_N = p_det_sulf_nh4 * ((1.0)*(1)*max(0.0,min(1.0,t_det_with_atmos_ship_N/max(0.00000000001,t_det)))) / ((1.0)*(1))
                p_det_sulf_nh4_atmos_ship_N = max(p_det_sulf_nh4_atmos_ship_N,0.0)

                ! particle formation from DON; sub-process for atmos_ship nitrogen :
                p_don2pocn_atmos_ship_N = p_don2pocn * ((1.0)*(1)*max(0.0,min(1.0,t_don_with_atmos_ship_N/max(0.00000000001,t_don)))) / ((1.0)*(1))
                p_don2pocn_atmos_ship_N = max(p_don2pocn_atmos_ship_N,0.0)

                ! respiration of DON; sub-process for atmos_ship nitrogen :
                p_don_resp_atmos_ship_N = p_don_resp * ((1.0)*(1)*max(0.0,min(1.0,t_don_with_atmos_ship_N/max(0.00000000001,t_don)))) / ((1.0)*(1))
                p_don_resp_atmos_ship_N = max(p_don_resp_atmos_ship_N,0.0)

                ! recycling of DON using nitrate (denitrification); sub-process for atmos_ship nitrogen :
                p_don_denit_noN2_atmos_ship_N = p_don_denit_noN2 * ((1.0)*(1)*max(0.0,min(1.0,t_don_with_atmos_ship_N/max(0.00000000001,t_don)))) / ((1.0)*(1))
                p_don_denit_noN2_atmos_ship_N = max(p_don_denit_noN2_atmos_ship_N,0.0)

                ! Mineralization of DON, e-acceptor sulfate (sulfate reduction); sub-process for atmos_ship nitrogen :
                p_don_sulf_atmos_ship_N = p_don_sulf * ((1.0)*(1)*max(0.0,min(1.0,t_don_with_atmos_ship_N/max(0.00000000001,t_don)))) / ((1.0)*(1))
                p_don_sulf_atmos_ship_N = max(p_don_sulf_atmos_ship_N,0.0)


                if (k == grid_kmt(i,j)) then
                   ! recycling of sedimentary detritus to ammonium using oxygen (respiration) :
                   p_sed_resp_nh4  = (lr_sed_rec*sed_active)*lim_t_o2_2*lim_t_sed_20
                   p_sed_resp_nh4  = max(p_sed_resp_nh4 ,0.0)

                   ! coupled nitrification and denitrification after mineralization of detritus in oxic sediments :
                   p_nh4_nitdenit_n2 = (frac_denit_sed*p_sed_resp_nh4*theta(t_o2-5.0e-6))*lim_t_o2_2*lim_t_nh4_11
                   p_nh4_nitdenit_n2 = max(p_nh4_nitdenit_n2,0.0)

                   ! recycling of sedimentary detritus to ammonium using nitrate (denitrification) :
                   p_sed_denit_nh4_noN2 = (lr_sed_rec*sed_active)*(1.0-lim_t_o2_2)*lim_t_no3_3*lim_t_sed_20
                   p_sed_denit_nh4_noN2 = max(p_sed_denit_nh4_noN2,0.0)

                   ! recycling of sedimentary detritus to ammonium using nitrate (denitrification) :
                   p_sed_denit_nh4_wiN2 = (lr_sed_rec*sed_active)*(1.0-lim_t_o2_2)*lim_t_no3_3
                   p_sed_denit_nh4_wiN2 = max(p_sed_denit_nh4_wiN2,0.0)

                   ! recycling of sedimentary detritus to ammonium using sulfate (sulfate reduction) :
                   p_sed_sulf_nh4  = (lr_sed_rec*sed_active)*(1.0-lim_t_o2_2)*(1.0-lim_t_no3_3)*lim_t_sed_20
                   p_sed_sulf_nh4  = max(p_sed_sulf_nh4 ,0.0)

                   ! recycling of sedimentary poc to dic using oxygen (respiration) :
                   p_sed_poc_resp  = (lr_sed_rec*poc_active)*lim_t_sed_poc_21*lim_t_o2_2
                   p_sed_poc_resp  = max(p_sed_poc_resp ,0.0)

                   ! recycling of sedimentary poc to dic using nitrate (denitrification) :
                   p_sed_poc_denit = (lr_sed_rec*poc_active)*(1.0-lim_t_o2_2)*lim_t_no3_3*lim_t_sed_poc_21
                   p_sed_poc_denit = max(p_sed_poc_denit,0.0)

                   ! recycling of sedimentary poc to dic using sulfate (sulfate reduction) :
                   p_sed_poc_sulf  = (lr_sed_rec*poc_active)*(1.0-lim_t_o2_2)*(1.0-lim_t_no3_3)*lim_t_sed_poc_21
                   p_sed_poc_sulf  = max(p_sed_poc_sulf ,0.0)

                   ! retention of phosphate in the sediment under oxic conditions :
                   p_po4_retent_ips = (p_sed_resp_nh4*frac_po4retent)*lim_t_o2_4*lim_t_po4_9
                   p_po4_retent_ips = max(p_po4_retent_ips,0.0)

                   ! liberation of phosphate from the sediment under anoxic conditions :
                   p_ips_liber_po4 = (t_ips*r_ips_liber)*lim_t_h2s_5*lim_t_ips_22
                   p_ips_liber_po4 = max(p_ips_liber_po4,0.0)

                   ! detritus sedimentation :
                   p_det_sedi_sed  = ((1.0-erosion_is_active)*(0.0-w_det_sedi)*t_det*cgt_density)*lim_t_det_19
                   p_det_sedi_sed  = max(p_det_sedi_sed ,0.0)

                   ! sedimentation of iron PO4 :
                   p_ipw_sedi_ips  = ((1.0-erosion_is_active)*(0.0-w_ipw_sedi)*t_ipw*cgt_density)*lim_t_ipw_25
                   p_ipw_sedi_ips  = max(p_ipw_sedi_ips ,0.0)

                   ! poc sedimentation :
                   p_poc_sedi_sed  = ((1.0-erosion_is_active)*(0.0-w_poc_sedi)*t_poc*cgt_density)*lim_t_poc_12
                   p_poc_sedi_sed  = max(p_poc_sedi_sed ,0.0)

                   ! pocn sedimentation :
                   p_pocn_sedi_sed = ((1.0-erosion_is_active)*(0.0-w_pocn_sedi)*t_pocn*cgt_density)*lim_t_pocn_14
                   p_pocn_sedi_sed = max(p_pocn_sedi_sed,0.0)

                   ! pocp sedimentation :
                   p_pocp_sedi_sed = ((1.0-erosion_is_active)*(0.0-w_pocp_sedi)*t_pocp*cgt_density)*lim_t_pocp_13
                   p_pocp_sedi_sed = max(p_pocp_sedi_sed,0.0)

                   ! sedimentary detritus erosion :
                   p_sed_ero_det   = (erosion_is_active*r_sed_ero*sed_active)*lim_t_sed_20
                   p_sed_ero_det   = max(p_sed_ero_det  ,0.0)

                   ! erosion of iron PO4 :
                   p_ips_ero_ipw   = (erosion_is_active*r_ips_ero*t_ips)*lim_t_ips_22
                   p_ips_ero_ipw   = max(p_ips_ero_ipw  ,0.0)

                   ! sedimentary poc erosion :
                   p_sed_ero_poc   = (erosion_is_active*r_sed_ero*poc_active)*lim_t_sed_poc_21
                   p_sed_ero_poc   = max(p_sed_ero_poc  ,0.0)

                   ! sedimentary pocn erosion :
                   p_sed_ero_pocn  = (erosion_is_active*r_sed_ero*pocn_active)*lim_t_sed_pocn_26
                   p_sed_ero_pocn  = max(p_sed_ero_pocn ,0.0)

                   ! sedimentary pocp erosion :
                   p_sed_ero_pocp  = (erosion_is_active*r_sed_ero*pocp_active)*lim_t_sed_pocp_27
                   p_sed_ero_pocp  = max(p_sed_ero_pocp ,0.0)

                   ! bio resuspension of sedimentary detritus :
                   p_sed_biores_det = (r_biores*exp(-0.02*cgt_bottomdepth)*sed_active)*lim_t_o2_6*lim_t_sed_20
                   p_sed_biores_det = max(p_sed_biores_det,0.0)

                   ! bio resuspension of iron PO4 :
                   p_ips_biores_ipw = (r_biores*exp(-0.02*cgt_bottomdepth)*t_ips)*lim_t_o2_6*lim_t_ips_22
                   p_ips_biores_ipw = max(p_ips_biores_ipw,0.0)

                   ! bio resuspension of sedimentary poc :
                   p_sed_biores_poc = (r_biores*exp(-0.02*cgt_bottomdepth)*poc_active)*lim_t_o2_6*lim_t_sed_poc_21
                   p_sed_biores_poc = max(p_sed_biores_poc,0.0)

                   ! bio resuspension of sedimentary pocn :
                   p_sed_biores_pocn = (r_biores*exp(-0.02*cgt_bottomdepth)*pocn_active)*lim_t_o2_6*lim_t_sed_pocn_26
                   p_sed_biores_pocn = max(p_sed_biores_pocn,0.0)

                   ! bio resuspension of sedimentary pocp :
                   p_sed_biores_pocp = (r_biores*exp(-0.02*cgt_bottomdepth)*pocp_active)*lim_t_o2_6*lim_t_sed_pocp_27
                   p_sed_biores_pocp = max(p_sed_biores_pocp,0.0)

                   ! burial of detritus deeper than max_sed :
                   p_sed_burial    = ((sed_tot-sed_tot_active)/cgt_timestep*t_sed/sed_tot)*lim_t_sed_20
                   p_sed_burial    = max(p_sed_burial   ,0.0)

                   ! burial of iron PO4 :
                   p_ips_burial    = (ips_eff*r_ips_burial*sed_tot_active/rfr_c/sed_max)*lim_t_ips_22
                   p_ips_burial    = max(p_ips_burial   ,0.0)

                   ! burial of poc deeper than max_sed :
                   p_poc_burial    = ((sed_tot-sed_tot_active)/cgt_timestep*t_sed_poc/sed_tot)*lim_t_sed_poc_21
                   p_poc_burial    = max(p_poc_burial   ,0.0)

                   ! burial of pocn deeper than max_sed :
                   p_pocn_burial   = ((sed_tot-sed_tot_active)/cgt_timestep*t_sed_pocn/sed_tot)*lim_t_sed_pocn_26
                   p_pocn_burial   = max(p_pocn_burial  ,0.0)

                   ! burial of pocp deeper than max_sed :
                   p_pocp_burial   = ((sed_tot-sed_tot_active)/cgt_timestep*t_sed_pocp/sed_tot)*lim_t_sed_pocp_27
                   p_pocp_burial   = max(p_pocp_burial  ,0.0)

                   ! recycling of sedimentary pocn to dic and NH4 using oxygen (respiration) :
                   p_sed_pocn_resp = (lr_sed_rec*pocn_active)*lim_t_sed_pocn_26*lim_t_o2_2
                   p_sed_pocn_resp = max(p_sed_pocn_resp,0.0)

                   ! recycling of sedimentary pocp to dic and PO4 using oxygen (respiration) :
                   p_sed_pocp_resp = (lr_sed_rec*pocp_active)*lim_t_o2_2*lim_t_sed_pocp_27
                   p_sed_pocp_resp = max(p_sed_pocp_resp,0.0)

                   ! recycling of sedimentary pocn to dic and NH4 using nitrate (denitrification) :
                   p_sed_pocn_denit_noN2 = (lr_sed_rec*pocn_active)*(1.0-lim_t_o2_2)*lim_t_no3_3*lim_t_sed_pocn_26
                   p_sed_pocn_denit_noN2 = max(p_sed_pocn_denit_noN2,0.0)

                   ! recycling of sedimentary pocn to dic and NH4 using nitrate (denitrification) :
                   p_sed_pocn_denit_wiN2 = (lr_sed_rec*pocn_active)*(1.0-lim_t_o2_2)*lim_t_no3_3
                   p_sed_pocn_denit_wiN2 = max(p_sed_pocn_denit_wiN2,0.0)

                   ! recycling of sedimentary pocp to dic and PO4 using nitrate (denitrification) :
                   p_sed_pocp_denit = (lr_sed_rec*pocp_active)*(1.0-lim_t_o2_2)*lim_t_no3_3*lim_t_sed_pocp_27
                   p_sed_pocp_denit = max(p_sed_pocp_denit,0.0)

                   ! recycling of sedimentary pocn to dic and NH4 using sulfate (sulfate reduction) :
                   p_sed_pocn_sulf = (lr_sed_rec*pocn_active)*(1.0-lim_t_o2_2)*(1.0-lim_t_no3_3)*lim_t_pocn_14
                   p_sed_pocn_sulf = max(p_sed_pocn_sulf,0.0)

                   ! recycling of sedimentary pocp to dic and PO4 using sulfate (sulfate reduction) :
                   p_sed_pocp_sulf = (lr_sed_rec*pocp_active)*(1.0-lim_t_o2_2)*(1.0-lim_t_no3_3)*lim_t_pocp_13
                   p_sed_pocp_sulf = max(p_sed_pocp_sulf,0.0)

                   ! coupled nitrification and denitrification after mineralization of pocn-detritus in oxic sediments :
                   p_nh4_nitdenit_pocn_n2 = (frac_denit_sed*p_sed_pocn_resp*theta(t_o2-5.0e-6))*lim_t_nh4_11*lim_t_o2_2
                   p_nh4_nitdenit_pocn_n2 = max(p_nh4_nitdenit_pocn_n2,0.0)

                   ! recycling of sedimentary detritus to ammonium using oxygen (respiration); sub-process for atmos_tot nitrogen :
                   p_sed_resp_nh4_atmos_tot_N = p_sed_resp_nh4 * ((1.0)*(1)*max(0.0,min(1.0,t_sed_with_atmos_tot_N/max(0.00000000001,t_sed)))) / ((1.0)*(1))
                   p_sed_resp_nh4_atmos_tot_N = max(p_sed_resp_nh4_atmos_tot_N,0.0)

                   ! recycling of sedimentary detritus to ammonium using nitrate (denitrification); sub-process for atmos_tot nitrogen :
                   p_sed_denit_nh4_noN2_atmos_tot_N = p_sed_denit_nh4_noN2 * ((1.0)*(1)*max(0.0,min(1.0,t_sed_with_atmos_tot_N/max(0.00000000001,t_sed)))) / ((1.0)*(1))
                   p_sed_denit_nh4_noN2_atmos_tot_N = max(p_sed_denit_nh4_noN2_atmos_tot_N,0.0)

                   ! recycling of sedimentary detritus to ammonium using sulfate (sulfate reduction); sub-process for atmos_tot nitrogen :
                   p_sed_sulf_nh4_atmos_tot_N = p_sed_sulf_nh4 * ((1.0)*(1)*max(0.0,min(1.0,t_sed_with_atmos_tot_N/max(0.00000000001,t_sed)))) / ((1.0)*(1))
                   p_sed_sulf_nh4_atmos_tot_N = max(p_sed_sulf_nh4_atmos_tot_N,0.0)

                   ! detritus sedimentation; sub-process for atmos_tot nitrogen :
                   p_det_sedi_sed_atmos_tot_N = p_det_sedi_sed * ((1.0)*(1)*max(0.0,min(1.0,t_det_with_atmos_tot_N/max(0.00000000001,t_det)))) / ((1.0)*(1))
                   p_det_sedi_sed_atmos_tot_N = max(p_det_sedi_sed_atmos_tot_N,0.0)

                   ! pocn sedimentation; sub-process for atmos_tot nitrogen :
                   p_pocn_sedi_sed_atmos_tot_N = p_pocn_sedi_sed * ((1.0)*(1)*max(0.0,min(1.0,t_pocn_with_atmos_tot_N/max(0.00000000001,t_pocn)))) / ((1.0)*(1))
                   p_pocn_sedi_sed_atmos_tot_N = max(p_pocn_sedi_sed_atmos_tot_N,0.0)

                   ! sedimentary detritus erosion; sub-process for atmos_tot nitrogen :
                   p_sed_ero_det_atmos_tot_N = p_sed_ero_det * ((1.0)*(1)*max(0.0,min(1.0,t_sed_with_atmos_tot_N/max(0.00000000001,t_sed)))) / ((1.0)*(1))
                   p_sed_ero_det_atmos_tot_N = max(p_sed_ero_det_atmos_tot_N,0.0)

                   ! sedimentary pocn erosion; sub-process for atmos_tot nitrogen :
                   p_sed_ero_pocn_atmos_tot_N = p_sed_ero_pocn * ((1.0)*(1)*max(0.0,min(1.0,t_sed_pocn_with_atmos_tot_N/max(0.00000000001,t_sed_pocn)))) / ((1.0)*(1))
                   p_sed_ero_pocn_atmos_tot_N = max(p_sed_ero_pocn_atmos_tot_N,0.0)

                   ! bio resuspension of sedimentary detritus; sub-process for atmos_tot nitrogen :
                   p_sed_biores_det_atmos_tot_N = p_sed_biores_det * ((1.0)*(1)*max(0.0,min(1.0,t_sed_with_atmos_tot_N/max(0.00000000001,t_sed)))) / ((1.0)*(1))
                   p_sed_biores_det_atmos_tot_N = max(p_sed_biores_det_atmos_tot_N,0.0)

                   ! bio resuspension of sedimentary pocn; sub-process for atmos_tot nitrogen :
                   p_sed_biores_pocn_atmos_tot_N = p_sed_biores_pocn * ((1.0)*(1)*max(0.0,min(1.0,t_sed_pocn_with_atmos_tot_N/max(0.00000000001,t_sed_pocn)))) / ((1.0)*(1))
                   p_sed_biores_pocn_atmos_tot_N = max(p_sed_biores_pocn_atmos_tot_N,0.0)

                   ! burial of detritus deeper than max_sed; sub-process for atmos_tot nitrogen :
                   p_sed_burial_atmos_tot_N = p_sed_burial * ((1.0)*(1)*max(0.0,min(1.0,t_sed_with_atmos_tot_N/max(0.00000000001,t_sed)))) / ((1.0)*(1))
                   p_sed_burial_atmos_tot_N = max(p_sed_burial_atmos_tot_N,0.0)

                   ! burial of pocn deeper than max_sed; sub-process for atmos_tot nitrogen :
                   p_pocn_burial_atmos_tot_N = p_pocn_burial * ((1.0)*(1)*max(0.0,min(1.0,t_sed_pocn_with_atmos_tot_N/max(0.00000000001,t_sed_pocn)))) / ((1.0)*(1))
                   p_pocn_burial_atmos_tot_N = max(p_pocn_burial_atmos_tot_N,0.0)

                   ! recycling of sedimentary pocn to dic and NH4 using oxygen (respiration); sub-process for atmos_tot nitrogen :
                   p_sed_pocn_resp_atmos_tot_N = p_sed_pocn_resp * ((1.0)*(1)*max(0.0,min(1.0,t_sed_pocn_with_atmos_tot_N/max(0.00000000001,t_sed_pocn)))) / ((1.0)*(1))
                   p_sed_pocn_resp_atmos_tot_N = max(p_sed_pocn_resp_atmos_tot_N,0.0)

                   ! recycling of sedimentary pocn to dic and NH4 using nitrate (denitrification); sub-process for atmos_tot nitrogen :
                   p_sed_pocn_denit_noN2_atmos_tot_N = p_sed_pocn_denit_noN2 * ((1.0)*(1)*max(0.0,min(1.0,t_sed_pocn_with_atmos_tot_N/max(0.00000000001,t_sed_pocn)))) / ((1.0)*(1))
                   p_sed_pocn_denit_noN2_atmos_tot_N = max(p_sed_pocn_denit_noN2_atmos_tot_N,0.0)

                   ! recycling of sedimentary pocn to dic and NH4 using sulfate (sulfate reduction); sub-process for atmos_tot nitrogen :
                   p_sed_pocn_sulf_atmos_tot_N = p_sed_pocn_sulf * ((1.0)*(1)*max(0.0,min(1.0,t_pocn_with_atmos_tot_N/max(0.00000000001,t_pocn)))) / ((1.0)*(1))
                   p_sed_pocn_sulf_atmos_tot_N = max(p_sed_pocn_sulf_atmos_tot_N,0.0)

                   ! recycling of sedimentary detritus to ammonium using oxygen (respiration); sub-process for atmos_ship nitrogen :
                   p_sed_resp_nh4_atmos_ship_N = p_sed_resp_nh4 * ((1.0)*(1)*max(0.0,min(1.0,t_sed_with_atmos_ship_N/max(0.00000000001,t_sed)))) / ((1.0)*(1))
                   p_sed_resp_nh4_atmos_ship_N = max(p_sed_resp_nh4_atmos_ship_N,0.0)

                   ! recycling of sedimentary detritus to ammonium using nitrate (denitrification); sub-process for atmos_ship nitrogen :
                   p_sed_denit_nh4_noN2_atmos_ship_N = p_sed_denit_nh4_noN2 * ((1.0)*(1)*max(0.0,min(1.0,t_sed_with_atmos_ship_N/max(0.00000000001,t_sed)))) / ((1.0)*(1))
                   p_sed_denit_nh4_noN2_atmos_ship_N = max(p_sed_denit_nh4_noN2_atmos_ship_N,0.0)

                   ! recycling of sedimentary detritus to ammonium using sulfate (sulfate reduction); sub-process for atmos_ship nitrogen :
                   p_sed_sulf_nh4_atmos_ship_N = p_sed_sulf_nh4 * ((1.0)*(1)*max(0.0,min(1.0,t_sed_with_atmos_ship_N/max(0.00000000001,t_sed)))) / ((1.0)*(1))
                   p_sed_sulf_nh4_atmos_ship_N = max(p_sed_sulf_nh4_atmos_ship_N,0.0)

                   ! detritus sedimentation; sub-process for atmos_ship nitrogen :
                   p_det_sedi_sed_atmos_ship_N = p_det_sedi_sed * ((1.0)*(1)*max(0.0,min(1.0,t_det_with_atmos_ship_N/max(0.00000000001,t_det)))) / ((1.0)*(1))
                   p_det_sedi_sed_atmos_ship_N = max(p_det_sedi_sed_atmos_ship_N,0.0)

                   ! pocn sedimentation; sub-process for atmos_ship nitrogen :
                   p_pocn_sedi_sed_atmos_ship_N = p_pocn_sedi_sed * ((1.0)*(1)*max(0.0,min(1.0,t_pocn_with_atmos_ship_N/max(0.00000000001,t_pocn)))) / ((1.0)*(1))
                   p_pocn_sedi_sed_atmos_ship_N = max(p_pocn_sedi_sed_atmos_ship_N,0.0)

                   ! sedimentary detritus erosion; sub-process for atmos_ship nitrogen :
                   p_sed_ero_det_atmos_ship_N = p_sed_ero_det * ((1.0)*(1)*max(0.0,min(1.0,t_sed_with_atmos_ship_N/max(0.00000000001,t_sed)))) / ((1.0)*(1))
                   p_sed_ero_det_atmos_ship_N = max(p_sed_ero_det_atmos_ship_N,0.0)

                   ! sedimentary pocn erosion; sub-process for atmos_ship nitrogen :
                   p_sed_ero_pocn_atmos_ship_N = p_sed_ero_pocn * ((1.0)*(1)*max(0.0,min(1.0,t_sed_pocn_with_atmos_ship_N/max(0.00000000001,t_sed_pocn)))) / ((1.0)*(1))
                   p_sed_ero_pocn_atmos_ship_N = max(p_sed_ero_pocn_atmos_ship_N,0.0)

                   ! bio resuspension of sedimentary detritus; sub-process for atmos_ship nitrogen :
                   p_sed_biores_det_atmos_ship_N = p_sed_biores_det * ((1.0)*(1)*max(0.0,min(1.0,t_sed_with_atmos_ship_N/max(0.00000000001,t_sed)))) / ((1.0)*(1))
                   p_sed_biores_det_atmos_ship_N = max(p_sed_biores_det_atmos_ship_N,0.0)

                   ! bio resuspension of sedimentary pocn; sub-process for atmos_ship nitrogen :
                   p_sed_biores_pocn_atmos_ship_N = p_sed_biores_pocn * ((1.0)*(1)*max(0.0,min(1.0,t_sed_pocn_with_atmos_ship_N/max(0.00000000001,t_sed_pocn)))) / ((1.0)*(1))
                   p_sed_biores_pocn_atmos_ship_N = max(p_sed_biores_pocn_atmos_ship_N,0.0)

                   ! burial of detritus deeper than max_sed; sub-process for atmos_ship nitrogen :
                   p_sed_burial_atmos_ship_N = p_sed_burial * ((1.0)*(1)*max(0.0,min(1.0,t_sed_with_atmos_ship_N/max(0.00000000001,t_sed)))) / ((1.0)*(1))
                   p_sed_burial_atmos_ship_N = max(p_sed_burial_atmos_ship_N,0.0)

                   ! burial of pocn deeper than max_sed; sub-process for atmos_ship nitrogen :
                   p_pocn_burial_atmos_ship_N = p_pocn_burial * ((1.0)*(1)*max(0.0,min(1.0,t_sed_pocn_with_atmos_ship_N/max(0.00000000001,t_sed_pocn)))) / ((1.0)*(1))
                   p_pocn_burial_atmos_ship_N = max(p_pocn_burial_atmos_ship_N,0.0)

                   ! recycling of sedimentary pocn to dic and NH4 using oxygen (respiration); sub-process for atmos_ship nitrogen :
                   p_sed_pocn_resp_atmos_ship_N = p_sed_pocn_resp * ((1.0)*(1)*max(0.0,min(1.0,t_sed_pocn_with_atmos_ship_N/max(0.00000000001,t_sed_pocn)))) / ((1.0)*(1))
                   p_sed_pocn_resp_atmos_ship_N = max(p_sed_pocn_resp_atmos_ship_N,0.0)

                   ! recycling of sedimentary pocn to dic and NH4 using nitrate (denitrification); sub-process for atmos_ship nitrogen :
                   p_sed_pocn_denit_noN2_atmos_ship_N = p_sed_pocn_denit_noN2 * ((1.0)*(1)*max(0.0,min(1.0,t_sed_pocn_with_atmos_ship_N/max(0.00000000001,t_sed_pocn)))) / ((1.0)*(1))
                   p_sed_pocn_denit_noN2_atmos_ship_N = max(p_sed_pocn_denit_noN2_atmos_ship_N,0.0)

                   ! recycling of sedimentary pocn to dic and NH4 using sulfate (sulfate reduction); sub-process for atmos_ship nitrogen :
                   p_sed_pocn_sulf_atmos_ship_N = p_sed_pocn_sulf * ((1.0)*(1)*max(0.0,min(1.0,t_pocn_with_atmos_ship_N/max(0.00000000001,t_pocn)))) / ((1.0)*(1))
                   p_sed_pocn_sulf_atmos_ship_N = max(p_sed_pocn_sulf_atmos_ship_N,0.0)

                endif

                if (k == 1) then
                endif

                !------------------------------------
                ! STEP 6.7.2: save the process rates if intermediate time step (Runge-Kutta)
                !------------------------------------
                if ((number_of_loop == 1) .and. intermediate) then
                   ergom%saved_rate_p_no3_assim_lpp(i,j,k)=ergom%saved_rate_p_no3_assim_lpp(i,j,k)+p_no3_assim_lpp
                   ergom%saved_rate_p_nh4_assim_lpp(i,j,k)=ergom%saved_rate_p_nh4_assim_lpp(i,j,k)+p_nh4_assim_lpp
                   ergom%saved_rate_p_no3_assim_spp(i,j,k)=ergom%saved_rate_p_no3_assim_spp(i,j,k)+p_no3_assim_spp
                   ergom%saved_rate_p_nh4_assim_spp(i,j,k)=ergom%saved_rate_p_nh4_assim_spp(i,j,k)+p_nh4_assim_spp
                   ergom%saved_rate_p_n2_assim_cya (i,j,k)=ergom%saved_rate_p_n2_assim_cya (i,j,k)+p_n2_assim_cya 
                   ergom%saved_rate_p_assim_lpp_doc(i,j,k)=ergom%saved_rate_p_assim_lpp_doc(i,j,k)+p_assim_lpp_doc
                   ergom%saved_rate_p_assim_spp_doc(i,j,k)=ergom%saved_rate_p_assim_spp_doc(i,j,k)+p_assim_spp_doc
                   ergom%saved_rate_p_assim_cya_doc(i,j,k)=ergom%saved_rate_p_assim_cya_doc(i,j,k)+p_assim_cya_doc
                   ergom%saved_rate_p_assim_lpp_dop(i,j,k)=ergom%saved_rate_p_assim_lpp_dop(i,j,k)+p_assim_lpp_dop
                   ergom%saved_rate_p_assim_spp_dop(i,j,k)=ergom%saved_rate_p_assim_spp_dop(i,j,k)+p_assim_spp_dop
                   ergom%saved_rate_p_nh4_assim_lpp_don(i,j,k)=ergom%saved_rate_p_nh4_assim_lpp_don(i,j,k)+p_nh4_assim_lpp_don
                   ergom%saved_rate_p_no3_assim_lpp_don(i,j,k)=ergom%saved_rate_p_no3_assim_lpp_don(i,j,k)+p_no3_assim_lpp_don
                   ergom%saved_rate_p_nh4_assim_spp_don(i,j,k)=ergom%saved_rate_p_nh4_assim_spp_don(i,j,k)+p_nh4_assim_spp_don
                   ergom%saved_rate_p_no3_assim_spp_don(i,j,k)=ergom%saved_rate_p_no3_assim_spp_don(i,j,k)+p_no3_assim_spp_don
                   ergom%saved_rate_p_poc_resp     (i,j,k)=ergom%saved_rate_p_poc_resp     (i,j,k)+p_poc_resp     
                   ergom%saved_rate_p_poc_denit    (i,j,k)=ergom%saved_rate_p_poc_denit    (i,j,k)+p_poc_denit    
                   ergom%saved_rate_p_poc_sulf     (i,j,k)=ergom%saved_rate_p_poc_sulf     (i,j,k)+p_poc_sulf     
                   ergom%saved_rate_p_pocp_resp    (i,j,k)=ergom%saved_rate_p_pocp_resp    (i,j,k)+p_pocp_resp    
                   ergom%saved_rate_p_pocp_denit   (i,j,k)=ergom%saved_rate_p_pocp_denit   (i,j,k)+p_pocp_denit   
                   ergom%saved_rate_p_pocp_sulf    (i,j,k)=ergom%saved_rate_p_pocp_sulf    (i,j,k)+p_pocp_sulf    
                   ergom%saved_rate_p_pocn_resp    (i,j,k)=ergom%saved_rate_p_pocn_resp    (i,j,k)+p_pocn_resp    
                   ergom%saved_rate_p_pocn_denit_noN2(i,j,k)=ergom%saved_rate_p_pocn_denit_noN2(i,j,k)+p_pocn_denit_noN2
                   ergom%saved_rate_p_pocn_denit_wiN2(i,j,k)=ergom%saved_rate_p_pocn_denit_wiN2(i,j,k)+p_pocn_denit_wiN2
                   ergom%saved_rate_p_pocn_sulf    (i,j,k)=ergom%saved_rate_p_pocn_sulf    (i,j,k)+p_pocn_sulf    
                   ergom%saved_rate_p_lpp_graz_zoo (i,j,k)=ergom%saved_rate_p_lpp_graz_zoo (i,j,k)+p_lpp_graz_zoo 
                   ergom%saved_rate_p_spp_graz_zoo (i,j,k)=ergom%saved_rate_p_spp_graz_zoo (i,j,k)+p_spp_graz_zoo 
                   ergom%saved_rate_p_cya_graz_zoo (i,j,k)=ergom%saved_rate_p_cya_graz_zoo (i,j,k)+p_cya_graz_zoo 
                   ergom%saved_rate_p_lpp_resp_nh4 (i,j,k)=ergom%saved_rate_p_lpp_resp_nh4 (i,j,k)+p_lpp_resp_nh4 
                   ergom%saved_rate_p_spp_resp_nh4 (i,j,k)=ergom%saved_rate_p_spp_resp_nh4 (i,j,k)+p_spp_resp_nh4 
                   ergom%saved_rate_p_cya_resp_nh4 (i,j,k)=ergom%saved_rate_p_cya_resp_nh4 (i,j,k)+p_cya_resp_nh4 
                   ergom%saved_rate_p_zoo_resp_nh4 (i,j,k)=ergom%saved_rate_p_zoo_resp_nh4 (i,j,k)+p_zoo_resp_nh4 
                   ergom%saved_rate_p_lpp_mort_det (i,j,k)=ergom%saved_rate_p_lpp_mort_det (i,j,k)+p_lpp_mort_det 
                   ergom%saved_rate_p_spp_mort_det (i,j,k)=ergom%saved_rate_p_spp_mort_det (i,j,k)+p_spp_mort_det 
                   ergom%saved_rate_p_cya_mort_det (i,j,k)=ergom%saved_rate_p_cya_mort_det (i,j,k)+p_cya_mort_det 
                   ergom%saved_rate_p_cya_mort_det_diff(i,j,k)=ergom%saved_rate_p_cya_mort_det_diff(i,j,k)+p_cya_mort_det_diff
                   ergom%saved_rate_p_zoo_mort_det (i,j,k)=ergom%saved_rate_p_zoo_mort_det (i,j,k)+p_zoo_mort_det 
                   ergom%saved_rate_p_nh4_nit_no3  (i,j,k)=ergom%saved_rate_p_nh4_nit_no3  (i,j,k)+p_nh4_nit_no3  
                   ergom%saved_rate_p_det_resp_nh4 (i,j,k)=ergom%saved_rate_p_det_resp_nh4 (i,j,k)+p_det_resp_nh4 
                   ergom%saved_rate_p_det_denit_nh4(i,j,k)=ergom%saved_rate_p_det_denit_nh4(i,j,k)+p_det_denit_nh4
                   ergom%saved_rate_p_det_sulf_nh4 (i,j,k)=ergom%saved_rate_p_det_sulf_nh4 (i,j,k)+p_det_sulf_nh4 
                   ergom%saved_rate_p_h2s_oxo2_sul (i,j,k)=ergom%saved_rate_p_h2s_oxo2_sul (i,j,k)+p_h2s_oxo2_sul 
                   ergom%saved_rate_p_h2s_oxno3_sul(i,j,k)=ergom%saved_rate_p_h2s_oxno3_sul(i,j,k)+p_h2s_oxno3_sul
                   ergom%saved_rate_p_sul_oxo2_so4 (i,j,k)=ergom%saved_rate_p_sul_oxo2_so4 (i,j,k)+p_sul_oxo2_so4 
                   ergom%saved_rate_p_sul_oxno3_so4(i,j,k)=ergom%saved_rate_p_sul_oxno3_so4(i,j,k)+p_sul_oxno3_so4
                   ergom%saved_rate_p_doc2pco      (i,j,k)=ergom%saved_rate_p_doc2pco      (i,j,k)+p_doc2pco      
                   ergom%saved_rate_p_dop2pocp     (i,j,k)=ergom%saved_rate_p_dop2pocp     (i,j,k)+p_dop2pocp     
                   ergom%saved_rate_p_don2pocn     (i,j,k)=ergom%saved_rate_p_don2pocn     (i,j,k)+p_don2pocn     
                   ergom%saved_rate_p_doc_resp     (i,j,k)=ergom%saved_rate_p_doc_resp     (i,j,k)+p_doc_resp     
                   ergom%saved_rate_p_doc_denit    (i,j,k)=ergom%saved_rate_p_doc_denit    (i,j,k)+p_doc_denit    
                   ergom%saved_rate_p_doc_sulf     (i,j,k)=ergom%saved_rate_p_doc_sulf     (i,j,k)+p_doc_sulf     
                   ergom%saved_rate_p_dop_resp     (i,j,k)=ergom%saved_rate_p_dop_resp     (i,j,k)+p_dop_resp     
                   ergom%saved_rate_p_dop_denit    (i,j,k)=ergom%saved_rate_p_dop_denit    (i,j,k)+p_dop_denit    
                   ergom%saved_rate_p_dop_sulf     (i,j,k)=ergom%saved_rate_p_dop_sulf     (i,j,k)+p_dop_sulf     
                   ergom%saved_rate_p_don_resp     (i,j,k)=ergom%saved_rate_p_don_resp     (i,j,k)+p_don_resp     
                   ergom%saved_rate_p_don_denit_noN2(i,j,k)=ergom%saved_rate_p_don_denit_noN2(i,j,k)+p_don_denit_noN2
                   ergom%saved_rate_p_don_denit_wiN2(i,j,k)=ergom%saved_rate_p_don_denit_wiN2(i,j,k)+p_don_denit_wiN2
                   ergom%saved_rate_p_don_sulf     (i,j,k)=ergom%saved_rate_p_don_sulf     (i,j,k)+p_don_sulf     
                   ergom%saved_rate_p_no3_assim_lpp_atmos_tot_N(i,j,k)=ergom%saved_rate_p_no3_assim_lpp_atmos_tot_N(i,j,k)+p_no3_assim_lpp_atmos_tot_N
                   ergom%saved_rate_p_nh4_assim_lpp_atmos_tot_N(i,j,k)=ergom%saved_rate_p_nh4_assim_lpp_atmos_tot_N(i,j,k)+p_nh4_assim_lpp_atmos_tot_N
                   ergom%saved_rate_p_no3_assim_spp_atmos_tot_N(i,j,k)=ergom%saved_rate_p_no3_assim_spp_atmos_tot_N(i,j,k)+p_no3_assim_spp_atmos_tot_N
                   ergom%saved_rate_p_nh4_assim_spp_atmos_tot_N(i,j,k)=ergom%saved_rate_p_nh4_assim_spp_atmos_tot_N(i,j,k)+p_nh4_assim_spp_atmos_tot_N
                   ergom%saved_rate_p_nh4_assim_lpp_don_atmos_tot_N(i,j,k)=ergom%saved_rate_p_nh4_assim_lpp_don_atmos_tot_N(i,j,k)+p_nh4_assim_lpp_don_atmos_tot_N
                   ergom%saved_rate_p_no3_assim_lpp_don_atmos_tot_N(i,j,k)=ergom%saved_rate_p_no3_assim_lpp_don_atmos_tot_N(i,j,k)+p_no3_assim_lpp_don_atmos_tot_N
                   ergom%saved_rate_p_nh4_assim_spp_don_atmos_tot_N(i,j,k)=ergom%saved_rate_p_nh4_assim_spp_don_atmos_tot_N(i,j,k)+p_nh4_assim_spp_don_atmos_tot_N
                   ergom%saved_rate_p_no3_assim_spp_don_atmos_tot_N(i,j,k)=ergom%saved_rate_p_no3_assim_spp_don_atmos_tot_N(i,j,k)+p_no3_assim_spp_don_atmos_tot_N
                   ergom%saved_rate_p_pocn_resp_atmos_tot_N(i,j,k)=ergom%saved_rate_p_pocn_resp_atmos_tot_N(i,j,k)+p_pocn_resp_atmos_tot_N
                   ergom%saved_rate_p_pocn_denit_noN2_atmos_tot_N(i,j,k)=ergom%saved_rate_p_pocn_denit_noN2_atmos_tot_N(i,j,k)+p_pocn_denit_noN2_atmos_tot_N
                   ergom%saved_rate_p_pocn_sulf_atmos_tot_N(i,j,k)=ergom%saved_rate_p_pocn_sulf_atmos_tot_N(i,j,k)+p_pocn_sulf_atmos_tot_N
                   ergom%saved_rate_p_lpp_graz_zoo_atmos_tot_N(i,j,k)=ergom%saved_rate_p_lpp_graz_zoo_atmos_tot_N(i,j,k)+p_lpp_graz_zoo_atmos_tot_N
                   ergom%saved_rate_p_spp_graz_zoo_atmos_tot_N(i,j,k)=ergom%saved_rate_p_spp_graz_zoo_atmos_tot_N(i,j,k)+p_spp_graz_zoo_atmos_tot_N
                   ergom%saved_rate_p_cya_graz_zoo_atmos_tot_N(i,j,k)=ergom%saved_rate_p_cya_graz_zoo_atmos_tot_N(i,j,k)+p_cya_graz_zoo_atmos_tot_N
                   ergom%saved_rate_p_lpp_resp_nh4_atmos_tot_N(i,j,k)=ergom%saved_rate_p_lpp_resp_nh4_atmos_tot_N(i,j,k)+p_lpp_resp_nh4_atmos_tot_N
                   ergom%saved_rate_p_spp_resp_nh4_atmos_tot_N(i,j,k)=ergom%saved_rate_p_spp_resp_nh4_atmos_tot_N(i,j,k)+p_spp_resp_nh4_atmos_tot_N
                   ergom%saved_rate_p_cya_resp_nh4_atmos_tot_N(i,j,k)=ergom%saved_rate_p_cya_resp_nh4_atmos_tot_N(i,j,k)+p_cya_resp_nh4_atmos_tot_N
                   ergom%saved_rate_p_zoo_resp_nh4_atmos_tot_N(i,j,k)=ergom%saved_rate_p_zoo_resp_nh4_atmos_tot_N(i,j,k)+p_zoo_resp_nh4_atmos_tot_N
                   ergom%saved_rate_p_lpp_mort_det_atmos_tot_N(i,j,k)=ergom%saved_rate_p_lpp_mort_det_atmos_tot_N(i,j,k)+p_lpp_mort_det_atmos_tot_N
                   ergom%saved_rate_p_spp_mort_det_atmos_tot_N(i,j,k)=ergom%saved_rate_p_spp_mort_det_atmos_tot_N(i,j,k)+p_spp_mort_det_atmos_tot_N
                   ergom%saved_rate_p_cya_mort_det_atmos_tot_N(i,j,k)=ergom%saved_rate_p_cya_mort_det_atmos_tot_N(i,j,k)+p_cya_mort_det_atmos_tot_N
                   ergom%saved_rate_p_cya_mort_det_diff_atmos_tot_N(i,j,k)=ergom%saved_rate_p_cya_mort_det_diff_atmos_tot_N(i,j,k)+p_cya_mort_det_diff_atmos_tot_N
                   ergom%saved_rate_p_zoo_mort_det_atmos_tot_N(i,j,k)=ergom%saved_rate_p_zoo_mort_det_atmos_tot_N(i,j,k)+p_zoo_mort_det_atmos_tot_N
                   ergom%saved_rate_p_nh4_nit_no3_atmos_tot_N(i,j,k)=ergom%saved_rate_p_nh4_nit_no3_atmos_tot_N(i,j,k)+p_nh4_nit_no3_atmos_tot_N
                   ergom%saved_rate_p_det_resp_nh4_atmos_tot_N(i,j,k)=ergom%saved_rate_p_det_resp_nh4_atmos_tot_N(i,j,k)+p_det_resp_nh4_atmos_tot_N
                   ergom%saved_rate_p_det_sulf_nh4_atmos_tot_N(i,j,k)=ergom%saved_rate_p_det_sulf_nh4_atmos_tot_N(i,j,k)+p_det_sulf_nh4_atmos_tot_N
                   ergom%saved_rate_p_don2pocn_atmos_tot_N(i,j,k)=ergom%saved_rate_p_don2pocn_atmos_tot_N(i,j,k)+p_don2pocn_atmos_tot_N
                   ergom%saved_rate_p_don_resp_atmos_tot_N(i,j,k)=ergom%saved_rate_p_don_resp_atmos_tot_N(i,j,k)+p_don_resp_atmos_tot_N
                   ergom%saved_rate_p_don_denit_noN2_atmos_tot_N(i,j,k)=ergom%saved_rate_p_don_denit_noN2_atmos_tot_N(i,j,k)+p_don_denit_noN2_atmos_tot_N
                   ergom%saved_rate_p_don_sulf_atmos_tot_N(i,j,k)=ergom%saved_rate_p_don_sulf_atmos_tot_N(i,j,k)+p_don_sulf_atmos_tot_N
                   ergom%saved_rate_p_no3_assim_lpp_atmos_ship_N(i,j,k)=ergom%saved_rate_p_no3_assim_lpp_atmos_ship_N(i,j,k)+p_no3_assim_lpp_atmos_ship_N
                   ergom%saved_rate_p_nh4_assim_lpp_atmos_ship_N(i,j,k)=ergom%saved_rate_p_nh4_assim_lpp_atmos_ship_N(i,j,k)+p_nh4_assim_lpp_atmos_ship_N
                   ergom%saved_rate_p_no3_assim_spp_atmos_ship_N(i,j,k)=ergom%saved_rate_p_no3_assim_spp_atmos_ship_N(i,j,k)+p_no3_assim_spp_atmos_ship_N
                   ergom%saved_rate_p_nh4_assim_spp_atmos_ship_N(i,j,k)=ergom%saved_rate_p_nh4_assim_spp_atmos_ship_N(i,j,k)+p_nh4_assim_spp_atmos_ship_N
                   ergom%saved_rate_p_nh4_assim_lpp_don_atmos_ship_N(i,j,k)=ergom%saved_rate_p_nh4_assim_lpp_don_atmos_ship_N(i,j,k)+p_nh4_assim_lpp_don_atmos_ship_N
                   ergom%saved_rate_p_no3_assim_lpp_don_atmos_ship_N(i,j,k)=ergom%saved_rate_p_no3_assim_lpp_don_atmos_ship_N(i,j,k)+p_no3_assim_lpp_don_atmos_ship_N
                   ergom%saved_rate_p_nh4_assim_spp_don_atmos_ship_N(i,j,k)=ergom%saved_rate_p_nh4_assim_spp_don_atmos_ship_N(i,j,k)+p_nh4_assim_spp_don_atmos_ship_N
                   ergom%saved_rate_p_no3_assim_spp_don_atmos_ship_N(i,j,k)=ergom%saved_rate_p_no3_assim_spp_don_atmos_ship_N(i,j,k)+p_no3_assim_spp_don_atmos_ship_N
                   ergom%saved_rate_p_pocn_resp_atmos_ship_N(i,j,k)=ergom%saved_rate_p_pocn_resp_atmos_ship_N(i,j,k)+p_pocn_resp_atmos_ship_N
                   ergom%saved_rate_p_pocn_denit_noN2_atmos_ship_N(i,j,k)=ergom%saved_rate_p_pocn_denit_noN2_atmos_ship_N(i,j,k)+p_pocn_denit_noN2_atmos_ship_N
                   ergom%saved_rate_p_pocn_sulf_atmos_ship_N(i,j,k)=ergom%saved_rate_p_pocn_sulf_atmos_ship_N(i,j,k)+p_pocn_sulf_atmos_ship_N
                   ergom%saved_rate_p_lpp_graz_zoo_atmos_ship_N(i,j,k)=ergom%saved_rate_p_lpp_graz_zoo_atmos_ship_N(i,j,k)+p_lpp_graz_zoo_atmos_ship_N
                   ergom%saved_rate_p_spp_graz_zoo_atmos_ship_N(i,j,k)=ergom%saved_rate_p_spp_graz_zoo_atmos_ship_N(i,j,k)+p_spp_graz_zoo_atmos_ship_N
                   ergom%saved_rate_p_cya_graz_zoo_atmos_ship_N(i,j,k)=ergom%saved_rate_p_cya_graz_zoo_atmos_ship_N(i,j,k)+p_cya_graz_zoo_atmos_ship_N
                   ergom%saved_rate_p_lpp_resp_nh4_atmos_ship_N(i,j,k)=ergom%saved_rate_p_lpp_resp_nh4_atmos_ship_N(i,j,k)+p_lpp_resp_nh4_atmos_ship_N
                   ergom%saved_rate_p_spp_resp_nh4_atmos_ship_N(i,j,k)=ergom%saved_rate_p_spp_resp_nh4_atmos_ship_N(i,j,k)+p_spp_resp_nh4_atmos_ship_N
                   ergom%saved_rate_p_cya_resp_nh4_atmos_ship_N(i,j,k)=ergom%saved_rate_p_cya_resp_nh4_atmos_ship_N(i,j,k)+p_cya_resp_nh4_atmos_ship_N
                   ergom%saved_rate_p_zoo_resp_nh4_atmos_ship_N(i,j,k)=ergom%saved_rate_p_zoo_resp_nh4_atmos_ship_N(i,j,k)+p_zoo_resp_nh4_atmos_ship_N
                   ergom%saved_rate_p_lpp_mort_det_atmos_ship_N(i,j,k)=ergom%saved_rate_p_lpp_mort_det_atmos_ship_N(i,j,k)+p_lpp_mort_det_atmos_ship_N
                   ergom%saved_rate_p_spp_mort_det_atmos_ship_N(i,j,k)=ergom%saved_rate_p_spp_mort_det_atmos_ship_N(i,j,k)+p_spp_mort_det_atmos_ship_N
                   ergom%saved_rate_p_cya_mort_det_atmos_ship_N(i,j,k)=ergom%saved_rate_p_cya_mort_det_atmos_ship_N(i,j,k)+p_cya_mort_det_atmos_ship_N
                   ergom%saved_rate_p_cya_mort_det_diff_atmos_ship_N(i,j,k)=ergom%saved_rate_p_cya_mort_det_diff_atmos_ship_N(i,j,k)+p_cya_mort_det_diff_atmos_ship_N
                   ergom%saved_rate_p_zoo_mort_det_atmos_ship_N(i,j,k)=ergom%saved_rate_p_zoo_mort_det_atmos_ship_N(i,j,k)+p_zoo_mort_det_atmos_ship_N
                   ergom%saved_rate_p_nh4_nit_no3_atmos_ship_N(i,j,k)=ergom%saved_rate_p_nh4_nit_no3_atmos_ship_N(i,j,k)+p_nh4_nit_no3_atmos_ship_N
                   ergom%saved_rate_p_det_resp_nh4_atmos_ship_N(i,j,k)=ergom%saved_rate_p_det_resp_nh4_atmos_ship_N(i,j,k)+p_det_resp_nh4_atmos_ship_N
                   ergom%saved_rate_p_det_sulf_nh4_atmos_ship_N(i,j,k)=ergom%saved_rate_p_det_sulf_nh4_atmos_ship_N(i,j,k)+p_det_sulf_nh4_atmos_ship_N
                   ergom%saved_rate_p_don2pocn_atmos_ship_N(i,j,k)=ergom%saved_rate_p_don2pocn_atmos_ship_N(i,j,k)+p_don2pocn_atmos_ship_N
                   ergom%saved_rate_p_don_resp_atmos_ship_N(i,j,k)=ergom%saved_rate_p_don_resp_atmos_ship_N(i,j,k)+p_don_resp_atmos_ship_N
                   ergom%saved_rate_p_don_denit_noN2_atmos_ship_N(i,j,k)=ergom%saved_rate_p_don_denit_noN2_atmos_ship_N(i,j,k)+p_don_denit_noN2_atmos_ship_N
                   ergom%saved_rate_p_don_sulf_atmos_ship_N(i,j,k)=ergom%saved_rate_p_don_sulf_atmos_ship_N(i,j,k)+p_don_sulf_atmos_ship_N
                   if (k == grid_kmt(i,j)) then
                      ergom%saved_rate_p_sed_resp_nh4 (i,j)=ergom%saved_rate_p_sed_resp_nh4 (i,j)+p_sed_resp_nh4 
                      ergom%saved_rate_p_nh4_nitdenit_n2(i,j)=ergom%saved_rate_p_nh4_nitdenit_n2(i,j)+p_nh4_nitdenit_n2
                      ergom%saved_rate_p_sed_denit_nh4_noN2(i,j)=ergom%saved_rate_p_sed_denit_nh4_noN2(i,j)+p_sed_denit_nh4_noN2
                      ergom%saved_rate_p_sed_denit_nh4_wiN2(i,j)=ergom%saved_rate_p_sed_denit_nh4_wiN2(i,j)+p_sed_denit_nh4_wiN2
                      ergom%saved_rate_p_sed_sulf_nh4 (i,j)=ergom%saved_rate_p_sed_sulf_nh4 (i,j)+p_sed_sulf_nh4 
                      ergom%saved_rate_p_sed_poc_resp (i,j)=ergom%saved_rate_p_sed_poc_resp (i,j)+p_sed_poc_resp 
                      ergom%saved_rate_p_sed_poc_denit(i,j)=ergom%saved_rate_p_sed_poc_denit(i,j)+p_sed_poc_denit
                      ergom%saved_rate_p_sed_poc_sulf (i,j)=ergom%saved_rate_p_sed_poc_sulf (i,j)+p_sed_poc_sulf 
                      ergom%saved_rate_p_po4_retent_ips(i,j)=ergom%saved_rate_p_po4_retent_ips(i,j)+p_po4_retent_ips
                      ergom%saved_rate_p_ips_liber_po4(i,j)=ergom%saved_rate_p_ips_liber_po4(i,j)+p_ips_liber_po4
                      ergom%saved_rate_p_det_sedi_sed (i,j)=ergom%saved_rate_p_det_sedi_sed (i,j)+p_det_sedi_sed 
                      ergom%saved_rate_p_ipw_sedi_ips (i,j)=ergom%saved_rate_p_ipw_sedi_ips (i,j)+p_ipw_sedi_ips 
                      ergom%saved_rate_p_poc_sedi_sed (i,j)=ergom%saved_rate_p_poc_sedi_sed (i,j)+p_poc_sedi_sed 
                      ergom%saved_rate_p_pocn_sedi_sed(i,j)=ergom%saved_rate_p_pocn_sedi_sed(i,j)+p_pocn_sedi_sed
                      ergom%saved_rate_p_pocp_sedi_sed(i,j)=ergom%saved_rate_p_pocp_sedi_sed(i,j)+p_pocp_sedi_sed
                      ergom%saved_rate_p_sed_ero_det  (i,j)=ergom%saved_rate_p_sed_ero_det  (i,j)+p_sed_ero_det  
                      ergom%saved_rate_p_ips_ero_ipw  (i,j)=ergom%saved_rate_p_ips_ero_ipw  (i,j)+p_ips_ero_ipw  
                      ergom%saved_rate_p_sed_ero_poc  (i,j)=ergom%saved_rate_p_sed_ero_poc  (i,j)+p_sed_ero_poc  
                      ergom%saved_rate_p_sed_ero_pocn (i,j)=ergom%saved_rate_p_sed_ero_pocn (i,j)+p_sed_ero_pocn 
                      ergom%saved_rate_p_sed_ero_pocp (i,j)=ergom%saved_rate_p_sed_ero_pocp (i,j)+p_sed_ero_pocp 
                      ergom%saved_rate_p_sed_biores_det(i,j)=ergom%saved_rate_p_sed_biores_det(i,j)+p_sed_biores_det
                      ergom%saved_rate_p_ips_biores_ipw(i,j)=ergom%saved_rate_p_ips_biores_ipw(i,j)+p_ips_biores_ipw
                      ergom%saved_rate_p_sed_biores_poc(i,j)=ergom%saved_rate_p_sed_biores_poc(i,j)+p_sed_biores_poc
                      ergom%saved_rate_p_sed_biores_pocn(i,j)=ergom%saved_rate_p_sed_biores_pocn(i,j)+p_sed_biores_pocn
                      ergom%saved_rate_p_sed_biores_pocp(i,j)=ergom%saved_rate_p_sed_biores_pocp(i,j)+p_sed_biores_pocp
                      ergom%saved_rate_p_sed_burial   (i,j)=ergom%saved_rate_p_sed_burial   (i,j)+p_sed_burial   
                      ergom%saved_rate_p_ips_burial   (i,j)=ergom%saved_rate_p_ips_burial   (i,j)+p_ips_burial   
                      ergom%saved_rate_p_poc_burial   (i,j)=ergom%saved_rate_p_poc_burial   (i,j)+p_poc_burial   
                      ergom%saved_rate_p_pocn_burial  (i,j)=ergom%saved_rate_p_pocn_burial  (i,j)+p_pocn_burial  
                      ergom%saved_rate_p_pocp_burial  (i,j)=ergom%saved_rate_p_pocp_burial  (i,j)+p_pocp_burial  
                      ergom%saved_rate_p_sed_pocn_resp(i,j)=ergom%saved_rate_p_sed_pocn_resp(i,j)+p_sed_pocn_resp
                      ergom%saved_rate_p_sed_pocp_resp(i,j)=ergom%saved_rate_p_sed_pocp_resp(i,j)+p_sed_pocp_resp
                      ergom%saved_rate_p_sed_pocn_denit_noN2(i,j)=ergom%saved_rate_p_sed_pocn_denit_noN2(i,j)+p_sed_pocn_denit_noN2
                      ergom%saved_rate_p_sed_pocn_denit_wiN2(i,j)=ergom%saved_rate_p_sed_pocn_denit_wiN2(i,j)+p_sed_pocn_denit_wiN2
                      ergom%saved_rate_p_sed_pocp_denit(i,j)=ergom%saved_rate_p_sed_pocp_denit(i,j)+p_sed_pocp_denit
                      ergom%saved_rate_p_sed_pocn_sulf(i,j)=ergom%saved_rate_p_sed_pocn_sulf(i,j)+p_sed_pocn_sulf
                      ergom%saved_rate_p_sed_pocp_sulf(i,j)=ergom%saved_rate_p_sed_pocp_sulf(i,j)+p_sed_pocp_sulf
                      ergom%saved_rate_p_nh4_nitdenit_pocn_n2(i,j)=ergom%saved_rate_p_nh4_nitdenit_pocn_n2(i,j)+p_nh4_nitdenit_pocn_n2
                      ergom%saved_rate_p_sed_resp_nh4_atmos_tot_N(i,j)=ergom%saved_rate_p_sed_resp_nh4_atmos_tot_N(i,j)+p_sed_resp_nh4_atmos_tot_N
                      ergom%saved_rate_p_sed_denit_nh4_noN2_atmos_tot_N(i,j)=ergom%saved_rate_p_sed_denit_nh4_noN2_atmos_tot_N(i,j)+p_sed_denit_nh4_noN2_atmos_tot_N
                      ergom%saved_rate_p_sed_sulf_nh4_atmos_tot_N(i,j)=ergom%saved_rate_p_sed_sulf_nh4_atmos_tot_N(i,j)+p_sed_sulf_nh4_atmos_tot_N
                      ergom%saved_rate_p_det_sedi_sed_atmos_tot_N(i,j)=ergom%saved_rate_p_det_sedi_sed_atmos_tot_N(i,j)+p_det_sedi_sed_atmos_tot_N
                      ergom%saved_rate_p_pocn_sedi_sed_atmos_tot_N(i,j)=ergom%saved_rate_p_pocn_sedi_sed_atmos_tot_N(i,j)+p_pocn_sedi_sed_atmos_tot_N
                      ergom%saved_rate_p_sed_ero_det_atmos_tot_N(i,j)=ergom%saved_rate_p_sed_ero_det_atmos_tot_N(i,j)+p_sed_ero_det_atmos_tot_N
                      ergom%saved_rate_p_sed_ero_pocn_atmos_tot_N(i,j)=ergom%saved_rate_p_sed_ero_pocn_atmos_tot_N(i,j)+p_sed_ero_pocn_atmos_tot_N
                      ergom%saved_rate_p_sed_biores_det_atmos_tot_N(i,j)=ergom%saved_rate_p_sed_biores_det_atmos_tot_N(i,j)+p_sed_biores_det_atmos_tot_N
                      ergom%saved_rate_p_sed_biores_pocn_atmos_tot_N(i,j)=ergom%saved_rate_p_sed_biores_pocn_atmos_tot_N(i,j)+p_sed_biores_pocn_atmos_tot_N
                      ergom%saved_rate_p_sed_burial_atmos_tot_N(i,j)=ergom%saved_rate_p_sed_burial_atmos_tot_N(i,j)+p_sed_burial_atmos_tot_N
                      ergom%saved_rate_p_pocn_burial_atmos_tot_N(i,j)=ergom%saved_rate_p_pocn_burial_atmos_tot_N(i,j)+p_pocn_burial_atmos_tot_N
                      ergom%saved_rate_p_sed_pocn_resp_atmos_tot_N(i,j)=ergom%saved_rate_p_sed_pocn_resp_atmos_tot_N(i,j)+p_sed_pocn_resp_atmos_tot_N
                      ergom%saved_rate_p_sed_pocn_denit_noN2_atmos_tot_N(i,j)=ergom%saved_rate_p_sed_pocn_denit_noN2_atmos_tot_N(i,j)+p_sed_pocn_denit_noN2_atmos_tot_N
                      ergom%saved_rate_p_sed_pocn_sulf_atmos_tot_N(i,j)=ergom%saved_rate_p_sed_pocn_sulf_atmos_tot_N(i,j)+p_sed_pocn_sulf_atmos_tot_N
                      ergom%saved_rate_p_sed_resp_nh4_atmos_ship_N(i,j)=ergom%saved_rate_p_sed_resp_nh4_atmos_ship_N(i,j)+p_sed_resp_nh4_atmos_ship_N
                      ergom%saved_rate_p_sed_denit_nh4_noN2_atmos_ship_N(i,j)=ergom%saved_rate_p_sed_denit_nh4_noN2_atmos_ship_N(i,j)+p_sed_denit_nh4_noN2_atmos_ship_N
                      ergom%saved_rate_p_sed_sulf_nh4_atmos_ship_N(i,j)=ergom%saved_rate_p_sed_sulf_nh4_atmos_ship_N(i,j)+p_sed_sulf_nh4_atmos_ship_N
                      ergom%saved_rate_p_det_sedi_sed_atmos_ship_N(i,j)=ergom%saved_rate_p_det_sedi_sed_atmos_ship_N(i,j)+p_det_sedi_sed_atmos_ship_N
                      ergom%saved_rate_p_pocn_sedi_sed_atmos_ship_N(i,j)=ergom%saved_rate_p_pocn_sedi_sed_atmos_ship_N(i,j)+p_pocn_sedi_sed_atmos_ship_N
                      ergom%saved_rate_p_sed_ero_det_atmos_ship_N(i,j)=ergom%saved_rate_p_sed_ero_det_atmos_ship_N(i,j)+p_sed_ero_det_atmos_ship_N
                      ergom%saved_rate_p_sed_ero_pocn_atmos_ship_N(i,j)=ergom%saved_rate_p_sed_ero_pocn_atmos_ship_N(i,j)+p_sed_ero_pocn_atmos_ship_N
                      ergom%saved_rate_p_sed_biores_det_atmos_ship_N(i,j)=ergom%saved_rate_p_sed_biores_det_atmos_ship_N(i,j)+p_sed_biores_det_atmos_ship_N
                      ergom%saved_rate_p_sed_biores_pocn_atmos_ship_N(i,j)=ergom%saved_rate_p_sed_biores_pocn_atmos_ship_N(i,j)+p_sed_biores_pocn_atmos_ship_N
                      ergom%saved_rate_p_sed_burial_atmos_ship_N(i,j)=ergom%saved_rate_p_sed_burial_atmos_ship_N(i,j)+p_sed_burial_atmos_ship_N
                      ergom%saved_rate_p_pocn_burial_atmos_ship_N(i,j)=ergom%saved_rate_p_pocn_burial_atmos_ship_N(i,j)+p_pocn_burial_atmos_ship_N
                      ergom%saved_rate_p_sed_pocn_resp_atmos_ship_N(i,j)=ergom%saved_rate_p_sed_pocn_resp_atmos_ship_N(i,j)+p_sed_pocn_resp_atmos_ship_N
                      ergom%saved_rate_p_sed_pocn_denit_noN2_atmos_ship_N(i,j)=ergom%saved_rate_p_sed_pocn_denit_noN2_atmos_ship_N(i,j)+p_sed_pocn_denit_noN2_atmos_ship_N
                      ergom%saved_rate_p_sed_pocn_sulf_atmos_ship_N(i,j)=ergom%saved_rate_p_sed_pocn_sulf_atmos_ship_N(i,j)+p_sed_pocn_sulf_atmos_ship_N
                   endif
                   if (k == 1) then
                   endif
                endif

                !------------------------------------
                ! STEP 6.7.3: use saved rates if they apply (Runge-Kutta)
                !------------------------------------
                if (use_saved_rates) then
                   if ((p_no3_assim_lpp > 0.0) .and. (ergom%saved_rate_p_no3_assim_lpp(i,j,k) >= 0.0)) then
                      p_no3_assim_lpp = ergom%saved_rate_p_no3_assim_lpp(i,j,k)
                   endif
                   if ((p_nh4_assim_lpp > 0.0) .and. (ergom%saved_rate_p_nh4_assim_lpp(i,j,k) >= 0.0)) then
                      p_nh4_assim_lpp = ergom%saved_rate_p_nh4_assim_lpp(i,j,k)
                   endif
                   if ((p_no3_assim_spp > 0.0) .and. (ergom%saved_rate_p_no3_assim_spp(i,j,k) >= 0.0)) then
                      p_no3_assim_spp = ergom%saved_rate_p_no3_assim_spp(i,j,k)
                   endif
                   if ((p_nh4_assim_spp > 0.0) .and. (ergom%saved_rate_p_nh4_assim_spp(i,j,k) >= 0.0)) then
                      p_nh4_assim_spp = ergom%saved_rate_p_nh4_assim_spp(i,j,k)
                   endif
                   if ((p_n2_assim_cya  > 0.0) .and. (ergom%saved_rate_p_n2_assim_cya (i,j,k) >= 0.0)) then
                      p_n2_assim_cya  = ergom%saved_rate_p_n2_assim_cya (i,j,k)
                   endif
                   if ((p_assim_lpp_doc > 0.0) .and. (ergom%saved_rate_p_assim_lpp_doc(i,j,k) >= 0.0)) then
                      p_assim_lpp_doc = ergom%saved_rate_p_assim_lpp_doc(i,j,k)
                   endif
                   if ((p_assim_spp_doc > 0.0) .and. (ergom%saved_rate_p_assim_spp_doc(i,j,k) >= 0.0)) then
                      p_assim_spp_doc = ergom%saved_rate_p_assim_spp_doc(i,j,k)
                   endif
                   if ((p_assim_cya_doc > 0.0) .and. (ergom%saved_rate_p_assim_cya_doc(i,j,k) >= 0.0)) then
                      p_assim_cya_doc = ergom%saved_rate_p_assim_cya_doc(i,j,k)
                   endif
                   if ((p_assim_lpp_dop > 0.0) .and. (ergom%saved_rate_p_assim_lpp_dop(i,j,k) >= 0.0)) then
                      p_assim_lpp_dop = ergom%saved_rate_p_assim_lpp_dop(i,j,k)
                   endif
                   if ((p_assim_spp_dop > 0.0) .and. (ergom%saved_rate_p_assim_spp_dop(i,j,k) >= 0.0)) then
                      p_assim_spp_dop = ergom%saved_rate_p_assim_spp_dop(i,j,k)
                   endif
                   if ((p_nh4_assim_lpp_don > 0.0) .and. (ergom%saved_rate_p_nh4_assim_lpp_don(i,j,k) >= 0.0)) then
                      p_nh4_assim_lpp_don = ergom%saved_rate_p_nh4_assim_lpp_don(i,j,k)
                   endif
                   if ((p_no3_assim_lpp_don > 0.0) .and. (ergom%saved_rate_p_no3_assim_lpp_don(i,j,k) >= 0.0)) then
                      p_no3_assim_lpp_don = ergom%saved_rate_p_no3_assim_lpp_don(i,j,k)
                   endif
                   if ((p_nh4_assim_spp_don > 0.0) .and. (ergom%saved_rate_p_nh4_assim_spp_don(i,j,k) >= 0.0)) then
                      p_nh4_assim_spp_don = ergom%saved_rate_p_nh4_assim_spp_don(i,j,k)
                   endif
                   if ((p_no3_assim_spp_don > 0.0) .and. (ergom%saved_rate_p_no3_assim_spp_don(i,j,k) >= 0.0)) then
                      p_no3_assim_spp_don = ergom%saved_rate_p_no3_assim_spp_don(i,j,k)
                   endif
                   if ((p_poc_resp      > 0.0) .and. (ergom%saved_rate_p_poc_resp     (i,j,k) >= 0.0)) then
                      p_poc_resp      = ergom%saved_rate_p_poc_resp     (i,j,k)
                   endif
                   if ((p_poc_denit     > 0.0) .and. (ergom%saved_rate_p_poc_denit    (i,j,k) >= 0.0)) then
                      p_poc_denit     = ergom%saved_rate_p_poc_denit    (i,j,k)
                   endif
                   if ((p_poc_sulf      > 0.0) .and. (ergom%saved_rate_p_poc_sulf     (i,j,k) >= 0.0)) then
                      p_poc_sulf      = ergom%saved_rate_p_poc_sulf     (i,j,k)
                   endif
                   if ((p_pocp_resp     > 0.0) .and. (ergom%saved_rate_p_pocp_resp    (i,j,k) >= 0.0)) then
                      p_pocp_resp     = ergom%saved_rate_p_pocp_resp    (i,j,k)
                   endif
                   if ((p_pocp_denit    > 0.0) .and. (ergom%saved_rate_p_pocp_denit   (i,j,k) >= 0.0)) then
                      p_pocp_denit    = ergom%saved_rate_p_pocp_denit   (i,j,k)
                   endif
                   if ((p_pocp_sulf     > 0.0) .and. (ergom%saved_rate_p_pocp_sulf    (i,j,k) >= 0.0)) then
                      p_pocp_sulf     = ergom%saved_rate_p_pocp_sulf    (i,j,k)
                   endif
                   if ((p_pocn_resp     > 0.0) .and. (ergom%saved_rate_p_pocn_resp    (i,j,k) >= 0.0)) then
                      p_pocn_resp     = ergom%saved_rate_p_pocn_resp    (i,j,k)
                   endif
                   if ((p_pocn_denit_noN2 > 0.0) .and. (ergom%saved_rate_p_pocn_denit_noN2(i,j,k) >= 0.0)) then
                      p_pocn_denit_noN2 = ergom%saved_rate_p_pocn_denit_noN2(i,j,k)
                   endif
                   if ((p_pocn_denit_wiN2 > 0.0) .and. (ergom%saved_rate_p_pocn_denit_wiN2(i,j,k) >= 0.0)) then
                      p_pocn_denit_wiN2 = ergom%saved_rate_p_pocn_denit_wiN2(i,j,k)
                   endif
                   if ((p_pocn_sulf     > 0.0) .and. (ergom%saved_rate_p_pocn_sulf    (i,j,k) >= 0.0)) then
                      p_pocn_sulf     = ergom%saved_rate_p_pocn_sulf    (i,j,k)
                   endif
                   if ((p_lpp_graz_zoo  > 0.0) .and. (ergom%saved_rate_p_lpp_graz_zoo (i,j,k) >= 0.0)) then
                      p_lpp_graz_zoo  = ergom%saved_rate_p_lpp_graz_zoo (i,j,k)
                   endif
                   if ((p_spp_graz_zoo  > 0.0) .and. (ergom%saved_rate_p_spp_graz_zoo (i,j,k) >= 0.0)) then
                      p_spp_graz_zoo  = ergom%saved_rate_p_spp_graz_zoo (i,j,k)
                   endif
                   if ((p_cya_graz_zoo  > 0.0) .and. (ergom%saved_rate_p_cya_graz_zoo (i,j,k) >= 0.0)) then
                      p_cya_graz_zoo  = ergom%saved_rate_p_cya_graz_zoo (i,j,k)
                   endif
                   if ((p_lpp_resp_nh4  > 0.0) .and. (ergom%saved_rate_p_lpp_resp_nh4 (i,j,k) >= 0.0)) then
                      p_lpp_resp_nh4  = ergom%saved_rate_p_lpp_resp_nh4 (i,j,k)
                   endif
                   if ((p_spp_resp_nh4  > 0.0) .and. (ergom%saved_rate_p_spp_resp_nh4 (i,j,k) >= 0.0)) then
                      p_spp_resp_nh4  = ergom%saved_rate_p_spp_resp_nh4 (i,j,k)
                   endif
                   if ((p_cya_resp_nh4  > 0.0) .and. (ergom%saved_rate_p_cya_resp_nh4 (i,j,k) >= 0.0)) then
                      p_cya_resp_nh4  = ergom%saved_rate_p_cya_resp_nh4 (i,j,k)
                   endif
                   if ((p_zoo_resp_nh4  > 0.0) .and. (ergom%saved_rate_p_zoo_resp_nh4 (i,j,k) >= 0.0)) then
                      p_zoo_resp_nh4  = ergom%saved_rate_p_zoo_resp_nh4 (i,j,k)
                   endif
                   if ((p_lpp_mort_det  > 0.0) .and. (ergom%saved_rate_p_lpp_mort_det (i,j,k) >= 0.0)) then
                      p_lpp_mort_det  = ergom%saved_rate_p_lpp_mort_det (i,j,k)
                   endif
                   if ((p_spp_mort_det  > 0.0) .and. (ergom%saved_rate_p_spp_mort_det (i,j,k) >= 0.0)) then
                      p_spp_mort_det  = ergom%saved_rate_p_spp_mort_det (i,j,k)
                   endif
                   if ((p_cya_mort_det  > 0.0) .and. (ergom%saved_rate_p_cya_mort_det (i,j,k) >= 0.0)) then
                      p_cya_mort_det  = ergom%saved_rate_p_cya_mort_det (i,j,k)
                   endif
                   if ((p_cya_mort_det_diff > 0.0) .and. (ergom%saved_rate_p_cya_mort_det_diff(i,j,k) >= 0.0)) then
                      p_cya_mort_det_diff = ergom%saved_rate_p_cya_mort_det_diff(i,j,k)
                   endif
                   if ((p_zoo_mort_det  > 0.0) .and. (ergom%saved_rate_p_zoo_mort_det (i,j,k) >= 0.0)) then
                      p_zoo_mort_det  = ergom%saved_rate_p_zoo_mort_det (i,j,k)
                   endif
                   if ((p_nh4_nit_no3   > 0.0) .and. (ergom%saved_rate_p_nh4_nit_no3  (i,j,k) >= 0.0)) then
                      p_nh4_nit_no3   = ergom%saved_rate_p_nh4_nit_no3  (i,j,k)
                   endif
                   if ((p_det_resp_nh4  > 0.0) .and. (ergom%saved_rate_p_det_resp_nh4 (i,j,k) >= 0.0)) then
                      p_det_resp_nh4  = ergom%saved_rate_p_det_resp_nh4 (i,j,k)
                   endif
                   if ((p_det_denit_nh4 > 0.0) .and. (ergom%saved_rate_p_det_denit_nh4(i,j,k) >= 0.0)) then
                      p_det_denit_nh4 = ergom%saved_rate_p_det_denit_nh4(i,j,k)
                   endif
                   if ((p_det_sulf_nh4  > 0.0) .and. (ergom%saved_rate_p_det_sulf_nh4 (i,j,k) >= 0.0)) then
                      p_det_sulf_nh4  = ergom%saved_rate_p_det_sulf_nh4 (i,j,k)
                   endif
                   if ((p_h2s_oxo2_sul  > 0.0) .and. (ergom%saved_rate_p_h2s_oxo2_sul (i,j,k) >= 0.0)) then
                      p_h2s_oxo2_sul  = ergom%saved_rate_p_h2s_oxo2_sul (i,j,k)
                   endif
                   if ((p_h2s_oxno3_sul > 0.0) .and. (ergom%saved_rate_p_h2s_oxno3_sul(i,j,k) >= 0.0)) then
                      p_h2s_oxno3_sul = ergom%saved_rate_p_h2s_oxno3_sul(i,j,k)
                   endif
                   if ((p_sul_oxo2_so4  > 0.0) .and. (ergom%saved_rate_p_sul_oxo2_so4 (i,j,k) >= 0.0)) then
                      p_sul_oxo2_so4  = ergom%saved_rate_p_sul_oxo2_so4 (i,j,k)
                   endif
                   if ((p_sul_oxno3_so4 > 0.0) .and. (ergom%saved_rate_p_sul_oxno3_so4(i,j,k) >= 0.0)) then
                      p_sul_oxno3_so4 = ergom%saved_rate_p_sul_oxno3_so4(i,j,k)
                   endif
                   if ((p_doc2pco       > 0.0) .and. (ergom%saved_rate_p_doc2pco      (i,j,k) >= 0.0)) then
                      p_doc2pco       = ergom%saved_rate_p_doc2pco      (i,j,k)
                   endif
                   if ((p_dop2pocp      > 0.0) .and. (ergom%saved_rate_p_dop2pocp     (i,j,k) >= 0.0)) then
                      p_dop2pocp      = ergom%saved_rate_p_dop2pocp     (i,j,k)
                   endif
                   if ((p_don2pocn      > 0.0) .and. (ergom%saved_rate_p_don2pocn     (i,j,k) >= 0.0)) then
                      p_don2pocn      = ergom%saved_rate_p_don2pocn     (i,j,k)
                   endif
                   if ((p_doc_resp      > 0.0) .and. (ergom%saved_rate_p_doc_resp     (i,j,k) >= 0.0)) then
                      p_doc_resp      = ergom%saved_rate_p_doc_resp     (i,j,k)
                   endif
                   if ((p_doc_denit     > 0.0) .and. (ergom%saved_rate_p_doc_denit    (i,j,k) >= 0.0)) then
                      p_doc_denit     = ergom%saved_rate_p_doc_denit    (i,j,k)
                   endif
                   if ((p_doc_sulf      > 0.0) .and. (ergom%saved_rate_p_doc_sulf     (i,j,k) >= 0.0)) then
                      p_doc_sulf      = ergom%saved_rate_p_doc_sulf     (i,j,k)
                   endif
                   if ((p_dop_resp      > 0.0) .and. (ergom%saved_rate_p_dop_resp     (i,j,k) >= 0.0)) then
                      p_dop_resp      = ergom%saved_rate_p_dop_resp     (i,j,k)
                   endif
                   if ((p_dop_denit     > 0.0) .and. (ergom%saved_rate_p_dop_denit    (i,j,k) >= 0.0)) then
                      p_dop_denit     = ergom%saved_rate_p_dop_denit    (i,j,k)
                   endif
                   if ((p_dop_sulf      > 0.0) .and. (ergom%saved_rate_p_dop_sulf     (i,j,k) >= 0.0)) then
                      p_dop_sulf      = ergom%saved_rate_p_dop_sulf     (i,j,k)
                   endif
                   if ((p_don_resp      > 0.0) .and. (ergom%saved_rate_p_don_resp     (i,j,k) >= 0.0)) then
                      p_don_resp      = ergom%saved_rate_p_don_resp     (i,j,k)
                   endif
                   if ((p_don_denit_noN2 > 0.0) .and. (ergom%saved_rate_p_don_denit_noN2(i,j,k) >= 0.0)) then
                      p_don_denit_noN2 = ergom%saved_rate_p_don_denit_noN2(i,j,k)
                   endif
                   if ((p_don_denit_wiN2 > 0.0) .and. (ergom%saved_rate_p_don_denit_wiN2(i,j,k) >= 0.0)) then
                      p_don_denit_wiN2 = ergom%saved_rate_p_don_denit_wiN2(i,j,k)
                   endif
                   if ((p_don_sulf      > 0.0) .and. (ergom%saved_rate_p_don_sulf     (i,j,k) >= 0.0)) then
                      p_don_sulf      = ergom%saved_rate_p_don_sulf     (i,j,k)
                   endif
                   if ((p_no3_assim_lpp_atmos_tot_N > 0.0) .and. (ergom%saved_rate_p_no3_assim_lpp_atmos_tot_N(i,j,k) >= 0.0)) then
                      p_no3_assim_lpp_atmos_tot_N = ergom%saved_rate_p_no3_assim_lpp_atmos_tot_N(i,j,k)
                   endif
                   if ((p_nh4_assim_lpp_atmos_tot_N > 0.0) .and. (ergom%saved_rate_p_nh4_assim_lpp_atmos_tot_N(i,j,k) >= 0.0)) then
                      p_nh4_assim_lpp_atmos_tot_N = ergom%saved_rate_p_nh4_assim_lpp_atmos_tot_N(i,j,k)
                   endif
                   if ((p_no3_assim_spp_atmos_tot_N > 0.0) .and. (ergom%saved_rate_p_no3_assim_spp_atmos_tot_N(i,j,k) >= 0.0)) then
                      p_no3_assim_spp_atmos_tot_N = ergom%saved_rate_p_no3_assim_spp_atmos_tot_N(i,j,k)
                   endif
                   if ((p_nh4_assim_spp_atmos_tot_N > 0.0) .and. (ergom%saved_rate_p_nh4_assim_spp_atmos_tot_N(i,j,k) >= 0.0)) then
                      p_nh4_assim_spp_atmos_tot_N = ergom%saved_rate_p_nh4_assim_spp_atmos_tot_N(i,j,k)
                   endif
                   if ((p_nh4_assim_lpp_don_atmos_tot_N > 0.0) .and. (ergom%saved_rate_p_nh4_assim_lpp_don_atmos_tot_N(i,j,k) >= 0.0)) then
                      p_nh4_assim_lpp_don_atmos_tot_N = ergom%saved_rate_p_nh4_assim_lpp_don_atmos_tot_N(i,j,k)
                   endif
                   if ((p_no3_assim_lpp_don_atmos_tot_N > 0.0) .and. (ergom%saved_rate_p_no3_assim_lpp_don_atmos_tot_N(i,j,k) >= 0.0)) then
                      p_no3_assim_lpp_don_atmos_tot_N = ergom%saved_rate_p_no3_assim_lpp_don_atmos_tot_N(i,j,k)
                   endif
                   if ((p_nh4_assim_spp_don_atmos_tot_N > 0.0) .and. (ergom%saved_rate_p_nh4_assim_spp_don_atmos_tot_N(i,j,k) >= 0.0)) then
                      p_nh4_assim_spp_don_atmos_tot_N = ergom%saved_rate_p_nh4_assim_spp_don_atmos_tot_N(i,j,k)
                   endif
                   if ((p_no3_assim_spp_don_atmos_tot_N > 0.0) .and. (ergom%saved_rate_p_no3_assim_spp_don_atmos_tot_N(i,j,k) >= 0.0)) then
                      p_no3_assim_spp_don_atmos_tot_N = ergom%saved_rate_p_no3_assim_spp_don_atmos_tot_N(i,j,k)
                   endif
                   if ((p_pocn_resp_atmos_tot_N > 0.0) .and. (ergom%saved_rate_p_pocn_resp_atmos_tot_N(i,j,k) >= 0.0)) then
                      p_pocn_resp_atmos_tot_N = ergom%saved_rate_p_pocn_resp_atmos_tot_N(i,j,k)
                   endif
                   if ((p_pocn_denit_noN2_atmos_tot_N > 0.0) .and. (ergom%saved_rate_p_pocn_denit_noN2_atmos_tot_N(i,j,k) >= 0.0)) then
                      p_pocn_denit_noN2_atmos_tot_N = ergom%saved_rate_p_pocn_denit_noN2_atmos_tot_N(i,j,k)
                   endif
                   if ((p_pocn_sulf_atmos_tot_N > 0.0) .and. (ergom%saved_rate_p_pocn_sulf_atmos_tot_N(i,j,k) >= 0.0)) then
                      p_pocn_sulf_atmos_tot_N = ergom%saved_rate_p_pocn_sulf_atmos_tot_N(i,j,k)
                   endif
                   if ((p_lpp_graz_zoo_atmos_tot_N > 0.0) .and. (ergom%saved_rate_p_lpp_graz_zoo_atmos_tot_N(i,j,k) >= 0.0)) then
                      p_lpp_graz_zoo_atmos_tot_N = ergom%saved_rate_p_lpp_graz_zoo_atmos_tot_N(i,j,k)
                   endif
                   if ((p_spp_graz_zoo_atmos_tot_N > 0.0) .and. (ergom%saved_rate_p_spp_graz_zoo_atmos_tot_N(i,j,k) >= 0.0)) then
                      p_spp_graz_zoo_atmos_tot_N = ergom%saved_rate_p_spp_graz_zoo_atmos_tot_N(i,j,k)
                   endif
                   if ((p_cya_graz_zoo_atmos_tot_N > 0.0) .and. (ergom%saved_rate_p_cya_graz_zoo_atmos_tot_N(i,j,k) >= 0.0)) then
                      p_cya_graz_zoo_atmos_tot_N = ergom%saved_rate_p_cya_graz_zoo_atmos_tot_N(i,j,k)
                   endif
                   if ((p_lpp_resp_nh4_atmos_tot_N > 0.0) .and. (ergom%saved_rate_p_lpp_resp_nh4_atmos_tot_N(i,j,k) >= 0.0)) then
                      p_lpp_resp_nh4_atmos_tot_N = ergom%saved_rate_p_lpp_resp_nh4_atmos_tot_N(i,j,k)
                   endif
                   if ((p_spp_resp_nh4_atmos_tot_N > 0.0) .and. (ergom%saved_rate_p_spp_resp_nh4_atmos_tot_N(i,j,k) >= 0.0)) then
                      p_spp_resp_nh4_atmos_tot_N = ergom%saved_rate_p_spp_resp_nh4_atmos_tot_N(i,j,k)
                   endif
                   if ((p_cya_resp_nh4_atmos_tot_N > 0.0) .and. (ergom%saved_rate_p_cya_resp_nh4_atmos_tot_N(i,j,k) >= 0.0)) then
                      p_cya_resp_nh4_atmos_tot_N = ergom%saved_rate_p_cya_resp_nh4_atmos_tot_N(i,j,k)
                   endif
                   if ((p_zoo_resp_nh4_atmos_tot_N > 0.0) .and. (ergom%saved_rate_p_zoo_resp_nh4_atmos_tot_N(i,j,k) >= 0.0)) then
                      p_zoo_resp_nh4_atmos_tot_N = ergom%saved_rate_p_zoo_resp_nh4_atmos_tot_N(i,j,k)
                   endif
                   if ((p_lpp_mort_det_atmos_tot_N > 0.0) .and. (ergom%saved_rate_p_lpp_mort_det_atmos_tot_N(i,j,k) >= 0.0)) then
                      p_lpp_mort_det_atmos_tot_N = ergom%saved_rate_p_lpp_mort_det_atmos_tot_N(i,j,k)
                   endif
                   if ((p_spp_mort_det_atmos_tot_N > 0.0) .and. (ergom%saved_rate_p_spp_mort_det_atmos_tot_N(i,j,k) >= 0.0)) then
                      p_spp_mort_det_atmos_tot_N = ergom%saved_rate_p_spp_mort_det_atmos_tot_N(i,j,k)
                   endif
                   if ((p_cya_mort_det_atmos_tot_N > 0.0) .and. (ergom%saved_rate_p_cya_mort_det_atmos_tot_N(i,j,k) >= 0.0)) then
                      p_cya_mort_det_atmos_tot_N = ergom%saved_rate_p_cya_mort_det_atmos_tot_N(i,j,k)
                   endif
                   if ((p_cya_mort_det_diff_atmos_tot_N > 0.0) .and. (ergom%saved_rate_p_cya_mort_det_diff_atmos_tot_N(i,j,k) >= 0.0)) then
                      p_cya_mort_det_diff_atmos_tot_N = ergom%saved_rate_p_cya_mort_det_diff_atmos_tot_N(i,j,k)
                   endif
                   if ((p_zoo_mort_det_atmos_tot_N > 0.0) .and. (ergom%saved_rate_p_zoo_mort_det_atmos_tot_N(i,j,k) >= 0.0)) then
                      p_zoo_mort_det_atmos_tot_N = ergom%saved_rate_p_zoo_mort_det_atmos_tot_N(i,j,k)
                   endif
                   if ((p_nh4_nit_no3_atmos_tot_N > 0.0) .and. (ergom%saved_rate_p_nh4_nit_no3_atmos_tot_N(i,j,k) >= 0.0)) then
                      p_nh4_nit_no3_atmos_tot_N = ergom%saved_rate_p_nh4_nit_no3_atmos_tot_N(i,j,k)
                   endif
                   if ((p_det_resp_nh4_atmos_tot_N > 0.0) .and. (ergom%saved_rate_p_det_resp_nh4_atmos_tot_N(i,j,k) >= 0.0)) then
                      p_det_resp_nh4_atmos_tot_N = ergom%saved_rate_p_det_resp_nh4_atmos_tot_N(i,j,k)
                   endif
                   if ((p_det_sulf_nh4_atmos_tot_N > 0.0) .and. (ergom%saved_rate_p_det_sulf_nh4_atmos_tot_N(i,j,k) >= 0.0)) then
                      p_det_sulf_nh4_atmos_tot_N = ergom%saved_rate_p_det_sulf_nh4_atmos_tot_N(i,j,k)
                   endif
                   if ((p_don2pocn_atmos_tot_N > 0.0) .and. (ergom%saved_rate_p_don2pocn_atmos_tot_N(i,j,k) >= 0.0)) then
                      p_don2pocn_atmos_tot_N = ergom%saved_rate_p_don2pocn_atmos_tot_N(i,j,k)
                   endif
                   if ((p_don_resp_atmos_tot_N > 0.0) .and. (ergom%saved_rate_p_don_resp_atmos_tot_N(i,j,k) >= 0.0)) then
                      p_don_resp_atmos_tot_N = ergom%saved_rate_p_don_resp_atmos_tot_N(i,j,k)
                   endif
                   if ((p_don_denit_noN2_atmos_tot_N > 0.0) .and. (ergom%saved_rate_p_don_denit_noN2_atmos_tot_N(i,j,k) >= 0.0)) then
                      p_don_denit_noN2_atmos_tot_N = ergom%saved_rate_p_don_denit_noN2_atmos_tot_N(i,j,k)
                   endif
                   if ((p_don_sulf_atmos_tot_N > 0.0) .and. (ergom%saved_rate_p_don_sulf_atmos_tot_N(i,j,k) >= 0.0)) then
                      p_don_sulf_atmos_tot_N = ergom%saved_rate_p_don_sulf_atmos_tot_N(i,j,k)
                   endif
                   if ((p_no3_assim_lpp_atmos_ship_N > 0.0) .and. (ergom%saved_rate_p_no3_assim_lpp_atmos_ship_N(i,j,k) >= 0.0)) then
                      p_no3_assim_lpp_atmos_ship_N = ergom%saved_rate_p_no3_assim_lpp_atmos_ship_N(i,j,k)
                   endif
                   if ((p_nh4_assim_lpp_atmos_ship_N > 0.0) .and. (ergom%saved_rate_p_nh4_assim_lpp_atmos_ship_N(i,j,k) >= 0.0)) then
                      p_nh4_assim_lpp_atmos_ship_N = ergom%saved_rate_p_nh4_assim_lpp_atmos_ship_N(i,j,k)
                   endif
                   if ((p_no3_assim_spp_atmos_ship_N > 0.0) .and. (ergom%saved_rate_p_no3_assim_spp_atmos_ship_N(i,j,k) >= 0.0)) then
                      p_no3_assim_spp_atmos_ship_N = ergom%saved_rate_p_no3_assim_spp_atmos_ship_N(i,j,k)
                   endif
                   if ((p_nh4_assim_spp_atmos_ship_N > 0.0) .and. (ergom%saved_rate_p_nh4_assim_spp_atmos_ship_N(i,j,k) >= 0.0)) then
                      p_nh4_assim_spp_atmos_ship_N = ergom%saved_rate_p_nh4_assim_spp_atmos_ship_N(i,j,k)
                   endif
                   if ((p_nh4_assim_lpp_don_atmos_ship_N > 0.0) .and. (ergom%saved_rate_p_nh4_assim_lpp_don_atmos_ship_N(i,j,k) >= 0.0)) then
                      p_nh4_assim_lpp_don_atmos_ship_N = ergom%saved_rate_p_nh4_assim_lpp_don_atmos_ship_N(i,j,k)
                   endif
                   if ((p_no3_assim_lpp_don_atmos_ship_N > 0.0) .and. (ergom%saved_rate_p_no3_assim_lpp_don_atmos_ship_N(i,j,k) >= 0.0)) then
                      p_no3_assim_lpp_don_atmos_ship_N = ergom%saved_rate_p_no3_assim_lpp_don_atmos_ship_N(i,j,k)
                   endif
                   if ((p_nh4_assim_spp_don_atmos_ship_N > 0.0) .and. (ergom%saved_rate_p_nh4_assim_spp_don_atmos_ship_N(i,j,k) >= 0.0)) then
                      p_nh4_assim_spp_don_atmos_ship_N = ergom%saved_rate_p_nh4_assim_spp_don_atmos_ship_N(i,j,k)
                   endif
                   if ((p_no3_assim_spp_don_atmos_ship_N > 0.0) .and. (ergom%saved_rate_p_no3_assim_spp_don_atmos_ship_N(i,j,k) >= 0.0)) then
                      p_no3_assim_spp_don_atmos_ship_N = ergom%saved_rate_p_no3_assim_spp_don_atmos_ship_N(i,j,k)
                   endif
                   if ((p_pocn_resp_atmos_ship_N > 0.0) .and. (ergom%saved_rate_p_pocn_resp_atmos_ship_N(i,j,k) >= 0.0)) then
                      p_pocn_resp_atmos_ship_N = ergom%saved_rate_p_pocn_resp_atmos_ship_N(i,j,k)
                   endif
                   if ((p_pocn_denit_noN2_atmos_ship_N > 0.0) .and. (ergom%saved_rate_p_pocn_denit_noN2_atmos_ship_N(i,j,k) >= 0.0)) then
                      p_pocn_denit_noN2_atmos_ship_N = ergom%saved_rate_p_pocn_denit_noN2_atmos_ship_N(i,j,k)
                   endif
                   if ((p_pocn_sulf_atmos_ship_N > 0.0) .and. (ergom%saved_rate_p_pocn_sulf_atmos_ship_N(i,j,k) >= 0.0)) then
                      p_pocn_sulf_atmos_ship_N = ergom%saved_rate_p_pocn_sulf_atmos_ship_N(i,j,k)
                   endif
                   if ((p_lpp_graz_zoo_atmos_ship_N > 0.0) .and. (ergom%saved_rate_p_lpp_graz_zoo_atmos_ship_N(i,j,k) >= 0.0)) then
                      p_lpp_graz_zoo_atmos_ship_N = ergom%saved_rate_p_lpp_graz_zoo_atmos_ship_N(i,j,k)
                   endif
                   if ((p_spp_graz_zoo_atmos_ship_N > 0.0) .and. (ergom%saved_rate_p_spp_graz_zoo_atmos_ship_N(i,j,k) >= 0.0)) then
                      p_spp_graz_zoo_atmos_ship_N = ergom%saved_rate_p_spp_graz_zoo_atmos_ship_N(i,j,k)
                   endif
                   if ((p_cya_graz_zoo_atmos_ship_N > 0.0) .and. (ergom%saved_rate_p_cya_graz_zoo_atmos_ship_N(i,j,k) >= 0.0)) then
                      p_cya_graz_zoo_atmos_ship_N = ergom%saved_rate_p_cya_graz_zoo_atmos_ship_N(i,j,k)
                   endif
                   if ((p_lpp_resp_nh4_atmos_ship_N > 0.0) .and. (ergom%saved_rate_p_lpp_resp_nh4_atmos_ship_N(i,j,k) >= 0.0)) then
                      p_lpp_resp_nh4_atmos_ship_N = ergom%saved_rate_p_lpp_resp_nh4_atmos_ship_N(i,j,k)
                   endif
                   if ((p_spp_resp_nh4_atmos_ship_N > 0.0) .and. (ergom%saved_rate_p_spp_resp_nh4_atmos_ship_N(i,j,k) >= 0.0)) then
                      p_spp_resp_nh4_atmos_ship_N = ergom%saved_rate_p_spp_resp_nh4_atmos_ship_N(i,j,k)
                   endif
                   if ((p_cya_resp_nh4_atmos_ship_N > 0.0) .and. (ergom%saved_rate_p_cya_resp_nh4_atmos_ship_N(i,j,k) >= 0.0)) then
                      p_cya_resp_nh4_atmos_ship_N = ergom%saved_rate_p_cya_resp_nh4_atmos_ship_N(i,j,k)
                   endif
                   if ((p_zoo_resp_nh4_atmos_ship_N > 0.0) .and. (ergom%saved_rate_p_zoo_resp_nh4_atmos_ship_N(i,j,k) >= 0.0)) then
                      p_zoo_resp_nh4_atmos_ship_N = ergom%saved_rate_p_zoo_resp_nh4_atmos_ship_N(i,j,k)
                   endif
                   if ((p_lpp_mort_det_atmos_ship_N > 0.0) .and. (ergom%saved_rate_p_lpp_mort_det_atmos_ship_N(i,j,k) >= 0.0)) then
                      p_lpp_mort_det_atmos_ship_N = ergom%saved_rate_p_lpp_mort_det_atmos_ship_N(i,j,k)
                   endif
                   if ((p_spp_mort_det_atmos_ship_N > 0.0) .and. (ergom%saved_rate_p_spp_mort_det_atmos_ship_N(i,j,k) >= 0.0)) then
                      p_spp_mort_det_atmos_ship_N = ergom%saved_rate_p_spp_mort_det_atmos_ship_N(i,j,k)
                   endif
                   if ((p_cya_mort_det_atmos_ship_N > 0.0) .and. (ergom%saved_rate_p_cya_mort_det_atmos_ship_N(i,j,k) >= 0.0)) then
                      p_cya_mort_det_atmos_ship_N = ergom%saved_rate_p_cya_mort_det_atmos_ship_N(i,j,k)
                   endif
                   if ((p_cya_mort_det_diff_atmos_ship_N > 0.0) .and. (ergom%saved_rate_p_cya_mort_det_diff_atmos_ship_N(i,j,k) >= 0.0)) then
                      p_cya_mort_det_diff_atmos_ship_N = ergom%saved_rate_p_cya_mort_det_diff_atmos_ship_N(i,j,k)
                   endif
                   if ((p_zoo_mort_det_atmos_ship_N > 0.0) .and. (ergom%saved_rate_p_zoo_mort_det_atmos_ship_N(i,j,k) >= 0.0)) then
                      p_zoo_mort_det_atmos_ship_N = ergom%saved_rate_p_zoo_mort_det_atmos_ship_N(i,j,k)
                   endif
                   if ((p_nh4_nit_no3_atmos_ship_N > 0.0) .and. (ergom%saved_rate_p_nh4_nit_no3_atmos_ship_N(i,j,k) >= 0.0)) then
                      p_nh4_nit_no3_atmos_ship_N = ergom%saved_rate_p_nh4_nit_no3_atmos_ship_N(i,j,k)
                   endif
                   if ((p_det_resp_nh4_atmos_ship_N > 0.0) .and. (ergom%saved_rate_p_det_resp_nh4_atmos_ship_N(i,j,k) >= 0.0)) then
                      p_det_resp_nh4_atmos_ship_N = ergom%saved_rate_p_det_resp_nh4_atmos_ship_N(i,j,k)
                   endif
                   if ((p_det_sulf_nh4_atmos_ship_N > 0.0) .and. (ergom%saved_rate_p_det_sulf_nh4_atmos_ship_N(i,j,k) >= 0.0)) then
                      p_det_sulf_nh4_atmos_ship_N = ergom%saved_rate_p_det_sulf_nh4_atmos_ship_N(i,j,k)
                   endif
                   if ((p_don2pocn_atmos_ship_N > 0.0) .and. (ergom%saved_rate_p_don2pocn_atmos_ship_N(i,j,k) >= 0.0)) then
                      p_don2pocn_atmos_ship_N = ergom%saved_rate_p_don2pocn_atmos_ship_N(i,j,k)
                   endif
                   if ((p_don_resp_atmos_ship_N > 0.0) .and. (ergom%saved_rate_p_don_resp_atmos_ship_N(i,j,k) >= 0.0)) then
                      p_don_resp_atmos_ship_N = ergom%saved_rate_p_don_resp_atmos_ship_N(i,j,k)
                   endif
                   if ((p_don_denit_noN2_atmos_ship_N > 0.0) .and. (ergom%saved_rate_p_don_denit_noN2_atmos_ship_N(i,j,k) >= 0.0)) then
                      p_don_denit_noN2_atmos_ship_N = ergom%saved_rate_p_don_denit_noN2_atmos_ship_N(i,j,k)
                   endif
                   if ((p_don_sulf_atmos_ship_N > 0.0) .and. (ergom%saved_rate_p_don_sulf_atmos_ship_N(i,j,k) >= 0.0)) then
                      p_don_sulf_atmos_ship_N = ergom%saved_rate_p_don_sulf_atmos_ship_N(i,j,k)
                   endif
                   if (k == grid_kmt(i,j)) then
                      if ((p_sed_resp_nh4  > 0.0) .and. (ergom%saved_rate_p_sed_resp_nh4 (i,j) >= 0.0)) then
                         p_sed_resp_nh4  = ergom%saved_rate_p_sed_resp_nh4 (i,j)
                      endif
                      if ((p_nh4_nitdenit_n2 > 0.0) .and. (ergom%saved_rate_p_nh4_nitdenit_n2(i,j) >= 0.0)) then
                         p_nh4_nitdenit_n2 = ergom%saved_rate_p_nh4_nitdenit_n2(i,j)
                      endif
                      if ((p_sed_denit_nh4_noN2 > 0.0) .and. (ergom%saved_rate_p_sed_denit_nh4_noN2(i,j) >= 0.0)) then
                         p_sed_denit_nh4_noN2 = ergom%saved_rate_p_sed_denit_nh4_noN2(i,j)
                      endif
                      if ((p_sed_denit_nh4_wiN2 > 0.0) .and. (ergom%saved_rate_p_sed_denit_nh4_wiN2(i,j) >= 0.0)) then
                         p_sed_denit_nh4_wiN2 = ergom%saved_rate_p_sed_denit_nh4_wiN2(i,j)
                      endif
                      if ((p_sed_sulf_nh4  > 0.0) .and. (ergom%saved_rate_p_sed_sulf_nh4 (i,j) >= 0.0)) then
                         p_sed_sulf_nh4  = ergom%saved_rate_p_sed_sulf_nh4 (i,j)
                      endif
                      if ((p_sed_poc_resp  > 0.0) .and. (ergom%saved_rate_p_sed_poc_resp (i,j) >= 0.0)) then
                         p_sed_poc_resp  = ergom%saved_rate_p_sed_poc_resp (i,j)
                      endif
                      if ((p_sed_poc_denit > 0.0) .and. (ergom%saved_rate_p_sed_poc_denit(i,j) >= 0.0)) then
                         p_sed_poc_denit = ergom%saved_rate_p_sed_poc_denit(i,j)
                      endif
                      if ((p_sed_poc_sulf  > 0.0) .and. (ergom%saved_rate_p_sed_poc_sulf (i,j) >= 0.0)) then
                         p_sed_poc_sulf  = ergom%saved_rate_p_sed_poc_sulf (i,j)
                      endif
                      if ((p_po4_retent_ips > 0.0) .and. (ergom%saved_rate_p_po4_retent_ips(i,j) >= 0.0)) then
                         p_po4_retent_ips = ergom%saved_rate_p_po4_retent_ips(i,j)
                      endif
                      if ((p_ips_liber_po4 > 0.0) .and. (ergom%saved_rate_p_ips_liber_po4(i,j) >= 0.0)) then
                         p_ips_liber_po4 = ergom%saved_rate_p_ips_liber_po4(i,j)
                      endif
                      if ((p_det_sedi_sed  > 0.0) .and. (ergom%saved_rate_p_det_sedi_sed (i,j) >= 0.0)) then
                         p_det_sedi_sed  = ergom%saved_rate_p_det_sedi_sed (i,j)
                      endif
                      if ((p_ipw_sedi_ips  > 0.0) .and. (ergom%saved_rate_p_ipw_sedi_ips (i,j) >= 0.0)) then
                         p_ipw_sedi_ips  = ergom%saved_rate_p_ipw_sedi_ips (i,j)
                      endif
                      if ((p_poc_sedi_sed  > 0.0) .and. (ergom%saved_rate_p_poc_sedi_sed (i,j) >= 0.0)) then
                         p_poc_sedi_sed  = ergom%saved_rate_p_poc_sedi_sed (i,j)
                      endif
                      if ((p_pocn_sedi_sed > 0.0) .and. (ergom%saved_rate_p_pocn_sedi_sed(i,j) >= 0.0)) then
                         p_pocn_sedi_sed = ergom%saved_rate_p_pocn_sedi_sed(i,j)
                      endif
                      if ((p_pocp_sedi_sed > 0.0) .and. (ergom%saved_rate_p_pocp_sedi_sed(i,j) >= 0.0)) then
                         p_pocp_sedi_sed = ergom%saved_rate_p_pocp_sedi_sed(i,j)
                      endif
                      if ((p_sed_ero_det   > 0.0) .and. (ergom%saved_rate_p_sed_ero_det  (i,j) >= 0.0)) then
                         p_sed_ero_det   = ergom%saved_rate_p_sed_ero_det  (i,j)
                      endif
                      if ((p_ips_ero_ipw   > 0.0) .and. (ergom%saved_rate_p_ips_ero_ipw  (i,j) >= 0.0)) then
                         p_ips_ero_ipw   = ergom%saved_rate_p_ips_ero_ipw  (i,j)
                      endif
                      if ((p_sed_ero_poc   > 0.0) .and. (ergom%saved_rate_p_sed_ero_poc  (i,j) >= 0.0)) then
                         p_sed_ero_poc   = ergom%saved_rate_p_sed_ero_poc  (i,j)
                      endif
                      if ((p_sed_ero_pocn  > 0.0) .and. (ergom%saved_rate_p_sed_ero_pocn (i,j) >= 0.0)) then
                         p_sed_ero_pocn  = ergom%saved_rate_p_sed_ero_pocn (i,j)
                      endif
                      if ((p_sed_ero_pocp  > 0.0) .and. (ergom%saved_rate_p_sed_ero_pocp (i,j) >= 0.0)) then
                         p_sed_ero_pocp  = ergom%saved_rate_p_sed_ero_pocp (i,j)
                      endif
                      if ((p_sed_biores_det > 0.0) .and. (ergom%saved_rate_p_sed_biores_det(i,j) >= 0.0)) then
                         p_sed_biores_det = ergom%saved_rate_p_sed_biores_det(i,j)
                      endif
                      if ((p_ips_biores_ipw > 0.0) .and. (ergom%saved_rate_p_ips_biores_ipw(i,j) >= 0.0)) then
                         p_ips_biores_ipw = ergom%saved_rate_p_ips_biores_ipw(i,j)
                      endif
                      if ((p_sed_biores_poc > 0.0) .and. (ergom%saved_rate_p_sed_biores_poc(i,j) >= 0.0)) then
                         p_sed_biores_poc = ergom%saved_rate_p_sed_biores_poc(i,j)
                      endif
                      if ((p_sed_biores_pocn > 0.0) .and. (ergom%saved_rate_p_sed_biores_pocn(i,j) >= 0.0)) then
                         p_sed_biores_pocn = ergom%saved_rate_p_sed_biores_pocn(i,j)
                      endif
                      if ((p_sed_biores_pocp > 0.0) .and. (ergom%saved_rate_p_sed_biores_pocp(i,j) >= 0.0)) then
                         p_sed_biores_pocp = ergom%saved_rate_p_sed_biores_pocp(i,j)
                      endif
                      if ((p_sed_burial    > 0.0) .and. (ergom%saved_rate_p_sed_burial   (i,j) >= 0.0)) then
                         p_sed_burial    = ergom%saved_rate_p_sed_burial   (i,j)
                      endif
                      if ((p_ips_burial    > 0.0) .and. (ergom%saved_rate_p_ips_burial   (i,j) >= 0.0)) then
                         p_ips_burial    = ergom%saved_rate_p_ips_burial   (i,j)
                      endif
                      if ((p_poc_burial    > 0.0) .and. (ergom%saved_rate_p_poc_burial   (i,j) >= 0.0)) then
                         p_poc_burial    = ergom%saved_rate_p_poc_burial   (i,j)
                      endif
                      if ((p_pocn_burial   > 0.0) .and. (ergom%saved_rate_p_pocn_burial  (i,j) >= 0.0)) then
                         p_pocn_burial   = ergom%saved_rate_p_pocn_burial  (i,j)
                      endif
                      if ((p_pocp_burial   > 0.0) .and. (ergom%saved_rate_p_pocp_burial  (i,j) >= 0.0)) then
                         p_pocp_burial   = ergom%saved_rate_p_pocp_burial  (i,j)
                      endif
                      if ((p_sed_pocn_resp > 0.0) .and. (ergom%saved_rate_p_sed_pocn_resp(i,j) >= 0.0)) then
                         p_sed_pocn_resp = ergom%saved_rate_p_sed_pocn_resp(i,j)
                      endif
                      if ((p_sed_pocp_resp > 0.0) .and. (ergom%saved_rate_p_sed_pocp_resp(i,j) >= 0.0)) then
                         p_sed_pocp_resp = ergom%saved_rate_p_sed_pocp_resp(i,j)
                      endif
                      if ((p_sed_pocn_denit_noN2 > 0.0) .and. (ergom%saved_rate_p_sed_pocn_denit_noN2(i,j) >= 0.0)) then
                         p_sed_pocn_denit_noN2 = ergom%saved_rate_p_sed_pocn_denit_noN2(i,j)
                      endif
                      if ((p_sed_pocn_denit_wiN2 > 0.0) .and. (ergom%saved_rate_p_sed_pocn_denit_wiN2(i,j) >= 0.0)) then
                         p_sed_pocn_denit_wiN2 = ergom%saved_rate_p_sed_pocn_denit_wiN2(i,j)
                      endif
                      if ((p_sed_pocp_denit > 0.0) .and. (ergom%saved_rate_p_sed_pocp_denit(i,j) >= 0.0)) then
                         p_sed_pocp_denit = ergom%saved_rate_p_sed_pocp_denit(i,j)
                      endif
                      if ((p_sed_pocn_sulf > 0.0) .and. (ergom%saved_rate_p_sed_pocn_sulf(i,j) >= 0.0)) then
                         p_sed_pocn_sulf = ergom%saved_rate_p_sed_pocn_sulf(i,j)
                      endif
                      if ((p_sed_pocp_sulf > 0.0) .and. (ergom%saved_rate_p_sed_pocp_sulf(i,j) >= 0.0)) then
                         p_sed_pocp_sulf = ergom%saved_rate_p_sed_pocp_sulf(i,j)
                      endif
                      if ((p_nh4_nitdenit_pocn_n2 > 0.0) .and. (ergom%saved_rate_p_nh4_nitdenit_pocn_n2(i,j) >= 0.0)) then
                         p_nh4_nitdenit_pocn_n2 = ergom%saved_rate_p_nh4_nitdenit_pocn_n2(i,j)
                      endif
                      if ((p_sed_resp_nh4_atmos_tot_N > 0.0) .and. (ergom%saved_rate_p_sed_resp_nh4_atmos_tot_N(i,j) >= 0.0)) then
                         p_sed_resp_nh4_atmos_tot_N = ergom%saved_rate_p_sed_resp_nh4_atmos_tot_N(i,j)
                      endif
                      if ((p_sed_denit_nh4_noN2_atmos_tot_N > 0.0) .and. (ergom%saved_rate_p_sed_denit_nh4_noN2_atmos_tot_N(i,j) >= 0.0)) then
                         p_sed_denit_nh4_noN2_atmos_tot_N = ergom%saved_rate_p_sed_denit_nh4_noN2_atmos_tot_N(i,j)
                      endif
                      if ((p_sed_sulf_nh4_atmos_tot_N > 0.0) .and. (ergom%saved_rate_p_sed_sulf_nh4_atmos_tot_N(i,j) >= 0.0)) then
                         p_sed_sulf_nh4_atmos_tot_N = ergom%saved_rate_p_sed_sulf_nh4_atmos_tot_N(i,j)
                      endif
                      if ((p_det_sedi_sed_atmos_tot_N > 0.0) .and. (ergom%saved_rate_p_det_sedi_sed_atmos_tot_N(i,j) >= 0.0)) then
                         p_det_sedi_sed_atmos_tot_N = ergom%saved_rate_p_det_sedi_sed_atmos_tot_N(i,j)
                      endif
                      if ((p_pocn_sedi_sed_atmos_tot_N > 0.0) .and. (ergom%saved_rate_p_pocn_sedi_sed_atmos_tot_N(i,j) >= 0.0)) then
                         p_pocn_sedi_sed_atmos_tot_N = ergom%saved_rate_p_pocn_sedi_sed_atmos_tot_N(i,j)
                      endif
                      if ((p_sed_ero_det_atmos_tot_N > 0.0) .and. (ergom%saved_rate_p_sed_ero_det_atmos_tot_N(i,j) >= 0.0)) then
                         p_sed_ero_det_atmos_tot_N = ergom%saved_rate_p_sed_ero_det_atmos_tot_N(i,j)
                      endif
                      if ((p_sed_ero_pocn_atmos_tot_N > 0.0) .and. (ergom%saved_rate_p_sed_ero_pocn_atmos_tot_N(i,j) >= 0.0)) then
                         p_sed_ero_pocn_atmos_tot_N = ergom%saved_rate_p_sed_ero_pocn_atmos_tot_N(i,j)
                      endif
                      if ((p_sed_biores_det_atmos_tot_N > 0.0) .and. (ergom%saved_rate_p_sed_biores_det_atmos_tot_N(i,j) >= 0.0)) then
                         p_sed_biores_det_atmos_tot_N = ergom%saved_rate_p_sed_biores_det_atmos_tot_N(i,j)
                      endif
                      if ((p_sed_biores_pocn_atmos_tot_N > 0.0) .and. (ergom%saved_rate_p_sed_biores_pocn_atmos_tot_N(i,j) >= 0.0)) then
                         p_sed_biores_pocn_atmos_tot_N = ergom%saved_rate_p_sed_biores_pocn_atmos_tot_N(i,j)
                      endif
                      if ((p_sed_burial_atmos_tot_N > 0.0) .and. (ergom%saved_rate_p_sed_burial_atmos_tot_N(i,j) >= 0.0)) then
                         p_sed_burial_atmos_tot_N = ergom%saved_rate_p_sed_burial_atmos_tot_N(i,j)
                      endif
                      if ((p_pocn_burial_atmos_tot_N > 0.0) .and. (ergom%saved_rate_p_pocn_burial_atmos_tot_N(i,j) >= 0.0)) then
                         p_pocn_burial_atmos_tot_N = ergom%saved_rate_p_pocn_burial_atmos_tot_N(i,j)
                      endif
                      if ((p_sed_pocn_resp_atmos_tot_N > 0.0) .and. (ergom%saved_rate_p_sed_pocn_resp_atmos_tot_N(i,j) >= 0.0)) then
                         p_sed_pocn_resp_atmos_tot_N = ergom%saved_rate_p_sed_pocn_resp_atmos_tot_N(i,j)
                      endif
                      if ((p_sed_pocn_denit_noN2_atmos_tot_N > 0.0) .and. (ergom%saved_rate_p_sed_pocn_denit_noN2_atmos_tot_N(i,j) >= 0.0)) then
                         p_sed_pocn_denit_noN2_atmos_tot_N = ergom%saved_rate_p_sed_pocn_denit_noN2_atmos_tot_N(i,j)
                      endif
                      if ((p_sed_pocn_sulf_atmos_tot_N > 0.0) .and. (ergom%saved_rate_p_sed_pocn_sulf_atmos_tot_N(i,j) >= 0.0)) then
                         p_sed_pocn_sulf_atmos_tot_N = ergom%saved_rate_p_sed_pocn_sulf_atmos_tot_N(i,j)
                      endif
                      if ((p_sed_resp_nh4_atmos_ship_N > 0.0) .and. (ergom%saved_rate_p_sed_resp_nh4_atmos_ship_N(i,j) >= 0.0)) then
                         p_sed_resp_nh4_atmos_ship_N = ergom%saved_rate_p_sed_resp_nh4_atmos_ship_N(i,j)
                      endif
                      if ((p_sed_denit_nh4_noN2_atmos_ship_N > 0.0) .and. (ergom%saved_rate_p_sed_denit_nh4_noN2_atmos_ship_N(i,j) >= 0.0)) then
                         p_sed_denit_nh4_noN2_atmos_ship_N = ergom%saved_rate_p_sed_denit_nh4_noN2_atmos_ship_N(i,j)
                      endif
                      if ((p_sed_sulf_nh4_atmos_ship_N > 0.0) .and. (ergom%saved_rate_p_sed_sulf_nh4_atmos_ship_N(i,j) >= 0.0)) then
                         p_sed_sulf_nh4_atmos_ship_N = ergom%saved_rate_p_sed_sulf_nh4_atmos_ship_N(i,j)
                      endif
                      if ((p_det_sedi_sed_atmos_ship_N > 0.0) .and. (ergom%saved_rate_p_det_sedi_sed_atmos_ship_N(i,j) >= 0.0)) then
                         p_det_sedi_sed_atmos_ship_N = ergom%saved_rate_p_det_sedi_sed_atmos_ship_N(i,j)
                      endif
                      if ((p_pocn_sedi_sed_atmos_ship_N > 0.0) .and. (ergom%saved_rate_p_pocn_sedi_sed_atmos_ship_N(i,j) >= 0.0)) then
                         p_pocn_sedi_sed_atmos_ship_N = ergom%saved_rate_p_pocn_sedi_sed_atmos_ship_N(i,j)
                      endif
                      if ((p_sed_ero_det_atmos_ship_N > 0.0) .and. (ergom%saved_rate_p_sed_ero_det_atmos_ship_N(i,j) >= 0.0)) then
                         p_sed_ero_det_atmos_ship_N = ergom%saved_rate_p_sed_ero_det_atmos_ship_N(i,j)
                      endif
                      if ((p_sed_ero_pocn_atmos_ship_N > 0.0) .and. (ergom%saved_rate_p_sed_ero_pocn_atmos_ship_N(i,j) >= 0.0)) then
                         p_sed_ero_pocn_atmos_ship_N = ergom%saved_rate_p_sed_ero_pocn_atmos_ship_N(i,j)
                      endif
                      if ((p_sed_biores_det_atmos_ship_N > 0.0) .and. (ergom%saved_rate_p_sed_biores_det_atmos_ship_N(i,j) >= 0.0)) then
                         p_sed_biores_det_atmos_ship_N = ergom%saved_rate_p_sed_biores_det_atmos_ship_N(i,j)
                      endif
                      if ((p_sed_biores_pocn_atmos_ship_N > 0.0) .and. (ergom%saved_rate_p_sed_biores_pocn_atmos_ship_N(i,j) >= 0.0)) then
                         p_sed_biores_pocn_atmos_ship_N = ergom%saved_rate_p_sed_biores_pocn_atmos_ship_N(i,j)
                      endif
                      if ((p_sed_burial_atmos_ship_N > 0.0) .and. (ergom%saved_rate_p_sed_burial_atmos_ship_N(i,j) >= 0.0)) then
                         p_sed_burial_atmos_ship_N = ergom%saved_rate_p_sed_burial_atmos_ship_N(i,j)
                      endif
                      if ((p_pocn_burial_atmos_ship_N > 0.0) .and. (ergom%saved_rate_p_pocn_burial_atmos_ship_N(i,j) >= 0.0)) then
                         p_pocn_burial_atmos_ship_N = ergom%saved_rate_p_pocn_burial_atmos_ship_N(i,j)
                      endif
                      if ((p_sed_pocn_resp_atmos_ship_N > 0.0) .and. (ergom%saved_rate_p_sed_pocn_resp_atmos_ship_N(i,j) >= 0.0)) then
                         p_sed_pocn_resp_atmos_ship_N = ergom%saved_rate_p_sed_pocn_resp_atmos_ship_N(i,j)
                      endif
                      if ((p_sed_pocn_denit_noN2_atmos_ship_N > 0.0) .and. (ergom%saved_rate_p_sed_pocn_denit_noN2_atmos_ship_N(i,j) >= 0.0)) then
                         p_sed_pocn_denit_noN2_atmos_ship_N = ergom%saved_rate_p_sed_pocn_denit_noN2_atmos_ship_N(i,j)
                      endif
                      if ((p_sed_pocn_sulf_atmos_ship_N > 0.0) .and. (ergom%saved_rate_p_sed_pocn_sulf_atmos_ship_N(i,j) >= 0.0)) then
                         p_sed_pocn_sulf_atmos_ship_N = ergom%saved_rate_p_sed_pocn_sulf_atmos_ship_N(i,j)
                      endif
                   endif
                   if (k == 1) then
                   endif
                endif

                !------------------------------------
                ! STEP 6.7.4: apply Patankar limitations
                !------------------------------------

                if (k == grid_kmt(i,j)) then
                endif
                if (k == 1) then
                endif

                if (k == grid_kmt(i,j)) then
                endif
                if (k == 1) then
                endif

                !------------------------------------
                ! STEP 6.7.5: calculate possible euler-forward change (in a full timestep)
                !------------------------------------
                change_of_t_n2            = 0.0
                change_of_t_o2            = 0.0
                change_of_t_dic           = 0.0
                change_of_t_nh4           = 0.0
                change_of_t_no3           = 0.0
                change_of_t_po4           = 0.0
                change_of_t_spp           = 0.0
                change_of_t_zoo           = 0.0
                change_of_t_h2s           = 0.0
                change_of_t_sul           = 0.0
                change_of_t_alk           = 0.0
                change_of_t_sed           = 0.0
                change_of_t_ips           = 0.0
                change_of_t_doc           = 0.0
                change_of_t_dop           = 0.0
                change_of_t_sed_poc       = 0.0
                change_of_t_sed_pocn      = 0.0
                change_of_t_sed_pocp      = 0.0
                change_of_total_atmos_tot_N = 0.0
                change_of_total_atmos_tot_N_at_bottom = 0.0
                change_of_total_atmos_ship_N = 0.0
                change_of_total_atmos_ship_N_at_bottom = 0.0
                change_of_t_n2_with_atmos_tot_N = 0.0
                change_of_t_nh4_with_atmos_tot_N = 0.0
                change_of_t_no3_with_atmos_tot_N = 0.0
                change_of_t_spp_with_atmos_tot_N = 0.0
                change_of_t_zoo_with_atmos_tot_N = 0.0
                change_of_t_sed_with_atmos_tot_N = 0.0
                change_of_t_sed_pocn_with_atmos_tot_N = 0.0
                change_of_t_n2_with_atmos_ship_N = 0.0
                change_of_t_nh4_with_atmos_ship_N = 0.0
                change_of_t_no3_with_atmos_ship_N = 0.0
                change_of_t_spp_with_atmos_ship_N = 0.0
                change_of_t_zoo_with_atmos_ship_N = 0.0
                change_of_t_sed_with_atmos_ship_N = 0.0
                change_of_t_sed_pocn_with_atmos_ship_N = 0.0
                change_of_t_ipw           = 0.0
                change_of_t_pocn_with_atmos_tot_N = 0.0
                change_of_t_lpp_with_atmos_tot_N = 0.0
                change_of_t_don_with_atmos_tot_N = 0.0
                change_of_t_cya_with_atmos_tot_N = 0.0
                change_of_t_det_with_atmos_tot_N = 0.0
                change_of_t_lpp           = 0.0
                change_of_t_don           = 0.0
                change_of_t_cya           = 0.0
                change_of_t_det           = 0.0
                change_of_t_poc           = 0.0
                change_of_t_pocp          = 0.0
                change_of_t_pocn          = 0.0
                change_of_t_pocn_with_atmos_ship_N = 0.0
                change_of_t_lpp_with_atmos_ship_N = 0.0
                change_of_t_don_with_atmos_ship_N = 0.0
                change_of_t_cya_with_atmos_ship_N = 0.0
                change_of_t_det_with_atmos_ship_N = 0.0
                if (implicit_bottomfluxes) then
                   change_btf_t_n2            = 0.0
                   change_btf_t_o2            = 0.0
                   change_btf_t_dic           = 0.0
                   change_btf_t_nh4           = 0.0
                   change_btf_t_no3           = 0.0
                   change_btf_t_po4           = 0.0
                   change_btf_t_spp           = 0.0
                   change_btf_t_zoo           = 0.0
                   change_btf_t_h2s           = 0.0
                   change_btf_t_sul           = 0.0
                   change_btf_t_alk           = 0.0
                   change_btf_t_doc           = 0.0
                   change_btf_t_dop           = 0.0
                   change_btf_total_atmos_tot_N = 0.0
                   change_btf_total_atmos_ship_N = 0.0
                   change_btf_t_n2_with_atmos_tot_N = 0.0
                   change_btf_t_nh4_with_atmos_tot_N = 0.0
                   change_btf_t_no3_with_atmos_tot_N = 0.0
                   change_btf_t_spp_with_atmos_tot_N = 0.0
                   change_btf_t_zoo_with_atmos_tot_N = 0.0
                   change_btf_t_n2_with_atmos_ship_N = 0.0
                   change_btf_t_nh4_with_atmos_ship_N = 0.0
                   change_btf_t_no3_with_atmos_ship_N = 0.0
                   change_btf_t_spp_with_atmos_ship_N = 0.0
                   change_btf_t_zoo_with_atmos_ship_N = 0.0
                   change_btf_t_ipw           = 0.0
                   change_btf_t_pocn_with_atmos_tot_N = 0.0
                   change_btf_t_lpp_with_atmos_tot_N = 0.0
                   change_btf_t_don_with_atmos_tot_N = 0.0
                   change_btf_t_cya_with_atmos_tot_N = 0.0
                   change_btf_t_det_with_atmos_tot_N = 0.0
                   change_btf_t_lpp           = 0.0
                   change_btf_t_don           = 0.0
                   change_btf_t_cya           = 0.0
                   change_btf_t_det           = 0.0
                   change_btf_t_poc           = 0.0
                   change_btf_t_pocp          = 0.0
                   change_btf_t_pocn          = 0.0
                   change_btf_t_pocn_with_atmos_ship_N = 0.0
                   change_btf_t_lpp_with_atmos_ship_N = 0.0
                   change_btf_t_don_with_atmos_ship_N = 0.0
                   change_btf_t_cya_with_atmos_ship_N = 0.0
                   change_btf_t_det_with_atmos_ship_N = 0.0
                endif



                change_of_t_n2            = change_of_t_n2            + cgt_timestep*(0.0 &
                   + (p_poc_denit)*(0.4)          & ! recycling of POC using nitrate (denitrification)
                   + (p_pocp_denit)*(42.4)        & ! recycling of POC using nitrate (denitrification)
                   + (p_pocn_denit_wiN2)*(2.65)   & ! recycling of POCN using nitrate (denitrification)
                   + (p_det_denit_nh4)*(2.65)     & ! recycling of detritus using nitrate (denitrification)
                   + (p_h2s_oxno3_sul)*(0.2)      & ! oxidation of hydrogen sulfide with nitrate
                   + (p_sul_oxno3_so4)*(0.6)      & ! oxidation of elemental sulfur with nitrate
                   + (p_doc_denit)*(0.4)          & ! recycling of DOC using nitrate (denitrification)
                   + (p_dop_denit)*(42.4)         & ! recycling of DOP using nitrate (denitrification)
                   + (p_don_denit_wiN2)*(2.65)    & ! recycling of DON using nitrate (denitrification)
                   - (p_n2_assim_cya)*(0.5)       & ! fixation of dinitrogen by diazotroph cyanobacteria
                )

                change_of_t_o2            = change_of_t_o2            + cgt_timestep*(0.0 &
                   + (p_no3_assim_lpp)*(8.625)    & ! assimilation of nitrate by large-cell phytoplankton
                   + (p_nh4_assim_lpp)*(6.625)    & ! assimilation of ammonium by large-cell phytoplankton
                   + (p_no3_assim_spp)*(8.625)    & ! assimilation of nitrate by small-cell phytoplankton
                   + (p_nh4_assim_spp)*(6.625)    & ! assimilation of ammonium by small-cell phytoplankton
                   + (p_n2_assim_cya)*(7.375)     & ! fixation of dinitrogen by diazotroph cyanobacteria
                   + p_assim_lpp_doc              & ! Production of DOC by LPP
                   + p_assim_spp_doc              & ! Production of DOC by SPP
                   + p_assim_cya_doc              & ! Production of POC by CYA
                   + (p_assim_lpp_dop)*(106)      & ! Production of DOP by LPP
                   + (p_assim_spp_dop)*(106)      & ! Production of DOP by SPP
                   + (p_nh4_assim_lpp_don)*(6.625) & ! Production of DON by LPP
                   + (p_no3_assim_lpp_don)*(8.625) & ! Production of DON by LPP
                   + (p_nh4_assim_spp_don)*(6.625) & ! Production of DON by SPP
                   + (p_no3_assim_spp_don)*(8.625) & ! Production of DON by SPP
                   - p_poc_resp                   & ! respiration of POC
                   - (p_pocp_resp)*(106)          & ! respiration of POCP
                   - (p_pocn_resp)*(6.625)        & ! respiration of POCN
                   - (p_lpp_resp_nh4)*(6.625)     & ! respiration of large-cell phytoplankton
                   - (p_spp_resp_nh4)*(6.625)     & ! respiration of small-cell phytoplankton
                   - (p_cya_resp_nh4)*(6.625)     & ! respiration of diazotroph cyanobacteria
                   - (p_zoo_resp_nh4)*(6.625)     & ! respiration of zooplankton
                   - (p_nh4_nit_no3)*(2)          & ! nitrification
                   - (p_det_resp_nh4)*(6.625)     & ! recycling of detritus using oxygen (respiration)
                   - (p_h2s_oxo2_sul)*(0.5)       & ! oxidation of hydrogen sulfide with oxygen
                   - (p_sul_oxo2_so4)*(1.5)       & ! oxidation of elemental sulfur with oxygen
                   - p_doc_resp                   & ! respiration of DOC
                   - (p_dop_resp)*(106)           & ! respiration of DOP
                   - (p_don_resp)*(6.625)         & ! respiration of DON
                )

                change_of_t_dic           = change_of_t_dic           + cgt_timestep*(0.0 &
                   + p_poc_resp                   & ! respiration of POC
                   + p_poc_denit                  & ! recycling of POC using nitrate (denitrification)
                   + p_poc_sulf                   & ! Mineralization of POC, e-acceptor sulfate (sulfate reduction)
                   + (p_pocp_resp)*(106)          & ! respiration of POCP
                   + (p_pocp_denit)*(106)         & ! recycling of POC using nitrate (denitrification)
                   + (p_pocp_sulf)*(106)          & ! Mineralization of POC, e-acceptor sulfate (sulfate reduction)
                   + (p_pocn_resp)*(6.625)        & ! respiration of POCN
                   + (p_pocn_denit_noN2)*(6.625)  & ! recycling of POCN using nitrate (denitrification)
                   + (p_pocn_sulf)*(6.625)        & ! Mineralization of POCN, e-acceptor sulfate (sulfate reduction)
                   + (p_lpp_resp_nh4)*(rfr_c)     & ! respiration of large-cell phytoplankton
                   + (p_spp_resp_nh4)*(rfr_c)     & ! respiration of small-cell phytoplankton
                   + (p_cya_resp_nh4)*(rfr_c)     & ! respiration of diazotroph cyanobacteria
                   + (p_zoo_resp_nh4)*(rfr_c)     & ! respiration of zooplankton
                   + (p_det_resp_nh4)*(rfr_c)     & ! recycling of detritus using oxygen (respiration)
                   + (p_det_denit_nh4)*(rfr_c)    & ! recycling of detritus using nitrate (denitrification)
                   + (p_det_sulf_nh4)*(rfr_c)     & ! recycling of detritus using sulfate (sulfate reduction)
                   + p_doc_resp                   & ! respiration of DOC
                   + p_doc_denit                  & ! recycling of DOC using nitrate (denitrification)
                   + p_doc_sulf                   & ! Mineralization of DOC, e-acceptor sulfate (sulfate reduction)
                   + (p_dop_resp)*(106)           & ! respiration of DOP
                   + (p_dop_denit)*(106)          & ! recycling of DOP using nitrate (denitrification)
                   + (p_dop_sulf)*(106)           & ! Mineralization of DOP, e-acceptor sulfate (sulfate reduction)
                   + (p_don_resp)*(6.625)         & ! respiration of DON
                   + (p_don_denit_noN2)*(6.625)   & ! recycling of DON using nitrate (denitrification)
                   + (p_don_sulf)*(6.625)         & ! Mineralization of DON, e-acceptor sulfate (sulfate reduction)
                   - (p_no3_assim_lpp)*(rfr_c)    & ! assimilation of nitrate by large-cell phytoplankton
                   - (p_nh4_assim_lpp)*(rfr_c)    & ! assimilation of ammonium by large-cell phytoplankton
                   - (p_no3_assim_spp)*(rfr_c)    & ! assimilation of nitrate by small-cell phytoplankton
                   - (p_nh4_assim_spp)*(rfr_c)    & ! assimilation of ammonium by small-cell phytoplankton
                   - (p_n2_assim_cya)*(rfr_c)     & ! fixation of dinitrogen by diazotroph cyanobacteria
                   - p_assim_lpp_doc              & ! Production of DOC by LPP
                   - p_assim_spp_doc              & ! Production of DOC by SPP
                   - p_assim_cya_doc              & ! Production of POC by CYA
                   - (p_assim_lpp_dop)*(106)      & ! Production of DOP by LPP
                   - (p_assim_spp_dop)*(106)      & ! Production of DOP by SPP
                   - (p_nh4_assim_lpp_don)*(6.625) & ! Production of DON by LPP
                   - (p_no3_assim_lpp_don)*(6.625) & ! Production of DON by LPP
                   - (p_nh4_assim_spp_don)*(6.625) & ! Production of DON by SPP
                   - (p_no3_assim_spp_don)*(6.625) & ! Production of DON by SPP
                )

                change_of_t_nh4           = change_of_t_nh4           + cgt_timestep*(0.0 &
                   + p_pocn_resp                  & ! respiration of POCN
                   + p_pocn_denit_noN2            & ! recycling of POCN using nitrate (denitrification)
                   + p_pocn_sulf                  & ! Mineralization of POCN, e-acceptor sulfate (sulfate reduction)
                   + (p_lpp_resp_nh4)*((1-don_fraction)) & ! respiration of large-cell phytoplankton
                   + (p_spp_resp_nh4)*((1-don_fraction)) & ! respiration of small-cell phytoplankton
                   + (p_cya_resp_nh4)*((1-don_fraction)) & ! respiration of diazotroph cyanobacteria
                   + (p_zoo_resp_nh4)*((1-don_fraction)) & ! respiration of zooplankton
                   + p_det_resp_nh4               & ! recycling of detritus using oxygen (respiration)
                   + p_det_denit_nh4              & ! recycling of detritus using nitrate (denitrification)
                   + p_det_sulf_nh4               & ! recycling of detritus using sulfate (sulfate reduction)
                   + p_don_resp                   & ! respiration of DON
                   + p_don_denit_noN2             & ! recycling of DON using nitrate (denitrification)
                   + p_don_sulf                   & ! Mineralization of DON, e-acceptor sulfate (sulfate reduction)
                   - p_nh4_assim_lpp              & ! assimilation of ammonium by large-cell phytoplankton
                   - p_nh4_assim_spp              & ! assimilation of ammonium by small-cell phytoplankton
                   - p_nh4_assim_lpp_don          & ! Production of DON by LPP
                   - p_nh4_assim_spp_don          & ! Production of DON by SPP
                   - p_nh4_nit_no3                & ! nitrification
                )

                change_of_t_no3           = change_of_t_no3           + cgt_timestep*(0.0 &
                   + p_nh4_nit_no3                & ! nitrification
                   - p_no3_assim_lpp              & ! assimilation of nitrate by large-cell phytoplankton
                   - p_no3_assim_spp              & ! assimilation of nitrate by small-cell phytoplankton
                   - p_no3_assim_lpp_don          & ! Production of DON by LPP
                   - p_no3_assim_spp_don          & ! Production of DON by SPP
                   - (p_poc_denit)*(0.8)          & ! recycling of POC using nitrate (denitrification)
                   - (p_pocp_denit)*(84.8)        & ! recycling of POC using nitrate (denitrification)
                   - (p_pocn_denit_wiN2)*(5.3)    & ! recycling of POCN using nitrate (denitrification)
                   - (p_det_denit_nh4)*(5.3)      & ! recycling of detritus using nitrate (denitrification)
                   - (p_h2s_oxno3_sul)*(0.4)      & ! oxidation of hydrogen sulfide with nitrate
                   - (p_sul_oxno3_so4)*(1.2)      & ! oxidation of elemental sulfur with nitrate
                   - (p_doc_denit)*(0.8)          & ! recycling of DOC using nitrate (denitrification)
                   - (p_dop_denit)*(84.8)         & ! recycling of DOP using nitrate (denitrification)
                   - (p_don_denit_wiN2)*(5.3)     & ! recycling of DON using nitrate (denitrification)
                )

                change_of_t_po4           = change_of_t_po4           + cgt_timestep*(0.0 &
                   + p_pocp_resp                  & ! respiration of POCP
                   + p_pocp_denit                 & ! recycling of POC using nitrate (denitrification)
                   + p_pocp_sulf                  & ! Mineralization of POC, e-acceptor sulfate (sulfate reduction)
                   + (p_lpp_resp_nh4)*(rfr_p)     & ! respiration of large-cell phytoplankton
                   + (p_spp_resp_nh4)*(rfr_p)     & ! respiration of small-cell phytoplankton
                   + (p_cya_resp_nh4)*(rfr_p)     & ! respiration of diazotroph cyanobacteria
                   + (p_zoo_resp_nh4)*(rfr_p)     & ! respiration of zooplankton
                   + (p_det_resp_nh4)*(rfr_p)     & ! recycling of detritus using oxygen (respiration)
                   + (p_det_denit_nh4)*(rfr_p)    & ! recycling of detritus using nitrate (denitrification)
                   + (p_det_sulf_nh4)*(rfr_p)     & ! recycling of detritus using sulfate (sulfate reduction)
                   + p_dop_resp                   & ! respiration of DOP
                   + p_dop_denit                  & ! recycling of DOP using nitrate (denitrification)
                   + p_dop_sulf                   & ! Mineralization of DOP, e-acceptor sulfate (sulfate reduction)
                   - (p_no3_assim_lpp)*(rfr_p)    & ! assimilation of nitrate by large-cell phytoplankton
                   - (p_nh4_assim_lpp)*(rfr_p)    & ! assimilation of ammonium by large-cell phytoplankton
                   - (p_no3_assim_spp)*(rfr_p)    & ! assimilation of nitrate by small-cell phytoplankton
                   - (p_nh4_assim_spp)*(rfr_p)    & ! assimilation of ammonium by small-cell phytoplankton
                   - (p_n2_assim_cya)*(rfr_p)     & ! fixation of dinitrogen by diazotroph cyanobacteria
                   - p_assim_lpp_dop              & ! Production of DOP by LPP
                   - p_assim_spp_dop              & ! Production of DOP by SPP
                )

                change_of_t_spp           = change_of_t_spp           + cgt_timestep*(0.0 &
                   + p_no3_assim_spp              & ! assimilation of nitrate by small-cell phytoplankton
                   + p_nh4_assim_spp              & ! assimilation of ammonium by small-cell phytoplankton
                   - p_spp_graz_zoo               & ! grazing of zooplankton eating small-cell phytoplankton
                   - p_spp_resp_nh4               & ! respiration of small-cell phytoplankton
                   - p_spp_mort_det               & ! mortality of small-scale phytoplankton
                )

                change_of_t_zoo           = change_of_t_zoo           + cgt_timestep*(0.0 &
                   + p_lpp_graz_zoo               & ! grazing of zooplankton eating large-cell phytoplankton
                   + p_spp_graz_zoo               & ! grazing of zooplankton eating small-cell phytoplankton
                   + p_cya_graz_zoo               & ! grazing of zooplankton eating diazotroph cyanobacteria
                   - p_zoo_resp_nh4               & ! respiration of zooplankton
                   - p_zoo_mort_det               & ! mortality of zooplankton
                )

                change_of_t_h2s           = change_of_t_h2s           + cgt_timestep*(0.0 &
                   + (p_poc_sulf)*(0.5)           & ! Mineralization of POC, e-acceptor sulfate (sulfate reduction)
                   + (p_pocp_sulf)*(53)           & ! Mineralization of POC, e-acceptor sulfate (sulfate reduction)
                   + (p_pocn_sulf)*(3.3125)       & ! Mineralization of POCN, e-acceptor sulfate (sulfate reduction)
                   + (p_det_sulf_nh4)*(3.3125)    & ! recycling of detritus using sulfate (sulfate reduction)
                   + (p_doc_sulf)*(0.5)           & ! Mineralization of DOC, e-acceptor sulfate (sulfate reduction)
                   + (p_dop_sulf)*(53)            & ! Mineralization of DOP, e-acceptor sulfate (sulfate reduction)
                   + (p_don_sulf)*(3.3125)        & ! Mineralization of DON, e-acceptor sulfate (sulfate reduction)
                   - p_h2s_oxo2_sul               & ! oxidation of hydrogen sulfide with oxygen
                   - p_h2s_oxno3_sul              & ! oxidation of hydrogen sulfide with nitrate
                )

                change_of_t_sul           = change_of_t_sul           + cgt_timestep*(0.0 &
                   + p_h2s_oxo2_sul               & ! oxidation of hydrogen sulfide with oxygen
                   + p_h2s_oxno3_sul              & ! oxidation of hydrogen sulfide with nitrate
                   - p_sul_oxo2_so4               & ! oxidation of elemental sulfur with oxygen
                   - p_sul_oxno3_so4              & ! oxidation of elemental sulfur with nitrate
                )

                change_of_t_alk           = change_of_t_alk           + cgt_timestep*(0.0 &
                   + (1)*(p_pocn_resp)*(0.5)      & ! respiration of POCN (produces ohminus)
                   + (1)*(p_pocn_denit_noN2)*(0.5) & ! recycling of POCN using nitrate (denitrification) (produces ohminus)
                   + (1)*(p_pocn_sulf)*(0.5)      & ! Mineralization of POCN, e-acceptor sulfate (sulfate reduction) (produces ohminus)
                   + (1)*(p_don_resp)*(0.5)       & ! respiration of DON (produces ohminus)
                   + (1)*(p_don_denit_noN2)*(0.5) & ! recycling of DON using nitrate (denitrification) (produces ohminus)
                   + (1)*(p_don_sulf)*(0.5)       & ! Mineralization of DON, e-acceptor sulfate (sulfate reduction) (produces ohminus)
                   - (1)*(p_nh4_assim_lpp_don)    & ! Production of DON by LPP (consumes ohminus)
                   - (1)*(p_nh4_assim_spp_don)    & ! Production of DON by SPP (consumes ohminus)
                   - (1)*(p_pocp_denit)*(3)       & ! recycling of POC using nitrate (denitrification) (consumes ohminus)
                   - (1)*(p_pocp_sulf)*(3)        & ! Mineralization of POC, e-acceptor sulfate (sulfate reduction) (consumes ohminus)
                   - (1)*(p_dop_denit)*(3)        & ! recycling of DOP using nitrate (denitrification) (consumes ohminus)
                   - (1)*(p_dop_sulf)*(3)         & ! Mineralization of DOP, e-acceptor sulfate (sulfate reduction) (consumes ohminus)
                   + (-1)*(p_nh4_assim_lpp)*(0.8125) & ! assimilation of ammonium by large-cell phytoplankton (produces h3oplus)
                   + (-1)*(p_nh4_assim_spp)*(0.8125) & ! assimilation of ammonium by small-cell phytoplankton (produces h3oplus)
                   + (-1)*(p_pocp_resp)*(3)       & ! respiration of POCP (produces h3oplus)
                   + (-1)*(p_nh4_nit_no3)*(2)     & ! nitrification (produces h3oplus)
                   + (-1)*(p_sul_oxo2_so4)*(2)    & ! oxidation of elemental sulfur with oxygen (produces h3oplus)
                   + (-1)*(p_sul_oxno3_so4)*(0.8) & ! oxidation of elemental sulfur with nitrate (produces h3oplus)
                   + (-1)*(p_dop_resp)*(3)        & ! respiration of DOP (produces h3oplus)
                   - (-1)*(p_no3_assim_lpp)*(1.1875) & ! assimilation of nitrate by large-cell phytoplankton (consumes h3oplus)
                   - (-1)*(p_no3_assim_spp)*(1.1875) & ! assimilation of nitrate by small-cell phytoplankton (consumes h3oplus)
                   - (-1)*(p_n2_assim_cya)*(0.1875) & ! fixation of dinitrogen by diazotroph cyanobacteria (consumes h3oplus)
                   - (-1)*(p_assim_lpp_dop)*(3)   & ! Production of DOP by LPP (consumes h3oplus)
                   - (-1)*(p_assim_spp_dop)*(3)   & ! Production of DOP by SPP (consumes h3oplus)
                   - (-1)*(p_no3_assim_lpp_don)   & ! Production of DON by LPP (consumes h3oplus)
                   - (-1)*(p_no3_assim_spp_don)   & ! Production of DON by SPP (consumes h3oplus)
                   - (-1)*(p_poc_denit)*(0.8)     & ! recycling of POC using nitrate (denitrification) (consumes h3oplus)
                   - (-1)*(p_poc_sulf)            & ! Mineralization of POC, e-acceptor sulfate (sulfate reduction) (consumes h3oplus)
                   - (-1)*(p_pocp_denit)*(84.8)   & ! recycling of POC using nitrate (denitrification) (consumes h3oplus)
                   - (-1)*(p_pocp_sulf)*(106)     & ! Mineralization of POC, e-acceptor sulfate (sulfate reduction) (consumes h3oplus)
                   - (-1)*(p_pocn_resp)*(0.5)     & ! respiration of POCN (consumes h3oplus)
                   - (-1)*(p_pocn_denit_noN2)*(5.8) & ! recycling of POCN using nitrate (denitrification) (consumes h3oplus)
                   - (-1)*(p_pocn_sulf)*(7.125)   & ! Mineralization of POCN, e-acceptor sulfate (sulfate reduction) (consumes h3oplus)
                   - (-1)*(p_lpp_resp_nh4)*(0.8125) & ! respiration of large-cell phytoplankton (consumes h3oplus)
                   - (-1)*(p_spp_resp_nh4)*(0.8125) & ! respiration of small-cell phytoplankton (consumes h3oplus)
                   - (-1)*(p_cya_resp_nh4)*(0.8125) & ! respiration of diazotroph cyanobacteria (consumes h3oplus)
                   - (-1)*(p_zoo_resp_nh4)*(0.8125) & ! respiration of zooplankton (consumes h3oplus)
                   - (-1)*(p_det_resp_nh4)*(0.8125) & ! recycling of detritus using oxygen (respiration) (consumes h3oplus)
                   - (-1)*(p_det_denit_nh4)*(6.1125) & ! recycling of detritus using nitrate (denitrification) (consumes h3oplus)
                   - (-1)*(p_det_sulf_nh4)*(7.4375) & ! recycling of detritus using sulfate (sulfate reduction) (consumes h3oplus)
                   - (-1)*(p_h2s_oxno3_sul)*(0.4) & ! oxidation of hydrogen sulfide with nitrate (consumes h3oplus)
                   - (-1)*(p_doc_denit)*(0.8)     & ! recycling of DOC using nitrate (denitrification) (consumes h3oplus)
                   - (-1)*(p_doc_sulf)            & ! Mineralization of DOC, e-acceptor sulfate (sulfate reduction) (consumes h3oplus)
                   - (-1)*(p_dop_denit)*(84.8)    & ! recycling of DOP using nitrate (denitrification) (consumes h3oplus)
                   - (-1)*(p_dop_sulf)*(106)      & ! Mineralization of DOP, e-acceptor sulfate (sulfate reduction) (consumes h3oplus)
                   - (-1)*(p_don_resp)*(0.5)      & ! respiration of DON (consumes h3oplus)
                   - (-1)*(p_don_denit_noN2)*(5.8) & ! recycling of DON using nitrate (denitrification) (consumes h3oplus)
                   - (-1)*(p_don_sulf)*(7.125)    & ! Mineralization of DON, e-acceptor sulfate (sulfate reduction) (consumes h3oplus)
                   + (2)*(p_pocp_resp)            & ! respiration of POCP (produces t_po4)
                   + (2)*(p_pocp_denit)           & ! recycling of POC using nitrate (denitrification) (produces t_po4)
                   + (2)*(p_pocp_sulf)            & ! Mineralization of POC, e-acceptor sulfate (sulfate reduction) (produces t_po4)
                   + (2)*(p_lpp_resp_nh4)*(rfr_p) & ! respiration of large-cell phytoplankton (produces t_po4)
                   + (2)*(p_spp_resp_nh4)*(rfr_p) & ! respiration of small-cell phytoplankton (produces t_po4)
                   + (2)*(p_cya_resp_nh4)*(rfr_p) & ! respiration of diazotroph cyanobacteria (produces t_po4)
                   + (2)*(p_zoo_resp_nh4)*(rfr_p) & ! respiration of zooplankton (produces t_po4)
                   + (2)*(p_det_resp_nh4)*(rfr_p) & ! recycling of detritus using oxygen (respiration) (produces t_po4)
                   + (2)*(p_det_denit_nh4)*(rfr_p) & ! recycling of detritus using nitrate (denitrification) (produces t_po4)
                   + (2)*(p_det_sulf_nh4)*(rfr_p) & ! recycling of detritus using sulfate (sulfate reduction) (produces t_po4)
                   + (2)*(p_dop_resp)             & ! respiration of DOP (produces t_po4)
                   + (2)*(p_dop_denit)            & ! recycling of DOP using nitrate (denitrification) (produces t_po4)
                   + (2)*(p_dop_sulf)             & ! Mineralization of DOP, e-acceptor sulfate (sulfate reduction) (produces t_po4)
                   - (2)*(p_no3_assim_lpp)*(rfr_p) & ! assimilation of nitrate by large-cell phytoplankton (consumes t_po4)
                   - (2)*(p_nh4_assim_lpp)*(rfr_p) & ! assimilation of ammonium by large-cell phytoplankton (consumes t_po4)
                   - (2)*(p_no3_assim_spp)*(rfr_p) & ! assimilation of nitrate by small-cell phytoplankton (consumes t_po4)
                   - (2)*(p_nh4_assim_spp)*(rfr_p) & ! assimilation of ammonium by small-cell phytoplankton (consumes t_po4)
                   - (2)*(p_n2_assim_cya)*(rfr_p) & ! fixation of dinitrogen by diazotroph cyanobacteria (consumes t_po4)
                   - (2)*(p_assim_lpp_dop)        & ! Production of DOP by LPP (consumes t_po4)
                   - (2)*(p_assim_spp_dop)        & ! Production of DOP by SPP (consumes t_po4)
                )

                change_of_t_doc           = change_of_t_doc           + cgt_timestep*(0.0 &
                   + p_assim_lpp_doc              & ! Production of DOC by LPP
                   + p_assim_spp_doc              & ! Production of DOC by SPP
                   + p_assim_cya_doc              & ! Production of POC by CYA
                   - p_doc2pco                    & ! particle formation from DOC
                   - p_doc_resp                   & ! respiration of DOC
                   - p_doc_denit                  & ! recycling of DOC using nitrate (denitrification)
                   - p_doc_sulf                   & ! Mineralization of DOC, e-acceptor sulfate (sulfate reduction)
                )

                change_of_t_dop           = change_of_t_dop           + cgt_timestep*(0.0 &
                   + p_assim_lpp_dop              & ! Production of DOP by LPP
                   + p_assim_spp_dop              & ! Production of DOP by SPP
                   - p_dop2pocp                   & ! particle formation from DOP
                   - p_dop_resp                   & ! respiration of DOP
                   - p_dop_denit                  & ! recycling of DOP using nitrate (denitrification)
                   - p_dop_sulf                   & ! Mineralization of DOP, e-acceptor sulfate (sulfate reduction)
                )

                change_of_t_n2_with_atmos_tot_N = change_of_t_n2_with_atmos_tot_N + cgt_timestep*(0.0 &
                   - (p_n2_assim_cya)*(0.5)*max(0.0,min(1.0,t_n2_with_atmos_tot_N/max(0.00000000001,t_n2))) & ! fixation of dinitrogen by diazotroph cyanobacteria
                )

                change_of_t_nh4_with_atmos_tot_N = change_of_t_nh4_with_atmos_tot_N + cgt_timestep*(0.0 &
                   + p_pocn_resp_atmos_tot_N      & ! respiration of POCN; sub-process for atmos_tot nitrogen
                   + p_pocn_denit_noN2_atmos_tot_N & ! recycling of POCN using nitrate (denitrification); sub-process for atmos_tot nitrogen
                   + p_pocn_sulf_atmos_tot_N      & ! Mineralization of POCN, e-acceptor sulfate (sulfate reduction); sub-process for atmos_tot nitrogen
                   + (p_lpp_resp_nh4_atmos_tot_N)*((1-don_fraction)) & ! respiration of large-cell phytoplankton; sub-process for atmos_tot nitrogen
                   + (p_spp_resp_nh4_atmos_tot_N)*((1-don_fraction)) & ! respiration of small-cell phytoplankton; sub-process for atmos_tot nitrogen
                   + (p_cya_resp_nh4_atmos_tot_N)*((1-don_fraction)) & ! respiration of diazotroph cyanobacteria; sub-process for atmos_tot nitrogen
                   + (p_zoo_resp_nh4_atmos_tot_N)*((1-don_fraction)) & ! respiration of zooplankton; sub-process for atmos_tot nitrogen
                   + p_det_resp_nh4_atmos_tot_N   & ! recycling of detritus using oxygen (respiration); sub-process for atmos_tot nitrogen
                   + p_det_sulf_nh4_atmos_tot_N   & ! recycling of detritus using sulfate (sulfate reduction); sub-process for atmos_tot nitrogen
                   + p_don_resp_atmos_tot_N       & ! respiration of DON; sub-process for atmos_tot nitrogen
                   + p_don_denit_noN2_atmos_tot_N & ! recycling of DON using nitrate (denitrification); sub-process for atmos_tot nitrogen
                   + p_don_sulf_atmos_tot_N       & ! Mineralization of DON, e-acceptor sulfate (sulfate reduction); sub-process for atmos_tot nitrogen
                   - p_nh4_assim_lpp*max(0.0,min(1.0,t_nh4_with_atmos_tot_N/max(0.00000000001,t_nh4))) & ! assimilation of ammonium by large-cell phytoplankton
                   - p_nh4_assim_spp*max(0.0,min(1.0,t_nh4_with_atmos_tot_N/max(0.00000000001,t_nh4))) & ! assimilation of ammonium by small-cell phytoplankton
                   - p_nh4_assim_lpp_don*max(0.0,min(1.0,t_nh4_with_atmos_tot_N/max(0.00000000001,t_nh4))) & ! Production of DON by LPP
                   - p_nh4_assim_spp_don*max(0.0,min(1.0,t_nh4_with_atmos_tot_N/max(0.00000000001,t_nh4))) & ! Production of DON by SPP
                   - p_nh4_nit_no3*max(0.0,min(1.0,t_nh4_with_atmos_tot_N/max(0.00000000001,t_nh4))) & ! nitrification
                )

                change_of_t_no3_with_atmos_tot_N = change_of_t_no3_with_atmos_tot_N + cgt_timestep*(0.0 &
                   + p_nh4_nit_no3_atmos_tot_N    & ! nitrification; sub-process for atmos_tot nitrogen
                   - p_no3_assim_lpp*max(0.0,min(1.0,t_no3_with_atmos_tot_N/max(0.00000000001,t_no3))) & ! assimilation of nitrate by large-cell phytoplankton
                   - p_no3_assim_spp*max(0.0,min(1.0,t_no3_with_atmos_tot_N/max(0.00000000001,t_no3))) & ! assimilation of nitrate by small-cell phytoplankton
                   - p_no3_assim_lpp_don*max(0.0,min(1.0,t_no3_with_atmos_tot_N/max(0.00000000001,t_no3))) & ! Production of DON by LPP
                   - p_no3_assim_spp_don*max(0.0,min(1.0,t_no3_with_atmos_tot_N/max(0.00000000001,t_no3))) & ! Production of DON by SPP
                   - (p_poc_denit)*(0.8)*max(0.0,min(1.0,t_no3_with_atmos_tot_N/max(0.00000000001,t_no3))) & ! recycling of POC using nitrate (denitrification)
                   - (p_pocp_denit)*(84.8)*max(0.0,min(1.0,t_no3_with_atmos_tot_N/max(0.00000000001,t_no3))) & ! recycling of POC using nitrate (denitrification)
                   - (p_pocn_denit_wiN2)*(5.3)*max(0.0,min(1.0,t_no3_with_atmos_tot_N/max(0.00000000001,t_no3))) & ! recycling of POCN using nitrate (denitrification)
                   - (p_det_denit_nh4)*(5.3)*max(0.0,min(1.0,t_no3_with_atmos_tot_N/max(0.00000000001,t_no3))) & ! recycling of detritus using nitrate (denitrification)
                   - (p_h2s_oxno3_sul)*(0.4)*max(0.0,min(1.0,t_no3_with_atmos_tot_N/max(0.00000000001,t_no3))) & ! oxidation of hydrogen sulfide with nitrate
                   - (p_sul_oxno3_so4)*(1.2)*max(0.0,min(1.0,t_no3_with_atmos_tot_N/max(0.00000000001,t_no3))) & ! oxidation of elemental sulfur with nitrate
                   - (p_doc_denit)*(0.8)*max(0.0,min(1.0,t_no3_with_atmos_tot_N/max(0.00000000001,t_no3))) & ! recycling of DOC using nitrate (denitrification)
                   - (p_dop_denit)*(84.8)*max(0.0,min(1.0,t_no3_with_atmos_tot_N/max(0.00000000001,t_no3))) & ! recycling of DOP using nitrate (denitrification)
                   - (p_don_denit_wiN2)*(5.3)*max(0.0,min(1.0,t_no3_with_atmos_tot_N/max(0.00000000001,t_no3))) & ! recycling of DON using nitrate (denitrification)
                )

                change_of_t_spp_with_atmos_tot_N = change_of_t_spp_with_atmos_tot_N + cgt_timestep*(0.0 &
                   + p_no3_assim_spp_atmos_tot_N  & ! assimilation of nitrate by small-cell phytoplankton; sub-process for atmos_tot nitrogen
                   + p_nh4_assim_spp_atmos_tot_N  & ! assimilation of ammonium by small-cell phytoplankton; sub-process for atmos_tot nitrogen
                   - p_spp_graz_zoo*max(0.0,min(1.0,t_spp_with_atmos_tot_N/max(0.00000000001,t_spp))) & ! grazing of zooplankton eating small-cell phytoplankton
                   - p_spp_resp_nh4*max(0.0,min(1.0,t_spp_with_atmos_tot_N/max(0.00000000001,t_spp))) & ! respiration of small-cell phytoplankton
                   - p_spp_mort_det*max(0.0,min(1.0,t_spp_with_atmos_tot_N/max(0.00000000001,t_spp))) & ! mortality of small-scale phytoplankton
                )

                change_of_t_zoo_with_atmos_tot_N = change_of_t_zoo_with_atmos_tot_N + cgt_timestep*(0.0 &
                   + p_lpp_graz_zoo_atmos_tot_N   & ! grazing of zooplankton eating large-cell phytoplankton; sub-process for atmos_tot nitrogen
                   + p_spp_graz_zoo_atmos_tot_N   & ! grazing of zooplankton eating small-cell phytoplankton; sub-process for atmos_tot nitrogen
                   + p_cya_graz_zoo_atmos_tot_N   & ! grazing of zooplankton eating diazotroph cyanobacteria; sub-process for atmos_tot nitrogen
                   - p_zoo_resp_nh4*max(0.0,min(1.0,t_zoo_with_atmos_tot_N/max(0.00000000001,t_zoo))) & ! respiration of zooplankton
                   - p_zoo_mort_det*max(0.0,min(1.0,t_zoo_with_atmos_tot_N/max(0.00000000001,t_zoo))) & ! mortality of zooplankton
                )

                change_of_t_n2_with_atmos_ship_N = change_of_t_n2_with_atmos_ship_N + cgt_timestep*(0.0 &
                   - (p_n2_assim_cya)*(0.5)*max(0.0,min(1.0,t_n2_with_atmos_ship_N/max(0.00000000001,t_n2))) & ! fixation of dinitrogen by diazotroph cyanobacteria
                )

                change_of_t_nh4_with_atmos_ship_N = change_of_t_nh4_with_atmos_ship_N + cgt_timestep*(0.0 &
                   + p_pocn_resp_atmos_ship_N     & ! respiration of POCN; sub-process for atmos_ship nitrogen
                   + p_pocn_denit_noN2_atmos_ship_N & ! recycling of POCN using nitrate (denitrification); sub-process for atmos_ship nitrogen
                   + p_pocn_sulf_atmos_ship_N     & ! Mineralization of POCN, e-acceptor sulfate (sulfate reduction); sub-process for atmos_ship nitrogen
                   + (p_lpp_resp_nh4_atmos_ship_N)*((1-don_fraction)) & ! respiration of large-cell phytoplankton; sub-process for atmos_ship nitrogen
                   + (p_spp_resp_nh4_atmos_ship_N)*((1-don_fraction)) & ! respiration of small-cell phytoplankton; sub-process for atmos_ship nitrogen
                   + (p_cya_resp_nh4_atmos_ship_N)*((1-don_fraction)) & ! respiration of diazotroph cyanobacteria; sub-process for atmos_ship nitrogen
                   + (p_zoo_resp_nh4_atmos_ship_N)*((1-don_fraction)) & ! respiration of zooplankton; sub-process for atmos_ship nitrogen
                   + p_det_resp_nh4_atmos_ship_N  & ! recycling of detritus using oxygen (respiration); sub-process for atmos_ship nitrogen
                   + p_det_sulf_nh4_atmos_ship_N  & ! recycling of detritus using sulfate (sulfate reduction); sub-process for atmos_ship nitrogen
                   + p_don_resp_atmos_ship_N      & ! respiration of DON; sub-process for atmos_ship nitrogen
                   + p_don_denit_noN2_atmos_ship_N & ! recycling of DON using nitrate (denitrification); sub-process for atmos_ship nitrogen
                   + p_don_sulf_atmos_ship_N      & ! Mineralization of DON, e-acceptor sulfate (sulfate reduction); sub-process for atmos_ship nitrogen
                   - p_nh4_assim_lpp*max(0.0,min(1.0,t_nh4_with_atmos_ship_N/max(0.00000000001,t_nh4))) & ! assimilation of ammonium by large-cell phytoplankton
                   - p_nh4_assim_spp*max(0.0,min(1.0,t_nh4_with_atmos_ship_N/max(0.00000000001,t_nh4))) & ! assimilation of ammonium by small-cell phytoplankton
                   - p_nh4_assim_lpp_don*max(0.0,min(1.0,t_nh4_with_atmos_ship_N/max(0.00000000001,t_nh4))) & ! Production of DON by LPP
                   - p_nh4_assim_spp_don*max(0.0,min(1.0,t_nh4_with_atmos_ship_N/max(0.00000000001,t_nh4))) & ! Production of DON by SPP
                   - p_nh4_nit_no3*max(0.0,min(1.0,t_nh4_with_atmos_ship_N/max(0.00000000001,t_nh4))) & ! nitrification
                )

                change_of_t_no3_with_atmos_ship_N = change_of_t_no3_with_atmos_ship_N + cgt_timestep*(0.0 &
                   + p_nh4_nit_no3_atmos_ship_N   & ! nitrification; sub-process for atmos_ship nitrogen
                   - p_no3_assim_lpp*max(0.0,min(1.0,t_no3_with_atmos_ship_N/max(0.00000000001,t_no3))) & ! assimilation of nitrate by large-cell phytoplankton
                   - p_no3_assim_spp*max(0.0,min(1.0,t_no3_with_atmos_ship_N/max(0.00000000001,t_no3))) & ! assimilation of nitrate by small-cell phytoplankton
                   - p_no3_assim_lpp_don*max(0.0,min(1.0,t_no3_with_atmos_ship_N/max(0.00000000001,t_no3))) & ! Production of DON by LPP
                   - p_no3_assim_spp_don*max(0.0,min(1.0,t_no3_with_atmos_ship_N/max(0.00000000001,t_no3))) & ! Production of DON by SPP
                   - (p_poc_denit)*(0.8)*max(0.0,min(1.0,t_no3_with_atmos_ship_N/max(0.00000000001,t_no3))) & ! recycling of POC using nitrate (denitrification)
                   - (p_pocp_denit)*(84.8)*max(0.0,min(1.0,t_no3_with_atmos_ship_N/max(0.00000000001,t_no3))) & ! recycling of POC using nitrate (denitrification)
                   - (p_pocn_denit_wiN2)*(5.3)*max(0.0,min(1.0,t_no3_with_atmos_ship_N/max(0.00000000001,t_no3))) & ! recycling of POCN using nitrate (denitrification)
                   - (p_det_denit_nh4)*(5.3)*max(0.0,min(1.0,t_no3_with_atmos_ship_N/max(0.00000000001,t_no3))) & ! recycling of detritus using nitrate (denitrification)
                   - (p_h2s_oxno3_sul)*(0.4)*max(0.0,min(1.0,t_no3_with_atmos_ship_N/max(0.00000000001,t_no3))) & ! oxidation of hydrogen sulfide with nitrate
                   - (p_sul_oxno3_so4)*(1.2)*max(0.0,min(1.0,t_no3_with_atmos_ship_N/max(0.00000000001,t_no3))) & ! oxidation of elemental sulfur with nitrate
                   - (p_doc_denit)*(0.8)*max(0.0,min(1.0,t_no3_with_atmos_ship_N/max(0.00000000001,t_no3))) & ! recycling of DOC using nitrate (denitrification)
                   - (p_dop_denit)*(84.8)*max(0.0,min(1.0,t_no3_with_atmos_ship_N/max(0.00000000001,t_no3))) & ! recycling of DOP using nitrate (denitrification)
                   - (p_don_denit_wiN2)*(5.3)*max(0.0,min(1.0,t_no3_with_atmos_ship_N/max(0.00000000001,t_no3))) & ! recycling of DON using nitrate (denitrification)
                )

                change_of_t_spp_with_atmos_ship_N = change_of_t_spp_with_atmos_ship_N + cgt_timestep*(0.0 &
                   + p_no3_assim_spp_atmos_ship_N & ! assimilation of nitrate by small-cell phytoplankton; sub-process for atmos_ship nitrogen
                   + p_nh4_assim_spp_atmos_ship_N & ! assimilation of ammonium by small-cell phytoplankton; sub-process for atmos_ship nitrogen
                   - p_spp_graz_zoo*max(0.0,min(1.0,t_spp_with_atmos_ship_N/max(0.00000000001,t_spp))) & ! grazing of zooplankton eating small-cell phytoplankton
                   - p_spp_resp_nh4*max(0.0,min(1.0,t_spp_with_atmos_ship_N/max(0.00000000001,t_spp))) & ! respiration of small-cell phytoplankton
                   - p_spp_mort_det*max(0.0,min(1.0,t_spp_with_atmos_ship_N/max(0.00000000001,t_spp))) & ! mortality of small-scale phytoplankton
                )

                change_of_t_zoo_with_atmos_ship_N = change_of_t_zoo_with_atmos_ship_N + cgt_timestep*(0.0 &
                   + p_lpp_graz_zoo_atmos_ship_N  & ! grazing of zooplankton eating large-cell phytoplankton; sub-process for atmos_ship nitrogen
                   + p_spp_graz_zoo_atmos_ship_N  & ! grazing of zooplankton eating small-cell phytoplankton; sub-process for atmos_ship nitrogen
                   + p_cya_graz_zoo_atmos_ship_N  & ! grazing of zooplankton eating diazotroph cyanobacteria; sub-process for atmos_ship nitrogen
                   - p_zoo_resp_nh4*max(0.0,min(1.0,t_zoo_with_atmos_ship_N/max(0.00000000001,t_zoo))) & ! respiration of zooplankton
                   - p_zoo_mort_det*max(0.0,min(1.0,t_zoo_with_atmos_ship_N/max(0.00000000001,t_zoo))) & ! mortality of zooplankton
                )

                change_of_t_pocn_with_atmos_tot_N = change_of_t_pocn_with_atmos_tot_N + cgt_timestep*(0.0 &
                   + p_don2pocn_atmos_tot_N       & ! particle formation from DON; sub-process for atmos_tot nitrogen
                   - p_pocn_resp*max(0.0,min(1.0,t_pocn_with_atmos_tot_N/max(0.00000000001,t_pocn))) & ! respiration of POCN
                   - p_pocn_denit_noN2*max(0.0,min(1.0,t_pocn_with_atmos_tot_N/max(0.00000000001,t_pocn))) & ! recycling of POCN using nitrate (denitrification)
                   - p_pocn_sulf*max(0.0,min(1.0,t_pocn_with_atmos_tot_N/max(0.00000000001,t_pocn))) & ! Mineralization of POCN, e-acceptor sulfate (sulfate reduction)
                )

                change_of_t_lpp_with_atmos_tot_N = change_of_t_lpp_with_atmos_tot_N + cgt_timestep*(0.0 &
                   + p_no3_assim_lpp_atmos_tot_N  & ! assimilation of nitrate by large-cell phytoplankton; sub-process for atmos_tot nitrogen
                   + p_nh4_assim_lpp_atmos_tot_N  & ! assimilation of ammonium by large-cell phytoplankton; sub-process for atmos_tot nitrogen
                   - p_lpp_graz_zoo*max(0.0,min(1.0,t_lpp_with_atmos_tot_N/max(0.00000000001,t_lpp))) & ! grazing of zooplankton eating large-cell phytoplankton
                   - p_lpp_resp_nh4*max(0.0,min(1.0,t_lpp_with_atmos_tot_N/max(0.00000000001,t_lpp))) & ! respiration of large-cell phytoplankton
                   - p_lpp_mort_det*max(0.0,min(1.0,t_lpp_with_atmos_tot_N/max(0.00000000001,t_lpp))) & ! mortality of large-cell phytoplankton
                )

                change_of_t_don_with_atmos_tot_N = change_of_t_don_with_atmos_tot_N + cgt_timestep*(0.0 &
                   + p_nh4_assim_lpp_don_atmos_tot_N & ! Production of DON by LPP; sub-process for atmos_tot nitrogen
                   + p_no3_assim_lpp_don_atmos_tot_N & ! Production of DON by LPP; sub-process for atmos_tot nitrogen
                   + p_nh4_assim_spp_don_atmos_tot_N & ! Production of DON by SPP; sub-process for atmos_tot nitrogen
                   + p_no3_assim_spp_don_atmos_tot_N & ! Production of DON by SPP; sub-process for atmos_tot nitrogen
                   + (p_lpp_resp_nh4_atmos_tot_N)*(don_fraction) & ! respiration of large-cell phytoplankton; sub-process for atmos_tot nitrogen
                   + (p_spp_resp_nh4_atmos_tot_N)*(don_fraction) & ! respiration of small-cell phytoplankton; sub-process for atmos_tot nitrogen
                   + (p_cya_resp_nh4_atmos_tot_N)*(don_fraction) & ! respiration of diazotroph cyanobacteria; sub-process for atmos_tot nitrogen
                   + (p_zoo_resp_nh4_atmos_tot_N)*(don_fraction) & ! respiration of zooplankton; sub-process for atmos_tot nitrogen
                   - p_don2pocn*max(0.0,min(1.0,t_don_with_atmos_tot_N/max(0.00000000001,t_don))) & ! particle formation from DON
                   - p_don_resp*max(0.0,min(1.0,t_don_with_atmos_tot_N/max(0.00000000001,t_don))) & ! respiration of DON
                   - p_don_denit_noN2*max(0.0,min(1.0,t_don_with_atmos_tot_N/max(0.00000000001,t_don))) & ! recycling of DON using nitrate (denitrification)
                   - p_don_sulf*max(0.0,min(1.0,t_don_with_atmos_tot_N/max(0.00000000001,t_don))) & ! Mineralization of DON, e-acceptor sulfate (sulfate reduction)
                )

                change_of_t_cya_with_atmos_tot_N = change_of_t_cya_with_atmos_tot_N + cgt_timestep*(0.0 &
                   - p_cya_graz_zoo*max(0.0,min(1.0,t_cya_with_atmos_tot_N/max(0.00000000001,t_cya))) & ! grazing of zooplankton eating diazotroph cyanobacteria
                   - p_cya_resp_nh4*max(0.0,min(1.0,t_cya_with_atmos_tot_N/max(0.00000000001,t_cya))) & ! respiration of diazotroph cyanobacteria
                   - p_cya_mort_det*max(0.0,min(1.0,t_cya_with_atmos_tot_N/max(0.00000000001,t_cya))) & ! mortality of diazotroph cyanobacteria
                   - p_cya_mort_det_diff*max(0.0,min(1.0,t_cya_with_atmos_tot_N/max(0.00000000001,t_cya))) & ! mortality of diazotroph cyanobacteria due to strong turbulence
                )

                change_of_t_det_with_atmos_tot_N = change_of_t_det_with_atmos_tot_N + cgt_timestep*(0.0 &
                   + p_lpp_mort_det_atmos_tot_N   & ! mortality of large-cell phytoplankton; sub-process for atmos_tot nitrogen
                   + p_spp_mort_det_atmos_tot_N   & ! mortality of small-scale phytoplankton; sub-process for atmos_tot nitrogen
                   + p_cya_mort_det_atmos_tot_N   & ! mortality of diazotroph cyanobacteria; sub-process for atmos_tot nitrogen
                   + p_cya_mort_det_diff_atmos_tot_N & ! mortality of diazotroph cyanobacteria due to strong turbulence; sub-process for atmos_tot nitrogen
                   + p_zoo_mort_det_atmos_tot_N   & ! mortality of zooplankton; sub-process for atmos_tot nitrogen
                   - p_det_resp_nh4*max(0.0,min(1.0,t_det_with_atmos_tot_N/max(0.00000000001,t_det))) & ! recycling of detritus using oxygen (respiration)
                   - p_det_denit_nh4*max(0.0,min(1.0,t_det_with_atmos_tot_N/max(0.00000000001,t_det))) & ! recycling of detritus using nitrate (denitrification)
                   - p_det_sulf_nh4*max(0.0,min(1.0,t_det_with_atmos_tot_N/max(0.00000000001,t_det))) & ! recycling of detritus using sulfate (sulfate reduction)
                )

                change_of_t_lpp           = change_of_t_lpp           + cgt_timestep*(0.0 &
                   + p_no3_assim_lpp              & ! assimilation of nitrate by large-cell phytoplankton
                   + p_nh4_assim_lpp              & ! assimilation of ammonium by large-cell phytoplankton
                   - p_lpp_graz_zoo               & ! grazing of zooplankton eating large-cell phytoplankton
                   - p_lpp_resp_nh4               & ! respiration of large-cell phytoplankton
                   - p_lpp_mort_det               & ! mortality of large-cell phytoplankton
                )

                change_of_t_don           = change_of_t_don           + cgt_timestep*(0.0 &
                   + p_nh4_assim_lpp_don          & ! Production of DON by LPP
                   + p_no3_assim_lpp_don          & ! Production of DON by LPP
                   + p_nh4_assim_spp_don          & ! Production of DON by SPP
                   + p_no3_assim_spp_don          & ! Production of DON by SPP
                   + (p_lpp_resp_nh4)*(don_fraction) & ! respiration of large-cell phytoplankton
                   + (p_spp_resp_nh4)*(don_fraction) & ! respiration of small-cell phytoplankton
                   + (p_cya_resp_nh4)*(don_fraction) & ! respiration of diazotroph cyanobacteria
                   + (p_zoo_resp_nh4)*(don_fraction) & ! respiration of zooplankton
                   - p_don2pocn                   & ! particle formation from DON
                   - p_don_resp                   & ! respiration of DON
                   - p_don_denit_noN2             & ! recycling of DON using nitrate (denitrification)
                   - p_don_sulf                   & ! Mineralization of DON, e-acceptor sulfate (sulfate reduction)
                )

                change_of_t_cya           = change_of_t_cya           + cgt_timestep*(0.0 &
                   + p_n2_assim_cya               & ! fixation of dinitrogen by diazotroph cyanobacteria
                   - p_cya_graz_zoo               & ! grazing of zooplankton eating diazotroph cyanobacteria
                   - p_cya_resp_nh4               & ! respiration of diazotroph cyanobacteria
                   - p_cya_mort_det               & ! mortality of diazotroph cyanobacteria
                   - p_cya_mort_det_diff          & ! mortality of diazotroph cyanobacteria due to strong turbulence
                )

                change_of_t_det           = change_of_t_det           + cgt_timestep*(0.0 &
                   + p_lpp_mort_det               & ! mortality of large-cell phytoplankton
                   + p_spp_mort_det               & ! mortality of small-scale phytoplankton
                   + p_cya_mort_det               & ! mortality of diazotroph cyanobacteria
                   + p_cya_mort_det_diff          & ! mortality of diazotroph cyanobacteria due to strong turbulence
                   + p_zoo_mort_det               & ! mortality of zooplankton
                   - p_det_resp_nh4               & ! recycling of detritus using oxygen (respiration)
                   - p_det_denit_nh4              & ! recycling of detritus using nitrate (denitrification)
                   - p_det_sulf_nh4               & ! recycling of detritus using sulfate (sulfate reduction)
                )

                change_of_t_poc           = change_of_t_poc           + cgt_timestep*(0.0 &
                   + p_doc2pco                    & ! particle formation from DOC
                   - p_poc_resp                   & ! respiration of POC
                   - p_poc_denit                  & ! recycling of POC using nitrate (denitrification)
                   - p_poc_sulf                   & ! Mineralization of POC, e-acceptor sulfate (sulfate reduction)
                )

                change_of_t_pocp          = change_of_t_pocp          + cgt_timestep*(0.0 &
                   + p_dop2pocp                   & ! particle formation from DOP
                   - p_pocp_resp                  & ! respiration of POCP
                   - p_pocp_denit                 & ! recycling of POC using nitrate (denitrification)
                   - p_pocp_sulf                  & ! Mineralization of POC, e-acceptor sulfate (sulfate reduction)
                )

                change_of_t_pocn          = change_of_t_pocn          + cgt_timestep*(0.0 &
                   + p_don2pocn                   & ! particle formation from DON
                   - p_pocn_resp                  & ! respiration of POCN
                   - p_pocn_denit_noN2            & ! recycling of POCN using nitrate (denitrification)
                   - p_pocn_sulf                  & ! Mineralization of POCN, e-acceptor sulfate (sulfate reduction)
                )

                change_of_t_pocn_with_atmos_ship_N = change_of_t_pocn_with_atmos_ship_N + cgt_timestep*(0.0 &
                   + p_don2pocn_atmos_ship_N      & ! particle formation from DON; sub-process for atmos_ship nitrogen
                   - p_pocn_resp*max(0.0,min(1.0,t_pocn_with_atmos_ship_N/max(0.00000000001,t_pocn))) & ! respiration of POCN
                   - p_pocn_denit_noN2*max(0.0,min(1.0,t_pocn_with_atmos_ship_N/max(0.00000000001,t_pocn))) & ! recycling of POCN using nitrate (denitrification)
                   - p_pocn_sulf*max(0.0,min(1.0,t_pocn_with_atmos_ship_N/max(0.00000000001,t_pocn))) & ! Mineralization of POCN, e-acceptor sulfate (sulfate reduction)
                )

                change_of_t_lpp_with_atmos_ship_N = change_of_t_lpp_with_atmos_ship_N + cgt_timestep*(0.0 &
                   + p_no3_assim_lpp_atmos_ship_N & ! assimilation of nitrate by large-cell phytoplankton; sub-process for atmos_ship nitrogen
                   + p_nh4_assim_lpp_atmos_ship_N & ! assimilation of ammonium by large-cell phytoplankton; sub-process for atmos_ship nitrogen
                   - p_lpp_graz_zoo*max(0.0,min(1.0,t_lpp_with_atmos_ship_N/max(0.00000000001,t_lpp))) & ! grazing of zooplankton eating large-cell phytoplankton
                   - p_lpp_resp_nh4*max(0.0,min(1.0,t_lpp_with_atmos_ship_N/max(0.00000000001,t_lpp))) & ! respiration of large-cell phytoplankton
                   - p_lpp_mort_det*max(0.0,min(1.0,t_lpp_with_atmos_ship_N/max(0.00000000001,t_lpp))) & ! mortality of large-cell phytoplankton
                )

                change_of_t_don_with_atmos_ship_N = change_of_t_don_with_atmos_ship_N + cgt_timestep*(0.0 &
                   + p_nh4_assim_lpp_don_atmos_ship_N & ! Production of DON by LPP; sub-process for atmos_ship nitrogen
                   + p_no3_assim_lpp_don_atmos_ship_N & ! Production of DON by LPP; sub-process for atmos_ship nitrogen
                   + p_nh4_assim_spp_don_atmos_ship_N & ! Production of DON by SPP; sub-process for atmos_ship nitrogen
                   + p_no3_assim_spp_don_atmos_ship_N & ! Production of DON by SPP; sub-process for atmos_ship nitrogen
                   + (p_lpp_resp_nh4_atmos_ship_N)*(don_fraction) & ! respiration of large-cell phytoplankton; sub-process for atmos_ship nitrogen
                   + (p_spp_resp_nh4_atmos_ship_N)*(don_fraction) & ! respiration of small-cell phytoplankton; sub-process for atmos_ship nitrogen
                   + (p_cya_resp_nh4_atmos_ship_N)*(don_fraction) & ! respiration of diazotroph cyanobacteria; sub-process for atmos_ship nitrogen
                   + (p_zoo_resp_nh4_atmos_ship_N)*(don_fraction) & ! respiration of zooplankton; sub-process for atmos_ship nitrogen
                   - p_don2pocn*max(0.0,min(1.0,t_don_with_atmos_ship_N/max(0.00000000001,t_don))) & ! particle formation from DON
                   - p_don_resp*max(0.0,min(1.0,t_don_with_atmos_ship_N/max(0.00000000001,t_don))) & ! respiration of DON
                   - p_don_denit_noN2*max(0.0,min(1.0,t_don_with_atmos_ship_N/max(0.00000000001,t_don))) & ! recycling of DON using nitrate (denitrification)
                   - p_don_sulf*max(0.0,min(1.0,t_don_with_atmos_ship_N/max(0.00000000001,t_don))) & ! Mineralization of DON, e-acceptor sulfate (sulfate reduction)
                )

                change_of_t_cya_with_atmos_ship_N = change_of_t_cya_with_atmos_ship_N + cgt_timestep*(0.0 &
                   - p_cya_graz_zoo*max(0.0,min(1.0,t_cya_with_atmos_ship_N/max(0.00000000001,t_cya))) & ! grazing of zooplankton eating diazotroph cyanobacteria
                   - p_cya_resp_nh4*max(0.0,min(1.0,t_cya_with_atmos_ship_N/max(0.00000000001,t_cya))) & ! respiration of diazotroph cyanobacteria
                   - p_cya_mort_det*max(0.0,min(1.0,t_cya_with_atmos_ship_N/max(0.00000000001,t_cya))) & ! mortality of diazotroph cyanobacteria
                   - p_cya_mort_det_diff*max(0.0,min(1.0,t_cya_with_atmos_ship_N/max(0.00000000001,t_cya))) & ! mortality of diazotroph cyanobacteria due to strong turbulence
                )

                change_of_t_det_with_atmos_ship_N = change_of_t_det_with_atmos_ship_N + cgt_timestep*(0.0 &
                   + p_lpp_mort_det_atmos_ship_N  & ! mortality of large-cell phytoplankton; sub-process for atmos_ship nitrogen
                   + p_spp_mort_det_atmos_ship_N  & ! mortality of small-scale phytoplankton; sub-process for atmos_ship nitrogen
                   + p_cya_mort_det_atmos_ship_N  & ! mortality of diazotroph cyanobacteria; sub-process for atmos_ship nitrogen
                   + p_cya_mort_det_diff_atmos_ship_N & ! mortality of diazotroph cyanobacteria due to strong turbulence; sub-process for atmos_ship nitrogen
                   + p_zoo_mort_det_atmos_ship_N  & ! mortality of zooplankton; sub-process for atmos_ship nitrogen
                   - p_det_resp_nh4*max(0.0,min(1.0,t_det_with_atmos_ship_N/max(0.00000000001,t_det))) & ! recycling of detritus using oxygen (respiration)
                   - p_det_denit_nh4*max(0.0,min(1.0,t_det_with_atmos_ship_N/max(0.00000000001,t_det))) & ! recycling of detritus using nitrate (denitrification)
                   - p_det_sulf_nh4*max(0.0,min(1.0,t_det_with_atmos_ship_N/max(0.00000000001,t_det))) & ! recycling of detritus using sulfate (sulfate reduction)
                )

                if (k == 1) then

                   change_of_t_n2            = change_of_t_n2            + cgt_timestep*(0.0 &
                   )

                   change_of_t_o2            = change_of_t_o2            + cgt_timestep*(0.0 &
                   )

                   change_of_t_dic           = change_of_t_dic           + cgt_timestep*(0.0 &
                   )

                   change_of_t_n2_with_atmos_tot_N = change_of_t_n2_with_atmos_tot_N + cgt_timestep*(0.0 &
                   )

                   change_of_t_n2_with_atmos_ship_N = change_of_t_n2_with_atmos_ship_N + cgt_timestep*(0.0 &
                   )
               endif

                if (k == grid_kmt(i,j)) then
                   if (implicit_bottomfluxes) then

                      change_btf_t_n2            = change_btf_t_n2            + cgt_timestep*(0.0 &
                         + (p_nh4_nitdenit_n2)*(0.5)    & ! coupled nitrification and denitrification after mineralization of detritus in oxic sediments
                         + (p_sed_denit_nh4_wiN2)*(2.65) & ! recycling of sedimentary detritus to ammonium using nitrate (denitrification)
                         + (p_sed_poc_denit)*(0.4)      & ! recycling of sedimentary poc to dic using nitrate (denitrification)
                         + (p_sed_pocn_denit_wiN2)*(2.65) & ! recycling of sedimentary pocn to dic and NH4 using nitrate (denitrification)
                         + (p_sed_pocp_denit)*(42.4)    & ! recycling of sedimentary pocp to dic and PO4 using nitrate (denitrification)
                         + (p_nh4_nitdenit_pocn_n2)*(0.5) & ! coupled nitrification and denitrification after mineralization of pocn-detritus in oxic sediments
                      )

                      change_btf_t_o2            = change_btf_t_o2            + cgt_timestep*(0.0 &
                         - (p_sed_resp_nh4)*(6.625)     & ! recycling of sedimentary detritus to ammonium using oxygen (respiration)
                         - (p_nh4_nitdenit_n2)*(0.75)   & ! coupled nitrification and denitrification after mineralization of detritus in oxic sediments
                         - p_sed_poc_resp               & ! recycling of sedimentary poc to dic using oxygen (respiration)
                         - (p_sed_pocn_resp)*(6.625)    & ! recycling of sedimentary pocn to dic and NH4 using oxygen (respiration)
                         - (p_sed_pocp_resp)*(106)      & ! recycling of sedimentary pocp to dic and PO4 using oxygen (respiration)
                         - (p_nh4_nitdenit_pocn_n2)*(0.75) & ! coupled nitrification and denitrification after mineralization of pocn-detritus in oxic sediments
                      )

                      change_btf_t_dic           = change_btf_t_dic           + cgt_timestep*(0.0 &
                         + (p_sed_resp_nh4)*(rfr_c)     & ! recycling of sedimentary detritus to ammonium using oxygen (respiration)
                         + (p_sed_denit_nh4_noN2)*(rfr_c) & ! recycling of sedimentary detritus to ammonium using nitrate (denitrification)
                         + (p_sed_sulf_nh4)*(rfr_c)     & ! recycling of sedimentary detritus to ammonium using sulfate (sulfate reduction)
                         + p_sed_poc_resp               & ! recycling of sedimentary poc to dic using oxygen (respiration)
                         + p_sed_poc_denit              & ! recycling of sedimentary poc to dic using nitrate (denitrification)
                         + p_sed_poc_sulf               & ! recycling of sedimentary poc to dic using sulfate (sulfate reduction)
                         + (p_sed_pocn_resp)*(6.625)    & ! recycling of sedimentary pocn to dic and NH4 using oxygen (respiration)
                         + (p_sed_pocp_resp)*(106)      & ! recycling of sedimentary pocp to dic and PO4 using oxygen (respiration)
                         + (p_sed_pocn_denit_noN2)*(6.625) & ! recycling of sedimentary pocn to dic and NH4 using nitrate (denitrification)
                         + (p_sed_pocp_denit)*(106)     & ! recycling of sedimentary pocp to dic and PO4 using nitrate (denitrification)
                         + (p_sed_pocn_sulf)*(6.625)    & ! recycling of sedimentary pocn to dic and NH4 using sulfate (sulfate reduction)
                         + (p_sed_pocp_sulf)*(106)      & ! recycling of sedimentary pocp to dic and PO4 using sulfate (sulfate reduction)
                      )

                      change_btf_t_nh4           = change_btf_t_nh4           + cgt_timestep*(0.0 &
                         + p_sed_resp_nh4               & ! recycling of sedimentary detritus to ammonium using oxygen (respiration)
                         + p_sed_denit_nh4_noN2         & ! recycling of sedimentary detritus to ammonium using nitrate (denitrification)
                         + p_sed_sulf_nh4               & ! recycling of sedimentary detritus to ammonium using sulfate (sulfate reduction)
                         + p_sed_pocn_resp              & ! recycling of sedimentary pocn to dic and NH4 using oxygen (respiration)
                         + p_sed_pocn_denit_noN2        & ! recycling of sedimentary pocn to dic and NH4 using nitrate (denitrification)
                         + p_sed_pocn_sulf              & ! recycling of sedimentary pocn to dic and NH4 using sulfate (sulfate reduction)
                         - p_nh4_nitdenit_n2            & ! coupled nitrification and denitrification after mineralization of detritus in oxic sediments
                         - p_nh4_nitdenit_pocn_n2       & ! coupled nitrification and denitrification after mineralization of pocn-detritus in oxic sediments
                      )

                      change_btf_t_no3           = change_btf_t_no3           + cgt_timestep*(0.0 &
                         - (p_sed_denit_nh4_wiN2)*(5.3) & ! recycling of sedimentary detritus to ammonium using nitrate (denitrification)
                         - (p_sed_poc_denit)*(0.8)      & ! recycling of sedimentary poc to dic using nitrate (denitrification)
                         - (p_sed_pocn_denit_wiN2)*(5.3) & ! recycling of sedimentary pocn to dic and NH4 using nitrate (denitrification)
                         - (p_sed_pocp_denit)*(84.8)    & ! recycling of sedimentary pocp to dic and PO4 using nitrate (denitrification)
                      )

                      change_btf_t_po4           = change_btf_t_po4           + cgt_timestep*(0.0 &
                         + (p_sed_resp_nh4)*(rfr_p)     & ! recycling of sedimentary detritus to ammonium using oxygen (respiration)
                         + (p_sed_denit_nh4_noN2)*(rfr_p) & ! recycling of sedimentary detritus to ammonium using nitrate (denitrification)
                         + (p_sed_sulf_nh4)*(rfr_p)     & ! recycling of sedimentary detritus to ammonium using sulfate (sulfate reduction)
                         + p_ips_liber_po4              & ! liberation of phosphate from the sediment under anoxic conditions
                         + p_sed_pocp_resp              & ! recycling of sedimentary pocp to dic and PO4 using oxygen (respiration)
                         + p_sed_pocp_denit             & ! recycling of sedimentary pocp to dic and PO4 using nitrate (denitrification)
                         + p_sed_pocp_sulf              & ! recycling of sedimentary pocp to dic and PO4 using sulfate (sulfate reduction)
                         - (p_po4_retent_ips)*(rfr_p)   & ! retention of phosphate in the sediment under oxic conditions
                      )

                      change_btf_t_h2s           = change_btf_t_h2s           + cgt_timestep*(0.0 &
                         + (p_sed_sulf_nh4)*(3.3125)    & ! recycling of sedimentary detritus to ammonium using sulfate (sulfate reduction)
                         + (p_sed_poc_sulf)*(0.5)       & ! recycling of sedimentary poc to dic using sulfate (sulfate reduction)
                         + (p_sed_pocn_sulf)*(3.3125)   & ! recycling of sedimentary pocn to dic and NH4 using sulfate (sulfate reduction)
                         + (p_sed_pocp_sulf)*(53)       & ! recycling of sedimentary pocp to dic and PO4 using sulfate (sulfate reduction)
                      )

                      change_btf_t_alk           = change_btf_t_alk           + cgt_timestep*(0.0 &
                         + (1)*(p_sed_pocn_resp)*(0.5)  & ! recycling of sedimentary pocn to dic and NH4 using oxygen (respiration) (produces ohminus)
                         + (1)*(p_sed_pocn_denit_noN2)*(0.5) & ! recycling of sedimentary pocn to dic and NH4 using nitrate (denitrification) (produces ohminus)
                         + (1)*(p_sed_pocn_sulf)*(0.5)  & ! recycling of sedimentary pocn to dic and NH4 using sulfate (sulfate reduction) (produces ohminus)
                         - (1)*(p_sed_pocp_denit)*(3)   & ! recycling of sedimentary pocp to dic and PO4 using nitrate (denitrification) (consumes ohminus)
                         - (1)*(p_sed_pocp_sulf)*(3)    & ! recycling of sedimentary pocp to dic and PO4 using sulfate (sulfate reduction) (consumes ohminus)
                         + (-1)*(p_nh4_nitdenit_n2)     & ! coupled nitrification and denitrification after mineralization of detritus in oxic sediments (produces h3oplus)
                         + (-1)*(p_sed_pocp_resp)*(3)   & ! recycling of sedimentary pocp to dic and PO4 using oxygen (respiration) (produces h3oplus)
                         + (-1)*(p_nh4_nitdenit_pocn_n2) & ! coupled nitrification and denitrification after mineralization of pocn-detritus in oxic sediments (produces h3oplus)
                         - (-1)*(p_sed_resp_nh4)*(0.8125) & ! recycling of sedimentary detritus to ammonium using oxygen (respiration) (consumes h3oplus)
                         - (-1)*(p_sed_denit_nh4_noN2)*(6.1125) & ! recycling of sedimentary detritus to ammonium using nitrate (denitrification) (consumes h3oplus)
                         - (-1)*(p_sed_sulf_nh4)*(7.4375) & ! recycling of sedimentary detritus to ammonium using sulfate (sulfate reduction) (consumes h3oplus)
                         - (-1)*(p_sed_poc_denit)*(0.8) & ! recycling of sedimentary poc to dic using nitrate (denitrification) (consumes h3oplus)
                         - (-1)*(p_sed_poc_sulf)        & ! recycling of sedimentary poc to dic using sulfate (sulfate reduction) (consumes h3oplus)
                         - (-1)*(p_sed_pocn_resp)*(0.5) & ! recycling of sedimentary pocn to dic and NH4 using oxygen (respiration) (consumes h3oplus)
                         - (-1)*(p_sed_pocp_denit)*(84.8) & ! recycling of sedimentary pocp to dic and PO4 using nitrate (denitrification) (consumes h3oplus)
                         - (-1)*(p_sed_pocn_sulf)*(7.125) & ! recycling of sedimentary pocn to dic and NH4 using sulfate (sulfate reduction) (consumes h3oplus)
                         - (-1)*(p_sed_pocp_sulf)*(106) & ! recycling of sedimentary pocp to dic and PO4 using sulfate (sulfate reduction) (consumes h3oplus)
                         + (2)*(p_sed_resp_nh4)*(rfr_p) & ! recycling of sedimentary detritus to ammonium using oxygen (respiration) (produces t_po4)
                         + (2)*(p_sed_denit_nh4_noN2)*(rfr_p) & ! recycling of sedimentary detritus to ammonium using nitrate (denitrification) (produces t_po4)
                         + (2)*(p_sed_sulf_nh4)*(rfr_p) & ! recycling of sedimentary detritus to ammonium using sulfate (sulfate reduction) (produces t_po4)
                         + (2)*(p_ips_liber_po4)        & ! liberation of phosphate from the sediment under anoxic conditions (produces t_po4)
                         + (2)*(p_sed_pocp_resp)        & ! recycling of sedimentary pocp to dic and PO4 using oxygen (respiration) (produces t_po4)
                         + (2)*(p_sed_pocp_denit)       & ! recycling of sedimentary pocp to dic and PO4 using nitrate (denitrification) (produces t_po4)
                         + (2)*(p_sed_pocp_sulf)        & ! recycling of sedimentary pocp to dic and PO4 using sulfate (sulfate reduction) (produces t_po4)
                         - (2)*(p_po4_retent_ips)*(rfr_p) & ! retention of phosphate in the sediment under oxic conditions (consumes t_po4)
                      )

                      change_btf_t_nh4_with_atmos_tot_N = change_btf_t_nh4_with_atmos_tot_N + cgt_timestep*(0.0 &
                         + p_sed_resp_nh4_atmos_tot_N   & ! recycling of sedimentary detritus to ammonium using oxygen (respiration); sub-process for atmos_tot nitrogen
                         + p_sed_denit_nh4_noN2_atmos_tot_N & ! recycling of sedimentary detritus to ammonium using nitrate (denitrification); sub-process for atmos_tot nitrogen
                         + p_sed_sulf_nh4_atmos_tot_N   & ! recycling of sedimentary detritus to ammonium using sulfate (sulfate reduction); sub-process for atmos_tot nitrogen
                         + p_sed_pocn_resp_atmos_tot_N  & ! recycling of sedimentary pocn to dic and NH4 using oxygen (respiration); sub-process for atmos_tot nitrogen
                         + p_sed_pocn_denit_noN2_atmos_tot_N & ! recycling of sedimentary pocn to dic and NH4 using nitrate (denitrification); sub-process for atmos_tot nitrogen
                         + p_sed_pocn_sulf_atmos_tot_N  & ! recycling of sedimentary pocn to dic and NH4 using sulfate (sulfate reduction); sub-process for atmos_tot nitrogen
                         - p_nh4_nitdenit_n2*max(0.0,min(1.0,t_nh4_with_atmos_tot_N/max(0.00000000001,t_nh4))) & ! coupled nitrification and denitrification after mineralization of detritus in oxic sediments
                         - p_nh4_nitdenit_pocn_n2*max(0.0,min(1.0,t_nh4_with_atmos_tot_N/max(0.00000000001,t_nh4))) & ! coupled nitrification and denitrification after mineralization of pocn-detritus in oxic sediments
                      )

                      change_btf_t_no3_with_atmos_tot_N = change_btf_t_no3_with_atmos_tot_N + cgt_timestep*(0.0 &
                         - (p_sed_denit_nh4_wiN2)*(5.3)*max(0.0,min(1.0,t_no3_with_atmos_tot_N/max(0.00000000001,t_no3))) & ! recycling of sedimentary detritus to ammonium using nitrate (denitrification)
                         - (p_sed_poc_denit)*(0.8)*max(0.0,min(1.0,t_no3_with_atmos_tot_N/max(0.00000000001,t_no3))) & ! recycling of sedimentary poc to dic using nitrate (denitrification)
                         - (p_sed_pocn_denit_wiN2)*(5.3)*max(0.0,min(1.0,t_no3_with_atmos_tot_N/max(0.00000000001,t_no3))) & ! recycling of sedimentary pocn to dic and NH4 using nitrate (denitrification)
                         - (p_sed_pocp_denit)*(84.8)*max(0.0,min(1.0,t_no3_with_atmos_tot_N/max(0.00000000001,t_no3))) & ! recycling of sedimentary pocp to dic and PO4 using nitrate (denitrification)
                      )

                      change_btf_t_nh4_with_atmos_ship_N = change_btf_t_nh4_with_atmos_ship_N + cgt_timestep*(0.0 &
                         + p_sed_resp_nh4_atmos_ship_N  & ! recycling of sedimentary detritus to ammonium using oxygen (respiration); sub-process for atmos_ship nitrogen
                         + p_sed_denit_nh4_noN2_atmos_ship_N & ! recycling of sedimentary detritus to ammonium using nitrate (denitrification); sub-process for atmos_ship nitrogen
                         + p_sed_sulf_nh4_atmos_ship_N  & ! recycling of sedimentary detritus to ammonium using sulfate (sulfate reduction); sub-process for atmos_ship nitrogen
                         + p_sed_pocn_resp_atmos_ship_N & ! recycling of sedimentary pocn to dic and NH4 using oxygen (respiration); sub-process for atmos_ship nitrogen
                         + p_sed_pocn_denit_noN2_atmos_ship_N & ! recycling of sedimentary pocn to dic and NH4 using nitrate (denitrification); sub-process for atmos_ship nitrogen
                         + p_sed_pocn_sulf_atmos_ship_N & ! recycling of sedimentary pocn to dic and NH4 using sulfate (sulfate reduction); sub-process for atmos_ship nitrogen
                         - p_nh4_nitdenit_n2*max(0.0,min(1.0,t_nh4_with_atmos_ship_N/max(0.00000000001,t_nh4))) & ! coupled nitrification and denitrification after mineralization of detritus in oxic sediments
                         - p_nh4_nitdenit_pocn_n2*max(0.0,min(1.0,t_nh4_with_atmos_ship_N/max(0.00000000001,t_nh4))) & ! coupled nitrification and denitrification after mineralization of pocn-detritus in oxic sediments
                      )

                      change_btf_t_no3_with_atmos_ship_N = change_btf_t_no3_with_atmos_ship_N + cgt_timestep*(0.0 &
                         - (p_sed_denit_nh4_wiN2)*(5.3)*max(0.0,min(1.0,t_no3_with_atmos_ship_N/max(0.00000000001,t_no3))) & ! recycling of sedimentary detritus to ammonium using nitrate (denitrification)
                         - (p_sed_poc_denit)*(0.8)*max(0.0,min(1.0,t_no3_with_atmos_ship_N/max(0.00000000001,t_no3))) & ! recycling of sedimentary poc to dic using nitrate (denitrification)
                         - (p_sed_pocn_denit_wiN2)*(5.3)*max(0.0,min(1.0,t_no3_with_atmos_ship_N/max(0.00000000001,t_no3))) & ! recycling of sedimentary pocn to dic and NH4 using nitrate (denitrification)
                         - (p_sed_pocp_denit)*(84.8)*max(0.0,min(1.0,t_no3_with_atmos_ship_N/max(0.00000000001,t_no3))) & ! recycling of sedimentary pocp to dic and PO4 using nitrate (denitrification)
                      )

                      change_btf_t_ipw           = change_btf_t_ipw           + cgt_timestep*(0.0 &
                         + p_ips_ero_ipw                & ! erosion of iron PO4
                         + p_ips_biores_ipw             & ! bio resuspension of iron PO4
                         - p_ipw_sedi_ips               & ! sedimentation of iron PO4
                      )

                      change_btf_t_pocn_with_atmos_tot_N = change_btf_t_pocn_with_atmos_tot_N + cgt_timestep*(0.0 &
                         + p_sed_ero_pocn_atmos_tot_N   & ! sedimentary pocn erosion; sub-process for atmos_tot nitrogen
                         + p_sed_biores_pocn_atmos_tot_N & ! bio resuspension of sedimentary pocn; sub-process for atmos_tot nitrogen
                         - p_pocn_sedi_sed*max(0.0,min(1.0,t_pocn_with_atmos_tot_N/max(0.00000000001,t_pocn))) & ! pocn sedimentation
                         - p_sed_pocn_sulf*max(0.0,min(1.0,t_pocn_with_atmos_tot_N/max(0.00000000001,t_pocn))) & ! recycling of sedimentary pocn to dic and NH4 using sulfate (sulfate reduction)
                      )

                      change_btf_t_det_with_atmos_tot_N = change_btf_t_det_with_atmos_tot_N + cgt_timestep*(0.0 &
                         + p_sed_ero_det_atmos_tot_N    & ! sedimentary detritus erosion; sub-process for atmos_tot nitrogen
                         + p_sed_biores_det_atmos_tot_N & ! bio resuspension of sedimentary detritus; sub-process for atmos_tot nitrogen
                         - p_det_sedi_sed*max(0.0,min(1.0,t_det_with_atmos_tot_N/max(0.00000000001,t_det))) & ! detritus sedimentation
                      )

                      change_btf_t_det           = change_btf_t_det           + cgt_timestep*(0.0 &
                         + p_sed_ero_det                & ! sedimentary detritus erosion
                         + p_sed_biores_det             & ! bio resuspension of sedimentary detritus
                         - p_det_sedi_sed               & ! detritus sedimentation
                      )

                      change_btf_t_poc           = change_btf_t_poc           + cgt_timestep*(0.0 &
                         + p_sed_ero_poc                & ! sedimentary poc erosion
                         + p_sed_biores_poc             & ! bio resuspension of sedimentary poc
                         - p_poc_sedi_sed               & ! poc sedimentation
                      )

                      change_btf_t_pocp          = change_btf_t_pocp          + cgt_timestep*(0.0 &
                         + p_sed_ero_pocp               & ! sedimentary pocp erosion
                         + p_sed_biores_pocp            & ! bio resuspension of sedimentary pocp
                         - p_pocp_sedi_sed              & ! pocp sedimentation
                         - p_sed_pocp_sulf              & ! recycling of sedimentary pocp to dic and PO4 using sulfate (sulfate reduction)
                      )

                      change_btf_t_pocn          = change_btf_t_pocn          + cgt_timestep*(0.0 &
                         + p_sed_ero_pocn               & ! sedimentary pocn erosion
                         + p_sed_biores_pocn            & ! bio resuspension of sedimentary pocn
                         - p_pocn_sedi_sed              & ! pocn sedimentation
                         - p_sed_pocn_sulf              & ! recycling of sedimentary pocn to dic and NH4 using sulfate (sulfate reduction)
                      )

                      change_btf_t_pocn_with_atmos_ship_N = change_btf_t_pocn_with_atmos_ship_N + cgt_timestep*(0.0 &
                         + p_sed_ero_pocn_atmos_ship_N  & ! sedimentary pocn erosion; sub-process for atmos_ship nitrogen
                         + p_sed_biores_pocn_atmos_ship_N & ! bio resuspension of sedimentary pocn; sub-process for atmos_ship nitrogen
                         - p_pocn_sedi_sed*max(0.0,min(1.0,t_pocn_with_atmos_ship_N/max(0.00000000001,t_pocn))) & ! pocn sedimentation
                         - p_sed_pocn_sulf*max(0.0,min(1.0,t_pocn_with_atmos_ship_N/max(0.00000000001,t_pocn))) & ! recycling of sedimentary pocn to dic and NH4 using sulfate (sulfate reduction)
                      )

                      change_btf_t_det_with_atmos_ship_N = change_btf_t_det_with_atmos_ship_N + cgt_timestep*(0.0 &
                         + p_sed_ero_det_atmos_ship_N   & ! sedimentary detritus erosion; sub-process for atmos_ship nitrogen
                         + p_sed_biores_det_atmos_ship_N & ! bio resuspension of sedimentary detritus; sub-process for atmos_ship nitrogen
                         - p_det_sedi_sed*max(0.0,min(1.0,t_det_with_atmos_ship_N/max(0.00000000001,t_det))) & ! detritus sedimentation
                      )
                   else

                      change_of_t_n2            = change_of_t_n2            + cgt_timestep*(0.0 &
                         + (p_nh4_nitdenit_n2)*(0.5)/(cgt_cellheight*cgt_density) & ! coupled nitrification and denitrification after mineralization of detritus in oxic sediments
                         + (p_sed_denit_nh4_wiN2)*(2.65)/(cgt_cellheight*cgt_density) & ! recycling of sedimentary detritus to ammonium using nitrate (denitrification)
                         + (p_sed_poc_denit)*(0.4)/(cgt_cellheight*cgt_density) & ! recycling of sedimentary poc to dic using nitrate (denitrification)
                         + (p_sed_pocn_denit_wiN2)*(2.65)/(cgt_cellheight*cgt_density) & ! recycling of sedimentary pocn to dic and NH4 using nitrate (denitrification)
                         + (p_sed_pocp_denit)*(42.4)/(cgt_cellheight*cgt_density) & ! recycling of sedimentary pocp to dic and PO4 using nitrate (denitrification)
                         + (p_nh4_nitdenit_pocn_n2)*(0.5)/(cgt_cellheight*cgt_density) & ! coupled nitrification and denitrification after mineralization of pocn-detritus in oxic sediments
                      )

                      change_of_t_o2            = change_of_t_o2            + cgt_timestep*(0.0 &
                         - (p_sed_resp_nh4)*(6.625)/(cgt_cellheight*cgt_density) & ! recycling of sedimentary detritus to ammonium using oxygen (respiration)
                         - (p_nh4_nitdenit_n2)*(0.75)/(cgt_cellheight*cgt_density) & ! coupled nitrification and denitrification after mineralization of detritus in oxic sediments
                         - p_sed_poc_resp/(cgt_cellheight*cgt_density) & ! recycling of sedimentary poc to dic using oxygen (respiration)
                         - (p_sed_pocn_resp)*(6.625)/(cgt_cellheight*cgt_density) & ! recycling of sedimentary pocn to dic and NH4 using oxygen (respiration)
                         - (p_sed_pocp_resp)*(106)/(cgt_cellheight*cgt_density) & ! recycling of sedimentary pocp to dic and PO4 using oxygen (respiration)
                         - (p_nh4_nitdenit_pocn_n2)*(0.75)/(cgt_cellheight*cgt_density) & ! coupled nitrification and denitrification after mineralization of pocn-detritus in oxic sediments
                      )

                      change_of_t_dic           = change_of_t_dic           + cgt_timestep*(0.0 &
                         + (p_sed_resp_nh4)*(rfr_c)/(cgt_cellheight*cgt_density) & ! recycling of sedimentary detritus to ammonium using oxygen (respiration)
                         + (p_sed_denit_nh4_noN2)*(rfr_c)/(cgt_cellheight*cgt_density) & ! recycling of sedimentary detritus to ammonium using nitrate (denitrification)
                         + (p_sed_sulf_nh4)*(rfr_c)/(cgt_cellheight*cgt_density) & ! recycling of sedimentary detritus to ammonium using sulfate (sulfate reduction)
                         + p_sed_poc_resp/(cgt_cellheight*cgt_density) & ! recycling of sedimentary poc to dic using oxygen (respiration)
                         + p_sed_poc_denit/(cgt_cellheight*cgt_density) & ! recycling of sedimentary poc to dic using nitrate (denitrification)
                         + p_sed_poc_sulf/(cgt_cellheight*cgt_density) & ! recycling of sedimentary poc to dic using sulfate (sulfate reduction)
                         + (p_sed_pocn_resp)*(6.625)/(cgt_cellheight*cgt_density) & ! recycling of sedimentary pocn to dic and NH4 using oxygen (respiration)
                         + (p_sed_pocp_resp)*(106)/(cgt_cellheight*cgt_density) & ! recycling of sedimentary pocp to dic and PO4 using oxygen (respiration)
                         + (p_sed_pocn_denit_noN2)*(6.625)/(cgt_cellheight*cgt_density) & ! recycling of sedimentary pocn to dic and NH4 using nitrate (denitrification)
                         + (p_sed_pocp_denit)*(106)/(cgt_cellheight*cgt_density) & ! recycling of sedimentary pocp to dic and PO4 using nitrate (denitrification)
                         + (p_sed_pocn_sulf)*(6.625)/(cgt_cellheight*cgt_density) & ! recycling of sedimentary pocn to dic and NH4 using sulfate (sulfate reduction)
                         + (p_sed_pocp_sulf)*(106)/(cgt_cellheight*cgt_density) & ! recycling of sedimentary pocp to dic and PO4 using sulfate (sulfate reduction)
                      )

                      change_of_t_nh4           = change_of_t_nh4           + cgt_timestep*(0.0 &
                         + p_sed_resp_nh4/(cgt_cellheight*cgt_density) & ! recycling of sedimentary detritus to ammonium using oxygen (respiration)
                         + p_sed_denit_nh4_noN2/(cgt_cellheight*cgt_density) & ! recycling of sedimentary detritus to ammonium using nitrate (denitrification)
                         + p_sed_sulf_nh4/(cgt_cellheight*cgt_density) & ! recycling of sedimentary detritus to ammonium using sulfate (sulfate reduction)
                         + p_sed_pocn_resp/(cgt_cellheight*cgt_density) & ! recycling of sedimentary pocn to dic and NH4 using oxygen (respiration)
                         + p_sed_pocn_denit_noN2/(cgt_cellheight*cgt_density) & ! recycling of sedimentary pocn to dic and NH4 using nitrate (denitrification)
                         + p_sed_pocn_sulf/(cgt_cellheight*cgt_density) & ! recycling of sedimentary pocn to dic and NH4 using sulfate (sulfate reduction)
                         - p_nh4_nitdenit_n2/(cgt_cellheight*cgt_density) & ! coupled nitrification and denitrification after mineralization of detritus in oxic sediments
                         - p_nh4_nitdenit_pocn_n2/(cgt_cellheight*cgt_density) & ! coupled nitrification and denitrification after mineralization of pocn-detritus in oxic sediments
                      )

                      change_of_t_no3           = change_of_t_no3           + cgt_timestep*(0.0 &
                         - (p_sed_denit_nh4_wiN2)*(5.3)/(cgt_cellheight*cgt_density) & ! recycling of sedimentary detritus to ammonium using nitrate (denitrification)
                         - (p_sed_poc_denit)*(0.8)/(cgt_cellheight*cgt_density) & ! recycling of sedimentary poc to dic using nitrate (denitrification)
                         - (p_sed_pocn_denit_wiN2)*(5.3)/(cgt_cellheight*cgt_density) & ! recycling of sedimentary pocn to dic and NH4 using nitrate (denitrification)
                         - (p_sed_pocp_denit)*(84.8)/(cgt_cellheight*cgt_density) & ! recycling of sedimentary pocp to dic and PO4 using nitrate (denitrification)
                      )

                      change_of_t_po4           = change_of_t_po4           + cgt_timestep*(0.0 &
                         + (p_sed_resp_nh4)*(rfr_p)/(cgt_cellheight*cgt_density) & ! recycling of sedimentary detritus to ammonium using oxygen (respiration)
                         + (p_sed_denit_nh4_noN2)*(rfr_p)/(cgt_cellheight*cgt_density) & ! recycling of sedimentary detritus to ammonium using nitrate (denitrification)
                         + (p_sed_sulf_nh4)*(rfr_p)/(cgt_cellheight*cgt_density) & ! recycling of sedimentary detritus to ammonium using sulfate (sulfate reduction)
                         + p_ips_liber_po4/(cgt_cellheight*cgt_density) & ! liberation of phosphate from the sediment under anoxic conditions
                         + p_sed_pocp_resp/(cgt_cellheight*cgt_density) & ! recycling of sedimentary pocp to dic and PO4 using oxygen (respiration)
                         + p_sed_pocp_denit/(cgt_cellheight*cgt_density) & ! recycling of sedimentary pocp to dic and PO4 using nitrate (denitrification)
                         + p_sed_pocp_sulf/(cgt_cellheight*cgt_density) & ! recycling of sedimentary pocp to dic and PO4 using sulfate (sulfate reduction)
                         - (p_po4_retent_ips)*(rfr_p)/(cgt_cellheight*cgt_density) & ! retention of phosphate in the sediment under oxic conditions
                      )

                      change_of_t_h2s           = change_of_t_h2s           + cgt_timestep*(0.0 &
                         + (p_sed_sulf_nh4)*(3.3125)/(cgt_cellheight*cgt_density) & ! recycling of sedimentary detritus to ammonium using sulfate (sulfate reduction)
                         + (p_sed_poc_sulf)*(0.5)/(cgt_cellheight*cgt_density) & ! recycling of sedimentary poc to dic using sulfate (sulfate reduction)
                         + (p_sed_pocn_sulf)*(3.3125)/(cgt_cellheight*cgt_density) & ! recycling of sedimentary pocn to dic and NH4 using sulfate (sulfate reduction)
                         + (p_sed_pocp_sulf)*(53)/(cgt_cellheight*cgt_density) & ! recycling of sedimentary pocp to dic and PO4 using sulfate (sulfate reduction)
                      )

                      change_of_t_alk           = change_of_t_alk           + cgt_timestep*(0.0 &
                         + (1)*(p_sed_pocn_resp)*(0.5)/(cgt_cellheight*cgt_density) & ! recycling of sedimentary pocn to dic and NH4 using oxygen (respiration) (produces ohminus)
                         + (1)*(p_sed_pocn_denit_noN2)*(0.5)/(cgt_cellheight*cgt_density) & ! recycling of sedimentary pocn to dic and NH4 using nitrate (denitrification) (produces ohminus)
                         + (1)*(p_sed_pocn_sulf)*(0.5)/(cgt_cellheight*cgt_density) & ! recycling of sedimentary pocn to dic and NH4 using sulfate (sulfate reduction) (produces ohminus)
                         - (1)*(p_sed_pocp_denit)*(3)/(cgt_cellheight*cgt_density) & ! recycling of sedimentary pocp to dic and PO4 using nitrate (denitrification) (consumes ohminus)
                         - (1)*(p_sed_pocp_sulf)*(3)/(cgt_cellheight*cgt_density) & ! recycling of sedimentary pocp to dic and PO4 using sulfate (sulfate reduction) (consumes ohminus)
                         + (-1)*(p_nh4_nitdenit_n2)/(cgt_cellheight*cgt_density) & ! coupled nitrification and denitrification after mineralization of detritus in oxic sediments (produces h3oplus)
                         + (-1)*(p_sed_pocp_resp)*(3)/(cgt_cellheight*cgt_density) & ! recycling of sedimentary pocp to dic and PO4 using oxygen (respiration) (produces h3oplus)
                         + (-1)*(p_nh4_nitdenit_pocn_n2)/(cgt_cellheight*cgt_density) & ! coupled nitrification and denitrification after mineralization of pocn-detritus in oxic sediments (produces h3oplus)
                         - (-1)*(p_sed_resp_nh4)*(0.8125)/(cgt_cellheight*cgt_density) & ! recycling of sedimentary detritus to ammonium using oxygen (respiration) (consumes h3oplus)
                         - (-1)*(p_sed_denit_nh4_noN2)*(6.1125)/(cgt_cellheight*cgt_density) & ! recycling of sedimentary detritus to ammonium using nitrate (denitrification) (consumes h3oplus)
                         - (-1)*(p_sed_sulf_nh4)*(7.4375)/(cgt_cellheight*cgt_density) & ! recycling of sedimentary detritus to ammonium using sulfate (sulfate reduction) (consumes h3oplus)
                         - (-1)*(p_sed_poc_denit)*(0.8)/(cgt_cellheight*cgt_density) & ! recycling of sedimentary poc to dic using nitrate (denitrification) (consumes h3oplus)
                         - (-1)*(p_sed_poc_sulf)/(cgt_cellheight*cgt_density) & ! recycling of sedimentary poc to dic using sulfate (sulfate reduction) (consumes h3oplus)
                         - (-1)*(p_sed_pocn_resp)*(0.5)/(cgt_cellheight*cgt_density) & ! recycling of sedimentary pocn to dic and NH4 using oxygen (respiration) (consumes h3oplus)
                         - (-1)*(p_sed_pocp_denit)*(84.8)/(cgt_cellheight*cgt_density) & ! recycling of sedimentary pocp to dic and PO4 using nitrate (denitrification) (consumes h3oplus)
                         - (-1)*(p_sed_pocn_sulf)*(7.125)/(cgt_cellheight*cgt_density) & ! recycling of sedimentary pocn to dic and NH4 using sulfate (sulfate reduction) (consumes h3oplus)
                         - (-1)*(p_sed_pocp_sulf)*(106)/(cgt_cellheight*cgt_density) & ! recycling of sedimentary pocp to dic and PO4 using sulfate (sulfate reduction) (consumes h3oplus)
                         + (2)*(p_sed_resp_nh4)*(rfr_p)/(cgt_cellheight*cgt_density) & ! recycling of sedimentary detritus to ammonium using oxygen (respiration) (produces t_po4)
                         + (2)*(p_sed_denit_nh4_noN2)*(rfr_p)/(cgt_cellheight*cgt_density) & ! recycling of sedimentary detritus to ammonium using nitrate (denitrification) (produces t_po4)
                         + (2)*(p_sed_sulf_nh4)*(rfr_p)/(cgt_cellheight*cgt_density) & ! recycling of sedimentary detritus to ammonium using sulfate (sulfate reduction) (produces t_po4)
                         + (2)*(p_ips_liber_po4)/(cgt_cellheight*cgt_density) & ! liberation of phosphate from the sediment under anoxic conditions (produces t_po4)
                         + (2)*(p_sed_pocp_resp)/(cgt_cellheight*cgt_density) & ! recycling of sedimentary pocp to dic and PO4 using oxygen (respiration) (produces t_po4)
                         + (2)*(p_sed_pocp_denit)/(cgt_cellheight*cgt_density) & ! recycling of sedimentary pocp to dic and PO4 using nitrate (denitrification) (produces t_po4)
                         + (2)*(p_sed_pocp_sulf)/(cgt_cellheight*cgt_density) & ! recycling of sedimentary pocp to dic and PO4 using sulfate (sulfate reduction) (produces t_po4)
                         - (2)*(p_po4_retent_ips)*(rfr_p)/(cgt_cellheight*cgt_density) & ! retention of phosphate in the sediment under oxic conditions (consumes t_po4)
                      )

                      change_of_t_nh4_with_atmos_tot_N = change_of_t_nh4_with_atmos_tot_N + cgt_timestep*(0.0 &
                         + p_sed_resp_nh4_atmos_tot_N/(cgt_cellheight*cgt_density) & ! recycling of sedimentary detritus to ammonium using oxygen (respiration); sub-process for atmos_tot nitrogen
                         + p_sed_denit_nh4_noN2_atmos_tot_N/(cgt_cellheight*cgt_density) & ! recycling of sedimentary detritus to ammonium using nitrate (denitrification); sub-process for atmos_tot nitrogen
                         + p_sed_sulf_nh4_atmos_tot_N/(cgt_cellheight*cgt_density) & ! recycling of sedimentary detritus to ammonium using sulfate (sulfate reduction); sub-process for atmos_tot nitrogen
                         + p_sed_pocn_resp_atmos_tot_N/(cgt_cellheight*cgt_density) & ! recycling of sedimentary pocn to dic and NH4 using oxygen (respiration); sub-process for atmos_tot nitrogen
                         + p_sed_pocn_denit_noN2_atmos_tot_N/(cgt_cellheight*cgt_density) & ! recycling of sedimentary pocn to dic and NH4 using nitrate (denitrification); sub-process for atmos_tot nitrogen
                         + p_sed_pocn_sulf_atmos_tot_N/(cgt_cellheight*cgt_density) & ! recycling of sedimentary pocn to dic and NH4 using sulfate (sulfate reduction); sub-process for atmos_tot nitrogen
                         - p_nh4_nitdenit_n2/(cgt_cellheight*cgt_density)*max(0.0,min(1.0,t_nh4_with_atmos_tot_N/max(0.00000000001,t_nh4))) & ! coupled nitrification and denitrification after mineralization of detritus in oxic sediments
                         - p_nh4_nitdenit_pocn_n2/(cgt_cellheight*cgt_density)*max(0.0,min(1.0,t_nh4_with_atmos_tot_N/max(0.00000000001,t_nh4))) & ! coupled nitrification and denitrification after mineralization of pocn-detritus in oxic sediments
                      )

                      change_of_t_no3_with_atmos_tot_N = change_of_t_no3_with_atmos_tot_N + cgt_timestep*(0.0 &
                         - (p_sed_denit_nh4_wiN2)*(5.3)/(cgt_cellheight*cgt_density)*max(0.0,min(1.0,t_no3_with_atmos_tot_N/max(0.00000000001,t_no3))) & ! recycling of sedimentary detritus to ammonium using nitrate (denitrification)
                         - (p_sed_poc_denit)*(0.8)/(cgt_cellheight*cgt_density)*max(0.0,min(1.0,t_no3_with_atmos_tot_N/max(0.00000000001,t_no3))) & ! recycling of sedimentary poc to dic using nitrate (denitrification)
                         - (p_sed_pocn_denit_wiN2)*(5.3)/(cgt_cellheight*cgt_density)*max(0.0,min(1.0,t_no3_with_atmos_tot_N/max(0.00000000001,t_no3))) & ! recycling of sedimentary pocn to dic and NH4 using nitrate (denitrification)
                         - (p_sed_pocp_denit)*(84.8)/(cgt_cellheight*cgt_density)*max(0.0,min(1.0,t_no3_with_atmos_tot_N/max(0.00000000001,t_no3))) & ! recycling of sedimentary pocp to dic and PO4 using nitrate (denitrification)
                      )

                      change_of_t_nh4_with_atmos_ship_N = change_of_t_nh4_with_atmos_ship_N + cgt_timestep*(0.0 &
                         + p_sed_resp_nh4_atmos_ship_N/(cgt_cellheight*cgt_density) & ! recycling of sedimentary detritus to ammonium using oxygen (respiration); sub-process for atmos_ship nitrogen
                         + p_sed_denit_nh4_noN2_atmos_ship_N/(cgt_cellheight*cgt_density) & ! recycling of sedimentary detritus to ammonium using nitrate (denitrification); sub-process for atmos_ship nitrogen
                         + p_sed_sulf_nh4_atmos_ship_N/(cgt_cellheight*cgt_density) & ! recycling of sedimentary detritus to ammonium using sulfate (sulfate reduction); sub-process for atmos_ship nitrogen
                         + p_sed_pocn_resp_atmos_ship_N/(cgt_cellheight*cgt_density) & ! recycling of sedimentary pocn to dic and NH4 using oxygen (respiration); sub-process for atmos_ship nitrogen
                         + p_sed_pocn_denit_noN2_atmos_ship_N/(cgt_cellheight*cgt_density) & ! recycling of sedimentary pocn to dic and NH4 using nitrate (denitrification); sub-process for atmos_ship nitrogen
                         + p_sed_pocn_sulf_atmos_ship_N/(cgt_cellheight*cgt_density) & ! recycling of sedimentary pocn to dic and NH4 using sulfate (sulfate reduction); sub-process for atmos_ship nitrogen
                         - p_nh4_nitdenit_n2/(cgt_cellheight*cgt_density)*max(0.0,min(1.0,t_nh4_with_atmos_ship_N/max(0.00000000001,t_nh4))) & ! coupled nitrification and denitrification after mineralization of detritus in oxic sediments
                         - p_nh4_nitdenit_pocn_n2/(cgt_cellheight*cgt_density)*max(0.0,min(1.0,t_nh4_with_atmos_ship_N/max(0.00000000001,t_nh4))) & ! coupled nitrification and denitrification after mineralization of pocn-detritus in oxic sediments
                      )

                      change_of_t_no3_with_atmos_ship_N = change_of_t_no3_with_atmos_ship_N + cgt_timestep*(0.0 &
                         - (p_sed_denit_nh4_wiN2)*(5.3)/(cgt_cellheight*cgt_density)*max(0.0,min(1.0,t_no3_with_atmos_ship_N/max(0.00000000001,t_no3))) & ! recycling of sedimentary detritus to ammonium using nitrate (denitrification)
                         - (p_sed_poc_denit)*(0.8)/(cgt_cellheight*cgt_density)*max(0.0,min(1.0,t_no3_with_atmos_ship_N/max(0.00000000001,t_no3))) & ! recycling of sedimentary poc to dic using nitrate (denitrification)
                         - (p_sed_pocn_denit_wiN2)*(5.3)/(cgt_cellheight*cgt_density)*max(0.0,min(1.0,t_no3_with_atmos_ship_N/max(0.00000000001,t_no3))) & ! recycling of sedimentary pocn to dic and NH4 using nitrate (denitrification)
                         - (p_sed_pocp_denit)*(84.8)/(cgt_cellheight*cgt_density)*max(0.0,min(1.0,t_no3_with_atmos_ship_N/max(0.00000000001,t_no3))) & ! recycling of sedimentary pocp to dic and PO4 using nitrate (denitrification)
                      )

                      change_of_t_ipw           = change_of_t_ipw           + cgt_timestep*(0.0 &
                         + p_ips_ero_ipw/(cgt_cellheight*cgt_density) & ! erosion of iron PO4
                         + p_ips_biores_ipw/(cgt_cellheight*cgt_density) & ! bio resuspension of iron PO4
                         - p_ipw_sedi_ips/(cgt_cellheight*cgt_density) & ! sedimentation of iron PO4
                      )

                      change_of_t_pocn_with_atmos_tot_N = change_of_t_pocn_with_atmos_tot_N + cgt_timestep*(0.0 &
                         + p_sed_ero_pocn_atmos_tot_N/(cgt_cellheight*cgt_density) & ! sedimentary pocn erosion; sub-process for atmos_tot nitrogen
                         + p_sed_biores_pocn_atmos_tot_N/(cgt_cellheight*cgt_density) & ! bio resuspension of sedimentary pocn; sub-process for atmos_tot nitrogen
                         - p_pocn_sedi_sed/(cgt_cellheight*cgt_density)*max(0.0,min(1.0,t_pocn_with_atmos_tot_N/max(0.00000000001,t_pocn))) & ! pocn sedimentation
                         - p_sed_pocn_sulf/(cgt_cellheight*cgt_density)*max(0.0,min(1.0,t_pocn_with_atmos_tot_N/max(0.00000000001,t_pocn))) & ! recycling of sedimentary pocn to dic and NH4 using sulfate (sulfate reduction)
                      )

                      change_of_t_det_with_atmos_tot_N = change_of_t_det_with_atmos_tot_N + cgt_timestep*(0.0 &
                         + p_sed_ero_det_atmos_tot_N/(cgt_cellheight*cgt_density) & ! sedimentary detritus erosion; sub-process for atmos_tot nitrogen
                         + p_sed_biores_det_atmos_tot_N/(cgt_cellheight*cgt_density) & ! bio resuspension of sedimentary detritus; sub-process for atmos_tot nitrogen
                         - p_det_sedi_sed/(cgt_cellheight*cgt_density)*max(0.0,min(1.0,t_det_with_atmos_tot_N/max(0.00000000001,t_det))) & ! detritus sedimentation
                      )

                      change_of_t_det           = change_of_t_det           + cgt_timestep*(0.0 &
                         + p_sed_ero_det/(cgt_cellheight*cgt_density) & ! sedimentary detritus erosion
                         + p_sed_biores_det/(cgt_cellheight*cgt_density) & ! bio resuspension of sedimentary detritus
                         - p_det_sedi_sed/(cgt_cellheight*cgt_density) & ! detritus sedimentation
                      )

                      change_of_t_poc           = change_of_t_poc           + cgt_timestep*(0.0 &
                         + p_sed_ero_poc/(cgt_cellheight*cgt_density) & ! sedimentary poc erosion
                         + p_sed_biores_poc/(cgt_cellheight*cgt_density) & ! bio resuspension of sedimentary poc
                         - p_poc_sedi_sed/(cgt_cellheight*cgt_density) & ! poc sedimentation
                      )

                      change_of_t_pocp          = change_of_t_pocp          + cgt_timestep*(0.0 &
                         + p_sed_ero_pocp/(cgt_cellheight*cgt_density) & ! sedimentary pocp erosion
                         + p_sed_biores_pocp/(cgt_cellheight*cgt_density) & ! bio resuspension of sedimentary pocp
                         - p_pocp_sedi_sed/(cgt_cellheight*cgt_density) & ! pocp sedimentation
                         - p_sed_pocp_sulf/(cgt_cellheight*cgt_density) & ! recycling of sedimentary pocp to dic and PO4 using sulfate (sulfate reduction)
                      )

                      change_of_t_pocn          = change_of_t_pocn          + cgt_timestep*(0.0 &
                         + p_sed_ero_pocn/(cgt_cellheight*cgt_density) & ! sedimentary pocn erosion
                         + p_sed_biores_pocn/(cgt_cellheight*cgt_density) & ! bio resuspension of sedimentary pocn
                         - p_pocn_sedi_sed/(cgt_cellheight*cgt_density) & ! pocn sedimentation
                         - p_sed_pocn_sulf/(cgt_cellheight*cgt_density) & ! recycling of sedimentary pocn to dic and NH4 using sulfate (sulfate reduction)
                      )

                      change_of_t_pocn_with_atmos_ship_N = change_of_t_pocn_with_atmos_ship_N + cgt_timestep*(0.0 &
                         + p_sed_ero_pocn_atmos_ship_N/(cgt_cellheight*cgt_density) & ! sedimentary pocn erosion; sub-process for atmos_ship nitrogen
                         + p_sed_biores_pocn_atmos_ship_N/(cgt_cellheight*cgt_density) & ! bio resuspension of sedimentary pocn; sub-process for atmos_ship nitrogen
                         - p_pocn_sedi_sed/(cgt_cellheight*cgt_density)*max(0.0,min(1.0,t_pocn_with_atmos_ship_N/max(0.00000000001,t_pocn))) & ! pocn sedimentation
                         - p_sed_pocn_sulf/(cgt_cellheight*cgt_density)*max(0.0,min(1.0,t_pocn_with_atmos_ship_N/max(0.00000000001,t_pocn))) & ! recycling of sedimentary pocn to dic and NH4 using sulfate (sulfate reduction)
                      )

                      change_of_t_det_with_atmos_ship_N = change_of_t_det_with_atmos_ship_N + cgt_timestep*(0.0 &
                         + p_sed_ero_det_atmos_ship_N/(cgt_cellheight*cgt_density) & ! sedimentary detritus erosion; sub-process for atmos_ship nitrogen
                         + p_sed_biores_det_atmos_ship_N/(cgt_cellheight*cgt_density) & ! bio resuspension of sedimentary detritus; sub-process for atmos_ship nitrogen
                         - p_det_sedi_sed/(cgt_cellheight*cgt_density)*max(0.0,min(1.0,t_det_with_atmos_ship_N/max(0.00000000001,t_det))) & ! detritus sedimentation
                      )
                   endif

                   change_of_t_sed           = change_of_t_sed           + cgt_timestep*(0.0 &
                      + p_det_sedi_sed               & ! detritus sedimentation
                      - p_sed_resp_nh4               & ! recycling of sedimentary detritus to ammonium using oxygen (respiration)
                      - p_sed_denit_nh4_noN2         & ! recycling of sedimentary detritus to ammonium using nitrate (denitrification)
                      - p_sed_sulf_nh4               & ! recycling of sedimentary detritus to ammonium using sulfate (sulfate reduction)
                      - p_sed_ero_det                & ! sedimentary detritus erosion
                      - p_sed_biores_det             & ! bio resuspension of sedimentary detritus
                      - p_sed_burial                 & ! burial of detritus deeper than max_sed
                   )

                   change_of_t_ips           = change_of_t_ips           + cgt_timestep*(0.0 &
                      + (p_po4_retent_ips)*(rfr_p)   & ! retention of phosphate in the sediment under oxic conditions
                      + p_ipw_sedi_ips               & ! sedimentation of iron PO4
                      - p_ips_liber_po4              & ! liberation of phosphate from the sediment under anoxic conditions
                      - p_ips_ero_ipw                & ! erosion of iron PO4
                      - p_ips_biores_ipw             & ! bio resuspension of iron PO4
                      - p_ips_burial                 & ! burial of iron PO4
                   )

                   change_of_t_sed_poc       = change_of_t_sed_poc       + cgt_timestep*(0.0 &
                      + p_poc_sedi_sed               & ! poc sedimentation
                      - p_sed_poc_resp               & ! recycling of sedimentary poc to dic using oxygen (respiration)
                      - p_sed_poc_denit              & ! recycling of sedimentary poc to dic using nitrate (denitrification)
                      - p_sed_poc_sulf               & ! recycling of sedimentary poc to dic using sulfate (sulfate reduction)
                      - p_sed_ero_poc                & ! sedimentary poc erosion
                      - p_sed_biores_poc             & ! bio resuspension of sedimentary poc
                      - p_poc_burial                 & ! burial of poc deeper than max_sed
                   )

                   change_of_t_sed_pocn      = change_of_t_sed_pocn      + cgt_timestep*(0.0 &
                      + p_pocn_sedi_sed              & ! pocn sedimentation
                      - p_sed_ero_pocn               & ! sedimentary pocn erosion
                      - p_sed_biores_pocn            & ! bio resuspension of sedimentary pocn
                      - p_pocn_burial                & ! burial of pocn deeper than max_sed
                      - p_sed_pocn_resp              & ! recycling of sedimentary pocn to dic and NH4 using oxygen (respiration)
                      - p_sed_pocn_denit_noN2        & ! recycling of sedimentary pocn to dic and NH4 using nitrate (denitrification)
                   )

                   change_of_t_sed_pocp      = change_of_t_sed_pocp      + cgt_timestep*(0.0 &
                      + p_pocp_sedi_sed              & ! pocp sedimentation
                      - p_sed_ero_pocp               & ! sedimentary pocp erosion
                      - p_sed_biores_pocp            & ! bio resuspension of sedimentary pocp
                      - p_pocp_burial                & ! burial of pocp deeper than max_sed
                      - p_sed_pocp_resp              & ! recycling of sedimentary pocp to dic and PO4 using oxygen (respiration)
                      - p_sed_pocp_denit             & ! recycling of sedimentary pocp to dic and PO4 using nitrate (denitrification)
                   )

                   change_of_t_sed_with_atmos_tot_N = change_of_t_sed_with_atmos_tot_N + cgt_timestep*(0.0 &
                      + p_det_sedi_sed_atmos_tot_N   & ! detritus sedimentation; sub-process for atmos_tot nitrogen
                      - p_sed_resp_nh4*max(0.0,min(1.0,t_sed_with_atmos_tot_N/max(0.00000000001,t_sed))) & ! recycling of sedimentary detritus to ammonium using oxygen (respiration)
                      - p_sed_denit_nh4_noN2*max(0.0,min(1.0,t_sed_with_atmos_tot_N/max(0.00000000001,t_sed))) & ! recycling of sedimentary detritus to ammonium using nitrate (denitrification)
                      - p_sed_sulf_nh4*max(0.0,min(1.0,t_sed_with_atmos_tot_N/max(0.00000000001,t_sed))) & ! recycling of sedimentary detritus to ammonium using sulfate (sulfate reduction)
                      - p_sed_ero_det*max(0.0,min(1.0,t_sed_with_atmos_tot_N/max(0.00000000001,t_sed))) & ! sedimentary detritus erosion
                      - p_sed_biores_det*max(0.0,min(1.0,t_sed_with_atmos_tot_N/max(0.00000000001,t_sed))) & ! bio resuspension of sedimentary detritus
                      - p_sed_burial*max(0.0,min(1.0,t_sed_with_atmos_tot_N/max(0.00000000001,t_sed))) & ! burial of detritus deeper than max_sed
                   )

                   change_of_t_sed_pocn_with_atmos_tot_N = change_of_t_sed_pocn_with_atmos_tot_N + cgt_timestep*(0.0 &
                      + p_pocn_sedi_sed_atmos_tot_N  & ! pocn sedimentation; sub-process for atmos_tot nitrogen
                      - p_sed_ero_pocn*max(0.0,min(1.0,t_sed_pocn_with_atmos_tot_N/max(0.00000000001,t_sed_pocn))) & ! sedimentary pocn erosion
                      - p_sed_biores_pocn*max(0.0,min(1.0,t_sed_pocn_with_atmos_tot_N/max(0.00000000001,t_sed_pocn))) & ! bio resuspension of sedimentary pocn
                      - p_pocn_burial*max(0.0,min(1.0,t_sed_pocn_with_atmos_tot_N/max(0.00000000001,t_sed_pocn))) & ! burial of pocn deeper than max_sed
                      - p_sed_pocn_resp*max(0.0,min(1.0,t_sed_pocn_with_atmos_tot_N/max(0.00000000001,t_sed_pocn))) & ! recycling of sedimentary pocn to dic and NH4 using oxygen (respiration)
                      - p_sed_pocn_denit_noN2*max(0.0,min(1.0,t_sed_pocn_with_atmos_tot_N/max(0.00000000001,t_sed_pocn))) & ! recycling of sedimentary pocn to dic and NH4 using nitrate (denitrification)
                   )

                   change_of_t_sed_with_atmos_ship_N = change_of_t_sed_with_atmos_ship_N + cgt_timestep*(0.0 &
                      + p_det_sedi_sed_atmos_ship_N  & ! detritus sedimentation; sub-process for atmos_ship nitrogen
                      - p_sed_resp_nh4*max(0.0,min(1.0,t_sed_with_atmos_ship_N/max(0.00000000001,t_sed))) & ! recycling of sedimentary detritus to ammonium using oxygen (respiration)
                      - p_sed_denit_nh4_noN2*max(0.0,min(1.0,t_sed_with_atmos_ship_N/max(0.00000000001,t_sed))) & ! recycling of sedimentary detritus to ammonium using nitrate (denitrification)
                      - p_sed_sulf_nh4*max(0.0,min(1.0,t_sed_with_atmos_ship_N/max(0.00000000001,t_sed))) & ! recycling of sedimentary detritus to ammonium using sulfate (sulfate reduction)
                      - p_sed_ero_det*max(0.0,min(1.0,t_sed_with_atmos_ship_N/max(0.00000000001,t_sed))) & ! sedimentary detritus erosion
                      - p_sed_biores_det*max(0.0,min(1.0,t_sed_with_atmos_ship_N/max(0.00000000001,t_sed))) & ! bio resuspension of sedimentary detritus
                      - p_sed_burial*max(0.0,min(1.0,t_sed_with_atmos_ship_N/max(0.00000000001,t_sed))) & ! burial of detritus deeper than max_sed
                   )

                   change_of_t_sed_pocn_with_atmos_ship_N = change_of_t_sed_pocn_with_atmos_ship_N + cgt_timestep*(0.0 &
                      + p_pocn_sedi_sed_atmos_ship_N & ! pocn sedimentation; sub-process for atmos_ship nitrogen
                      - p_sed_ero_pocn*max(0.0,min(1.0,t_sed_pocn_with_atmos_ship_N/max(0.00000000001,t_sed_pocn))) & ! sedimentary pocn erosion
                      - p_sed_biores_pocn*max(0.0,min(1.0,t_sed_pocn_with_atmos_ship_N/max(0.00000000001,t_sed_pocn))) & ! bio resuspension of sedimentary pocn
                      - p_pocn_burial*max(0.0,min(1.0,t_sed_pocn_with_atmos_ship_N/max(0.00000000001,t_sed_pocn))) & ! burial of pocn deeper than max_sed
                      - p_sed_pocn_resp*max(0.0,min(1.0,t_sed_pocn_with_atmos_ship_N/max(0.00000000001,t_sed_pocn))) & ! recycling of sedimentary pocn to dic and NH4 using oxygen (respiration)
                      - p_sed_pocn_denit_noN2*max(0.0,min(1.0,t_sed_pocn_with_atmos_ship_N/max(0.00000000001,t_sed_pocn))) & ! recycling of sedimentary pocn to dic and NH4 using nitrate (denitrification)
                   )

                endif

                !------------------------------------
                ! STEP 6.7.6: calculate maximum fraction of the timestep before some tracer gets exhausted
                !------------------------------------

                timestep_fraction = 1.0
                which_tracer_exhausted = -1

                ! find the tracer which is exhausted after the shortest period of time

                ! in the water column

                ! check if tracer t_n2            was exhausted from the beginning and is still consumed
                if ((ergom%t_n2           (i,j,k,tau) .le. 0.0) .and. (change_of_t_n2             .lt. 0.0)) then
                   timestep_fraction = 0.0
                   which_tracer_exhausted = 1
                endif
                ! check if tracer t_n2            was present, but got exhausted
                if ((ergom%t_n2           (i,j,k,tau) .gt. 0.0) .and. (ergom%t_n2           (i,j,k,tau) + change_of_t_n2            .lt. 0.0)) then
                   timestep_fraction_new = ergom%t_n2           (i,j,k,tau) / (0.0 - change_of_t_n2           )
                   if (timestep_fraction_new .le. timestep_fraction) then
                      which_tracer_exhausted = 1
                      timestep_fraction = timestep_fraction_new
                   endif
                endif

                ! check if tracer t_o2            was exhausted from the beginning and is still consumed
                if ((ergom%t_o2           (i,j,k,tau) .le. 0.0) .and. (change_of_t_o2             .lt. 0.0)) then
                   timestep_fraction = 0.0
                   which_tracer_exhausted = 2
                endif
                ! check if tracer t_o2            was present, but got exhausted
                if ((ergom%t_o2           (i,j,k,tau) .gt. 0.0) .and. (ergom%t_o2           (i,j,k,tau) + change_of_t_o2            .lt. 0.0)) then
                   timestep_fraction_new = ergom%t_o2           (i,j,k,tau) / (0.0 - change_of_t_o2           )
                   if (timestep_fraction_new .le. timestep_fraction) then
                      which_tracer_exhausted = 2
                      timestep_fraction = timestep_fraction_new
                   endif
                endif

                ! check if tracer t_dic           was exhausted from the beginning and is still consumed
                if ((ergom%t_dic          (i,j,k,tau) .le. 0.0) .and. (change_of_t_dic            .lt. 0.0)) then
                   timestep_fraction = 0.0
                   which_tracer_exhausted = 3
                endif
                ! check if tracer t_dic           was present, but got exhausted
                if ((ergom%t_dic          (i,j,k,tau) .gt. 0.0) .and. (ergom%t_dic          (i,j,k,tau) + change_of_t_dic           .lt. 0.0)) then
                   timestep_fraction_new = ergom%t_dic          (i,j,k,tau) / (0.0 - change_of_t_dic          )
                   if (timestep_fraction_new .le. timestep_fraction) then
                      which_tracer_exhausted = 3
                      timestep_fraction = timestep_fraction_new
                   endif
                endif

                ! check if tracer t_nh4           was exhausted from the beginning and is still consumed
                if ((ergom%t_nh4          (i,j,k,tau) .le. 0.0) .and. (change_of_t_nh4            .lt. 0.0)) then
                   timestep_fraction = 0.0
                   which_tracer_exhausted = 4
                endif
                ! check if tracer t_nh4           was present, but got exhausted
                if ((ergom%t_nh4          (i,j,k,tau) .gt. 0.0) .and. (ergom%t_nh4          (i,j,k,tau) + change_of_t_nh4           .lt. 0.0)) then
                   timestep_fraction_new = ergom%t_nh4          (i,j,k,tau) / (0.0 - change_of_t_nh4          )
                   if (timestep_fraction_new .le. timestep_fraction) then
                      which_tracer_exhausted = 4
                      timestep_fraction = timestep_fraction_new
                   endif
                endif

                ! check if tracer t_no3           was exhausted from the beginning and is still consumed
                if ((ergom%t_no3          (i,j,k,tau) .le. 0.0) .and. (change_of_t_no3            .lt. 0.0)) then
                   timestep_fraction = 0.0
                   which_tracer_exhausted = 5
                endif
                ! check if tracer t_no3           was present, but got exhausted
                if ((ergom%t_no3          (i,j,k,tau) .gt. 0.0) .and. (ergom%t_no3          (i,j,k,tau) + change_of_t_no3           .lt. 0.0)) then
                   timestep_fraction_new = ergom%t_no3          (i,j,k,tau) / (0.0 - change_of_t_no3          )
                   if (timestep_fraction_new .le. timestep_fraction) then
                      which_tracer_exhausted = 5
                      timestep_fraction = timestep_fraction_new
                   endif
                endif

                ! check if tracer t_po4           was exhausted from the beginning and is still consumed
                if ((ergom%t_po4          (i,j,k,tau) .le. 0.0) .and. (change_of_t_po4            .lt. 0.0)) then
                   timestep_fraction = 0.0
                   which_tracer_exhausted = 6
                endif
                ! check if tracer t_po4           was present, but got exhausted
                if ((ergom%t_po4          (i,j,k,tau) .gt. 0.0) .and. (ergom%t_po4          (i,j,k,tau) + change_of_t_po4           .lt. 0.0)) then
                   timestep_fraction_new = ergom%t_po4          (i,j,k,tau) / (0.0 - change_of_t_po4          )
                   if (timestep_fraction_new .le. timestep_fraction) then
                      which_tracer_exhausted = 6
                      timestep_fraction = timestep_fraction_new
                   endif
                endif

                ! check if tracer t_spp           was exhausted from the beginning and is still consumed
                if ((ergom%t_spp          (i,j,k,tau) .le. 0.0) .and. (change_of_t_spp            .lt. 0.0)) then
                   timestep_fraction = 0.0
                   which_tracer_exhausted = 7
                endif
                ! check if tracer t_spp           was present, but got exhausted
                if ((ergom%t_spp          (i,j,k,tau) .gt. 0.0) .and. (ergom%t_spp          (i,j,k,tau) + change_of_t_spp           .lt. 0.0)) then
                   timestep_fraction_new = ergom%t_spp          (i,j,k,tau) / (0.0 - change_of_t_spp          )
                   if (timestep_fraction_new .le. timestep_fraction) then
                      which_tracer_exhausted = 7
                      timestep_fraction = timestep_fraction_new
                   endif
                endif

                ! check if tracer t_zoo           was exhausted from the beginning and is still consumed
                if ((ergom%t_zoo          (i,j,k,tau) .le. 0.0) .and. (change_of_t_zoo            .lt. 0.0)) then
                   timestep_fraction = 0.0
                   which_tracer_exhausted = 8
                endif
                ! check if tracer t_zoo           was present, but got exhausted
                if ((ergom%t_zoo          (i,j,k,tau) .gt. 0.0) .and. (ergom%t_zoo          (i,j,k,tau) + change_of_t_zoo           .lt. 0.0)) then
                   timestep_fraction_new = ergom%t_zoo          (i,j,k,tau) / (0.0 - change_of_t_zoo          )
                   if (timestep_fraction_new .le. timestep_fraction) then
                      which_tracer_exhausted = 8
                      timestep_fraction = timestep_fraction_new
                   endif
                endif

                ! check if tracer t_h2s           was exhausted from the beginning and is still consumed
                if ((ergom%t_h2s          (i,j,k,tau) .le. 0.0) .and. (change_of_t_h2s            .lt. 0.0)) then
                   timestep_fraction = 0.0
                   which_tracer_exhausted = 9
                endif
                ! check if tracer t_h2s           was present, but got exhausted
                if ((ergom%t_h2s          (i,j,k,tau) .gt. 0.0) .and. (ergom%t_h2s          (i,j,k,tau) + change_of_t_h2s           .lt. 0.0)) then
                   timestep_fraction_new = ergom%t_h2s          (i,j,k,tau) / (0.0 - change_of_t_h2s          )
                   if (timestep_fraction_new .le. timestep_fraction) then
                      which_tracer_exhausted = 9
                      timestep_fraction = timestep_fraction_new
                   endif
                endif

                ! check if tracer t_sul           was exhausted from the beginning and is still consumed
                if ((ergom%t_sul          (i,j,k,tau) .le. 0.0) .and. (change_of_t_sul            .lt. 0.0)) then
                   timestep_fraction = 0.0
                   which_tracer_exhausted = 10
                endif
                ! check if tracer t_sul           was present, but got exhausted
                if ((ergom%t_sul          (i,j,k,tau) .gt. 0.0) .and. (ergom%t_sul          (i,j,k,tau) + change_of_t_sul           .lt. 0.0)) then
                   timestep_fraction_new = ergom%t_sul          (i,j,k,tau) / (0.0 - change_of_t_sul          )
                   if (timestep_fraction_new .le. timestep_fraction) then
                      which_tracer_exhausted = 10
                      timestep_fraction = timestep_fraction_new
                   endif
                endif

                ! check if tracer t_doc           was exhausted from the beginning and is still consumed
                if ((ergom%t_doc          (i,j,k,tau) .le. 0.0) .and. (change_of_t_doc            .lt. 0.0)) then
                   timestep_fraction = 0.0
                   which_tracer_exhausted = 14
                endif
                ! check if tracer t_doc           was present, but got exhausted
                if ((ergom%t_doc          (i,j,k,tau) .gt. 0.0) .and. (ergom%t_doc          (i,j,k,tau) + change_of_t_doc           .lt. 0.0)) then
                   timestep_fraction_new = ergom%t_doc          (i,j,k,tau) / (0.0 - change_of_t_doc          )
                   if (timestep_fraction_new .le. timestep_fraction) then
                      which_tracer_exhausted = 14
                      timestep_fraction = timestep_fraction_new
                   endif
                endif

                ! check if tracer t_dop           was exhausted from the beginning and is still consumed
                if ((ergom%t_dop          (i,j,k,tau) .le. 0.0) .and. (change_of_t_dop            .lt. 0.0)) then
                   timestep_fraction = 0.0
                   which_tracer_exhausted = 15
                endif
                ! check if tracer t_dop           was present, but got exhausted
                if ((ergom%t_dop          (i,j,k,tau) .gt. 0.0) .and. (ergom%t_dop          (i,j,k,tau) + change_of_t_dop           .lt. 0.0)) then
                   timestep_fraction_new = ergom%t_dop          (i,j,k,tau) / (0.0 - change_of_t_dop          )
                   if (timestep_fraction_new .le. timestep_fraction) then
                      which_tracer_exhausted = 15
                      timestep_fraction = timestep_fraction_new
                   endif
                endif

                ! check if tracer t_ipw           was exhausted from the beginning and is still consumed
                if ((ergom%t_ipw          (i,j,k,tau) .le. 0.0) .and. (change_of_t_ipw            .lt. 0.0)) then
                   timestep_fraction = 0.0
                   which_tracer_exhausted = 37
                endif
                ! check if tracer t_ipw           was present, but got exhausted
                if ((ergom%t_ipw          (i,j,k,tau) .gt. 0.0) .and. (ergom%t_ipw          (i,j,k,tau) + change_of_t_ipw           .lt. 0.0)) then
                   timestep_fraction_new = ergom%t_ipw          (i,j,k,tau) / (0.0 - change_of_t_ipw          )
                   if (timestep_fraction_new .le. timestep_fraction) then
                      which_tracer_exhausted = 37
                      timestep_fraction = timestep_fraction_new
                   endif
                endif

                ! check if tracer t_lpp           was exhausted from the beginning and is still consumed
                if ((ergom%t_lpp          (i,j,k,tau) .le. 0.0) .and. (change_of_t_lpp            .lt. 0.0)) then
                   timestep_fraction = 0.0
                   which_tracer_exhausted = 43
                endif
                ! check if tracer t_lpp           was present, but got exhausted
                if ((ergom%t_lpp          (i,j,k,tau) .gt. 0.0) .and. (ergom%t_lpp          (i,j,k,tau) + change_of_t_lpp           .lt. 0.0)) then
                   timestep_fraction_new = ergom%t_lpp          (i,j,k,tau) / (0.0 - change_of_t_lpp          )
                   if (timestep_fraction_new .le. timestep_fraction) then
                      which_tracer_exhausted = 43
                      timestep_fraction = timestep_fraction_new
                   endif
                endif

                ! check if tracer t_don           was exhausted from the beginning and is still consumed
                if ((ergom%t_don          (i,j,k,tau) .le. 0.0) .and. (change_of_t_don            .lt. 0.0)) then
                   timestep_fraction = 0.0
                   which_tracer_exhausted = 44
                endif
                ! check if tracer t_don           was present, but got exhausted
                if ((ergom%t_don          (i,j,k,tau) .gt. 0.0) .and. (ergom%t_don          (i,j,k,tau) + change_of_t_don           .lt. 0.0)) then
                   timestep_fraction_new = ergom%t_don          (i,j,k,tau) / (0.0 - change_of_t_don          )
                   if (timestep_fraction_new .le. timestep_fraction) then
                      which_tracer_exhausted = 44
                      timestep_fraction = timestep_fraction_new
                   endif
                endif

                ! check if tracer t_cya           was exhausted from the beginning and is still consumed
                if ((ergom%t_cya          (i,j,k,tau) .le. 0.0) .and. (change_of_t_cya            .lt. 0.0)) then
                   timestep_fraction = 0.0
                   which_tracer_exhausted = 45
                endif
                ! check if tracer t_cya           was present, but got exhausted
                if ((ergom%t_cya          (i,j,k,tau) .gt. 0.0) .and. (ergom%t_cya          (i,j,k,tau) + change_of_t_cya           .lt. 0.0)) then
                   timestep_fraction_new = ergom%t_cya          (i,j,k,tau) / (0.0 - change_of_t_cya          )
                   if (timestep_fraction_new .le. timestep_fraction) then
                      which_tracer_exhausted = 45
                      timestep_fraction = timestep_fraction_new
                   endif
                endif

                ! check if tracer t_det           was exhausted from the beginning and is still consumed
                if ((ergom%t_det          (i,j,k,tau) .le. 0.0) .and. (change_of_t_det            .lt. 0.0)) then
                   timestep_fraction = 0.0
                   which_tracer_exhausted = 46
                endif
                ! check if tracer t_det           was present, but got exhausted
                if ((ergom%t_det          (i,j,k,tau) .gt. 0.0) .and. (ergom%t_det          (i,j,k,tau) + change_of_t_det           .lt. 0.0)) then
                   timestep_fraction_new = ergom%t_det          (i,j,k,tau) / (0.0 - change_of_t_det          )
                   if (timestep_fraction_new .le. timestep_fraction) then
                      which_tracer_exhausted = 46
                      timestep_fraction = timestep_fraction_new
                   endif
                endif

                ! check if tracer t_poc           was exhausted from the beginning and is still consumed
                if ((ergom%t_poc          (i,j,k,tau) .le. 0.0) .and. (change_of_t_poc            .lt. 0.0)) then
                   timestep_fraction = 0.0
                   which_tracer_exhausted = 47
                endif
                ! check if tracer t_poc           was present, but got exhausted
                if ((ergom%t_poc          (i,j,k,tau) .gt. 0.0) .and. (ergom%t_poc          (i,j,k,tau) + change_of_t_poc           .lt. 0.0)) then
                   timestep_fraction_new = ergom%t_poc          (i,j,k,tau) / (0.0 - change_of_t_poc          )
                   if (timestep_fraction_new .le. timestep_fraction) then
                      which_tracer_exhausted = 47
                      timestep_fraction = timestep_fraction_new
                   endif
                endif

                ! check if tracer t_pocp          was exhausted from the beginning and is still consumed
                if ((ergom%t_pocp         (i,j,k,tau) .le. 0.0) .and. (change_of_t_pocp           .lt. 0.0)) then
                   timestep_fraction = 0.0
                   which_tracer_exhausted = 48
                endif
                ! check if tracer t_pocp          was present, but got exhausted
                if ((ergom%t_pocp         (i,j,k,tau) .gt. 0.0) .and. (ergom%t_pocp         (i,j,k,tau) + change_of_t_pocp          .lt. 0.0)) then
                   timestep_fraction_new = ergom%t_pocp         (i,j,k,tau) / (0.0 - change_of_t_pocp         )
                   if (timestep_fraction_new .le. timestep_fraction) then
                      which_tracer_exhausted = 48
                      timestep_fraction = timestep_fraction_new
                   endif
                endif

                ! check if tracer t_pocn          was exhausted from the beginning and is still consumed
                if ((ergom%t_pocn         (i,j,k,tau) .le. 0.0) .and. (change_of_t_pocn           .lt. 0.0)) then
                   timestep_fraction = 0.0
                   which_tracer_exhausted = 49
                endif
                ! check if tracer t_pocn          was present, but got exhausted
                if ((ergom%t_pocn         (i,j,k,tau) .gt. 0.0) .and. (ergom%t_pocn         (i,j,k,tau) + change_of_t_pocn          .lt. 0.0)) then
                   timestep_fraction_new = ergom%t_pocn         (i,j,k,tau) / (0.0 - change_of_t_pocn         )
                   if (timestep_fraction_new .le. timestep_fraction) then
                      which_tracer_exhausted = 49
                      timestep_fraction = timestep_fraction_new
                   endif
                endif

                ! in the bottom layer
                if (k == grid_kmt(i,j)) then

                   ! check if tracer t_sed           was exhausted from the beginning and is still consumed
                   if ((ergom%t_sed          (i,j) .le. 0.0) .and. (change_of_t_sed           .lt. 0.0)) then
                      timestep_fraction = 0.0
                      which_tracer_exhausted = 12
                   endif
                   ! check if tracer t_sed           was present, but got exhausted
                   if ((ergom%t_sed          (i,j) .gt. 0.0) .and. (ergom%t_sed          (i,j) + change_of_t_sed           .lt. 0.0)) then
                      timestep_fraction_new = ergom%t_sed          (i,j) / (0.0 - change_of_t_sed          )
                      if (timestep_fraction_new .le. timestep_fraction) then
                         which_tracer_exhausted = 12
                         timestep_fraction = timestep_fraction_new
                      endif
                   endif

                   ! check if tracer t_ips           was exhausted from the beginning and is still consumed
                   if ((ergom%t_ips          (i,j) .le. 0.0) .and. (change_of_t_ips           .lt. 0.0)) then
                      timestep_fraction = 0.0
                      which_tracer_exhausted = 13
                   endif
                   ! check if tracer t_ips           was present, but got exhausted
                   if ((ergom%t_ips          (i,j) .gt. 0.0) .and. (ergom%t_ips          (i,j) + change_of_t_ips           .lt. 0.0)) then
                      timestep_fraction_new = ergom%t_ips          (i,j) / (0.0 - change_of_t_ips          )
                      if (timestep_fraction_new .le. timestep_fraction) then
                         which_tracer_exhausted = 13
                         timestep_fraction = timestep_fraction_new
                      endif
                   endif

                   ! check if tracer t_sed_poc       was exhausted from the beginning and is still consumed
                   if ((ergom%t_sed_poc      (i,j) .le. 0.0) .and. (change_of_t_sed_poc       .lt. 0.0)) then
                      timestep_fraction = 0.0
                      which_tracer_exhausted = 16
                   endif
                   ! check if tracer t_sed_poc       was present, but got exhausted
                   if ((ergom%t_sed_poc      (i,j) .gt. 0.0) .and. (ergom%t_sed_poc      (i,j) + change_of_t_sed_poc       .lt. 0.0)) then
                      timestep_fraction_new = ergom%t_sed_poc      (i,j) / (0.0 - change_of_t_sed_poc      )
                      if (timestep_fraction_new .le. timestep_fraction) then
                         which_tracer_exhausted = 16
                         timestep_fraction = timestep_fraction_new
                      endif
                   endif

                   ! check if tracer t_sed_pocn      was exhausted from the beginning and is still consumed
                   if ((ergom%t_sed_pocn     (i,j) .le. 0.0) .and. (change_of_t_sed_pocn      .lt. 0.0)) then
                      timestep_fraction = 0.0
                      which_tracer_exhausted = 17
                   endif
                   ! check if tracer t_sed_pocn      was present, but got exhausted
                   if ((ergom%t_sed_pocn     (i,j) .gt. 0.0) .and. (ergom%t_sed_pocn     (i,j) + change_of_t_sed_pocn      .lt. 0.0)) then
                      timestep_fraction_new = ergom%t_sed_pocn     (i,j) / (0.0 - change_of_t_sed_pocn     )
                      if (timestep_fraction_new .le. timestep_fraction) then
                         which_tracer_exhausted = 17
                         timestep_fraction = timestep_fraction_new
                      endif
                   endif

                   ! check if tracer t_sed_pocp      was exhausted from the beginning and is still consumed
                   if ((ergom%t_sed_pocp     (i,j) .le. 0.0) .and. (change_of_t_sed_pocp      .lt. 0.0)) then
                      timestep_fraction = 0.0
                      which_tracer_exhausted = 18
                   endif
                   ! check if tracer t_sed_pocp      was present, but got exhausted
                   if ((ergom%t_sed_pocp     (i,j) .gt. 0.0) .and. (ergom%t_sed_pocp     (i,j) + change_of_t_sed_pocp      .lt. 0.0)) then
                      timestep_fraction_new = ergom%t_sed_pocp     (i,j) / (0.0 - change_of_t_sed_pocp     )
                      if (timestep_fraction_new .le. timestep_fraction) then
                         which_tracer_exhausted = 18
                         timestep_fraction = timestep_fraction_new
                      endif
                   endif
                endif

                !------------------------------------
                ! STEP 6.7.7: update the limitations: processes limited by this tracer become zero in the future
                !------------------------------------

                if (1 .eq. which_tracer_exhausted) then
                   lim_t_n2_7           = 0.0
                endif
                if (2 .eq. which_tracer_exhausted) then
                   lim_t_o2_0           = 0.0
                   lim_t_o2_2           = 0.0
                   lim_t_o2_4           = 0.0
                   lim_t_o2_6           = 0.0
                endif
                if (3 .eq. which_tracer_exhausted) then
                   lim_t_dic_8          = 0.0
                endif
                if (4 .eq. which_tracer_exhausted) then
                   lim_t_nh4_11         = 0.0
                endif
                if (5 .eq. which_tracer_exhausted) then
                   lim_t_no3_1          = 0.0
                   lim_t_no3_3          = 0.0
                   lim_t_no3_10         = 0.0
                endif
                if (6 .eq. which_tracer_exhausted) then
                   lim_t_po4_9          = 0.0
                endif
                if (7 .eq. which_tracer_exhausted) then
                   lim_t_spp_16         = 0.0
                endif
                if (8 .eq. which_tracer_exhausted) then
                   lim_t_zoo_18         = 0.0
                endif
                if (9 .eq. which_tracer_exhausted) then
                   lim_t_h2s_5          = 0.0
                   lim_t_h2s_23         = 0.0
                endif
                if (10 .eq. which_tracer_exhausted) then
                   lim_t_sul_24         = 0.0
                endif
                if (12 .eq. which_tracer_exhausted) then
                   lim_t_sed_20         = 0.0
                endif
                if (13 .eq. which_tracer_exhausted) then
                   lim_t_ips_22         = 0.0
                endif
                if (14 .eq. which_tracer_exhausted) then
                   lim_t_doc_28         = 0.0
                endif
                if (15 .eq. which_tracer_exhausted) then
                   lim_t_dop_29         = 0.0
                endif
                if (16 .eq. which_tracer_exhausted) then
                   lim_t_sed_poc_21     = 0.0
                endif
                if (17 .eq. which_tracer_exhausted) then
                   lim_t_sed_pocn_26    = 0.0
                endif
                if (18 .eq. which_tracer_exhausted) then
                   lim_t_sed_pocp_27    = 0.0
                endif
                if (37 .eq. which_tracer_exhausted) then
                   lim_t_ipw_25         = 0.0
                endif
                if (43 .eq. which_tracer_exhausted) then
                   lim_t_lpp_15         = 0.0
                endif
                if (44 .eq. which_tracer_exhausted) then
                   lim_t_don_30         = 0.0
                endif
                if (45 .eq. which_tracer_exhausted) then
                   lim_t_cya_17         = 0.0
                endif
                if (46 .eq. which_tracer_exhausted) then
                   lim_t_det_19         = 0.0
                endif
                if (47 .eq. which_tracer_exhausted) then
                   lim_t_poc_12         = 0.0
                endif
                if (48 .eq. which_tracer_exhausted) then
                   lim_t_pocp_13        = 0.0
                endif
                if (49 .eq. which_tracer_exhausted) then
                   lim_t_pocn_14        = 0.0
                endif

                !------------------------------------
                ! STEP 6.7.8: apply a Euler-forward timestep with the fraction of the time
                !------------------------------------
                ! in the water column

                ! tracer t_n2            (dissolved molecular nitrogen):
                ergom%t_n2           (i,j,k,tau) = ergom%t_n2           (i,j,k,tau) + change_of_t_n2            * timestep_fraction

                ! tracer t_o2            (dissolved oxygen):
                ergom%t_o2           (i,j,k,tau) = ergom%t_o2           (i,j,k,tau) + change_of_t_o2            * timestep_fraction

                ! tracer t_dic           (dissolved inorganic carbon, treated as carbon dioxide):
                ergom%t_dic          (i,j,k,tau) = ergom%t_dic          (i,j,k,tau) + change_of_t_dic           * timestep_fraction

                ! tracer t_nh4           (ammonium):
                ergom%t_nh4          (i,j,k,tau) = ergom%t_nh4          (i,j,k,tau) + change_of_t_nh4           * timestep_fraction

                ! tracer t_no3           (nitrate):
                ergom%t_no3          (i,j,k,tau) = ergom%t_no3          (i,j,k,tau) + change_of_t_no3           * timestep_fraction

                ! tracer t_po4           (phosphate):
                ergom%t_po4          (i,j,k,tau) = ergom%t_po4          (i,j,k,tau) + change_of_t_po4           * timestep_fraction

                ! tracer t_spp           (small-cell phytoplankton):
                ergom%t_spp          (i,j,k,tau) = ergom%t_spp          (i,j,k,tau) + change_of_t_spp           * timestep_fraction

                ! tracer t_zoo           (zooplankton):
                ergom%t_zoo          (i,j,k,tau) = ergom%t_zoo          (i,j,k,tau) + change_of_t_zoo           * timestep_fraction

                ! tracer t_h2s           (hydrogen sulfide):
                ergom%t_h2s          (i,j,k,tau) = ergom%t_h2s          (i,j,k,tau) + change_of_t_h2s           * timestep_fraction

                ! tracer t_sul           (sulfur):
                ergom%t_sul          (i,j,k,tau) = ergom%t_sul          (i,j,k,tau) + change_of_t_sul           * timestep_fraction

                ! tracer t_alk           (total alkalinity):
                ergom%t_alk          (i,j,k,tau) = ergom%t_alk          (i,j,k,tau) + change_of_t_alk           * timestep_fraction

                ! tracer t_doc           (dissolved organic carbon):
                ergom%t_doc          (i,j,k,tau) = ergom%t_doc          (i,j,k,tau) + change_of_t_doc           * timestep_fraction

                ! tracer t_dop           (phosphorus in dissolved organic carbon in Redfield ratio):
                ergom%t_dop          (i,j,k,tau) = ergom%t_dop          (i,j,k,tau) + change_of_t_dop           * timestep_fraction

                ! tracer total_atmos_tot_N (total_atmos_tot_N):
                ergom%total_atmos_tot_N(i,j,k,tau) = ergom%total_atmos_tot_N(i,j,k,tau) + change_of_total_atmos_tot_N * timestep_fraction

                ! tracer total_atmos_ship_N (total_atmos_ship_N):
                ergom%total_atmos_ship_N(i,j,k,tau) = ergom%total_atmos_ship_N(i,j,k,tau) + change_of_total_atmos_ship_N * timestep_fraction

                ! tracer t_n2_with_atmos_tot_N (dissolved molecular nitrogen; containing nitrogen from (total) atmospheric deposition):
                ergom%t_n2_with_atmos_tot_N(i,j,k,tau) = ergom%t_n2_with_atmos_tot_N(i,j,k,tau) + change_of_t_n2_with_atmos_tot_N * timestep_fraction

                ! tracer t_nh4_with_atmos_tot_N (ammonium; containing nitrogen from (total) atmospheric deposition):
                ergom%t_nh4_with_atmos_tot_N(i,j,k,tau) = ergom%t_nh4_with_atmos_tot_N(i,j,k,tau) + change_of_t_nh4_with_atmos_tot_N * timestep_fraction

                ! tracer t_no3_with_atmos_tot_N (nitrate; containing nitrogen from (total) atmospheric deposition):
                ergom%t_no3_with_atmos_tot_N(i,j,k,tau) = ergom%t_no3_with_atmos_tot_N(i,j,k,tau) + change_of_t_no3_with_atmos_tot_N * timestep_fraction

                ! tracer t_spp_with_atmos_tot_N (small-cell phytoplankton; containing nitrogen from (total) atmospheric deposition):
                ergom%t_spp_with_atmos_tot_N(i,j,k,tau) = ergom%t_spp_with_atmos_tot_N(i,j,k,tau) + change_of_t_spp_with_atmos_tot_N * timestep_fraction

                ! tracer t_zoo_with_atmos_tot_N (zooplankton; containing nitrogen from (total) atmospheric deposition):
                ergom%t_zoo_with_atmos_tot_N(i,j,k,tau) = ergom%t_zoo_with_atmos_tot_N(i,j,k,tau) + change_of_t_zoo_with_atmos_tot_N * timestep_fraction

                ! tracer t_n2_with_atmos_ship_N (dissolved molecular nitrogen; containing nitrogen from atmospheric deposition, which has been previously emitted by ships):
                ergom%t_n2_with_atmos_ship_N(i,j,k,tau) = ergom%t_n2_with_atmos_ship_N(i,j,k,tau) + change_of_t_n2_with_atmos_ship_N * timestep_fraction

                ! tracer t_nh4_with_atmos_ship_N (ammonium; containing nitrogen from atmospheric deposition, which has been previously emitted by ships):
                ergom%t_nh4_with_atmos_ship_N(i,j,k,tau) = ergom%t_nh4_with_atmos_ship_N(i,j,k,tau) + change_of_t_nh4_with_atmos_ship_N * timestep_fraction

                ! tracer t_no3_with_atmos_ship_N (nitrate; containing nitrogen from atmospheric deposition, which has been previously emitted by ships):
                ergom%t_no3_with_atmos_ship_N(i,j,k,tau) = ergom%t_no3_with_atmos_ship_N(i,j,k,tau) + change_of_t_no3_with_atmos_ship_N * timestep_fraction

                ! tracer t_spp_with_atmos_ship_N (small-cell phytoplankton; containing nitrogen from atmospheric deposition, which has been previously emitted by ships):
                ergom%t_spp_with_atmos_ship_N(i,j,k,tau) = ergom%t_spp_with_atmos_ship_N(i,j,k,tau) + change_of_t_spp_with_atmos_ship_N * timestep_fraction

                ! tracer t_zoo_with_atmos_ship_N (zooplankton; containing nitrogen from atmospheric deposition, which has been previously emitted by ships):
                ergom%t_zoo_with_atmos_ship_N(i,j,k,tau) = ergom%t_zoo_with_atmos_ship_N(i,j,k,tau) + change_of_t_zoo_with_atmos_ship_N * timestep_fraction

                ! tracer t_ipw           (suspended iron phosphate):
                ergom%t_ipw          (i,j,k,tau) = ergom%t_ipw          (i,j,k,tau) + change_of_t_ipw           * timestep_fraction

                ! tracer t_pocn_with_atmos_tot_N (nitrogen in particulate organic carbon in Redfield ratio; containing nitrogen from (total) atmospheric deposition):
                ergom%t_pocn_with_atmos_tot_N(i,j,k,tau) = ergom%t_pocn_with_atmos_tot_N(i,j,k,tau) + change_of_t_pocn_with_atmos_tot_N * timestep_fraction

                ! tracer t_lpp_with_atmos_tot_N (large-cell phytoplankton; containing nitrogen from (total) atmospheric deposition):
                ergom%t_lpp_with_atmos_tot_N(i,j,k,tau) = ergom%t_lpp_with_atmos_tot_N(i,j,k,tau) + change_of_t_lpp_with_atmos_tot_N * timestep_fraction

                ! tracer t_don_with_atmos_tot_N (nitrogen in dissolved organic carbon in Redfield ratio; containing nitrogen from (total) atmospheric deposition):
                ergom%t_don_with_atmos_tot_N(i,j,k,tau) = ergom%t_don_with_atmos_tot_N(i,j,k,tau) + change_of_t_don_with_atmos_tot_N * timestep_fraction

                ! tracer t_cya_with_atmos_tot_N (diazotroph cyanobacteria; containing nitrogen from (total) atmospheric deposition):
                ergom%t_cya_with_atmos_tot_N(i,j,k,tau) = ergom%t_cya_with_atmos_tot_N(i,j,k,tau) + change_of_t_cya_with_atmos_tot_N * timestep_fraction

                ! tracer t_det_with_atmos_tot_N (detritus; containing nitrogen from (total) atmospheric deposition):
                ergom%t_det_with_atmos_tot_N(i,j,k,tau) = ergom%t_det_with_atmos_tot_N(i,j,k,tau) + change_of_t_det_with_atmos_tot_N * timestep_fraction

                ! tracer t_lpp           (large-cell phytoplankton):
                ergom%t_lpp          (i,j,k,tau) = ergom%t_lpp          (i,j,k,tau) + change_of_t_lpp           * timestep_fraction

                ! tracer t_don           (nitrogen in dissolved organic carbon in Redfield ratio):
                ergom%t_don          (i,j,k,tau) = ergom%t_don          (i,j,k,tau) + change_of_t_don           * timestep_fraction

                ! tracer t_cya           (diazotroph cyanobacteria):
                ergom%t_cya          (i,j,k,tau) = ergom%t_cya          (i,j,k,tau) + change_of_t_cya           * timestep_fraction

                ! tracer t_det           (detritus):
                ergom%t_det          (i,j,k,tau) = ergom%t_det          (i,j,k,tau) + change_of_t_det           * timestep_fraction

                ! tracer t_poc           (particulate organic carbon):
                ergom%t_poc          (i,j,k,tau) = ergom%t_poc          (i,j,k,tau) + change_of_t_poc           * timestep_fraction

                ! tracer t_pocp          (phosphorus in particulate organic carbon in Redfield ratio):
                ergom%t_pocp         (i,j,k,tau) = ergom%t_pocp         (i,j,k,tau) + change_of_t_pocp          * timestep_fraction

                ! tracer t_pocn          (nitrogen in particulate organic carbon in Redfield ratio):
                ergom%t_pocn         (i,j,k,tau) = ergom%t_pocn         (i,j,k,tau) + change_of_t_pocn          * timestep_fraction

                ! tracer t_pocn_with_atmos_ship_N (nitrogen in particulate organic carbon in Redfield ratio; containing nitrogen from atmospheric deposition, which has been previously emitted by ships):
                ergom%t_pocn_with_atmos_ship_N(i,j,k,tau) = ergom%t_pocn_with_atmos_ship_N(i,j,k,tau) + change_of_t_pocn_with_atmos_ship_N * timestep_fraction

                ! tracer t_lpp_with_atmos_ship_N (large-cell phytoplankton; containing nitrogen from atmospheric deposition, which has been previously emitted by ships):
                ergom%t_lpp_with_atmos_ship_N(i,j,k,tau) = ergom%t_lpp_with_atmos_ship_N(i,j,k,tau) + change_of_t_lpp_with_atmos_ship_N * timestep_fraction

                ! tracer t_don_with_atmos_ship_N (nitrogen in dissolved organic carbon in Redfield ratio; containing nitrogen from atmospheric deposition, which has been previously emitted by ships):
                ergom%t_don_with_atmos_ship_N(i,j,k,tau) = ergom%t_don_with_atmos_ship_N(i,j,k,tau) + change_of_t_don_with_atmos_ship_N * timestep_fraction

                ! tracer t_cya_with_atmos_ship_N (diazotroph cyanobacteria; containing nitrogen from atmospheric deposition, which has been previously emitted by ships):
                ergom%t_cya_with_atmos_ship_N(i,j,k,tau) = ergom%t_cya_with_atmos_ship_N(i,j,k,tau) + change_of_t_cya_with_atmos_ship_N * timestep_fraction

                ! tracer t_det_with_atmos_ship_N (detritus; containing nitrogen from atmospheric deposition, which has been previously emitted by ships):
                ergom%t_det_with_atmos_ship_N(i,j,k,tau) = ergom%t_det_with_atmos_ship_N(i,j,k,tau) + change_of_t_det_with_atmos_ship_N * timestep_fraction
                if (implicit_bottomfluxes) then

                ! tracer t_n2            (dissolved molecular nitrogen):
                ergom%btf_t_n2           (i,j) = ergom%btf_t_n2           (i,j) + change_btf_t_n2            * timestep_fraction

                ! tracer t_o2            (dissolved oxygen):
                ergom%btf_t_o2           (i,j) = ergom%btf_t_o2           (i,j) + change_btf_t_o2            * timestep_fraction

                ! tracer t_dic           (dissolved inorganic carbon, treated as carbon dioxide):
                ergom%btf_t_dic          (i,j) = ergom%btf_t_dic          (i,j) + change_btf_t_dic           * timestep_fraction

                ! tracer t_nh4           (ammonium):
                ergom%btf_t_nh4          (i,j) = ergom%btf_t_nh4          (i,j) + change_btf_t_nh4           * timestep_fraction

                ! tracer t_no3           (nitrate):
                ergom%btf_t_no3          (i,j) = ergom%btf_t_no3          (i,j) + change_btf_t_no3           * timestep_fraction

                ! tracer t_po4           (phosphate):
                ergom%btf_t_po4          (i,j) = ergom%btf_t_po4          (i,j) + change_btf_t_po4           * timestep_fraction

                ! tracer t_spp           (small-cell phytoplankton):
                ergom%btf_t_spp          (i,j) = ergom%btf_t_spp          (i,j) + change_btf_t_spp           * timestep_fraction

                ! tracer t_zoo           (zooplankton):
                ergom%btf_t_zoo          (i,j) = ergom%btf_t_zoo          (i,j) + change_btf_t_zoo           * timestep_fraction

                ! tracer t_h2s           (hydrogen sulfide):
                ergom%btf_t_h2s          (i,j) = ergom%btf_t_h2s          (i,j) + change_btf_t_h2s           * timestep_fraction

                ! tracer t_sul           (sulfur):
                ergom%btf_t_sul          (i,j) = ergom%btf_t_sul          (i,j) + change_btf_t_sul           * timestep_fraction

                ! tracer t_alk           (total alkalinity):
                ergom%btf_t_alk          (i,j) = ergom%btf_t_alk          (i,j) + change_btf_t_alk           * timestep_fraction

                ! tracer t_doc           (dissolved organic carbon):
                ergom%btf_t_doc          (i,j) = ergom%btf_t_doc          (i,j) + change_btf_t_doc           * timestep_fraction

                ! tracer t_dop           (phosphorus in dissolved organic carbon in Redfield ratio):
                ergom%btf_t_dop          (i,j) = ergom%btf_t_dop          (i,j) + change_btf_t_dop           * timestep_fraction

                ! tracer total_atmos_tot_N (total_atmos_tot_N):
                ergom%btf_total_atmos_tot_N(i,j) = ergom%btf_total_atmos_tot_N(i,j) + change_btf_total_atmos_tot_N * timestep_fraction

                ! tracer total_atmos_ship_N (total_atmos_ship_N):
                ergom%btf_total_atmos_ship_N(i,j) = ergom%btf_total_atmos_ship_N(i,j) + change_btf_total_atmos_ship_N * timestep_fraction

                ! tracer t_n2_with_atmos_tot_N (dissolved molecular nitrogen; containing nitrogen from (total) atmospheric deposition):
                ergom%btf_t_n2_with_atmos_tot_N(i,j) = ergom%btf_t_n2_with_atmos_tot_N(i,j) + change_btf_t_n2_with_atmos_tot_N * timestep_fraction

                ! tracer t_nh4_with_atmos_tot_N (ammonium; containing nitrogen from (total) atmospheric deposition):
                ergom%btf_t_nh4_with_atmos_tot_N(i,j) = ergom%btf_t_nh4_with_atmos_tot_N(i,j) + change_btf_t_nh4_with_atmos_tot_N * timestep_fraction

                ! tracer t_no3_with_atmos_tot_N (nitrate; containing nitrogen from (total) atmospheric deposition):
                ergom%btf_t_no3_with_atmos_tot_N(i,j) = ergom%btf_t_no3_with_atmos_tot_N(i,j) + change_btf_t_no3_with_atmos_tot_N * timestep_fraction

                ! tracer t_spp_with_atmos_tot_N (small-cell phytoplankton; containing nitrogen from (total) atmospheric deposition):
                ergom%btf_t_spp_with_atmos_tot_N(i,j) = ergom%btf_t_spp_with_atmos_tot_N(i,j) + change_btf_t_spp_with_atmos_tot_N * timestep_fraction

                ! tracer t_zoo_with_atmos_tot_N (zooplankton; containing nitrogen from (total) atmospheric deposition):
                ergom%btf_t_zoo_with_atmos_tot_N(i,j) = ergom%btf_t_zoo_with_atmos_tot_N(i,j) + change_btf_t_zoo_with_atmos_tot_N * timestep_fraction

                ! tracer t_n2_with_atmos_ship_N (dissolved molecular nitrogen; containing nitrogen from atmospheric deposition, which has been previously emitted by ships):
                ergom%btf_t_n2_with_atmos_ship_N(i,j) = ergom%btf_t_n2_with_atmos_ship_N(i,j) + change_btf_t_n2_with_atmos_ship_N * timestep_fraction

                ! tracer t_nh4_with_atmos_ship_N (ammonium; containing nitrogen from atmospheric deposition, which has been previously emitted by ships):
                ergom%btf_t_nh4_with_atmos_ship_N(i,j) = ergom%btf_t_nh4_with_atmos_ship_N(i,j) + change_btf_t_nh4_with_atmos_ship_N * timestep_fraction

                ! tracer t_no3_with_atmos_ship_N (nitrate; containing nitrogen from atmospheric deposition, which has been previously emitted by ships):
                ergom%btf_t_no3_with_atmos_ship_N(i,j) = ergom%btf_t_no3_with_atmos_ship_N(i,j) + change_btf_t_no3_with_atmos_ship_N * timestep_fraction

                ! tracer t_spp_with_atmos_ship_N (small-cell phytoplankton; containing nitrogen from atmospheric deposition, which has been previously emitted by ships):
                ergom%btf_t_spp_with_atmos_ship_N(i,j) = ergom%btf_t_spp_with_atmos_ship_N(i,j) + change_btf_t_spp_with_atmos_ship_N * timestep_fraction

                ! tracer t_zoo_with_atmos_ship_N (zooplankton; containing nitrogen from atmospheric deposition, which has been previously emitted by ships):
                ergom%btf_t_zoo_with_atmos_ship_N(i,j) = ergom%btf_t_zoo_with_atmos_ship_N(i,j) + change_btf_t_zoo_with_atmos_ship_N * timestep_fraction

                ! tracer t_ipw           (suspended iron phosphate):
                ergom%btf_t_ipw          (i,j) = ergom%btf_t_ipw          (i,j) + change_btf_t_ipw           * timestep_fraction

                ! tracer t_pocn_with_atmos_tot_N (nitrogen in particulate organic carbon in Redfield ratio; containing nitrogen from (total) atmospheric deposition):
                ergom%btf_t_pocn_with_atmos_tot_N(i,j) = ergom%btf_t_pocn_with_atmos_tot_N(i,j) + change_btf_t_pocn_with_atmos_tot_N * timestep_fraction

                ! tracer t_lpp_with_atmos_tot_N (large-cell phytoplankton; containing nitrogen from (total) atmospheric deposition):
                ergom%btf_t_lpp_with_atmos_tot_N(i,j) = ergom%btf_t_lpp_with_atmos_tot_N(i,j) + change_btf_t_lpp_with_atmos_tot_N * timestep_fraction

                ! tracer t_don_with_atmos_tot_N (nitrogen in dissolved organic carbon in Redfield ratio; containing nitrogen from (total) atmospheric deposition):
                ergom%btf_t_don_with_atmos_tot_N(i,j) = ergom%btf_t_don_with_atmos_tot_N(i,j) + change_btf_t_don_with_atmos_tot_N * timestep_fraction

                ! tracer t_cya_with_atmos_tot_N (diazotroph cyanobacteria; containing nitrogen from (total) atmospheric deposition):
                ergom%btf_t_cya_with_atmos_tot_N(i,j) = ergom%btf_t_cya_with_atmos_tot_N(i,j) + change_btf_t_cya_with_atmos_tot_N * timestep_fraction

                ! tracer t_det_with_atmos_tot_N (detritus; containing nitrogen from (total) atmospheric deposition):
                ergom%btf_t_det_with_atmos_tot_N(i,j) = ergom%btf_t_det_with_atmos_tot_N(i,j) + change_btf_t_det_with_atmos_tot_N * timestep_fraction

                ! tracer t_lpp           (large-cell phytoplankton):
                ergom%btf_t_lpp          (i,j) = ergom%btf_t_lpp          (i,j) + change_btf_t_lpp           * timestep_fraction

                ! tracer t_don           (nitrogen in dissolved organic carbon in Redfield ratio):
                ergom%btf_t_don          (i,j) = ergom%btf_t_don          (i,j) + change_btf_t_don           * timestep_fraction

                ! tracer t_cya           (diazotroph cyanobacteria):
                ergom%btf_t_cya          (i,j) = ergom%btf_t_cya          (i,j) + change_btf_t_cya           * timestep_fraction

                ! tracer t_det           (detritus):
                ergom%btf_t_det          (i,j) = ergom%btf_t_det          (i,j) + change_btf_t_det           * timestep_fraction

                ! tracer t_poc           (particulate organic carbon):
                ergom%btf_t_poc          (i,j) = ergom%btf_t_poc          (i,j) + change_btf_t_poc           * timestep_fraction

                ! tracer t_pocp          (phosphorus in particulate organic carbon in Redfield ratio):
                ergom%btf_t_pocp         (i,j) = ergom%btf_t_pocp         (i,j) + change_btf_t_pocp          * timestep_fraction

                ! tracer t_pocn          (nitrogen in particulate organic carbon in Redfield ratio):
                ergom%btf_t_pocn         (i,j) = ergom%btf_t_pocn         (i,j) + change_btf_t_pocn          * timestep_fraction

                ! tracer t_pocn_with_atmos_ship_N (nitrogen in particulate organic carbon in Redfield ratio; containing nitrogen from atmospheric deposition, which has been previously emitted by ships):
                ergom%btf_t_pocn_with_atmos_ship_N(i,j) = ergom%btf_t_pocn_with_atmos_ship_N(i,j) + change_btf_t_pocn_with_atmos_ship_N * timestep_fraction

                ! tracer t_lpp_with_atmos_ship_N (large-cell phytoplankton; containing nitrogen from atmospheric deposition, which has been previously emitted by ships):
                ergom%btf_t_lpp_with_atmos_ship_N(i,j) = ergom%btf_t_lpp_with_atmos_ship_N(i,j) + change_btf_t_lpp_with_atmos_ship_N * timestep_fraction

                ! tracer t_don_with_atmos_ship_N (nitrogen in dissolved organic carbon in Redfield ratio; containing nitrogen from atmospheric deposition, which has been previously emitted by ships):
                ergom%btf_t_don_with_atmos_ship_N(i,j) = ergom%btf_t_don_with_atmos_ship_N(i,j) + change_btf_t_don_with_atmos_ship_N * timestep_fraction

                ! tracer t_cya_with_atmos_ship_N (diazotroph cyanobacteria; containing nitrogen from atmospheric deposition, which has been previously emitted by ships):
                ergom%btf_t_cya_with_atmos_ship_N(i,j) = ergom%btf_t_cya_with_atmos_ship_N(i,j) + change_btf_t_cya_with_atmos_ship_N * timestep_fraction

                ! tracer t_det_with_atmos_ship_N (detritus; containing nitrogen from atmospheric deposition, which has been previously emitted by ships):
                ergom%btf_t_det_with_atmos_ship_N(i,j) = ergom%btf_t_det_with_atmos_ship_N(i,j) + change_btf_t_det_with_atmos_ship_N * timestep_fraction
                endif


                ! in the bottom layer
                if (k == grid_kmt(i,j)) then

                   ! tracer t_sed           (sediment detritus)
                   ergom%t_sed          (i,j) = ergom%t_sed          (i,j) + change_of_t_sed           * timestep_fraction

                   ! tracer t_ips           (iron phosphate in sediment)
                   ergom%t_ips          (i,j) = ergom%t_ips          (i,j) + change_of_t_ips           * timestep_fraction

                   ! tracer t_sed_poc       (sediment particular carbon)
                   ergom%t_sed_poc      (i,j) = ergom%t_sed_poc      (i,j) + change_of_t_sed_poc       * timestep_fraction

                   ! tracer t_sed_pocn      (sediment particular organic N+C)
                   ergom%t_sed_pocn     (i,j) = ergom%t_sed_pocn     (i,j) + change_of_t_sed_pocn      * timestep_fraction

                   ! tracer t_sed_pocp      (sediment particular organic P+C)
                   ergom%t_sed_pocp     (i,j) = ergom%t_sed_pocp     (i,j) + change_of_t_sed_pocp      * timestep_fraction

                   ! tracer total_atmos_tot_N_at_bottom (total_atmos_tot_N_at_bottom)
                   ergom%total_atmos_tot_N_at_bottom(i,j) = ergom%total_atmos_tot_N_at_bottom(i,j) + change_of_total_atmos_tot_N_at_bottom * timestep_fraction

                   ! tracer total_atmos_ship_N_at_bottom (total_atmos_ship_N_at_bottom)
                   ergom%total_atmos_ship_N_at_bottom(i,j) = ergom%total_atmos_ship_N_at_bottom(i,j) + change_of_total_atmos_ship_N_at_bottom * timestep_fraction

                   ! tracer t_sed_with_atmos_tot_N (sediment detritus; containing nitrogen from (total) atmospheric deposition)
                   ergom%t_sed_with_atmos_tot_N(i,j) = ergom%t_sed_with_atmos_tot_N(i,j) + change_of_t_sed_with_atmos_tot_N * timestep_fraction

                   ! tracer t_sed_pocn_with_atmos_tot_N (sediment particular organic N+C; containing nitrogen from (total) atmospheric deposition)
                   ergom%t_sed_pocn_with_atmos_tot_N(i,j) = ergom%t_sed_pocn_with_atmos_tot_N(i,j) + change_of_t_sed_pocn_with_atmos_tot_N * timestep_fraction

                   ! tracer t_sed_with_atmos_ship_N (sediment detritus; containing nitrogen from atmospheric deposition, which has been previously emitted by ships)
                   ergom%t_sed_with_atmos_ship_N(i,j) = ergom%t_sed_with_atmos_ship_N(i,j) + change_of_t_sed_with_atmos_ship_N * timestep_fraction

                   ! tracer t_sed_pocn_with_atmos_ship_N (sediment particular organic N+C; containing nitrogen from atmospheric deposition, which has been previously emitted by ships)
                   ergom%t_sed_pocn_with_atmos_ship_N(i,j) = ergom%t_sed_pocn_with_atmos_ship_N(i,j) + change_of_t_sed_pocn_with_atmos_ship_N * timestep_fraction
                endif

                !------------------------------------
                ! STEP 6.7.9: save process rates to obtain total rate over full timestep in the end
                !------------------------------------
                if (.not. intermediate) then
                   total_rate_p_no3_assim_lpp = total_rate_p_no3_assim_lpp + p_no3_assim_lpp * timestep_fraction * fraction_of_total_timestep
                   total_rate_p_nh4_assim_lpp = total_rate_p_nh4_assim_lpp + p_nh4_assim_lpp * timestep_fraction * fraction_of_total_timestep
                   total_rate_p_no3_assim_spp = total_rate_p_no3_assim_spp + p_no3_assim_spp * timestep_fraction * fraction_of_total_timestep
                   total_rate_p_nh4_assim_spp = total_rate_p_nh4_assim_spp + p_nh4_assim_spp * timestep_fraction * fraction_of_total_timestep
                   total_rate_p_n2_assim_cya  = total_rate_p_n2_assim_cya  + p_n2_assim_cya  * timestep_fraction * fraction_of_total_timestep
                   total_rate_p_assim_lpp_doc = total_rate_p_assim_lpp_doc + p_assim_lpp_doc * timestep_fraction * fraction_of_total_timestep
                   total_rate_p_assim_spp_doc = total_rate_p_assim_spp_doc + p_assim_spp_doc * timestep_fraction * fraction_of_total_timestep
                   total_rate_p_assim_cya_doc = total_rate_p_assim_cya_doc + p_assim_cya_doc * timestep_fraction * fraction_of_total_timestep
                   total_rate_p_assim_lpp_dop = total_rate_p_assim_lpp_dop + p_assim_lpp_dop * timestep_fraction * fraction_of_total_timestep
                   total_rate_p_assim_spp_dop = total_rate_p_assim_spp_dop + p_assim_spp_dop * timestep_fraction * fraction_of_total_timestep
                   total_rate_p_nh4_assim_lpp_don = total_rate_p_nh4_assim_lpp_don + p_nh4_assim_lpp_don * timestep_fraction * fraction_of_total_timestep
                   total_rate_p_no3_assim_lpp_don = total_rate_p_no3_assim_lpp_don + p_no3_assim_lpp_don * timestep_fraction * fraction_of_total_timestep
                   total_rate_p_nh4_assim_spp_don = total_rate_p_nh4_assim_spp_don + p_nh4_assim_spp_don * timestep_fraction * fraction_of_total_timestep
                   total_rate_p_no3_assim_spp_don = total_rate_p_no3_assim_spp_don + p_no3_assim_spp_don * timestep_fraction * fraction_of_total_timestep
                   total_rate_p_poc_resp      = total_rate_p_poc_resp      + p_poc_resp      * timestep_fraction * fraction_of_total_timestep
                   total_rate_p_poc_denit     = total_rate_p_poc_denit     + p_poc_denit     * timestep_fraction * fraction_of_total_timestep
                   total_rate_p_poc_sulf      = total_rate_p_poc_sulf      + p_poc_sulf      * timestep_fraction * fraction_of_total_timestep
                   total_rate_p_pocp_resp     = total_rate_p_pocp_resp     + p_pocp_resp     * timestep_fraction * fraction_of_total_timestep
                   total_rate_p_pocp_denit    = total_rate_p_pocp_denit    + p_pocp_denit    * timestep_fraction * fraction_of_total_timestep
                   total_rate_p_pocp_sulf     = total_rate_p_pocp_sulf     + p_pocp_sulf     * timestep_fraction * fraction_of_total_timestep
                   total_rate_p_pocn_resp     = total_rate_p_pocn_resp     + p_pocn_resp     * timestep_fraction * fraction_of_total_timestep
                   total_rate_p_pocn_denit_noN2 = total_rate_p_pocn_denit_noN2 + p_pocn_denit_noN2 * timestep_fraction * fraction_of_total_timestep
                   total_rate_p_pocn_denit_wiN2 = total_rate_p_pocn_denit_wiN2 + p_pocn_denit_wiN2 * timestep_fraction * fraction_of_total_timestep
                   total_rate_p_pocn_sulf     = total_rate_p_pocn_sulf     + p_pocn_sulf     * timestep_fraction * fraction_of_total_timestep
                   total_rate_p_lpp_graz_zoo  = total_rate_p_lpp_graz_zoo  + p_lpp_graz_zoo  * timestep_fraction * fraction_of_total_timestep
                   total_rate_p_spp_graz_zoo  = total_rate_p_spp_graz_zoo  + p_spp_graz_zoo  * timestep_fraction * fraction_of_total_timestep
                   total_rate_p_cya_graz_zoo  = total_rate_p_cya_graz_zoo  + p_cya_graz_zoo  * timestep_fraction * fraction_of_total_timestep
                   total_rate_p_lpp_resp_nh4  = total_rate_p_lpp_resp_nh4  + p_lpp_resp_nh4  * timestep_fraction * fraction_of_total_timestep
                   total_rate_p_spp_resp_nh4  = total_rate_p_spp_resp_nh4  + p_spp_resp_nh4  * timestep_fraction * fraction_of_total_timestep
                   total_rate_p_cya_resp_nh4  = total_rate_p_cya_resp_nh4  + p_cya_resp_nh4  * timestep_fraction * fraction_of_total_timestep
                   total_rate_p_zoo_resp_nh4  = total_rate_p_zoo_resp_nh4  + p_zoo_resp_nh4  * timestep_fraction * fraction_of_total_timestep
                   total_rate_p_lpp_mort_det  = total_rate_p_lpp_mort_det  + p_lpp_mort_det  * timestep_fraction * fraction_of_total_timestep
                   total_rate_p_spp_mort_det  = total_rate_p_spp_mort_det  + p_spp_mort_det  * timestep_fraction * fraction_of_total_timestep
                   total_rate_p_cya_mort_det  = total_rate_p_cya_mort_det  + p_cya_mort_det  * timestep_fraction * fraction_of_total_timestep
                   total_rate_p_cya_mort_det_diff = total_rate_p_cya_mort_det_diff + p_cya_mort_det_diff * timestep_fraction * fraction_of_total_timestep
                   total_rate_p_zoo_mort_det  = total_rate_p_zoo_mort_det  + p_zoo_mort_det  * timestep_fraction * fraction_of_total_timestep
                   total_rate_p_nh4_nit_no3   = total_rate_p_nh4_nit_no3   + p_nh4_nit_no3   * timestep_fraction * fraction_of_total_timestep
                   total_rate_p_det_resp_nh4  = total_rate_p_det_resp_nh4  + p_det_resp_nh4  * timestep_fraction * fraction_of_total_timestep
                   total_rate_p_det_denit_nh4 = total_rate_p_det_denit_nh4 + p_det_denit_nh4 * timestep_fraction * fraction_of_total_timestep
                   total_rate_p_det_sulf_nh4  = total_rate_p_det_sulf_nh4  + p_det_sulf_nh4  * timestep_fraction * fraction_of_total_timestep
                   total_rate_p_h2s_oxo2_sul  = total_rate_p_h2s_oxo2_sul  + p_h2s_oxo2_sul  * timestep_fraction * fraction_of_total_timestep
                   total_rate_p_h2s_oxno3_sul = total_rate_p_h2s_oxno3_sul + p_h2s_oxno3_sul * timestep_fraction * fraction_of_total_timestep
                   total_rate_p_sul_oxo2_so4  = total_rate_p_sul_oxo2_so4  + p_sul_oxo2_so4  * timestep_fraction * fraction_of_total_timestep
                   total_rate_p_sul_oxno3_so4 = total_rate_p_sul_oxno3_so4 + p_sul_oxno3_so4 * timestep_fraction * fraction_of_total_timestep
                   total_rate_p_doc2pco       = total_rate_p_doc2pco       + p_doc2pco       * timestep_fraction * fraction_of_total_timestep
                   total_rate_p_dop2pocp      = total_rate_p_dop2pocp      + p_dop2pocp      * timestep_fraction * fraction_of_total_timestep
                   total_rate_p_don2pocn      = total_rate_p_don2pocn      + p_don2pocn      * timestep_fraction * fraction_of_total_timestep
                   total_rate_p_doc_resp      = total_rate_p_doc_resp      + p_doc_resp      * timestep_fraction * fraction_of_total_timestep
                   total_rate_p_doc_denit     = total_rate_p_doc_denit     + p_doc_denit     * timestep_fraction * fraction_of_total_timestep
