% Figure 8 - Cai et al.2018, Ocean Science, 14, 1-14, 2018
clc,clear all
close all
%% observations
load Obs_Guadalquivir.txt;
M2=Obs_Guadalquivir(:,2:3);
S2=Obs_Guadalquivir(:,4:5);
N2=Obs_Guadalquivir(:,6:7);
K1=Obs_Guadalquivir(:,8:9);
O1=Obs_Guadalquivir(:,10:11);
x_obs = Obs_Guadalquivir(:,1);% distance of stations from mouth
for KK =1:5
    if KK==1
        Amp_M2 = M2(:,1); % amplitude
        Phi_M2 = M2(:,2); % phase
        f_M2= 1;       % friction correction factor
        T_M2=12.4206*3600; % period
    elseif KK==2
        Amp_S2 = S2(:,1);
        Phi_S2 = S2(:,2);
        f_S2=4;
        T_S2=12*3600;
    elseif KK==3
        Amp_N2 = N2(:,1);
        Phi_N2 = N2(:,2);
        f_N2=4.4;
        T_N2=12.6583*3600;
    elseif KK==4
        Amp_K1 = K1(:,1);
        Phi_K1 = K1(:,2);
        f_K1=50;
        T_K1=23.9345*3600;    
    elseif KK==5
        Amp_O1 = O1(:,1);
        Phi_O1 = O1(:,2);
        f_O1=42;
        T_O1=25.8193*3600;        
    end
end
%% Inputs
Le=103*1000;    % dimensional length [m]
D0=7.1;          % depth at the estuary mouth [m]
K=46;
Lb=65.5*1000;     % width convergence length [m] (=0 constant)
Lz=inf;     % depth convergence length [m] (=0 constant)
dx=500;        % distance interval [m]
x=(0:dx:Le-dx)./1000;
rs = 1.5; 
inf=2; % closed end case
f1=1;f2=1;f3=1;f4=1;f5=1;
%% model computation
for i=1:10
[eta_M2,U_M2,phi_M2]= ... 
    f_linN(Le,Amp_M2(1),T_M2(1),D0,rs,K,Lb,Lz,dx,f1,inf);
[eta_S2,U_S2,phi_S2]= ... 
    f_linN(Le,Amp_S2(1),T_S2(1),D0,rs,K,Lb,Lz,dx,f2,inf);
[eta_N2,U_N2,phi_N2]= ... 
    f_linN(Le,Amp_N2(1),T_N2(1),D0,rs,K,Lb,Lz,dx,f3,inf);
[eta_K1,U_K1,phi_K1]= ... 
    f_linN(Le,Amp_K1(1),T_K1(1),D0,rs,K,Lb,Lz,dx,f4,inf);
[eta_O1,U_O1,phi_O1]= ... 
    f_linN(Le,Amp_O1(1),T_O1(1),D0,rs,K,Lb,Lz,dx,f5,inf);

epsilon1=U_M2./(U_M2+U_S2+U_N2+U_K1+U_O1);
epsilon2=U_S2./(U_M2+U_S2+U_N2+U_K1+U_O1);
epsilon3=U_N2./(U_M2+U_S2+U_N2+U_K1+U_O1);
epsilon4=U_K1./(U_M2+U_S2+U_N2+U_K1+U_O1);
epsilon5=U_O1./(U_M2+U_S2+U_N2+U_K1+U_O1);
F1=(2+3*epsilon1.^2+6*epsilon2.^2+6*epsilon3.^2+6*epsilon4.^2+6*epsilon5.^2)./5;
F2=(2+3*epsilon2.^2+6*epsilon1.^2+6*epsilon3.^2+6*epsilon4.^2+6*epsilon5.^2)./5;
F3=(2+3*epsilon3.^2+6*epsilon1.^2+6*epsilon2.^2+6*epsilon4.^2+6*epsilon5.^2)./5;
F4=(2+3*epsilon4.^2+6*epsilon1.^2+6*epsilon2.^2+6*epsilon3.^2+6*epsilon5.^2)./5;
F5=(2+3*epsilon5.^2+6*epsilon1.^2+6*epsilon2.^2+6*epsilon3.^2+6*epsilon4.^2)./5;
f1=F1./epsilon1;
f2=F2./epsilon2;
f3=F3./epsilon3;
f4=F4./epsilon4;
f5=F5./epsilon5;
end
Table=[mean(f1) mean(f2) mean(f3) mean(f4) mean(f5)];
%% Phase
% Phase elevation for M2
phi_M2=-rad2deg(phi_M2);
phi_M2=phi_M2-phi_M2(1);
phi_M2=mod(phi_M2, 180);
% Phase elevation for S2
phi_S2=-rad2deg(phi_S2);
phi_S2=phi_S2-phi_S2(1);
phi_S2=mod(phi_S2, 180);
% Phase elevation for N2
phi_N2=-rad2deg(phi_N2);
phi_N2=phi_N2-phi_N2(1);
phi_N2=mod(phi_N2, 180);
% Phase elevation for K1
phi_K1=-rad2deg(phi_K1);
phi_K1=phi_K1-phi_K1(1);
phi_K1=mod(phi_K1, 180);
% Phase elevation for O1
phi_O1=-rad2deg(phi_O1);
phi_O1=phi_O1-phi_O1(1);
phi_O1=mod(phi_O1, 180);
%% Plot
figure1=figure;
        subplot 321 % M2 Amplitude and phase
        [AX,H1,H2]=plotyy(x,eta_M2,x,phi_M2);
        hold on
        plot(AX(1),x_obs, Amp_M2,'or')
        hold(AX(2),'on')
        plot(AX(2),x_obs,Phi_M2,'sb')
        set(H1,'LineStyle','-','Color','red')
        set(H2,'LineStyle','-','Color','blue')
        set(get(AX(1),'Ylabel'),'String','Amplitude (m)', 'fontsize',14) 
        set(get(AX(1),'Ylabel'),'String','Amplitude (m)', 'fontsize',14) 
        set(AX(1),'xlim',[0 103],'Ylim',[0.6 1],'YTick',[0.6 0.7 0.8 0.9 1],'ycolor',[1 0 0])
        set(AX(2),'xlim',[0 103],'ycolor',[0 0 1],'ylim',[0 160],'YTick',[0 40 80 120 160])
        text(3,0.95,'(a) M_2', 'fontsize', 14)
        
        %%
        subplot 322 % S2 Amplitude and phase
        [AX,H1,H2]=plotyy(x,eta_S2,x,phi_S2);
        hold on
        plot(AX(1),x_obs, Amp_S2,'or')
        hold(AX(2),'on')
        plot(AX(2),x_obs,Phi_S2,'sb')
        set(H1,'LineStyle','-','Color','red')
        set(H2,'LineStyle','-','Color','blue')
        set(get(AX(1),'Ylabel'),'String','Amplitude (m)', 'fontsize',14) 
        set(get(AX(2),'Ylabel'),'String','Phase \rm(\circ)', 'fontsize',14)
        set(AX(1),'xlim',[0 103],'ylim',[0.1 0.4],'ycolor',[1 0 0])
        set(AX(2),'xlim',[0 103],'ycolor',[0 0 1],'ylim',[0 160],'YTick',[0 40 80 120 160])
        text(3,0.35,'(b) S_2', 'fontsize', 14)
        %%
                subplot 323 % N2 Amplitude and phase
        [AX,H1,H2]=plotyy(x,eta_N2,x,phi_N2);
        hold on
        plot(AX(1),x_obs, Amp_N2,'or')
        hold(AX(2),'on')
        plot(AX(2),x_obs,Phi_N2,'sb')
        set(H1,'LineStyle','-','Color','red')
        set(H2,'LineStyle','-','Color','blue')
        set(get(AX(1),'Ylabel'),'String','Amplitude (m)', 'fontsize',14) 
      %  set(get(AX(2),'Ylabel'),'String','Phase \rm(\circ)', 'fontsize',14)
        set(AX(1),'xlim',[0 103],'Ylim',[0 0.2],'YTick',[0 0.1 0.2],'ycolor',[1 0 0])
        set(AX(2),'xlim',[0 103],'ycolor',[0 0 1],'ylim',[0 160],'YTick',[0 40 80 120 160])
         text(3,0.14,'(c) N_2', 'fontsize', 14)
         %%
         subplot 324 % K1 Amplitude and phase
        [AX,H1,H2]=plotyy(x,eta_K1,x,phi_K1);
        hold on
        plot(AX(1),x_obs, Amp_K1,'or');
        hold(AX(2),'on');
        plot(AX(2),x_obs,Phi_K1,'sb');
        set(H1,'LineStyle','-','Color','red');
        set(H2,'LineStyle','-','Color','blue');
        set(get(AX(1),'Ylabel'),'String','Amplitude (m)', 'fontsize',14) ;
        set(get(AX(2),'Ylabel'),'String','Phase \rm(\circ)', 'fontsize',14);
        set(AX(1),'xlim',[0 103],'Ylim',[0 0.2],'YTick',[0 0.1 0.2],'ycolor',[1 0 0])
        set(AX(2),'xlim',[0 103],'ycolor',[0 0 1],'ylim',[0 160],'YTick',[0 40 80 120 160]);
        text(3,0.16,'(d) K_1', 'fontsize', 14)
        set(get(AX(2),'Xlabel'),'String','Distance from the mouth (km)', 'fontsize',14);
%%
subplot 325 % O1 Amplitude and phase
        [AX,H1,H2]=plotyy(x,eta_O1,x,phi_O1);
        hold on
        plot(AX(1),x_obs, Amp_O1,'or');
        hold(AX(2),'on');
        plot(AX(2),x_obs,Phi_O1,'sb');
        set(H1,'LineStyle','-','Color','red');
        set(H2,'LineStyle','-','Color','blue');
        set(get(AX(1),'Ylabel'),'String','Amplitude (m)', 'fontsize',14); 
        set(get(AX(2),'Ylabel'),'String','Phase \rm(\circ)', 'fontsize',14);
        set(get(AX(2),'Xlabel'),'String','Distance from the mouth (km)', 'fontsize',14);
        set(AX(1),'xlim',[0 103],'Ylim',[0 0.2],'YTick',[0 0.1 0.2],'ycolor',[1 0 0])
        set(AX(2),'xlim',[0 103],'ycolor',[0 0 1],'ylim',[0 160],'YTick',[0 40 80 120 160]);
        text(3,0.16,'(e) O_1', 'fontsize', 14)
        %%
               hSub = subplot(326); plot(1, nan, 'r',1, nan,'or', 1, nan,'b', 1,nan,'sb'); set(hSub, 'Visible', 'off');
        legend('Analytical \eta', 'Observed \eta', 'Analytical \phi_A ', 'Observed \phi_A', 'Location','north')
        set(gca,'fontsize',15)


