/********************************************************************
 *                                                                  *
 *       A Comprehensive Gibbs Thermodynamic Potential of Ice       *
 *              Rainer Feistel & Wolfgang Wagner, 2004              *
 *                                                                  *
 *        presented at the 14th International Conference            *
 *             on the Properties of Water and Steam                 *
 *          August 29 - September 3, 2004, Kyoto, Japan             *
 *                                                                  *
 *              C++ implementation by Vladimir Tchijov,             *
 *                   tchijov@servidor.unam.mx                       *
 *               (code version: 17 December 2004)                   *
 *                                                                  *
 *              submitted to Ocean Science, Dec. 2004, as:          *
 *     Numerical Implementation and Oceanographic Application       *
 *                   of the Gibbs Potential of Ice                  *
 *            by R.Feistel, W.Wagner, V.Tchijov, C.Guder            *
 *                                                                  *
 *        Further details will be published in the article:         *
 *                                                                  *
 *   High-pressure thermodynamic Gibbs functions of ice and sea ice *
 *                Rainer Feistel & Wolfgang Wagner                  *
 *          Journal of Marine Research, 2005, in press              *
 *                                                                  *
 ********************************************************************/
#include <iostream>
using namespace std;
#include "IceIh_FW.h"

using namespace IceIh_FW;

int main()
{
  double T,P;

  T=263.15;      // Temperature, K
  P=10101325.0;  // Pressure, Pa

  cout.precision(15);
  
  cout << "T_abs               " << T << "   K" << endl;
  cout << "P_abs               " << P << " Pa" << endl;
  cout << "g                   " << ice_g(T,P) << "     J/kg" << endl;
  cout << "dgdT                " << ice_dgdt(T,P) << "      J/(kg K)" << endl;
  cout << "dgdP                " << ice_dgdp(T,P) << "   m^3/kg" << endl;
  cout << "d2gdT2              " << ice_d2gdt2(T,P) << "     J/(kg K^2)" << endl;
  cout << "d2gdTdP             " << ice_d2gdtdp(T,P) << "  m^3/(kg K)" << endl;
  cout << "d2gdP2              " << ice_d2gdp2(T,P) << " m^3/(kg Pa)" << endl;
  cout << "d3gdT2dP            " << ice_d3gdt2dp(T,P) << "  m^3/(kg K^2)" << endl;
  cout << "d3gdTdP2            " << ice_d3gdtdp2(T,P) << " m^3/(kg K Pa)" << endl;
  cout << "d3gdP3              " << ice_d3gdp3(T,P) << "  m^3/(kg Pa^2)" << endl;
  cout << "spec. volume        " << ice_specific_volume(T,P) << "   m^3/kg" << endl;
  cout << "density             " << ice_density(T,P) << "      kg/m^3" << endl;
  cout << "enthalpy            " << ice_enthalpy(T,P) << "     J/kg" << endl;
  cout << "entropy             " << ice_entropy(T,P) << "     J/(kg K)" << endl;
  cout << "free energy         " << ice_free_energy(T,P) << "     J/kg" << endl;
  cout << "int. energy         " << ice_internal_energy(T,P) << "     J/kg" << endl;
  cout << "heat capacity       " << ice_heat_capacity(T,P) << "      J/(kg K)" << endl;
  cout << "therm. exp.         " << ice_thermal_expansion(T,P) << "  1/K" << endl;
  cout << "isoth. compr.       " << ice_isothermal_compressibility(T,P) << "  1/Pa" << endl;
  cout << "isent. compr.       " << ice_isentropic_compressibility(T,P) << "  1/Pa" << endl;
  cout << "press. coeff.       " << ice_pressure_coefficient(T,P) << "     1/K" << endl;
  cout << "d(isent. compr)/dP  " << ice_disentropic_compressibilitydP(T,P) << " 1/Pa^2" << endl;
  
  return 0;
}

/*************************************************************
 *************************************************************
Borland C++ Builder (version 5) compiler for Windows.
Output:

T_abs               263.15   K
P_abs               10101325 Pa

g                   -1606.45117448966     J/kg
dgdT                1299.04800566944      J/(kg K)
dgdP                0.00108787119642917   m^3/kg
d2gdT2              -7.67906117056837     J/(kg K^2)
d2gdTdP             1.66429674881775e-07  m^3/(kg K)
d2gdP2              -1.25548611251055e-13 m^3/(kg Pa)
d3gdT2dP            5.61033076359349e-10  m^3/(kg K^2)
d3gdTdP2            -2.15950418441554e-16 m^3/(kg K Pa)
d3gdP3              8.83364207555687e-23  m^3/(kg Pa^2)
spec. volume        0.00108787119642917   m^3/kg
density             919.226470268169      kg/m^3
enthalpy            -343450.933866404     J/kg
entropy             -1299.04800566944     J/(kg K)
free energy         -12595.3916877596     J/kg
int. energy         -354439.874379674     J/kg
heat capacity       2020.74494703507      J/(kg K)
therm. exp.         0.000152986562589453  1/K
isoth. compr.       1.15407606767378e-10  1/Pa
isent. compr.       1.12091901460767e-10  1/Pa
press. coeff.       0.131232229564815     1/K
d(isent. compr)/dP  -5.99025933097888e-20 1/Pa^2

*******************************************************
*******************************************************
GNU g++ (version 3.3.1) compiler for LINUX.
Output:

T_abs               263.15   K
P_abs               10101325 Pa

g                   -1606.45117448957     J/kg
dgdT                1299.04800566944      J/(kg K)
dgdP                0.00108787119642917   m^3/kg
d2gdT2              -7.67906117056837     J/(kg K^2)
d2gdTdP             1.66429674881775e-07  m^3/(kg K)
d2gdP2              -1.25548611251055e-13 m^3/(kg Pa)
d3gdT2dP            5.61033076359349e-10  m^3/(kg K^2)
d3gdTdP2            -2.15950418441554e-16 m^3/(kg K Pa)
d3gdP3              8.83364207555687e-23  m^3/(kg Pa^2)
spec. volume        0.00108787119642917   m^3/kg
density             919.226470268169      kg/m^3
enthalpy            -343450.933866404     J/kg
entropy             -1299.04800566944     J/(kg K)
free energy         -12595.3916877595     J/kg
int. energy         -354439.874379674     J/kg
heat capacity       2020.74494703507      J/(kg K)
therm. exp.         0.000152986562589453  1/K
isoth. compr.       1.15407606767378e-10  1/Pa
isent. compr.       1.12091901460767e-10  1/Pa
press. coeff.       0.131232229564815     1/K
d(isent. compr)/dP  -5.99025933097889e-20 1/Pa^2

****************************************************************/


