C***************************************************************
      PROGRAM Ice
C***************************************************************
C                                                               
C     A Comprehensive Gibbs Thermodynamic Potential of Ice      
C            Rainer Feistel & Wolfgang Wagner, 2004             
C                                                               
C      presented at the 14th International Conference           
C           on the Properties of Water and Steam                
C        August 29 - September 3, 2004, Kyoto, Japan            
C                                                               
C           FORTRAN implementation by Christoph Guder,          
C              C.Guder@thermo.ruhr-uni-bochum.de                
C    (code version: 17 December 2004, corrected 16 June 2006)                
C                                                               
C            published Ocean Science, 1 (2005) 29-38 as:         
C     Numerical Implementation and Oceanographic Application    
C                of the Gibbs Potential of Ice                  
C          by R.Feistel, W.Wagner, V.Tchijov, C.Guder           
C                                                               
C      Further details are published in the article:        
C                                                               
C High-pressure thermodynamic Gibbs functions of ice and sea ice
C              Rainer Feistel & Wolfgang Wagner                 
C          Journal of Marine Research, 63 (2005) 95-139           
C                                                               
C***************************************************************
      IMPLICIT REAL*8 (A-I,O-Z)
C
      T = 263.15D0
      P = 10101325.D0
C
      CALL DAT
C
      WRITE(*,*)'T_abs             ',T,'K'
      WRITE(*,*)'P_abs             ',P,'Pa'
      WRITE(*,*)'g                 ',ice_g(T,P),'J/kg'
      WRITE(*,*)'dg/dT             ',ice_dgdt(T,P),'J/(kg K)'
      WRITE(*,*)'dg/dP             ',ice_dgdp(T,P),'m**3/kg'
      WRITE(*,*)'d2g/dT2           ',ice_d2gdt2(T,P),'J/(kg K**2)'
      WRITE(*,*)'d2g/dTdP          ',ice_d2gdtdp(T,P),'m**3/(kg K)'
      WRITE(*,*)'d2g/dP2           ',ice_d2gdp2(T,P),'m**3/(kg Pa)'
      WRITE(*,*)'d3g/dT3           ',ice_d3gdt3(T,P),'J/(kg K**3)'
      WRITE(*,*)'d3g/dT2dP         ',ice_d3gdt2dp(T,P),'m**3/(kg K**2)'
      WRITE(*,*)'d3g/dTdP2         ',ice_d3gdtdp2(T,P),'m**3/(kg Pa K)'
      WRITE(*,*)'d3g/dP3           ',ice_d3gdp3(T,P),'m**3/(kg Pa**2)'
      WRITE(*,*)'specific volume   ',ice_specific_volume(T,P),'m**3/kg'
      WRITE(*,*)'density           ',ice_density(T,P),'kg/m**3'
      WRITE(*,*)'enthalpy          ',ice_enthalpy(T,P),'J/kg'
      WRITE(*,*)'entropy           ',ice_entropy(T,P),'J/(kg K)'
      WRITE(*,*)'free energy       ',ice_free_energy(T,P),'J/kg'
      WRITE(*,*)'internal energy   ',ice_internal_energy(T,P),'J/kg'
      WRITE(*,*)'heat capacity     ',ice_heat_capacity(T,P),'J/(kg K)'
      WRITE(*,*)'therm. expansion  ',ice_thermal_expansion(T,P),'1/K'
      WRITE(*,*)'isoth. compr.     ',ice_isothermal_compressibility(T,P)
     &,'1/Pa'
      WRITE(*,*)'isentr. compr.    ',ice_isentropic_compressibility(T,P)
     &,'1/Pa'
      WRITE(*,*)'press. coefficient',ice_pressure_coefficient(T,P)
     &,'1/K'
      WRITE(*,*)'disentr. compr./dP',ice_disentropic_compressdp(T,P)
     &,'1/Pa**2'
C
      END
C
C     Printout
C
C     T_abs                263.150000000000      K
C     P_abs                10101325.0000000      Pa
C     g                   -1606.45117448973      J/kg
C     dg/dT                1299.04800566944      J/(kg K)
C     dg/dP               1.087871196429174E-003 m**3/kg
C     d2g/dT2             -7.67906117056837      J/(kg K**2)
C     d2g/dTdP            1.664296748817753E-007 m**3/(kg K)
C     d2g/dP2            -1.255486112510547E-013 m**3/(kg Pa)
C     d3g/dT3             1.414393649194133E-003 J/(kg K**3)
C     d3g/dT2dP           5.610330763593495E-010 m**3/(kg K**2)
C     d3g/dTdP2          -2.159504184415537E-016 m**3/(kg Pa K)
C     d3g/dP3             8.833642075556870E-023 m**3/(kg Pa**2)
C     specific volume     1.087871196429174E-003 m**3/kg
C     density              919.226470268169      kg/m**3
C     enthalpy            -343450.933866404      J/kg
C     entropy             -1299.04800566944      J/(kg K)
C     free energy         -12595.3916877597      J/kg
C     internal energy     -354439.874379674      J/kg
C     heat capacity        2020.74494703507      J/(kg K)
C     therm. expansion    1.529865625894533E-004 1/K
C     isoth. compr.       1.154076067673776E-010 1/Pa
C     isentr. compr.      1.120919014607667E-010 1/Pa
C     press. coefficient  0.131232229564815      1/K
C     disentr. compr./dP -5.990259330978887E-020 1/Pa**2
C