#ifndef ICEIH_FW_AUX
#define ICEIH_FW_AUX

#include <complex>
using namespace std;

namespace IceIh_FW_Aux {

typedef complex<double> dcomplex;

extern const double g00,g01,g02,g03,g04;
extern const dcomplex t1,r1,t2,r20,r21,r22;
extern const dcomplex compl_zero;
extern const double sigma_absolute,sigma_IAPWS95,
                    Pt,P0,Tt,T0,Tm,TM,p0,tau;

double g0(double P);
double dg0_dP(double P);
double d2g0_dP2(double P);
double d3g0_dP3(double P);

dcomplex r2(double P);
dcomplex dr2_dP(double P);
dcomplex d2r2_dP2(double P);
dcomplex d3r2_dP3(double P);
}

#endif
