#ifndef ICEIH_FW
#define ICEIH_FW

namespace IceIh_FW {

double ice_g(double T, double P);

double ice_dgdp(double T, double P);
double ice_d2gdp2(double T, double P);

double ice_d3gdp3(double T, double P);
double ice_d3gdtdp2(double T, double P);
double ice_d3gdt2dp(double T, double P);

double ice_dgdt(double T, double P);
double ice_d2gdt2(double T, double P);
double ice_d2gdtdp(double T, double P);

double ice_specific_volume(double T, double P);
double ice_density(double T, double P);
double ice_thermal_expansion(double T, double P);
double ice_isothermal_compressibility(double T, double P);
double ice_isentropic_compressibility(double T, double P);
double ice_disentropic_compressibilitydP(double T, double P);
double ice_pressure_coefficient(double T, double P);

double ice_heat_capacity(double T, double P);
double ice_free_energy(double T, double P);
double ice_entropy(double T, double P);
double ice_enthalpy(double T, double P);
double ice_internal_energy(double T, double P);
}

#endif


 