C***********************************************************************************************
      SUBROUTINE DAT
C***********************************************************************************************
C
C    THIS SUBROUTINE CONTAINS THE CONSTANTS FOR THE CALCULATIONS
C
      IMPLICIT REAL*8(A-H,O-Z)
      COMPLEX*16 tk(2), rk1, rk2(3)
      DIMENSION G0(10)
      COMMON/CONSTANTS/tk,rk1,rk2,S0,Tt,Pt,PNORM,P0
      COMMON/G0CONSTANTS/G0
C
      G0(1) = -632578.704355102D0
      G0(2) = 0.655029997804786D0
      G0(3) = -1.89952376891314D-8
      G0(4) = 3.40692612753936D-15
      G0(5) = -5.78593658679522D-22
C
      tk(1) = (3.71539090346389D-2,5.10464771184122D-2)
      tk(2) = (0.345095829562823D0,0.343315892017841D0)
C
      rk1 = (45.951447199735D0,65.223705014775D0)
C
      rk2(1) = (-75.8695106343435D0,-80.9878506462645D0)
      rk2(2) = (-5.75529765634353D-5,5.09059011946526D-5)
      rk2(3) = (2.39617513518116D-11,-2.73297877749166D-11)
C
      S0 = -3333.18160308627D0
C
      Tt = 273.16D0
      Pt = 611.657D0
      PNORM = 101325.D0
      P0 = PNORM / Pt
C
      RETURN
      END
C***********************************************************************************************
      DOUBLEPRECISION FUNCTION ice_g(T,P)
C***********************************************************************************************
C
C    THIS SUBROUTINE CALCULATES THE SPECIFIC GIBBS ENERGY FOR ICE IN J/kg
C
      IMPLICIT REAL*8(A-I,O-Z)
      COMPLEX*16 tk(2), rk1, rk2(3),SR(2),TERM(2)
      INTEGER I
      DIMENSION G0(10)
      COMMON/CONSTANTS/tk,rk1,rk2,S0,Tt,Pt,PNORM,P0
      COMMON/G0CONSTANTS/G0
C
      ice_g = 0.D0
C
      TN = T / Tt
      PN = P / Pt
C
      DO 10, I=0,4
        ice_g = ice_g + G0(I+1) * (PN-P0)**I
   10 CONTINUE
C
      ice_g = ice_g - S0 * Tt * TN
C
      SR(1) = rk1
      SR(2) = (0.D0,0.D0)
      DO 20, I=0, 2
        SR(2) = SR(2) + rk2(I+1) * (PN-P0)**I
   20 CONTINUE
C
      DO 30, I=1,2
        TERM(I) = (tk(I)-TN)*CDLOG(tk(I)-TN)+(tk(I)+TN)*CDLOG(tk(I)+TN)
     *        -2.D0*tk(I)*CDLOG(tk(I))-TN**2/tk(I)
   30 CONTINUE
C
      DO 40, I=1,2
        ice_g = ice_g + Tt * DBLE(SR(I) * TERM(I))
   40 CONTINUE
C
      RETURN
      END
C***********************************************************************************************
      DOUBLEPRECISION FUNCTION ice_dgdt(T,P)
C***********************************************************************************************
C
C    THIS SUBROUTINE CALCULATES THE 1ST T-DERIVATIVE OF G IN J/(kg K)
C
      IMPLICIT REAL*8(A-I,O-Z)
      COMPLEX*16 tk(2), rk1, rk2(3),SR(2),TERM(2)
      INTEGER I
      COMMON/CONSTANTS/tk,rk1,rk2,S0,Tt,Pt,PNORM,P0
C
      ice_dgdt = -S0
C
      TN = T / Tt
      PN = P / Pt
C
      SR(1) = rk1
      SR(2) = (0.D0,0.D0)
      DO 20, I=0, 2
        SR(2) = SR(2) + rk2(I+1) * (PN-P0)**I
   20 CONTINUE
C
      DO 30, I=1,2
      TERM(I) = -CDLOG(tk(I)-TN)+CDLOG(tk(I)+TN)-
     *          2.D0*TN/tk(I)
   30 CONTINUE
C
      DO 40, I=1,2
        ice_dgdt = ice_dgdt  + DBLE(SR(I) * TERM(I))
   40 CONTINUE
C
      RETURN
      END
C***********************************************************************************************
      DOUBLEPRECISION FUNCTION ice_dgdp(T,P)
C***********************************************************************************************
C
C    THIS SUBROUTINE CALCULATES THE 1ST P-DERIVATIVE OF G IN m**3/kg
C
      IMPLICIT REAL*8(A-I,O-Z)
      COMPLEX*16 tk(2), rk1, rk2(3),SR(2),TERM(2)
      INTEGER I
      DIMENSION G0(10)
      COMMON/CONSTANTS/tk,rk1,rk2,S0,Tt,Pt,PNORM,P0
      COMMON/G0CONSTANTS/G0
C
      ice_dgdp = 0.D0
C
      TN = T / Tt
      PN = P / Pt
C
      DO 10, I=1,4
        ice_dgdp = ice_dgdp + G0(I+1)*(PN-P0)**(I-1)*DBLE(I)*(1.D0/Pt)
   10 CONTINUE
C
      SR(2) = (0.D0,0.D0)
      DO 20, I=1, 2
        SR(2) = SR(2)+rk2(I+1)*(PN-P0)**(I-1)*DBLE(I)*1.D0/Pt
   20 CONTINUE
C
      TERM(2) = (tk(2)-TN)*CDLOG(tk(2)-TN)+(tk(2)+TN)*CDLOG(tk(2)+TN)
     *          -2.D0*tk(2)*CDLOG(tk(2))-TN**2.D0/tk(2)
C
      ice_dgdp = ice_dgdp + Tt * DBLE(SR(2) * TERM(2))
C
      RETURN
      END
C***********************************************************************************************
      DOUBLEPRECISION FUNCTION ice_d2gdt2(T,P)
C***********************************************************************************************
C
C    THIS SUBROUTINE CALCULATES THE 2ND T-DERIVATIVE OF G IN J/(kg K**2)
C
      IMPLICIT REAL*8(A-I,O-Z)
      INTEGER I
      COMPLEX*16 tk(2), rk1, rk2(3),SR(2),TERM(2)
      COMMON/CONSTANTS/tk,rk1,rk2,S0,Tt,Pt,PNORM,P0
C
      ice_d2gdt2 = 0.D0
C
      TN = T / Tt
      PN = P / Pt
C
      SR(1) = rk1
      SR(2) = (0.D0,0.D0)
      DO 20, I=0, 2
        SR(2) = SR(2) + rk2(I+1) * (PN-P0)**I
   20 CONTINUE
C
      DO 30, I=1,2
        TERM(I) = 1.D0/(tk(I)-TN)+1.D0/(tk(I)+TN)-2.D0/tk(I)
   30 CONTINUE
C
      DO 40, I=1,2
        ice_d2gdt2 = ice_d2gdt2 + 1.D0/Tt * DBLE(SR(I) * TERM(I))
   40 CONTINUE
C
      RETURN
      END
C***********************************************************************************************
      DOUBLEPRECISION FUNCTION ice_d2gdtdp(T,P)
C***********************************************************************************************
C
C    THIS SUBROUTINE CALCULATES THE 2ND T-P-DERIVATIVE OF G IN m**3/(kg K)
C
      IMPLICIT REAL*8(A-I,O-Z)
      INTEGER I
      COMPLEX*16 tk(2), rk1, rk2(3),SR(2),TERM(2)
      COMMON/CONSTANTS/tk,rk1,rk2,S0,Tt,Pt,PNORM,P0
C
      ice_d2gdtdp = 0.D0
C
      TN = T / Tt
      PN = P / Pt
C
      SR(2) = (0.D0,0.D0)
      DO 20, I=1, 2
        SR(2) = SR(2)+rk2(I+1)*(PN-P0)**(I-1)*DBLE(I)*1.D0/Pt
   20 CONTINUE
C
      TERM(2) = -CDLOG(tk(2)-TN)+CDLOG(tk(2)+TN)-2.D0*TN/tk(2)
C
      ice_d2gdtdp = DBLE(SR(2) * TERM(2))
C
      RETURN
      END
C***********************************************************************************************
      DOUBLEPRECISION FUNCTION ice_d2gdp2(T,P)
C***********************************************************************************************
C
C    THIS SUBROUTINE CALCULATES THE 2ND P-DERIVATIVE OF G IN m**3/(kg Pa)
C
      IMPLICIT REAL*8(A-I,O-Z)
      COMPLEX*16 tk(2), rk1, rk2(3),SR(2),TERM(2)
      INTEGER I
      DIMENSION G0(10)
      COMMON/CONSTANTS/tk,rk1,rk2,S0,Tt,Pt,PNORM,P0
      COMMON/G0CONSTANTS/G0
C
      ice_d2gdp2 = 0.D0
C
      TN = T / Tt
      PN = P / Pt
C
      DO 10, I=2,4
        ice_d2gdp2 = ice_d2gdp2+G0(I+1)*(PN-P0)**(I-2)*DBLE(I)*DBLE(I-1)
     *         *(1.D0/(Pt**2.D0))
   10 CONTINUE
C
      SR(2) = rk2(3)*2.D0*(1.D0/Pt**2)
C
        TERM(2) = (tk(2)-TN)*CDLOG(tk(2)-TN)+(tk(2)+TN)*CDLOG(tk(2)+TN)
     *          -2.D0*tk(2)*CDLOG(tk(2))-TN**2.D0/tk(2)
C
      ice_d2gdp2 = ice_d2gdp2 + Tt * DBLE(SR(2) * TERM(2))
C
      RETURN
      END
C***********************************************************************************************
      DOUBLEPRECISION FUNCTION ice_d3gdt3(T,P)
C***********************************************************************************************
C
C    THIS SUBROUTINE CALCULATES THE 3RD T-DERIVATIVE OF G IN J/(kg K**3)
C
      IMPLICIT REAL*8(A-I,O-Z)
      COMPLEX*16 tk(2), rk1, rk2(3),SR(2),TERM(2)
      INTEGER I
      COMMON/CONSTANTS/tk,rk1,rk2,S0,Tt,Pt,PNORM,P0
C
      ice_d3gdt3 = 0.D0
C
      TN = T / Tt
      PN = P / Pt
C
      SR(1) = rk1
      SR(2) = (0.D0,0.D0)
      DO 20, I=0, 2
        SR(2) = SR(2) + rk2(I+1) * (PN-P0)**I
   20 CONTINUE
C
      DO 30, I=1,2
        TERM(I) = (1.D0/((tk(I)-TN)**2))-(1.D0/((tk(I)+TN)**2))
   30 CONTINUE
C
      DO 40, I=1,2
        ice_d3gdt3 = ice_d3gdt3 + 1.D0/Tt**2 * DBLE(SR(I) * TERM(I))
   40 CONTINUE
C
      RETURN
      END
C***********************************************************************************************
      DOUBLEPRECISION FUNCTION ice_d3gdt2dp(T,P)
C***********************************************************************************************
C
C    THIS SUBROUTINE CALCULATES THE 3RD T-T-P-DERIVATIVE OF G IN m**3/(kg K**2)
C
      IMPLICIT REAL*8(A-I,O-Z)
      COMPLEX*16 tk(2), rk1, rk2(3),SR(2),TERM(2)
      INTEGER I
      COMMON/CONSTANTS/tk,rk1,rk2,S0,Tt,Pt,PNORM,P0
C
      ice_d3gdt2dp = 0.D0
C
      TN = T / Tt
      PN = P / Pt
C
      SR(2) = (0.D0,0.D0)
      DO 20, I=1, 2
        SR(2) = SR(2)+rk2(I+1)*(PN-P0)**(I-1)*DBLE(I)*1.D0/Pt
   20 CONTINUE
C
      TERM(2) = 1.D0/(tk(2)-TN)+1.D0/(tk(2)+TN)-2.D0/tk(2)
C
      ice_d3gdt2dp = 1.D0/Tt * DBLE(SR(2) * TERM(2))
C
      RETURN
      END
C***********************************************************************************************
      DOUBLEPRECISION FUNCTION ice_d3gdtdp2(T,P)
C***********************************************************************************************
C
C    THIS SUBROUTINE CALCULATES THE 3RD T-P-P-DERIVATIVE OF G IN m**3/(kg Pa K)
C
      IMPLICIT REAL*8(A-I,O-Z)
      COMPLEX*16 tk(2), rk1, rk2(3),SR(2),TERM(2)
      INTEGER I
      COMMON/CONSTANTS/tk,rk1,rk2,S0,Tt,Pt,PNORM,P0
C
      ice_d3gdtdp2 = 0.D0
C
      TN = T / Tt
      PN = P / Pt
C
      SR(2) = rk2(3)*2.D0*(1.D0/Pt**2)
C
      TERM(2) = -CDLOG(tk(2)-TN)+CDLOG(tk(2)+TN)-
     *          2.D0*TN/tk(2)
C
      ice_d3gdtdp2 = DBLE(SR(2) * TERM(2))
C
      RETURN
      END
C***********************************************************************************************
      DOUBLEPRECISION FUNCTION ice_d3gdp3(T,P)
C***********************************************************************************************
C
C    THIS SUBROUTINE CALCULATES THE 3RD P-DERIVATIVE OF G IN m**3/(kg Pa**2)
C
      IMPLICIT REAL*8(A-I,O-Z)
      COMPLEX*16 tk(2), rk1, rk2(3),SR(2),TERM(2)
      INTEGER I
      DIMENSION G0(10)
      COMMON/CONSTANTS/tk,rk1,rk2,S0,Tt,Pt,PNORM,P0
      COMMON/G0CONSTANTS/G0
C
      ice_d3gdp3 = 0.D0
C
      TN = T / Tt
      PN = P / Pt
C
      DO 10, I=3,4
        ice_d3gdp3 = ice_d3gdp3+G0(I+1)*(PN-P0)**(I-3)*DBLE(I)*DBLE(I-1)
     *         *DBLE(I-2)/Pt**3
   10 CONTINUE
C
      RETURN
      END
C***********************************************************************************************
      DOUBLEPRECISION FUNCTION ice_density(T,P)
C***********************************************************************************************
C
C     THIS FUNCTION CALCULATES THE DENSITY OF ICE IN kg/m**3
C
      IMPLICIT REAL*8 (A-I,O-Z)
C
      ice_density = 0.D0
      GP = ice_dgdp(T,P)
      ice_density = 1.D0 / GP
C
      RETURN
      END
C***********************************************************************************************
      DOUBLEPRECISION FUNCTION ice_specific_volume(T,P)
C***********************************************************************************************
C
C     THIS FUNCTION CALCULATES THE SPECIFIC VOLUME OF ICE IN m**3/kg
C
      IMPLICIT REAL*8 (A-I,O-Z)
C
      ice_specific_volume = 0.D0
      GP = ice_dgdp(T,P)
      ice_specific_volume = GP
C
      RETURN
      END
C***********************************************************************************************
      DOUBLEPRECISION FUNCTION ice_entropy(T,P)
C***********************************************************************************************
C
C     THIS FUNCTION CALCULATES THE SPECIFIC ENTROPY OF ICE IN J/(kg K)
C
      IMPLICIT REAL*8 (A-I,O-Z)
C
      ice_entropy = 0.D0
      GT = ice_dgdt(T,P)
      ice_entropy = -1.D0 * GT
C
      RETURN
      END
C***********************************************************************************************
      DOUBLEPRECISION FUNCTION ice_heat_capacity(T,P)
C***********************************************************************************************
C
C     THIS FUNCTION CALCULATES THE SPECIFIC ISOBARIC HEAT CAPACITY OF ICE IN J/(kg K)
C
      IMPLICIT REAL*8 (A-I,O-Z)
C
      ice_heat_capacity = 0.D0
      GTT = ice_d2gdt2(T,P)
      ice_heat_capacity = -1.D0 * T * GTT
C
      RETURN
      END
C***********************************************************************************************
      DOUBLEPRECISION FUNCTION ice_enthalpy(T,P)
C***********************************************************************************************
C
C     THIS FUNCTION CALCULATES THE SPECIFIC ENTHALPY OF ICE IN J/kg
C
      IMPLICIT REAL*8 (A-I,O-Z)
C
      ice_enthalpy = 0.D0
      G  = ice_g(T,P)
      GT = ice_dgdt(T,P)
      ice_enthalpy = G - T * GT
C
      RETURN
      END
C***********************************************************************************************
      DOUBLEPRECISION FUNCTION ice_free_enthalpy(T,P)
C***********************************************************************************************
C
C     THIS FUNCTION CALCULATES THE SPECIFIC GIBBS ENERGY WHICH IS EQUAL TO THE
C     SPECIFIC FREE ENTHALPY OF ICE IN J/kg
C
      IMPLICIT REAL*8 (A-I,O-Z)
C
      ice_free_enthalpy = ice_g(T,P)
C
      RETURN
      END
C***********************************************************************************************
      DOUBLEPRECISION FUNCTION ice_internal_energy(T,P)
C***********************************************************************************************
C
C     THIS FUNCTION CALCULATES THE SPECIFIC INTERNAL ENERGY OF ICE IN J/kg
C
      IMPLICIT REAL*8 (A-I,O-Z)
C
      ice_internal_energy = 0.D0
      G  = ice_g(T,P)
      GT = ice_dgdt(T,P)
      GP = ice_dgdp(T,P)
      ice_internal_energy = G - T * GT - P * GP
C
      RETURN
      END
C***********************************************************************************************
      DOUBLEPRECISION FUNCTION ice_free_energy(T,P)
C***********************************************************************************************
C
C     THIS FUNCTION CALCULATES THE SPECIFIC HELMHOLTZ ENERGY WHICH IS EQUAL TO THE
c     SPECIFIC FREE ENERGY OF ICE IN J/kg
C
      IMPLICIT REAL*8 (A-I,O-Z)
C
      ice_free_energy = 0.D0
      G  = ice_g(T,P)
      GP = ice_dgdp(T,P)
      ice_free_energy = G - P * GP
C
      RETURN
      END
C***********************************************************************************************
      DOUBLEPRECISION FUNCTION ice_thermal_expansion(T,P)
C***********************************************************************************************
C
C     THIS FUNCTION CALCULATES THE CUBIC EXPANSION COEFFICIENT OF ICE IN 1/K
C
      IMPLICIT REAL*8 (A-I,O-Z)
C
      ice_thermal_expansion = 0.D0
      GP  = ice_dgdp(T,P)
      GTP = ice_d2gdtdp(T,P)
      ice_thermal_expansion = GTP / GP
C
      RETURN
      END
C***********************************************************************************************
      DOUBLEPRECISION FUNCTION ice_isothermal_compressibility(T,P)
C***********************************************************************************************
C
C     THIS FUNCTION CALCULATES THE ISOTHERMAL COMPRESSIBILITY OF ICE IN 1/Pa
C
      IMPLICIT REAL*8 (A-I,O-Z)
C
      ice_isothermal_compressibility = 0.D0
      GP  = ice_dgdp(T,P)
      GPP = ice_d2gdp2(T,P)
      ice_isothermal_compressibility = -1.D0 * GPP / GP
C
      RETURN
      END
C***********************************************************************************************
      DOUBLEPRECISION FUNCTION ice_isentropic_compressibility(T,P)
C***********************************************************************************************
C
C     THIS FUNCTION CALCULATES THE ISENTROPIC COMPRESSIBILITY OF ICE IN 1/Pa
C
      IMPLICIT REAL*8 (A-I,O-Z)
C
      ice_isentropic_compressibility = 0.D0
      GP  = ice_dgdp(T,P)
      GTP = ice_d2gdtdp(T,P)
      GTT = ice_d2gdt2(T,P)
      GPP = ice_d2gdp2(T,P)
      ice_isentropic_compressibility = ((GTP**2.D0)-GTT*GPP)/(GP*GTT)
C
      RETURN
      END
C***********************************************************************************************
      DOUBLEPRECISION FUNCTION ice_pressure_coefficient(T,P)
C***********************************************************************************************
C
C     THIS FUNCTION CALCULATES THE PRESSURE COEFFICIENT OF ICE IN 1/K
C
      IMPLICIT REAL*8 (A-I,O-Z)
C
      ice_pressure_coefficient = 0.D0
      GTP = ice_d2gdtdp(T,P)
      GPP = ice_d2gdp2(T,P)
      ice_pressure_coefficient = (-1.D0/P) * GTP / GPP 
C
      RETURN
      END
C***********************************************************************************************
      DOUBLEPRECISION FUNCTION ice_disentropic_compressibilitydp(T,P)
C***********************************************************************************************
C
C     THIS FUNCTION CALCULATES THE 1ST P-DERIVATIVE OF THE ISENTROPIC COMPRESSIBILITY IN 1/Pa**2
C
      IMPLICIT REAL * 8 (A-I,O-Z)
C
      ice_disentropic_compressibilitydp = 0.D0
      GP   = ice_dgdp(T,P)
      GTP  = ice_d2gdtdp(T,P)
      GTT  = ice_d2gdt2(T,P)
      GPP  = ice_d2gdp2(T,P)
      GPPP = ice_d3gdp3(T,P)
      GTPP = ice_d3gdtdp2(T,P)
      GTTP = ice_d3gdt2dp(T,P)
C
      ice_disentropic_compressibilitydp = 1.D0/GP*(1.D0/GTT*(2.D0
     *             *GTP*GTPP-GTP**2*(GPP/GP+GTTP/GTT))-GPPP+GPP**2/GP)
C
      RETURN
      END