VERSION 5.00
Begin VB.Form Gibbs_Form 
   Caption         =   "Form1"
   ClientHeight    =   3936
   ClientLeft      =   48
   ClientTop       =   288
   ClientWidth     =   5772
   Icon            =   "Gibbs04.frx":0000
   LinkTopic       =   "Form1"
   ScaleHeight     =   3936
   ScaleWidth      =   5772
   StartUpPosition =   3  'Windows Default
End
Attribute VB_Name = "Gibbs_Form"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
DefLng I-N: DefDbl A-H, O-Z

Sub FW04demo(ByVal degC#, ByVal dBar#)

'###################################################################
'#                                                                 #
'#      A Comprehensive Gibbs Thermodynamic Potential of Ice       #
'#             Rainer Feistel & Wolfgang Wagner, 2004              #
'#                                                                 #
'#       presented at the 14th International Conference            #
'#            on the Properties of Water and Steam                 #
'#         August 29 - September 3, 2004, Kyoto, Japan             #
'#                                                                 #
'#             VB6 implementation by Rainer Feistel,               #
'#               rainer.feistel@io-warnemuende.de                  #
'#              (code version: 18 December 2004)                   #
'#                                                                 #
'#             submitted to Ocean Science, Dec. 2004, as:          #
'#    Numerical Implementation and Oceanographic Application       #
'#                  of the Gibbs Potential of Ice                  #
'#           by R.Feistel, W.Wagner, V.Tchijov, C.Guder            #
'#                                                                 #
'#       Further details will be published in the article:         #
'#                                                                 #
'#  High-pressure thermodynamic Gibbs functions of ice and sea ice #
'#               Rainer Feistel & Wolfgang Wagner                  #
'#         Journal of Marine Research, 2005, in press              #
'#                                                                 #
'###################################################################

Me.Show
Call InitG_FW04

T = degC + 273.15           'degC -> K
P = dBar * 10000# + 101325# 'dBar -> Pa

Debug.Print "T_degC =", degC; "C"
Debug.Print "T_abs =", T; "K"
Debug.Print "P_dBar =", dBar; "dBar"
Debug.Print "P_abs =", P; "Pa"
Debug.Print ""
Debug.Print "g            ", ice_g(T, P); "J/kg"
Debug.Print "dg/dT        ", ice_dgdt(T, P); "J/(kg K)"
Debug.Print "dg/dP        ", ice_dgdp(T, P); "m^3/kg"
Debug.Print "d2g/dT2      ", ice_d2gdt2(T, P); "J/(kg K^2)"
Debug.Print "d2g/dTdP     ", ice_d2gdtdp(T, P); "m^3/(kg K)"
Debug.Print "d2g/dP2      ", ice_d2gdp2(T, P); "m^3/(kg Pa)"
Debug.Print "d3g/dT3      ", ice_d3gdt3(T, P); "J/(kg K^3)"
Debug.Print "d3g/dT2dP    ", ice_d3gdt2dp(T, P); "m^3/(kg K^2)"
Debug.Print "d3g/dTdP2    ", ice_d3gdtdp2(T, P); "m^3/(kg K Pa)"
Debug.Print "d3g/dP3      ", ice_d3gdp3(T, P); "m^3/(kg Pa^2)"
Debug.Print "spec. volume ", ice_specific_volume(T, P); "m^3/kg"
Debug.Print "density      ", ice_density(T, P); "kg/m^3"
Debug.Print "enthalpy     ", ice_enthalpy(T, P); "J/kg"
Debug.Print "entropy      ", ice_entropy(T, P); "J/kg"
Debug.Print "free energy  ", ice_free_energy(T, P); "J/kg"
Debug.Print "int. energy  ", ice_internal_energy(T, P); "J/kg"
Debug.Print "heat capacity", ice_heat_capacity(T, P); "J/kgK"
Debug.Print "therm. exp.  ", ice_thermal_expansion(T, P); "1/K"
Debug.Print "isoth. compr.", ice_isothermal_compressibility(T, P); "1/Pa"
Debug.Print "adiab. compr.", ice_isentropic_compressibility(T, P); "1/Pa"
Debug.Print "press. coeff.", ice_pressure_coefficient(T, P); "1/K"
Debug.Print "d(isent. compr)/dP", ice_disentropic_compressibilitydp(T, P); "1/Pa^2"

'Printout:
'T_degC =      -10 C
'T_abs =        263.15 K
'P_dBar =       1000 dBar
'P_abs =        10101325 Pa
'
'g             -1606.4511744898 J/kg
'dg/dT          1299.04800566945 J/(kg K)
'dg/dP          1.08787119642917E-03 m^3/kg
'd2g/dT2       -7.67906117056837 J/(kg K^2)
'd2g/dTdP       1.66429674881775E-07 m^3/(kg K)
'd2g/dP2       -1.25548611251055E-13 m^3/(kg Pa)
'd3g/dT3        1.41439364919413E-03 J/(kg K^3)
'd3g/dT2dP      5.61033076359349E-10 m^3/(kg K^2)
'd3g/dTdP2     -2.15950418441553E-16 m^3/(kg K Pa)
'd3g/dP3        8.83364207555687E-23 m^3/(kg Pa^2)
'spec. volume   1.08787119642917E-03 m^3/kg
'density        919.226470268169 kg/m^3
'enthalpy      -343450.933866404 J/kg
'entropy       -1299.04800566945 J/kg
'free energy   -12595.3916877597 J/kg
'int. energy   -354439.874379674 J/kg
'heat capacity  2020.74494703507 J/kgK
'therm. exp.    1.52986562589453E-04 1/K
'isoth. compr.  1.15407606767377E-10 1/Pa
'adiab. compr.  1.12091901460767E-10 1/Pa
'press. coeff.  0.131232229564815 1/K
'd(isent. compr)/dP          -5.99025933097889E-20 1/Pa^2

End Sub


Private Sub Form_Load()

'call demo printout with

T_degC = -10#     'T_abs = 263.15 K
P_dBar = 1000#    'P_abs = 10 MPa + 101325 Pa

FW04demo T_degC, P_dBar

'Printout:

'T_degC =      -10 C
'T_abs =        263.15 K
'P_dBar =       1000 dBar
'P_abs =        10101325 Pa
'
'g             -1606.4511744898 J/kg
'dg/dT          1299.04800566945 J/(kg K)
'dg/dP          1.08787119642917E-03 m^3/kg
'd2g/dT2       -7.67906117056837 J/(kg K^2)
'd2g/dTdP       1.66429674881775E-07 m^3/(kg K)
'd2g/dP2       -1.25548611251055E-13 m^3/(kg Pa)
'd3g/dT3        1.41439364919413E-03 J/(kg K^3)
'd3g/dT2dP      5.61033076359349E-10 m^3/(kg K^2)
'd3g/dTdP2     -2.15950418441553E-16 m^3/(kg K Pa)
'd3g/dP3        8.83364207555687E-23 m^3/(kg Pa^2)
'spec. volume   1.08787119642917E-03 m^3/kg
'density        919.226470268169 kg/m^3
'enthalpy      -343450.933866404 J/kg
'entropy       -1299.04800566945 J/kg
'free energy   -12595.3916877597 J/kg
'int. energy   -354439.874379674 J/kg
'heat capacity  2020.74494703507 J/kgK
'therm. exp.    1.52986562589453E-04 1/K
'isoth. compr.  1.15407606767377E-10 1/Pa
'adiab. compr.  1.12091901460767E-10 1/Pa
'press. coeff.  0.131232229564815 1/K
'd(isent. compr)/dP          -5.99025933097889E-20 1/Pa^2


End Sub


