Attribute VB_Name = "Complex_Mdl"
Option Explicit

'========================================================
'Implementation of elementary complex arithmetics in VB6
' R.Feistel, 5.11.2003, last update 30.11.2004
'========================================================

Public Const PI = 3.14159265358979

'Define Complex Number Type
Public Type CplxType
  Re  As Double
  Im  As Double
End Type

Public Function Acs(ByVal x As Double) As Double
'Returns real function arccos(x)
Acs = 0.5 * PI - Asn(x)
End Function




Public Function Asn(ByVal x As Double) As Double
'Returns real function arcsin(x) between -PI/2 and +PI/2
Select Case Abs(x)

  'For invalid arguments > 1, accept a certain rounding tolerance
  Case Is > 1.00001: MsgBox "Error: ASN Argument =" + Str$(x): Asn = 0
  
  'compute regular values from intrinsic arctan
  Case Is < 1: Asn = Atn(x / Sqr(1# - x * x))

  'values -PI/2 and +PI/2
  Case Else: Asn = 0.5 * PI * Sgn(x)

End Select
End Function

Function Cplx_Ampl(a As CplxType) As Double
'returns Amplitude A = |a| of complex number a
Cplx_Ampl = Sqr(Cplx_Mult(a, Cplx_Conj(a)).Re)
End Function

Function Cplx_Arg(a As CplxType) As Double
'returns argument = phase angle arg(a) of complex number a,
'-PI < arg <= +PI
Select Case a.Re
  Case 0:      Cplx_Arg = Sgn(a.Im) * PI * 0.5
  Case Is > 0: Cplx_Arg = Atn(a.Im / a.Re)
  Case Else:   Cplx_Arg = Atn(a.Im / a.Re) + IIf(a.Im < 0, -PI, PI)
End Select
End Function
Function Cplx_Conj(a As CplxType) As CplxType
'returns complex conjugate Re(a) - i*Im(a) of complex number a
Cplx_Conj.Re = a.Re
Cplx_Conj.Im = -a.Im
End Function

Function Cplx_Inv(a As CplxType) As CplxType
'returns complex reciprocal 1/a
Cplx_Inv = Cplx_Div(Cplx_Num(1, 0), a)
End Function
Function Cplx_Div(a As CplxType, b As CplxType) As CplxType
'returns complex fraction a / b
Dim ab As CplxType, bb As Double
bb = Cplx_Mult(b, Cplx_Conj(b)).Re
ab = Cplx_Mult(a, Cplx_Conj(b))
Cplx_Div.Re = ab.Re / bb
Cplx_Div.Im = ab.Im / bb
End Function

Function Cplx_Log(a As CplxType) As CplxType
'returns complex logarithm ln(a), principal value -PI < Im(ln(a)) <= PI
Dim r#
r# = Cplx_Ampl(a)
If r > 0 Then
  Cplx_Log.Re = Log(r)
  Cplx_Log.Im = Cplx_Arg(a)
Else
  MsgBox "Invalid Argument of Log"
  Cplx_Log.Re = 0
  Cplx_Log.Im = 0
End If
End Function

Function Cplx_Exp(a As CplxType) As CplxType
'returns complex exponential exp(a)
Dim amp#
amp# = Exp(a.Re)
Cplx_Exp.Re = amp# * Cos(a.Im)
Cplx_Exp.Im = amp# * Sin(a.Im)
End Function
Function Cplx_Mult(a As CplxType, b As CplxType) As CplxType
'returns complex product a*b
Cplx_Mult.Re = a.Re * b.Re - a.Im * b.Im
Cplx_Mult.Im = a.Re * b.Im + a.Im * b.Re
End Function


Function Cplx_Num(ByVal x As Double, Optional ByVal y As Double = 0) As CplxType
'assigns real x (and optionally imaginary y) part to a complex number x + iy
Cplx_Num.Re = x
Cplx_Num.Im = y
End Function

Function Cplx_Factor(a As CplxType, ByVal b As Double) As CplxType
'returns product a*b of complex a with real b
Cplx_Factor.Re = a.Re * b
Cplx_Factor.Im = a.Im * b
End Function

Function Cplx_Power(a As CplxType, n As Integer) As CplxType
'returns complex integer power a^n by multiplication
Dim an As CplxType, i As Long, P As CplxType
If n = 0 Then
  Cplx_Power = Cplx_Num(1)
  Exit Function
End If

If n > 0 Then
  an = a
Else
  an = Cplx_Inv(a)
End If

P = an
For i = 1 To Abs(n) - 1
  P = Cplx_Mult(P, an)
Next i
Cplx_Power = P

End Function


Function Cplx_Sum(a As CplxType, b As CplxType) As CplxType
'returns the complex sum a + b
Cplx_Sum.Re = a.Re + b.Re
Cplx_Sum.Im = a.Im + b.Im
End Function

Function Cplx_Diff(a As CplxType, b As CplxType) As CplxType
'returns complex difference a - b
Cplx_Diff.Re = a.Re - b.Re
Cplx_Diff.Im = a.Im - b.Im
End Function


Function Cplx_Root(z As CplxType, ByVal i As Integer, ByVal n As Integer) As CplxType
'returns the i-th root of n complex n-th roots of z = (x+iy)
Cplx_Root = Cplx_Rootxy(z.Re, z.Im, i, n)
End Function


Function Cplx_Rootxy(ByVal x As Double, _
                     ByVal y As Double, _
                     ByVal i As Integer, _
                     ByVal n As Integer) As CplxType
'returns the i-th root of n complex n-th roots of z = (x+iy)

Dim r#, cph#, sph#, phi#

If n < 1 Then
  MsgBox "Invalid Root"
  Exit Function
End If

r# = Sqr(x ^ 2 + y ^ 2)
If r = 0 Then
  Cplx_Rootxy.Re = 0
  Cplx_Rootxy.Im = 0
  Exit Function
End If

cph# = x / r
sph# = y / r
phi# = Acs(cph)
If sph < 0 Then phi = -phi
r = r ^ (1 / n)
x = r * Cos((phi + i * 2 * PI) / n)
y = r * Sin((phi + i * 2 * PI) / n)
Cplx_Rootxy.Re = x
Cplx_Rootxy.Im = y
End Function


